/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.admin;

import akka.stream.Materializer;
import akka.stream.scaladsl.Source;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.v1.admin.party_management_service.AllocatePartyRequest;
import com.daml.ledger.api.v1.admin.party_management_service.AllocatePartyResponse;
import com.daml.ledger.api.v1.admin.party_management_service.GetParticipantIdRequest;
import com.daml.ledger.api.v1.admin.party_management_service.GetParticipantIdResponse;
import com.daml.ledger.api.v1.admin.party_management_service.GetPartiesRequest;
import com.daml.ledger.api.v1.admin.party_management_service.GetPartiesResponse;
import com.daml.ledger.api.v1.admin.party_management_service.ListKnownPartiesRequest;
import com.daml.ledger.api.v1.admin.party_management_service.ListKnownPartiesResponse;
import com.daml.ledger.api.v1.admin.party_management_service.PartyDetails;
import com.daml.ledger.api.v1.admin.party_management_service.PartyManagementServiceGrpc;
import com.daml.ledger.api.v1.admin.party_management_service.PartyManagementServiceGrpc$;
import com.daml.ledger.api.v1.admin.party_management_service.PartyManagementServiceGrpc$PartyManagementService$;
import com.daml.ledger.api.validation.ValidationErrors$;
import com.daml.ledger.participant.state.index.v2.IndexPartyManagementService;
import com.daml.ledger.participant.state.index.v2.IndexTransactionsService;
import com.daml.ledger.participant.state.index.v2.LedgerEndService;
import com.daml.ledger.participant.state.v2.SubmissionResult;
import com.daml.ledger.participant.state.v2.WritePartyService;
import com.daml.lf.data.Ref$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.services.admin.ApiPartyManagementService$;
import com.daml.platform.apiserver.services.admin.SynchronousResponse;
import com.daml.platform.apiserver.services.logging.package$;
import com.daml.platform.server.api.ValidationLogger$;
import com.daml.telemetry.DefaultTelemetry$;
import com.daml.telemetry.TelemetryContext;
import io.grpc.ServerServiceDefinition;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rud!\u0002\u001a4\u0005]z\u0004\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011q\u0004!\u0011!Q\u0001\nuD!\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011BA\u0002\u0011)\ti\u0001\u0001B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u0003?\u0001!\u0011!Q\u0001\n\u0005\u0005\u0002BCA(\u0001\t\u0005\t\u0015a\u0003\u0002R!Q\u0011\u0011\r\u0001\u0003\u0002\u0003\u0006Y!a\u0019\t\u0015\u0005-\u0004A!A!\u0002\u0017\ti\u0007C\u0004\u0002z\u0001!I!a\u001f\t\u0013\u0005M\u0005A1A\u0005\f\u0005U\u0005\u0002CAO\u0001\u0001\u0006I!a&\t\u0013\u0005}\u0005A1A\u0005\n\u0005\u0005\u0006\u0002CAm\u0001\u0001\u0006I!a)\t\u000f\u0005m\u0007\u0001\"\u0011\u0002^\"9\u0011Q\u001d\u0001\u0005B\u0005\u001d\bbBA|\u0001\u0011\u0005\u0013\u0011 \u0005\b\u0005'\u0001A\u0011\tB\u000b\u0011\u001d\u00119\u0003\u0001C!\u0005SAqAa\u000f\u0001\t\u0003\u0012i\u0004\u0003\u0005\u0003P\u0001\u0001K\u0011\u0002B)\u000f!\u0011\tg\rE\u0001o\t\rda\u0002\u001a4\u0011\u00039$Q\r\u0005\b\u0003s2B\u0011\u0001B4\u0011\u001d\u0011IG\u0006C\u0001\u0005WB\u0011Ba$\u0017#\u0003%\tA!%\b\u000f\t\u001df\u0003#\u0003\u0003*\u001a9!Q\u0016\f\t\n\t=\u0006bBA=7\u0011\u0005!\u0011\u0017\u0005\n\u0005g[\"\u0019!C\u0005\u0005kC\u0001B!0\u001cA\u0003%!q\u0017\u0005\n\u0005\u007f[\"\u0019!C\u0005\u0005kC\u0001B!1\u001cA\u0003%!q\u0017\u0005\n\u0005\u0007\\\"\u0019!C\u0005\u0005kC\u0001B!2\u001cA\u0003%!q\u0017\u0005\b\u0005\u000f\\B\u0011\u0001Be\r\u0019\u0011yM\u0006\u0004\u0003R\"Q!\u0011\u001d\u0013\u0003\u0002\u0003\u0006IAa9\t\u0015\u0005\u0005AE!A!\u0002\u0013\t\u0019\u0001\u0003\u0005pI\t\u0005\t\u0015!\u0003q\u0011)\t\t\u0007\nB\u0001B\u0003-\u00111\r\u0005\u000b\u0003W\"#\u0011!Q\u0001\f\u00055\u0004bBA=I\u0011\u0005!\u0011\u001e\u0005\n\u0003'##\u0019!C\u0005\u0003+C\u0001\"!(%A\u0003%\u0011q\u0013\u0005\b\u0005s$C\u0011\tB~\u0011\u001d\u0019y\u0001\nC!\u0007#Aqaa\u000e%\t\u0003\u001aI\u0004C\u0004\u0004d\u0011\"\te!\u001a\t\u000f\r=D\u0005\"\u0011\u0004r\tI\u0012\t]5QCJ$\u00180T1oC\u001e,W.\u001a8u'\u0016\u0014h/[2f\u0015\t!T'A\u0003bI6LgN\u0003\u00027o\u0005A1/\u001a:wS\u000e,7O\u0003\u00029s\u0005I\u0011\r]5tKJ4XM\u001d\u0006\u0003um\n\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u0003yu\nA\u0001Z1nY*\ta(A\u0002d_6\u001cB\u0001\u0001!GQB\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n1\u0011I\\=SK\u001a\u0004\"aR3\u000f\u0005!\u0013gBA%`\u001d\tQUL\u0004\u0002L5:\u0011Aj\u0016\b\u0003\u001bVs!A\u0014+\u000f\u0005=\u001bV\"\u0001)\u000b\u0005E\u0013\u0016A\u0002\u001fs_>$hh\u0001\u0001\n\u0003yJ!\u0001P\u001f\n\u0005Y[\u0014A\u00027fI\u001e,'/\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005Y[\u0014BA.]\u0003\t1\u0018G\u0003\u0002Y3&\u0011AG\u0018\u0006\u00037rK!\u0001Y1\u00021A\f'\u000f^=`[\u0006t\u0017mZ3nK:$xl]3sm&\u001cWM\u0003\u00025=&\u00111\rZ\u0001\u001b!\u0006\u0014H/_'b]\u0006<W-\\3oiN+'O^5dK\u001e\u0013\bo\u0019\u0006\u0003A\u0006L!AZ4\u0003-A\u000b'\u000f^=NC:\fw-Z7f]R\u001cVM\u001d<jG\u0016T!a\u00193\u0011\u0005%lW\"\u00016\u000b\u0005-d\u0017\u0001B4sa\u000eT!\u0001W\u001d\n\u00059T'AD$sa\u000e\f\u0005/[*feZL7-Z\u0001\u0017a\u0006\u0014H/_'b]\u0006<W-\\3oiN+'O^5dKB\u0011\u0011O_\u0007\u0002e*\u00111\u000f^\u0001\u0003mJR!!\u001e<\u0002\u000b%tG-\u001a=\u000b\u0005]D\u0018!B:uCR,'BA=Z\u0003-\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;\n\u0005m\u0014(aG%oI\u0016D\b+\u0019:us6\u000bg.Y4f[\u0016tGoU3sm&\u001cW-\u0001\nue\u0006t7/Y2uS>t7+\u001a:wS\u000e,\u0007CA9\u007f\u0013\ty(O\u0001\rJ]\u0012,\u0007\u0010\u0016:b]N\f7\r^5p]N\u001cVM\u001d<jG\u0016\fAb\u001e:ji\u0016\u001cVM\u001d<jG\u0016\u0004B!!\u0002\u0002\n5\u0011\u0011q\u0001\u0006\u0003gZLA!a\u0003\u0002\b\t\trK]5uKB\u000b'\u000f^=TKJ4\u0018nY3\u000215\fg.Y4f[\u0016tGoU3sm&\u001cW\rV5nK>,H\u000f\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0011\u0011,(/\u0019;j_:T1!!\u0007C\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003;\t\u0019B\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002+M,(-\\5tg&|g.\u00133HK:,'/\u0019;peB9\u0011)a\t\u0002(\u0005]\u0012bAA\u0013\u0005\nIa)\u001e8di&|g.\r\t\u0005\u0003S\t\tD\u0004\u0003\u0002,\u00055\u0002CA(C\u0013\r\tyCQ\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0012Q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=\"\t\u0005\u0003\u0002:\u0005%c\u0002BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0005I\u0006$\u0018MC\u0002\u0002Dm\n!\u0001\u001c4\n\t\u0005\u001d\u0013QH\u0001\u0004%\u00164\u0017\u0002BA&\u0003\u001b\u0012AbU;c[&\u001c8/[8o\u0013\u0012TA!a\u0012\u0002>\u0005aQ.\u0019;fe&\fG.\u001b>feB!\u00111KA/\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013AB:ue\u0016\fWN\u0003\u0002\u0002\\\u0005!\u0011m[6b\u0013\u0011\ty&!\u0016\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\b\u0003BA3\u0003Oj!!a\u0006\n\t\u0005%\u0014q\u0003\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0002\\8hO&twmQ8oi\u0016DH\u000f\u0005\u0003\u0002p\u0005UTBAA9\u0015\r\t\u0019hO\u0001\bY><w-\u001b8h\u0013\u0011\t9(!\u001d\u0003\u001d1{wmZ5oO\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"B\"! \u0002\n\u0006-\u0015QRAH\u0003##\u0002\"a \u0002\u0004\u0006\u0015\u0015q\u0011\t\u0004\u0003\u0003\u0003Q\"A\u001a\t\u000f\u0005=\u0013\u0002q\u0001\u0002R!9\u0011\u0011M\u0005A\u0004\u0005\r\u0004bBA6\u0013\u0001\u000f\u0011Q\u000e\u0005\u0006_&\u0001\r\u0001\u001d\u0005\u0006y&\u0001\r! \u0005\b\u0003\u0003I\u0001\u0019AA\u0002\u0011\u001d\ti!\u0003a\u0001\u0003\u001fAq!a\b\n\u0001\u0004\t\t#\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003/\u0003B!a\u001c\u0002\u001a&!\u00111TA9\u0005Q\u0019uN\u001c;fqR,\u0018\r\\5{K\u0012dunZ4fe\u00069An\\4hKJ\u0004\u0013aE:z]\u000eD'o\u001c8pkN\u0014Vm\u001d9p]N,WCAAR!)\t\t)!*\u0002*\u0006u\u00161Z\u0005\u0004\u0003O\u001b$aE*z]\u000eD'o\u001c8pkN\u0014Vm\u001d9p]N,\u0007cB!\u0002,\u0006=\u00161X\u0005\u0004\u0003[\u0013%A\u0002+va2,'\u0007E\u0003B\u0003c\u000b),C\u0002\u00024\n\u0013aa\u00149uS>t\u0007\u0003BA\u001d\u0003oKA!!/\u0002N\t)\u0001+\u0019:usB)\u0011)!-\u0002(A!\u0011qXAc\u001d\rY\u0015\u0011Y\u0005\u0004\u0003\u0007d\u0016A\u00023p[\u0006Lg.\u0003\u0003\u0002H\u0006%'A\u0003)beRLXI\u001c;ss*\u0019\u00111\u0019/\u0011\t\u00055\u00171\u001b\b\u0005\u0003\u007f\u000by-\u0003\u0003\u0002R\u0006%\u0017A\u0003)beRLXI\u001c;ss&!\u0011Q[Al\u0005I\tE\u000e\\8dCRLwN\\!dG\u0016\u0004H/\u001a3\u000b\t\u0005E\u0017\u0011Z\u0001\u0015gft7\r\u001b:p]>,8OU3ta>t7/\u001a\u0011\u0002\u000b\rdwn]3\u0015\u0005\u0005}\u0007cA!\u0002b&\u0019\u00111\u001d\"\u0003\tUs\u0017\u000e^\u0001\fE&tGmU3sm&\u001cW\r\u0006\u0002\u0002jB!\u00111^Az\u001b\t\tiOC\u0002l\u0003_T!!!=\u0002\u0005%|\u0017\u0002BA{\u0003[\u0014qcU3sm\u0016\u00148+\u001a:wS\u000e,G)\u001a4j]&$\u0018n\u001c8\u0002!\u001d,G\u000fU1si&\u001c\u0017\u000e]1oi&#G\u0003BA~\u0005\u0013\u0001b!!\u001a\u0002~\n\u0005\u0011\u0002BA\u0000\u0003/\u0011aAR;ukJ,\u0007\u0003\u0002B\u0002\u0005\u000bi\u0011\u0001Z\u0005\u0004\u0005\u000f!'\u0001G$fiB\u000b'\u000f^5dSB\fg\u000e^%e%\u0016\u001c\bo\u001c8tK\"9!1\u0002\tA\u0002\t5\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u0005\u0007\u0011y!C\u0002\u0003\u0012\u0011\u0014qcR3u!\u0006\u0014H/[2ja\u0006tG/\u00133SKF,Xm\u001d;\u0002\u0015\u001d,G\u000fU1si&,7\u000f\u0006\u0003\u0003\u0018\t}\u0001CBA3\u0003{\u0014I\u0002\u0005\u0003\u0003\u0004\tm\u0011b\u0001B\u000fI\n\u0011r)\u001a;QCJ$\u0018.Z:SKN\u0004xN\\:f\u0011\u001d\u0011Y!\u0005a\u0001\u0005C\u0001BAa\u0001\u0003$%\u0019!Q\u00053\u0003#\u001d+G\u000fU1si&,7OU3rk\u0016\u001cH/\u0001\tmSN$8J\\8x]B\u000b'\u000f^5fgR!!1\u0006B\u001a!\u0019\t)'!@\u0003.A!!1\u0001B\u0018\u0013\r\u0011\t\u0004\u001a\u0002\u0019\u0019&\u001cHo\u00138po:\u0004\u0016M\u001d;jKN\u0014Vm\u001d9p]N,\u0007b\u0002B\u0006%\u0001\u0007!Q\u0007\t\u0005\u0005\u0007\u00119$C\u0002\u0003:\u0011\u0014q\u0003T5ti.swn\u001e8QCJ$\u0018.Z:SKF,Xm\u001d;\u0002\u001b\u0005dGn\\2bi\u0016\u0004\u0016M\u001d;z)\u0011\u0011yDa\u0012\u0011\r\u0005\u0015\u0014Q B!!\u0011\u0011\u0019Aa\u0011\n\u0007\t\u0015CMA\u000bBY2|7-\u0019;f!\u0006\u0014H/\u001f*fgB|gn]3\t\u000f\t-1\u00031\u0001\u0003JA!!1\u0001B&\u0013\r\u0011i\u0005\u001a\u0002\u0015\u00032dwnY1uKB\u000b'\u000f^=SKF,Xm\u001d;\u0002\u001f5\f\u0007\u000fU1sif$U\r^1jYN$BAa\u0015\u0003ZA!!1\u0001B+\u0013\r\u00119\u0006\u001a\u0002\r!\u0006\u0014H/\u001f#fi\u0006LGn\u001d\u0005\b\u00057\"\u0002\u0019\u0001B/\u0003\u001d!W\r^1jYN\u0004B!a0\u0003`%!!qKAe\u0003e\t\u0005/\u001b)beRLX*\u00198bO\u0016lWM\u001c;TKJ4\u0018nY3\u0011\u0007\u0005\u0005ec\u0005\u0002\u0017\u0001R\u0011!1M\u0001\u0011GJ,\u0017\r^3Ba&\u001cVM\u001d<jG\u0016$BB!\u001c\u0003\u0000\t\r%q\u0011BF\u0005\u001b#\u0002Ba\u001c\u0003z\tm$Q\u0010\n\u0006\u0005c\u0012)\b\u001b\u0004\u0007\u0005g2\u0002Aa\u001c\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007\t]TMD\u0002\u0003\u0004\tDq!a\u0014\u0019\u0001\b\t\t\u0006C\u0004\u0002ba\u0001\u001d!a\u0019\t\u000f\u0005-\u0004\u0004q\u0001\u0002n!1!\u0011\u0011\rA\u0002A\fQ\u0004]1sifl\u0015M\\1hK6,g\u000e^*feZL7-\u001a\"bG.,g\u000e\u001a\u0005\u0007\u0005\u000bC\u0002\u0019A?\u0002'Q\u0014\u0018M\\:bGRLwN\\:TKJ4\u0018nY3\t\u000f\t%\u0005\u00041\u0001\u0002\u0004\u0005aqO]5uK\n\u000b7m[3oI\"9\u0011Q\u0002\rA\u0002\u0005=\u0001\"CA\u00101A\u0005\t\u0019AA\u0011\u0003i\u0019'/Z1uK\u0006\u0003\u0018nU3sm&\u001cW\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011\u0019J\u000b\u0003\u0002\"\tU5F\u0001BL!\u0011\u0011IJa)\u000e\u0005\tm%\u0002\u0002BO\u0005?\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005&)\u0001\u0006b]:|G/\u0019;j_:LAA!*\u0003\u001c\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\r\u0013X-\u0019;f'V\u0014W.[:tS>t\u0017\n\u001a\t\u0004\u0005W[R\"\u0001\f\u0003%\r\u0013X-\u0019;f'V\u0014W.[:tS>t\u0017\nZ\n\u00037\u0001#\"A!+\u0002\u0019M+hMZ5y\u0019\u0016tw\r\u001e5\u0016\u0005\t]\u0006cA!\u0003:&\u0019!1\u0018\"\u0003\u0007%sG/A\u0007Tk\u001a4\u0017\u000e\u001f'f]\u001e$\b\u000eI\u0001\n\u001b\u0006DH*\u001a8hi\"\f!\"T1y\u0019\u0016tw\r\u001e5!\u0003=\u0001&/\u001a4jq6\u000b\u0007\u0010T3oORD\u0017\u0001\u0005)sK\u001aL\u00070T1y\u0019\u0016tw\r\u001e5!\u0003)9\u0018\u000e\u001e5Qe\u00164\u0017\u000e\u001f\u000b\u0005\u0003o\u0011Y\rC\u0004\u0003N\u000e\u0002\r!a\n\u0002\u0013A\f'\u000f^=IS:$(aG*z]\u000eD'o\u001c8pkN\u0014Vm\u001d9p]N,7\u000b\u001e:bi\u0016<\u0017p\u0005\u0003%\u0001\nM\u0007C\u0003Bk\u00057\fI+!0\u0002L:!\u0011\u0011\u0011Bl\u0013\r\u0011InM\u0001\u0014'ft7\r\u001b:p]>,8OU3ta>t7/Z\u0005\u0005\u0005;\u0014yN\u0001\u0005TiJ\fG/Z4z\u0015\r\u0011InM\u0001\u0011Y\u0016$w-\u001a:F]\u0012\u001cVM\u001d<jG\u0016\u00042!\u001dBs\u0013\r\u00119O\u001d\u0002\u0011\u0019\u0016$w-\u001a:F]\u0012\u001cVM\u001d<jG\u0016$\u0002Ba;\u0003t\nU(q\u001f\u000b\u0007\u0005[\u0014yO!=\u0011\u0007\t-F\u0005C\u0004\u0002b)\u0002\u001d!a\u0019\t\u000f\u0005-$\u0006q\u0001\u0002n!9!\u0011\u001d\u0016A\u0002\t\r\bbBA\u0001U\u0001\u0007\u00111\u0001\u0005\u0006_*\u0002\r\u0001]\u0001\u0011GV\u0014(/\u001a8u\u0019\u0016$w-\u001a:F]\u0012$\"A!@\u0011\r\u0005\u0015\u0014Q B\u0000!\u0015\t\u0015\u0011WB\u0001!\u0011\u0019\u0019a!\u0003\u000f\t\u0005}6QA\u0005\u0005\u0007\u000f\tI-\u0001\u0007MK\u0012<WM](gMN,G/\u0003\u0003\u0004\f\r5!\u0001C!cg>dW\u000f^3\u000b\t\r\u001d\u0011\u0011Z\u0001\u0007gV\u0014W.\u001b;\u0015\r\rM1qFB\u001a)\u0019\u0019)b!\b\u0004.A1\u0011QMA\u007f\u0007/\u0001B!!\u0002\u0004\u001a%!11DA\u0004\u0005A\u0019VOY7jgNLwN\u001c*fgVdG\u000fC\u0004\u0004 9\u0002\u001da!\t\u0002!Q,G.Z7fiJL8i\u001c8uKb$\b\u0003BB\u0012\u0007Si!a!\n\u000b\u0007\r\u001d2(A\u0005uK2,W.\u001a;ss&!11FB\u0013\u0005A!V\r\\3nKR\u0014\u0018pQ8oi\u0016DH\u000fC\u0004\u0002l9\u0002\u001d!!\u001c\t\u000f\rEb\u00061\u0001\u00028\u0005a1/\u001e2nSN\u001c\u0018n\u001c8JI\"91Q\u0007\u0018A\u0002\u0005%\u0016!B5oaV$\u0018aB3oiJLWm\u001d\u000b\u0005\u0007w\u0019y\u0006\r\u0003\u0004>\r5\u0003\u0003CB \u0007\u000b\nil!\u0013\u000e\u0005\r\u0005#\u0002BB\"\u0003+\n\u0001b]2bY\u0006$7\u000f\\\u0005\u0005\u0007\u000f\u001a\tE\u0001\u0004T_V\u00148-\u001a\t\u0005\u0007\u0017\u001ai\u0005\u0004\u0001\u0005\u0017\r=s&!A\u0001\u0002\u000b\u00051\u0011\u000b\u0002\u0004?\u0012\n\u0014\u0003BB*\u00073\u00022!QB+\u0013\r\u00199F\u0011\u0002\b\u001d>$\b.\u001b8h!\r\t51L\u0005\u0004\u0007;\u0012%aA!os\"91\u0011M\u0018A\u0002\t}\u0018AB8gMN,G/\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0007O\u001ai\u0007E\u0004B\u0007S\ni,a3\n\u0007\r-$IA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o\u0011\u001d\u0019\t\u0004\ra\u0001\u0003o\taA]3kK\u000e$H\u0003BB:\u0007w\u0002r!QB5\u0003{\u001b)\b\u0005\u0003\u0002l\u000e]\u0014\u0002BB=\u0003[\u0014ac\u0015;biV\u001c(+\u001e8uS6,W\t_2faRLwN\u001c\u0005\b\u0007c\t\u0004\u0019AA\u001c\u0001")
public final class ApiPartyManagementService
implements PartyManagementServiceGrpc.PartyManagementService,
GrpcApiService {
    private final IndexPartyManagementService partyManagementService;
    private final Function1<String, String> submissionIdGenerator;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final SynchronousResponse<Tuple2<Option<String>, Option<String>>, domain.PartyEntry, domain.PartyEntry.AllocationAccepted> synchronousResponse;

    public static Function1<String, String> createApiService$default$5() {
        return ApiPartyManagementService$.MODULE$.createApiService$default$5();
    }

    public static PartyManagementServiceGrpc.PartyManagementService createApiService(IndexPartyManagementService partyManagementServiceBackend, IndexTransactionsService transactionsService, WritePartyService writeBackend, FiniteDuration managementServiceTimeout, Function1<String, String> submissionIdGenerator, Materializer materializer, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ApiPartyManagementService$.MODULE$.createApiService(partyManagementServiceBackend, transactionsService, writeBackend, managementServiceTimeout, submissionIdGenerator, materializer, executionContext, loggingContext);
    }

    public PartyManagementServiceGrpc$PartyManagementService$ serviceCompanion() {
        return PartyManagementServiceGrpc.PartyManagementService.serviceCompanion$((PartyManagementServiceGrpc.PartyManagementService)this);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private SynchronousResponse<Tuple2<Option<String>, Option<String>>, domain.PartyEntry, domain.PartyEntry.AllocationAccepted> synchronousResponse() {
        return this.synchronousResponse;
    }

    public void close() {
    }

    public ServerServiceDefinition bindService() {
        return PartyManagementServiceGrpc$.MODULE$.bindService((PartyManagementServiceGrpc.PartyManagementService)this, this.executionContext);
    }

    public Future<GetParticipantIdResponse> getParticipantId(GetParticipantIdRequest request) {
        this.logger().info().apply((Function0 & Serializable)() -> "Getting Participant ID", this.loggingContext);
        return this.partyManagementService.getParticipantId(this.loggingContext).map((Function1 & Serializable)pid -> new GetParticipantIdResponse(pid.toString()), this.executionContext).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    public Future<GetPartiesResponse> getParties(GetPartiesRequest request) {
        return (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.partyStrings((Iterable<String>)request.parties()), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Getting parties", loggingContext);
            return $this.partyManagementService.getParties((Seq)request.parties().map((Function1 & Serializable)s -> (String)Ref$.MODULE$.Party().assertFromString(s)), loggingContext).map((Function1 & Serializable)ps -> new GetPartiesResponse((Seq)ps.map((Function1 & Serializable)details -> this.mapPartyDetails((domain.PartyDetails)details))), $this.executionContext).andThen(this.logger().logErrorsOnCall(loggingContext), $this.executionContext);
        }, this.loggingContext);
    }

    public Future<ListKnownPartiesResponse> listKnownParties(ListKnownPartiesRequest request) {
        this.logger().info().apply((Function0 & Serializable)() -> "Listing known parties", this.loggingContext);
        return this.partyManagementService.listKnownParties(this.loggingContext).map((Function1 & Serializable)ps -> new ListKnownPartiesResponse((Seq)ps.map((Function1 & Serializable)details -> this.mapPartyDetails((domain.PartyDetails)details))), this.executionContext).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    public Future<AllocatePartyResponse> allocateParty(AllocatePartyRequest request) {
        String submissionId = (String)this.submissionIdGenerator.apply((Object)request.partyIdHint());
        return (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.partyString(request.partyIdHint()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.submissionId(submissionId)}), (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Allocating party", loggingContext);
            TelemetryContext telemetryContext = DefaultTelemetry$.MODULE$.contextFromGrpcThreadLocalContext();
            DamlContextualizedErrorLogger contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
            Future validatedPartyIdHint = request.partyIdHint().isEmpty() ? Future$.MODULE$.successful((Object)None$.MODULE$) : (Future)Ref$.MODULE$.Party().fromString(request.partyIdHint()).fold(arg_0 -> ApiPartyManagementService.$anonfun$allocateParty$3(this, request, (ContextualizedErrorLogger)contextualizedErrorLogger, loggingContext, arg_0), (Function1 & Serializable)party -> Future$.MODULE$.successful((Object)new Some(party)));
            Future submit = validatedPartyIdHint.map((Function1 & Serializable)partyIdHint -> {
                Option displayName = new Some((Object)request.displayName()).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()));
                Tuple2 input = new Tuple2(partyIdHint, (Object)displayName);
                return new Tuple3(partyIdHint, (Object)displayName, (Object)input);
            }, $this.executionContext).flatMap((Function1 & Serializable)x$3 -> {
                Tuple3 tuple3 = x$3;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Tuple2 input = (Tuple2)tuple3._3();
                Future future = this.synchronousResponse().submitAndWait(submissionId, (Tuple2<Option<String>, Option<String>>)input, telemetryContext, (LoggingContext)loggingContext).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ApiPartyManagementService.$anonfun$allocateParty$8(check$ifrefutable$1)), $this.executionContext).map((Function1 & Serializable)x$2 -> {
                    domain.PartyEntry.AllocationAccepted allocationAccepted = x$2;
                    if (allocationAccepted == null) {
                        throw new MatchError((Object)allocationAccepted);
                    }
                    domain.PartyDetails partyDetails = allocationAccepted.partyDetails();
                    PartyDetails details = new PartyDetails(partyDetails.party(), (String)partyDetails.displayName().getOrElse((Function0 & Serializable)() -> ""), partyDetails.isLocal());
                    AllocatePartyResponse allocatePartyResponse = new AllocatePartyResponse((Option)new Some((Object)details));
                    return allocatePartyResponse;
                }, $this.executionContext);
                return future;
            }, $this.executionContext);
            return submit.andThen(this.logger().logErrorsOnCall(loggingContext), $this.executionContext);
        }, this.loggingContext);
    }

    private PartyDetails mapPartyDetails(domain.PartyDetails details) {
        return new PartyDetails(details.party(), (String)details.displayName().getOrElse((Function0 & Serializable)() -> ""), details.isLocal());
    }

    public static final /* synthetic */ Future $anonfun$allocateParty$3(ApiPartyManagementService $this, AllocatePartyRequest request$2, ContextualizedErrorLogger contextualizedErrorLogger$1, LoggingContext loggingContext$1, String error) {
        return Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure((Object)request$2, (Throwable)ValidationErrors$.MODULE$.invalidArgument(error, contextualizedErrorLogger$1), $this.logger(), loggingContext$1));
    }

    public static final /* synthetic */ boolean $anonfun$allocateParty$8(domain.PartyEntry.AllocationAccepted check$ifrefutable$1) {
        domain.PartyEntry.AllocationAccepted allocationAccepted = check$ifrefutable$1;
        boolean bl = allocationAccepted != null;
        return bl;
    }

    public ApiPartyManagementService(IndexPartyManagementService partyManagementService, IndexTransactionsService transactionService, WritePartyService writeService, FiniteDuration managementServiceTimeout, Function1<String, String> submissionIdGenerator, Materializer materializer, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.partyManagementService = partyManagementService;
        this.submissionIdGenerator = submissionIdGenerator;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        PartyManagementServiceGrpc.PartyManagementService.$init$((PartyManagementServiceGrpc.PartyManagementService)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.synchronousResponse = new SynchronousResponse<Tuple2<Option<String>, Option<String>>, domain.PartyEntry, domain.PartyEntry.AllocationAccepted>(new SynchronousResponseStrategy((LedgerEndService)transactionService, writeService, partyManagementService, executionContext, loggingContext), managementServiceTimeout, executionContext, materializer);
    }

    private static final class SynchronousResponseStrategy
    implements SynchronousResponse.Strategy<Tuple2<Option<String>, Option<String>>, domain.PartyEntry, domain.PartyEntry.AllocationAccepted> {
        private final LedgerEndService ledgerEndService;
        private final WritePartyService writeService;
        private final IndexPartyManagementService partyManagementService;
        private final ExecutionContext executionContext;
        public final LoggingContext com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$loggingContext;
        private final ContextualizedLogger com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$logger;

        public ContextualizedLogger com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$logger() {
            return this.com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$logger;
        }

        @Override
        public Future<Option<domain.LedgerOffset.Absolute>> currentLedgerEnd() {
            return this.ledgerEndService.currentLedgerEnd(this.com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$loggingContext).map((Function1 & Serializable)x$4 -> new Some(x$4), this.executionContext);
        }

        @Override
        public Future<SubmissionResult> submit(String submissionId, Tuple2<Option<String>, Option<String>> input, TelemetryContext telemetryContext, LoggingContext loggingContext) {
            Tuple2<Option<String>, Option<String>> tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option party = (Option)tuple2._1();
            Option displayName = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)party, (Object)displayName);
            Tuple2 tuple23 = tuple22;
            Option party2 = (Option)tuple23._1();
            Option displayName2 = (Option)tuple23._2();
            return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps(this.writeService.allocateParty(party2, displayName2, submissionId, loggingContext, telemetryContext)));
        }

        @Override
        public Source<domain.PartyEntry, ?> entries(Option<domain.LedgerOffset.Absolute> offset) {
            return this.partyManagementService.partyEntries(offset, this.com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$loggingContext);
        }

        @Override
        public PartialFunction<domain.PartyEntry, domain.PartyEntry.AllocationAccepted> accept(String submissionId) {
            return new Serializable(null, submissionId){
                private static final long serialVersionUID = 0L;
                private final String submissionId$2;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends domain.PartyEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    domain.PartyEntry.AllocationAccepted allocationAccepted;
                    Option option;
                    A1 A1 = x1;
                    if (A1 instanceof domain.PartyEntry.AllocationAccepted && (option = (allocationAccepted = (domain.PartyEntry.AllocationAccepted)A1).submissionId()) instanceof Some) {
                        Some some = (Some)option;
                        String string = (String)some.value();
                        String string2 = this.submissionId$2;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            object = allocationAccepted;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(domain.PartyEntry x1) {
                    domain.PartyEntry partyEntry = x1;
                    if (!(partyEntry instanceof domain.PartyEntry.AllocationAccepted)) return false;
                    domain.PartyEntry.AllocationAccepted allocationAccepted = (domain.PartyEntry.AllocationAccepted)partyEntry;
                    Option option = allocationAccepted.submissionId();
                    if (!(option instanceof Some)) return false;
                    Some some = (Some)option;
                    String string = (String)some.value();
                    String string2 = this.submissionId$2;
                    String string3 = string;
                    if (string2 != null) {
                        if (!string2.equals(string3)) return false;
                        return true;
                    }
                    if (string3 == null) return true;
                    return false;
                }
                {
                    this.submissionId$2 = submissionId$2;
                }
            };
        }

        @Override
        public PartialFunction<domain.PartyEntry, StatusRuntimeException> reject(String submissionId) {
            return new Serializable(this, submissionId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ SynchronousResponseStrategy $outer;
                private final String submissionId$3;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends domain.PartyEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var3_10;
                    A1 A1 = x1;
                    if (A1 instanceof domain.PartyEntry$.AllocationRejected) {
                        domain.PartyEntry$.AllocationRejected allocationRejected = (domain.PartyEntry$.AllocationRejected)A1;
                        String string = allocationRejected.submissionId();
                        String reason = allocationRejected.reason();
                        String string2 = this.submissionId$3;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            StatusRuntimeException statusRuntimeException = ValidationErrors$.MODULE$.invalidArgument(reason, (ContextualizedErrorLogger)new DamlContextualizedErrorLogger(this.$outer.com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$logger(), this.$outer.com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$loggingContext, (Option)new Some((Object)this.submissionId$3)));
                            return var3_10;
                        }
                    }
                    Object object = function1.apply(x1);
                    return var3_10;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(domain.PartyEntry x1) {
                    domain.PartyEntry partyEntry = x1;
                    if (!(partyEntry instanceof domain.PartyEntry$.AllocationRejected)) return false;
                    domain.PartyEntry$.AllocationRejected allocationRejected = (domain.PartyEntry$.AllocationRejected)partyEntry;
                    String string = allocationRejected.submissionId();
                    String string2 = this.submissionId$3;
                    String string3 = string;
                    if (string2 != null) {
                        if (!string2.equals(string3)) return false;
                        return true;
                    }
                    if (string3 == null) return true;
                    return false;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.submissionId$3 = submissionId$3;
                }
            };
        }

        public SynchronousResponseStrategy(LedgerEndService ledgerEndService, WritePartyService writeService, IndexPartyManagementService partyManagementService, ExecutionContext executionContext, LoggingContext loggingContext) {
            this.ledgerEndService = ledgerEndService;
            this.writeService = writeService;
            this.partyManagementService = partyManagementService;
            this.executionContext = executionContext;
            this.com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$loggingContext = loggingContext;
            this.com$daml$platform$apiserver$services$admin$ApiPartyManagementService$SynchronousResponseStrategy$$logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        }
    }
}

