/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.admin;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.v1.admin.user_management_service.Right;
import com.daml.ledger.api.v1.admin.user_management_service.User;
import com.daml.lf.data.Ref$;
import com.daml.platform.apiserver.page_tokens.ListUsersPageTokenPayload;
import com.daml.platform.apiserver.page_tokens.ListUsersPageTokenPayload$;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.package$;
import scala.util.Either;
import scala.util.Right;
import scala.util.Try$;

public final class ApiUserManagementService$ {
    public static final ApiUserManagementService$ MODULE$ = new ApiUserManagementService$();
    private static final Function1<domain.UserRight, com.daml.ledger.api.v1.admin.user_management_service.Right> com$daml$platform$apiserver$services$admin$ApiUserManagementService$$toProtoRight = (Function1 & Serializable)x0$1 -> {
        com.daml.ledger.api.v1.admin.user_management_service.Right right;
        domain.UserRight userRight = x0$1;
        if (domain.UserRight$.ParticipantAdmin$.MODULE$.equals(userRight)) {
            right = new com.daml.ledger.api.v1.admin.user_management_service.Right((Right.Kind)new Right.Kind$.ParticipantAdmin(new Right.ParticipantAdmin()));
        } else if (userRight instanceof domain.UserRight.CanActAs) {
            domain.UserRight.CanActAs canActAs = (domain.UserRight.CanActAs)userRight;
            String party = canActAs.party();
            right = new com.daml.ledger.api.v1.admin.user_management_service.Right((Right.Kind)new Right.Kind$.CanActAs(new Right.CanActAs(party)));
        } else if (userRight instanceof domain.UserRight.CanReadAs) {
            domain.UserRight.CanReadAs canReadAs = (domain.UserRight.CanReadAs)userRight;
            String party = canReadAs.party();
            right = new com.daml.ledger.api.v1.admin.user_management_service.Right((Right.Kind)new Right.Kind$.CanReadAs(new Right.CanReadAs(party)));
        } else {
            throw new MatchError((Object)userRight);
        }
        return right;
    };

    public User com$daml$platform$apiserver$services$admin$ApiUserManagementService$$toProtoUser(domain.User user) {
        return new User(user.id().toString(), (String)user.primaryParty().getOrElse((Function0 & Serializable)() -> ""));
    }

    public Function1<domain.UserRight, com.daml.ledger.api.v1.admin.user_management_service.Right> com$daml$platform$apiserver$services$admin$ApiUserManagementService$$toProtoRight() {
        return com$daml$platform$apiserver$services$admin$ApiUserManagementService$$toProtoRight;
    }

    public String encodeNextPageToken(Option<String> token) {
        return (String)token.map((Function1 & Serializable)id -> {
            byte[] bytes = Base64.getUrlEncoder().encode(new ListUsersPageTokenPayload(id, ListUsersPageTokenPayload$.MODULE$.apply$default$2()).toByteArray());
            return new String(bytes, StandardCharsets.UTF_8);
        }).getOrElse((Function0 & Serializable)() -> "");
    }

    public Either<StatusRuntimeException, Option<String>> decodeUserIdFromPageToken(String pageToken, ContextualizedErrorLogger loggingContext) {
        Right right;
        if (pageToken.isEmpty()) {
            right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
        } else {
            byte[] bytes = pageToken.getBytes(StandardCharsets.UTF_8);
            right = ((Either)Try$.MODULE$.apply((Function0 & Serializable)() -> Base64.getUrlDecoder().decode(bytes)).map((Function1 & Serializable)x$13 -> package$.MODULE$.Right().apply(x$13)).recover((PartialFunction)new Serializable(loggingContext){
                private static final long serialVersionUID = 0L;
                private final ContextualizedErrorLogger loggingContext$5;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof IllegalArgumentException ? package$.MODULE$.Left().apply((Object)((Object)ApiUserManagementService$.MODULE$.com$daml$platform$apiserver$services$admin$ApiUserManagementService$$invalidPageToken(this.loggingContext$5))) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof IllegalArgumentException;
                    return bl;
                }
                {
                    this.loggingContext$5 = loggingContext$5;
                }
            }).get()).flatMap((Function1 & Serializable)decodedBytes -> ((Either)Try$.MODULE$.apply((Function0 & Serializable)() -> (ListUsersPageTokenPayload)ListUsersPageTokenPayload$.MODULE$.parseFrom(decodedBytes)).map((Function1 & Serializable)x$14 -> package$.MODULE$.Right().apply(x$14)).recover((PartialFunction)new Serializable(loggingContext){
                private static final long serialVersionUID = 0L;
                private final ContextualizedErrorLogger loggingContext$5;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = A1 instanceof InvalidProtocolBufferException ? package$.MODULE$.Left().apply((Object)((Object)ApiUserManagementService$.MODULE$.com$daml$platform$apiserver$services$admin$ApiUserManagementService$$invalidPageToken(this.loggingContext$5))) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = throwable instanceof InvalidProtocolBufferException;
                    return bl;
                }
                {
                    this.loggingContext$5 = loggingContext$5;
                }
            }).get()).flatMap((Function1 & Serializable)tokenPayload -> Ref$.MODULE$.UserId().fromString(tokenPayload.userIdLowerBoundExcl()).map((Function1 & Serializable)x$15 -> new Some(x$15)).left().map((Function1 & Serializable)x$16 -> MODULE$.com$daml$platform$apiserver$services$admin$ApiUserManagementService$$invalidPageToken(loggingContext)).map((Function1 & Serializable)userId -> userId)));
        }
        return right;
    }

    public StatusRuntimeException com$daml$platform$apiserver$services$admin$ApiUserManagementService$$invalidPageToken(ContextualizedErrorLogger errorLogger) {
        return new RequestValidation.InvalidArgument$.Reject("Invalid page token", errorLogger).asGrpcError();
    }

    private ApiUserManagementService$() {
    }
}

