/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.admin;

import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.LedgerApiErrors;
import com.daml.ledger.api.domain;
import com.daml.ledger.participant.state.v2.SubmissionResult;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.telemetry.TelemetryContext;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\t5e\u0001\u0002\u0012$\u0001AB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\u000b\u0003g\u0004!\u0011!Q\u0001\n\u0005U\bB\u0003B\u0001\u0001\t\u0005\t\u0015a\u0003\u0003\u0004!Q!\u0011\u0002\u0001\u0003\u0002\u0003\u0006YAa\u0003\t\r}\u0002A\u0011\u0001B\n\u0011%\u0011\t\u0003\u0001b\u0001\n\u0013\u0011\u0019\u0003\u0003\u0005\u0003,\u0001\u0001\u000b\u0011\u0002B\u0013\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_AqA!\u0010\u0001\t\u0013\u0011y\u0004C\u0004\u0003P\u0001!IA!\u0015\t\u000f\tm\u0003\u0001\"\u0003\u0003^!9!\u0011\u0010\u0001\u0005\n\tmt!\u0002\u001f$\u0011\u0003id!\u0002\u0012$\u0011\u0003q\u0004\"B \u000f\t\u0003\u0001eaB!\u000f!\u0003\r\nA\u0011\u0005\u0006\tB1\t!\u0012\u0005\u0006SB1\tA\u001b\u0005\b\u0003\u000b\u0002b\u0011AA$\u0011\u001d\ty\u0007\u0005D\u0001\u0003cBq!!!\u0011\r\u0003\t\u0019I\u0002\u0004\u0002\u001a:1\u00111\u0014\u0005\u000b\u0003_2\"\u0011!Q\u0001\n\u0005}\u0005BB \u0017\t\u0003\tI\u000bC\u0005\u00022Z\u0011\r\u0011\"\u0003\u00024\"A\u0011Q\u0018\f!\u0002\u0013\t)\fC\u0004\u0002@Z!\t!!1\u0007\r\u0005\u001dgBBAe\u0011)\t\t\t\bB\u0001B\u0003%\u0011Q\u001a\u0005\u0007\u007fq!\t!a5\t\u0013\u0005eGD1A\u0005\n\u0005m\u0007\u0002CAq9\u0001\u0006I!!8\t\u000f\u0005}F\u0004\"\u0001\u0002d\n\u00192+\u001f8dQJ|gn\\;t%\u0016\u001c\bo\u001c8tK*\u0011A%J\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003M\u001d\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003Q%\n\u0011\"\u00199jg\u0016\u0014h/\u001a:\u000b\u0005)Z\u0013\u0001\u00039mCR4wN]7\u000b\u00051j\u0013\u0001\u00023b[2T\u0011AL\u0001\u0004G>l7\u0001A\u000b\bc\u0005%\u0018Q^Ay'\t\u0001!\u0007\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VMZ\u0001\tgR\u0014\u0018\r^3hsBA!\bEAt\u0003W\fyO\u0004\u0002<\u001b5\t1%A\nTs:\u001c\u0007N]8o_V\u001c(+Z:q_:\u001cX\r\u0005\u0002<\u001dM\u0011aBM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0012\u0001b\u0015;sCR,w-_\u000b\b\u0007\u0006M\u0012\u0011MA>'\t\u0001\"'\u0001\tdkJ\u0014XM\u001c;MK\u0012<WM]#oIR\ta\tE\u0002H\u00152k\u0011\u0001\u0013\u0006\u0003\u0013R\n!bY8oGV\u0014(/\u001a8u\u0013\tY\u0005J\u0001\u0004GkR,(/\u001a\t\u0004g5{\u0015B\u0001(5\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001K\u001a\b\u0003#\u000et!A\u00151\u000f\u0005MkfB\u0001+\\\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002Y_\u00051AH]8pizJ\u0011AL\u0005\u0003Y5J!\u0001X\u0016\u0002\r1,GmZ3s\u0013\tqv,A\u0002ba&T!\u0001X\u0016\n\u0005\u0005\u0014\u0017A\u00023p[\u0006LgN\u0003\u0002_?&\u0011A-Z\u0001\r\u0019\u0016$w-\u001a:PM\u001a\u001cX\r\u001e\u0006\u0003C\nL!a\u001a5\u0003\u0011\u0005\u00137o\u001c7vi\u0016T!\u0001Z3\u0002\rM,(-\\5u)\u0015Y\u0017qBA\u0016)\rawo \t\u0004\u000f*k\u0007C\u00018v\u001b\u0005y'B\u00019r\u0003\t1(G\u0003\u0002sg\u0006)1\u000f^1uK*\u0011AoX\u0001\fa\u0006\u0014H/[2ja\u0006tG/\u0003\u0002w_\n\u00012+\u001e2nSN\u001c\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006qJ\u0001\u001d!_\u0001\u0011i\u0016dW-\\3uef\u001cuN\u001c;fqR\u0004\"A_?\u000e\u0003mT!\u0001`\u0016\u0002\u0013Q,G.Z7fiJL\u0018B\u0001@|\u0005A!V\r\\3nKR\u0014\u0018pQ8oi\u0016DH\u000fC\u0004\u0002\u0002I\u0001\u001d!a\u0001\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n-\nq\u0001\\8hO&tw-\u0003\u0003\u0002\u000e\u0005\u001d!A\u0004'pO\u001eLgnZ\"p]R,\u0007\u0010\u001e\u0005\b\u0003#\u0011\u0002\u0019AA\n\u00031\u0019XOY7jgNLwN\\%e!\u0011\t)\"!\n\u000f\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005!A-\u0019;b\u0015\r\tybK\u0001\u0003Y\u001aLA!a\t\u0002\u001a\u0005\u0019!+\u001a4\n\t\u0005\u001d\u0012\u0011\u0006\u0002\r'V\u0014W.[:tS>t\u0017\n\u001a\u0006\u0005\u0003G\tI\u0002C\u0004\u0002.I\u0001\r!a\f\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005E\u00121\u0007\u0007\u0001\t\u001d\t)\u0004\u0005b\u0001\u0003o\u0011Q!\u00138qkR\fB!!\u000f\u0002@A\u00191'a\u000f\n\u0007\u0005uBGA\u0004O_RD\u0017N\\4\u0011\u0007M\n\t%C\u0002\u0002DQ\u00121!\u00118z\u0003\u001d)g\u000e\u001e:jKN$B!!\u0013\u0002lA\"\u00111JA4!!\ti%a\u0017\u0002`\u0005\u0015TBAA(\u0015\u0011\t\t&a\u0015\u0002\u0011M\u001c\u0017\r\\1eg2TA!!\u0016\u0002X\u000511\u000f\u001e:fC6T!!!\u0017\u0002\t\u0005\\7.Y\u0005\u0005\u0003;\nyE\u0001\u0004T_V\u00148-\u001a\t\u0005\u0003c\t\t\u0007B\u0004\u0002dA\u0011\r!a\u000e\u0003\u000b\u0015sGO]=\u0011\t\u0005E\u0012q\r\u0003\f\u0003S\u001a\u0012\u0011!A\u0001\u0006\u0003\t9DA\u0002`IEBa!!\u001c\u0014\u0001\u0004a\u0015AB8gMN,G/\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0003g\ny\bE\u00044\u0003k\ny&!\u001f\n\u0007\u0005]DGA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o!\u0011\t\t$a\u001f\u0005\u000f\u0005u\u0004C1\u0001\u00028\ti\u0011iY2faR,G-\u00128uefDq!!\u0005\u0015\u0001\u0004\t\u0019\"\u0001\u0004sK*,7\r\u001e\u000b\u0005\u0003\u000b\u000b9\nE\u00044\u0003k\ny&a\"\u0011\t\u0005%\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006!qM\u001d9d\u0015\t\t\t*\u0001\u0002j_&!\u0011QSAF\u0005Y\u0019F/\u0019;vgJ+h\u000e^5nK\u0016C8-\u001a9uS>t\u0007bBA\t+\u0001\u0007\u00111\u0003\u0002\t\u0003\u000e\u001cW\r\u001d;fIV1\u0011QTAR\u0003O\u001b\"A\u0006\u001a\u0011\u000fM\n)(!)\u0002&B!\u0011\u0011GAR\t\u001d\t\u0019G\u0006b\u0001\u0003o\u0001B!!\r\u0002(\u00129\u0011Q\u0010\fC\u0002\u0005]B\u0003BAV\u0003_\u0003r!!,\u0017\u0003C\u000b)+D\u0001\u000f\u0011\u001d\ty\u0007\u0007a\u0001\u0003?\u000bA\u0002\\5gi\u0016$\u0017iY2faR,\"!!.\u0011\u000fM\n9,!)\u0002<&\u0019\u0011\u0011\u0018\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003B\u001aN\u0003K\u000bQ\u0002\\5gi\u0016$\u0017iY2faR\u0004\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003w\u000b\u0019\rC\u0004\u0002Fn\u0001\r!!)\u0002\u000b\u0015tGO]=\u0003\u0011I+'.Z2uK\u0012,B!a3\u0002RN\u0011AD\r\t\bg\u0005U\u0014qZAD!\u0011\t\t$!5\u0005\u000f\u0005\rDD1\u0001\u00028Q!\u0011Q[Al!\u0015\ti\u000bHAh\u0011\u001d\t\tI\ba\u0001\u0003\u001b\fA\u0002\\5gi\u0016$'+\u001a6fGR,\"!!8\u0011\u000fM\n9,a4\u0002`B!1'TAD\u00035a\u0017N\u001a;fIJ+'.Z2uAQ!\u0011q\\As\u0011\u001d\t)-\ta\u0001\u0003\u001f\u0004B!!\r\u0002j\u00129\u0011Q\u0007\u0001C\u0002\u0005]\u0002\u0003BA\u0019\u0003[$q!a\u0019\u0001\u0005\u0004\t9\u0004\u0005\u0003\u00022\u0005EHaBA?\u0001\t\u0007\u0011qG\u0001\u000bi&lW\rV8MSZ,\u0007\u0003BA|\u0003{l!!!?\u000b\u0007\u0005m\b*\u0001\u0005ekJ\fG/[8o\u0013\u0011\ty0!?\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0004\u000f\n\u0015\u0011b\u0001B\u0004\u0011\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\r[\u0006$XM]5bY&TXM\u001d\t\u0005\u0005\u001b\u0011y!\u0004\u0002\u0002T%!!\u0011CA*\u00051i\u0015\r^3sS\u0006d\u0017N_3s)\u0019\u0011)B!\b\u0003 Q1!q\u0003B\r\u00057\u0001\u0002b\u000f\u0001\u0002h\u0006-\u0018q\u001e\u0005\b\u0005\u0003)\u00019\u0001B\u0002\u0011\u001d\u0011I!\u0002a\u0002\u0005\u0017AQ\u0001O\u0003A\u0002eBq!a=\u0006\u0001\u0004\t)0\u0001\u0004m_\u001e<WM]\u000b\u0003\u0005K\u0001B!!\u0002\u0003(%!!\u0011FA\u0004\u0005Q\u0019uN\u001c;fqR,\u0018\r\\5{K\u0012dunZ4fe\u00069An\\4hKJ\u0004\u0013!D:vE6LG/\u00118e/\u0006LG\u000f\u0006\u0004\u00032\te\"1\b\u000b\u0007\u0005g\u0011)Da\u000e\u0011\t\u001dS\u0015q\u001e\u0005\u0006q\"\u0001\u001d!\u001f\u0005\b\u0003\u0003A\u00019AA\u0002\u0011\u001d\t\t\u0002\u0003a\u0001\u0003'Aq!!\f\t\u0001\u0004\t9/\u0001\u0005u_J+7/\u001e7u)!\u0011\tE!\u0012\u0003H\t-C\u0003\u0002B\u001a\u0005\u0007Bq!!\u0001\n\u0001\b\t\u0019\u0001C\u0004\u0002\u0012%\u0001\r!a\u0005\t\r\t%\u0013\u00021\u0001M\u0003YaW\rZ4fe\u0016sGMQ3g_J,'+Z9vKN$\bB\u0002B'\u0013\u0001\u0007Q.\u0001\ttk\nl\u0017n]:j_:\u0014Vm];mi\u0006a\u0011mY6o_^dW\rZ4fIR1!1\u000bB,\u00053\"BAa\r\u0003V!9\u0011\u0011\u0001\u0006A\u0004\u0005\r\u0001bBA\t\u0015\u0001\u0007\u00111\u0003\u0005\u0007\u0005\u0013R\u0001\u0019\u0001'\u0002\u0017Q|wI\u001d9d\u000bJ\u0014xN\u001d\u000b\u0007\u0005?\u0012)Ha\u001e\u0011\u000fM\n)H!\u0019\u0003tA!!1\rB7\u001d\u0011\u0011)G!\u001b\u000f\u0007Y\u00139'C\u00016\u0013\r\u0011Y\u0007N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yG!\u001d\u0003\u0013QC'o\\<bE2,'b\u0001B6iA!qISA\u001d\u0011\u001d\t\ta\u0003a\u0001\u0003\u0007Aq!!\u0005\f\u0001\u0004\t\u0019\"A\u0006feJ|'\u000fT8hO\u0016\u0014HC\u0002B?\u0005\u0013\u0013Y\t\u0005\u0003\u0003\u0000\t\u0015UB\u0001BA\u0015\r\u0011\u0019iK\u0001\u0006KJ\u0014xN]\u0005\u0005\u0005\u000f\u0013\tIA\u000fEC6d7i\u001c8uKb$X/\u00197ju\u0016$WI\u001d:pe2{wmZ3s\u0011\u001d\t\t\u0001\u0004a\u0001\u0003\u0007Aq!!\u0005\r\u0001\u0004\t\u0019\u0002")
public class SynchronousResponse<Input, Entry, AcceptedEntry> {
    private final Strategy<Input, Entry, AcceptedEntry> strategy;
    private final FiniteDuration timeToLive;
    private final ExecutionContext executionContext;
    private final Materializer materializer;
    private final ContextualizedLogger logger;

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public Future<AcceptedEntry> submitAndWait(String submissionId, Input input, TelemetryContext telemetryContext, LoggingContext loggingContext) {
        return this.strategy.currentLedgerEnd().flatMap((Function1 & Serializable)ledgerEndBeforeRequest -> $this.strategy.submit(submissionId, input, telemetryContext, loggingContext).flatMap((Function1 & Serializable)submissionResult -> this.toResult(submissionId, (Option<domain.LedgerOffset.Absolute>)ledgerEndBeforeRequest, (SubmissionResult)submissionResult, loggingContext).map((Function1 & Serializable)entry -> entry, $this.executionContext), $this.executionContext), this.executionContext);
    }

    private Future<AcceptedEntry> toResult(String submissionId, Option<domain.LedgerOffset.Absolute> ledgerEndBeforeRequest, SubmissionResult submissionResult, LoggingContext loggingContext) {
        Future future;
        SubmissionResult submissionResult2 = submissionResult;
        if (SubmissionResult.Acknowledged$.MODULE$.equals(submissionResult2)) {
            future = this.acknowledged(submissionId, ledgerEndBeforeRequest, loggingContext);
        } else if (submissionResult2 instanceof SubmissionResult.SynchronousError) {
            SubmissionResult.SynchronousError synchronousError = (SubmissionResult.SynchronousError)submissionResult2;
            future = Future$.MODULE$.failed((Throwable)synchronousError.exception());
        } else {
            throw new MatchError((Object)submissionResult2);
        }
        return future;
    }

    private Future<AcceptedEntry> acknowledged(String submissionId, Option<domain.LedgerOffset.Absolute> ledgerEndBeforeRequest, LoggingContext loggingContext) {
        Accepted<Entry, AcceptedEntry> isAccepted = new Accepted<Entry, AcceptedEntry>(this.strategy.accept(submissionId));
        Rejected<Entry> isRejected = new Rejected<Entry>(this.strategy.reject(submissionId));
        return ((Future)((Source)this.strategy.entries(ledgerEndBeforeRequest).collect((PartialFunction)new Serializable(null, isAccepted, isRejected){
            private static final long serialVersionUID = 0L;
            private final Accepted isAccepted$1;
            private final Rejected isRejected$1;

            public final <A1 extends Entry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<StatusRuntimeException> option;
                Object object;
                Option<AcceptedEntry> option2;
                A1 A1 = x1;
                if (A1 != null && !(option2 = this.isAccepted$1.unapply(A1)).isEmpty()) {
                    Object entry = option2.get();
                    object = Future$.MODULE$.successful(entry);
                } else if (A1 != null && !(option = this.isRejected$1.unapply(A1)).isEmpty()) {
                    StatusRuntimeException exception = (StatusRuntimeException)((Object)option.get());
                    object = Future$.MODULE$.failed((Throwable)exception);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Entry x1) {
                Option<StatusRuntimeException> option;
                Option<AcceptedEntry> option2;
                Entry Entry2 = x1;
                boolean bl = Entry2 != null && !(option2 = this.isAccepted$1.unapply(Entry2)).isEmpty() ? true : Entry2 != null && !(option = this.isRejected$1.unapply(Entry2)).isEmpty();
                return bl;
            }
            {
                this.isAccepted$1 = isAccepted$1;
                this.isRejected$1 = isRejected$1;
            }
        }).completionTimeout(this.timeToLive)).runWith((Graph)Sink$.MODULE$.head(), this.materializer)).recoverWith(this.toGrpcError(loggingContext, submissionId), this.executionContext).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private PartialFunction<Throwable, Future<Nothing$>> toGrpcError(LoggingContext loggingContext, String submissionId) {
        return new Serializable(this, loggingContext, submissionId){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SynchronousResponse $outer;
            private final LoggingContext loggingContext$2;
            private final String submissionId$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof TimeoutException ? Future$.MODULE$.failed((Throwable)new LedgerApiErrors.RequestTimeOut$.Reject("Request timed out", false, (ContextualizedErrorLogger)this.$outer.com$daml$platform$apiserver$services$admin$SynchronousResponse$$errorLogger(this.loggingContext$2, this.submissionId$2)).asGrpcError()) : (A1 instanceof NoSuchElementException ? Future$.MODULE$.failed((Throwable)new LedgerApiErrors.ServiceNotRunning$.Reject("Party submission", (ContextualizedErrorLogger)this.$outer.com$daml$platform$apiserver$services$admin$SynchronousResponse$$errorLogger(this.loggingContext$2, this.submissionId$2)).asGrpcError()) : function1.apply(x1));
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof TimeoutException ? true : throwable instanceof NoSuchElementException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.loggingContext$2 = loggingContext$2;
                this.submissionId$2 = submissionId$2;
            }
        };
    }

    public DamlContextualizedErrorLogger com$daml$platform$apiserver$services$admin$SynchronousResponse$$errorLogger(LoggingContext loggingContext, String submissionId) {
        return new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)new Some((Object)submissionId));
    }

    public SynchronousResponse(Strategy<Input, Entry, AcceptedEntry> strategy, FiniteDuration timeToLive, ExecutionContext executionContext, Materializer materializer) {
        this.strategy = strategy;
        this.timeToLive = timeToLive;
        this.executionContext = executionContext;
        this.materializer = materializer;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }

    private static final class Accepted<Entry, AcceptedEntry> {
        private final Function1<Entry, Option<AcceptedEntry>> liftedAccept;

        private Function1<Entry, Option<AcceptedEntry>> liftedAccept() {
            return this.liftedAccept;
        }

        public Option<AcceptedEntry> unapply(Entry entry) {
            return (Option)this.liftedAccept().apply(entry);
        }

        public Accepted(PartialFunction<Entry, AcceptedEntry> accept2) {
            this.liftedAccept = accept2.lift();
        }
    }

    private static final class Rejected<Entry> {
        private final Function1<Entry, Option<StatusRuntimeException>> liftedReject;

        private Function1<Entry, Option<StatusRuntimeException>> liftedReject() {
            return this.liftedReject;
        }

        public Option<StatusRuntimeException> unapply(Entry entry) {
            return (Option)this.liftedReject().apply(entry);
        }

        public Rejected(PartialFunction<Entry, StatusRuntimeException> reject2) {
            this.liftedReject = reject2.lift();
        }
    }

    public static interface Strategy<Input, Entry, AcceptedEntry> {
        public Future<Option<domain.LedgerOffset.Absolute>> currentLedgerEnd();

        public Future<SubmissionResult> submit(String var1, Input var2, TelemetryContext var3, LoggingContext var4);

        public Source<Entry, ?> entries(Option<domain.LedgerOffset.Absolute> var1);

        public PartialFunction<Entry, AcceptedEntry> accept(String var1);

        public PartialFunction<Entry, StatusRuntimeException> reject(String var1);
    }
}

