/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.transaction;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Source;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.domain$;
import com.daml.ledger.api.messages.transaction.GetTransactionByEventIdRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionByIdRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionTreesRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionsRequest;
import com.daml.ledger.api.v1.transaction_service.GetFlatTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionTreesResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsResponse;
import com.daml.ledger.api.validation.ValidationErrors$;
import com.daml.ledger.participant.state.index.v2.IndexTransactionsService;
import com.daml.lf.ledger.EventId;
import com.daml.lf.ledger.EventId$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.logging.entries.LoggingEntries;
import com.daml.logging.entries.LoggingEntries$;
import com.daml.logging.entries.LoggingValue;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.services.StreamMetrics$;
import com.daml.platform.apiserver.services.logging.package$;
import com.daml.platform.apiserver.services.transaction.ApiTransactionService$;
import com.daml.platform.server.api.services.domain.TransactionService;
import com.daml.platform.server.api.services.grpc.GrpcTransactionService;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scalaz.syntax.TagOps$;

@ScalaSignature(bytes="\u0006\u0005\tUuA\u0002\r\u001a\u0011\u0003iRE\u0002\u0004(3!\u0005Q\u0004\u000b\u0005\u0006_\u0005!\t!\r\u0005\u0006e\u0005!\ta\r\u0004\u0007Oe\u0011Q$a\r\t\u0015\u0005-AA!A!\u0002\u0013\ti\u0001\u0003\u0006\u0002(\u0011\u0011\t\u0011)A\u0005\u0003SA\u0011\"a\u0010\u0005\u0005\u0003\u0005\u000b1\u0002'\t\u0011\u0019$!\u0011!Q\u0001\f\u001dDaa\f\u0003\u0005\n\u0005\u0005\u0003\"CA(\t\t\u0007I\u0011BA)\u0011!\tI\u0006\u0002Q\u0001\n\u0005M\u0003bBA.\t\u0011\u0005\u0013Q\f\u0005\b\u0003\u000b#A\u0011IAD\u0011\u001d\ty\f\u0002C!\u0003\u0003Dq!a5\u0005\t\u0003\n)\u000eC\u0004\u0002h\u0012!\t%!;\t\u000f\u0005MH\u0001\"\u0011\u0002v\"9!\u0011\u0001\u0003\u0005B\t\r\u0001b\u0002B\u0004\t\u0011%!\u0011\u0002\u0005\b\u0005\u001f\"A\u0011\u0002B)\u0011\u001d\u0011Y\u0006\u0002C\u0005\u0005;BqAa\u001c\u0005\t\u0013\u0011\t\bC\u0004\u0003v\u0011!IAa\u001e\u0002+\u0005\u0003\u0018\u000e\u0016:b]N\f7\r^5p]N+'O^5dK*\u0011!dG\u0001\fiJ\fgn]1di&|gN\u0003\u0002\u001d;\u0005A1/\u001a:wS\u000e,7O\u0003\u0002\u001f?\u0005I\u0011\r]5tKJ4XM\u001d\u0006\u0003A\u0005\n\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u0003E\r\nA\u0001Z1nY*\tA%A\u0002d_6\u0004\"AJ\u0001\u000e\u0003e\u0011Q#\u00119j)J\fgn]1di&|gnU3sm&\u001cWm\u0005\u0002\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002K\u000511M]3bi\u0016$b\u0001N7\u0002\n\u0005\u0015B#B\u001bK%r+'c\u0001\u001c9\u0007\u001a!q'\u0001\u00016\u00051a$/\u001a4j]\u0016lWM\u001c;?!\tI\u0014)D\u0001;\u0015\tYD(\u0001\u0003heB\u001c'B\u0001\u000f>\u0015\tqt(A\u0002ba&T!\u0001Q\u0010\u0002\rM,'O^3s\u0013\t\u0011%H\u0001\fHeB\u001cGK]1og\u0006\u001cG/[8o'\u0016\u0014h/[2f!\t!\u0005*D\u0001F\u0015\tYdIC\u0001H\u0003\tIw.\u0003\u0002J\u000b\ny!)\u001b8eC\ndWmU3sm&\u001cW\rC\u0003L\u0007\u0001\u000fA*\u0001\u0002fGB\u0011Q\nU\u0007\u0002\u001d*\u0011qjK\u0001\u000bG>t7-\u001e:sK:$\u0018BA)O\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003T\u0007\u0001\u000fA+A\u0002nCR\u0004\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\rM$(/Z1n\u0015\u0005I\u0016\u0001B1lW\u0006L!a\u0017,\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\t\u000bu\u001b\u00019\u00010\u0002\u0007\u0015\u001ch\r\u0005\u0002`G6\t\u0001M\u0003\u0002bE\u00069\u0011\rZ1qi\u0016\u0014(BA\u001e\"\u0013\t!\u0007MA\rFq\u0016\u001cW\u000f^5p]N+\u0017/^3oG\u0016\u0014h)Y2u_JL\b\"\u00024\u0004\u0001\b9\u0017A\u00047pO\u001eLgnZ\"p]R,\u0007\u0010\u001e\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u0006\nq\u0001\\8hO&tw-\u0003\u0002mS\nqAj\\4hS:<7i\u001c8uKb$\b\"\u00028\u0004\u0001\u0004y\u0017\u0001\u00037fI\u001e,'/\u00133\u0011\u0007A\f\u0019A\u0004\u0002r}:\u0011!\u000f \b\u0003gjt!\u0001^=\u000f\u0005UDX\"\u0001<\u000b\u0005]\u0004\u0014A\u0002\u001fs_>$h(C\u0001%\u0013\t\u00113%\u0003\u0002|C\u00051A.\u001a3hKJL!AP?\u000b\u0005m\f\u0013bA@\u0002\u0002\u00051Am\\7bS:T!AP?\n\t\u0005\u0015\u0011q\u0001\u0002\t\u0019\u0016$w-\u001a:JI*\u0019q0!\u0001\t\u000f\u0005-1\u00011\u0001\u0002\u000e\u0005\u0019BO]1og\u0006\u001cG/[8ogN+'O^5dKB!\u0011qBA\u0011\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011A\u0001<3\u0015\u0011\t9\"!\u0007\u0002\u000b%tG-\u001a=\u000b\t\u0005m\u0011QD\u0001\u0006gR\fG/\u001a\u0006\u0004\u0003?i\u0018a\u00039beRL7-\u001b9b]RLA!a\t\u0002\u0012\tA\u0012J\u001c3fqR\u0013\u0018M\\:bGRLwN\\:TKJ4\u0018nY3\t\u000f\u0005\u001d2\u00011\u0001\u0002*\u00059Q.\u001a;sS\u000e\u001c\b\u0003BA\u0016\u0003_i!!!\f\u000b\u0007\u0005\u001d\u0012%\u0003\u0003\u00022\u00055\"aB'fiJL7m]\n\u0005\t%\n)\u0004\u0005\u0003\u00028\u0005mRBAA\u001d\u0015\tyH(\u0003\u0003\u0002>\u0005e\"A\u0005+sC:\u001c\u0018m\u0019;j_:\u001cVM\u001d<jG\u0016\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0015\r\u0005\r\u00131JA')\u0019\t)%a\u0012\u0002JA\u0011a\u0005\u0002\u0005\u0007\u0003\u007fI\u00019\u0001'\t\u000b\u0019L\u00019A4\t\u000f\u0005-\u0011\u00021\u0001\u0002\u000e!9\u0011qE\u0005A\u0002\u0005%\u0012A\u00027pO\u001e,'/\u0006\u0002\u0002TA\u0019\u0001.!\u0016\n\u0007\u0005]\u0013N\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u000319W\r\u001e'fI\u001e,'/\u00128e)\u0011\ty&a\u001d\u0011\u000b5\u000b\t'!\u001a\n\u0007\u0005\rdJ\u0001\u0004GkR,(/\u001a\t\u0005\u0003O\niGD\u0002q\u0003SJA!a\u001b\u0002\b\u0005aA*\u001a3hKJ|eMZ:fi&!\u0011qNA9\u0005!\t%m]8mkR,'\u0002BA6\u0003\u000fAaA\u001c\u0007A\u0002\u0005U\u0004\u0003BA<\u0003\u007frA!!\u001f\u0002|A\u0011QoK\u0005\u0004\u0003{Z\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0002\u0006\r%AB*ue&twMC\u0002\u0002~-\nqbZ3u)J\fgn]1di&|gn\u001d\u000b\u0005\u0003\u0013\u000bi\u000b\u0005\u0005\u0002\f\u0006E\u0015QSAS\u001b\t\tiIC\u0002\u0002\u0010Z\u000b\u0001b]2bY\u0006$7\u000f\\\u0005\u0005\u0003'\u000biI\u0001\u0004T_V\u00148-\u001a\t\u0005\u0003/\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003M!(/\u00198tC\u000e$\u0018n\u001c8`g\u0016\u0014h/[2f\u0015\u0011\ty*!\u0001\u0002\u0005Y\f\u0014\u0002BAR\u00033\u0013qcR3u)J\fgn]1di&|gn\u001d*fgB|gn]3\u0011\t\u0005\u001d\u0016\u0011V\u0007\u00021&\u0019\u00111\u0016-\u0003\u000f9{G/V:fI\"9\u0011qV\u0007A\u0002\u0005E\u0016a\u0002:fcV,7\u000f\u001e\t\u0005\u0003g\u000bY,\u0004\u0002\u00026*\u0019!$a.\u000b\t\u0005e\u0016\u0011A\u0001\t[\u0016\u001c8/Y4fg&!\u0011QXA[\u0005Y9U\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001c(+Z9vKN$\u0018aE4fiR\u0013\u0018M\\:bGRLwN\u001c+sK\u0016\u001cH\u0003BAb\u0003\u0017\u0004\u0002\"a#\u0002\u0012\u0006\u0015\u0017Q\u0015\t\u0005\u0003/\u000b9-\u0003\u0003\u0002J\u0006e%aG$fiR\u0013\u0018M\\:bGRLwN\u001c+sK\u0016\u001c(+Z:q_:\u001cX\rC\u0004\u00020:\u0001\r!!4\u0011\t\u0005M\u0016qZ\u0005\u0005\u0003#\f)L\u0001\u000eHKR$&/\u00198tC\u000e$\u0018n\u001c8Ue\u0016,7OU3rk\u0016\u001cH/A\fhKR$&/\u00198tC\u000e$\u0018n\u001c8Cs\u00163XM\u001c;JIR!\u0011q[Ap!\u0015i\u0015\u0011MAm!\u0011\t9*a7\n\t\u0005u\u0017\u0011\u0014\u0002\u0017\u000f\u0016$HK]1og\u0006\u001cG/[8o%\u0016\u001c\bo\u001c8tK\"9\u0011qV\bA\u0002\u0005\u0005\b\u0003BAZ\u0003GLA!!:\u00026\nqr)\u001a;Ue\u0006t7/Y2uS>t')_#wK:$\u0018\n\u001a*fcV,7\u000f^\u0001\u0013O\u0016$HK]1og\u0006\u001cG/[8o\u0005fLE\r\u0006\u0003\u0002X\u0006-\bbBAX!\u0001\u0007\u0011Q\u001e\t\u0005\u0003g\u000by/\u0003\u0003\u0002r\u0006U&!G$fiR\u0013\u0018M\\:bGRLwN\u001c\"z\u0013\u0012\u0014V-];fgR\f1dZ3u\r2\fG\u000f\u0016:b]N\f7\r^5p]\nKXI^3oi&#G\u0003BA|\u0003\u007f\u0004R!TA1\u0003s\u0004B!a&\u0002|&!\u0011Q`AM\u0005i9U\r\u001e$mCR$&/\u00198tC\u000e$\u0018n\u001c8SKN\u0004xN\\:f\u0011\u001d\ty+\u0005a\u0001\u0003C\facZ3u\r2\fG\u000f\u0016:b]N\f7\r^5p]\nK\u0018\n\u001a\u000b\u0005\u0003o\u0014)\u0001C\u0004\u00020J\u0001\r!!<\u000231|wn[+q)J,WMQ=Ue\u0006t7/Y2uS>t\u0017\n\u001a\u000b\u0007\u0005\u0017\u0011iBa\n\u0015\t\u0005]'Q\u0002\u0005\b\u0005\u001f\u0019\u00029\u0001B\t\u0003-)'O]8s\u0019><w-\u001a:\u0011\t\tM!\u0011D\u0007\u0003\u0005+Q1Aa\u0006\"\u0003\u0015)'O]8s\u0013\u0011\u0011YB!\u0006\u00033\r{g\u000e^3yiV\fG.\u001b>fI\u0016\u0013(o\u001c:M_\u001e<WM\u001d\u0005\b\u0005?\u0019\u0002\u0019\u0001B\u0011\u00035!(/\u00198tC\u000e$\u0018n\u001c8JIB\u0019\u0001Oa\t\n\t\t\u0015\u0012q\u0001\u0002\u000e)J\fgn]1di&|g.\u00133\t\u000f\t%2\u00031\u0001\u0003,\u0005\t\"/Z9vKN$\u0018N\\4QCJ$\u0018.Z:\u0011\r\u0005]$Q\u0006B\u0019\u0013\u0011\u0011y#a!\u0003\u0007M+G\u000f\u0005\u0003\u00034\t%c\u0002\u0002B\u001b\u0005\u0007rAAa\u000e\u0003>9\u00191O!\u000f\n\u0007\tm\u0012%\u0001\u0002mM&!!q\bB!\u0003\u0011!\u0017\r^1\u000b\u0007\tm\u0012%\u0003\u0003\u0003F\t\u001d\u0013a\u0001*fM*!!q\bB!\u0013\u0011\u0011YE!\u0014\u0003\u000bA\u000b'\u000f^=\u000b\t\t\u0015#qI\u0001\u001aY>|7.\u00169GY\u0006$()\u001f+sC:\u001c\u0018m\u0019;j_:LE\r\u0006\u0004\u0003T\t]#\u0011\f\u000b\u0005\u0003o\u0014)\u0006C\u0004\u0003\u0010Q\u0001\u001dA!\u0005\t\u000f\t}A\u00031\u0001\u0003\"!9!\u0011\u0006\u000bA\u0002\t-\u0012\u0001\u0007;sC:\u001c\u0018m\u0019;j_:$&/Z3t\u0019><w-\u00192mKR!!q\fB6!\u0011\u0011\tGa\u001a\u000e\u0005\t\r$b\u0001B3S\u00069QM\u001c;sS\u0016\u001c\u0018\u0002\u0002B5\u0005G\u0012a\u0002T8hO&tw-\u00128ue&,7\u000fC\u0004\u0003nU\u0001\r!!2\u0002\u000bQ\u0014X-Z:\u0002)Q\u0014\u0018M\\:bGRLwN\\:M_\u001e<\u0017M\u00197f)\u0011\u0011yFa\u001d\t\u000f\t5d\u00031\u0001\u0002\u0016\u0006qQM\u001c;jifdunZ4bE2,GC\u0003B=\u0005\u000f\u0013YI!$\u0003\u0012B!!1\u0010BA\u001d\u0011\u0011\tG! \n\t\t}$1M\u0001\r\u0019><w-\u001b8h-\u0006dW/Z\u0005\u0005\u0005\u0007\u0013)I\u0001\u0004OKN$X\r\u001a\u0006\u0005\u0005\u007f\u0012\u0019\u0007C\u0004\u0003\n^\u0001\r!!\u001e\u0002\u0013\r|W.\\1oI&#\u0007b\u0002B\u0010/\u0001\u0007\u0011Q\u000f\u0005\b\u0005\u001f;\u0002\u0019AA;\u0003)9xN]6gY><\u0018\n\u001a\u0005\b\u0005';\u0002\u0019AA;\u0003\u0019ygMZ:fi\u0002")
public final class ApiTransactionService
implements TransactionService {
    private final IndexTransactionsService transactionsService;
    private final Metrics metrics;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;

    public static GrpcTransactionService create(Object ledgerId, IndexTransactionsService transactionsService, Metrics metrics, ExecutionContext ec, Materializer mat, ExecutionSequencerFactory esf, LoggingContext loggingContext) {
        return ApiTransactionService$.MODULE$.create(ledgerId, transactionsService, metrics, ec, mat, esf, loggingContext);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public Future<domain.LedgerOffset.Absolute> getLedgerEnd(String ledgerId) {
        return this.transactionsService.currentLedgerEnd(this.loggingContext).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    public Source<GetTransactionsResponse, NotUsed> getTransactions(GetTransactionsRequest request) {
        LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.ledgerId((Option<Object>)request.ledgerId()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.startExclusive(request.startExclusive()), package$.MODULE$.endInclusive((Option<domain.LedgerOffset>)request.endInclusive()), package$.MODULE$.filters(request.filter()), package$.MODULE$.verbose(request.verbose())}), (Function1 & Serializable)loggingContext -> {
            ApiTransactionService.$anonfun$getTransactions$1(this, loggingContext);
            return BoxedUnit.UNIT;
        }, this.loggingContext);
        this.logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(21).append("Transaction request: ").append(request).toString(), this.loggingContext);
        return this.transactionsService.transactions(request.startExclusive(), request.endInclusive(), request.filter(), request.verbose(), this.loggingContext).via((Graph)this.logger().enrichedDebugStream("Responding with transactions.", (Function1 & Serializable)trees -> new LoggingEntries(this.transactionsLoggable(trees)), this.loggingContext)).via((Graph)this.logger().logErrorsOnStream(this.loggingContext)).via(StreamMetrics$.MODULE$.countElements(this.metrics.daml().lapi().streams().transactions()));
    }

    public Source<GetTransactionTreesResponse, NotUsed> getTransactionTrees(GetTransactionTreesRequest request) {
        LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.ledgerId((Option<Object>)request.ledgerId()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.startExclusive(request.startExclusive()), package$.MODULE$.endInclusive((Option<domain.LedgerOffset>)request.endInclusive()), package$.MODULE$.parties((Iterable<String>)request.parties()), package$.MODULE$.verbose(request.verbose())}), (Function1 & Serializable)loggingContext -> {
            ApiTransactionService.$anonfun$getTransactionTrees$1(this, loggingContext);
            return BoxedUnit.UNIT;
        }, this.loggingContext);
        this.logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(26).append("Transaction tree request: ").append(request).toString(), this.loggingContext);
        return this.transactionsService.transactionTrees(request.startExclusive(), request.endInclusive(), new domain.TransactionFilter(((IterableOnceOps)request.parties().map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)domain.Filters$.MODULE$.noFilter()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), request.verbose(), this.loggingContext).via((Graph)this.logger().enrichedDebugStream("Responding with transaction trees.", (Function1 & Serializable)trees -> new LoggingEntries(this.transactionTreesLoggable(trees)), this.loggingContext)).via((Graph)this.logger().logErrorsOnStream(this.loggingContext)).via(StreamMetrics$.MODULE$.countElements(this.metrics.daml().lapi().streams().transactionTrees()));
    }

    public Future<GetTransactionResponse> getTransactionByEventId(GetTransactionByEventIdRequest request) {
        LoggingContext enrichedLoggingContext = LoggingContext$.MODULE$.enriched(package$.MODULE$.ledgerId((Option<Object>)request.ledgerId()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.eventId(request.eventId()), package$.MODULE$.parties((Iterable<String>)request.requestingParties())}), this.loggingContext);
        this.logger().info().apply((Function0 & Serializable)() -> "Received request for transaction by event ID.", enrichedLoggingContext);
        DamlContextualizedErrorLogger errorLogger = new DamlContextualizedErrorLogger(this.logger(), enrichedLoggingContext, (Option)None$.MODULE$);
        this.logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(33).append("Transaction by event ID request: ").append(request).toString(), this.loggingContext);
        return ((Future)EventId$.MODULE$.fromString((String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(request.eventId()))).map(arg_0 -> ApiTransactionService.$anonfun$getTransactionByEventId$3(this, request, (ContextualizedErrorLogger)errorLogger, arg_0)).getOrElse(() -> ApiTransactionService.$anonfun$getTransactionByEventId$4(request, (ContextualizedErrorLogger)errorLogger))).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    public Future<GetTransactionResponse> getTransactionById(GetTransactionByIdRequest request) {
        DamlContextualizedErrorLogger errorLogger = (DamlContextualizedErrorLogger)LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.ledgerId((Option<Object>)request.ledgerId()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.transactionId(request.transactionId()), package$.MODULE$.parties((Iterable<String>)request.requestingParties())}), (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Received request for transaction by ID.", loggingContext);
            return new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        }, this.loggingContext);
        this.logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(27).append("Transaction by ID request: ").append(request).toString(), this.loggingContext);
        return this.lookUpTreeByTransactionId(request.transactionId(), (Set<String>)request.requestingParties(), (ContextualizedErrorLogger)errorLogger).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    public Future<GetFlatTransactionResponse> getFlatTransactionByEventId(GetTransactionByEventIdRequest request) {
        DamlContextualizedErrorLogger errorLogger = (DamlContextualizedErrorLogger)LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.ledgerId((Option<Object>)request.ledgerId()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.eventId(request.eventId()), package$.MODULE$.parties((Iterable<String>)request.requestingParties())}), (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Received request for flat transaction by event ID.", loggingContext);
            return new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        }, this.loggingContext);
        this.logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(38).append("Flat transaction by event ID request: ").append(request).toString(), this.loggingContext);
        return ((Future)EventId$.MODULE$.fromString((String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(request.eventId()))).map((Function1 & Serializable)x0$1 -> {
            EventId eventId = x0$1;
            if (eventId == null) {
                throw new MatchError((Object)eventId);
            }
            String transactionId = eventId.transactionId();
            Future<GetFlatTransactionResponse> future = this.lookUpFlatByTransactionId(domain$.MODULE$.TransactionId().apply((Object)transactionId), (Set<String>)request.requestingParties(), (ContextualizedErrorLogger)errorLogger);
            return future;
        }).getOrElse((Function0 & Serializable)() -> {
            String msg = new StringBuilder(9).append("eventId: ").append(request.eventId()).toString();
            return Future$.MODULE$.failed((Throwable)ValidationErrors$.MODULE$.invalidArgument(msg, (ContextualizedErrorLogger)errorLogger));
        })).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    public Future<GetFlatTransactionResponse> getFlatTransactionById(GetTransactionByIdRequest request) {
        DamlContextualizedErrorLogger errorLogger = (DamlContextualizedErrorLogger)LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.ledgerId((Option<Object>)request.ledgerId()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.transactionId(request.transactionId()), package$.MODULE$.parties((Iterable<String>)request.requestingParties())}), (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Received request for flat transaction by ID.", loggingContext);
            return new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        }, this.loggingContext);
        this.logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(32).append("Flat transaction by ID request: ").append(request).toString(), this.loggingContext);
        return this.lookUpFlatByTransactionId(request.transactionId(), (Set<String>)request.requestingParties(), (ContextualizedErrorLogger)errorLogger).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    private Future<GetTransactionResponse> lookUpTreeByTransactionId(Object transactionId, Set<String> requestingParties, ContextualizedErrorLogger errorLogger) {
        return this.transactionsService.getTransactionTreeById(transactionId, requestingParties, this.loggingContext).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RequestValidation.NotFound$.Transaction$.Reject((String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(transactionId)), errorLogger).asGrpcError());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                GetTransactionResponse transaction = (GetTransactionResponse)some.value();
                future = Future$.MODULE$.successful((Object)transaction);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.executionContext);
    }

    private Future<GetFlatTransactionResponse> lookUpFlatByTransactionId(Object transactionId, Set<String> requestingParties, ContextualizedErrorLogger errorLogger) {
        return this.transactionsService.getTransactionById(transactionId, requestingParties, this.loggingContext).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RequestValidation.NotFound$.Transaction$.Reject((String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(transactionId)), errorLogger).asGrpcError());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                GetFlatTransactionResponse transaction = (GetFlatTransactionResponse)some.value();
                future = Future$.MODULE$.successful((Object)transaction);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.executionContext);
    }

    private Map transactionTreesLoggable(GetTransactionTreesResponse trees) {
        return LoggingEntries$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactions"), (Object)new LoggingValue.OfIterable((Iterable)trees.transactions().toList().map((Function1 & Serializable)t -> this.entityLoggable(t.commandId(), t.transactionId(), t.workflowId(), t.offset()))))}));
    }

    private Map transactionsLoggable(GetTransactionsResponse trees) {
        return LoggingEntries$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactions"), (Object)new LoggingValue.OfIterable((Iterable)trees.transactions().toList().map((Function1 & Serializable)t -> this.entityLoggable(t.commandId(), t.transactionId(), t.workflowId(), t.offset()))))}));
    }

    private LoggingValue.Nested entityLoggable(String commandId, String transactionId, String workflowId, String offset) {
        return LoggingValue.Nested$.MODULE$.fromEntries((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.commandId(commandId), package$.MODULE$.transactionId(transactionId), package$.MODULE$.workflowId(workflowId), package$.MODULE$.offset(offset)}));
    }

    public static final /* synthetic */ void $anonfun$getTransactions$1(ApiTransactionService $this, LoggingContext loggingContext) {
        $this.logger().info().apply((Function0 & Serializable)() -> "Received request for transactions.", loggingContext);
    }

    public static final /* synthetic */ void $anonfun$getTransactionTrees$1(ApiTransactionService $this, LoggingContext loggingContext) {
        $this.logger().info().apply((Function0 & Serializable)() -> "Received request for transaction trees.", loggingContext);
    }

    public static final /* synthetic */ Future $anonfun$getTransactionByEventId$3(ApiTransactionService $this, GetTransactionByEventIdRequest request$3, ContextualizedErrorLogger errorLogger$1, EventId x0$1) {
        EventId eventId = x0$1;
        if (eventId == null) {
            throw new MatchError((Object)eventId);
        }
        String transactionId = eventId.transactionId();
        Future<GetTransactionResponse> future = $this.lookUpTreeByTransactionId(domain$.MODULE$.TransactionId().apply((Object)transactionId), (Set<String>)request$3.requestingParties(), errorLogger$1);
        return future;
    }

    public static final /* synthetic */ Future $anonfun$getTransactionByEventId$4(GetTransactionByEventIdRequest request$3, ContextualizedErrorLogger errorLogger$1) {
        return Future$.MODULE$.failed((Throwable)ValidationErrors$.MODULE$.invalidArgument(new StringBuilder(17).append("invalid eventId: ").append(request$3.eventId()).toString(), errorLogger$1));
    }

    public ApiTransactionService(IndexTransactionsService transactionsService, Metrics metrics, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.transactionsService = transactionsService;
        this.metrics = metrics;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

