/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.indexer;

import akka.stream.Materializer;
import com.daml.daml_lf_dev.DamlLf;
import com.daml.ledger.participant.state.v2.ReadService;
import com.daml.ledger.resources.ResourceContext;
import com.daml.lf.engine.ValueEnricher;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.indexer.IndexerConfig;
import com.daml.platform.indexer.IndexerConfig$;
import com.daml.platform.indexer.MeteringAggregator;
import com.daml.platform.indexer.MeteringAggregator$Owner$;
import com.daml.platform.indexer.parallel.InitializeParallelIngestion;
import com.daml.platform.indexer.parallel.ParallelIndexerFactory$;
import com.daml.platform.indexer.parallel.ParallelIndexerSubscription;
import com.daml.platform.store.DbSupport;
import com.daml.platform.store.DbType$;
import com.daml.platform.store.LfValueTranslationCache;
import com.daml.platform.store.backend.DBLockStorageBackend;
import com.daml.platform.store.backend.DataSourceStorageBackend;
import com.daml.platform.store.backend.IngestionStorageBackend;
import com.daml.platform.store.backend.MeteringParameterStorageBackend;
import com.daml.platform.store.backend.MeteringStorageWriteBackend;
import com.daml.platform.store.backend.ParameterStorageBackend;
import com.daml.platform.store.backend.StorageBackendFactory;
import com.daml.platform.store.backend.StorageBackendFactory$;
import com.daml.platform.store.backend.StringInterningStorageBackend;
import com.daml.platform.store.dao.DbDispatcher;
import com.daml.platform.store.dao.events.CompressionStrategy;
import com.daml.platform.store.dao.events.CompressionStrategy$;
import com.daml.platform.store.dao.events.LfValueTranslation;
import com.daml.platform.store.interning.StringInterningView;
import com.daml.resources.AbstractResourceOwner;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005-s!\u0002\b\u0010\u0011\u0003Ab!\u0002\u000e\u0010\u0011\u0003Y\u0002\"\u0002\u0012\u0002\t\u0003\u0019c!\u0002\u0013\u0002\u0005M)\u0003\u0002\u0003\u0014\u0004\u0005\u0003\u0005\u000b\u0011B\u0014\t\u0011M\u001a!\u0011!Q\u0001\nQB\u0001\u0002S\u0002\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u0019\u000e\u0011\t\u0011)A\u0005\u001b\"A\u0011l\u0001B\u0001B\u0003%!\f\u0003\u0005`\u0007\t\u0005\t\u0015!\u0003a\u0011!A7A!A!\u0002\u0013I\u0007\u0002\u0003:\u0004\u0005\u0003\u0005\u000b1B:\t\u000b\t\u001aA\u0011A>\t\u000f\u0005=1\u0001\"\u0001\u0002\u0012\u0005Y!\n\u001a2d\u0013:$W\r_3s\u0015\t\u0001\u0012#A\u0004j]\u0012,\u00070\u001a:\u000b\u0005I\u0019\u0012\u0001\u00039mCR4wN]7\u000b\u0005Q)\u0012\u0001\u00023b[2T\u0011AF\u0001\u0004G>l7\u0001\u0001\t\u00033\u0005i\u0011a\u0004\u0002\f\u0015\u0012\u00147-\u00138eKb,'o\u0005\u0002\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\r\u0003\u000f\u0019\u000b7\r^8ssN\u00111\u0001H\u0001\u000ea\u0006\u0014H/[2ja\u0006tG/\u00133\u0011\u0005!\u0002dBA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0011!\u0017\r^1\u000b\u00055\u001a\u0012A\u00017g\u0013\ty#&A\u0002SK\u001aL!!\r\u001a\u0003\u001bA\u000b'\u000f^5dSB\fg\u000e^%e\u0015\ty#&A\u000eqCJ$\u0018nY5qC:$H)\u0019;b'>,(oY3D_:4\u0017n\u001a\t\u0003k\u0015s!A\u000e\"\u000f\u0005]\u0002eB\u0001\u001d@\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=/\u00051AH]8pizJ\u0011AF\u0005\u0003)UI!AE\n\n\u0005\u0005\u000b\u0012!B:u_J,\u0017BA\"E\u0003%!%mU;qa>\u0014HO\u0003\u0002B#%\u0011ai\u0012\u0002\u001c!\u0006\u0014H/[2ja\u0006tG\u000fR1uCN{WO]2f\u0007>tg-[4\u000b\u0005\r#\u0015AB2p]\u001aLw\r\u0005\u0002\u001a\u0015&\u00111j\u0004\u0002\u000e\u0013:$W\r_3s\u0007>tg-[4\u0002\u0017I,\u0017\rZ*feZL7-\u001a\t\u0003\u001d^k\u0011a\u0014\u0006\u0003!F\u000b!A\u001e\u001a\u000b\u0005I\u001b\u0016!B:uCR,'B\u0001+V\u0003-\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;\u000b\u0005Y\u001b\u0012A\u00027fI\u001e,'/\u0003\u0002Y\u001f\nY!+Z1e'\u0016\u0014h/[2f\u0003\u001diW\r\u001e:jGN\u0004\"aW/\u000e\u0003qS!!W\n\n\u0005yc&aB'fiJL7m]\u0001\u0018Y\u001a4\u0016\r\\;f)J\fgn\u001d7bi&|gnQ1dQ\u0016\u0004\"!Y3\u000f\u0005\t\u001cW\"\u0001#\n\u0005\u0011$\u0015a\u0006'g-\u0006dW/\u001a+sC:\u001cH.\u0019;j_:\u001c\u0015m\u00195f\u0013\t1wMA\u0003DC\u000eDWM\u0003\u0002e\t\u0006!2\u000f\u001e:j]\u001eLe\u000e^3s]&twMV5fo>\u00032!\b6m\u0013\tYgD\u0001\u0004PaRLwN\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u0012\u000b\u0011\"\u001b8uKJt\u0017N\\4\n\u0005Et'aE*ue&tw-\u00138uKJt\u0017N\\4WS\u0016<\u0018\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0019\u0019HO]3b[*\t\u00010\u0001\u0003bW.\f\u0017B\u0001>v\u00051i\u0015\r^3sS\u0006d\u0017N_3s)=a\u0018\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\f\u00055ACA?\u0000!\tq8!D\u0001\u0002\u0011\u0015\u0011H\u0002q\u0001t\u0011\u00151C\u00021\u0001(\u0011\u0015\u0019D\u00021\u00015\u0011\u0015AE\u00021\u0001J\u0011\u0015aE\u00021\u0001N\u0011\u0015IF\u00021\u0001[\u0011\u0015yF\u00021\u0001a\u0011\u0015AG\u00021\u0001j\u0003-Ig.\u001b;jC2L'0\u001a3\u0015\u0005\u0005MA\u0003BA\u000b\u0003w\u0001b!a\u0006\u0002*\u0005=b\u0002BA\r\u0003GqA!a\u0007\u0002 9\u0019\u0001(!\b\n\u0005Y\u001b\u0012bAA\u0011+\u0006I!/Z:pkJ\u001cWm]\u0005\u0005\u0003K\t9#A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005\u0005R+\u0003\u0003\u0002,\u00055\"!\u0004*fg>,(oY3Po:,'O\u0003\u0003\u0002&\u0005\u001d\u0002\u0003BA\u0019\u0003kq1!GA\u001a\u0013\r\t)cD\u0005\u0005\u0003o\tIDA\u0004J]\u0012,\u00070\u001a:\u000b\u0007\u0005\u0015r\u0002C\u0004\u0002>5\u0001\u001d!a\u0010\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002FM\tq\u0001\\8hO&tw-\u0003\u0003\u0002J\u0005\r#A\u0004'pO\u001eLgnZ\"p]R,\u0007\u0010\u001e")
public final class JdbcIndexer {

    public static final class Factory {
        private final String participantId;
        private final DbSupport.ParticipantDataSourceConfig participantDataSourceConfig;
        private final IndexerConfig config;
        private final ReadService readService;
        private final Metrics metrics;
        private final LfValueTranslationCache.Cache lfValueTranslationCache;
        private final Option<StringInterningView> stringInterningViewO;
        private final Materializer materializer;

        public AbstractResourceOwner<ResourceContext, AbstractResourceOwner<ResourceContext, Future<BoxedUnit>>> initialized(LoggingContext loggingContext) {
            StorageBackendFactory factory = StorageBackendFactory$.MODULE$.of(DbType$.MODULE$.jdbcType(this.participantDataSourceConfig.jdbcUrl()));
            DataSourceStorageBackend dataSourceStorageBackend = factory.createDataSourceStorageBackend();
            IngestionStorageBackend<?> ingestionStorageBackend = factory.createIngestionStorageBackend();
            MeteringStorageWriteBackend meteringStoreBackend = factory.createMeteringStorageWriteBackend();
            ParameterStorageBackend parameterStorageBackend = factory.createParameterStorageBackend();
            MeteringParameterStorageBackend meteringParameterStorageBackend = factory.createMeteringParameterStorageBackend();
            DBLockStorageBackend DBLockStorageBackend2 = factory.createDBLockStorageBackend();
            StringInterningStorageBackend stringInterningStorageBackend = factory.createStringInterningStorageBackend();
            DbSupport.DataSourceProperties dbConfig = IndexerConfig$.MODULE$.dataSourceProperties(this.config);
            String x$12 = this.participantId;
            ParameterStorageBackend x$22 = parameterStorageBackend;
            IngestionStorageBackend<?> x$3 = ingestionStorageBackend;
            StringInterningStorageBackend x$4 = stringInterningStorageBackend;
            Metrics x$5 = this.metrics;
            ParameterStorageBackend x$6 = parameterStorageBackend;
            IngestionStorageBackend<?> x$7 = ingestionStorageBackend;
            String x$8 = this.participantId;
            LfValueTranslation x$9 = new LfValueTranslation(this.lfValueTranslationCache, this.metrics, (Option<ValueEnricher>)None$.MODULE$, (Function2<String, LoggingContext, Future<Option<DamlLf.Archive>>>)(Function2 & Serializable)(x$1, x$2) -> Future$.MODULE$.successful((Object)None$.MODULE$));
            CompressionStrategy x$10 = this.config.enableCompression() ? CompressionStrategy$.MODULE$.allGZIP(this.metrics) : CompressionStrategy$.MODULE$.none(this.metrics);
            int x$11 = this.config.maxInputBufferSize();
            int x$122 = this.config.inputMappingParallelism();
            int x$13 = this.config.batchingParallelism();
            int x$14 = this.config.ingestionParallelism();
            long x$15 = this.config.submissionBatchSize();
            Metrics x$16 = this.metrics;
            MeteringStorageWriteBackend x$17 = meteringStoreBackend;
            MeteringParameterStorageBackend x$18 = meteringParameterStorageBackend;
            ParameterStorageBackend x$19 = parameterStorageBackend;
            Metrics x$20 = this.metrics;
            FiniteDuration x$21 = MeteringAggregator$Owner$.MODULE$.$lessinit$greater$default$5();
            FiniteDuration x$222 = MeteringAggregator$Owner$.MODULE$.$lessinit$greater$default$6();
            MeteringAggregator.Owner owner2 = new MeteringAggregator.Owner(x$17, x$19, x$18, x$20, x$21, x$222);
            AbstractResourceOwner<ResourceContext, AbstractResourceOwner<ResourceContext, Future<BoxedUnit>>> indexer = ParallelIndexerFactory$.MODULE$.apply(this.config.inputMappingParallelism(), this.config.batchingParallelism(), dbConfig.createDbConfig(this.participantDataSourceConfig), this.config.highAvailability(), this.metrics, DBLockStorageBackend2, dataSourceStorageBackend, new InitializeParallelIngestion(x$12, x$3, x$22, x$4, x$5), new ParallelIndexerSubscription(x$7, x$6, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16), (Function1<DbDispatcher, AbstractResourceOwner<ResourceContext, BoxedUnit>>)(Function1 & Serializable)dbDispatcher -> owner2.apply((DbDispatcher)dbDispatcher, loggingContext), this.materializer, this.readService, this.stringInterningViewO, loggingContext);
            return indexer;
        }

        public Factory(String participantId, DbSupport.ParticipantDataSourceConfig participantDataSourceConfig, IndexerConfig config, ReadService readService, Metrics metrics, LfValueTranslationCache.Cache lfValueTranslationCache, Option<StringInterningView> stringInterningViewO, Materializer materializer) {
            this.participantId = participantId;
            this.participantDataSourceConfig = participantDataSourceConfig;
            this.config = config;
            this.readService = readService;
            this.metrics = metrics;
            this.lfValueTranslationCache = lfValueTranslationCache;
            this.stringInterningViewO = stringInterningViewO;
            this.materializer = materializer;
        }
    }
}

