/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.indexer.ha;

import akka.stream.KillSwitch;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.indexer.ha.Handle;
import com.daml.platform.indexer.ha.KillSwitchCaptor;
import com.daml.platform.indexer.ha.KillSwitchCaptor$State$Shutdown$;
import com.daml.platform.indexer.ha.PreemptableSequence;
import com.daml.platform.indexer.ha.PreemptableSequence$;
import com.daml.platform.indexer.ha.SequenceHelper;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Timer;
import java.util.TimerTask;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class PreemptableSequence$ {
    public static final PreemptableSequence$ MODULE$ = new PreemptableSequence$();
    private static final ContextualizedLogger com$daml$platform$indexer$ha$PreemptableSequence$$logger = ContextualizedLogger$.MODULE$.get(MODULE$.getClass());

    public ContextualizedLogger com$daml$platform$indexer$ha$PreemptableSequence$$logger() {
        return com$daml$platform$indexer$ha$PreemptableSequence$$logger;
    }

    public PreemptableSequence apply(Timer timer, ExecutionContext executionContext, LoggingContext loggingContext) {
        return sequence -> {
            Promise resultCompleted = Promise$.MODULE$.apply();
            KillSwitchCaptor killSwitchCaptor = new KillSwitchCaptor(loggingContext);
            Handle resultHandle = new Handle((Future<BoxedUnit>)resultCompleted.future(), killSwitchCaptor);
            ObjectRef releaseStack = ObjectRef.create((Object)package$.MODULE$.Nil());
            SequenceHelper helper = new SequenceHelper(timer, loggingContext, releaseStack, executionContext, killSwitchCaptor, resultHandle){
                private final Timer timer$1;
                private final LoggingContext loggingContext$1;
                private final ObjectRef releaseStack$1;
                private final ExecutionContext executionContext$1;
                private final KillSwitchCaptor killSwitchCaptor$1;
                private final Handle resultHandle$1;

                private Future<BoxedUnit> waitFor(long delayMillis) {
                    Promise p = Promise$.MODULE$.apply();
                    this.timer$1.schedule(new TimerTask(null, p){
                        private final Promise p$1;

                        public void run() {
                            this.p$1.success((Object)BoxedUnit.UNIT);
                        }
                        {
                            this.p$1 = p$1;
                        }
                    }, delayMillis);
                    return this.goF((Function0 & Serializable)() -> p.future());
                }

                public synchronized void registerRelease(Function0<BoxedUnit> release) {
                    PreemptableSequence$.MODULE$.com$daml$platform$indexer$ha$PreemptableSequence$$logger().info().apply((Function0 & Serializable)() -> "Registered release function", this.loggingContext$1);
                    Function0 & Serializable intersect = (Function0 & Serializable)() -> Future$.MODULE$.apply(release, $this.executionContext$1);
                    this.releaseStack$1.elem = ((List)this.releaseStack$1.elem).$colon$colon((Object)intersect);
                }

                public <T> Future<T> goF(Function0<Future<T>> f) {
                    Future future;
                    KillSwitchCaptor.State state = this.killSwitchCaptor$1.state();
                    if (state instanceof KillSwitchCaptor.State.Used) {
                        PreemptableSequence$.MODULE$.com$daml$platform$indexer$ha$PreemptableSequence$$logger().info().apply((Function0 & Serializable)() -> "KillSwitch already used, interrupting sequence!", this.loggingContext$1);
                        future = Future$.MODULE$.failed((Throwable)new Exception("UsedKillSwitch"));
                    } else {
                        future = (Future)f.apply();
                    }
                    return future;
                }

                public <T> Future<T> go(Function0<T> body) {
                    return this.goF((Function0 & Serializable)() -> Future$.MODULE$.apply(body, $this.executionContext$1));
                }

                public <T> Future<T> retry(long waitMillisBetweenRetries, long maxAmountOfRetries, Function1<Throwable, Object> retryable, Function0<T> body) {
                    return this.go(body).transformWith((Function1 & Serializable)x0$1 -> {
                        boolean bl = false;
                        Failure failure = null;
                        Try try_ = x0$1;
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Object t = success.value();
                            return Future$.MODULE$.successful(t);
                        }
                        if (try_ instanceof Failure) {
                            bl = true;
                            failure = (Failure)try_;
                            Throwable ex = failure.exception();
                            if (BoxesRunTime.unboxToBoolean((Object)retryable.apply((Object)ex))) {
                                Future future;
                                if (maxAmountOfRetries == 0L) {
                                    PreemptableSequence$.MODULE$.com$daml$platform$indexer$ha$PreemptableSequence$$logger().warn().apply((Function0 & Serializable)() -> new StringBuilder(58).append("Maximum amount of retries reached (").append(maxAmountOfRetries).append("). Failing permanently.").toString(), ex, $this.loggingContext$1);
                                    future = Future$.MODULE$.failed(ex);
                                    return future;
                                } else {
                                    String retriesLeft = maxAmountOfRetries < 0L ? "unlimited" : BoxesRunTime.boxToLong((long)(maxAmountOfRetries - 1L));
                                    PreemptableSequence$.MODULE$.com$daml$platform$indexer$ha$PreemptableSequence$$logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(35).append("Retrying (retries left: ").append((Object)retriesLeft).append("). Due to: ").append(ex.getMessage()).toString(), $this.loggingContext$1);
                                    future = this.waitFor(waitMillisBetweenRetries).flatMap((Function1 & Serializable)x$3 -> this.retry(waitMillisBetweenRetries, maxAmountOfRetries - 1L, retryable, body), $this.executionContext$1);
                                }
                                return future;
                            }
                        }
                        if (!bl) throw new MatchError((Object)try_);
                        Throwable ex = failure.exception();
                        PreemptableSequence$.MODULE$.com$daml$platform$indexer$ha$PreemptableSequence$$logger().warn().apply((Function0 & Serializable)() -> "Failure not retryable.", ex, $this.loggingContext$1);
                        return Future$.MODULE$.failed(ex);
                    }, this.executionContext$1);
                }

                public <T> long retry$default$2() {
                    return -1L;
                }

                public <T> Function1<Throwable, Object> retry$default$3() {
                    return (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$retry$default$3$2(x$2));
                }

                public Future<BoxedUnit> merge(Handle handle) {
                    PreemptableSequence$.MODULE$.com$daml$platform$indexer$ha$PreemptableSequence$$logger().info().apply((Function0 & Serializable)() -> "Delegating KillSwitch upon merge.", this.loggingContext$1);
                    this.killSwitchCaptor$1.setDelegate((Option<KillSwitch>)new Some((Object)handle.killSwitch()));
                    KillSwitchCaptor.State state = this.killSwitchCaptor$1.state();
                    if (KillSwitchCaptor$State$Shutdown$.MODULE$.equals(state)) {
                        PreemptableSequence$.MODULE$.com$daml$platform$indexer$ha$PreemptableSequence$$logger().info().apply((Function0 & Serializable)() -> "Replying ShutDown after merge.", this.loggingContext$1);
                        handle.killSwitch().shutdown();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (state instanceof KillSwitchCaptor.State.Aborted) {
                        KillSwitchCaptor.State.Aborted aborted = (KillSwitchCaptor.State.Aborted)state;
                        Throwable ex = aborted.t();
                        PreemptableSequence$.MODULE$.com$daml$platform$indexer$ha$PreemptableSequence$$logger().info().apply((Function0 & Serializable)() -> new StringBuilder(31).append("Replaying abort (").append(ex.getMessage()).append(") after merge.").toString(), this.loggingContext$1);
                        handle.killSwitch().abort(ex);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return handle.completed().transform((Function1 & Serializable)r -> {
                        $this.killSwitchCaptor$1.setDelegate((Option<KillSwitch>)None$.MODULE$);
                        return r;
                    }, this.executionContext$1);
                }

                public Handle handle() {
                    return this.resultHandle$1;
                }

                public static final /* synthetic */ boolean $anonfun$retry$default$3$2(Throwable x$2) {
                    return true;
                }
                {
                    this.timer$1 = timer$1;
                    this.loggingContext$1 = loggingContext$1;
                    this.releaseStack$1 = releaseStack$1;
                    this.executionContext$1 = executionContext$1;
                    this.killSwitchCaptor$1 = killSwitchCaptor$1;
                    this.resultHandle$1 = resultHandle$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$go$1(com.daml.platform.indexer.ha.PreemptableSequence$$anon$1 scala.Function0 ), $anonfun$goF$1(), $anonfun$merge$1(), $anonfun$merge$2(), $anonfun$merge$3(java.lang.Throwable ), $anonfun$merge$4(com.daml.platform.indexer.ha.PreemptableSequence$$anon$1 scala.util.Try ), $anonfun$registerRelease$1(), $anonfun$registerRelease$2(com.daml.platform.indexer.ha.PreemptableSequence$$anon$1 scala.Function0 ), $anonfun$retry$1(com.daml.platform.indexer.ha.PreemptableSequence$$anon$1 scala.Function1 long long scala.Function0 scala.util.Try ), $anonfun$retry$2(long ), $anonfun$retry$3(java.lang.Object java.lang.Throwable ), $anonfun$retry$4(com.daml.platform.indexer.ha.PreemptableSequence$$anon$1 long long scala.Function1 scala.Function0 scala.runtime.BoxedUnit ), $anonfun$retry$5(), $anonfun$retry$default$3$2$adapted(java.lang.Throwable ), $anonfun$waitFor$1(scala.concurrent.Promise )}, serializedLambda);
                }
            };
            ((Future)sequence.apply((Object)helper)).transformWith((Function1 & Serializable)fResult -> PreemptableSequence$.release$2(releaseStack, executionContext).transform((Function1 & Serializable)x$5 -> fResult, executionContext), executionContext).onComplete((Function1 & Serializable)x0$1 -> {
                Promise promise;
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    Promise promise2;
                    KillSwitchCaptor.State state = killSwitchCaptor.state();
                    if (KillSwitchCaptor$State$Shutdown$.MODULE$.equals(state)) {
                        promise2 = resultCompleted.success((Object)BoxedUnit.UNIT);
                    } else if (state instanceof KillSwitchCaptor.State.Aborted) {
                        KillSwitchCaptor.State.Aborted aborted = (KillSwitchCaptor.State.Aborted)state;
                        Throwable ex = aborted.t();
                        promise2 = resultCompleted.failure(ex);
                    } else {
                        promise2 = resultCompleted.success((Object)BoxedUnit.UNIT);
                    }
                    promise = promise2;
                } else if (try_ instanceof Failure) {
                    Promise promise3;
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    KillSwitchCaptor.State state = killSwitchCaptor.state();
                    if (KillSwitchCaptor$State$Shutdown$.MODULE$.equals(state)) {
                        promise3 = resultCompleted.success((Object)BoxedUnit.UNIT);
                    } else if (state instanceof KillSwitchCaptor.State.Aborted) {
                        KillSwitchCaptor.State.Aborted aborted = (KillSwitchCaptor.State.Aborted)state;
                        Throwable ex2 = aborted.t();
                        promise3 = resultCompleted.failure(ex2);
                    } else {
                        promise3 = resultCompleted.failure(ex);
                    }
                    promise = promise3;
                } else {
                    throw new MatchError((Object)try_);
                }
                return promise;
            }, executionContext);
            return resultHandle;
        };
    }

    private static final Future release$2(ObjectRef releaseStack$1, ExecutionContext executionContext$1) {
        Future future;
        PreemptableSequence$ preemptableSequence$ = MODULE$;
        synchronized (preemptableSequence$) {
            Future future2;
            List list = (List)releaseStack$1.elem;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                future2 = Future$.MODULE$.unit();
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                Function0 x = (Function0)colon2.head();
                List xs = colon2.next$access$1();
                releaseStack$1.elem = xs;
                future2 = ((Future)x.apply()).transformWith((Function1 & Serializable)x$4 -> PreemptableSequence$.release$2(releaseStack$1, executionContext$1), executionContext$1);
            } else {
                throw new MatchError((Object)list);
            }
            future = future2;
        }
        return future;
    }

    private PreemptableSequence$() {
    }
}

