/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.indexer.parallel;

import com.daml.ledger.offset.Offset;
import com.daml.ledger.offset.Offset$;
import com.daml.ledger.participant.state.v2.Update;
import com.daml.ledger.participant.state.v2.Update$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.logging.entries.LoggingValue$;
import com.daml.logging.entries.ToLoggingValue$;
import com.daml.metrics.Metrics;
import com.daml.metrics.Timed$;
import com.daml.platform.indexer.parallel.ParallelIndexerSubscription;
import com.daml.platform.store.backend.DbDto;
import com.daml.platform.store.backend.DbDto$StringInterningDto$;
import com.daml.platform.store.backend.IngestionStorageBackend;
import com.daml.platform.store.backend.ParameterStorageBackend;
import com.daml.platform.store.dao.DbDispatcher;
import com.daml.platform.store.dao.events.CompressionStrategy;
import com.daml.platform.store.dao.events.LfValueTranslation;
import java.io.Serializable;
import java.sql.Connection;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple11;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ParallelIndexerSubscription$
implements Serializable {
    public static final ParallelIndexerSubscription$ MODULE$ = new ParallelIndexerSubscription$();
    private static final ContextualizedLogger logger = ContextualizedLogger$.MODULE$.get(MODULE$.getClass());

    private ContextualizedLogger logger() {
        return logger;
    }

    public Function1<Iterable<Tuple2<Offset, Update>>, ParallelIndexerSubscription.Batch<Vector<DbDto>>> inputMapper(Metrics metrics, Function1<Offset, Function1<Update, Iterator<DbDto>>> toDbDto, Function1<Iterable<Tuple2<Offset, Update>>, Vector<DbDto.TransactionMetering>> toMeteringDbDto, LoggingContext loggingContext) {
        return (Function1 & Serializable)input -> {
            metrics.daml().parallelIndexer().inputMapping().batchSize().update(input.size());
            input.foreach((Function1 & Serializable)x0$1 -> {
                ParallelIndexerSubscription$.$anonfun$inputMapper$2(loggingContext, x0$1);
                return BoxedUnit.UNIT;
            });
            Vector mainBatch = input.iterator().flatMap((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Offset offset = (Offset)tuple2._1();
                Update update = (Update)tuple2._2();
                Iterator iterator = (Iterator)((Function1)toDbDto.apply((Object)offset)).apply((Object)update);
                return iterator;
            }).toVector();
            Vector meteringBatch = (Vector)toMeteringDbDto.apply(input);
            Vector batch = (Vector)mainBatch.$plus$plus((IterableOnce)meteringBatch);
            return new ParallelIndexerSubscription.Batch<Vector>((Offset)((Tuple2)input.last())._1(), 0L, 0, ((Update)((Tuple2)input.last())._2()).recordTime().toInstant().toEpochMilli(), batch, input.size(), (Vector<Offset>)((IterableOnceOps)input.view().map((Function1 & Serializable)x$5 -> (Offset)x$5._1())).toVector());
        };
    }

    public ParallelIndexerSubscription.Batch<Vector<DbDto>> seqMapperZero(long initialSeqId, int initialStringInterningId) {
        return new ParallelIndexerSubscription.Batch<Vector<DbDto>>(null, initialSeqId, initialStringInterningId, 0L, package$.MODULE$.Vector().empty(), 0, (Vector<Offset>)package$.MODULE$.Vector().empty());
    }

    public ParallelIndexerSubscription.Batch<Vector<DbDto>> seqMapper(Function1<Iterable<DbDto>, Iterable<Tuple2<Object, String>>> internize, Metrics metrics, ParallelIndexerSubscription.Batch<Vector<DbDto>> previous, ParallelIndexerSubscription.Batch<Vector<DbDto>> current) {
        return (ParallelIndexerSubscription.Batch)Timed$.MODULE$.value(metrics.daml().parallelIndexer().seqMapping().duration(), (Function0 & Serializable)() -> {
            LongRef eventSeqId = LongRef.create((long)previous.lastSeqEventId());
            Vector batchWithSeqIds = (Vector)((StrictOptimizedIterableOps)current.batch()).map((Function1 & Serializable)x0$1 -> {
                DbDto dbDto;
                DbDto dbDto2 = x0$1;
                if (dbDto2 instanceof DbDto.EventCreate) {
                    DbDto.EventCreate eventCreate = (DbDto.EventCreate)dbDto2;
                    ++eventSeqId$1.elem;
                    long x$1 = eventSeqId$1.elem;
                    Option<String> x$2 = eventCreate.copy$default$1();
                    Option<String> x$3 = eventCreate.copy$default$2();
                    Option<Object> x$4 = eventCreate.copy$default$3();
                    Option<String> x$5 = eventCreate.copy$default$4();
                    Option<String> x$6 = eventCreate.copy$default$5();
                    Option<String> x$7 = eventCreate.copy$default$6();
                    Option<Set<String>> x$8 = eventCreate.copy$default$7();
                    Option<Object> x$9 = eventCreate.copy$default$8();
                    Option<String> x$10 = eventCreate.copy$default$9();
                    String x$11 = eventCreate.copy$default$10();
                    Option<String> x$12 = eventCreate.copy$default$11();
                    Set<String> x$13 = eventCreate.copy$default$12();
                    Set<String> x$14 = eventCreate.copy$default$13();
                    Option<byte[]> x$15 = eventCreate.copy$default$14();
                    Option<Set<String>> x$16 = eventCreate.copy$default$15();
                    Option<Set<String>> x$17 = eventCreate.copy$default$16();
                    Option<String> x$18 = eventCreate.copy$default$17();
                    Option<byte[]> x$19 = eventCreate.copy$default$18();
                    Option<String> x$20 = eventCreate.copy$default$19();
                    Option<Object> x$21 = eventCreate.copy$default$20();
                    Option<Object> x$22 = eventCreate.copy$default$21();
                    dbDto = eventCreate.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$1);
                } else if (dbDto2 instanceof DbDto.EventExercise) {
                    DbDto.EventExercise eventExercise = (DbDto.EventExercise)dbDto2;
                    ++eventSeqId$1.elem;
                    long x$23 = eventSeqId$1.elem;
                    boolean x$24 = eventExercise.copy$default$1();
                    Option<String> x$25 = eventExercise.copy$default$2();
                    Option<String> x$26 = eventExercise.copy$default$3();
                    Option<Object> x$27 = eventExercise.copy$default$4();
                    Option<String> x$28 = eventExercise.copy$default$5();
                    Option<String> x$29 = eventExercise.copy$default$6();
                    Option<String> x$30 = eventExercise.copy$default$7();
                    Option<Set<String>> x$31 = eventExercise.copy$default$8();
                    Option<Object> x$32 = eventExercise.copy$default$9();
                    Option<String> x$33 = eventExercise.copy$default$10();
                    String x$34 = eventExercise.copy$default$11();
                    Option<String> x$35 = eventExercise.copy$default$12();
                    Set<String> x$36 = eventExercise.copy$default$13();
                    Set<String> x$37 = eventExercise.copy$default$14();
                    Option<byte[]> x$38 = eventExercise.copy$default$15();
                    Option<String> x$39 = eventExercise.copy$default$16();
                    Option<byte[]> x$40 = eventExercise.copy$default$17();
                    Option<byte[]> x$41 = eventExercise.copy$default$18();
                    Option<Set<String>> x$42 = eventExercise.copy$default$19();
                    Option<Vector<String>> x$43 = eventExercise.copy$default$20();
                    Option<Object> x$44 = eventExercise.copy$default$21();
                    Option<Object> x$45 = eventExercise.copy$default$22();
                    Option<Object> x$46 = eventExercise.copy$default$23();
                    dbDto = eventExercise.copy(x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$23);
                } else if (dbDto2 instanceof DbDto.EventDivulgence) {
                    DbDto.EventDivulgence eventDivulgence = (DbDto.EventDivulgence)dbDto2;
                    ++eventSeqId$1.elem;
                    long x$47 = eventSeqId$1.elem;
                    Option<String> x$48 = eventDivulgence.copy$default$1();
                    Option<String> x$49 = eventDivulgence.copy$default$2();
                    Option<String> x$50 = eventDivulgence.copy$default$3();
                    Option<String> x$51 = eventDivulgence.copy$default$4();
                    Option<Set<String>> x$52 = eventDivulgence.copy$default$5();
                    String x$53 = eventDivulgence.copy$default$6();
                    Option<String> x$54 = eventDivulgence.copy$default$7();
                    Set<String> x$55 = eventDivulgence.copy$default$8();
                    Option<byte[]> x$56 = eventDivulgence.copy$default$9();
                    Option<Object> x$57 = eventDivulgence.copy$default$10();
                    dbDto = eventDivulgence.copy(x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$47);
                } else if (dbDto2 instanceof DbDto.CreateFilter) {
                    DbDto.CreateFilter createFilter = (DbDto.CreateFilter)dbDto2;
                    dbDto = createFilter.copy(eventSeqId$1.elem, createFilter.copy$default$2(), createFilter.copy$default$3());
                } else {
                    dbDto = dbDto2;
                }
                return dbDto;
            });
            Iterable iterable = (Iterable)((IterableOps)internize.apply((Object)batchWithSeqIds)).map((Function1 & Serializable)entry -> DbDto$StringInterningDto$.MODULE$.from((Tuple2<Object, String>)entry));
            Tuple2 tuple2 = iterable.isEmpty() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)previous.lastStringInterningId())), (Object)batchWithSeqIds) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((DbDto.StringInterningDto)iterable.last()).internalId())), batchWithSeqIds.$plus$plus((IterableOnce)iterable));
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            int newLastStringInterningId = tuple22._1$mcI$sp();
            Vector dbDtosWithStringInterning = (Vector)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)newLastStringInterningId), (Object)dbDtosWithStringInterning);
            Tuple2 tuple24 = tuple23;
            int newLastStringInterningId2 = tuple24._1$mcI$sp();
            Vector dbDtosWithStringInterning2 = (Vector)tuple24._2();
            long x$58 = eventSeqId.elem;
            int x$59 = newLastStringInterningId2;
            Vector x$60 = dbDtosWithStringInterning2;
            Offset x$61 = current.copy$default$1();
            long x$62 = current.copy$default$4();
            int x$63 = current.copy$default$6();
            Vector<Offset> x$64 = current.copy$default$7();
            return current.copy(x$61, x$58, x$59, x$62, x$60, x$63, x$64);
        });
    }

    public <DB_BATCH> Function1<ParallelIndexerSubscription.Batch<Vector<DbDto>>, ParallelIndexerSubscription.Batch<DB_BATCH>> batcher(Function1<Vector<DbDto>, DB_BATCH> batchF) {
        return (Function1 & Serializable)inBatch -> {
            Object dbBatch;
            Object x$1 = dbBatch = batchF.apply(inBatch.batch());
            Offset x$2 = inBatch.copy$default$1();
            long x$3 = inBatch.copy$default$2();
            int x$4 = inBatch.copy$default$3();
            long x$5 = inBatch.copy$default$4();
            int x$6 = inBatch.copy$default$6();
            Vector<Offset> x$7 = inBatch.copy$default$7();
            return inBatch.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7);
        };
    }

    public <DB_BATCH> Function1<ParallelIndexerSubscription.Batch<DB_BATCH>, Future<ParallelIndexerSubscription.Batch<DB_BATCH>>> ingester(Function2<Connection, DB_BATCH, BoxedUnit> ingestFunction, DbDispatcher dbDispatcher, Metrics metrics, LoggingContext loggingContext) {
        return (Function1 & Serializable)batch -> (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updateOffsets"), (Object)LoggingValue$.MODULE$.from(batch.offsets(), ToLoggingValue$.MODULE$.Iterable$u005BT$u005D$u0020to$u0020LoggingValue(Offset$.MODULE$.Offset$u0020to$u0020LoggingValue()))), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> dbDispatcher.executeSql(metrics.daml().parallelIndexer().ingestion(), (Function1 & Serializable)connection -> {
            metrics.daml().parallelIndexer().updates().inc((long)batch.batchSize());
            ingestFunction.apply(connection, batch.batch());
            return batch;
        }, (LoggingContext)loggingContext), loggingContext);
    }

    public <DB_BATCH> Function2<ParallelIndexerSubscription.Batch<DB_BATCH>, ParallelIndexerSubscription.Batch<DB_BATCH>, ParallelIndexerSubscription.Batch<DB_BATCH>> tailer(DB_BATCH zeroDbBatch) {
        return (Function2 & Serializable)(x$7, curr) -> new ParallelIndexerSubscription.Batch<Object>(curr.lastOffset(), curr.lastSeqEventId(), curr.lastStringInterningId(), curr.lastRecordTime(), zeroDbBatch, 0, (Vector<Offset>)package$.MODULE$.Vector().empty());
    }

    public ParameterStorageBackend.LedgerEnd ledgerEndFrom(ParallelIndexerSubscription.Batch<?> batch) {
        return new ParameterStorageBackend.LedgerEnd(batch.lastOffset(), batch.lastSeqEventId(), batch.lastStringInterningId());
    }

    public <DB_BATCH> Function1<ParallelIndexerSubscription.Batch<DB_BATCH>, Future<ParallelIndexerSubscription.Batch<DB_BATCH>>> ingestTail(Function1<ParameterStorageBackend.LedgerEnd, Function1<Connection, BoxedUnit>> ingestTailFunction, DbDispatcher dbDispatcher, Metrics metrics, LoggingContext loggingContext) {
        return (Function1 & Serializable)batch -> (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updateOffset"), (Object)LoggingValue$.MODULE$.from((Object)batch.lastOffset(), Offset$.MODULE$.Offset$u0020to$u0020LoggingValue())), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> dbDispatcher.executeSql(metrics.daml().parallelIndexer().tailIngestion(), (Function1 & Serializable)connection -> {
            ((Function1)ingestTailFunction.apply((Object)MODULE$.ledgerEndFrom((ParallelIndexerSubscription.Batch<?>)batch))).apply(connection);
            metrics.daml().indexer().ledgerEndSequentialId().updateValue((Object)BoxesRunTime.boxToLong((long)batch.lastSeqEventId()));
            metrics.daml().indexer().lastReceivedRecordTime().updateValue((Object)BoxesRunTime.boxToLong((long)batch.lastRecordTime()));
            metrics.daml().indexer().lastReceivedOffset().updateValue((Object)batch.lastOffset().toHexString());
            MODULE$.logger().info().apply((Function0 & Serializable)() -> "Ledger end updated", loggingContext);
            return batch;
        }, (LoggingContext)loggingContext), loggingContext);
    }

    public <DB_BATCH> ParallelIndexerSubscription<DB_BATCH> apply(IngestionStorageBackend<DB_BATCH> ingestionStorageBackend, ParameterStorageBackend parameterStorageBackend, String participantId, LfValueTranslation translation, CompressionStrategy compressionStrategy, int maxInputBufferSize, int inputMappingParallelism, int batchingParallelism, int ingestionParallelism, long submissionBatchSize, Metrics metrics) {
        return new ParallelIndexerSubscription<DB_BATCH>(ingestionStorageBackend, parameterStorageBackend, participantId, translation, compressionStrategy, maxInputBufferSize, inputMappingParallelism, batchingParallelism, ingestionParallelism, submissionBatchSize, metrics);
    }

    public <DB_BATCH> Option<Tuple11<IngestionStorageBackend<DB_BATCH>, ParameterStorageBackend, String, LfValueTranslation, CompressionStrategy, Object, Object, Object, Object, Object, Metrics>> unapply(ParallelIndexerSubscription<DB_BATCH> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11(x$0.ingestionStorageBackend(), (Object)x$0.parameterStorageBackend(), (Object)x$0.participantId(), (Object)x$0.translation(), (Object)x$0.compressionStrategy(), (Object)BoxesRunTime.boxToInteger((int)x$0.maxInputBufferSize()), (Object)BoxesRunTime.boxToInteger((int)x$0.inputMappingParallelism()), (Object)BoxesRunTime.boxToInteger((int)x$0.batchingParallelism()), (Object)BoxesRunTime.boxToInteger((int)x$0.ingestionParallelism()), (Object)BoxesRunTime.boxToLong((long)x$0.submissionBatchSize()), (Object)x$0.metrics()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ParallelIndexerSubscription$.class);
    }

    public static final /* synthetic */ void $anonfun$inputMapper$3(Update update$1, LoggingContext loggingContext) {
        MODULE$.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(8).append("Storing ").append(update$1.description()).toString(), loggingContext);
    }

    public static final /* synthetic */ void $anonfun$inputMapper$2(LoggingContext loggingContext$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Offset offset = (Offset)tuple2._1();
        Update update = (Update)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offset"), (Object)LoggingValue$.MODULE$.from((Object)offset, Offset$.MODULE$.Offset$u0020to$u0020LoggingValue())), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)LoggingValue$.MODULE$.from((Object)update, Update$.MODULE$.Update$u0020to$u0020LoggingValue()))}), (Function1 & Serializable)loggingContext -> {
            ParallelIndexerSubscription$.$anonfun$inputMapper$3(update, loggingContext);
            return BoxedUnit.UNIT;
        }, loggingContext$2);
    }

    private ParallelIndexerSubscription$() {
    }
}

