/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store;

import com.daml.ledger.resources.ResourceContext;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.configuration.ServerRole;
import com.daml.platform.store.DbSupport;
import com.daml.platform.store.DbType;
import com.daml.platform.store.DbType$;
import com.daml.platform.store.FlywayMigrations;
import com.daml.platform.store.FlywayMigrations$;
import com.daml.platform.store.backend.DataSourceStorageBackend;
import com.daml.platform.store.backend.StorageBackendFactory;
import com.daml.platform.store.backend.StorageBackendFactory$;
import com.daml.platform.store.dao.DbDispatcher;
import com.daml.platform.store.dao.DbDispatcher$;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.HasExecutionContext;
import com.daml.resources.PureResource$;
import com.daml.resources.Resource;
import java.io.Serializable;
import java.sql.Connection;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class DbSupport$
implements Serializable {
    public static final DbSupport$ MODULE$ = new DbSupport$();

    public AbstractResourceOwner<ResourceContext, DbSupport> owner(DbSupport.DbConfig dbConfig, ServerRole serverRole, Metrics metrics, LoggingContext loggingContext) {
        DbType dbType = DbType$.MODULE$.jdbcType(dbConfig.jdbcUrl());
        StorageBackendFactory storageBackendFactory = StorageBackendFactory$.MODULE$.of(dbType);
        DataSourceStorageBackend qual$1 = storageBackendFactory.createDataSourceStorageBackend();
        DataSourceStorageBackend.DataSourceConfig x$1 = dbConfig.dataSourceConfig();
        Option<Function1<Connection, BoxedUnit>> x$2 = qual$1.createDataSource$default$2();
        return DbDispatcher$.MODULE$.owner(qual$1.createDataSource(x$1, x$2, loggingContext), serverRole, dbConfig.connectionPool().connectionPoolSize(), dbConfig.connectionPool().connectionTimeout(), metrics, loggingContext).map((Function1 & Serializable)dbDispatcher -> new DbSupport((DbDispatcher)dbDispatcher, storageBackendFactory));
    }

    public AbstractResourceOwner<ResourceContext, DbSupport> migratedOwner(ServerRole serverRole, DbSupport.DbConfig dbConfig, Metrics metrics, LoggingContext loggingContext) {
        AbstractResourceOwner<ResourceContext, BoxedUnit> migrationOwner = new AbstractResourceOwner<ResourceContext, BoxedUnit>(dbConfig, loggingContext){
            private final DbSupport.DbConfig dbConfig$1;
            private final LoggingContext loggingContext$1;

            public Resource<ResourceContext, BoxedUnit> acquire(ResourceContext context) {
                FlywayMigrations qual$1 = new FlywayMigrations(this.dbConfig$1.jdbcUrl(), FlywayMigrations$.MODULE$.$lessinit$greater$default$2(), context, this.loggingContext$1);
                boolean x$1 = qual$1.migrate$default$1();
                return PureResource$.MODULE$.apply(qual$1.migrate(x$1), (HasExecutionContext)ResourceContext.Context$u0020has$u0020ExecutionContext$.MODULE$);
            }
            {
                this.dbConfig$1 = dbConfig$1;
                this.loggingContext$1 = loggingContext$1;
                super((HasExecutionContext)ResourceContext.Context$u0020has$u0020ExecutionContext$.MODULE$);
            }
        };
        return migrationOwner.flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            ServerRole x$12 = serverRole;
            Metrics x$2 = metrics;
            DbSupport.DbConfig x$3 = dbConfig;
            AbstractResourceOwner abstractResourceOwner = MODULE$.owner(x$3, x$12, x$2, loggingContext).map((Function1 & Serializable)dbSupport -> dbSupport);
            return abstractResourceOwner;
        });
    }

    public DbSupport apply(DbDispatcher dbDispatcher, StorageBackendFactory storageBackendFactory) {
        return new DbSupport(dbDispatcher, storageBackendFactory);
    }

    public Option<Tuple2<DbDispatcher, StorageBackendFactory>> unapply(DbSupport x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.dbDispatcher(), (Object)x$0.storageBackendFactory()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DbSupport$.class);
    }

    private DbSupport$() {
    }
}

