/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.backend;

import anorm.Column;
import anorm.Column$;
import anorm.ColumnName;
import anorm.MetaDataItem;
import anorm.ParameterMetaData;
import anorm.RowParser;
import anorm.SqlMappingError$;
import anorm.SqlParser$;
import anorm.ToStatement;
import anorm.TypeDoesNotMatch;
import com.daml.ledger.offset.Offset;
import com.daml.ledger.offset.Offset$;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.Time;
import com.daml.lf.ledger.EventId;
import com.daml.lf.ledger.EventId$;
import com.daml.lf.value.Value;
import com.daml.lf.value.Value$ContractId$;
import com.daml.platform.store.backend.Conversions;
import java.io.Serializable;
import java.math.BigDecimal;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

public final class Conversions$ {
    public static final Conversions$ MODULE$ = new Conversions$();
    private static final Column<String> columnToParty = MODULE$.stringColumnToX((Function1 & Serializable)s -> Ref$.MODULE$.Party().fromString(s));
    private static final Column<Object> bigDecimalColumnToBoolean = Column$.MODULE$.nonNull((Function2 & Serializable)(value, meta) -> {
        Right right;
        ColumnName qualified;
        MetaDataItem metaDataItem = meta;
        if (metaDataItem == null) {
            throw new MatchError((Object)metaDataItem);
        }
        ColumnName columnName = qualified = metaDataItem.column();
        ColumnName qualified2 = columnName;
        Object object = value;
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)bigDecimal.equals(new BigDecimal(1))));
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        } else {
            right = package$.MODULE$.Left().apply((Object)new TypeDoesNotMatch(new StringBuilder(39).append("Cannot convert ").append(value).append(": to Boolean for column ").append(qualified2).toString()));
        }
        return right;
    });
    private static final ToStatement<String> packageIdToStatement = new Conversions.SubTypeOfStringToStatement<String>();
    private static final Column<String> columnToLedgerString = MODULE$.stringColumnToX((Function1 & Serializable)s -> Ref$.MODULE$.LedgerString().fromString(s));
    private static final ToStatement<String> ledgerStringToStatement = new Conversions.SubTypeOfStringToStatement<String>();
    private static final Column<String> columnToApplicationId = MODULE$.stringColumnToX((Function1 & Serializable)s -> Ref$.MODULE$.ApplicationId().fromString(s));
    private static final ToStatement<String> applicationIdToStatement = new Conversions.SubTypeOfStringToStatement<String>();
    private static final Column<EventId> columnToEventId = MODULE$.stringColumnToX((Function1 & Serializable)s -> EventId$.MODULE$.fromString(s));
    private static final Column<String> columnToParticipantId = MODULE$.stringColumnToX((Function1 & Serializable)s -> Ref$.MODULE$.ParticipantId().fromString(s));
    private static final Column<Value.ContractId> columnToContractId = MODULE$.stringColumnToX((Function1 & Serializable)s -> Value$ContractId$.MODULE$.fromString(s));

    private <X> Column<X> stringColumnToX(Function1<String, Either<String, X>> f) {
        return Column$.MODULE$.nonNull((Function2 & Serializable)(value, meta) -> ((Either)Column$.MODULE$.columnToString().apply(value, meta)).flatMap((Function1 & Serializable)x -> ((Either)f.apply(x)).left().map((Function1)SqlMappingError$.MODULE$)));
    }

    private Column<String> columnToParty() {
        return columnToParty;
    }

    public RowParser<String> party(String columnName) {
        return SqlParser$.MODULE$.get(columnName, this.columnToParty());
    }

    public Column<Object> bigDecimalColumnToBoolean() {
        return bigDecimalColumnToBoolean;
    }

    public ToStatement<String> packageIdToStatement() {
        return packageIdToStatement;
    }

    private Column<String> columnToLedgerString() {
        return columnToLedgerString;
    }

    public ToStatement<String> ledgerStringToStatement() {
        return ledgerStringToStatement;
    }

    public RowParser<String> ledgerString(String columnName) {
        return SqlParser$.MODULE$.get(columnName, this.columnToLedgerString());
    }

    private Column<String> columnToApplicationId() {
        return columnToApplicationId;
    }

    public ToStatement<String> applicationIdToStatement() {
        return applicationIdToStatement;
    }

    public RowParser<String> applicationId(String columnName) {
        return SqlParser$.MODULE$.get(columnName, this.columnToApplicationId());
    }

    private Column<EventId> columnToEventId() {
        return columnToEventId;
    }

    public RowParser<EventId> eventId(String columnName) {
        return SqlParser$.MODULE$.get(columnName, this.columnToEventId());
    }

    private Column<String> columnToParticipantId() {
        return columnToParticipantId;
    }

    public RowParser<String> participantId(String columnName) {
        return SqlParser$.MODULE$.get(columnName, this.columnToParticipantId());
    }

    private Column<Value.ContractId> columnToContractId() {
        return columnToContractId;
    }

    public RowParser<Value.ContractId> contractId(String columnName) {
        return SqlParser$.MODULE$.get(columnName, this.columnToContractId());
    }

    public RowParser<Offset> offset(String name) {
        return SqlParser$.MODULE$.get(name, Column$.MODULE$.columnToString()).map((Function1 & Serializable)v -> Offset$.MODULE$.fromHexString((String)Ref$.MODULE$.HexString().assertFromString(v)));
    }

    public RowParser<Offset> offset(int position) {
        return SqlParser$.MODULE$.get(position, Column$.MODULE$.columnToString()).map((Function1 & Serializable)v -> Offset$.MODULE$.fromHexString((String)Ref$.MODULE$.HexString().assertFromString(v)));
    }

    public ParameterMetaData<Time.Timestamp> TimestampParamMeta() {
        return new ParameterMetaData<Time.Timestamp>(){
            private final String sqlType;

            public String sqlType() {
                return this.sqlType;
            }

            public int jdbcType() {
                return -5;
            }
            {
                this.sqlType = "BIGINT";
            }
        };
    }

    public RowParser<Time.Timestamp> timestampFromMicros(String name) {
        return SqlParser$.MODULE$.get(name, Column$.MODULE$.columnToLong()).map((Function1 & Serializable)micros -> Time.Timestamp$.MODULE$.assertFromLong(BoxesRunTime.unboxToLong((Object)micros)));
    }

    private Conversions$() {
    }
}

