/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.cache;

import com.daml.ledger.offset.Offset;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.value.Value;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.store.cache.ContractKeyStateValue;
import com.daml.platform.store.cache.ContractKeyStateValue$Unassigned$;
import com.daml.platform.store.cache.ContractStateCaches$;
import com.daml.platform.store.cache.ContractStateValue;
import com.daml.platform.store.cache.StateCache;
import com.daml.platform.store.dao.events.ContractStateEvent;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\b\u0010\u0001iA\u0011\"\t\u0001\u0003\u0006\u0004%\ta\u0004\u0012\t\u0011I\u0002!\u0011!Q\u0001\n\rB\u0011b\r\u0001\u0003\u0006\u0004%\ta\u0004\u001b\t\u0011\u0001\u0003!\u0011!Q\u0001\nUB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006YA\u0011\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019!\u0006\u0001)A\u0005#\")Q\u000b\u0001C\u0001-\u001e)qn\u0004E\u0001a\u001a)ab\u0004E\u0001c\")\u0001j\u0003C\u0001e\")1o\u0003C\u0001i\n\u00192i\u001c8ue\u0006\u001cGo\u0015;bi\u0016\u001c\u0015m\u00195fg*\u0011\u0001#E\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003%M\tQa\u001d;pe\u0016T!\u0001F\u000b\u0002\u0011Ad\u0017\r\u001e4pe6T!AF\f\u0002\t\u0011\fW\u000e\u001c\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\u0011-,\u0017p\u0015;bi\u0016,\u0012a\t\t\u0005I\u0015:s&D\u0001\u0010\u0013\t1sB\u0001\u0006Ti\u0006$XmQ1dQ\u0016\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003YU\t!\u0001\u001c4\n\u00059J#!C$m_\n\fGnS3z!\t!\u0003'\u0003\u00022\u001f\t)2i\u001c8ue\u0006\u001cGoS3z'R\fG/\u001a,bYV,\u0017!C6fsN#\u0018\r^3!\u00035\u0019wN\u001c;sC\u000e$8\u000b^1uKV\tQ\u0007\u0005\u0003%KYj\u0004CA\u001c;\u001d\t!\u0003(\u0003\u0002:\u001f\u00059\u0001/Y2lC\u001e,\u0017BA\u001e=\u0005)\u0019uN\u001c;sC\u000e$\u0018\n\u001a\u0006\u0003s=\u0001\"\u0001\n \n\u0005}z!AE\"p]R\u0014\u0018m\u0019;Ti\u0006$XMV1mk\u0016\fabY8oiJ\f7\r^*uCR,\u0007%\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015+\u0012a\u00027pO\u001eLgnZ\u0005\u0003\u000f\u0012\u0013a\u0002T8hO&twmQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004\u00156sECA&M!\t!\u0003\u0001C\u0003B\r\u0001\u000f!\tC\u0003\"\r\u0001\u00071\u0005C\u00034\r\u0001\u0007Q'\u0001\u0004m_\u001e<WM]\u000b\u0002#B\u00111IU\u0005\u0003'\u0012\u0013AcQ8oi\u0016DH/^1mSj,G\rT8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0005aV\u001c\b\u000e\u0006\u0002X5B\u0011A\u0004W\u0005\u00033v\u0011A!\u00168ji\")1,\u0003a\u00019\u0006YQM^3oiN\u0014\u0015\r^2i!\riFm\u001a\b\u0003=\u000et!a\u00182\u000e\u0003\u0001T!!Y\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012BA\u001d\u001e\u0013\t)gM\u0001\u0004WK\u000e$xN\u001d\u0006\u0003su\u0001\"\u0001[7\u000e\u0003%T!A[6\u0002\r\u00154XM\u001c;t\u0015\ta\u0017#A\u0002eC>L!A\\5\u0003%\r{g\u000e\u001e:bGR\u001cF/\u0019;f\u000bZ,g\u000e^\u0001\u0014\u0007>tGO]1diN#\u0018\r^3DC\u000eDWm\u001d\t\u0003I-\u0019\"aC\u000e\u0015\u0003A\fQAY;jY\u0012$\u0002\"^@\u0002\u0014\u0005u\u0011\u0011\u0005\u000b\u0004\u0017Zt\b\"B<\u000e\u0001\bA\u0018\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\tIH0D\u0001{\u0015\tYX$\u0001\u0006d_:\u001cWO\u001d:f]RL!! >\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B!\u000e\u0001\b\u0011\u0005bBA\u0001\u001b\u0001\u0007\u00111A\u0001\u0012S:LG/[1m\u0007\u0006\u001c\u0007.Z%oI\u0016D\b\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0007_\u001a47/\u001a;\u000b\u0007\u00055Q#\u0001\u0004mK\u0012<WM]\u0005\u0005\u0003#\t9A\u0001\u0004PM\u001a\u001cX\r\u001e\u0005\b\u0003+i\u0001\u0019AA\f\u0003Ui\u0017\r_\"p]R\u0014\u0018m\u0019;t\u0007\u0006\u001c\u0007.Z*ju\u0016\u00042\u0001HA\r\u0013\r\tY\"\b\u0002\u0005\u0019>tw\rC\u0004\u0002 5\u0001\r!a\u0006\u0002\u001f5\f\u0007pS3z\u0007\u0006\u001c\u0007.Z*ju\u0016Dq!a\t\u000e\u0001\u0004\t)#A\u0004nKR\u0014\u0018nY:\u0011\t\u0005\u001d\u00121F\u0007\u0003\u0003SQ1!a\t\u0016\u0013\u0011\ti#!\u000b\u0003\u000f5+GO]5dg\u0002")
public class ContractStateCaches {
    private final StateCache<GlobalKey, ContractKeyStateValue> keyState;
    private final StateCache<Value.ContractId, ContractStateValue> contractState;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;

    public static ContractStateCaches build(Offset initialCacheIndex, long maxContractsCacheSize, long maxKeyCacheSize, Metrics metrics, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ContractStateCaches$.MODULE$.build(initialCacheIndex, maxContractsCacheSize, maxKeyCacheSize, metrics, executionContext, loggingContext);
    }

    public StateCache<GlobalKey, ContractKeyStateValue> keyState() {
        return this.keyState;
    }

    public StateCache<Value.ContractId, ContractStateValue> contractState() {
        return this.contractState;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public void push(Vector<ContractStateEvent> eventsBatch) {
        block2: {
            block1: {
                if (!eventsBatch.isEmpty()) break block1;
                this.logger().error().apply((Function0 & Serializable)() -> "push triggered with empty events batch", this.loggingContext);
                break block2;
            }
            Builder keyMappingsBuilder = Predef$.MODULE$.Map().newBuilder();
            Builder contractMappingsBuilder = Predef$.MODULE$.Map().newBuilder();
            eventsBatch.foreach((Function1 & Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                ContractStateEvent contractStateEvent = x0$1;
                if (contractStateEvent instanceof ContractStateEvent.Created) {
                    ContractStateEvent.Created created = (ContractStateEvent.Created)contractStateEvent;
                    created.globalKey().foreach((Function1 & Serializable)key -> (Builder)keyMappingsBuilder.addOne((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)new ContractKeyStateValue.Assigned(created.contractId(), created.stakeholders()))));
                    boxedUnit = contractMappingsBuilder.addOne((Object)new Tuple2((Object)created.contractId(), (Object)new ContractStateValue.Active(created.contract(), created.stakeholders(), created.ledgerEffectiveTime())));
                } else if (contractStateEvent instanceof ContractStateEvent.Archived) {
                    ContractStateEvent.Archived archived = (ContractStateEvent.Archived)contractStateEvent;
                    archived.globalKey().foreach((Function1 & Serializable)key -> (Builder)keyMappingsBuilder.addOne((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)ContractKeyStateValue$Unassigned$.MODULE$)));
                    boxedUnit = contractMappingsBuilder.addOne((Object)new Tuple2((Object)archived.contractId(), (Object)new ContractStateValue.Archived(archived.stakeholders())));
                } else if (contractStateEvent instanceof ContractStateEvent.LedgerEndMarker) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)contractStateEvent);
                }
                return boxedUnit;
            });
            Map keyMappings = (Map)keyMappingsBuilder.result();
            Map contractMappings = (Map)contractMappingsBuilder.result();
            Offset validAt = ((ContractStateEvent)eventsBatch.last()).eventOffset();
            if (keyMappings.nonEmpty()) {
                this.keyState().putBatch(validAt, (Map<GlobalKey, ContractKeyStateValue>)keyMappings, this.loggingContext);
            }
            if (!contractMappings.nonEmpty()) break block2;
            this.contractState().putBatch(validAt, (Map<Value.ContractId, ContractStateValue>)contractMappings, this.loggingContext);
        }
    }

    public ContractStateCaches(StateCache<GlobalKey, ContractKeyStateValue> keyState, StateCache<Value.ContractId, ContractStateValue> contractState, LoggingContext loggingContext) {
        this.keyState = keyState;
        this.contractState = contractState;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

