/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.cache;

import com.codahale.metrics.Timer;
import com.daml.caching.Cache;
import com.daml.ledger.offset.Offset;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Timed$;
import com.daml.platform.store.cache.MutableCacheBackedContractStore;
import com.daml.platform.store.cache.StateCache$;
import com.daml.platform.store.cache.StateCache$PendingUpdatesState$;
import com.daml.scalautil.Statement$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rEd!\u0002#F\u0001&{\u0005\u0002C4\u0001\u0005+\u0007I\u0011\u00015\t\u0011E\u0004!\u0011#Q\u0001\n%D\u0001B\u0012\u0001\u0003\u0016\u0004%\tA\u001d\u0005\n\u0003\u001f\u0001!\u0011#Q\u0001\nMD!\"!\u0005\u0001\u0005+\u0007I\u0011AA\n\u0011)\t)\u0003\u0001B\tB\u0003%\u0011Q\u0003\u0005\u000b\u0003O\u0001!\u0011!Q\u0001\f\u0005%\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003\u0013B\u0001\"a\u0016\u0001A\u0003%\u00111\n\u0005\u000b\u00033\u0002!\u0019!C\u0001\u000b\u0006m\u0003\u0002\u0003BS\u0001\u0001\u0006I!!\u0018\t\u0013\t\u001d\u0006\u00011A\u0005\u0002\u0015C\u0007B\u0003BU\u0001\u0001\u0007I\u0011A#\u0003,\"9!q\u0016\u0001!B\u0013I\u0007b\u0002B]\u0001\u0011\u0005!1\u0018\u0005\b\u0005\u001f\u0004A\u0011\u0001Bi\u0011\u001d\u0011i\u000f\u0001C\u0001\u0005_Dqaa\u0002\u0001\t\u0013\u0019I\u0001C\u0004\u0004\u001a\u0001!Iaa\u0007\t\u000f\r\r\u0002\u0001\"\u0003\u0004&!I\u0011Q\u001a\u0001\u0002\u0002\u0013\u000511\u0006\u0005\n\u0003+\u0004\u0011\u0013!C\u0001\u0007\u000bB\u0011\"!<\u0001#\u0003%\taa\u0013\t\u0013\rU\u0003!%A\u0005\u0002\r]\u0003\"CAz\u0001\u0005\u0005I\u0011IA{\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0011)\u0001C\u0005\u0003\u000e\u0001\t\t\u0011\"\u0001\u0004b!I!1\u0003\u0001\u0002\u0002\u0013\u0005#Q\u0003\u0005\n\u0005?\u0001\u0011\u0011!C\u0001\u0007KB\u0011Ba\u000b\u0001\u0003\u0003%\te!\u001b\t\u0013\tE\u0002!!A\u0005B\tM\u0002\"\u0003B\u001b\u0001\u0005\u0005I\u0011\tB\u001c\u0011%\u0011I\u0004AA\u0001\n\u0003\u001aigB\u0004\u0002\u0006\u0016C\t!a\"\u0007\r\u0011+\u0005\u0012AAE\u0011\u001d\t)\u0004\nC\u0001\u000333q!a'%\u0001\u0016\u000bi\n\u0003\u0006\u0002 \u001a\u0012\t\u001a!C\u0001\u0003CC!\"!+'\u0005\u0003\u0007I\u0011AAV\u0011)\t9L\nB\tB\u0003&\u00111\u0015\u0005\n\u0003s3#\u00113A\u0005\u0002!D!\"a/'\u0005\u0003\u0007I\u0011AA_\u0011%\t\tM\nB\tB\u0003&\u0011\u000eC\u0004\u00026\u0019\"\t!a1\t\u0013\u00055g%!A\u0005\u0002\u0005=\u0007\"CAkME\u0005I\u0011AAl\u0011%\tiOJI\u0001\n\u0003\ty\u000fC\u0005\u0002t\u001a\n\t\u0011\"\u0011\u0002v\"I!1\u0001\u0014\u0002\u0002\u0013\u0005!Q\u0001\u0005\n\u0005\u001b1\u0013\u0011!C\u0001\u0005\u001fA\u0011Ba\u0005'\u0003\u0003%\tE!\u0006\t\u0013\t}a%!A\u0005\u0002\t\u0005\u0002\"\u0003B\u0016M\u0005\u0005I\u0011\tB\u0017\u0011%\u0011\tDJA\u0001\n\u0003\u0012\u0019\u0004C\u0005\u00036\u0019\n\t\u0011\"\u0011\u00038!I!\u0011\b\u0014\u0002\u0002\u0013\u0005#1H\u0004\t\u0005\u007f!\u0003\u0012A#\u0003B\u0019A\u00111\u0014\u0013\t\u0002\u0015\u0013\u0019\u0005C\u0004\u00026m\"\tA!\u0012\t\u000f\t\u001d3\b\"\u0001\u0003J!I!1J\u001e\u0002\u0002\u0013\u0005%Q\n\u0005\n\u0005'Z\u0014\u0011!CA\u0005+B\u0011Ba\u001a<\u0003\u0003%IA!\u001b\t\u0013\t-C%!A\u0005\u0002\nE\u0004\"\u0003B*I\u0005\u0005I\u0011\u0011BF\u0011%\u00119\u0007JA\u0001\n\u0013\u0011IG\u0001\u0006Ti\u0006$XmQ1dQ\u0016T!AR$\u0002\u000b\r\f7\r[3\u000b\u0005!K\u0015!B:u_J,'B\u0001&L\u0003!\u0001H.\u0019;g_Jl'B\u0001'N\u0003\u0011!\u0017-\u001c7\u000b\u00039\u000b1aY8n+\u0011\u000160a\u0003\u0014\t\u0001\tvK\u0017\t\u0003%Vk\u0011a\u0015\u0006\u0002)\u0006)1oY1mC&\u0011ak\u0015\u0002\u0007\u0003:L(+\u001a4\u0011\u0005IC\u0016BA-T\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u00173\u000f\u0005q\u0013gBA/b\u001b\u0005q&BA0a\u0003\u0019a$o\\8u}\r\u0001\u0011\"\u0001+\n\u0005\r\u001c\u0016a\u00029bG.\fw-Z\u0005\u0003K\u001a\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!aY*\u0002#%t\u0017\u000e^5bY\u000e\u000b7\r[3J]\u0012,\u00070F\u0001j!\tQw.D\u0001l\u0015\taW.\u0001\u0004pM\u001a\u001cX\r\u001e\u0006\u0003].\u000ba\u0001\\3eO\u0016\u0014\u0018B\u00019l\u0005\u0019yeMZ:fi\u0006\u0011\u0012N\\5uS\u0006d7)Y2iK&sG-\u001a=!+\u0005\u0019\b#\u0002;xs\u0006%Q\"A;\u000b\u0005Y\\\u0015aB2bG\"LgnZ\u0005\u0003qV\u0014QaQ1dQ\u0016\u0004\"A_>\r\u0001\u0011)A\u0010\u0001b\u0001{\n\t1*E\u0002\u007f\u0003\u0007\u0001\"AU@\n\u0007\u0005\u00051KA\u0004O_RD\u0017N\\4\u0011\u0007I\u000b)!C\u0002\u0002\bM\u00131!\u00118z!\rQ\u00181\u0002\u0003\u0007\u0003\u001b\u0001!\u0019A?\u0003\u0003Y\u000baaY1dQ\u0016\u0004\u0013a\u0005:fO&\u001cH/\u001a:Va\u0012\fG/\u001a+j[\u0016\u0014XCAA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tq!\\3ue&\u001c7OC\u0002\u0002 5\u000b\u0001bY8eC\"\fG.Z\u0005\u0005\u0003G\tIBA\u0003US6,'/\u0001\u000bsK\u001eL7\u000f^3s+B$\u0017\r^3US6,'\u000fI\u0001\u0003K\u000e\u0004B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_\u0019\u0016AC2p]\u000e,(O]3oi&!\u00111GA\u0017\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\t\u0003s\t\t%a\u0011\u0002FQ!\u00111HA !\u0019\ti\u0004A=\u0002\n5\tQ\tC\u0004\u0002(!\u0001\u001d!!\u000b\t\u000b\u001dD\u0001\u0019A5\t\u000b\u0019C\u0001\u0019A:\t\u000f\u0005E\u0001\u00021\u0001\u0002\u0016\u00051An\\4hKJ,\"!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015L\u0003\u001dawnZ4j]\u001eLA!!\u0016\u0002P\t!2i\u001c8uKb$X/\u00197ju\u0016$Gj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\bqK:$\u0017N\\4Va\u0012\fG/Z:\u0016\u0005\u0005u\u0003cBA0\u0003SJ\u0018QN\u0007\u0003\u0003CRA!a\u0019\u0002f\u00059Q.\u001e;bE2,'bAA4'\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\u0004\u001b\u0006\u0004\bcAA8M9\u0019\u0011\u0011O\u0012\u000f\t\u0005M\u00141\u0011\b\u0005\u0003k\n\tI\u0004\u0003\u0002x\u0005}d\u0002BA=\u0003{r1!XA>\u0013\u0005q\u0015B\u0001'N\u0013\tQ5*\u0003\u0002I\u0013&\u0011aiR\u0001\u000b'R\fG/Z\"bG\",\u0007cAA\u001fIM!A%UAF!\u0011\ti)a&\u000e\u0005\u0005=%\u0002BAI\u0003'\u000b!![8\u000b\u0005\u0005U\u0015\u0001\u00026bm\u0006L1!ZAH)\t\t9IA\nQK:$\u0017N\\4Va\u0012\fG/Z:Ti\u0006$Xm\u0005\u0003'#^S\u0016\u0001\u00049f]\u0012LgnZ\"pk:$XCAAR!\r\u0011\u0016QU\u0005\u0004\u0003O\u001b&\u0001\u0002'p]\u001e\f\u0001\u0003]3oI&twmQ8v]R|F%Z9\u0015\t\u00055\u00161\u0017\t\u0004%\u0006=\u0016bAAY'\n!QK\\5u\u0011%\t)\fKA\u0001\u0002\u0004\t\u0019+A\u0002yIE\nQ\u0002]3oI&twmQ8v]R\u0004\u0013!\u00047bi\u0016\u001cHOV1mS\u0012\fE/A\tmCR,7\u000f\u001e,bY&$\u0017\t^0%KF$B!!,\u0002@\"A\u0011QW\u0016\u0002\u0002\u0003\u0007\u0011.\u0001\bmCR,7\u000f\u001e,bY&$\u0017\t\u001e\u0011\u0015\r\u0005\u0015\u0017\u0011ZAf!\r\t9MJ\u0007\u0002I!9\u0011qT\u0017A\u0002\u0005\r\u0006BBA][\u0001\u0007\u0011.\u0001\u0003d_BLHCBAc\u0003#\f\u0019\u000eC\u0005\u0002 :\u0002\n\u00111\u0001\u0002$\"A\u0011\u0011\u0018\u0018\u0011\u0002\u0003\u0007\u0011.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e'\u0006BAR\u00037\\#!!8\u0011\t\u0005}\u0017\u0011^\u0007\u0003\u0003CTA!a9\u0002f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O\u001c\u0016AC1o]>$\u0018\r^5p]&!\u00111^Aq\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tPK\u0002j\u00037\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA|!\u0011\tI0a@\u000e\u0005\u0005m(\u0002BA\u007f\u0003'\u000bA\u0001\\1oO&!!\u0011AA~\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\u0001\t\u0004%\n%\u0011b\u0001B\u0006'\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111\u0001B\t\u0011%\t)lMA\u0001\u0002\u0004\u00119!A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u0002\u0005\u0004\u0003\u001a\tm\u00111A\u0007\u0003\u0003KJAA!\b\u0002f\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\u0019C!\u000b\u0011\u0007I\u0013)#C\u0002\u0003(M\u0013qAQ8pY\u0016\fg\u000eC\u0005\u00026V\n\t\u00111\u0001\u0002\u0004\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9Pa\f\t\u0013\u0005Uf'!AA\u0002\t\u001d\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t\u001d\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0003$\tu\u0002\"CA[s\u0005\u0005\t\u0019AA\u0002\u0003M\u0001VM\u001c3j]\u001e,\u0006\u000fZ1uKN\u001cF/\u0019;f!\r\t9mO\n\u0005wE\u000bY\t\u0006\u0002\u0003B\u0005)Q-\u001c9usV\u0011\u0011QY\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003\u000b\u0014yE!\u0015\t\u000f\u0005}e\b1\u0001\u0002$\"1\u0011\u0011\u0018 A\u0002%\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003X\t\r\u0004#\u0002*\u0003Z\tu\u0013b\u0001B.'\n1q\n\u001d;j_:\u0004bA\u0015B0\u0003GK\u0017b\u0001B1'\n1A+\u001e9mKJB\u0011B!\u001a@\u0003\u0003\u0005\r!!2\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003lA!\u0011\u0011 B7\u0013\u0011\u0011y'a?\u0003\r=\u0013'.Z2u+\u0019\u0011\u0019Ha\u001f\u0003\u0000QA!Q\u000fBB\u0005\u000b\u0013I\t\u0006\u0003\u0003x\t\u0005\u0005cBA\u001f\u0001\te$Q\u0010\t\u0004u\nmD!\u0002?B\u0005\u0004i\bc\u0001>\u0003\u0000\u00111\u0011QB!C\u0002uDq!a\nB\u0001\b\tI\u0003C\u0003h\u0003\u0002\u0007\u0011\u000e\u0003\u0004G\u0003\u0002\u0007!q\u0011\t\u0007i^\u0014IH! \t\u000f\u0005E\u0011\t1\u0001\u0002\u0016U1!Q\u0012BN\u0005?#BAa$\u0003\"B)!K!\u0017\u0003\u0012BA!Ka%j\u0005/\u000b)\"C\u0002\u0003\u0016N\u0013a\u0001V;qY\u0016\u001c\u0004C\u0002;x\u00053\u0013i\nE\u0002{\u00057#Q\u0001 \"C\u0002u\u00042A\u001fBP\t\u0019\tiA\u0011b\u0001{\"I!Q\r\"\u0002\u0002\u0003\u0007!1\u0015\t\b\u0003{\u0001!\u0011\u0014BO\u0003=\u0001XM\u001c3j]\u001e,\u0006\u000fZ1uKN\u0004\u0013AC2bG\",\u0017J\u001c3fq\u0006q1-Y2iK&sG-\u001a=`I\u0015\fH\u0003BAW\u0005[C\u0001\"!.\u000f\u0003\u0003\u0005\r![\u0001\fG\u0006\u001c\u0007.Z%oI\u0016D\b\u0005K\u0002\u0010\u0005g\u00032A\u0015B[\u0013\r\u00119l\u0015\u0002\tm>d\u0017\r^5mK\u0006\u0019q-\u001a;\u0015\t\tu&1\u001a\u000b\u0005\u0005\u007f\u0013\t\rE\u0003S\u00053\nI\u0001C\u0004\u0003DB\u0001\u001dA!2\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB!\u0011Q\nBd\u0013\u0011\u0011I-a\u0014\u0003\u001d1{wmZ5oO\u000e{g\u000e^3yi\"1!Q\u001a\tA\u0002e\f1a[3z\u0003!\u0001X\u000f\u001e\"bi\u000eDGC\u0002Bj\u0005/\u0014Y\u000e\u0006\u0003\u0002.\nU\u0007b\u0002Bb#\u0001\u000f!Q\u0019\u0005\u0007\u00053\f\u0002\u0019A5\u0002\u000fY\fG.\u001b3Bi\"9!Q\\\tA\u0002\t}\u0017!\u00022bi\u000eD\u0007c\u0002Bq\u0005SL\u0018\u0011\u0002\b\u0005\u0005G\u0014)\u000f\u0005\u0002^'&\u0019!q]*\u0002\rA\u0013X\rZ3g\u0013\u0011\tYGa;\u000b\u0007\t\u001d8+\u0001\u0005qkR\f5/\u001f8d)\u0019\u0011\tPa?\u0003~R!!1\u001fB}!\u0019\tYC!>\u0002\n%!!q_A\u0017\u0005\u00191U\u000f^;sK\"9!1\u0019\nA\u0004\t\u0015\u0007B\u0002Bg%\u0001\u0007\u0011\u0010C\u0004\u0003\u0000J\u0001\ra!\u0001\u0002\u0015\u0019,Go\u00195Bgft7\r\u0005\u0004S\u0007\u0007I'1_\u0005\u0004\u0007\u000b\u0019&!\u0003$v]\u000e$\u0018n\u001c82\u0003m\u0011XmZ5ti\u0016\u0014XI^3oiV\fGnQ1dQ\u0016,\u0006\u000fZ1uKRA11BB\t\u0007'\u00199\u0002\u0006\u0003\u0004\u000e\r=\u0001CBA\u0016\u0005k\fi\u000bC\u0004\u0003DN\u0001\u001dA!2\t\r\t57\u00031\u0001z\u0011\u001d\u0019)b\u0005a\u0001\u0005g\fa\"\u001a<f]R,\u0018\r\\+qI\u0006$X\r\u0003\u0004\u0003ZN\u0001\r![\u0001\u0012e\u0016lwN^3Ge>l\u0007+\u001a8eS:<G\u0003BB\u000f\u0007C!B!!,\u0004 !9!1\u0019\u000bA\u0004\t\u0015\u0007B\u0002Bg)\u0001\u0007\u00110A\fueVt7-\u0019;f-\u0006dW/\u001a$pe2{wmZ5oOR!\u0011q_B\u0014\u0011\u001d\u0019I#\u0006a\u0001\u0003\u0013\tQA^1mk\u0016,ba!\f\u00046\reB\u0003CB\u0018\u0007{\u0019yda\u0011\u0015\t\rE21\b\t\b\u0003{\u000111GB\u001c!\rQ8Q\u0007\u0003\u0006yZ\u0011\r! \t\u0004u\u000eeBABA\u0007-\t\u0007Q\u0010C\u0004\u0002(Y\u0001\u001d!!\u000b\t\u000f\u001d4\u0002\u0013!a\u0001S\"AaI\u0006I\u0001\u0002\u0004\u0019\t\u0005\u0005\u0004uo\u000eM2q\u0007\u0005\n\u0003#1\u0002\u0013!a\u0001\u0003+)b!a<\u0004H\r%C!\u0002?\u0018\u0005\u0004iHABA\u0007/\t\u0007Q0\u0006\u0004\u0004N\rE31K\u000b\u0003\u0007\u001fR3a]An\t\u0015a\bD1\u0001~\t\u0019\ti\u0001\u0007b\u0001{\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCBB-\u0007;\u001ay&\u0006\u0002\u0004\\)\"\u0011QCAn\t\u0015a\u0018D1\u0001~\t\u0019\ti!\u0007b\u0001{R!\u00111AB2\u0011%\t)\fHA\u0001\u0002\u0004\u00119\u0001\u0006\u0003\u0003$\r\u001d\u0004\"CA[=\u0005\u0005\t\u0019AA\u0002)\u0011\t9pa\u001b\t\u0013\u0005Uv$!AA\u0002\t\u001dA\u0003\u0002B\u0012\u0007_B\u0011\"!.#\u0003\u0003\u0005\r!a\u0001")
public class StateCache<K, V>
implements Product,
Serializable {
    private final Offset initialCacheIndex;
    private final Cache<K, V> cache;
    private final Timer registerUpdateTimer;
    private final ExecutionContext ec;
    private final ContextualizedLogger com$daml$platform$store$cache$StateCache$$logger;
    private final Map<K, PendingUpdatesState> pendingUpdates;
    private volatile Offset cacheIndex;

    public static <K, V> Option<Tuple3<Offset, Cache<K, V>, Timer>> unapply(StateCache<K, V> x$0) {
        return StateCache$.MODULE$.unapply(x$0);
    }

    public static <K, V> StateCache<K, V> apply(Offset initialCacheIndex, Cache<K, V> cache, Timer registerUpdateTimer, ExecutionContext ec) {
        return StateCache$.MODULE$.apply(initialCacheIndex, cache, registerUpdateTimer, ec);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Offset initialCacheIndex() {
        return this.initialCacheIndex;
    }

    public Cache<K, V> cache() {
        return this.cache;
    }

    public Timer registerUpdateTimer() {
        return this.registerUpdateTimer;
    }

    public ContextualizedLogger com$daml$platform$store$cache$StateCache$$logger() {
        return this.com$daml$platform$store$cache$StateCache$$logger;
    }

    public Map<K, PendingUpdatesState> pendingUpdates() {
        return this.pendingUpdates;
    }

    public Offset cacheIndex() {
        return this.cacheIndex;
    }

    public void cacheIndex_$eq(Offset x$1) {
        this.cacheIndex = x$1;
    }

    public Option<V> get(K key, LoggingContext loggingContext) {
        None$ none$;
        Option option = this.cache().getIfPresent(key);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object value = some.value();
            this.com$daml$platform$store$cache$StateCache$$logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(18).append("Cache hit for ").append(key).append(" -> ").append(this.truncateValueForLogging(value)).toString(), loggingContext);
            none$ = new Some(value);
        } else if (None$.MODULE$.equals(option)) {
            this.com$daml$platform$store$cache$StateCache$$logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(16).append("Cache miss for ").append(key).append(" ").toString(), loggingContext);
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    public void putBatch(Offset validAt, scala.collection.immutable.Map<K, V> batch, LoggingContext loggingContext) {
        Timed$.MODULE$.value(this.registerUpdateTimer(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Map map = this.pendingUpdates();
            synchronized (map) {
                if (validAt.$greater((Object)this.cacheIndex())) {
                    batch.keySet().foreach((Function1 & Serializable)key -> {
                        StateCache.$anonfun$putBatch$2(this, validAt, key);
                        return BoxedUnit.UNIT;
                    });
                    this.cacheIndex_$eq(validAt);
                    this.cache().putAll(batch);
                    this.com$daml$platform$store$cache$StateCache$$logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(34).append("Updated cache with a batch of ").append(((IterableOnceOps)batch.map((Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string = new StringBuilder(4).append(k).append(" -> ").append(this.truncateValueForLogging(v)).toString();
                        return string;
                    })).mkString("[", ", ", "]")).append(" at ").append(validAt).toString(), loggingContext);
                } else {
                    this.com$daml$platform$store$cache$StateCache$$logger().warn().apply((Function0 & Serializable)() -> new StringBuilder(89).append("Ignoring incoming synchronous update at an index (").append(validAt).append(") equal to or before the cache index (").append(this.cacheIndex()).append(")").toString(), loggingContext);
                }
            }
        });
    }

    public Future<V> putAsync(K key, Function1<Offset, Future<V>> fetchAsync, LoggingContext loggingContext) {
        return (Future)Timed$.MODULE$.value(this.registerUpdateTimer(), (Function0 & Serializable)() -> {
            Future future;
            Map map = this.pendingUpdates();
            synchronized (map) {
                Future future2;
                Offset validAt = this.cacheIndex();
                Future eventualValue = Future$.MODULE$.delegate((Function0 & Serializable)() -> (Future)fetchAsync.apply((Object)validAt), $this.ec);
                PendingUpdatesState pendingUpdatesForKey = (PendingUpdatesState)this.pendingUpdates().getOrElseUpdate(key, (Function0 & Serializable)() -> StateCache$PendingUpdatesState$.MODULE$.empty());
                if (pendingUpdatesForKey.latestValidAt().$less((Object)validAt)) {
                    pendingUpdatesForKey.latestValidAt_$eq(validAt);
                    pendingUpdatesForKey.pendingCount_$eq(pendingUpdatesForKey.pendingCount() + 1L);
                    future2 = this.registerEventualCacheUpdate(key, eventualValue, validAt, loggingContext).flatMap((Function1 & Serializable)x$2 -> eventualValue, $this.ec);
                } else {
                    future2 = eventualValue;
                }
                future = future2;
            }
            return future;
        });
    }

    private Future<BoxedUnit> registerEventualCacheUpdate(K key, Future<V> eventualUpdate, Offset validAt, LoggingContext loggingContext) {
        return eventualUpdate.map((Function1 & Serializable)value -> {
            StateCache.$anonfun$registerEventualCacheUpdate$1(this, key, validAt, loggingContext, value);
            return BoxedUnit.UNIT;
        }, this.ec).recover((PartialFunction)new Serializable(this, key, loggingContext){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ StateCache $outer;
            private final Object key$3;
            private final LoggingContext loggingContext$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (A1 instanceof MutableCacheBackedContractStore.ContractReadThroughNotFound) {
                    MutableCacheBackedContractStore.ContractReadThroughNotFound contractReadThroughNotFound = (MutableCacheBackedContractStore.ContractReadThroughNotFound)A1;
                    Map<K, PendingUpdatesState> map = this.$outer.pendingUpdates();
                    synchronized (map) {
                        this.$outer.com$daml$platform$store$cache$StateCache$$removeFromPending(this.key$3, this.loggingContext$3);
                    }
                    this.$outer.com$daml$platform$store$cache$StateCache$$logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(48).append("Not caching negative lookup for contract at key ").append($this.key$3).toString(), (Throwable)contractReadThroughNotFound, this.loggingContext$3);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Map<K, PendingUpdatesState> map = this.$outer.pendingUpdates();
                    synchronized (map) {
                        this.$outer.com$daml$platform$store$cache$StateCache$$removeFromPending(this.key$3, this.loggingContext$3);
                    }
                    this.$outer.com$daml$platform$store$cache$StateCache$$logger().warn().apply((Function0 & Serializable)() -> new StringBuilder(40).append("Failure in pending cache update for key ").append($this.key$3).toString(), A1, this.loggingContext$3);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof MutableCacheBackedContractStore.ContractReadThroughNotFound ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$3 = key$3;
                this.loggingContext$3 = loggingContext$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.platform.store.cache.StateCache$$anonfun$registerEventualCacheUpdate$6 ), $anonfun$applyOrElse$2(com.daml.platform.store.cache.StateCache$$anonfun$registerEventualCacheUpdate$6 )}, serializedLambda);
            }
        }, this.ec);
    }

    public void com$daml$platform$store$cache$StateCache$$removeFromPending(K key, LoggingContext loggingContext) {
        Statement$.MODULE$.discard(this.pendingUpdates().get(key).map((Function1 & Serializable)pendingForKey -> {
            pendingForKey.pendingCount_$eq(pendingForKey.pendingCount() - 1L);
            return pendingForKey.pendingCount() == 0L ? this.pendingUpdates().$minus$eq(key) : BoxedUnit.UNIT;
        }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> this.com$daml$platform$store$cache$StateCache$$logger().error().apply((Function0 & Serializable)() -> new StringBuilder(52).append("Expected pending updates tracker for key ").append(key).append(" is missing").toString(), loggingContext)));
    }

    /*
     * WARNING - void declaration
     */
    private String truncateValueForLogging(V value) {
        void var2_2;
        String stringValueRepr = value.toString();
        int maxValueLength = 250;
        return stringValueRepr.length() > maxValueLength ? new StringBuilder(3).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(stringValueRepr), maxValueLength)).append("...").toString() : var2_2;
    }

    public <K, V> StateCache<K, V> copy(Offset initialCacheIndex, Cache<K, V> cache, Timer registerUpdateTimer, ExecutionContext ec) {
        return new StateCache<K, V>(initialCacheIndex, cache, registerUpdateTimer, ec);
    }

    public <K, V> Offset copy$default$1() {
        return this.initialCacheIndex();
    }

    public <K, V> Cache<K, V> copy$default$2() {
        return this.cache();
    }

    public <K, V> Timer copy$default$3() {
        return this.registerUpdateTimer();
    }

    public String productPrefix() {
        return "StateCache";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.initialCacheIndex();
                break;
            }
            case 1: {
                object = this.cache();
                break;
            }
            case 2: {
                object = this.registerUpdateTimer();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StateCache;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "initialCacheIndex";
                break;
            }
            case 1: {
                string = "cache";
                break;
            }
            case 2: {
                string = "registerUpdateTimer";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StateCache)) return false;
        boolean bl = true;
        if (!bl) return false;
        StateCache stateCache = (StateCache)x$1;
        Offset offset = this.initialCacheIndex();
        Offset offset2 = stateCache.initialCacheIndex();
        if (offset == null) {
            if (offset2 != null) {
                return false;
            }
        } else if (!offset.equals(offset2)) return false;
        Cache<K, V> cache = this.cache();
        Cache<K, V> cache2 = stateCache.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        Timer timer = this.registerUpdateTimer();
        Timer timer2 = stateCache.registerUpdateTimer();
        if (timer == null) {
            if (timer2 != null) {
                return false;
            }
        } else if (!timer.equals(timer2)) return false;
        if (!stateCache.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$putBatch$2(StateCache $this, Offset validAt$1, Object key) {
        $this.pendingUpdates().get(key).foreach((Function1 & Serializable)x$1 -> {
            x$1.latestValidAt_$eq(validAt$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$registerEventualCacheUpdate$2(StateCache $this, Offset validAt$3, Object key$3, Object value$2, LoggingContext loggingContext$3, PendingUpdatesState pendingForKey) {
        Offset offset = pendingForKey.latestValidAt();
        Offset offset2 = validAt$3;
        if (!(offset != null ? !offset.equals(offset2) : offset2 != null)) {
            $this.cache().put(key$3, value$2);
            $this.com$daml$platform$store$cache$StateCache$$logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(28).append("Updated cache for ").append(key$3).append(" with ").append($this.truncateValueForLogging(value$2)).append(" at ").append(validAt$3).toString(), loggingContext$3);
        }
        $this.com$daml$platform$store$cache$StateCache$$removeFromPending(key$3, loggingContext$3);
    }

    public static final /* synthetic */ void $anonfun$registerEventualCacheUpdate$1(StateCache $this, Object key$3, Offset validAt$3, LoggingContext loggingContext$3, Object value) {
        Map map = $this.pendingUpdates();
        synchronized (map) {
            $this.pendingUpdates().get(key$3).map((Function1 & Serializable)pendingForKey -> {
                StateCache.$anonfun$registerEventualCacheUpdate$2($this, validAt$3, key$3, value, loggingContext$3, pendingForKey);
                return BoxedUnit.UNIT;
            }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.com$daml$platform$store$cache$StateCache$$logger().error().apply((Function0 & Serializable)() -> new StringBuilder(44).append("Pending updates tracker for ").append(key$3).append(" not registered ").toString(), loggingContext$3));
        }
    }

    public StateCache(Offset initialCacheIndex, Cache<K, V> cache, Timer registerUpdateTimer, ExecutionContext ec) {
        this.initialCacheIndex = initialCacheIndex;
        this.cache = cache;
        this.registerUpdateTimer = registerUpdateTimer;
        this.ec = ec;
        Product.$init$((Product)this);
        this.com$daml$platform$store$cache$StateCache$$logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.pendingUpdates = (Map)Map$.MODULE$.empty();
        this.cacheIndex = initialCacheIndex;
    }

    public static class PendingUpdatesState
    implements Product,
    Serializable {
        private long pendingCount;
        private Offset latestValidAt;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long pendingCount() {
            return this.pendingCount;
        }

        public void pendingCount_$eq(long x$1) {
            this.pendingCount = x$1;
        }

        public Offset latestValidAt() {
            return this.latestValidAt;
        }

        public void latestValidAt_$eq(Offset x$1) {
            this.latestValidAt = x$1;
        }

        public PendingUpdatesState copy(long pendingCount, Offset latestValidAt) {
            return new PendingUpdatesState(pendingCount, latestValidAt);
        }

        public long copy$default$1() {
            return this.pendingCount();
        }

        public Offset copy$default$2() {
            return this.latestValidAt();
        }

        public String productPrefix() {
            return "PendingUpdatesState";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.pendingCount());
                    break;
                }
                case 1: {
                    object = this.latestValidAt();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PendingUpdatesState;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "pendingCount";
                    break;
                }
                case 1: {
                    string = "latestValidAt";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.pendingCount()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.latestValidAt()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PendingUpdatesState)) return false;
            boolean bl = true;
            if (!bl) return false;
            PendingUpdatesState pendingUpdatesState = (PendingUpdatesState)x$1;
            if (this.pendingCount() != pendingUpdatesState.pendingCount()) return false;
            Offset offset = this.latestValidAt();
            Offset offset2 = pendingUpdatesState.latestValidAt();
            if (offset == null) {
                if (offset2 != null) {
                    return false;
                }
            } else if (!offset.equals(offset2)) return false;
            if (!pendingUpdatesState.canEqual(this)) return false;
            return true;
        }

        public PendingUpdatesState(long pendingCount, Offset latestValidAt) {
            this.pendingCount = pendingCount;
            this.latestValidAt = latestValidAt;
            Product.$init$((Product)this);
        }
    }
}

