/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao;

import com.daml.ledger.api.health.HealthStatus;
import com.daml.ledger.api.health.Healthy$;
import com.daml.ledger.api.health.Unhealthy$;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.ResourceOwner$;
import com.daml.metrics.DatabaseMetrics;
import com.daml.metrics.Timed$;
import com.daml.platform.store.dao.JdbcConnectionProvider;
import com.daml.resources.AbstractResourceOwner;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Connection;
import java.sql.SQLTransientConnectionException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class DataSourceConnectionProvider$ {
    public static final DataSourceConnectionProvider$ MODULE$ = new DataSourceConnectionProvider$();
    private static final int com$daml$platform$store$dao$DataSourceConnectionProvider$$MaxTransientFailureCount = 5;
    private static final FiniteDuration HealthPollingSchedule = new package.DurationInt(package$.MODULE$.DurationInt(1)).second();

    public int com$daml$platform$store$dao$DataSourceConnectionProvider$$MaxTransientFailureCount() {
        return com$daml$platform$store$dao$DataSourceConnectionProvider$$MaxTransientFailureCount;
    }

    private FiniteDuration HealthPollingSchedule() {
        return HealthPollingSchedule;
    }

    public AbstractResourceOwner<ResourceContext, JdbcConnectionProvider> owner(DataSource dataSource) {
        return ResourceOwner$.MODULE$.forTimer((Function0 & Serializable)() -> new Timer("DataSourceConnectionProvider#healthPoller")).map((Function1 & Serializable)healthPoller -> {
            AtomicInteger transientFailureCount = new AtomicInteger(0);
            TimerTask checkHealth = new TimerTask(dataSource, transientFailureCount){
                private final DataSource dataSource$2;
                private final AtomicInteger transientFailureCount$1;

                public void run() {
                    try {
                        this.dataSource$2.getConnection().close();
                        this.transientFailureCount$1.set(0);
                    }
                    catch (SQLTransientConnectionException sQLTransientConnectionException) {
                        int n = this.transientFailureCount$1.incrementAndGet();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    }
                }
                {
                    this.dataSource$2 = dataSource$2;
                    this.transientFailureCount$1 = transientFailureCount$1;
                }
            };
            healthPoller.schedule(checkHealth, 0L, MODULE$.HealthPollingSchedule().toMillis());
            return new JdbcConnectionProvider(dataSource, transientFailureCount){
                private final DataSource dataSource$2;
                private final AtomicInteger transientFailureCount$1;

                public <T> T runSQL(DatabaseMetrics databaseMetrics, Function1<Connection, T> block) {
                    Object object;
                    conn.setAutoCommit(false);
                    try (Connection conn = this.dataSource$2.getConnection();){
                        try {
                            Object res = Timed$.MODULE$.value(databaseMetrics.queryTimer(), (Function0 & Serializable)() -> block.apply((Object)conn));
                            Timed$.MODULE$.value(databaseMetrics.commitTimer(), (Function0)(JFunction0.mcV.sp & Serializable)() -> conn.commit());
                            object = res;
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof SQLTransientConnectionException) {
                                SQLTransientConnectionException sQLTransientConnectionException = (SQLTransientConnectionException)throwable2;
                                this.transientFailureCount$1.incrementAndGet();
                                conn.rollback();
                                throw sQLTransientConnectionException;
                            }
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable t = (Throwable)option.get();
                                conn.rollback();
                                throw t;
                            }
                            throw throwable;
                        }
                    }
                    return (T)object;
                }

                public HealthStatus currentHealth() {
                    return this.transientFailureCount$1.get() < DataSourceConnectionProvider$.MODULE$.com$daml$platform$store$dao$DataSourceConnectionProvider$$MaxTransientFailureCount() ? Healthy$.MODULE$ : Unhealthy$.MODULE$;
                }
                {
                    this.dataSource$2 = dataSource$2;
                    this.transientFailureCount$1 = transientFailureCount$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$runSQL$1(scala.Function1 java.sql.Connection ), $anonfun$runSQL$2(java.sql.Connection )}, serializedLambda);
                }
            };
        });
    }

    private DataSourceConnectionProvider$() {
    }
}

