/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao;

import com.codahale.metrics.Timer;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.ledger.api.health.HealthStatus;
import com.daml.ledger.api.health.ReportsHealth;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.logging.entries.LoggingValue$;
import com.daml.logging.entries.ToLoggingValue$;
import com.daml.metrics.DatabaseMetrics;
import com.daml.platform.store.dao.DatabaseSelfServiceError$;
import com.daml.platform.store.dao.DbDispatcher;
import com.daml.platform.store.dao.JdbcConnectionProvider;
import java.io.Serializable;
import java.sql.Connection;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d!B\b\u0011\u0005AQ\u0002\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011Q\u0002!\u0011!Q\u0001\nUB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0001\"A\u0011\n\u0001B\u0001B\u0003-!\n\u0003\u0004Q\u0001\u0011\u0005\u0001#\u0015\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u0019q\u0006\u0001)A\u00057\"9q\f\u0001b\u0001\n\u0013\u0001\u0007B\u00024\u0001A\u0003%\u0011\rC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003m\u0001\u0011\u0005Q\u000eC\u0004\u0002$\u0001!I!!\n\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@\t\u0001BI\u0019#jgB\fGo\u00195fe&k\u0007\u000f\u001c\u0006\u0003#I\t1\u0001Z1p\u0015\t\u0019B#A\u0003ti>\u0014XM\u0003\u0002\u0016-\u0005A\u0001\u000f\\1uM>\u0014XN\u0003\u0002\u00181\u0005!A-Y7m\u0015\u0005I\u0012aA2p[N!\u0001aG\u0011&!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!eI\u0007\u0002!%\u0011A\u0005\u0005\u0002\r\t\n$\u0015n\u001d9bi\u000eDWM\u001d\t\u0003M5j\u0011a\n\u0006\u0003Q%\na\u0001[3bYRD'B\u0001\u0016,\u0003\r\t\u0007/\u001b\u0006\u0003YY\ta\u0001\\3eO\u0016\u0014\u0018B\u0001\u0018(\u00055\u0011V\r]8siNDU-\u00197uQ\u0006\u00112m\u001c8oK\u000e$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0007\u0001\u0001\"A\t\u001a\n\u0005M\u0002\"A\u0006&eE\u000e\u001cuN\u001c8fGRLwN\u001c)s_ZLG-\u001a:\u0002\u0011\u0015DXmY;u_J\u0004\"AN\u001f\u000e\u0003]R!\u0001O\u001d\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002;w\u0005!Q\u000f^5m\u0015\u0005a\u0014\u0001\u00026bm\u0006L!AP\u001c\u0003\u0011\u0015CXmY;u_J\f\u0001c\u001c<fe\u0006dGnV1jiRKW.\u001a:\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015aB7fiJL7m\u001d\u0006\u0003\u000bb\t\u0001bY8eC\"\fG.Z\u0005\u0003\u000f\n\u0013Q\u0001V5nKJ\fQc\u001c<fe\u0006dG.\u0012=fGV$\u0018n\u001c8US6,'/\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\u0005-sU\"\u0001'\u000b\u000553\u0012a\u00027pO\u001eLgnZ\u0005\u0003\u001f2\u0013a\u0002T8hO&twmQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0006%V3v\u000b\u0017\u000b\u0003'R\u0003\"A\t\u0001\t\u000b%3\u00019\u0001&\t\u000b=2\u0001\u0019A\u0019\t\u000bQ2\u0001\u0019A\u001b\t\u000b}2\u0001\u0019\u0001!\t\u000b!3\u0001\u0019\u0001!\u0002\r1|wmZ3s+\u0005Y\u0006CA&]\u0013\tiFJ\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001b!\t\u0011G-D\u0001d\u0015\tAT$\u0003\u0002fG\nAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b%A\u0007dkJ\u0014XM\u001c;IK\u0006dG\u000f\u001b\u000b\u0002SB\u0011aE[\u0005\u0003W\u001e\u0012A\u0002S3bYRD7\u000b^1ukN\f!\"\u001a=fGV$XmU9m+\tqg\u000fF\u0002p\u0003+!2\u0001]A\u0001)\t\tx\u0010E\u0002ceRL!a]2\u0003\r\u0019+H/\u001e:f!\t)h\u000f\u0004\u0001\u0005\u000b]d!\u0019\u0001=\u0003\u0003Q\u000b\"!\u001f?\u0011\u0005qQ\u0018BA>\u001e\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001H?\n\u0005yl\"aA!os\")\u0011\n\u0004a\u0002\u0015\"9\u00111\u0001\u0007A\u0002\u0005\u0015\u0011aA:rYB1A$a\u0002\u0002\fQL1!!\u0003\u001e\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\u000e\u0005EQBAA\b\u0015\r\t\u0019aO\u0005\u0005\u0003'\tyA\u0001\u0006D_:tWm\u0019;j_:Dq!a\u0006\r\u0001\u0004\tI\"A\beCR\f'-Y:f\u001b\u0016$(/[2t!\u0011\tY\"a\b\u000e\u0005\u0005u!BA\"\u0017\u0013\u0011\t\t#!\b\u0003\u001f\u0011\u000bG/\u00192bg\u0016lU\r\u001e:jGN\fQ\"\u001e9eCR,W*\u001a;sS\u000e\u001cHCBA\u0014\u0003c\t\u0019\u0004\u0006\u0003\u0002*\u0005=\u0002c\u0001\u000f\u0002,%\u0019\u0011QF\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u00136\u0001\u001dA\u0013\u0005\b\u0003/i\u0001\u0019AA\r\u0011\u001d\t)$\u0004a\u0001\u0003o\t\u0011b\u001d;beR,\u00050Z2\u0011\u0007q\tI$C\u0002\u0002<u\u0011A\u0001T8oO\u0006Y\u0001.\u00198eY\u0016,%O]8s)\u0011\t\t%!\u0012\u0015\u0007e\f\u0019\u0005C\u0003J\u001d\u0001\u000f!\nC\u0004\u0002H9\u0001\r!!\u0013\u0002\u0013QD'o\\<bE2,\u0007\u0003BA&\u00037rA!!\u0014\u0002X9!\u0011qJA+\u001b\t\t\tFC\u0002\u0002TA\na\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0007\u0005eS$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0013q\f\u0002\n)\"\u0014xn^1cY\u0016T1!!\u0017\u001e\u0001")
public final class DbDispatcherImpl
implements DbDispatcher,
ReportsHealth {
    private final JdbcConnectionProvider connectionProvider;
    private final Timer overallWaitTimer;
    private final Timer overallExecutionTimer;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final ExecutionContextExecutor executionContext;

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    public HealthStatus currentHealth() {
        return this.connectionProvider.currentHealth();
    }

    @Override
    public <T> Future<T> executeSql(DatabaseMetrics databaseMetrics, Function1<Connection, T> sql, LoggingContext loggingContext2) {
        return (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metric"), (Object)LoggingValue$.MODULE$.from((Object)databaseMetrics.name(), ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
            long startWait = System.nanoTime();
            return Future$.MODULE$.apply((Function0 & Serializable)() -> {
                Object t;
                long waitNanos = System.nanoTime() - startWait;
                this.logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(32).append("Waited ").append((long)((double)waitNanos / 1000000.0)).append(" ms to acquire connection").toString(), loggingContext);
                databaseMetrics.waitTimer().update(waitNanos, TimeUnit.NANOSECONDS);
                $this.overallWaitTimer.update(waitNanos, TimeUnit.NANOSECONDS);
                long startExec = System.nanoTime();
                try {
                    try {
                        t = $this.connectionProvider.runSQL(databaseMetrics, sql);
                    }
                    catch (Throwable throwable) {
                        throw this.handleError(throwable, (LoggingContext)loggingContext);
                    }
                }
                finally {
                    this.updateMetrics(databaseMetrics, startExec, (LoggingContext)loggingContext);
                }
                return t;
            }, (ExecutionContext)this.executionContext());
        }, loggingContext2);
    }

    private void updateMetrics(DatabaseMetrics databaseMetrics, long startExec, LoggingContext loggingContext) {
        try {
            long execNanos = System.nanoTime() - startExec;
            this.logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(21).append("Executed query in ").append((long)((double)execNanos / 1000000.0)).append(" ms").toString(), loggingContext);
            databaseMetrics.executionTimer().update(execNanos, TimeUnit.NANOSECONDS);
            this.overallExecutionTimer.update(execNanos, TimeUnit.NANOSECONDS);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logger().info().apply((Function0 & Serializable)() -> "Got an exception while updating timer metrics. Ignoring.", e, loggingContext);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private Nothing$ handleError(Throwable throwable, LoggingContext loggingContext) {
        Option option;
        DamlContextualizedErrorLogger contextualizedLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        Throwable throwable2 = throwable;
        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
            Throwable e = (Throwable)option.get();
            throw DatabaseSelfServiceError$.MODULE$.apply(e, (ContextualizedErrorLogger)contextualizedLogger);
        }
        if (throwable2 != null) {
            Throwable throwable3 = throwable2;
            this.logger().error().apply((Function0 & Serializable)() -> "Fatal error!", throwable3, loggingContext);
            throw throwable3;
        }
        throw new MatchError((Object)throwable2);
    }

    public static final /* synthetic */ void $anonfun$executionContext$1(DbDispatcherImpl $this, Throwable throwable) {
        $this.logger().error().apply((Function0 & Serializable)() -> "ExecutionContext has failed with an exception", throwable, $this.loggingContext);
    }

    public DbDispatcherImpl(JdbcConnectionProvider connectionProvider, Executor executor, Timer overallWaitTimer, Timer overallExecutionTimer, LoggingContext loggingContext) {
        this.connectionProvider = connectionProvider;
        this.overallWaitTimer = overallWaitTimer;
        this.overallExecutionTimer = overallExecutionTimer;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.executionContext = ExecutionContext$.MODULE$.fromExecutor(executor, (Function1 & Serializable)throwable -> {
            DbDispatcherImpl.$anonfun$executionContext$1(this, throwable);
            return BoxedUnit.UNIT;
        });
    }
}

