/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao.events;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.scaladsl.FlowOps;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.daml.ledger.api.v1.transaction_service.GetTransactionTreesResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsResponse;
import com.daml.ledger.offset.Offset;
import com.daml.lf.data.Ref;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.metrics.Timed$;
import com.daml.platform.store.cache.BufferSlice;
import com.daml.platform.store.cache.EventsBuffer;
import com.daml.platform.store.dao.LedgerDaoTransactionsReader;
import com.daml.platform.store.dao.events.BufferedTransactionsReader;
import com.daml.platform.store.dao.events.LfValueTranslation;
import com.daml.platform.store.dao.events.TransactionLogUpdatesConversions$ToFlatTransaction$;
import com.daml.platform.store.dao.events.TransactionLogUpdatesConversions$ToTransactionTree$;
import com.daml.platform.store.interfaces.TransactionLogUpdate;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BufferedTransactionsReader$ {
    public static final BufferedTransactionsReader$ MODULE$ = new BufferedTransactionsReader$();

    public BufferedTransactionsReader apply(LedgerDaoTransactionsReader delegate, EventsBuffer<TransactionLogUpdate> transactionsBuffer, int eventProcessingParallelism, LfValueTranslation lfValueTranslation, Metrics metrics, ExecutionContext executionContext) {
        LedgerDaoTransactionsReader x$1 = delegate;
        EventsBuffer<TransactionLogUpdate> x$2 = transactionsBuffer;
        Metrics x$3 = metrics;
        Function2 & Serializable x$4 = (Function2 & Serializable)(wildcardParties, templateSpecificParties) -> TransactionLogUpdatesConversions$ToFlatTransaction$.MODULE$.filter((Set<String>)wildcardParties, (Map<Ref.Identifier, Set<String>>)templateSpecificParties);
        Function3 & Serializable x$5 = (Function3 & Serializable)(x$11, x$12, x$13) -> TransactionLogUpdatesConversions$ToFlatTransaction$.MODULE$.toApiTransaction((Map<String, Set<Ref.Identifier>>)x$11, BoxesRunTime.unboxToBoolean((Object)x$12), lfValueTranslation, x$13, executionContext);
        Function1 & Serializable x$6 = (Function1 & Serializable)requestingParties -> (Function1 & Serializable)transaction -> TransactionLogUpdatesConversions$ToTransactionTree$.MODULE$.filter((Set<String>)requestingParties, (TransactionLogUpdate.Transaction)transaction);
        Function3 & Serializable x$7 = (Function3 & Serializable)(x$14, x$15, x$16) -> TransactionLogUpdatesConversions$ToTransactionTree$.MODULE$.toApiTransaction((Set<String>)x$14, BoxesRunTime.unboxToBoolean((Object)x$15), lfValueTranslation, x$16, executionContext);
        int x$8 = eventProcessingParallelism;
        return new BufferedTransactionsReader(x$1, x$2, x$8, (Function2<Set<String>, Map<Ref.Identifier, Set<String>>, Function1<TransactionLogUpdate.Transaction, Option<TransactionLogUpdate.Transaction>>>)x$4, (Function3<Map<String, Set<Ref.Identifier>>, Object, LoggingContext, Function1<TransactionLogUpdate.Transaction, Future<GetTransactionsResponse>>>)x$5, (Function1<Set<String>, Function1<TransactionLogUpdate.Transaction, Option<TransactionLogUpdate.Transaction>>>)x$6, (Function3<Set<String>, Object, LoggingContext, Function1<TransactionLogUpdate.Transaction, Future<GetTransactionTreesResponse>>>)x$7, x$3, executionContext);
    }

    public <FILTER, API_RESPONSE> Source<Tuple2<Offset, API_RESPONSE>, NotUsed> getTransactions(EventsBuffer<TransactionLogUpdate> transactionsBuffer, Offset startExclusive, Offset endInclusive, FILTER filter, boolean verbose, Metrics metrics, int eventProcessingParallelism, Function1<TransactionLogUpdate.Transaction, Option<TransactionLogUpdate.Transaction>> filterEvents, Function1<TransactionLogUpdate.Transaction, Future<API_RESPONSE>> toApiTx, Function4<Offset, Offset, FILTER, Object, Source<Tuple2<Offset, API_RESPONSE>, NotUsed>> fetchTransactions, Metrics.daml.services.index.BufferedReader bufferReaderMetrics, ExecutionContext executionContext) {
        Object FILTER = filter;
        Function1 function1 = toApiTx;
        Function4 function4 = fetchTransactions;
        Metrics.daml.services.index.BufferedReader bufferedReader = bufferReaderMetrics;
        Function1 & Serializable sliceFilter = (Function1 & Serializable)x0$1 -> {
            None$ none$;
            TransactionLogUpdate transactionLogUpdate = x0$1;
            if (transactionLogUpdate instanceof TransactionLogUpdate.Transaction) {
                TransactionLogUpdate.Transaction transaction = (TransactionLogUpdate.Transaction)transactionLogUpdate;
                none$ = (Option)filterEvents.apply((Object)transaction);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        };
        Source source = (Source)Source$.MODULE$.unfoldAsync((Object)startExclusive, (Function1 & Serializable)x0$2 -> {
            Offset offset = x0$2;
            Future future = offset.$less((Object)endInclusive) ? Future$.MODULE$.apply((Function0 & Serializable)() -> {
                Some some;
                BufferSlice.BufferSlice bufferSlice = transactionsBuffer.slice(offset, endInclusive, sliceFilter);
                if (bufferSlice instanceof BufferSlice.Inclusive) {
                    BufferSlice.Inclusive inclusive = (BufferSlice.Inclusive)bufferSlice;
                    Vector slice = inclusive.slice();
                    Source sourceFromBuffer = BufferedTransactionsReader$.bufferSource$1(slice, eventProcessingParallelism, bufferedReader, function1);
                    Offset nextChunkStartExclusive = (Offset)slice.lastOption().map((Function1 & Serializable)x$18 -> (Offset)x$18._1()).getOrElse((Function0 & Serializable)() -> endInclusive);
                    some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nextChunkStartExclusive), (Object)sourceFromBuffer));
                } else if (bufferSlice instanceof BufferSlice.LastBufferChunkSuffix) {
                    BufferSlice.LastBufferChunkSuffix lastBufferChunkSuffix = (BufferSlice.LastBufferChunkSuffix)bufferSlice;
                    Offset bufferedStartExclusive = lastBufferChunkSuffix.bufferedStartExclusive();
                    Vector slice = lastBufferChunkSuffix.slice();
                    Source sourceFromBuffer = (Source)((FlowOps)function4.apply((Object)startExclusive, (Object)bufferedStartExclusive, FILTER, (Object)BoxesRunTime.boxToBoolean((boolean)verbose))).concat((Graph)BufferedTransactionsReader$.bufferSource$1(slice, eventProcessingParallelism, bufferedReader, function1));
                    some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endInclusive), (Object)sourceFromBuffer));
                } else {
                    throw new MatchError(bufferSlice);
                }
                return some;
            }, executionContext) : Future$.MODULE$.successful((Object)None$.MODULE$);
            return future;
        }).flatMapConcat((Function1 & Serializable)x -> (Source)Predef$.MODULE$.identity(x));
        return (Source)Timed$.MODULE$.source(bufferedReader.fetchTimer(), (Function0 & Serializable)() -> source).map((Function1 & Serializable)tx -> {
            bufferedReader.fetchedTotal().inc();
            return tx;
        });
    }

    public Map<Ref.Identifier, Set<String>> invertMapping(Map<String, Set<Ref.Identifier>> partiesTemplates) {
        return (Map)partiesTemplates.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Map templatesToParties;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    templatesToParties = (Map)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String party = (String)tuple2._1();
            Set templates = (Set)tuple2._2();
            Map map = (Map)templates.foldLeft((Object)templatesToParties, (Function2 & Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Map aux = (Map)tuple2._1();
                Ref.Identifier templateId = (Ref.Identifier)tuple2._2();
                Map map = (Map)aux.updatedWith((Object)templateId, (Function1 & Serializable)x0$3 -> {
                    Some some;
                    Option option = x0$3;
                    if (None$.MODULE$.equals(option)) {
                        some = new Some(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{party})));
                    } else if (option instanceof Some) {
                        Some some2 = (Some)option;
                        Set partySet = (Set)some2.value();
                        some = new Some((Object)partySet.$plus((Object)party));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return some;
                });
                return map;
            });
            return map;
        });
    }

    private static final Source bufferSource$1(Vector bufferSlice, int eventProcessingParallelism$1, Metrics.daml.services.index.BufferedReader bufferReaderMetrics$1$1, Function1 toApiTx$1$1) {
        return bufferSlice.isEmpty() ? Source$.MODULE$.empty() : (Source)Source$.MODULE$.apply((Iterable)bufferSlice).mapAsync(eventProcessingParallelism$1, (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Offset offset = (Offset)tuple2._1();
            TransactionLogUpdate.Transaction payload = (TransactionLogUpdate.Transaction)tuple2._2();
            bufferReaderMetrics$1$1.fetchedBuffered().inc();
            Future future = Timed$.MODULE$.future(bufferReaderMetrics$1$1.conversion(), (Function0 & Serializable)() -> ((Future)toApiTx$1$1.apply((Object)payload)).map((Function1 & Serializable)x$17 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offset), x$17), (ExecutionContext)ExecutionContext.parasitic$.MODULE$));
            return future;
        });
    }

    private BufferedTransactionsReader$() {
    }
}

