/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao.events;

import akka.NotUsed;
import akka.stream.Attributes$;
import akka.stream.scaladsl.FlowOps;
import akka.stream.scaladsl.Source;
import com.daml.ledger.offset.Offset;
import com.daml.lf.data.Ref;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.indexer.parallel.BatchN$;
import com.daml.platform.store.backend.EventStorageBackend;
import com.daml.platform.store.dao.DbDispatcher;
import com.daml.platform.store.dao.events.ACSReader;
import com.daml.platform.store.dao.events.FilterTableACSReader$;
import com.daml.platform.store.dao.events.FilterTableACSReader$IdQueryConfiguration$;
import com.daml.platform.store.dao.events.QueryNonPruned;
import com.daml.platform.store.dao.events.Raw;
import com.daml.platform.store.utils.ConcurrencyLimiter;
import com.daml.platform.store.utils.QueueBasedConcurrencyLimiter;
import java.io.Serializable;
import java.sql.Connection;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.ChainingOps$;
import scala.util.package;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001db\u0001\u00023f\u0001ID\u0001\" \u0001\u0003\u0002\u0003\u0006IA \u0005\u000b\u0003\u000b\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\u0007\u0001\t\u0005\t\u0015!\u0003\u0002\u0010!Q\u00111\u0004\u0001\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005\r\u0002A!A!\u0002\u0013\ti\u0002\u0003\u0006\u0002&\u0001\u0011\t\u0011)A\u0005\u0003;A!\"a\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\tI\u0003\u0001B\u0001B\u0003%\u0011Q\u0004\u0005\u000b\u0003W\u0001!\u0011!Q\u0001\n\u0005u\u0001BCA\u0017\u0001\t\u0005\t\u0015!\u0003\u00020!Q\u0011\u0011\b\u0001\u0003\u0002\u0003\u0006I!a\u000f\t\u0015\u0005\u001d\u0003A!A!\u0002\u0013\tI\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0004\u0002CAB\u0001\u0001\u0006I!a\u001e\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\u001eA!\u0011E3\t\u0002\u0015\u0014\u0019CB\u0004eK\"\u0005QM!\n\t\u000f\u0005U#\u0003\"\u0001\u0003(!I\u00111\u000f\nC\u0002\u0013%\u0011Q\u000f\u0005\t\u0003\u0007\u0013\u0002\u0015!\u0003\u0002x\u00191!\u0011\u0006\nA\u0005WA!B!\u000f\u0017\u0005+\u0007I\u0011\u0001B\u001e\u0011)\u0011\u0019E\u0006B\tB\u0003%!Q\b\u0005\u000b\u0005\u000b2\"Q3A\u0005\u0002\t\u001d\u0003B\u0003B+-\tE\t\u0015!\u0003\u0003J!9\u0011Q\u000b\f\u0005\u0002\t]\u0003\"\u0003B1-\u0005\u0005I\u0011\u0001B2\u0011%\u0011IGFI\u0001\n\u0003\u0011Y\u0007C\u0005\u0003\u0002Z\t\n\u0011\"\u0001\u0003\u0004\"I!q\u0011\f\u0002\u0002\u0013\u0005#\u0011\u0012\u0005\n\u000573\u0012\u0011!C\u0001\u0005;C\u0011Ba(\u0017\u0003\u0003%\tA!)\t\u0013\t5f#!A\u0005B\t=\u0006\"\u0003B_-\u0005\u0005I\u0011\u0001B`\u0011%\u0011IMFA\u0001\n\u0003\u0012Y\rC\u0005\u0003PZ\t\t\u0011\"\u0011\u0003R\"I!1\u001b\f\u0002\u0002\u0013\u0005#Q\u001b\u0005\n\u0005/4\u0012\u0011!C!\u00053<\u0011B!8\u0013\u0003\u0003E\tAa8\u0007\u0013\t%\"#!A\t\u0002\t\u0005\bbBA+S\u0011\u0005!\u0011 \u0005\n\u0005'L\u0013\u0011!C#\u0005+D\u0011Ba?*\u0003\u0003%\tI!@\t\u0013\r\r\u0011&!A\u0005\u0002\u000e\u0015\u0001\"CB\bS\u0005\u0005I\u0011BB\t\r\u0019\u0019IB\u0005!\u0004\u001c!Q1QD\u0018\u0003\u0016\u0004%\taa\b\t\u0015\r\u0005rF!E!\u0002\u0013\u0011Y\u0002\u0003\u0006\u0002\u001c=\u0012)\u001a!C\u0001\u0005;C!ba\t0\u0005#\u0005\u000b\u0011BA\u000f\u0011\u001d\t)f\fC\u0001\u0007KA\u0011B!\u00190\u0003\u0003%\ta!\f\t\u0013\t%t&%A\u0005\u0002\rM\u0002\"\u0003BA_E\u0005I\u0011AB\u001c\u0011%\u00119iLA\u0001\n\u0003\u0012I\tC\u0005\u0003\u001c>\n\t\u0011\"\u0001\u0003\u001e\"I!qT\u0018\u0002\u0002\u0013\u000511\b\u0005\n\u0005[{\u0013\u0011!C!\u0005_C\u0011B!00\u0003\u0003%\taa\u0010\t\u0013\t%w&!A\u0005B\r\r\u0003\"\u0003Bh_\u0005\u0005I\u0011\tBi\u0011%\u0011\u0019nLA\u0001\n\u0003\u0012)\u000eC\u0005\u0003X>\n\t\u0011\"\u0011\u0004H\u001dI11\n\n\u0002\u0002#\u00051Q\n\u0004\n\u00073\u0011\u0012\u0011!E\u0001\u0007\u001fBq!!\u0016C\t\u0003\u0019\u0019\u0006C\u0005\u0003T\n\u000b\t\u0011\"\u0012\u0003V\"I!1 \"\u0002\u0002\u0013\u00055Q\u000b\u0005\n\u0007\u0007\u0011\u0015\u0011!CA\u00077B\u0011ba\u0004C\u0003\u0003%Ia!\u0005\u0007\r\r\r$\u0003QB3\u0011)\u00199\u0007\u0013BK\u0002\u0013\u0005!Q\u0014\u0005\u000b\u0007SB%\u0011#Q\u0001\n\u0005u\u0001BCB6\u0011\nU\r\u0011\"\u0001\u0003\u001e\"Q1Q\u000e%\u0003\u0012\u0003\u0006I!!\b\t\u000f\u0005U\u0003\n\"\u0001\u0004p!I!\u0011\r%\u0002\u0002\u0013\u00051q\u000f\u0005\n\u0005SB\u0015\u0013!C\u0001\u0007oA\u0011B!!I#\u0003%\taa\u000e\t\u0013\t\u001d\u0005*!A\u0005B\t%\u0005\"\u0003BN\u0011\u0006\u0005I\u0011\u0001BO\u0011%\u0011y\nSA\u0001\n\u0003\u0019i\bC\u0005\u0003.\"\u000b\t\u0011\"\u0011\u00030\"I!Q\u0018%\u0002\u0002\u0013\u00051\u0011\u0011\u0005\n\u0005\u0013D\u0015\u0011!C!\u0007\u000bC\u0011Ba4I\u0003\u0003%\tE!5\t\u0013\tM\u0007*!A\u0005B\tU\u0007\"\u0003Bl\u0011\u0006\u0005I\u0011IBE\u000f\u001d\u0019iI\u0005E\u0001\u0007\u001f3qaa\u0019\u0013\u0011\u0003\u0019\t\nC\u0004\u0002Vm#\taa%\t\u000f\tm8\f\"\u0001\u0004\u0016\"I!1`.\u0002\u0002\u0013\u00055q\u0015\u0005\n\u0007\u0007Y\u0016\u0011!CA\u0007[C\u0011ba\u0004\\\u0003\u0003%Ia!\u0005\t\u000f\rU&\u0003\"\u0001\u00048\"911\u001c\n\u0005\u0002\ru\u0007b\u0002C\b%\u0011\u0005A\u0011\u0003\u0002\u0015\r&dG/\u001a:UC\ndW-Q\"T%\u0016\fG-\u001a:\u000b\u0005\u0019<\u0017AB3wK:$8O\u0003\u0002iS\u0006\u0019A-Y8\u000b\u0005)\\\u0017!B:u_J,'B\u00017n\u0003!\u0001H.\u0019;g_Jl'B\u00018p\u0003\u0011!\u0017-\u001c7\u000b\u0003A\f1aY8n\u0007\u0001\u00192\u0001A:z!\t!x/D\u0001v\u0015\u00051\u0018!B:dC2\f\u0017B\u0001=v\u0005\u0019\te.\u001f*fMB\u0011!p_\u0007\u0002K&\u0011A0\u001a\u0002\n\u0003\u000e\u001b&+Z1eKJ\f!\u0002Z5ta\u0006$8\r[3s!\ry\u0018\u0011A\u0007\u0002O&\u0019\u00111A4\u0003\u0019\u0011\u0013G)[:qCR\u001c\u0007.\u001a:\u0002\u001dE,XM]=O_:\u0004&/\u001e8fIB\u0019!0!\u0003\n\u0007\u0005-QM\u0001\bRk\u0016\u0014\u0018PT8o!J,h.\u001a3\u0002'\u00154XM\u001c;Ti>\u0014\u0018mZ3CC\u000e\\WM\u001c3\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006j\u0003\u001d\u0011\u0017mY6f]\u0012LA!!\u0007\u0002\u0014\t\u0019RI^3oiN#xN]1hK\n\u000b7m[3oI\u0006A\u0001/Y4f'&TX\rE\u0002u\u0003?I1!!\tv\u0005\rIe\u000e^\u0001\u000bS\u0012\u0004\u0016mZ3TSj,\u0017\u0001E5e!\u0006<WMQ;gM\u0016\u00148+\u001b>f\u0003aIG\rU1hK^{'o[5oO6+Wn\u001c:z\u0005f$Xm]\u0001\u0016S\u00124U\r^2iS:<\u0007+\u0019:bY2,G.[:n\u0003Y\t7m\u001d$fi\u000eD\u0017N\\4qCJ\fG\u000e\\3mSNl\u0017aB7fiJL7m\u001d\t\u0005\u0003c\t)$\u0004\u0002\u00024)\u0019\u0011QF7\n\t\u0005]\u00121\u0007\u0002\b\u001b\u0016$(/[2t\u00031\tX/\u001a:zY&l\u0017\u000e^3s!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!S\u0006)Q\u000f^5mg&!\u0011QIA \u0005I\u0019uN\\2veJ,gnY=MS6LG/\u001a:\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\b\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=S/\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u0015\u0002N\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u00155\u0005e\u00131LA/\u0003?\n\t'a\u0019\u0002f\u0005\u001d\u0014\u0011NA6\u0003[\ny'!\u001d\u0011\u0005i\u0004\u0001\"B?\u000e\u0001\u0004q\bbBA\u0003\u001b\u0001\u0007\u0011q\u0001\u0005\b\u0003\u001bi\u0001\u0019AA\b\u0011\u001d\tY\"\u0004a\u0001\u0003;Aq!a\t\u000e\u0001\u0004\ti\u0002C\u0004\u0002&5\u0001\r!!\b\t\u000f\u0005\u001dR\u00021\u0001\u0002\u001e!9\u0011\u0011F\u0007A\u0002\u0005u\u0001bBA\u0016\u001b\u0001\u0007\u0011Q\u0004\u0005\b\u0003[i\u0001\u0019AA\u0018\u0011\u001d\tI$\u0004a\u0001\u0003wAq!a\u0012\u000e\u0001\u0004\tI%\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{j\u0017a\u00027pO\u001eLgnZ\u0005\u0005\u0003\u0003\u000bYH\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003%\t7m]*ue\u0016\fW\u000e\u0006\u0004\u0002\n\u0006\u0015(\u0011\u0001\u000b\u0005\u0003\u0017\u000bY\u000e\u0005\u0005\u0002\u000e\u0006m\u0015qTAj\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015\u0001C:dC2\fGm\u001d7\u000b\t\u0005U\u0015qS\u0001\u0007gR\u0014X-Y7\u000b\u0005\u0005e\u0015\u0001B1lW\u0006LA!!(\u0002\u0010\n11k\\;sG\u0016\u0004b!!)\u00022\u0006]f\u0002BAR\u0003[sA!!*\u0002,6\u0011\u0011q\u0015\u0006\u0004\u0003S\u000b\u0018A\u0002\u001fs_>$h(C\u0001w\u0013\r\ty+^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019,!.\u0003\rY+7\r^8s\u0015\r\ty+\u001e\t\u0007\u0003s\u000by,!2\u000f\t\u0005E\u00111X\u0005\u0005\u0003{\u000b\u0019\"A\nFm\u0016tGo\u0015;pe\u0006<WMQ1dW\u0016tG-\u0003\u0003\u0002B\u0006\r'!B#oiJL(\u0002BA_\u0003'\u0001B!a2\u0002N:\u0019!0!3\n\u0007\u0005-W-A\u0002SC^LA!a4\u0002R\nIa\t\\1u\u000bZ,g\u000e\u001e\u0006\u0004\u0003\u0017,\u0007\u0003BAk\u0003/l!!a&\n\t\u0005e\u0017q\u0013\u0002\b\u001d>$Xk]3e\u0011\u001d\ti\u000e\u0005a\u0002\u0003?\fa\u0002\\8hO&twmQ8oi\u0016DH\u000f\u0005\u0003\u0002z\u0005\u0005\u0018\u0002BAr\u0003w\u0012a\u0002T8hO&twmQ8oi\u0016DH\u000fC\u0004\u0002hB\u0001\r!!;\u0002\r\u0019LG\u000e^3s!\u0011\tY/a?\u000f\t\u00055\u0018\u0011 \b\u0005\u0003_\f9P\u0004\u0003\u0002r\u0006Uh\u0002BAS\u0003gL\u0011\u0001]\u0005\u0003]>L!\u0001\\7\n\u0007\u0005=6.\u0003\u0003\u0002~\u0006}(A\u0004$jYR,'OU3mCRLwN\u001c\u0006\u0004\u0003_[\u0007b\u0002B\u0002!\u0001\u0007!QA\u0001\tC\u000e$\u0018N^3BiB9AOa\u0002\u0003\f\tm\u0011b\u0001B\u0005k\n1A+\u001e9mKJ\u0002BA!\u0004\u0003\u00185\u0011!q\u0002\u0006\u0005\u0005#\u0011\u0019\"\u0001\u0004pM\u001a\u001cX\r\u001e\u0006\u0004\u0005+i\u0017A\u00027fI\u001e,'/\u0003\u0003\u0003\u001a\t=!AB(gMN,G\u000fE\u0002u\u0005;I1Aa\bv\u0005\u0011auN\\4\u0002)\u0019KG\u000e^3s)\u0006\u0014G.Z!D'J+\u0017\rZ3s!\tQ(c\u0005\u0002\u0013gR\u0011!1\u0005\u0002\u0007\r&dG/\u001a:\u0014\rY\u0019(Q\u0006B\u001a!\r!(qF\u0005\u0004\u0005c)(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003C\u0013)$\u0003\u0003\u00038\u0005U&\u0001D*fe&\fG.\u001b>bE2,\u0017!\u00029beRLXC\u0001B\u001f!\u0011\tYOa\u0010\n\t\t\u0005\u0013q \u0002\u0006!\u0006\u0014H/_\u0001\u0007a\u0006\u0014H/\u001f\u0011\u0002\u0015Q,W\u000e\u001d7bi\u0016LE-\u0006\u0002\u0003JA)AOa\u0013\u0003P%\u0019!QJ;\u0003\r=\u0003H/[8o!\u0011\tYO!\u0015\n\t\tM\u0013q \u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018a\u0003;f[Bd\u0017\r^3JI\u0002\"bA!\u0017\u0003^\t}\u0003c\u0001B.-5\t!\u0003C\u0004\u0003:m\u0001\rA!\u0010\t\u000f\t\u00153\u00041\u0001\u0003J\u0005!1m\u001c9z)\u0019\u0011IF!\u001a\u0003h!I!\u0011\b\u000f\u0011\u0002\u0003\u0007!Q\b\u0005\n\u0005\u000bb\u0002\u0013!a\u0001\u0005\u0013\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003n)\"!Q\bB8W\t\u0011\t\b\u0005\u0003\u0003t\tuTB\u0001B;\u0015\u0011\u00119H!\u001f\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B>k\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}$Q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u000bSCA!\u0013\u0003p\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa#\u0011\t\t5%qS\u0007\u0003\u0005\u001fSAA!%\u0003\u0014\u0006!A.\u00198h\u0015\t\u0011)*\u0001\u0003kCZ\f\u0017\u0002\u0002BM\u0005\u001f\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u000f\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa)\u0003*B\u0019AO!*\n\u0007\t\u001dVOA\u0002B]fD\u0011Ba+\"\u0003\u0003\u0005\r!!\b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\f\u0005\u0004\u00034\ne&1U\u0007\u0003\u0005kS1Aa.v\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005w\u0013)L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002Ba\u0005\u000f\u00042\u0001\u001eBb\u0013\r\u0011)-\u001e\u0002\b\u0005>|G.Z1o\u0011%\u0011YkIA\u0001\u0002\u0004\u0011\u0019+\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002BF\u0005\u001bD\u0011Ba+%\u0003\u0003\u0005\r!!\b\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa#\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tMa7\t\u0013\t-v%!AA\u0002\t\r\u0016A\u0002$jYR,'\u000fE\u0002\u0003\\%\u001aR!\u000bBr\u0005_\u0004\"B!:\u0003l\nu\"\u0011\nB-\u001b\t\u00119OC\u0002\u0003jV\fqA];oi&lW-\u0003\u0003\u0003n\n\u001d(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!\u0011\u001fB|\u001b\t\u0011\u0019P\u0003\u0003\u0003v\nM\u0015AA5p\u0013\u0011\u00119Da=\u0015\u0005\t}\u0017!B1qa2LHC\u0002B-\u0005\u007f\u001c\t\u0001C\u0004\u0003:1\u0002\rA!\u0010\t\u000f\t\u0015C\u00061\u0001\u0003J\u00059QO\\1qa2LH\u0003BB\u0004\u0007\u0017\u0001R\u0001\u001eB&\u0007\u0013\u0001r\u0001\u001eB\u0004\u0005{\u0011I\u0005C\u0005\u0004\u000e5\n\t\u00111\u0001\u0003Z\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\rM\u0001\u0003\u0002BG\u0007+IAaa\u0006\u0003\u0010\n1qJ\u00196fGR\u0014q!\u00133Rk\u0016\u0014\u0018p\u0005\u00040g\n5\"1G\u0001\u0018MJ|W.\u0012=dYV\u001c\u0018N^3Fm\u0016tGoU3r\u0013\u0012,\"Aa\u0007\u00021\u0019\u0014x.\\#yG2,8/\u001b<f\u000bZ,g\u000e^*fc&#\u0007%A\u0005qC\u001e,7+\u001b>fAQ11qEB\u0015\u0007W\u00012Aa\u00170\u0011\u001d\u0019i\u0002\u000ea\u0001\u00057Aq!a\u00075\u0001\u0004\ti\u0002\u0006\u0004\u0004(\r=2\u0011\u0007\u0005\n\u0007;)\u0004\u0013!a\u0001\u00057A\u0011\"a\u00076!\u0003\u0005\r!!\b\u0016\u0005\rU\"\u0006\u0002B\u000e\u0005_*\"a!\u000f+\t\u0005u!q\u000e\u000b\u0005\u0005G\u001bi\u0004C\u0005\u0003,j\n\t\u00111\u0001\u0002\u001eQ!!\u0011YB!\u0011%\u0011Y\u000bPA\u0001\u0002\u0004\u0011\u0019\u000b\u0006\u0003\u0003\f\u000e\u0015\u0003\"\u0003BV{\u0005\u0005\t\u0019AA\u000f)\u0011\u0011\tm!\u0013\t\u0013\t-\u0006)!AA\u0002\t\r\u0016aB%e#V,'/\u001f\t\u0004\u00057\u00125#\u0002\"\u0004R\t=\bC\u0003Bs\u0005W\u0014Y\"!\b\u0004(Q\u00111Q\n\u000b\u0007\u0007O\u00199f!\u0017\t\u000f\ruQ\t1\u0001\u0003\u001c!9\u00111D#A\u0002\u0005uA\u0003BB/\u0007C\u0002R\u0001\u001eB&\u0007?\u0002r\u0001\u001eB\u0004\u00057\ti\u0002C\u0005\u0004\u000e\u0019\u000b\t\u00111\u0001\u0004(\t!\u0012\nZ)vKJL8i\u001c8gS\u001e,(/\u0019;j_:\u001cb\u0001S:\u0003.\tM\u0012aC7j]B\u000bw-Z*ju\u0016\fA\"\\5o!\u0006<WmU5{K\u0002\n1\"\\1y!\u0006<WmU5{K\u0006aQ.\u0019=QC\u001e,7+\u001b>fAQ11\u0011OB:\u0007k\u00022Aa\u0017I\u0011\u001d\u00199'\u0014a\u0001\u0003;Aqaa\u001bN\u0001\u0004\ti\u0002\u0006\u0004\u0004r\re41\u0010\u0005\n\u0007Or\u0005\u0013!a\u0001\u0003;A\u0011ba\u001bO!\u0003\u0005\r!!\b\u0015\t\t\r6q\u0010\u0005\n\u0005W\u001b\u0016\u0011!a\u0001\u0003;!BA!1\u0004\u0004\"I!1V+\u0002\u0002\u0003\u0007!1\u0015\u000b\u0005\u0005\u0017\u001b9\tC\u0005\u0003,Z\u000b\t\u00111\u0001\u0002\u001eQ!!\u0011YBF\u0011%\u0011Y+WA\u0001\u0002\u0004\u0011\u0019+\u0001\u000bJIF+XM]=D_:4\u0017nZ;sCRLwN\u001c\t\u0004\u00057Z6\u0003B.t\u0005_$\"aa$\u0015\u0015\r]51TBP\u0007C\u001b)\u000b\u0006\u0003\u0004r\re\u0005bBAo;\u0002\u000f\u0011q\u001c\u0005\b\u0007;k\u0006\u0019AA\u000f\u00035i\u0017\r_%e!\u0006<WmU5{K\"9\u0011qE/A\u0002\u0005u\u0001bBBR;\u0002\u0007\u0011QD\u0001\u000bM&dG/\u001a:TSj,\u0007bBA\u0013;\u0002\u0007\u0011Q\u0004\u000b\u0007\u0007c\u001aIka+\t\u000f\r\u001dd\f1\u0001\u0002\u001e!911\u000e0A\u0002\u0005uA\u0003BBX\u0007g\u0003R\u0001\u001eB&\u0007c\u0003r\u0001\u001eB\u0004\u0003;\ti\u0002C\u0005\u0004\u000e}\u000b\t\u00111\u0001\u0004r\u0005A\u0011\u000eZ*pkJ\u001cW\r\u0006\u0004\u0004:\u000eM7q\u001b\u000b\u0005\u0007w\u001bi\f\u0005\u0005\u0002\u000e\u0006m%1DAj\u0011\u001d\u0019y,\u0019a\u0001\u0007\u0003\fqaZ3u!\u0006<W\rE\u0004u\u0007\u0007\u001c9ca2\n\u0007\r\u0015WOA\u0005Gk:\u001cG/[8ocA1\u00111JBe\u0007\u001bLAaa3\u0002N\t1a)\u001e;ve\u0016\u0004R\u0001^Bh\u00057I1a!5v\u0005\u0015\t%O]1z\u0011\u001d\u0019).\u0019a\u0001\u0007c\nA#\u001b3Rk\u0016\u0014\u0018pQ8oM&<WO]1uS>t\u0007bBBmC\u0002\u0007\u0011QD\u0001\u000fa\u0006<WMQ;gM\u0016\u00148+\u001b>f\u0003%iWM]4f'>\u0014H/\u0006\u0003\u0004`\u000e%H\u0003BBq\u0007\u007f$Baa9\u0004vBA\u0011QRAN\u0007K\f\u0019\u000e\u0005\u0003\u0004h\u000e%H\u0002\u0001\u0003\b\u0007W\u0014'\u0019ABw\u0005\u0005!\u0016\u0003BBx\u0005G\u00032\u0001^By\u0013\r\u0019\u00190\u001e\u0002\b\u001d>$\b.\u001b8h\u0011%\u00199PYA\u0001\u0002\b\u0019I0\u0001\u0006fm&$WM\\2fIE\u0002b!!)\u0004|\u000e\u0015\u0018\u0002BB\u007f\u0003k\u0013\u0001b\u0014:eKJLgn\u001a\u0005\b\t\u0003\u0011\u0007\u0019\u0001C\u0002\u0003\u001d\u0019x.\u001e:dKN\u0004b!!)\u00022\u000e\r\bf\u00012\u0005\bA!A\u0011\u0002C\u0006\u001b\t\u0011I(\u0003\u0003\u0005\u000e\te$a\u0002;bS2\u0014XmY\u0001\u0014gR\fG/\u001a4vY\u0012+G-\u001e9mS\u000e\fG/Z\u000b\u0005\t'!y\"\u0006\u0002\u0005\u0016A)A\u000fb\u0006\u0005\u001c%\u0019A\u0011D;\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004c\u0002;\u0004D\u0012uA\u0011\u0005\t\u0005\u0007O$y\u0002B\u0004\u0004l\u000e\u0014\ra!<\u0011\r\u0005\u0005F1\u0005C\u000f\u0013\u0011!)#!.\u0003\t1K7\u000f\u001e")
public class FilterTableACSReader
implements ACSReader {
    private final DbDispatcher dispatcher;
    private final QueryNonPruned queryNonPruned;
    private final EventStorageBackend eventStorageBackend;
    private final int pageSize;
    private final int idPageSize;
    private final int idPageBufferSize;
    private final int idPageWorkingMemoryBytes;
    private final int idFetchingParallelism;
    private final int acsFetchingparallelism;
    private final Metrics metrics;
    private final ConcurrencyLimiter querylimiter;
    private final ExecutionContext executionContext;
    private final ContextualizedLogger logger;

    public static <T> Function0<Function1<T, List<T>>> statefulDeduplicate() {
        return FilterTableACSReader$.MODULE$.statefulDeduplicate();
    }

    public static <T> Source<T, NotUsed> mergeSort(Vector<Source<T, NotUsed>> sources, Ordering<T> evidence$1) {
        return FilterTableACSReader$.MODULE$.mergeSort(sources, evidence$1);
    }

    public static Source<Object, NotUsed> idSource(IdQueryConfiguration idQueryConfiguration, int pageBufferSize, Function1<IdQuery, Future<long[]>> getPage) {
        return FilterTableACSReader$.MODULE$.idSource(idQueryConfiguration, pageBufferSize, getPage);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    @Override
    public Source<Vector<EventStorageBackend.Entry<Raw.FlatEvent>>, NotUsed> acsStream(Map<String, Set<Ref.Identifier>> filter2, Tuple2<Offset, Object> activeAt, LoggingContext loggingContext) {
        Set allFilterParties = filter2.keySet();
        Vector filters = filter2.iterator().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String party = (String)tuple2._1();
                Set templateIds = (Set)tuple2._2();
                if (templateIds.isEmpty()) {
                    return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Filter[]{new Filter(party, (Option<Ref.Identifier>)None$.MODULE$)}));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String party = (String)tuple2._1();
            Set templateIds = (Set)tuple2._2();
            return templateIds.iterator().map((Function1 & Serializable)templateId -> new Filter(party, (Option<Ref.Identifier>)new Some(templateId)));
        }).toVector();
        QueueBasedConcurrencyLimiter idQueryLimiter = new QueueBasedConcurrencyLimiter(this.idFetchingParallelism, this.executionContext);
        IdQueryConfiguration idQueryConfiguration = FilterTableACSReader$IdQueryConfiguration$.MODULE$.apply(this.idPageSize, this.idPageWorkingMemoryBytes, filters.size(), this.idPageBufferSize, loggingContext);
        return (Source)((Source)((FlowOps)ChainingOps$.MODULE$.pipe$extension(package.chaining$.MODULE$.scalaUtilChainingOps(filters.map((Function1 & Serializable)filter -> this.toIdSource$1((Filter)filter, idQueryConfiguration, idQueryLimiter, (Tuple2)activeAt, loggingContext))), (Function1 & Serializable)sources -> FilterTableACSReader$.MODULE$.mergeSort(sources, Ordering.Long$.MODULE$))).statefulMapConcat(FilterTableACSReader$.MODULE$.statefulDeduplicate())).via(BatchN$.MODULE$.apply(this.pageSize, this.acsFetchingparallelism + 1)).async().addAttributes(Attributes$.MODULE$.inputBuffer(this.acsFetchingparallelism, this.acsFetchingparallelism)).mapAsync(this.acsFetchingparallelism, (Function1 & Serializable)ids -> this.fetchAcs$1((Iterable)ids, allFilterParties, (Tuple2)activeAt, loggingContext));
    }

    public static final /* synthetic */ String $anonfun$acsStream$7(long last) {
        return new StringBuilder(6).append("until ").append(last).toString();
    }

    private final Source toIdSource$1(Filter filter, IdQueryConfiguration idQueryConfiguration$1, QueueBasedConcurrencyLimiter idQueryLimiter$1, Tuple2 activeAt$1, LoggingContext loggingContext$1) {
        return FilterTableACSReader$.MODULE$.idSource(idQueryConfiguration$1, this.idPageBufferSize, (Function1<IdQuery, Future<long[]>>)(Function1 & Serializable)idQuery -> idQueryLimiter$1.execute((Function0 & Serializable)() -> $this.dispatcher.executeSql($this.metrics.daml().index().db().getActiveContractIds(), (Function1 & Serializable)connection -> {
            Vector<Object> result = $this.eventStorageBackend.activeContractEventIds(filter.party(), filter.templateId(), idQuery.fromExclusiveEventSeqId(), activeAt$1._2$mcJ$sp(), idQuery.pageSize(), (Connection)connection);
            this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(33).append("getActiveContractIds ").append(filter).append(" returned #").append(result.size()).append(" ").append(result.lastOption().map((Function1 & Serializable)last -> FilterTableACSReader.$anonfun$acsStream$7(BoxesRunTime.unboxToLong((Object)last))).getOrElse((Function0 & Serializable)() -> "")).toString(), loggingContext$1);
            return (long[])result.toArray((ClassTag)ClassTag$.MODULE$.Long());
        }, loggingContext$1)));
    }

    public static final /* synthetic */ String $anonfun$acsStream$14(long last) {
        return new StringBuilder(6).append("until ").append(last).toString();
    }

    private final Future fetchAcs$1(Iterable ids, Set allFilterParties$1, Tuple2 activeAt$1, LoggingContext loggingContext$1) {
        return this.querylimiter.execute((Function0 & Serializable)() -> $this.dispatcher.executeSql($this.metrics.daml().index().db().getActiveContractBatch(), (Function1 & Serializable)connection -> {
            Vector result = (Vector)$this.queryNonPruned.executeSql((Function0 & Serializable)() -> $this.eventStorageBackend.activeContractEventBatch((Iterable<Object>)ids, (Set<String>)allFilterParties$1, activeAt$1._2$mcJ$sp(), (Connection)connection), (Offset)activeAt$1._1(), (Function1<Offset, String>)(Function1 & Serializable)pruned -> new StringBuilder(55).append("Active contracts request after ").append(((Offset)activeAt$1._1()).toHexString()).append(" precedes pruned offset ").append(pruned.toHexString()).toString(), (Connection)connection, (LoggingContext)Predef$.MODULE$.implicitly((Object)loggingContext$1));
            this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(34).append("getActiveContractBatch returned ").append(ids.size()).append("/").append(result.size()).append(" ").append(ids.lastOption().map((Function1 & Serializable)last -> FilterTableACSReader.$anonfun$acsStream$14(BoxesRunTime.unboxToLong((Object)last))).getOrElse((Function0 & Serializable)() -> "")).toString(), loggingContext$1);
            return result;
        }, loggingContext$1));
    }

    public FilterTableACSReader(DbDispatcher dispatcher, QueryNonPruned queryNonPruned, EventStorageBackend eventStorageBackend, int pageSize, int idPageSize, int idPageBufferSize, int idPageWorkingMemoryBytes, int idFetchingParallelism, int acsFetchingparallelism, Metrics metrics, ConcurrencyLimiter querylimiter, ExecutionContext executionContext) {
        this.dispatcher = dispatcher;
        this.queryNonPruned = queryNonPruned;
        this.eventStorageBackend = eventStorageBackend;
        this.pageSize = pageSize;
        this.idPageSize = idPageSize;
        this.idPageBufferSize = idPageBufferSize;
        this.idPageWorkingMemoryBytes = idPageWorkingMemoryBytes;
        this.idFetchingParallelism = idFetchingParallelism;
        this.acsFetchingparallelism = acsFetchingparallelism;
        this.metrics = metrics;
        this.querylimiter = querylimiter;
        this.executionContext = executionContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }

    public static class Filter
    implements Product,
    Serializable {
        private final String party;
        private final Option<Ref.Identifier> templateId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String party() {
            return this.party;
        }

        public Option<Ref.Identifier> templateId() {
            return this.templateId;
        }

        public Filter copy(String party, Option<Ref.Identifier> templateId) {
            return new Filter(party, templateId);
        }

        public String copy$default$1() {
            return this.party();
        }

        public Option<Ref.Identifier> copy$default$2() {
            return this.templateId();
        }

        public String productPrefix() {
            return "Filter";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.party();
                    break;
                }
                case 1: {
                    object = this.templateId();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Filter;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "party";
                    break;
                }
                case 1: {
                    string = "templateId";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Filter)) return false;
            boolean bl = true;
            if (!bl) return false;
            Filter filter = (Filter)x$1;
            String string = this.party();
            String string2 = filter.party();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Ref.Identifier> option = this.templateId();
            Option<Ref.Identifier> option2 = filter.templateId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!filter.canEqual(this)) return false;
            return true;
        }

        public Filter(String party, Option<Ref.Identifier> templateId) {
            this.party = party;
            this.templateId = templateId;
            Product.$init$((Product)this);
        }
    }

    public static class IdQuery
    implements Product,
    Serializable {
        private final long fromExclusiveEventSeqId;
        private final int pageSize;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long fromExclusiveEventSeqId() {
            return this.fromExclusiveEventSeqId;
        }

        public int pageSize() {
            return this.pageSize;
        }

        public IdQuery copy(long fromExclusiveEventSeqId, int pageSize) {
            return new IdQuery(fromExclusiveEventSeqId, pageSize);
        }

        public long copy$default$1() {
            return this.fromExclusiveEventSeqId();
        }

        public int copy$default$2() {
            return this.pageSize();
        }

        public String productPrefix() {
            return "IdQuery";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.fromExclusiveEventSeqId());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.pageSize());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof IdQuery;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "fromExclusiveEventSeqId";
                    break;
                }
                case 1: {
                    string = "pageSize";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.fromExclusiveEventSeqId()));
            n = Statics.mix((int)n, (int)this.pageSize());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof IdQuery)) return false;
            boolean bl = true;
            if (!bl) return false;
            IdQuery idQuery = (IdQuery)x$1;
            if (this.fromExclusiveEventSeqId() != idQuery.fromExclusiveEventSeqId()) return false;
            if (this.pageSize() != idQuery.pageSize()) return false;
            if (!idQuery.canEqual(this)) return false;
            return true;
        }

        public IdQuery(long fromExclusiveEventSeqId, int pageSize) {
            this.fromExclusiveEventSeqId = fromExclusiveEventSeqId;
            this.pageSize = pageSize;
            Product.$init$((Product)this);
        }
    }

    public static class IdQueryConfiguration
    implements Product,
    Serializable {
        private final int minPageSize;
        private final int maxPageSize;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int minPageSize() {
            return this.minPageSize;
        }

        public int maxPageSize() {
            return this.maxPageSize;
        }

        public IdQueryConfiguration copy(int minPageSize, int maxPageSize) {
            return new IdQueryConfiguration(minPageSize, maxPageSize);
        }

        public int copy$default$1() {
            return this.minPageSize();
        }

        public int copy$default$2() {
            return this.maxPageSize();
        }

        public String productPrefix() {
            return "IdQueryConfiguration";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.minPageSize());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.maxPageSize());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof IdQueryConfiguration;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "minPageSize";
                    break;
                }
                case 1: {
                    string = "maxPageSize";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.minPageSize());
            n = Statics.mix((int)n, (int)this.maxPageSize());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof IdQueryConfiguration)) return false;
            boolean bl = true;
            if (!bl) return false;
            IdQueryConfiguration idQueryConfiguration = (IdQueryConfiguration)x$1;
            if (this.minPageSize() != idQueryConfiguration.minPageSize()) return false;
            if (this.maxPageSize() != idQueryConfiguration.maxPageSize()) return false;
            if (!idQueryConfiguration.canEqual(this)) return false;
            return true;
        }

        public IdQueryConfiguration(int minPageSize, int maxPageSize) {
            this.minPageSize = minPageSize;
            this.maxPageSize = maxPageSize;
            Product.$init$((Product)this);
            Predef$.MODULE$.assert(minPageSize > 0);
            Predef$.MODULE$.assert(maxPageSize >= minPageSize);
        }
    }
}

