/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao.events;

import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.SubFlow;
import com.daml.platform.store.dao.events.EventsRange;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class TransactionsReader$ {
    public static final TransactionsReader$ MODULE$ = new TransactionsReader$();

    public Vector<EventsRange<Object>> splitRange(long startExclusive, long endInclusive, int numberOfChunks, int maxChunkSize) {
        Vector vector;
        Predef$.MODULE$.require(maxChunkSize > 0, (Function0 & Serializable)() -> new StringBuilder(54).append("Maximum chunk size must be strictly positive, but was ").append(maxChunkSize).toString());
        Predef$.MODULE$.require(numberOfChunks > 0, (Function0 & Serializable)() -> new StringBuilder(69).append("You can only split a range in a strictly positive number of chunks (").append(numberOfChunks).append(")").toString());
        long rangeSize = endInclusive - startExclusive;
        Predef$.MODULE$.require(rangeSize >= 0L, (Function0 & Serializable)() -> new StringBuilder(49).append("Range size should be positive but got bounds (").append(startExclusive).append(", ").append(endInclusive).append("]").toString());
        int minChunkSize = package$.MODULE$.max(1, maxChunkSize / 10);
        if (rangeSize == 0L) {
            vector = scala.package$.MODULE$.Vector().empty();
        } else {
            long targetChunkSize = rangeSize / (long)numberOfChunks;
            if (targetChunkSize < (long)minChunkSize) {
                long effectiveNumberOfChunks = rangeSize / (long)minChunkSize;
                vector = effectiveNumberOfChunks <= 1L ? (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EventsRange[]{new EventsRange<Long>(BoxesRunTime.boxToLong((long)startExclusive), BoxesRunTime.boxToLong((long)endInclusive))})) : this.splitRangeUnsafe(startExclusive, rangeSize, (int)effectiveNumberOfChunks);
            } else {
                int effectiveNumberOfChunks = Math.max(numberOfChunks, (int)Math.ceil((double)rangeSize / (double)maxChunkSize));
                vector = this.splitRangeUnsafe(startExclusive, rangeSize, effectiveNumberOfChunks);
            }
        }
        return vector;
    }

    private Vector<EventsRange<Object>> splitRangeUnsafe(long startExclusive, long rangeSize, int numberOfChunks) {
        long minStep = rangeSize / (long)numberOfChunks;
        long remainder = rangeSize - minStep * (long)numberOfChunks;
        return (Vector)((Tuple3)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfChunks).foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)startExclusive), (Object)BoxesRunTime.boxToLong((long)remainder), (Object)scala.package$.MODULE$.Vector().empty()), (Function2 & Serializable)(x0$1, x1$1) -> TransactionsReader$.$anonfun$splitRangeUnsafe$1(minStep, x0$1, BoxesRunTime.unboxToInt((Object)x1$1))))._3();
    }

    public <A, K, Mat> Source<Vector<A>, Mat> groupContiguous(Source<A, Mat> source, Function1<A, K> by) {
        return (Source)((SubFlow)source.statefulMapConcat((Function0 & Serializable)() -> {
            ObjectRef previousSegmentKey = ObjectRef.create((Object)None$.MODULE$);
            return (Function1 & Serializable)entry -> {
                Object keyForEntry = by.apply(entry);
                Tuple2 entryWithSplit = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry), (Object)BoxesRunTime.boxToBoolean((!((Option)previousSegmentKey$1.elem).contains(keyForEntry) ? 1 : 0) != 0));
                previousSegmentKey$1.elem = new Some(keyForEntry);
                return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{entryWithSplit}));
            };
        }).splitWhen((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12._2$mcZ$sp())).map((Function1 & Serializable)x$13 -> x$13._1()).fold((Object)scala.package$.MODULE$.Vector().empty(), (Function2 & Serializable)(x$14, x$15) -> (Vector)x$14.$colon$plus(x$15))).concatSubstreams();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Tuple3 $anonfun$splitRangeUnsafe$1(long minStep$1, Tuple3 x0$1, int x1$1) {
        Tuple3 tuple3;
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 != null && (tuple3 = (Tuple3)tuple2._1()) != null) {
            long lastStartExclusive = BoxesRunTime.unboxToLong((Object)tuple3._1());
            long l = BoxesRunTime.unboxToLong((Object)tuple3._2());
            Vector ranges = (Vector)tuple3._3();
            if (0L == l) {
                long endInclusiveChunk = lastStartExclusive + minStep$1;
                return new Tuple3((Object)BoxesRunTime.boxToLong((long)endInclusiveChunk), (Object)BoxesRunTime.boxToLong((long)0L), ranges.$colon$plus(new EventsRange<Long>(BoxesRunTime.boxToLong((long)lastStartExclusive), BoxesRunTime.boxToLong((long)endInclusiveChunk))));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple3 tuple32 = (Tuple3)tuple2._1();
        if (tuple32 == null) throw new MatchError((Object)tuple2);
        long lastStartExclusive = BoxesRunTime.unboxToLong((Object)tuple32._1());
        long remainder = BoxesRunTime.unboxToLong((Object)tuple32._2());
        Vector ranges = (Vector)tuple32._3();
        long endInclusiveChunk = lastStartExclusive + minStep$1 + 1L;
        Vector rangesResult = (Vector)ranges.$colon$plus(new EventsRange<Long>(BoxesRunTime.boxToLong((long)lastStartExclusive), BoxesRunTime.boxToLong((long)endInclusiveChunk)));
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)endInclusiveChunk), (Object)BoxesRunTime.boxToLong((long)(remainder - 1L)), (Object)rangesResult);
    }

    private TransactionsReader$() {
    }
}

