/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.runner;

import com.daml.ledger.api.testtool.infrastructure.ChannelEndpoint;
import com.daml.ledger.api.testtool.infrastructure.ChannelEndpoint$;
import com.daml.ledger.api.testtool.infrastructure.Dars$;
import com.daml.ledger.api.testtool.infrastructure.Errors;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestCase;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestCasesRunner;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestCasesRunner$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSummary;
import com.daml.ledger.api.testtool.infrastructure.PartyAllocationConfiguration;
import com.daml.ledger.api.testtool.infrastructure.Reporter;
import com.daml.ledger.api.testtool.infrastructure.ResourceOwner$;
import com.daml.ledger.api.testtool.infrastructure.Result;
import com.daml.ledger.api.testtool.runner.AvailableTests;
import com.daml.ledger.api.testtool.runner.Config;
import com.daml.ledger.api.testtool.runner.ConfiguredTests;
import com.daml.ledger.api.testtool.runner.TestRunner$;
import com.daml.ledger.api.tls.TlsConfiguration;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.Resource;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.Serializable;
import java.util.concurrent.Executors;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t5s!\u0002\u000f\u001e\u0011\u0003Qc!\u0002\u0017\u001e\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)T\u0001\u0002\u001c\u0002\t]*AaT\u0001\u0005!\"9Q+\u0001b\u0001\n\u00131\u0006B\u0002.\u0002A\u0003%q\u000bC\u0004\\\u0003\t\u0007I\u0011\u0002/\t\r\u0015\f\u0001\u0015!\u0003^\u0011\u001d1\u0017A1A\u0005\n\u001dDaa]\u0001!\u0002\u0013A\u0007b\u0002;\u0002\u0005\u0004%I!\u001e\u0005\u0007{\u0006\u0001\u000b\u0011\u0002<\t\u000by\fA\u0011B@\t\u000f\u0005M\u0012\u0001\"\u0003\u00026!9\u00111L\u0001\u0005\n\u0005u\u0003bBA6\u0003\u0011%\u0011Q\u000e\u0005\b\u0003c\nA\u0011BA:\u0011\u001d\tI(\u0001C\u0005\u0003w2Q\u0001L\u000f\u0003\u0003'C!\"!&\u0014\u0005\u0003\u0005\u000b\u0011BAL\u0011)\tij\u0005B\u0001B\u0003%\u0011q\u0014\u0005\u0007iM!\t!!*\t\u000f\u000556\u0003\"\u0001\u00020\"9\u0011\u0011W\n\u0005\n\u0005M\u0006bBAh'\u0011%\u0011\u0011\u001b\u0005\b\u0003?\u001cB\u0011BAq\u0011\u001d\u0011ic\u0005C\u0005\u0005_\t!\u0002V3tiJ+hN\\3s\u0015\tqr$\u0001\u0004sk:tWM\u001d\u0006\u0003A\u0005\n\u0001\u0002^3tiR|w\u000e\u001c\u0006\u0003E\r\n1!\u00199j\u0015\t!S%\u0001\u0004mK\u0012<WM\u001d\u0006\u0003M\u001d\nA\u0001Z1nY*\t\u0001&A\u0002d_6\u001c\u0001\u0001\u0005\u0002,\u00035\tQD\u0001\u0006UKN$(+\u001e8oKJ\u001c\"!\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!FA\u0007SKN|WO]2f\u001f^tWM]\u000b\u0003q\u0019\u0003B!\u000f\u001f?\t6\t!H\u0003\u0002<K\u0005I!/Z:pkJ\u001cWm]\u0005\u0003{i\u0012Q#\u00112tiJ\f7\r\u001e*fg>,(oY3Po:,'\u000f\u0005\u0002@\u00056\t\u0001I\u0003\u0002Ba\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\r\u0003%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u!\t)e\t\u0004\u0001\u0005\u000b\u001d\u001b!\u0019\u0001%\u0003\u0003Q\u000b\"!\u0013'\u0011\u0005=R\u0015BA&1\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aL'\n\u00059\u0003$aA!os\nA!+Z:pkJ\u001cW-\u0006\u0002R)B!\u0011H\u0015 T\u0013\ty%\b\u0005\u0002F)\u0012)q\t\u0002b\u0001\u0011\u0006A!+Z:pkJ\u001cW-F\u0001X!\rI\u0004LP\u0005\u00033j\u0012\u0011CU3t_V\u00148-\u001a$bGR|'/[3t\u0003%\u0011Vm]8ve\u000e,\u0007%\u0001\u0004m_\u001e<WM]\u000b\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0006g24GG\u001b\u0006\u0002E\u0006\u0019qN]4\n\u0005\u0011|&A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002!%$WM\u001c;jM&,'oU;gM&DX#\u00015\u0011\u0005%\u0004hB\u00016o!\tY\u0007'D\u0001m\u0015\ti\u0017&\u0001\u0004=e>|GOP\u0005\u0003_B\na\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011q\u000eM\u0001\u0012S\u0012,g\u000e^5gS\u0016\u00148+\u001e4gSb\u0004\u0013!H;oG\u0006,x\r\u001b;Fq\u000e,\u0007\u000f^5p]\u0016\u0013(o\u001c:NKN\u001c\u0018mZ3\u0016\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\t1\fgn\u001a\u0006\u0002w\u0006!!.\u0019<b\u0013\t\t\b0\u0001\u0010v]\u000e\fWo\u001a5u\u000bb\u001cW\r\u001d;j_:,%O]8s\u001b\u0016\u001c8/Y4fA\u0005AQ\r_5u\u0007>$W\r\u0006\u0004\u0002\u0002\u0005\u001d\u0011\u0011\u0006\t\u0004_\u0005\r\u0011bAA\u0003a\t\u0019\u0011J\u001c;\t\u000f\u0005%Q\u00021\u0001\u0002\f\u0005I1/^7nCJLWm\u001d\t\u0007\u0003\u001b\t9\"!\b\u000f\t\u0005=\u00111\u0003\b\u0004W\u0006E\u0011\"A\u0019\n\u0007\u0005U\u0001'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00111\u0004\u0002\u0007-\u0016\u001cGo\u001c:\u000b\u0007\u0005U\u0001\u0007\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019cH\u0001\u000fS:4'/Y:ueV\u001cG/\u001e:f\u0013\u0011\t9#!\t\u0003#1+GmZ3s)\u0016\u001cHoU;n[\u0006\u0014\u0018\u0010C\u0004\u0002,5\u0001\r!!\f\u0002\u001b\u0015D\b/Z2u\r\u0006LG.\u001e:f!\ry\u0013qF\u0005\u0004\u0003c\u0001$a\u0002\"p_2,\u0017M\\\u0001\u0011aJLg\u000e\u001e'jgR|e\rV3tiN,B!a\u000e\u0002NQ!\u0011\u0011HA))\u0011\tY$!\u0011\u0011\u0007=\ni$C\u0002\u0002@A\u0012A!\u00168ji\"9\u00111\t\bA\u0002\u0005\u0015\u0013aB4fi:\u000bW.\u001a\t\u0007_\u0005\u001d\u00131\n5\n\u0007\u0005%\u0003GA\u0005Gk:\u001cG/[8ocA\u0019Q)!\u0014\u0005\r\u0005=cB1\u0001I\u0005\u0005\t\u0005bBA*\u001d\u0001\u0007\u0011QK\u0001\u0006i\u0016\u001cHo\u001d\t\u0007\u0003\u001b\t9&a\u0013\n\t\u0005e\u00131\u0004\u0002\u0004'\u0016\f\u0018\u0001\u00079sS:$\u0018I^1jY\u0006\u0014G.\u001a+fgR\u001cV/\u001b;fgR!\u00111HA0\u0011\u001d\t\tg\u0004a\u0001\u0003G\n!\u0002^3tiN+\u0018\u000e^3t!\u0019\ti!a\u0006\u0002fA!\u0011qDA4\u0013\u0011\tI'!\t\u0003\u001f1+GmZ3s)\u0016\u001cHoU;ji\u0016\f1\u0003\u001d:j]R\fe/Y5mC\ndW\rV3tiN$B!a\u000f\u0002p!9\u0011\u0011\r\tA\u0002\u0005\r\u0014\u0001E3yiJ\f7\r\u001e*fg>,(oY3t)\u0011\tY$!\u001e\t\rm\n\u0002\u0019AA<!\u0015\ti!a\u0016i\u0003\u001di\u0017\r^2iKN$B!! \u0002\nR!\u0011QFA@\u0011\u001d\t\tI\u0005a\u0001\u0003\u0007\u000bA\u0001^3tiB!\u0011qDAC\u0013\u0011\t9)!\t\u0003\u001d1+GmZ3s)\u0016\u001cHoQ1tK\"9\u00111\u0012\nA\u0002\u00055\u0015\u0001\u00039sK\u001aL\u00070Z:\u0011\u000b\u00055\u0011q\u00125\n\t\u0005E\u00151\u0004\u0002\t\u0013R,'/\u00192mKN\u00111CL\u0001\u000fCZ\f\u0017\u000e\\1cY\u0016$Vm\u001d;t!\rY\u0013\u0011T\u0005\u0004\u00037k\"AD!wC&d\u0017M\u00197f)\u0016\u001cHo]\u0001\u0007G>tg-[4\u0011\u0007-\n\t+C\u0002\u0002$v\u0011aaQ8oM&<GCBAT\u0003S\u000bY\u000b\u0005\u0002,'!9\u0011Q\u0013\fA\u0002\u0005]\u0005bBAO-\u0001\u0007\u0011qT\u0001\u000beVt\u0017I\u001c3Fq&$HCAA\u001e\u0003QqWm\u001e'fI\u001e,'oQ1tKN\u0014VO\u001c8feR1\u0011QWAd\u0003\u0013$B!a.\u0002DB)q(!/\u0002>&\u0019\u00111\u0018!\u0003\r\u0019+H/\u001e:f!\u0011\ty\"a0\n\t\u0005\u0005\u0017\u0011\u0005\u0002\u0016\u0019\u0016$w-\u001a:UKN$8)Y:fgJ+hN\\3s\u0011\u0019\t)\r\u0007a\u0002}\u0005\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003;C\u0002\u0019AAP\u0011\u001d\tY\r\u0007a\u0001\u0003\u001b\fQaY1tKN\u0004b!!\u0004\u0002\u0018\u0005\r\u0015aF2sK\u0006$X\rT3eO\u0016\u00148)Y:fgJ+hN\\3s)!\t\u0019.a6\u0002Z\u0006mG\u0003BA\\\u0003+Da!!2\u001a\u0001\bq\u0004bBAO3\u0001\u0007\u0011q\u0014\u0005\b\u0003\u0017L\u0002\u0019AAg\u0011\u001d\ti.\u0007a\u0001\u0003\u0003\t!cY8oGV\u0014(/\u001a8u)\u0016\u001cHOU;og\u0006a\u0012N\\5uS\u0006d\u0017N_3QCJ$\u0018nY5qC:$8\t[1o]\u0016dG\u0003CAr\u0005\u001f\u0011\u0019Ba\u0006\u0011\u000b\u0005\u00158!a@\u000f\u0007\u0005\u001d\bA\u0004\u0003\u0002j\u0006uh\u0002BAv\u0003wtA!!<\u0002z:!\u0011q^A|\u001d\u0011\t\t0!>\u000f\u0007-\f\u00190C\u0001)\u0013\t1s%\u0003\u0002%K%\u0011!eI\u0005\u0003A\u0005J!AH\u0010\u0011\t\t\u0005!1B\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u0005!qM\u001d9d\u0015\t\u0011I!\u0001\u0002j_&!!Q\u0002B\u0002\u0005\u001d\u0019\u0005.\u00198oK2DaA!\u0005\u001b\u0001\u0004A\u0017\u0001\u00025pgRDqA!\u0006\u001b\u0001\u0004\t\t!\u0001\u0003q_J$\bb\u0002B\r5\u0001\u0007!1D\u0001\ni2\u001c8i\u001c8gS\u001e\u0004Ra\fB\u000f\u0005CI1Aa\b1\u0005\u0019y\u0005\u000f^5p]B!!1\u0005B\u0015\u001b\t\u0011)CC\u0002\u0003(\u0005\n1\u0001\u001e7t\u0013\u0011\u0011YC!\n\u0003!Qc7oQ8oM&<WO]1uS>t\u0017!H5oSRL\u0017\r\\5{KB\u000b'\u000f^5dSB\fg\u000e^\"iC:tW\r\\:\u0015\r\tE\"q\bB&)\u0011\u0011\u0019D!\u0010\u0011\u000b\u0005\u0015HA!\u000e\u0011\r\u00055\u0011q\u0003B\u001c!\u0011\tyB!\u000f\n\t\tm\u0012\u0011\u0005\u0002\u0010\u0007\"\fgN\\3m\u000b:$\u0007o\\5oi\"1\u0011QY\u000eA\u0004yBqA!\u0011\u001c\u0001\u0004\u0011\u0019%\u0001\u000bqCJ$\u0018nY5qC:$XI\u001c3q_&tGo\u001d\t\u0007\u0003\u001b\t9B!\u0012\u0011\r=\u00129\u0005[A\u0001\u0013\r\u0011I\u0005\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\te1\u00041\u0001\u0003\u001c\u0001")
public final class TestRunner {
    private final AvailableTests availableTests;
    private final Config config;

    public void runAndExit() {
        ConfiguredTests tests = new ConfiguredTests(this.availableTests, this.config);
        if (tests.missingTests().nonEmpty()) {
            Predef$.MODULE$.println((Object)"The following exclusion or inclusion does not match any test:");
            tests.missingTests().foreach((Function1 & Serializable)testName -> {
                Predef$.MODULE$.println((Object)new StringBuilder(4).append("  - ").append(testName).toString());
                return BoxedUnit.UNIT;
            });
            throw scala.sys.package$.MODULE$.exit(64);
        }
        if (this.config.listTestSuites()) {
            TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$printAvailableTestSuites(tests.allTests());
            throw scala.sys.package$.MODULE$.exit(0);
        }
        if (this.config.listTests()) {
            TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$printAvailableTests(tests.allTests());
            throw scala.sys.package$.MODULE$.exit(0);
        }
        if (this.config.extract()) {
            TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$extractResources((Seq<String>)Dars$.MODULE$.resources());
            throw scala.sys.package$.MODULE$.exit(0);
        }
        if (this.config.participantsEndpoints().isEmpty()) {
            Predef$.MODULE$.println((Object)"No participant to test, exiting.");
            throw scala.sys.package$.MODULE$.exit(0);
        }
        Thread.currentThread().setUncaughtExceptionHandler((x$6, exception) -> {
            TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$logger().error(TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$uncaughtExceptionErrorMessage(), exception);
            throw scala.sys.package$.MODULE$.exit(1);
        });
        Vector includedTests = this.config.included().isEmpty() ? tests.defaultCases() : (Vector)tests.allCases().filter((Function1 & Serializable)test -> BoxesRunTime.boxToBoolean((boolean)TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$matches((Iterable<String>)this.config.included(), test)));
        Vector addedTests = (Vector)tests.allCases().filter((Function1 & Serializable)test -> BoxesRunTime.boxToBoolean((boolean)TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$matches((Iterable<String>)this.config.additional(), test)));
        Tuple2 tuple2 = ((StrictOptimizedIterableOps)includedTests.$plus$plus((IterableOnce)addedTests)).partition((Function1 & Serializable)test -> BoxesRunTime.boxToBoolean((boolean)TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$matches((Iterable<String>)this.config.excluded(), test)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector excludedTests = (Vector)tuple2._1();
        Vector testsToRun = (Vector)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)excludedTests, (Object)testsToRun);
        Tuple2 tuple23 = tuple22;
        Vector excludedTests2 = (Vector)tuple23._1();
        Vector testsToRun2 = (Vector)tuple23._2();
        ExecutionContextExecutorService resourceManagementExecutionContext = ExecutionContext$.MODULE$.fromExecutorService(Executors.newSingleThreadExecutor());
        Future<LedgerTestCasesRunner> runner = this.newLedgerCasesRunner(this.config, (Vector<LedgerTestCase>)testsToRun2, (ExecutionContext)resourceManagementExecutionContext);
        runner.flatMap((Function1 & Serializable)x$8 -> x$8.runTests((ExecutionContext)ExecutionContext$.MODULE$.global()), (ExecutionContext)resourceManagementExecutionContext).onComplete((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Failure failure = null;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Vector summaries = (Vector)success.value();
                Vector excludedTestSummaries = (Vector)excludedTests2.map((Function1 & Serializable)ledgerTestCase -> new LedgerTestSummary(ledgerTestCase.suite().name(), ledgerTestCase.name(), ledgerTestCase.description(), (Either)package$.MODULE$.Right().apply((Object)new Result.Excluded("excluded test"))));
                new Reporter.ColorizedPrintStreamReporter(System.out, $this.config.verbose()).report(summaries, excludedTestSummaries, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifierSuffix"), (Object)TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$identifierSuffix()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"concurrentTestRuns"), (Object)Integer.toString($this.config.concurrentTestRuns())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeoutScaleFactor"), (Object)Double.toString($this.config.timeoutScaleFactor()))})));
                return scala.sys.package$.MODULE$.exit(TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$exitCode((Vector<LedgerTestSummary>)summaries, $this.config.mustFail()));
            }
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (exception instanceof Errors.FrameworkException) {
                    Errors.FrameworkException frameworkException = (Errors.FrameworkException)exception;
                    TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$logger().error(frameworkException.getMessage());
                    TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$logger().debug(frameworkException.getMessage(), (Throwable)frameworkException);
                    return scala.sys.package$.MODULE$.exit(1);
                }
            }
            if (!bl) throw new MatchError((Object)try_);
            Throwable exception = failure.exception();
            TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$logger().error(exception.getMessage(), exception);
            return scala.sys.package$.MODULE$.exit(1);
        }, (ExecutionContext)resourceManagementExecutionContext);
    }

    private Future<LedgerTestCasesRunner> newLedgerCasesRunner(Config config, Vector<LedgerTestCase> cases, ExecutionContext executionContext) {
        return this.createLedgerCasesRunner(config, cases, config.concurrentTestRuns(), executionContext);
    }

    private Future<LedgerTestCasesRunner> createLedgerCasesRunner(Config config, Vector<LedgerTestCase> cases, int concurrentTestRuns, ExecutionContext executionContext) {
        return this.initializeParticipantChannels(config.participantsEndpoints(), config.tlsConfig(), executionContext).asFuture().map((Function1 & Serializable)participantChannels -> {
            Vector x$1 = cases;
            Vector x$2 = participantChannels;
            int x$3 = config.maxConnectionAttempts();
            PartyAllocationConfiguration x$4 = config.partyAllocation();
            boolean x$5 = config.shuffleParticipants();
            double x$6 = config.timeoutScaleFactor();
            int x$7 = concurrentTestRuns;
            boolean x$8 = config.uploadDars();
            String x$9 = TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$identifierSuffix();
            Option<TlsConfiguration> x$10 = config.tlsConfig();
            Seq x$11 = LedgerTestCasesRunner$.MODULE$.$lessinit$greater$default$10();
            return new LedgerTestCasesRunner(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$11, x$10);
        }, executionContext);
    }

    private AbstractResourceOwner<ExecutionContext, Channel> initializeParticipantChannel(String host, int port, Option<TlsConfiguration> tlsConfig) {
        TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$logger().info(new StringBuilder(49).append("Setting up managed channel to participant at ").append(host).append(":").append(port).append("...").toString());
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port).usePlaintext();
        tlsConfig.foreach((Function1 & Serializable)ssl -> {
            TestRunner.$anonfun$initializeParticipantChannel$1(channelBuilder, ssl);
            return BoxedUnit.UNIT;
        });
        channelBuilder.maxInboundMessageSize(10000000);
        return ResourceOwner$.MODULE$.forChannel((ManagedChannelBuilder)channelBuilder, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds());
    }

    private Resource<ExecutionContext, Vector<ChannelEndpoint>> initializeParticipantChannels(Vector<Tuple2<String, Object>> participantEndpoints, Option<TlsConfiguration> tlsConfig, ExecutionContext executionContext) {
        return TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$Resource().sequence((Iterable)participantEndpoints.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Resource resource = this.initializeParticipantChannel(host, port, tlsConfig).acquire((Object)executionContext).map((Function1 & Serializable)channel -> ChannelEndpoint$.MODULE$.forRemote(channel, host, port), (Object)executionContext);
            return resource;
        }), Vector$.MODULE$.iterableFactory(), (Object)executionContext);
    }

    public static final /* synthetic */ void $anonfun$initializeParticipantChannel$1(NettyChannelBuilder channelBuilder$1, TlsConfiguration ssl) {
        ssl.client(ssl.client$default$1()).foreach((Function1 & Serializable)sslContext -> {
            TestRunner$.MODULE$.com$daml$ledger$api$testtool$runner$TestRunner$$logger().info("Setting up managed channel with transport security.");
            return channelBuilder$1.useTransportSecurity().sslContext(sslContext).negotiationType(NegotiationType.TLS);
        });
    }

    public TestRunner(AvailableTests availableTests, Config config) {
        this.availableTests = availableTests;
        this.config = config;
    }
}

