/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_14;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.CommandExecution;
import com.daml.error.definitions.groups.ConsistencyErrors;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.Synchronize$;
import com.daml.ledger.api.testtool.infrastructure.TransactionHelpers$;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$;
import com.daml.ledger.api.v1.event.ExercisedEvent;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.test.semantic.Exceptions.Divulger;
import com.daml.ledger.test.semantic.Exceptions.Divulger$;
import com.daml.ledger.test.semantic.Exceptions.ExceptionTester;
import com.daml.ledger.test.semantic.Exceptions.ExceptionTester$;
import com.daml.ledger.test.semantic.Exceptions.Fetcher;
import com.daml.ledger.test.semantic.Exceptions.Fetcher$;
import com.daml.ledger.test.semantic.Exceptions.Informer;
import com.daml.ledger.test.semantic.Exceptions.RollbackNestingHelper;
import com.daml.ledger.test.semantic.Exceptions.WithKey;
import com.daml.ledger.test.semantic.Exceptions.WithKeyDelegate;
import com.daml.ledger.test.semantic.Exceptions.WithSimpleKey;
import com.daml.ledger.test.semantic.Exceptions.WithSimpleKey$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0003%!)\u0011\u0004\u0001C\u00015\taQ\t_2faRLwN\\:J)*\u0011A!B\u0001\u0006mFz\u0016\u0007\u000e\u0006\u0003\r\u001d\taa];ji\u0016\u001c(B\u0001\u0005\n\u0003!!Xm\u001d;u_>d'B\u0001\u0006\f\u0003\r\t\u0007/\u001b\u0006\u0003\u00195\ta\u0001\\3eO\u0016\u0014(B\u0001\b\u0010\u0003\u0011!\u0017-\u001c7\u000b\u0003A\t1aY8n\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0005Y9\u0011AD5oMJ\f7\u000f\u001e:vGR,(/Z\u0005\u00031U\u0011q\u0002T3eO\u0016\u0014H+Z:u'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\r\u0001")
public final class ExceptionsIT
extends LedgerTestSuite {
    public ExceptionsIT() {
        this.test("ExUncaught", "Uncaught exception returns INVALID_ARGUMENT", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> Assertions$.MODULE$.futureAssertions(ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseThrowUncaught$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId()))).mustFail("Unhandled exception", $this.ec$1).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$2(failure);
                        return BoxedUnit.UNIT;
                    }, $this.ec$1), this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2(Throwable failure) {
                Assertions$.MODULE$.assertGrpcErrorRegex(failure, (ErrorCode)CommandExecution.Interpreter$.UnhandledException$.MODULE$, (Option)new Some((Object)Pattern.compile("Unhandled (Daml )?exception")), true, Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$2$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("ExCaughtBasic", "Exceptions can be caught", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseThrowCaught$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)tree -> {
                        $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$4(tree);
                        return BoxedUnit.UNIT;
                    }, $this.ec$2), this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$4(TransactionTree tree) {
                Assertions$.MODULE$.assertLength("1 successful exercise", 1, (Seq)TransactionHelpers$.MODULE$.exercisedEvents(tree));
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$4$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExCaughtNested", "Exceptions can be caught when thrown from a nested try block", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseNestedCatch$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)tree -> {
                        $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$6(tree);
                        return BoxedUnit.UNIT;
                    }, $this.ec$3), this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$6(TransactionTree tree) {
                Assertions$.MODULE$.assertLength("1 successful exercise", 1, (Seq)TransactionHelpers$.MODULE$.exercisedEvents(tree));
            }
            {
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$6$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRollbackActiveFetch", "Rollback node depends on activeness of contract in a fetch", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)tFetch -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackFetch$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), tFetch, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$2 -> {
                        TransactionTree transactionTree = x$2;
                        return ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseArchive$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(tFetch), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$1 -> {
                            TransactionTree transactionTree = x$1;
                            return Assertions$.MODULE$.futureAssertions(ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackFetch$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), tFetch, ExerciseOn$.MODULE$.OnId()))).mustFail("contract is archived", $this.ec$4).map((Function1 & Serializable)failure -> {
                                $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$11(failure);
                                return BoxedUnit.UNIT;
                            }, $this.ec$4);
                        }, $this.ec$4);
                    }, $this.ec$4), $this.ec$4), this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$11(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$11$adapted(java.lang.Throwable ), $anonfun$applyOrElse$7(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$8(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$9(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRollbackActiveExerciseConsuming", "Rollback node depends on activeness of contract in a consuming exercise", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)tExercise -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackConsuming$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), tExercise, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$4 -> {
                        TransactionTree transactionTree = x$4;
                        return ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseArchive$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(tExercise), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$3 -> {
                            TransactionTree transactionTree = x$3;
                            return Assertions$.MODULE$.futureAssertions(ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackConsuming$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), tExercise, ExerciseOn$.MODULE$.OnId()))).mustFail("contract is archived", $this.ec$5).map((Function1 & Serializable)failure -> {
                                $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$16(failure);
                                return BoxedUnit.UNIT;
                            }, $this.ec$5);
                        }, $this.ec$5);
                    }, $this.ec$5), $this.ec$5), this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$16(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$12(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$13(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$14(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$15(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$16$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("ExRollbackActiveExerciseNonConsuming", "Rollback node depends on activeness of contract in a non-consuming exercise", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)tExercise -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackNonConsuming$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), tExercise, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$6 -> {
                        TransactionTree transactionTree = x$6;
                        return ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseArchive$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(tExercise), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$5 -> {
                            TransactionTree transactionTree = x$5;
                            return Assertions$.MODULE$.futureAssertions(ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackNonConsuming$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), tExercise, ExerciseOn$.MODULE$.OnId()))).mustFail("contract is archived", $this.ec$6).map((Function1 & Serializable)failure -> {
                                $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$21(failure);
                                return BoxedUnit.UNIT;
                            }, $this.ec$6);
                        }, $this.ec$6);
                    }, $this.ec$6), $this.ec$6), this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$21(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$17(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$18(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$19(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$20(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$21$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("ExRolledbackArchiveConsuming", "Rolled back archive does not block consuming exercise", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.create(party, (Template)new WithSimpleKey(party)).flatMap((Function1 & Serializable)withKey -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRolledbackArchiveConsuming$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), withKey, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$7 -> {
                        $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$24(x$7);
                        return BoxedUnit.UNIT;
                    }, $this.ec$7), $this.ec$7), this.ec$7);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$24(TransactionTree x$7) {
                TransactionTree transactionTree = x$7;
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$22(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$23(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$24$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRolledbackArchiveNonConsuming", "Rolled back archive does not block non-consuming exercise", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.create(party, (Template)new WithSimpleKey(party)).flatMap((Function1 & Serializable)withKey -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRolledbackArchiveNonConsuming$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), withKey, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$8 -> {
                        $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$27(x$8);
                        return BoxedUnit.UNIT;
                    }, $this.ec$8), $this.ec$8), this.ec$8);
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participant participant;
                Allocation.Participants participants = x8;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$27(TransactionTree x$8) {
                TransactionTree transactionTree = x$8;
            }
            {
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$25(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$26(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$27$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRolledbackKeyCreation", "Rolled back key creation does not block creation of the same key", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$9;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x9;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRolledbackDuplicateKey$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$9 -> {
                        $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$29(x$9);
                        return BoxedUnit.UNIT;
                    }, $this.ec$9), this.ec$9);
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Allocation.Participants x9) {
                Allocation.Participant participant;
                Allocation.Participants participants = x9;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$29(TransactionTree x$9) {
                TransactionTree transactionTree = x$9;
            }
            {
                this.ec$9 = ec$9;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$28(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$29$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRollbackDuplicateKeyCreated", "Rollback fails once contract with same key is created", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$10;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x10;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseDuplicateKey$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$11 -> {
                        TransactionTree transactionTree = x$11;
                        return ledger.create(party, (Template)new WithSimpleKey(party)).flatMap((Function1 & Serializable)x$10 -> {
                            Object object = x$10;
                            return Assertions$.MODULE$.futureAssertions(ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseDuplicateKey$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId()))).mustFail("duplicate key", $this.ec$10).map((Function1 & Serializable)failure -> {
                                $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$33(failure);
                                return BoxedUnit.UNIT;
                            }, $this.ec$10);
                        }, $this.ec$10);
                    }, $this.ec$10), this.ec$10);
                }
                return (B1)function1.apply(x10);
            }

            public final boolean isDefinedAt(Allocation.Participants x10) {
                Allocation.Participant participant;
                Allocation.Participants participants = x10;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$33(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.DuplicateContractKey$.MODULE$, (Option)new Some((Object)"DuplicateKey"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$10 = ec$10;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$30(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$31(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$32(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$33$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("ExRollbackDuplicateKeyArchived", "Rollback succeeds once contract with same key is archived", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$11;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x11;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.create(party, (Template)new WithSimpleKey(party)).flatMap((Function1 & Serializable)withKey -> Assertions$.MODULE$.futureAssertions(ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseDuplicateKey$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId()))).mustFail("duplicate key", $this.ec$11).map((Function1 & Serializable)failure -> {
                        Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.DuplicateContractKey$.MODULE$, (Option)new Some((Object)"DuplicateKey"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                        BoxedUnit x$12 = BoxedUnit.UNIT;
                        return new Tuple2(failure, (Object)x$12);
                    }, $this.ec$11).flatMap((Function1 & Serializable)x$15 -> {
                        Tuple2 tuple2 = x$15;
                        if (tuple2 != null) {
                            return ledger.exercise(party, WithSimpleKey.WithSimpleKey$u0020syntax$.MODULE$.exerciseArchive$extension(WithSimpleKey$.MODULE$.WithSimpleKey$u0020syntax(withKey), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$14 -> {
                                TransactionTree transactionTree = x$14;
                                return ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseDuplicateKey$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$13 -> {
                                    $anonfun$$nestedInanonfun$new$11$1.$anonfun$applyOrElse$39(x$13);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$11);
                            }, $this.ec$11);
                        }
                        throw new MatchError((Object)tuple2);
                    }, $this.ec$11), $this.ec$11), this.ec$11);
                }
                return (B1)function1.apply(x11);
            }

            public final boolean isDefinedAt(Allocation.Participants x11) {
                Allocation.Participant participant;
                Allocation.Participants participants = x11;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$39(TransactionTree x$13) {
                TransactionTree transactionTree = x$13;
            }
            {
                this.ec$11 = ec$11;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$34(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$35(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$36(java.lang.Throwable ), $anonfun$applyOrElse$37(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$38(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$39$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRollbackKeyFetchCreated", "Rollback with key fetch fails once contract is archived", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$12;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x12;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.create(party, (Template)new WithSimpleKey(party)).flatMap((Function1 & Serializable)withKey -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseFetchKey$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$17 -> {
                        TransactionTree transactionTree = x$17;
                        return ledger.exercise(party, WithSimpleKey.WithSimpleKey$u0020syntax$.MODULE$.exerciseArchive$extension(WithSimpleKey$.MODULE$.WithSimpleKey$u0020syntax(withKey), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$16 -> {
                            TransactionTree transactionTree = x$16;
                            return Assertions$.MODULE$.futureAssertions(ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseFetchKey$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId()))).mustFail("couldn't find key", $this.ec$12).map((Function1 & Serializable)failure -> {
                                $anonfun$$nestedInanonfun$new$12$1.$anonfun$applyOrElse$44(failure);
                                return BoxedUnit.UNIT;
                            }, $this.ec$12);
                        }, $this.ec$12);
                    }, $this.ec$12), $this.ec$12), this.ec$12);
                }
                return (B1)function1.apply(x12);
            }

            public final boolean isDefinedAt(Allocation.Participants x12) {
                Allocation.Participant participant;
                Allocation.Participants participants = x12;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$44(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)CommandExecution.Interpreter$.LookupErrors$.ContractKeyNotFound$.MODULE$, (Option)new Some((Object)"couldn't find key"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$12 = ec$12;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$40(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$41(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$42(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$43(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$44$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("ExRollbackKeyFetchArchived", "Rollback with key fetch succeeds once contract is created", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$13;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x13;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> Assertions$.MODULE$.futureAssertions(ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseFetchKey$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId()))).mustFail("contract not found", $this.ec$13).map((Function1 & Serializable)failure -> {
                        Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)CommandExecution.Interpreter$.LookupErrors$.ContractKeyNotFound$.MODULE$, (Option)new Some((Object)"couldn't find key"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                        BoxedUnit x$18 = BoxedUnit.UNIT;
                        return new Tuple2(failure, (Object)x$18);
                    }, $this.ec$13).flatMap((Function1 & Serializable)x$21 -> {
                        Tuple2 tuple2 = x$21;
                        if (tuple2 != null) {
                            return ledger.create(party, (Template)new WithSimpleKey(party)).flatMap((Function1 & Serializable)x$20 -> {
                                Object object = x$20;
                                return ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseFetchKey$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$19 -> {
                                    $anonfun$$nestedInanonfun$new$13$1.$anonfun$applyOrElse$49(x$19);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$13);
                            }, $this.ec$13);
                        }
                        throw new MatchError((Object)tuple2);
                    }, $this.ec$13), this.ec$13);
                }
                return (B1)function1.apply(x13);
            }

            public final boolean isDefinedAt(Allocation.Participants x13) {
                Allocation.Participant participant;
                Allocation.Participants participants = x13;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$49(TransactionTree x$19) {
                TransactionTree transactionTree = x$19;
            }
            {
                this.ec$13 = ec$13;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$45(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$46(java.lang.Throwable ), $anonfun$applyOrElse$47(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$48(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$49$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRollbackHidden", "Create and exercise in rollback node is not exposed on ledger API", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$14;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x14;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackCreate$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)tree -> {
                        $anonfun$$nestedInanonfun$new$14$1.$anonfun$applyOrElse$51(tree);
                        return BoxedUnit.UNIT;
                    }, $this.ec$14), this.ec$14);
                }
                return (B1)function1.apply(x14);
            }

            public final boolean isDefinedAt(Allocation.Participants x14) {
                Allocation.Participant participant;
                Allocation.Participants participants = x14;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$51(TransactionTree tree) {
                Assertions$.MODULE$.assertLength("no creates", 0, (Seq)TransactionHelpers$.MODULE$.createdEvents(tree));
                ExercisedEvent exercise = (ExercisedEvent)Assertions$.MODULE$.assertSingleton("1 exercise", (Seq)TransactionHelpers$.MODULE$.exercisedEvents(tree));
                String string = exercise.choice();
                String string2 = "RollbackCreate";
                Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Choice name mismatch");
            }
            {
                this.ec$14 = ec$14;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$50(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$14$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$51$adapted(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$52()}, serializedLambda);
            }
        });
        this.test("ExRollbackDivulge", "Fetch in rollback divulges", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$15;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                A1 A1 = x15;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext aLedger = participant.context();
                        Object aParty = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext bLedger = participant2.context();
                            Object bParty = participant2.parties().apply(0);
                            return (B1)aLedger.create(aParty, (Template)new Divulger(aParty, bParty)).flatMap((Function1 & Serializable)divulger -> bLedger.create(bParty, (Template)new Fetcher(bParty, aParty)).flatMap((Function1 & Serializable)fetcher -> bLedger.create(bParty, (Template)new WithSimpleKey(bParty)).flatMap((Function1 & Serializable)t -> Synchronize$.MODULE$.synchronize(aLedger, bLedger, $this.ec$15).flatMap((Function1 & Serializable)x$27 -> {
                                BoxedUnit boxedUnit = x$27;
                                return Assertions$.MODULE$.futureAssertions(aLedger.exercise(aParty, Fetcher.Fetcher$u0020syntax$.MODULE$.exerciseFetch$extension(Fetcher$.MODULE$.Fetcher$u0020syntax(fetcher), t, ExerciseOn$.MODULE$.OnId()))).mustFail("contract could not be found", $this.ec$15).map((Function1 & Serializable)fetchFailure -> {
                                    Assertions$.MODULE$.assertGrpcError(fetchFailure, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                                    BoxedUnit x$22 = BoxedUnit.UNIT;
                                    return new Tuple2(fetchFailure, (Object)x$22);
                                }, $this.ec$15).flatMap((Function1 & Serializable)x$26 -> {
                                    Tuple2 tuple2 = x$26;
                                    if (tuple2 != null) {
                                        return bLedger.exercise(bParty, Divulger.Divulger$u0020syntax$.MODULE$.exerciseDivulge$extension(Divulger$.MODULE$.Divulger$u0020syntax(divulger), t, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$25 -> {
                                            TransactionTree transactionTree = x$25;
                                            return Synchronize$.MODULE$.synchronize(aLedger, bLedger, $this.ec$15).flatMap((Function1 & Serializable)x$24 -> {
                                                BoxedUnit boxedUnit = x$24;
                                                return aLedger.exercise(aParty, Fetcher.Fetcher$u0020syntax$.MODULE$.exerciseFetch$extension(Fetcher$.MODULE$.Fetcher$u0020syntax(fetcher), t, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$23 -> {
                                                    $anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$61(x$23);
                                                    return BoxedUnit.UNIT;
                                                }, $this.ec$15);
                                            }, $this.ec$15);
                                        }, $this.ec$15);
                                    }
                                    throw new MatchError((Object)tuple2);
                                }, $this.ec$15);
                            }, $this.ec$15), $this.ec$15), $this.ec$15), this.ec$15);
                        }
                    }
                }
                return (B1)function1.apply(x15);
            }

            public final boolean isDefinedAt(Allocation.Participants x15) {
                Allocation.Participants participants = x15;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$61(TransactionTree x$23) {
                TransactionTree transactionTree = x$23;
            }
            {
                this.ec$15 = ec$15;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$53(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$15$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$54(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$15$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$55(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$15$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$56(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$15$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$57(java.lang.Throwable ), $anonfun$applyOrElse$58(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$15$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$59(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$15$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$60(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$15$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$61$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRollbackProjectionDivulgence", "Fetch and fetchbykey in projection divulge", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$16;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x16, Function1<A1, B1> function1) {
                A1 A1 = x16;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext aLedger = participant.context();
                        Object aParty = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext bLedger = participant2.context();
                            Object bParty = participant2.parties().apply(0);
                            return (B1)aLedger.create(aParty, (Template)new Fetcher(aParty, bParty)).flatMap((Function1 & Serializable)fetcher -> aLedger.create(aParty, (Template)new WithKey(aParty, 0L, (Seq)package$.MODULE$.List().empty())).flatMap((Function1 & Serializable)withKey0 -> aLedger.create(aParty, (Template)new WithKey(aParty, 1L, (Seq)package$.MODULE$.List().empty())).flatMap((Function1 & Serializable)withKey1 -> Synchronize$.MODULE$.synchronize(aLedger, bLedger, $this.ec$16).flatMap((Function1 & Serializable)x$36 -> {
                                BoxedUnit boxedUnit = x$36;
                                return Assertions$.MODULE$.futureAssertions(bLedger.exercise(bParty, Fetcher.Fetcher$u0020syntax$.MODULE$.exerciseFetch_$extension(Fetcher$.MODULE$.Fetcher$u0020syntax(fetcher), withKey0, ExerciseOn$.MODULE$.OnId()))).mustFail("contract could not be found", $this.ec$16).map((Function1 & Serializable)fetchFailure -> {
                                    Assertions$.MODULE$.assertGrpcError(fetchFailure, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                                    BoxedUnit x$28 = BoxedUnit.UNIT;
                                    return new Tuple2(fetchFailure, (Object)x$28);
                                }, $this.ec$16).flatMap((Function1 & Serializable)x$35 -> {
                                    Tuple2 tuple2 = x$35;
                                    if (tuple2 != null) {
                                        return Assertions$.MODULE$.futureAssertions(bLedger.exercise(bParty, Fetcher.Fetcher$u0020syntax$.MODULE$.exerciseFetch_$extension(Fetcher$.MODULE$.Fetcher$u0020syntax(fetcher), withKey1, ExerciseOn$.MODULE$.OnId()))).mustFail("contract could not be found", $this.ec$16).map((Function1 & Serializable)fetchFailure -> {
                                            Assertions$.MODULE$.assertGrpcError(fetchFailure, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                                            BoxedUnit x$29 = BoxedUnit.UNIT;
                                            return new Tuple2(fetchFailure, (Object)x$29);
                                        }, $this.ec$16).flatMap((Function1 & Serializable)x$34 -> {
                                            Tuple2 tuple2 = x$34;
                                            if (tuple2 != null) {
                                                return aLedger.create(aParty, (Template)new ExceptionTester(aParty)).flatMap((Function1 & Serializable)tester -> aLedger.exercise(aParty, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseProjectionDivulgence$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(tester), bParty, withKey0, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$33 -> {
                                                    TransactionTree transactionTree = x$33;
                                                    return Synchronize$.MODULE$.synchronize(aLedger, bLedger, $this.ec$16).flatMap((Function1 & Serializable)x$32 -> {
                                                        BoxedUnit boxedUnit = x$32;
                                                        return bLedger.exercise(bParty, Fetcher.Fetcher$u0020syntax$.MODULE$.exerciseFetch_$extension(Fetcher$.MODULE$.Fetcher$u0020syntax(fetcher), withKey0, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$31 -> {
                                                            TransactionTree transactionTree = x$31;
                                                            return bLedger.exercise(bParty, Fetcher.Fetcher$u0020syntax$.MODULE$.exerciseFetch_$extension(Fetcher$.MODULE$.Fetcher$u0020syntax(fetcher), withKey1, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$30 -> {
                                                                $anonfun$$nestedInanonfun$new$16$1.$anonfun$applyOrElse$74(x$30);
                                                                return BoxedUnit.UNIT;
                                                            }, $this.ec$16);
                                                        }, $this.ec$16);
                                                    }, $this.ec$16);
                                                }, $this.ec$16), $this.ec$16);
                                            }
                                            throw new MatchError((Object)tuple2);
                                        }, $this.ec$16);
                                    }
                                    throw new MatchError((Object)tuple2);
                                }, $this.ec$16);
                            }, $this.ec$16), $this.ec$16), $this.ec$16), this.ec$16);
                        }
                    }
                }
                return (B1)function1.apply(x16);
            }

            public final boolean isDefinedAt(Allocation.Participants x16) {
                Allocation.Participants participants = x16;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$74(TransactionTree x$30) {
                TransactionTree transactionTree = x$30;
            }
            {
                this.ec$16 = ec$16;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$62(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$63(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$64(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$65(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$66(java.lang.Throwable ), $anonfun$applyOrElse$67(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$68(java.lang.Throwable ), $anonfun$applyOrElse$69(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$70(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$71(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$72(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$73(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$74$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRollbackProjectionNormalization", "Projection normalization is correctly applied", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$, Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$17;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x17, Function1<A1, B1> function1) {
                A1 A1 = x17;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(3) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    Allocation.Participant participant3 = (Allocation.Participant)A1.participants().apply(2);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext aLedger = participant.context();
                        Object aParty = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext bLedger = participant2.context();
                            Object bParty = participant2.parties().apply(0);
                            if (participant3 != null && participant3.parties() != null && participant3.parties().lengthCompare(1) == 0) {
                                ParticipantTestContext cLedger = participant3.context();
                                Object cParty = participant3.parties().apply(0);
                                return (B1)aLedger.create(aParty, (Template)new Informer(aParty, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bParty})))).flatMap((Function1 & Serializable)abInformer -> aLedger.create(aParty, (Template)new Informer(aParty, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cParty})))).flatMap((Function1 & Serializable)acInformer -> aLedger.create(aParty, (Template)new Informer(aParty, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bParty, cParty})))).flatMap((Function1 & Serializable)abcInformer -> bLedger.create(bParty, (Template)new WithKeyDelegate(aParty, bParty)).flatMap((Function1 & Serializable)keyDelegate -> Synchronize$.MODULE$.synchronize(aLedger, bLedger, $this.ec$17).flatMap((Function1 & Serializable)x$39 -> {
                                    BoxedUnit boxedUnit = x$39;
                                    return Synchronize$.MODULE$.synchronize(aLedger, cLedger, $this.ec$17).flatMap((Function1 & Serializable)x$38 -> {
                                        BoxedUnit boxedUnit = x$38;
                                        return aLedger.create(aParty, (Template)new ExceptionTester(aParty)).flatMap((Function1 & Serializable)tester -> aLedger.exercise(aParty, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseProjectionNormalization$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(tester), bParty, keyDelegate, abInformer, acInformer, abcInformer, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$37 -> {
                                            $anonfun$$nestedInanonfun$new$17$1.$anonfun$applyOrElse$82(x$37);
                                            return BoxedUnit.UNIT;
                                        }, $this.ec$17), $this.ec$17);
                                    }, $this.ec$17);
                                }, $this.ec$17), $this.ec$17), $this.ec$17), $this.ec$17), this.ec$17);
                            }
                        }
                    }
                }
                return (B1)function1.apply(x17);
            }

            public final boolean isDefinedAt(Allocation.Participants x17) {
                Allocation.Participants participants = x17;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(3) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    Allocation.Participant participant3 = (Allocation.Participant)participants.participants().apply(2);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0 && participant3 != null && participant3.parties() != null && participant3.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$82(TransactionTree x$37) {
                TransactionTree transactionTree = x$37;
            }
            {
                this.ec$17 = ec$17;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$75(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$76(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$77(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$78(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$79(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$80(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$81(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$82$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRollbackProjectionNesting", "Nested rollback nodes are handled properly", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$, Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$18;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x18, Function1<A1, B1> function1) {
                A1 A1 = x18;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(3) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    Allocation.Participant participant3 = (Allocation.Participant)A1.participants().apply(2);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext aLedger = participant.context();
                        Object aParty = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext bLedger = participant2.context();
                            Object bParty = participant2.parties().apply(0);
                            if (participant3 != null && participant3.parties() != null && participant3.parties().lengthCompare(1) == 0) {
                                ParticipantTestContext cLedger = participant3.context();
                                Object cParty = participant3.parties().apply(0);
                                return (B1)bLedger.create(bParty, (Template)new WithKeyDelegate(aParty, bParty)).flatMap((Function1 & Serializable)keyDelegate -> cLedger.create(cParty, (Template)new RollbackNestingHelper(aParty, bParty, cParty)).flatMap((Function1 & Serializable)nestingHelper -> Synchronize$.MODULE$.synchronize(aLedger, bLedger, $this.ec$18).flatMap((Function1 & Serializable)x$42 -> {
                                    BoxedUnit boxedUnit = x$42;
                                    return Synchronize$.MODULE$.synchronize(aLedger, cLedger, $this.ec$18).flatMap((Function1 & Serializable)x$41 -> {
                                        BoxedUnit boxedUnit = x$41;
                                        return aLedger.create(aParty, (Template)new ExceptionTester(aParty)).flatMap((Function1 & Serializable)tester -> aLedger.exercise(aParty, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseProjectionNesting$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(tester), bParty, keyDelegate, nestingHelper, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$40 -> {
                                            $anonfun$$nestedInanonfun$new$18$1.$anonfun$applyOrElse$88(x$40);
                                            return BoxedUnit.UNIT;
                                        }, $this.ec$18), $this.ec$18);
                                    }, $this.ec$18);
                                }, $this.ec$18), $this.ec$18), this.ec$18);
                            }
                        }
                    }
                }
                return (B1)function1.apply(x18);
            }

            public final boolean isDefinedAt(Allocation.Participants x18) {
                Allocation.Participants participants = x18;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(3) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    Allocation.Participant participant3 = (Allocation.Participant)participants.participants().apply(2);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0 && participant3 != null && participant3.parties() != null && participant3.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$88(TransactionTree x$40) {
                TransactionTree transactionTree = x$40;
            }
            {
                this.ec$18 = ec$18;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$83(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$18$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$84(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$18$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$85(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$18$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$86(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$18$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$87(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$18$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$88$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExCKRollbackGlobalArchivedLookup", "Create with key succeeds after archive & rolledback negative lookup", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$19;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x19, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x19;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.create(party, (Template)new WithSimpleKey(party)).flatMap((Function1 & Serializable)withKey -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackGlobalArchivedLookup$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), withKey, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$43 -> {
                        $anonfun$$nestedInanonfun$new$19$1.$anonfun$applyOrElse$91(x$43);
                        return BoxedUnit.UNIT;
                    }, $this.ec$19), $this.ec$19), this.ec$19);
                }
                return (B1)function1.apply(x19);
            }

            public final boolean isDefinedAt(Allocation.Participants x19) {
                Allocation.Participant participant;
                Allocation.Participants participants = x19;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$91(TransactionTree x$43) {
                TransactionTree transactionTree = x$43;
            }
            {
                this.ec$19 = ec$19;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$89(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$19$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$90(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$19$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$91$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExCKRollbackGlobalArchivedCreate", "Create with key succeeds after archive & rolledback negative lookup", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$20;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x20, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x20;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> ledger.create(party, (Template)new WithSimpleKey(party)).flatMap((Function1 & Serializable)withKey -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackGlobalArchivedCreate$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), withKey, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$44 -> {
                        $anonfun$$nestedInanonfun$new$20$1.$anonfun$applyOrElse$94(x$44);
                        return BoxedUnit.UNIT;
                    }, $this.ec$20), $this.ec$20), this.ec$20);
                }
                return (B1)function1.apply(x20);
            }

            public final boolean isDefinedAt(Allocation.Participants x20) {
                Allocation.Participant participant;
                Allocation.Participants participants = x20;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$94(TransactionTree x$44) {
                TransactionTree transactionTree = x$44;
            }
            {
                this.ec$20 = ec$20;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$92(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$20$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$93(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$20$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$94$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ExRollbackCreate", "Archiving a contract created within a rolled-back try-catch block, fails", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$21;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x21, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x21;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)t -> Assertions$.MODULE$.futureAssertions(ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackCreateBecomesInactive$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(t), ExerciseOn$.MODULE$.OnId()))).mustFail("contract is inactive", $this.ec$21).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$21$1.$anonfun$applyOrElse$96(failure);
                        return BoxedUnit.UNIT;
                    }, $this.ec$21), this.ec$21);
                }
                return (B1)function1.apply(x21);
            }

            public final boolean isDefinedAt(Allocation.Participants x21) {
                Allocation.Participant participant;
                Allocation.Participants participants = x21;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$96(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$21 = ec$21;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$95(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$21$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$96$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("ExRollbackExerciseCreateLookup", "Lookup a contract Archiving a contract created within a rolled-back try-catch block, fails", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$22;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x22, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x22;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new ExceptionTester(party)).flatMap((Function1 & Serializable)helper -> ledger.create(party, (Template)new WithSimpleKey(party)).flatMap((Function1 & Serializable)withKey -> ledger.exercise(party, ExceptionTester.ExceptionTester$u0020syntax$.MODULE$.exerciseRollbackExerciseCreateLookup$extension(ExceptionTester$.MODULE$.ExceptionTester$u0020syntax(helper), withKey, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$45 -> {
                        $anonfun$$nestedInanonfun$new$22$1.$anonfun$applyOrElse$99(x$45);
                        return BoxedUnit.UNIT;
                    }, $this.ec$22), $this.ec$22), this.ec$22);
                }
                return (B1)function1.apply(x22);
            }

            public final boolean isDefinedAt(Allocation.Participants x22) {
                Allocation.Participant participant;
                Allocation.Participants participants = x22;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$99(TransactionTree x$45) {
                TransactionTree transactionTree = x$45;
            }
            {
                this.ec$22 = ec$22;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$97(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$22$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$98(com.daml.ledger.api.testtool.suites.v1_14.ExceptionsIT$$anonfun$$nestedInanonfun$new$22$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$99$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
    }
}

