/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.FutureAssertions;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$;
import com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$;
import com.daml.ledger.api.v1.active_contracts_service.GetActiveContractsRequest;
import com.daml.ledger.api.v1.active_contracts_service.GetActiveContractsRequest$;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.event.Event;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.v1.transaction.Transaction;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.api.v1.transaction_filter.Filters;
import com.daml.ledger.api.v1.transaction_filter.Filters$;
import com.daml.ledger.api.v1.transaction_filter.InclusiveFilters;
import com.daml.ledger.api.v1.transaction_filter.InclusiveFilters$;
import com.daml.ledger.api.v1.transaction_filter.TransactionFilter;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest$;
import com.daml.ledger.api.v1.value.Identifier;
import com.daml.ledger.api.v1.value.Record;
import com.daml.ledger.api.v1.value.RecordField;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.test.model.Test.Divulgence1;
import com.daml.ledger.test.model.Test.Divulgence2;
import com.daml.ledger.test.model.Test.Divulgence2$;
import com.daml.ledger.test.model.Test.Dummy;
import com.daml.ledger.test.model.Test.Dummy$;
import com.daml.ledger.test.model.Test.DummyFactory;
import com.daml.ledger.test.model.Test.DummyFactory$;
import com.daml.ledger.test.model.Test.DummyWithParam;
import com.daml.ledger.test.model.Test.DummyWithParam$;
import com.daml.ledger.test.model.Test.TriAgreement;
import com.daml.ledger.test.model.Test.TriAgreement$;
import com.daml.ledger.test.model.Test.TriProposal;
import com.daml.ledger.test.model.Test.TriProposal$;
import com.daml.ledger.test.model.Test.WithObservers;
import com.daml.ledger.test.model.Test.WithObservers$;
import com.daml.ledger.test.model.Test.Witnesses;
import com.daml.ledger.test.model.Test.Witnesses$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;
import scalaz.syntax.TagOps$;
import scalaz.syntax.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001\u0002\u0003\u0006\u0001QAQa\u0007\u0001\u0005\u0002qAQa\b\u0001\u0005\n\u0001BQA\u001c\u0001\u0005\n=\u0014\u0001$Q2uSZ,7i\u001c8ue\u0006\u001cGo]*feZL7-Z%U\u0015\t1q!\u0001\u0003wc}C$B\u0001\u0005\n\u0003\u0019\u0019X/\u001b;fg*\u0011!bC\u0001\ti\u0016\u001cH\u000f^8pY*\u0011A\"D\u0001\u0004CBL'B\u0001\b\u0010\u0003\u0019aW\rZ4fe*\u0011\u0001#E\u0001\u0005I\u0006lGNC\u0001\u0013\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0013\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017B\u0001\u000e\u0018\u0005=aU\rZ4feR+7\u000f^*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0006\u0003Q\u0019'/Z1uK\u0012+X.\\=D_:$(/Y2ugR\u0019\u0011EY4\u0015\u0005\tj\u0006cA\u0012)U5\tAE\u0003\u0002&M\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0013\u0003\r\u0019+H/\u001e:f!\u0015YCFL+Z\u001b\u00051\u0013BA\u0017'\u0005\u0019!V\u000f\u001d7fgA\u0019qfR&\u000f\u0005A\"eBA\u0019B\u001d\t\u0011dH\u0004\u00024y9\u0011Ag\u000f\b\u0003kir!AN\u001d\u000e\u0003]R!\u0001O\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012B\u0001\t\u0012\u0013\tqq\"\u0003\u0002>\u001b\u000511\r\\5f]RL!a\u0010!\u0002\u000f\tLg\u000eZ5oO*\u0011Q(D\u0005\u0003\u0005\u000e\u000bq\u0001]1dW\u0006<WM\u0003\u0002@\u0001&\u0011QIR\u0001\n!JLW.\u001b;jm\u0016T!AQ\"\n\u0005!K%AC\"p]R\u0014\u0018m\u0019;JI&\u0011!j\u0011\u0002\n!JLW.\u001b;jm\u0016\u0004\"\u0001T*\u000e\u00035S!AT(\u0002\tQ+7\u000f\u001e\u0006\u0003!F\u000bQ!\\8eK2T!AU\u0007\u0002\tQ,7\u000f^\u0005\u0003)6\u0013Q\u0001R;n[f\u00042aL$W!\tau+\u0003\u0002Y\u001b\nqA)^7ns^KG\u000f\u001b)be\u0006l\u0007cA\u0018H5B\u0011AjW\u0005\u000396\u0013A\u0002R;n[f4\u0015m\u0019;pefDQA\u0018\u0002A\u0004}\u000b!!Z2\u0011\u0005\r\u0002\u0017BA1%\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003d\u0005\u0001\u0007A-A\u0003qCJ$\u0018\u0010\u0005\u00020K&\u0011a-\u0013\u0002\u0006!\u0006\u0014H/\u001f\u0005\u0006\u001d\t\u0001\r\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W^\t1\u0002]1si&\u001c\u0017\u000e]1oi&\u0011QN\u001b\u0002\u0017!\u0006\u0014H/[2ja\u0006tG\u000fV3ti\u000e{g\u000e^3yi\u0006y\u0011m]:feR$V-\u001c9mCR,7/F\u0002q\u0003[!r!\u001d;~\u0003?\ty\u0004\u0005\u0002,e&\u00111O\n\u0002\u0005+:LG\u000fC\u0003d\u0007\u0001\u0007Q\u000fE\u0002ww\u0012l\u0011a\u001e\u0006\u0003qf\f\u0011\"[7nkR\f'\r\\3\u000b\u0005i4\u0013AC2pY2,7\r^5p]&\u0011Ap\u001e\u0002\u0004'\u0016\f\b\"\u0002@\u0004\u0001\u0004y\u0018AB3wK:$8\u000f\u0005\u0004\u0002\u0002\u0005%\u0011q\u0002\b\u0005\u0003\u0007\t9AD\u00027\u0003\u000bI\u0011aJ\u0005\u0003\u0005\u001aJA!a\u0003\u0002\u000e\t1a+Z2u_JT!A\u0011\u0014\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005)QM^3oi*\u0019\u0011\u0011D\u0006\u0002\u0005Y\f\u0014\u0002BA\u000f\u0003'\u0011Ab\u0011:fCR,G-\u0012<f]RDq!!\t\u0004\u0001\u0004\t\u0019#\u0001\u0006uK6\u0004H.\u0019;f\u0013\u0012\u0004RaLA\u0013\u0003SI1!a\nJ\u0005)!V-\u001c9mCR,\u0017\n\u001a\t\u0005\u0003W\ti\u0003\u0004\u0001\u0005\u000f\u0005=2A1\u0001\u00022\t\t\u0011)\u0005\u0003\u00024\u0005e\u0002cA\u0016\u00026%\u0019\u0011q\u0007\u0014\u0003\u000f9{G\u000f[5oOB\u00191&a\u000f\n\u0007\u0005ubEA\u0002B]fDq!!\u0011\u0004\u0001\u0004\t\u0019%A\u0003d_VtG\u000fE\u0002,\u0003\u000bJ1!a\u0012'\u0005\rIe\u000e\u001e")
public class ActiveContractsServiceIT
extends LedgerTestSuite {
    public Future<Tuple3<Object, Object, Object>> com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$createDummyContracts(Object party, ParticipantTestContext ledger, ExecutionContext ec) {
        return ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> ledger.create(party, (Template)new DummyWithParam(party)).flatMap((Function1 & Serializable)dummyWithParam -> ledger.create(party, (Template)new DummyFactory(party)).map((Function1 & Serializable)dummyFactory -> new Tuple3(dummy, dummyWithParam, dummyFactory), ec), ec), ec);
    }

    public <A> void com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates(Seq<Object> party, Vector<CreatedEvent> events, Object templateId, int count) {
        int templateEvents = events.count((Function1 & Serializable)x$95 -> BoxesRunTime.boxToBoolean((boolean)ActiveContractsServiceIT.$anonfun$assertTemplates$1(templateId, x$95)));
        Predef$.MODULE$.assert(templateEvents == count, (Function0 & Serializable)() -> new StringBuilder(34).append(party.mkString(" and ")).append(" expected ").append(count).append(" ").append(templateId).append(" events, but received ").append(templateEvents).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$assertTemplates$1(Object templateId$2, CreatedEvent x$95) {
        Identifier identifier = x$95.getTemplateId();
        Object object = TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(templateId$2));
        return !(identifier != null ? !identifier.equals(object) : object != null);
    }

    public ActiveContractsServiceIT() {
        this.test("ACSinvalidLedgerId", "The ActiveContractService should fail for requests with an invalid ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null) {
                    ParticipantTestContext ledger = participant.context();
                    Seq parties = participant.parties();
                    String invalidLedgerId = "ACSinvalidLedgerId";
                    GetActiveContractsRequest invalidRequest = (GetActiveContractsRequest)ledger.activeContractsRequest(parties, ledger.activeContractsRequest$default$2(), ledger.activeContractsRequest$default$3(), ledger.activeContractsRequest$default$4()).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$1 -> GetActiveContractsRequest$.MODULE$.GetActiveContractsRequestLens(x$1).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.activeContracts(invalidRequest)).mustFail("retrieving active contracts", this.ec$1).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$2(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)"not found. Actual Ledger ID"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$2$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("ACSemptyResponse", "The ActiveContractService should succeed with an empty response if no contracts have been created for a party", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)activeContracts -> {
                        $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$3(activeContracts);
                        return BoxedUnit.UNIT;
                    }, this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(Vector activeContracts) {
                Predef$.MODULE$.assert(activeContracts.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(50).append("There should be no active contracts, but received ").append(activeContracts).toString());
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3$adapted(scala.collection.immutable.Vector ), $anonfun$applyOrElse$4(scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("ACSallContracts", "The ActiveContractService should return all active contracts", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ActiveContractsServiceIT $outer;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$createDummyContracts(party, ledger, this.ec$3).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$5(check$ifrefutable$1)), this.ec$3).flatMap((Function1 & Serializable)x$7 -> {
                        Tuple3 tuple3 = x$7;
                        if (tuple3 != null) {
                            Object dummy = tuple3._1();
                            Object dummyWithParam = tuple3._2();
                            Object dummyFactory = tuple3._3();
                            return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)activeContracts -> {
                                $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$7(dummy, dummyWithParam, dummyFactory, party, activeContracts);
                                return BoxedUnit.UNIT;
                            }, $this.ec$3);
                        }
                        throw new MatchError((Object)tuple3);
                    }, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$5(Tuple3 check$ifrefutable$1) {
                Tuple3 tuple3 = check$ifrefutable$1;
                return tuple3 != null;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$9(Object dummy$1, CreatedEvent x$2) {
                String string = x$2.contractId();
                Object object = dummy$1;
                return !(string != null ? !string.equals(object) : object != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$11(Object dummyWithParam$1, CreatedEvent x$3) {
                String string = x$3.contractId();
                Object object = dummyWithParam$1;
                return !(string != null ? !string.equals(object) : object != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$13(Object dummyFactory$1, CreatedEvent x$4) {
                String string = x$4.contractId();
                Object object = dummyFactory$1;
                return !(string != null ? !string.equals(object) : object != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$15(Object party$1, CreatedEvent x$5) {
                Seq seq = x$5.signatories();
                .colon.colon colon2 = new .colon.colon((Object)((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(party$1))), (List)Nil$.MODULE$);
                return !(seq != null ? !seq.equals(colon2) : colon2 != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$17(CreatedEvent x$6) {
                return x$6.observers().isEmpty();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$7(Object dummy$1, Object dummyWithParam$1, Object dummyFactory$1, Object party$1, Vector activeContracts) {
                Predef$.MODULE$.assert(activeContracts.size() == 3, (Function0 & Serializable)() -> new StringBuilder(36).append("Expected 3 contracts, but received ").append(activeContracts.size()).append(".").toString());
                Predef$.MODULE$.assert(activeContracts.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$9(dummy$1, x$2))), (Function0 & Serializable)() -> new StringBuilder(44).append("Didn't find Dummy contract with contractId ").append(dummy$1).append(".").toString());
                Predef$.MODULE$.assert(activeContracts.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$11(dummyWithParam$1, x$3))), (Function0 & Serializable)() -> new StringBuilder(53).append("Didn't find DummyWithParam contract with contractId ").append(dummy$1).append(".").toString());
                Predef$.MODULE$.assert(activeContracts.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$13(dummyFactory$1, x$4))), (Function0 & Serializable)() -> new StringBuilder(51).append("Didn't find DummyFactory contract with contractId ").append(dummy$1).append(".").toString());
                Vector invalidSignatories = (Vector)activeContracts.filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$15(party$1, x$5)));
                Predef$.MODULE$.assert(invalidSignatories.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(46).append("Found contracts with signatories other than ").append(party$1).append(": ").append(invalidSignatories).toString());
                Vector invalidObservers = (Vector)activeContracts.filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$17(x$6)));
                Predef$.MODULE$.assert(invalidObservers.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(42).append("Found contracts with non-empty observers: ").append(invalidObservers).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(java.lang.Object ), $anonfun$applyOrElse$11$adapted(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$12(java.lang.Object ), $anonfun$applyOrElse$13$adapted(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$14(java.lang.Object ), $anonfun$applyOrElse$15$adapted(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$16(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$17$adapted(com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$18(scala.collection.immutable.Vector ), $anonfun$applyOrElse$5$adapted(scala.Tuple3 ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$7$adapted(java.lang.Object java.lang.Object java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$8(scala.collection.immutable.Vector ), $anonfun$applyOrElse$9$adapted(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent )}, serializedLambda);
            }
        });
        this.test("ACSfilterContracts", "The ActiveContractService should return contracts filtered by templateId", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ActiveContractsServiceIT $outer;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$createDummyContracts(party, ledger, this.ec$4).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$19(check$ifrefutable$2)), this.ec$4).flatMap((Function1 & Serializable)x$8 -> {
                        Tuple3 tuple3 = x$8;
                        if (tuple3 != null) {
                            Object dummy = tuple3._1();
                            return ledger.activeContractsByTemplateId((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Dummy$.MODULE$.id()})), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)activeContracts -> {
                                $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$21(dummy, activeContracts);
                                return BoxedUnit.UNIT;
                            }, $this.ec$4);
                        }
                        throw new MatchError((Object)tuple3);
                    }, this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$19(Tuple3 check$ifrefutable$2) {
                Tuple3 tuple3 = check$ifrefutable$2;
                return tuple3 != null;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$21(Object dummy$2, Vector activeContracts) {
                Predef$.MODULE$.assert(activeContracts.size() == 1, (Function0 & Serializable)() -> new StringBuilder(35).append("Expected 1 contract, but received ").append(activeContracts.size()).append(".").toString());
                Identifier identifier = ((CreatedEvent)activeContracts.head()).getTemplateId();
                Object object = TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()));
                Predef$.MODULE$.assert(!(identifier != null ? !identifier.equals(object) : object != null), (Function0 & Serializable)() -> new StringBuilder(45).append("Received contract is not of type Dummy, but ").append(((CreatedEvent)activeContracts.head()).templateId()).append(".").toString());
                String string = ((CreatedEvent)activeContracts.head()).contractId();
                Object object2 = dummy$2;
                Predef$.MODULE$.assert(!(string != null ? !string.equals(object2) : object2 != null), (Function0 & Serializable)() -> new StringBuilder(50).append("Expected contract with contractId ").append(dummy$2).append(", but received ").append(((CreatedEvent)activeContracts.head()).contractId()).append(".").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$19$adapted(scala.Tuple3 ), $anonfun$applyOrElse$20(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$21$adapted(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$22(scala.collection.immutable.Vector ), $anonfun$applyOrElse$23(scala.collection.immutable.Vector ), $anonfun$applyOrElse$24(java.lang.Object scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("ACSarchivedContracts", "The ActiveContractService does not return archived contracts", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ActiveContractsServiceIT $outer;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$createDummyContracts(party, ledger, this.ec$5).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$25(check$ifrefutable$3)), this.ec$5).flatMap((Function1 & Serializable)x$13 -> {
                        Tuple3 tuple3 = x$13;
                        if (tuple3 != null) {
                            Object dummy = tuple3._1();
                            return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).flatMap((Function1 & Serializable)contractsBeforeExercise -> ledger.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$12 -> {
                                TransactionTree transactionTree = x$12;
                                return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)contractsAfterExercise -> {
                                    $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$29(contractsBeforeExercise, dummy, contractsAfterExercise);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$5);
                            }, $this.ec$5), $this.ec$5);
                        }
                        throw new MatchError((Object)tuple3);
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$25(Tuple3 check$ifrefutable$3) {
                Tuple3 tuple3 = check$ifrefutable$3;
                return tuple3 != null;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$31(Object dummy$3, CreatedEvent x$9) {
                String string = x$9.contractId();
                Object object = dummy$3;
                return !(string != null ? !string.equals(object) : object != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$35(Object dummy$3, CreatedEvent x$11) {
                String string = x$11.contractId();
                Object object = dummy$3;
                return !(string != null ? !string.equals(object) : object != null);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$29(Vector contractsBeforeExercise$1, Object dummy$3, Vector contractsAfterExercise) {
                Predef$.MODULE$.assert(contractsBeforeExercise$1.size() == 3, (Function0 & Serializable)() -> new StringBuilder(36).append("Expected 3 contracts, but received ").append(contractsBeforeExercise$1.size()).append(".").toString());
                Predef$.MODULE$.assert(contractsBeforeExercise$1.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$31(dummy$3, x$9))), (Function0 & Serializable)() -> new StringBuilder(69).append("Expected to receive contract with contractId ").append(dummy$3).append(", but received ").append(((IterableOnceOps)contractsBeforeExercise$1.map((Function1 & Serializable)x$10 -> x$10.contractId())).mkString(", ")).append(" instead.").toString());
                Predef$.MODULE$.assert(contractsAfterExercise.size() == 2, (Function0 & Serializable)() -> new StringBuilder(35).append("Expected 2 contracts, but received ").append(contractsAfterExercise.size()).toString());
                Predef$.MODULE$.assert(!contractsAfterExercise.exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$35(dummy$3, x$11))), (Function0 & Serializable)() -> new StringBuilder(50).append("Expected to not receive contract with contractId ").append(dummy$3).append(".").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$25$adapted(scala.Tuple3 ), $anonfun$applyOrElse$26(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$27(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$28(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.collection.immutable.Vector java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$29$adapted(scala.collection.immutable.Vector java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$30(scala.collection.immutable.Vector ), $anonfun$applyOrElse$31$adapted(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$32(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$33(com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$34(scala.collection.immutable.Vector ), $anonfun$applyOrElse$35$adapted(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$36(java.lang.Object )}, serializedLambda);
            }
        });
        this.test("ACSusableOffset", "The ActiveContractService should return a usable offset to resume streaming transactions", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> ledger.activeContracts(ledger.activeContractsRequest((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.activeContractsRequest$default$2(), ledger.activeContractsRequest$default$3(), ledger.activeContractsRequest$default$4())).withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$38(check$ifrefutable$4)), $this.ec$6).flatMap((Function1 & Serializable)x$18 -> {
                        Tuple2 tuple2 = x$18;
                        if (tuple2 != null) {
                            Option option = (Option)tuple2._1();
                            Vector onlyDummy = (Vector)tuple2._2();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                LedgerOffset offset = (LedgerOffset)some.value();
                                return ledger.create(party, (Template)new DummyWithParam(party)).map((Function1 & Serializable)dummyWithParam -> {
                                    GetTransactionsRequest request = ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2());
                                    GetTransactionsRequest fromOffset = (GetTransactionsRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$14 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$14).begin().$colon$eq((Object)offset)}));
                                    return new Tuple3(dummyWithParam, (Object)request, (Object)fromOffset);
                                }, $this.ec$6).flatMap((Function1 & Serializable)x$17 -> {
                                    Tuple3 tuple3 = x$17;
                                    if (tuple3 != null) {
                                        Object dummyWithParam = tuple3._1();
                                        GetTransactionsRequest fromOffset = (GetTransactionsRequest)tuple3._3();
                                        return ledger.flatTransactions(fromOffset).map((Function1 & Serializable)transactions -> {
                                            $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$43(onlyDummy, dummy, offset, dummyWithParam, transactions);
                                            return BoxedUnit.UNIT;
                                        }, $this.ec$6);
                                    }
                                    throw new MatchError((Object)tuple3);
                                }, $this.ec$6);
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }, $this.ec$6), this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$38(Tuple2 check$ifrefutable$4) {
                Option option;
                Tuple2 tuple2 = check$ifrefutable$4;
                return tuple2 != null && (option = (Option)tuple2._1()) instanceof Some;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$44(Object dummy$4, CreatedEvent x$15) {
                String string = x$15.contractId();
                Object object = dummy$4;
                return !(string != null ? !string.equals(object) : object != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$48(Object dummyWithParam$2, CreatedEvent x$16) {
                String string = x$16.contractId();
                Object object = dummyWithParam$2;
                return !(string != null ? !string.equals(object) : object != null);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$43(Vector onlyDummy$1, Object dummy$4, LedgerOffset offset$1, Object dummyWithParam$2, Vector transactions) {
                Predef$.MODULE$.assert(onlyDummy$1.size() == 1);
                Predef$.MODULE$.assert(onlyDummy$1.exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$44(dummy$4, x$15))), (Function0 & Serializable)() -> new StringBuilder(64).append("Expected to receive ").append(dummy$4).append(" in active contracts, but didn't receive it.").toString());
                Predef$.MODULE$.assert(transactions.size() == 1, (Function0 & Serializable)() -> new StringBuilder(67).append("Expected to receive only 1 transaction from offset ").append(offset$1).append(", but received ").append(transactions.size()).append(".").toString());
                Transaction transaction = (Transaction)transactions.head();
                Predef$.MODULE$.assert(transaction.events().size() == 1, (Function0 & Serializable)() -> new StringBuilder(56).append("Expected only 1 event in the transaction, but received ").append(transaction.events().size()).append(".").toString());
                Seq createdEvent = (Seq)transaction.events().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Event, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Event.Event event;
                        A1 A1 = x1;
                        if (A1 != null && (event = A1.event()) instanceof Event.Event$.Created) {
                            Event.Event$.Created created = (Event.Event$.Created)event;
                            CreatedEvent createdEvent = created.value();
                            return (B1)createdEvent;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Event x1) {
                        Event.Event event;
                        Event event2 = x1;
                        return event2 != null && (event = event2.event()) instanceof Event.Event$.Created;
                    }
                });
                Predef$.MODULE$.assert(createdEvent.exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$48(dummyWithParam$2, x$16))), (Function0 & Serializable)() -> new StringBuilder(43).append("Expected a CreateEvent for ").append(dummyWithParam$2).append(", but received ").append(createdEvent).append(".").toString());
            }
            {
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$37(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$38$adapted(scala.Tuple2 ), $anonfun$applyOrElse$39(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$40(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object ), $anonfun$applyOrElse$41(com.daml.ledger.api.v1.ledger_offset.LedgerOffset scalapb.lenses.Lens ), $anonfun$applyOrElse$42(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.collection.immutable.Vector java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset scala.Tuple3 ), $anonfun$applyOrElse$43$adapted(scala.collection.immutable.Vector java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$44$adapted(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$45(java.lang.Object ), $anonfun$applyOrElse$46(com.daml.ledger.api.v1.ledger_offset.LedgerOffset scala.collection.immutable.Vector ), $anonfun$applyOrElse$47(com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$48$adapted(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$49(java.lang.Object scala.collection.immutable.Seq )}, serializedLambda);
            }
        });
        this.test("ACSverbosity", "The ActiveContractService should emit field names only if the verbose flag is set to true", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).map((Function1 & Serializable)x$27 -> {
                        GetActiveContractsRequest verboseRequest = (GetActiveContractsRequest)ledger.activeContractsRequest((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.activeContractsRequest$default$2(), ledger.activeContractsRequest$default$3(), ledger.activeContractsRequest$default$4()).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$19 -> GetActiveContractsRequest$.MODULE$.GetActiveContractsRequestLens(x$19).verbose().$colon$eq((Object)BoxesRunTime.boxToBoolean((boolean)true))}));
                        GetActiveContractsRequest nonVerboseRequest = (GetActiveContractsRequest)verboseRequest.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$20 -> GetActiveContractsRequest$.MODULE$.GetActiveContractsRequestLens(x$20).verbose().$colon$eq((Object)BoxesRunTime.boxToBoolean((boolean)false))}));
                        return new Tuple3(x$27, (Object)verboseRequest, (Object)nonVerboseRequest);
                    }, this.ec$7).flatMap((Function1 & Serializable)x$30 -> {
                        Tuple3 tuple3 = x$30;
                        if (tuple3 != null) {
                            GetActiveContractsRequest verboseRequest = (GetActiveContractsRequest)tuple3._2();
                            GetActiveContractsRequest nonVerboseRequest = (GetActiveContractsRequest)tuple3._3();
                            return ledger.activeContracts(verboseRequest).withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$54(check$ifrefutable$5)), $this.ec$7).flatMap((Function1 & Serializable)x$29 -> {
                                Tuple2 tuple2 = x$29;
                                if (tuple2 != null) {
                                    Vector verboseEvents = (Vector)tuple2._2();
                                    return ledger.activeContracts(nonVerboseRequest).withFilter((Function1 & Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$56(check$ifrefutable$6)), $this.ec$7).map((Function1 & Serializable)x$28 -> {
                                        $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$57(verboseEvents, party, x$28);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$7);
                                }
                                throw new MatchError((Object)tuple2);
                            }, $this.ec$7);
                        }
                        throw new MatchError((Object)tuple3);
                    }, this.ec$7);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$54(Tuple2 check$ifrefutable$5) {
                Tuple2 tuple2 = check$ifrefutable$5;
                return tuple2 != null;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$56(Tuple2 check$ifrefutable$6) {
                Tuple2 tuple2 = check$ifrefutable$6;
                return tuple2 != null;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$60(RecordField x$23) {
                return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$23.label()));
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$64(RecordField x$26) {
                return x$26.label().isEmpty();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$57(Vector verboseEvents$1, Object party$5, Tuple2 x$28) {
                Tuple2 tuple2 = x$28;
                if (tuple2 != null) {
                    Vector nonVerboseEvents = (Vector)tuple2._2();
                    Vector verboseCreateArgs = (Vector)((StrictOptimizedIterableOps)verboseEvents$1.map((Function1 & Serializable)x$21 -> x$21.getCreateArguments())).flatMap((Function1 & Serializable)x$22 -> x$22.fields());
                    Predef$.MODULE$.assert(verboseEvents$1.nonEmpty() && verboseCreateArgs.forall((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$60(x$23))), (Function0 & Serializable)() -> new StringBuilder(48).append(party$5).append(" expected a contract with labels, but received ").append(verboseEvents$1).append(".").toString());
                    Vector nonVerboseCreateArgs = (Vector)((StrictOptimizedIterableOps)nonVerboseEvents.map((Function1 & Serializable)x$24 -> x$24.getCreateArguments())).flatMap((Function1 & Serializable)x$25 -> x$25.fields());
                    Predef$.MODULE$.assert(nonVerboseEvents.nonEmpty() && nonVerboseCreateArgs.forall((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$64(x$26))), (Function0 & Serializable)() -> new StringBuilder(51).append(party$5).append(" expected a contract without labels, but received ").append(nonVerboseEvents).append(".").toString());
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$50(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$51(scalapb.lenses.Lens ), $anonfun$applyOrElse$52(scalapb.lenses.Lens ), $anonfun$applyOrElse$53(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$54$adapted(scala.Tuple2 ), $anonfun$applyOrElse$55(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.active_contracts_service.GetActiveContractsRequest java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$56$adapted(scala.Tuple2 ), $anonfun$applyOrElse$57$adapted(scala.collection.immutable.Vector java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$58(com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$59(com.daml.ledger.api.v1.value.Record ), $anonfun$applyOrElse$60$adapted(com.daml.ledger.api.v1.value.RecordField ), $anonfun$applyOrElse$61(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$62(com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$63(com.daml.ledger.api.v1.value.Record ), $anonfun$applyOrElse$64$adapted(com.daml.ledger.api.v1.value.RecordField ), $anonfun$applyOrElse$65(java.lang.Object scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("ACSmultiParty", "The ActiveContractsService should return contracts for the requesting parties", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ActiveContractsServiceIT $outer;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$createDummyContracts(alice, ledger, this.ec$8).flatMap((Function1 & Serializable)x$32 -> {
                        Tuple3 tuple3 = x$32;
                        return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$createDummyContracts(bob, ledger, $this.ec$8).flatMap((Function1 & Serializable)x$31 -> {
                            Tuple3 tuple3 = x$31;
                            return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice})).flatMap((Function1 & Serializable)allContractsForAlice -> ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob})).flatMap((Function1 & Serializable)allContractsForBob -> ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice, bob})).flatMap((Function1 & Serializable)allContractsForAliceAndBob -> ledger.activeContractsByTemplateId((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Dummy$.MODULE$.id()})), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice})).flatMap((Function1 & Serializable)dummyContractsForAlice -> ledger.activeContractsByTemplateId((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Dummy$.MODULE$.id()})), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice, bob})).map((Function1 & Serializable)dummyContractsForAliceAndBob -> {
                                $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$72(this, allContractsForAlice, alice, allContractsForBob, bob, allContractsForAliceAndBob, dummyContractsForAlice, dummyContractsForAliceAndBob);
                                return BoxedUnit.UNIT;
                            }, $this.ec$8), $this.ec$8), $this.ec$8), $this.ec$8), $this.ec$8);
                        }, $this.ec$8);
                    }, this.ec$8);
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participant participant;
                Allocation.Participants participants = x8;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$72($anonfun$$nestedInanonfun$new$8$1 $this, Vector allContractsForAlice$1, Object alice$1, Vector allContractsForBob$1, Object bob$1, Vector allContractsForAliceAndBob$1, Vector dummyContractsForAlice$1, Vector dummyContractsForAliceAndBob) {
                Predef$.MODULE$.assert(allContractsForAlice$1.size() == 3, (Function0 & Serializable)() -> new StringBuilder(34).append(alice$1).append(" expected 3 events, but received ").append(allContractsForAlice$1.size()).append(".").toString());
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice$1}))), (Vector<CreatedEvent>)allContractsForAlice$1, Dummy$.MODULE$.id(), 1);
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice$1}))), (Vector<CreatedEvent>)allContractsForAlice$1, DummyWithParam$.MODULE$.id(), 1);
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice$1}))), (Vector<CreatedEvent>)allContractsForAlice$1, DummyFactory$.MODULE$.id(), 1);
                Predef$.MODULE$.assert(allContractsForBob$1.size() == 3, (Function0 & Serializable)() -> new StringBuilder(34).append(bob$1).append(" expected 3 events, but received ").append(allContractsForBob$1.size()).append(".").toString());
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob$1}))), (Vector<CreatedEvent>)allContractsForBob$1, Dummy$.MODULE$.id(), 1);
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob$1}))), (Vector<CreatedEvent>)allContractsForBob$1, DummyWithParam$.MODULE$.id(), 1);
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob$1}))), (Vector<CreatedEvent>)allContractsForBob$1, DummyFactory$.MODULE$.id(), 1);
                Predef$.MODULE$.assert(allContractsForAliceAndBob$1.size() == 6, (Function0 & Serializable)() -> new StringBuilder(39).append(alice$1).append(" and ").append(bob$1).append(" expected 6 events, but received ").append(allContractsForAliceAndBob$1.size()).append(".").toString());
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice$1, bob$1}))), (Vector<CreatedEvent>)allContractsForAliceAndBob$1, Dummy$.MODULE$.id(), 2);
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice$1, bob$1}))), (Vector<CreatedEvent>)allContractsForAliceAndBob$1, DummyWithParam$.MODULE$.id(), 2);
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice$1, bob$1}))), (Vector<CreatedEvent>)allContractsForAliceAndBob$1, DummyFactory$.MODULE$.id(), 2);
                Predef$.MODULE$.assert(dummyContractsForAlice$1.size() == 1, (Function0 & Serializable)() -> new StringBuilder(33).append(alice$1).append(" expected 1 event, but received ").append(dummyContractsForAlice$1.size()).append(".").toString());
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice$1}))), (Vector<CreatedEvent>)dummyContractsForAlice$1, Dummy$.MODULE$.id(), 1);
                Predef$.MODULE$.assert(dummyContractsForAliceAndBob.size() == 2, (Function0 & Serializable)() -> new StringBuilder(39).append(alice$1).append(" and ").append(bob$1).append(" expected 2 events, but received ").append(dummyContractsForAliceAndBob.size()).append(".").toString());
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$ActiveContractsServiceIT$$assertTemplates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice$1, bob$1}))), (Vector<CreatedEvent>)dummyContractsForAliceAndBob, Dummy$.MODULE$.id(), 2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$66(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$8$1 java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$67(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$68(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$69(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector scala.collection.immutable.Vector ), $anonfun$applyOrElse$70(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector scala.collection.immutable.Vector scala.collection.immutable.Vector ), $anonfun$applyOrElse$71(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector scala.collection.immutable.Vector scala.collection.immutable.Vector scala.collection.immutable.Vector ), $anonfun$applyOrElse$72$adapted(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$8$1 scala.collection.immutable.Vector java.lang.Object scala.collection.immutable.Vector java.lang.Object scala.collection.immutable.Vector scala.collection.immutable.Vector scala.collection.immutable.Vector ), $anonfun$applyOrElse$73(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$74(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$75(java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$76(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$77(java.lang.Object java.lang.Object scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("ACSagreementText", "The ActiveContractService should properly fill the agreementText field", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$9;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x9;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummyCid -> ledger.create(party, (Template)new DummyWithParam(party)).flatMap((Function1 & Serializable)dummyWithParamCid -> ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)contracts -> {
                        $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$80(party, dummyCid, dummyWithParamCid, contracts);
                        return BoxedUnit.UNIT;
                    }, $this.ec$9), $this.ec$9), this.ec$9);
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Allocation.Participants x9) {
                Allocation.Participant participant;
                Allocation.Participants participants = x9;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$82(Option x$33) {
                return x$33.nonEmpty();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$84(Option x$34) {
                return x$34.nonEmpty();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$80(Object party$6, Object dummyCid$1, Object dummyWithParamCid$1, Vector contracts) {
                Predef$.MODULE$.assert(contracts.size() == 2, (Function0 & Serializable)() -> new StringBuilder(37).append(party$6).append(" expected 2 contracts, but received ").append(contracts.size()).append(".").toString());
                Vector dummyAgreementText = (Vector)contracts.collect((PartialFunction)new Serializable(null, dummyCid$1){
                    private static final long serialVersionUID = 0L;
                    private final Object dummyCid$1;

                    public final <A1 extends CreatedEvent, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        String string = A1.contractId();
                        Object object = this.dummyCid$1;
                        if (!(string != null ? !string.equals(object) : object != null)) {
                            return (B1)A1.agreementText();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(CreatedEvent x1) {
                        CreatedEvent createdEvent = x1;
                        String string = createdEvent.contractId();
                        Object object = this.dummyCid$1;
                        return !(string != null ? !string.equals(object) : object != null);
                    }
                    {
                        this.dummyCid$1 = dummyCid$1;
                    }
                });
                Vector dummyWithParamAgreementText = (Vector)contracts.collect((PartialFunction)new Serializable(null, dummyWithParamCid$1){
                    private static final long serialVersionUID = 0L;
                    private final Object dummyWithParamCid$1;

                    public final <A1 extends CreatedEvent, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        String string = A1.contractId();
                        Object object = this.dummyWithParamCid$1;
                        if (!(string != null ? !string.equals(object) : object != null)) {
                            return (B1)A1.agreementText();
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(CreatedEvent x2) {
                        CreatedEvent createdEvent = x2;
                        String string = createdEvent.contractId();
                        Object object = this.dummyWithParamCid$1;
                        return !(string != null ? !string.equals(object) : object != null);
                    }
                    {
                        this.dummyWithParamCid$1 = dummyWithParamCid$1;
                    }
                });
                Predef$.MODULE$.assert(dummyAgreementText.exists((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$82(x$33))), (Function0 & Serializable)() -> new StringBuilder(52).append(party$6).append(" expected a non-empty agreement text, but received ").append(dummyAgreementText).append(".").toString());
                Predef$.MODULE$.assert(dummyWithParamAgreementText.exists((Function1 & Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$84(x$34))), (Function0 & Serializable)() -> new StringBuilder(49).append(party$6).append(" expected an empty agreement text, but received ").append(dummyWithParamAgreementText).append(".").toString());
            }
            {
                this.ec$9 = ec$9;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$78(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$79(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$80$adapted(java.lang.Object java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$81(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$82$adapted(scala.Option ), $anonfun$applyOrElse$83(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$84$adapted(scala.Option ), $anonfun$applyOrElse$85(java.lang.Object scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("ACSeventId", "The ActiveContractService should properly fill the eventId field", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$10;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x10;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)x$36 -> {
                        Object object = x$36;
                        return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).withFilter((Function1 & Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$87(check$ifrefutable$7)), $this.ec$10).flatMap((Function1 & Serializable)x$35 -> {
                            SeqOps seqOps;
                            Vector vector = x$35;
                            if (vector != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Vector().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                                CreatedEvent dummyEvent = (CreatedEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                                return ledger.flatTransactionByEventId(dummyEvent.eventId(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).flatMap((Function1 & Serializable)flatTransaction -> ledger.transactionTreeByEventId(dummyEvent.eventId(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)transactionTree -> {
                                    $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$90(flatTransaction, dummyEvent, transactionTree);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$10), $this.ec$10);
                            }
                            throw new MatchError((Object)vector);
                        }, $this.ec$10);
                    }, this.ec$10);
                }
                return (B1)function1.apply(x10);
            }

            public final boolean isDefinedAt(Allocation.Participants x10) {
                Allocation.Participant participant;
                Allocation.Participants participants = x10;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$87(Vector check$ifrefutable$7) {
                SeqOps seqOps;
                Vector vector = check$ifrefutable$7;
                return vector != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Vector().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$90(Transaction flatTransaction$1, CreatedEvent dummyEvent$1, TransactionTree transactionTree) {
                String string = flatTransaction$1.transactionId();
                String string2 = transactionTree.transactionId();
                Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> new StringBuilder(81).append("EventId ").append(dummyEvent$1.eventId()).append(" did not resolve to the same flat transaction (").append(flatTransaction$1.transactionId()).append(") and transaction tree (").append(transactionTree.transactionId()).append(").").toString());
            }
            {
                this.ec$10 = ec$10;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$86(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$87$adapted(scala.collection.immutable.Vector ), $anonfun$applyOrElse$88(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$89(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.event.CreatedEvent java.lang.Object com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$90$adapted(com.daml.ledger.api.v1.transaction.Transaction com.daml.ledger.api.v1.event.CreatedEvent com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$91(com.daml.ledger.api.v1.event.CreatedEvent com.daml.ledger.api.v1.transaction.Transaction com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("ACSnoWitnessedContracts", "The ActiveContractService should not return witnessed contracts", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$11;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x11;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    return (B1)ledger.create(alice, (Template)new Witnesses(alice, bob, bob)).flatMap((Function1 & Serializable)witnesses -> ledger.exercise(bob, Witnesses.Witnesses$u0020syntax$.MODULE$.exerciseWitnessesCreateNewWitnesses$extension(Witnesses$.MODULE$.Witnesses$u0020syntax(witnesses), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$37 -> {
                        TransactionTree transactionTree = x$37;
                        return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob})).flatMap((Function1 & Serializable)bobContracts -> ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice})).map((Function1 & Serializable)aliceContracts -> {
                            $anonfun$$nestedInanonfun$new$11$1.$anonfun$applyOrElse$95(bobContracts, bob, alice, aliceContracts);
                            return BoxedUnit.UNIT;
                        }, $this.ec$11), $this.ec$11);
                    }, $this.ec$11), this.ec$11);
                }
                return (B1)function1.apply(x11);
            }

            public final boolean isDefinedAt(Allocation.Participants x11) {
                Allocation.Participant participant;
                Allocation.Participants participants = x11;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$95(Vector bobContracts$1, Object bob$2, Object alice$2, Vector aliceContracts) {
                Predef$.MODULE$.assert(bobContracts$1.size() == 2, (Function0 & Serializable)() -> new StringBuilder(59).append("Expected to receive 2 active contracts for ").append(bob$2).append(", but received ").append(bobContracts$1.size()).append(".").toString());
                Predef$.MODULE$.assert(aliceContracts.size() == 1, (Function0 & Serializable)() -> new StringBuilder(59).append("Expected to receive 1 active contracts for ").append(alice$2).append(", but received ").append(aliceContracts.size()).append(".").toString());
            }
            {
                this.ec$11 = ec$11;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$92(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$93(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$94(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$95$adapted(scala.collection.immutable.Vector java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$96(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$97(java.lang.Object scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("ACSnoDivulgedContracts", "The ActiveContractService should not return divulged contracts", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$12;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x12;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    return (B1)ledger.create(alice, (Template)new Divulgence1(alice)).flatMap((Function1 & Serializable)divulgence1 -> ledger.create(bob, (Template)new Divulgence2(bob, alice)).flatMap((Function1 & Serializable)divulgence2 -> ledger.exercise(alice, Divulgence2.Divulgence2$u0020syntax$.MODULE$.exerciseDivulgence2Fetch$extension(Divulgence2$.MODULE$.Divulgence2$u0020syntax(divulgence2), divulgence1, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$38 -> {
                        TransactionTree transactionTree = x$38;
                        return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob})).flatMap((Function1 & Serializable)bobContracts -> ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice})).map((Function1 & Serializable)aliceContracts -> {
                            $anonfun$$nestedInanonfun$new$12$1.$anonfun$applyOrElse$102(bobContracts, bob, alice, aliceContracts);
                            return BoxedUnit.UNIT;
                        }, $this.ec$12), $this.ec$12);
                    }, $this.ec$12), $this.ec$12), this.ec$12);
                }
                return (B1)function1.apply(x12);
            }

            public final boolean isDefinedAt(Allocation.Participants x12) {
                Allocation.Participant participant;
                Allocation.Participants participants = x12;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$102(Vector bobContracts$2, Object bob$3, Object alice$3, Vector aliceContracts) {
                Predef$.MODULE$.assert(bobContracts$2.size() == 1, (Function0 & Serializable)() -> new StringBuilder(59).append("Expected to receive 1 active contracts for ").append(bob$3).append(", but received ").append(bobContracts$2.size()).append(".").toString());
                Predef$.MODULE$.assert(aliceContracts.size() == 2, (Function0 & Serializable)() -> new StringBuilder(59).append("Expected to receive 2 active contracts for ").append(alice$3).append(", but received ").append(aliceContracts.size()).append(".").toString());
            }
            {
                this.ec$12 = ec$12;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$100(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$101(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$102$adapted(scala.collection.immutable.Vector java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$103(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$104(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$98(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$99(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object )}, serializedLambda);
            }
        });
        this.test("ACSnoSignatoryObservers", "The ActiveContractService should not return overlapping signatories and observers", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$13;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x13;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    return (B1)ledger.create(alice, (Template)new WithObservers(alice, (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice, bob})))).flatMap((Function1 & Serializable)x$39 -> {
                        Object object = x$39;
                        return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice})).map((Function1 & Serializable)contracts -> {
                            $anonfun$$nestedInanonfun$new$13$1.$anonfun$applyOrElse$106(bob, contracts);
                            return BoxedUnit.UNIT;
                        }, $this.ec$13);
                    }, this.ec$13);
                }
                return (B1)function1.apply(x13);
            }

            public final boolean isDefinedAt(Allocation.Participants x13) {
                Allocation.Participant participant;
                Allocation.Participants participants = x13;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$107(Object bob$4, CreatedEvent ce) {
                Seq seq = ce.observers();
                SeqOps seqOps = Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob$4}));
                Predef$.MODULE$.assert(!(seq != null ? !seq.equals(seqOps) : seqOps != null), (Function0 & Serializable)() -> new StringBuilder(50).append("Expected observers to only contain ").append(bob$4).append(", but received ").append(ce.observers()).toString());
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$106(Object bob$4, Vector contracts) {
                Predef$.MODULE$.assert(contracts.nonEmpty());
                contracts.foreach((Function1 & Serializable)ce -> {
                    $anonfun$$nestedInanonfun$new$13$1.$anonfun$applyOrElse$107(bob$4, ce);
                    return BoxedUnit.UNIT;
                });
            }
            {
                this.ec$13 = ec$13;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$105(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$106$adapted(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$107$adapted(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$108(java.lang.Object com.daml.ledger.api.v1.event.CreatedEvent )}, serializedLambda);
            }
        });
        this.test("ACFilterWitnesses", "The ActiveContractService should filter witnesses by the transaction filter", Allocation$.MODULE$.allocate((Allocation.PartyCount)new Allocation.Parties(3), (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$14;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x14;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(3) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    Object charlie = participant.parties().apply(2);
                    return (B1)ledger.create(alice, (Template)new WithObservers(alice, (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob, charlie})))).flatMap((Function1 & Serializable)x$41 -> {
                        Object object = x$41;
                        return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob})).flatMap((Function1 & Serializable)bobContracts -> ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice, bob})).flatMap((Function1 & Serializable)aliceBobContracts -> ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob, charlie})).map((Function1 & Serializable)bobCharlieContracts -> {
                            $anonfun$$nestedInanonfun$new$14$1.$anonfun$applyOrElse$112(bobContracts, bob, aliceBobContracts, alice, charlie, bobCharlieContracts);
                            return BoxedUnit.UNIT;
                        }, $this.ec$14), $this.ec$14), $this.ec$14);
                    }, this.ec$14);
                }
                return (B1)function1.apply(x14);
            }

            public final boolean isDefinedAt(Allocation.Participants x14) {
                Allocation.Participant participant;
                Allocation.Participants participants = x14;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(3) == 0;
            }

            private static final void assertWitnesses$1(Vector contracts, Set requesters) {
                Predef$.MODULE$.assert(contracts.size() == 1, (Function0 & Serializable)() -> new StringBuilder(59).append("Expected to receive 1 active contracts for ").append(requesters).append(", but received ").append(contracts.size()).append(".").toString());
                Set set = ((CreatedEvent)contracts.head()).witnessParties().toSet();
                Object object = requesters.map((Function1 & Serializable)x$40 -> x$40.toString());
                Predef$.MODULE$.assert(!(set != null ? !set.equals(object) : object != null), (Function0 & Serializable)() -> new StringBuilder(52).append("Expected witness parties to equal to ").append(requesters).append(", but received ").append(((CreatedEvent)contracts.head()).witnessParties()).toString());
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$112(Vector bobContracts$3, Object bob$5, Vector aliceBobContracts$1, Object alice$5, Object charlie$1, Vector bobCharlieContracts) {
                $anonfun$$nestedInanonfun$new$14$1.assertWitnesses$1(bobContracts$3, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob$5})));
                $anonfun$$nestedInanonfun$new$14$1.assertWitnesses$1(aliceBobContracts$1, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice$5, bob$5})));
                $anonfun$$nestedInanonfun$new$14$1.assertWitnesses$1(bobCharlieContracts, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob$5, charlie$1})));
            }
            {
                this.ec$14 = ec$14;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$109(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$14$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$110(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$14$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$111(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$14$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$112$adapted(scala.collection.immutable.Vector java.lang.Object scala.collection.immutable.Vector java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$113(scala.collection.immutable.Set scala.collection.immutable.Vector ), $anonfun$applyOrElse$114(java.lang.Object ), $anonfun$applyOrElse$115(scala.collection.immutable.Set scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("ACSFilterCombinations", "Testing ACS filter combinations", Allocation$.MODULE$.allocate((Allocation.PartyCount)new Allocation.Parties(3), (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$15;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x15;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(3) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object p1 = participant.parties().apply(0);
                    Object p2 = participant.parties().apply(1);
                    Object p3 = participant.parties().apply(2);
                    LazyRef FilterCoord$module = new LazyRef();
                    Vector templateIds = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{(Identifier)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(TriAgreement$.MODULE$.id())), (Identifier)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(TriProposal$.MODULE$.id())), (Identifier)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(WithObservers$.MODULE$.id()))}));
                    Vector parties = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p1, p2, p3}));
                    Vector partyCombinations = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Set[]{(Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))}));
                    Set $times = Predef$.MODULE$.Set().empty();
                    Vector fixtures = (Vector)((StrictOptimizedIterableOps)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)$times)})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)$times), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)$times)})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)$times), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)$times)})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)$times), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)$times), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)$times)})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)$times), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))})), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)$times), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}))}))).map((Function1 & Serializable)filter -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(filter), (Object)this.filterCoordsForFilter$1((Map)filter, templateIds, partyCombinations, FilterCoord$module)));
                    Random random = new Random(System.nanoTime());
                    return (B1)this.createContracts$1(ledger, partyCombinations, parties, FilterCoord$module).flatMap((Function1 & Serializable)allContracts -> this.testForFixtures$1(fixtures, (Map)allContracts, ledger, parties, random, templateIds).map((Function1 & Serializable)x$60 -> {
                        $anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$152(x$60);
                        return BoxedUnit.UNIT;
                    }, $this.ec$15), this.ec$15);
                }
                return (B1)function1.apply(x15);
            }

            public final boolean isDefinedAt(Allocation.Participants x15) {
                Allocation.Participant participant;
                Allocation.Participants participants = x15;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(3) == 0;
            }

            private final /* synthetic */ ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$ FilterCoord$lzycompute$1(LazyRef FilterCoord$module$1) {
                ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$ activeContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$;
                LazyRef lazyRef = FilterCoord$module$1;
                synchronized (lazyRef) {
                    activeContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$ = FilterCoord$module$1.initialized() ? (ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$)FilterCoord$module$1.value() : (ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$)FilterCoord$module$1.initialize((Object)new ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$(this));
                }
                return activeContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$;
            }

            private final ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$ FilterCoord$3(LazyRef FilterCoord$module$1) {
                if (FilterCoord$module$1.initialized()) {
                    return (ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$2$)FilterCoord$module$1.value();
                }
                return this.FilterCoord$lzycompute$1(FilterCoord$module$1);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$116(Tuple2 check$ifrefutable$8) {
                Tuple2 tuple2 = check$ifrefutable$8;
                return tuple2 != null;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$119(int party$8, Set x$42) {
                return x$42.apply((Object)BoxesRunTime.boxToInteger((int)party$8));
            }

            public static final /* synthetic */ Vector $anonfun$applyOrElse$118($anonfun$$nestedInanonfun$new$15$1 $this, Vector partyCombinations$1, int party$8, LazyRef FilterCoord$module$1, int templateId) {
                return (Vector)((StrictOptimizedIterableOps)partyCombinations$1.filter((Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$119(party$8, x$42)))).map((Function1 & Serializable)allowedPartyCombination -> {
                    public class Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1
                    implements Product,
                    Serializable {
                        private final int templateId;
                        private final Set<Object> stakeholders;
                        private final /* synthetic */ $anonfun$$nestedInanonfun$new$15$1 $outer;

                        public Iterator<String> productElementNames() {
                            return Product.productElementNames$((Product)this);
                        }

                        public int templateId() {
                            return this.templateId;
                        }

                        public Set<Object> stakeholders() {
                            return this.stakeholders;
                        }

                        public Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 copy(int templateId, Set<Object> stakeholders) {
                            return new Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1(this.$outer, templateId, stakeholders);
                        }

                        public int copy$default$1() {
                            return this.templateId();
                        }

                        public Set<Object> copy$default$2() {
                            return this.stakeholders();
                        }

                        public String productPrefix() {
                            return "FilterCoord";
                        }

                        public int productArity() {
                            return 2;
                        }

                        public Object productElement(int x$1) {
                            int n = x$1;
                            switch (n) {
                                case 0: {
                                    return BoxesRunTime.boxToInteger((int)this.templateId());
                                }
                                case 1: {
                                    return this.stakeholders();
                                }
                            }
                            return Statics.ioobe((int)x$1);
                        }

                        public Iterator<Object> productIterator() {
                            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                        }

                        public boolean canEqual(Object x$1) {
                            return x$1 instanceof Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1;
                        }

                        public String productElementName(int x$1) {
                            int n = x$1;
                            switch (n) {
                                case 0: {
                                    return "templateId";
                                }
                                case 1: {
                                    return "stakeholders";
                                }
                            }
                            return (String)Statics.ioobe((int)x$1);
                        }

                        public int hashCode() {
                            int n = -889275714;
                            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                            n = Statics.mix((int)n, (int)this.templateId());
                            n = Statics.mix((int)n, (int)Statics.anyHash(this.stakeholders()));
                            return Statics.finalizeHash((int)n, (int)2);
                        }

                        public String toString() {
                            return ScalaRunTime$.MODULE$._toString((Product)this);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public boolean equals(Object x$1) {
                            if (this == x$1) return true;
                            Object object = x$1;
                            if (!(object instanceof Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1)) return false;
                            boolean bl = true;
                            if (!bl) return false;
                            Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 var4_3 = (Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1)x$1;
                            if (this.templateId() != var4_3.templateId()) return false;
                            Set<Object> set = this.stakeholders();
                            Set<Object> set2 = var4_3.stakeholders();
                            if (set == null) {
                                if (set2 != null) {
                                    return false;
                                }
                            } else if (!set.equals(set2)) return false;
                            if (!var4_3.canEqual(this)) return false;
                            return true;
                        }

                        public Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1($anonfun$$nestedInanonfun$new$15$1 $outer, int templateId, Set<Object> stakeholders) {
                            this.templateId = templateId;
                            this.stakeholders = stakeholders;
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            Product.$init$((Product)this);
                        }
                    }
                    return $this.FilterCoord$3(FilterCoord$module$1).apply(templateId, (Set<Object>)allowedPartyCombination);
                });
            }

            private final Set filterCoordsForFilter$1(Map filter, Vector templateIds$1, Vector partyCombinations$1, LazyRef FilterCoord$module$1) {
                return ((IterableOnceOps)filter.withFilter((Function1 & Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$116(check$ifrefutable$8))).flatMap((Function1 & Serializable)x$43 -> {
                    Tuple2 tuple2 = x$43;
                    if (tuple2 != null) {
                        int party = tuple2._1$mcI$sp();
                        Set templates = (Set)tuple2._2();
                        return (Set)(templates.isEmpty() ? templateIds$1.indices().toSet() : templates).flatMap((Function1 & Serializable)templateId -> $anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$118(this, partyCombinations$1, party, FilterCoord$module$1, BoxesRunTime.unboxToInt((Object)templateId)));
                    }
                    throw new MatchError((Object)tuple2);
                })).toSet();
            }

            private static final Object withThreeParties$1(Function3 f, Set partySet) {
                boolean bl = false;
                .colon.colon colon2 = null;
                List list = partySet.toList();
                if (list instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)list;
                    Object a = colon2.head();
                    List list2 = colon2.next$access$1();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        Object b = colon3.head();
                        List list3 = colon3.next$access$1();
                        if (list3 instanceof .colon.colon) {
                            .colon.colon colon4 = (.colon.colon)list3;
                            Object c = colon4.head();
                            List list4 = colon4.next$access$1();
                            if (Nil$.MODULE$.equals(list4)) {
                                return f.apply(a, b, c);
                            }
                        }
                    }
                }
                if (bl) {
                    Object a = colon2.head();
                    List list5 = colon2.next$access$1();
                    if (list5 instanceof .colon.colon) {
                        .colon.colon colon5 = (.colon.colon)list5;
                        Object b = colon5.head();
                        List list6 = colon5.next$access$1();
                        if (Nil$.MODULE$.equals(list6)) {
                            return f.apply(a, b, b);
                        }
                    }
                }
                if (bl) {
                    Object a = colon2.head();
                    List list7 = colon2.next$access$1();
                    if (Nil$.MODULE$.equals(list7)) {
                        return f.apply(a, a, a);
                    }
                }
                throw new Exception(new StringBuilder(56).append("Invalid partySet, length must be 1 or 2 or 3 but it was ").append(list).toString());
            }

            private static final Future createContractFor$1(int template, int partyCombination, ParticipantTestContext ledger$13, Vector partyCombinations$1, Vector parties$1, Vector templateFactories$1) {
                return ledger$13.create(((IterableOnceOps)((IterableOps)partyCombinations$1.apply(partyCombination)).map((Function1)parties$1)).toList(), ((IterableOnceOps)((IterableOps)partyCombinations$1.apply(partyCombination)).map((Function1)parties$1)).toList(), (Template)((Function1)templateFactories$1.apply(template)).apply(((IterableOps)partyCombinations$1.apply(partyCombination)).map((Function1)parties$1)));
            }

            public static final /* synthetic */ Future $anonfun$applyOrElse$129($anonfun$$nestedInanonfun$new$15$1 $this, int templateIndex$1, int partyCombinationIndex$1, ParticipantTestContext ledger$13, Vector partyCombinations$1, Vector parties$1, Vector templateFactories$1, int x$51) {
                int n = x$51;
                return $anonfun$$nestedInanonfun$new$15$1.createContractFor$1(templateIndex$1, partyCombinationIndex$1, ledger$13, partyCombinations$1, parties$1, templateFactories$1).map((Function1 & Serializable)x$50 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(partyCombinationIndex$1, templateIndex$1)), x$50), $this.ec$15);
            }

            public static final /* synthetic */ IndexedSeq $anonfun$applyOrElse$128($anonfun$$nestedInanonfun$new$15$1 $this, int partyCombinationIndex$1, ParticipantTestContext ledger$13, Vector partyCombinations$1, Vector parties$1, Vector templateFactories$1, int templateIndex) {
                return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)x$51 -> $anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$129($this, templateIndex, partyCombinationIndex$1, ledger$13, partyCombinations$1, parties$1, templateFactories$1, BoxesRunTime.unboxToInt((Object)x$51)));
            }

            public static final /* synthetic */ IndexedSeq $anonfun$applyOrElse$127($anonfun$$nestedInanonfun$new$15$1 $this, Vector templateFactories$1, ParticipantTestContext ledger$13, Vector partyCombinations$1, Vector parties$1, int partyCombinationIndex) {
                return (IndexedSeq)templateFactories$1.indices().flatMap((Function1 & Serializable)templateIndex -> $anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$128($this, partyCombinationIndex, ledger$13, partyCombinations$1, parties$1, templateFactories$1, BoxesRunTime.unboxToInt((Object)templateIndex)));
            }

            private final Future createContracts$1(ParticipantTestContext ledger$13, Vector partyCombinations$1, Vector parties$1, LazyRef FilterCoord$module$1) {
                Function1[] function1Array = new Function1[3];
                Function3 & Serializable intersect = (Function3 & Serializable)(x$44, x$45, x$46) -> new TriAgreement(x$44, x$45, x$46);
                function1Array[0] = (Function1 & Serializable)partySet -> (TriAgreement)$anonfun$$nestedInanonfun$new$15$1.withThreeParties$1(intersect, partySet);
                Function3 & Serializable intersect2 = (Function3 & Serializable)(x$47, x$48, x$49) -> new TriProposal(x$47, x$48, x$49);
                function1Array[1] = (Function1 & Serializable)partySet -> (TriProposal)$anonfun$$nestedInanonfun$new$15$1.withThreeParties$1(intersect2, partySet);
                function1Array[2] = (Function1 & Serializable)parties -> new WithObservers(parties.head(), (Seq)parties.toList());
                Vector templateFactories = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])function1Array));
                IndexedSeq createFs = (IndexedSeq)partyCombinations$1.indices().flatMap((Function1 & Serializable)partyCombinationIndex -> $anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$127(this, templateFactories, ledger$13, partyCombinations$1, parties$1, BoxesRunTime.unboxToInt((Object)partyCombinationIndex)));
                return Future$.MODULE$.sequence((IterableOnce)createFs, BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$15).map((Function1 & Serializable)x$52 -> (Map)x$52.groupBy((Function1 & Serializable)x$53 -> (Tuple2)x$53._1()).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        IndexedSeq contractId = (IndexedSeq)tuple2._2();
                        if (tuple22 != null) {
                            int partyCombinationIndex = tuple22._1$mcI$sp();
                            int templateIndex = tuple22._2$mcI$sp();
                            return new Tuple2((Object)this.FilterCoord$3(FilterCoord$module$1).apply(templateIndex, (Set<Object>)((Set)partyCombinations$1.apply(partyCombinationIndex))), (Object)contractId.view().map((Function1 & Serializable)x$54 -> x$54._2().toString()).toSet());
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }), this.ec$15);
            }

            private final Future activeContractIdsFor$1(Map filter, ParticipantTestContext ledger$13, Vector parties$1, Random random$1, Vector templateIds$1) {
                return ledger$13.activeContracts(new GetActiveContractsRequest(ledger$13.ledgerId(), (Option)new Some((Object)new TransactionFilter((Map)filter.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        int party = tuple2._1$mcI$sp();
                        Set templates = (Set)tuple2._2();
                        if (templates.isEmpty()) {
                            return new Tuple2((Object)parties$1.apply(party).toString(), (Object)new Filters((Option)None$.MODULE$));
                        }
                    }
                    if (tuple2 != null) {
                        int party = tuple2._1$mcI$sp();
                        Set templates = (Set)tuple2._2();
                        return new Tuple2((Object)parties$1.apply(party).toString(), (Object)new Filters((Option)new Some((Object)new InclusiveFilters((Seq)random$1.shuffle((IterableOnce)templates.toSeq().map((Function1)templateIds$1), BuildFrom$.MODULE$.buildFromIterableOps()), InclusiveFilters$.MODULE$.$lessinit$greater$default$2()))));
                    }
                    throw new MatchError((Object)tuple2);
                }))), true, GetActiveContractsRequest$.MODULE$.$lessinit$greater$default$4())).map((Function1 & Serializable)x$55 -> (Vector)((StrictOptimizedIterableOps)x$55._2()).map((Function1 & Serializable)x$56 -> x$56.contractId()), this.ec$15);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$138(Map allContracts$1, $anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 key) {
                return allContracts$1.contains((Object)key);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$140(Map allContracts$1, $anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 key) {
                return allContracts$1.contains((Object)key);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$143(Tuple2 x$57) {
                return ((SeqOps)x$57._2()).size() > 1;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$146(Set actualSet$1, String x) {
                return !actualSet$1.apply((Object)x);
            }

            private static final void testForFixture$1(Vector actual, Set expected, String hint, Map allContracts$1) {
                Set expectedContracts;
                List errors;
                Set actualSet = actual.toSet();
                Predef$.MODULE$.assert(expected.forall((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$138(allContracts$1, key))), (Function0 & Serializable)() -> new StringBuilder(48).append(hint).append(" expected FilterCoord(s) which do not exist(s): ").append(expected.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$140(allContracts$1, key)))).toString());
                Predef$.MODULE$.assert(actualSet.size() == actual.size(), (Function0 & Serializable)() -> new StringBuilder(32).append(hint).append(" ACS returned redundant entries ").append(actual.groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).toList().filter((Function1 & Serializable)x$57 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$143(x$57))).map((Function1 & Serializable)x$58 -> (String)x$58._1()).mkString("\n")).toString());
                List list = errors = allContracts$1.toList().flatMap((Function1 & Serializable)x0$1 -> {
                    Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 filterCoord;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 filterCoord2 = (Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1)tuple2._1();
                        Set contracts = (Set)tuple2._2();
                        if (expected.apply((Object)filterCoord2) && contracts.forall((Function1)actualSet)) {
                            return Nil$.MODULE$;
                        }
                    }
                    if (tuple2 != null) {
                        Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 filterCoord3 = (Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1)tuple2._1();
                        Set contracts = (Set)tuple2._2();
                        if (expected.apply((Object)filterCoord3) && contracts.forall((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$146(actualSet, x)))) {
                            return new .colon.colon((Object)new StringBuilder(23).append(filterCoord3).append(" is missing from result").toString(), (List)Nil$.MODULE$);
                        }
                    }
                    if (tuple2 != null && expected.apply((Object)(filterCoord = (Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1)tuple2._1()))) {
                        return new .colon.colon((Object)new StringBuilder(33).append(filterCoord).append(" is partially missing from result").toString(), (List)Nil$.MODULE$);
                    }
                    if (tuple2 != null) {
                        Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 filterCoord4 = (Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1)tuple2._1();
                        Set contracts = (Set)tuple2._2();
                        if (contracts.forall((Function1)actualSet)) {
                            return new .colon.colon((Object)new StringBuilder(42).append(filterCoord4).append(" is present (too many contracts in result)").toString(), (List)Nil$.MODULE$);
                        }
                    }
                    if (tuple2 != null) {
                        Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 filterCoord5 = (Com_daml_ledger_api_testtool_suites_v1_8_ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1)tuple2._1();
                        Set contracts = (Set)tuple2._2();
                        if (contracts.exists((Function1)actualSet)) {
                            return new .colon.colon((Object)new StringBuilder(52).append(filterCoord5).append(" is partially present (too many contracts in result)").toString(), (List)Nil$.MODULE$);
                        }
                    }
                    if (tuple2 != null) {
                        return Nil$.MODULE$;
                    }
                    throw new MatchError((Object)tuple2);
                });
                Nil$ nil$ = Nil$.MODULE$;
                Predef$.MODULE$.assert(!(list != null ? !list.equals(nil$) : nil$ != null), (Function0 & Serializable)() -> new StringBuilder(15).append(hint).append(" ACS mismatch: ").append(errors.mkString(", ")).toString());
                Set set = expectedContracts = ((IterableOnceOps)expected.view().flatMap((Function1)allContracts$1)).toSet();
                Set set2 = actualSet;
                Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null), (Function0 & Serializable)() -> new StringBuilder(53).append(hint).append(" ACS mismatch\n Extra contracts: ").append(actualSet.$minus$minus((IterableOnce)expectedContracts)).append("\n Missing contracts: ").append(expectedContracts.$minus$minus((IterableOnce)actualSet)).toString());
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$150(Set expectedResultCoords$1, Map filter$1, Map allContracts$1, Vector x$59) {
                $anonfun$$nestedInanonfun$new$15$1.testForFixture$1(x$59, expectedResultCoords$1, new StringBuilder(8).append("Filter: ").append(filter$1).toString(), allContracts$1);
            }

            private final Future testForFixtures$1(Vector fixtures, Map allContracts, ParticipantTestContext ledger$13, Vector parties$1, Random random$1, Vector templateIds$1) {
                Vector testFs = (Vector)fixtures.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Map filter = (Map)tuple2._1();
                        Set expectedResultCoords = (Set)tuple2._2();
                        return this.activeContractIdsFor$1(filter, ledger$13, parties$1, random$1, templateIds$1).map((Function1 & Serializable)x$59 -> {
                            $anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$150(expectedResultCoords, filter, allContracts, x$59);
                            return BoxedUnit.UNIT;
                        }, $this.ec$15);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Future$.MODULE$.sequence((IterableOnce)testFs, BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$15);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$152(Vector x$60) {
                Vector vector = x$60;
            }
            {
                this.ec$15 = ec$15;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$116$adapted(scala.Tuple2 ), $anonfun$applyOrElse$117(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 scala.collection.immutable.Vector scala.collection.immutable.Vector scala.runtime.LazyRef scala.Tuple2 ), $anonfun$applyOrElse$118$adapted(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 scala.collection.immutable.Vector int scala.runtime.LazyRef java.lang.Object ), $anonfun$applyOrElse$119$adapted(int scala.collection.immutable.Set ), $anonfun$applyOrElse$120(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 int scala.runtime.LazyRef scala.collection.immutable.Set ), $anonfun$applyOrElse$121(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 scala.collection.immutable.Vector scala.collection.immutable.Vector scala.runtime.LazyRef scala.collection.immutable.Map ), $anonfun$applyOrElse$122(java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$123(scala.Function3 scala.collection.immutable.Set ), $anonfun$applyOrElse$124(java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$125(scala.Function3 scala.collection.immutable.Set ), $anonfun$applyOrElse$126(scala.collection.immutable.Set ), $anonfun$applyOrElse$127$adapted(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 scala.collection.immutable.Vector com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.collection.immutable.Vector scala.collection.immutable.Vector java.lang.Object ), $anonfun$applyOrElse$128$adapted(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 int com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.collection.immutable.Vector scala.collection.immutable.Vector scala.collection.immutable.Vector java.lang.Object ), $anonfun$applyOrElse$129$adapted(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 int int com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.collection.immutable.Vector scala.collection.immutable.Vector scala.collection.immutable.Vector java.lang.Object ), $anonfun$applyOrElse$130(int int java.lang.Object ), $anonfun$applyOrElse$131(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 scala.collection.immutable.Vector scala.runtime.LazyRef scala.collection.immutable.IndexedSeq ), $anonfun$applyOrElse$132(scala.Tuple2 ), $anonfun$applyOrElse$133(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 scala.collection.immutable.Vector scala.runtime.LazyRef scala.Tuple2 ), $anonfun$applyOrElse$134(scala.Tuple2 ), $anonfun$applyOrElse$135(scala.collection.immutable.Vector scala.util.Random scala.collection.immutable.Vector scala.Tuple2 ), $anonfun$applyOrElse$136(scala.Tuple2 ), $anonfun$applyOrElse$137(com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$138$adapted(scala.collection.immutable.Map com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 ), $anonfun$applyOrElse$139(java.lang.String scala.collection.immutable.Set scala.collection.immutable.Map ), $anonfun$applyOrElse$140$adapted(scala.collection.immutable.Map com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1$FilterCoord$1 ), $anonfun$applyOrElse$141(java.lang.String scala.collection.immutable.Vector ), $anonfun$applyOrElse$142(java.lang.String ), $anonfun$applyOrElse$143$adapted(scala.Tuple2 ), $anonfun$applyOrElse$144(scala.Tuple2 ), $anonfun$applyOrElse$145(scala.collection.immutable.Set scala.collection.immutable.Set scala.Tuple2 ), $anonfun$applyOrElse$146$adapted(scala.collection.immutable.Set java.lang.String ), $anonfun$applyOrElse$147(java.lang.String scala.collection.immutable.List ), $anonfun$applyOrElse$148(java.lang.String scala.collection.immutable.Set scala.collection.immutable.Set ), $anonfun$applyOrElse$149(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.collection.immutable.Vector scala.util.Random scala.collection.immutable.Vector scala.collection.immutable.Map scala.Tuple2 ), $anonfun$applyOrElse$150$adapted(scala.collection.immutable.Set scala.collection.immutable.Map scala.collection.immutable.Map scala.collection.immutable.Vector ), $anonfun$applyOrElse$151(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$15$1 scala.collection.immutable.Vector com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.collection.immutable.Vector scala.util.Random scala.collection.immutable.Vector scala.collection.immutable.Map ), $anonfun$applyOrElse$152$adapted(scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        String x$1 = "ActiveAtOffsetInfluencesAcs";
        String x$2 = "Allow to specify optional active_at_offset";
        Function1 & Serializable x$3 = (Function1 & Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)x$61.acsActiveAtOffsetFeature());
        String x$4 = "Requires ACS with active_at_offset";
        Allocation.PartyAllocation x$5 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$6 = false;
        double x$7 = this.test$default$4();
        int x$8 = this.test$default$6();
        List x$9 = this.test$default$9();
        Function1 & Serializable x$10 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$16;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x16, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x16;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Some transactionFilter = new Some((Object)new TransactionFilter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(party))), (Object)new Filters(Filters$.MODULE$.apply$default$1()))}))));
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)c1 -> ledger.currentEnd().flatMap((Function1 & Serializable)offset1 -> ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)c2 -> ledger.currentEnd().flatMap((Function1 & Serializable)offset2 -> {
                        Some x$1 = transactionFilter;
                        String x$2 = offset1.getAbsolute();
                        String x$3 = GetActiveContractsRequest$.MODULE$.apply$default$1();
                        boolean x$4 = GetActiveContractsRequest$.MODULE$.apply$default$3();
                        return ledger.activeContractsIds(new GetActiveContractsRequest(x$3, (Option)x$1, x$4, x$2)).withFilter((Function1 & Serializable)check$ifrefutable$9 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$17$1.$anonfun$applyOrElse$157(check$ifrefutable$9)), $this.ec$16).map((Function1 & Serializable)x$65 -> {
                            Tuple2 tuple2 = x$65;
                            if (tuple2 != null) {
                                Option acsOffset1 = (Option)tuple2._1();
                                Vector acs1 = (Vector)tuple2._2();
                                Assertions$.MODULE$.assertEquals("acs1", (Object)acs1.toSet(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{c1})));
                                BoxedUnit x$63 = BoxedUnit.UNIT;
                                Assertions$.MODULE$.assertEquals("acs1 offset", (Object)acsOffset1, (Object)new Some(offset1));
                                BoxedUnit x$64 = BoxedUnit.UNIT;
                                return new Tuple3((Object)tuple2, (Object)x$63, (Object)x$64);
                            }
                            throw new MatchError((Object)tuple2);
                        }, $this.ec$16).flatMap((Function1 & Serializable)x$75 -> {
                            Tuple2 tuple2;
                            Tuple3 tuple3 = x$75;
                            if (tuple3 != null && (tuple2 = (Tuple2)tuple3._1()) != null) {
                                Some x$5 = transactionFilter;
                                String x$6 = offset2.getAbsolute();
                                String x$7 = GetActiveContractsRequest$.MODULE$.apply$default$1();
                                boolean x$8 = GetActiveContractsRequest$.MODULE$.apply$default$3();
                                return ledger.activeContractsIds(new GetActiveContractsRequest(x$7, (Option)x$5, x$8, x$6)).withFilter((Function1 & Serializable)check$ifrefutable$10 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$17$1.$anonfun$applyOrElse$160(check$ifrefutable$10)), $this.ec$16).map((Function1 & Serializable)x$69 -> {
                                    Tuple2 tuple2 = x$69;
                                    if (tuple2 != null) {
                                        Option acsOffset2 = (Option)tuple2._1();
                                        Vector acs2 = (Vector)tuple2._2();
                                        Assertions$.MODULE$.assertEquals("ACS at the second offset", (Object)acs2.toSet(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{c1, c2})));
                                        BoxedUnit x$67 = BoxedUnit.UNIT;
                                        Assertions$.MODULE$.assertEquals("acs1 offset", (Object)acsOffset2, (Object)new Some(offset2));
                                        BoxedUnit x$68 = BoxedUnit.UNIT;
                                        return new Tuple3((Object)tuple2, (Object)x$67, (Object)x$68);
                                    }
                                    throw new MatchError((Object)tuple2);
                                }, $this.ec$16).flatMap((Function1 & Serializable)x$74 -> {
                                    Tuple2 tuple2;
                                    Tuple3 tuple3 = x$74;
                                    if (tuple3 != null && (tuple2 = (Tuple2)tuple3._1()) != null) {
                                        Some x$9 = transactionFilter;
                                        String x$10 = "";
                                        String x$11 = GetActiveContractsRequest$.MODULE$.apply$default$1();
                                        boolean x$12 = GetActiveContractsRequest$.MODULE$.apply$default$3();
                                        return ledger.activeContractsIds(new GetActiveContractsRequest(x$11, (Option)x$9, x$12, "")).withFilter((Function1 & Serializable)check$ifrefutable$11 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$17$1.$anonfun$applyOrElse$163(check$ifrefutable$11)), $this.ec$16).flatMap((Function1 & Serializable)x$73 -> {
                                            Tuple2 tuple2 = x$73;
                                            if (tuple2 != null) {
                                                Option acsOffset3 = (Option)tuple2._1();
                                                Vector acs3 = (Vector)tuple2._2();
                                                return ledger.currentEnd().map((Function1 & Serializable)endOffset -> {
                                                    Assertions$.MODULE$.assertEquals("ACS at the default offset", (Object)acs3.toSet(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{c1, c2})));
                                                    BoxedUnit x$70 = BoxedUnit.UNIT;
                                                    Assertions$.MODULE$.assertEquals("acs1 offset", (Object)acsOffset3, (Object)new Some(endOffset));
                                                    BoxedUnit x$71 = BoxedUnit.UNIT;
                                                    return new Tuple3(endOffset, (Object)x$70, (Object)x$71);
                                                }, $this.ec$16).map((Function1 & Serializable)x$72 -> {
                                                    $anonfun$$nestedInanonfun$new$17$1.$anonfun$applyOrElse$166(x$72);
                                                    return BoxedUnit.UNIT;
                                                }, $this.ec$16);
                                            }
                                            throw new MatchError((Object)tuple2);
                                        }, $this.ec$16);
                                    }
                                    throw new MatchError((Object)tuple3);
                                }, $this.ec$16);
                            }
                            throw new MatchError((Object)tuple3);
                        }, $this.ec$16);
                    }, $this.ec$16), $this.ec$16), $this.ec$16), this.ec$16);
                }
                return (B1)function1.apply(x16);
            }

            public final boolean isDefinedAt(Allocation.Participants x16) {
                Allocation.Participant participant;
                Allocation.Participants participants = x16;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$157(Tuple2 check$ifrefutable$9) {
                Tuple2 tuple2 = check$ifrefutable$9;
                return tuple2 != null;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$160(Tuple2 check$ifrefutable$10) {
                Tuple2 tuple2 = check$ifrefutable$10;
                return tuple2 != null;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$163(Tuple2 check$ifrefutable$11) {
                Tuple2 tuple2 = check$ifrefutable$11;
                return tuple2 != null;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$166(Tuple3 x$72) {
                Tuple3 tuple3 = x$72;
                if (tuple3 != null) {
                    return;
                }
                throw new MatchError((Object)tuple3);
            }
            {
                this.ec$16 = ec$16;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$153(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Some java.lang.Object ), $anonfun$applyOrElse$154(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Some java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$155(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object java.lang.Object ), $anonfun$applyOrElse$156(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$157$adapted(scala.Tuple2 ), $anonfun$applyOrElse$158(java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset scala.Tuple2 ), $anonfun$applyOrElse$159(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$160$adapted(scala.Tuple2 ), $anonfun$applyOrElse$161(java.lang.Object java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset scala.Tuple2 ), $anonfun$applyOrElse$162(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Some java.lang.Object java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$163$adapted(scala.Tuple2 ), $anonfun$applyOrElse$164(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$165(scala.collection.immutable.Vector java.lang.Object java.lang.Object scala.Option com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$166$adapted(scala.Tuple3 )}, serializedLambda);
            }
        };
        this.test("ActiveAtOffsetInfluencesAcs", "Allow to specify optional active_at_offset", x$5, x$7, false, x$8, x$3, "Requires ACS with active_at_offset", x$9, x$10);
        String x$11 = "AcsAtPruningOffsetIsAllowed";
        String x$12 = "Allow requesting ACS at the pruning offset";
        Function1 & Serializable x$13 = (Function1 & Serializable)x$76 -> BoxesRunTime.boxToBoolean((boolean)x$76.acsActiveAtOffsetFeature());
        String x$14 = "Requires ACS with active_at_offset";
        Allocation.PartyAllocation x$15 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$16 = false;
        double x$17 = this.test$default$4();
        int x$18 = this.test$default$6();
        List x$19 = this.test$default$9();
        Function1 & Serializable x$20 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$17;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x17, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x17;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Some transactionFilter = new Some((Object)new TransactionFilter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(party))), (Object)new Filters(Filters$.MODULE$.apply$default$1()))}))));
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)c1 -> ledger.currentEnd().flatMap((Function1 & Serializable)anOffset -> ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)x$84 -> {
                        Object object = x$84;
                        return ledger.pruneCantonSafe(anOffset, party, (Function1 & Serializable)x$77 -> new Dummy(x$77).create(DummyImplicit$.MODULE$.dummyImplicit()).command(), ledger.pruneCantonSafe$default$4(), $this.ec$17).flatMap((Function1 & Serializable)x$83 -> {
                            BoxedUnit boxedUnit = x$83;
                            Some x$1 = transactionFilter;
                            String x$2 = anOffset.getAbsolute();
                            String x$3 = GetActiveContractsRequest$.MODULE$.apply$default$1();
                            boolean x$4 = GetActiveContractsRequest$.MODULE$.apply$default$3();
                            return ledger.activeContractsIds(new GetActiveContractsRequest(x$3, (Option)x$1, x$4, x$2)).withFilter((Function1 & Serializable)check$ifrefutable$12 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$19$1.$anonfun$applyOrElse$172(check$ifrefutable$12)), $this.ec$17).map((Function1 & Serializable)x$81 -> {
                                Tuple2 tuple2 = x$81;
                                if (tuple2 != null) {
                                    Option acsOffset = (Option)tuple2._1();
                                    Vector acs = (Vector)tuple2._2();
                                    Assertions$.MODULE$.assertEquals("acs valid_at at pruning offset", (Object)acs.toSet(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{c1})));
                                    BoxedUnit x$79 = BoxedUnit.UNIT;
                                    Assertions$.MODULE$.assertEquals("acs valid_at offset", (Object)acsOffset, (Object)new Some(anOffset));
                                    BoxedUnit x$80 = BoxedUnit.UNIT;
                                    return new Tuple3((Object)tuple2, (Object)x$79, (Object)x$80);
                                }
                                throw new MatchError((Object)tuple2);
                            }, $this.ec$17).map((Function1 & Serializable)x$82 -> {
                                $anonfun$$nestedInanonfun$new$19$1.$anonfun$applyOrElse$174(x$82);
                                return BoxedUnit.UNIT;
                            }, $this.ec$17);
                        }, $this.ec$17);
                    }, $this.ec$17), $this.ec$17), this.ec$17);
                }
                return (B1)function1.apply(x17);
            }

            public final boolean isDefinedAt(Allocation.Participants x17) {
                Allocation.Participant participant;
                Allocation.Participants participants = x17;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$172(Tuple2 check$ifrefutable$12) {
                Tuple2 tuple2 = check$ifrefutable$12;
                return tuple2 != null;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$174(Tuple3 x$82) {
                Tuple2 tuple2;
                Tuple3 tuple3 = x$82;
                if (tuple3 != null && (tuple2 = (Tuple2)tuple3._1()) != null) {
                    return;
                }
                throw new MatchError((Object)tuple3);
            }
            {
                this.ec$17 = ec$17;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$167(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$19$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Some java.lang.Object ), $anonfun$applyOrElse$168(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$19$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Some java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$169(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$19$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object scala.Some java.lang.Object java.lang.Object ), $anonfun$applyOrElse$170(java.lang.Object ), $anonfun$applyOrElse$171(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$19$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$172$adapted(scala.Tuple2 ), $anonfun$applyOrElse$173(java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset scala.Tuple2 ), $anonfun$applyOrElse$174$adapted(scala.Tuple3 )}, serializedLambda);
            }
        };
        this.test("AcsAtPruningOffsetIsAllowed", "Allow requesting ACS at the pruning offset", x$15, x$17, false, x$18, x$13, "Requires ACS with active_at_offset", x$19, x$20);
        String x$21 = "AcsBeforePruningOffsetIsDisallowed";
        String x$22 = "Fail when requesting ACS before the pruning offset";
        Function1 & Serializable x$23 = (Function1 & Serializable)x$85 -> BoxesRunTime.boxToBoolean((boolean)x$85.acsActiveAtOffsetFeature());
        String x$24 = "Requires ACS with active_at_offset";
        Allocation.PartyAllocation x$25 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$26 = false;
        double x$27 = this.test$default$4();
        int x$28 = this.test$default$6();
        List x$29 = this.test$default$9();
        Function1 & Serializable x$30 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$18;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x18, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x18;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Some transactionFilter = new Some((Object)new TransactionFilter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(party))), (Object)new Filters(Filters$.MODULE$.apply$default$1()))}))));
                    return (B1)ledger.currentEnd().flatMap((Function1 & Serializable)offset1 -> ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)x$90 -> {
                        Object object = x$90;
                        return ledger.currentEnd().flatMap((Function1 & Serializable)offset2 -> ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)x$89 -> {
                            Object object = x$89;
                            return ledger.pruneCantonSafe(offset2, party, (Function1 & Serializable)x$86 -> new Dummy(x$86).create(DummyImplicit$.MODULE$.dummyImplicit()).command(), ledger.pruneCantonSafe$default$4(), $this.ec$18).flatMap((Function1 & Serializable)x$88 -> {
                                BoxedUnit boxedUnit = x$88;
                                Some x$1 = transactionFilter;
                                String x$2 = offset1.getAbsolute();
                                String x$3 = GetActiveContractsRequest$.MODULE$.apply$default$1();
                                boolean x$4 = GetActiveContractsRequest$.MODULE$.apply$default$3();
                                FutureAssertions qual$1 = Assertions$.MODULE$.futureAssertions(ledger.activeContractsIds(new GetActiveContractsRequest(x$3, (Option)x$1, x$4, x$2)));
                                String x$5 = "ACS before the pruning offset";
                                RequestValidation.ParticipantPrunedDataAccessed$ x$6 = RequestValidation.ParticipantPrunedDataAccessed$.MODULE$;
                                Option x$7 = qual$1.mustFailWith$default$3();
                                return qual$1.mustFailWith("ACS before the pruning offset", (ErrorCode)x$6, x$7, $this.ec$18).map((Function1 & Serializable)x$87 -> {
                                    $anonfun$$nestedInanonfun$new$21$1.$anonfun$applyOrElse$181(x$87);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$18);
                            }, $this.ec$18);
                        }, $this.ec$18), $this.ec$18);
                    }, $this.ec$18), this.ec$18);
                }
                return (B1)function1.apply(x18);
            }

            public final boolean isDefinedAt(Allocation.Participants x18) {
                Allocation.Participant participant;
                Allocation.Participants participants = x18;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$181(BoxedUnit x$87) {
                BoxedUnit boxedUnit = x$87;
            }
            {
                this.ec$18 = ec$18;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$175(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$21$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$176(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$21$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object ), $anonfun$applyOrElse$177(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$21$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$178(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$21$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object ), $anonfun$applyOrElse$179(java.lang.Object ), $anonfun$applyOrElse$180(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$21$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset scala.runtime.BoxedUnit ), $anonfun$applyOrElse$181$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        this.test("AcsBeforePruningOffsetIsDisallowed", "Fail when requesting ACS before the pruning offset", x$25, x$27, false, x$28, x$23, "Requires ACS with active_at_offset", x$29, x$30);
        String x$31 = "ActiveAtOffsetInvalidFormat";
        String x$32 = "Fail when active_at_offset has invalid format";
        Function1 & Serializable x$33 = (Function1 & Serializable)x$91 -> BoxesRunTime.boxToBoolean((boolean)x$91.acsActiveAtOffsetFeature());
        String x$34 = "Requires ACS with active_at_offset";
        Allocation.PartyAllocation x$35 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        double x$36 = this.test$default$4();
        boolean x$37 = this.test$default$5();
        int x$38 = this.test$default$6();
        List x$39 = this.test$default$9();
        Function1 & Serializable x$40 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$19;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x19, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x19;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    Some transactionFilter;
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Some x$1 = transactionFilter = new Some((Object)new TransactionFilter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(party))), (Object)new Filters(Filters$.MODULE$.apply$default$1()))}))));
                    String x$2 = "bad";
                    String x$3 = GetActiveContractsRequest$.MODULE$.apply$default$1();
                    boolean x$4 = GetActiveContractsRequest$.MODULE$.apply$default$3();
                    FutureAssertions qual$1 = Assertions$.MODULE$.futureAssertions(ledger.activeContracts(new GetActiveContractsRequest(x$3, (Option)x$1, x$4, "bad")));
                    String x$5 = "invalid offset format";
                    RequestValidation.NonHexOffset$ x$6 = RequestValidation.NonHexOffset$.MODULE$;
                    Option x$7 = qual$1.mustFailWith$default$3();
                    return (B1)qual$1.mustFailWith("invalid offset format", (ErrorCode)x$6, x$7, this.ec$19).map((Function1 & Serializable)x$92 -> {
                        $anonfun$$nestedInanonfun$new$23$1.$anonfun$applyOrElse$182(x$92);
                        return BoxedUnit.UNIT;
                    }, this.ec$19);
                }
                return (B1)function1.apply(x19);
            }

            public final boolean isDefinedAt(Allocation.Participants x19) {
                Allocation.Participant participant;
                Allocation.Participants participants = x19;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$182(BoxedUnit x$92) {
                BoxedUnit boxedUnit = x$92;
            }
            {
                this.ec$19 = ec$19;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$182$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        this.test("ActiveAtOffsetInvalidFormat", "Fail when active_at_offset has invalid format", x$35, x$36, x$37, x$38, x$33, "Requires ACS with active_at_offset", x$39, x$40);
        String x$41 = "ActiveAtOffsetAfterLedgerEnd";
        String x$42 = "Fail when active_at_offset is after the ledger end offset";
        Function1 & Serializable x$43 = (Function1 & Serializable)x$93 -> BoxesRunTime.boxToBoolean((boolean)x$93.acsActiveAtOffsetFeature());
        String x$44 = "Requires ACS with active_at_offset";
        Allocation.PartyAllocation x$45 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$46 = false;
        double x$47 = this.test$default$4();
        int x$48 = this.test$default$6();
        List x$49 = this.test$default$9();
        Function1 & Serializable x$50 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$20;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x20, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x20;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Some transactionFilter = new Some((Object)new TransactionFilter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(party))), (Object)new Filters(Filters$.MODULE$.apply$default$1()))}))));
                    return (B1)ledger.offsetBeyondLedgerEnd().flatMap((Function1 & Serializable)offsetBeyondLedgerEnd -> {
                        Some x$1 = transactionFilter;
                        String x$2 = offsetBeyondLedgerEnd.getAbsolute();
                        String x$3 = GetActiveContractsRequest$.MODULE$.apply$default$1();
                        boolean x$4 = GetActiveContractsRequest$.MODULE$.apply$default$3();
                        FutureAssertions qual$1 = Assertions$.MODULE$.futureAssertions(ledger.activeContracts(new GetActiveContractsRequest(x$3, (Option)x$1, x$4, x$2)));
                        String x$5 = "offset after ledger end";
                        RequestValidation.OffsetAfterLedgerEnd$ x$6 = RequestValidation.OffsetAfterLedgerEnd$.MODULE$;
                        Option x$7 = qual$1.mustFailWith$default$3();
                        return qual$1.mustFailWith("offset after ledger end", (ErrorCode)x$6, x$7, $this.ec$20).map((Function1 & Serializable)x$94 -> {
                            $anonfun$$nestedInanonfun$new$25$1.$anonfun$applyOrElse$184(x$94);
                            return BoxedUnit.UNIT;
                        }, $this.ec$20);
                    }, this.ec$20);
                }
                return (B1)function1.apply(x20);
            }

            public final boolean isDefinedAt(Allocation.Participants x20) {
                Allocation.Participant participant;
                Allocation.Participants participants = x20;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$184(BoxedUnit x$94) {
                BoxedUnit boxedUnit = x$94;
            }
            {
                this.ec$20 = ec$20;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$183(com.daml.ledger.api.testtool.suites.v1_8.ActiveContractsServiceIT$$anonfun$$nestedInanonfun$new$25$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Some com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$184$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        this.test("ActiveAtOffsetAfterLedgerEnd", "Fail when active_at_offset is after the ledger end offset", x$45, x$47, false, x$48, x$43, "Requires ACS with active_at_offset", x$49, x$50);
    }
}

