/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.api.util.DurationConversion$;
import com.daml.error.ErrorCode;
import com.daml.error.definitions.LedgerApiErrors$;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.error.definitions.groups.RequestValidation$InvalidDeduplicationPeriodField$;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.FutureAssertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.Features;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$;
import com.daml.ledger.api.v1.admin.participant_pruning_service.PruneResponse;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest$;
import com.daml.ledger.api.v1.command_submission_service.SubmitRequest;
import com.daml.ledger.api.v1.command_submission_service.SubmitRequest$;
import com.daml.ledger.api.v1.commands.Command;
import com.daml.ledger.api.v1.commands.Commands;
import com.daml.ledger.api.v1.commands.Commands$;
import com.daml.ledger.api.v1.completion.Completion;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset$;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.test.model.Test.Dummy;
import com.daml.ledger.test.model.Test.Dummy$;
import com.daml.lf.data.Ref$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.google.protobuf.duration.Duration;
import com.google.protobuf.duration.Duration$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.regex.Pattern;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scalapb.lenses.Lens;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001\u0002\u0004\b\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013-!\u0005\u0003\u0004*\u0001\u0001\u0006Ia\t\u0005\u0006U\u0001!Ia\u000b\u0005\u0006_\u0002!I\u0001\u001d\u0002'\u0007>lW.\u00198e\t\u0016$W\u000f\u001d7jG\u0006$\u0018n\u001c8QKJLw\u000e\u001a,bY&$\u0017\r^5p]&#&B\u0001\u0005\n\u0003\u00111\u0018g\u0018\u001d\u000b\u0005)Y\u0011AB:vSR,7O\u0003\u0002\r\u001b\u0005AA/Z:ui>|GN\u0003\u0002\u000f\u001f\u0005\u0019\u0011\r]5\u000b\u0005A\t\u0012A\u00027fI\u001e,'O\u0003\u0002\u0013'\u0005!A-Y7m\u0015\u0005!\u0012aA2p[\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\tQ2\"\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005qI\"a\u0004'fI\u001e,'\u000fV3tiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u00059\u0011A\u00047pO\u001eLgnZ\"p]R,\u0007\u0010^\u000b\u0002GA\u0011AeJ\u0007\u0002K)\u0011a%E\u0001\bY><w-\u001b8h\u0013\tASE\u0001\bM_\u001e<\u0017N\\4D_:$X\r\u001f;\u0002\u001f1|wmZ5oO\u000e{g\u000e^3yi\u0002\nqDZ5oI\u001aK'o\u001d;PM\u001a\u001cX\r^!gi\u0016\u0014x)\u001b<f]>3gm]3u)\ra3M\u001b\u000b\u0003[\u001d#\"A\f\"\u0011\u0007=\"d'D\u00011\u0015\t\t$'\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kA\u0012aAR;ukJ,\u0007CA\u001c@\u001d\tATH\u0004\u0002:y5\t!H\u0003\u0002<+\u00051AH]8pizJ\u0011aM\u0005\u0003}I\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011aH\r\u0005\u0006\u0007\u0012\u0001\u001d\u0001R\u0001\u0003K\u000e\u0004\"aL#\n\u0005\u0019\u0003$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015AE\u00011\u0001J\u0003\u0015\u0001\u0018M\u001d;z!\tQuL\u0004\u0002L9:\u0011A*\u0017\b\u0003\u001bZs!A\u0014+\u000f\u0005=\u001bfB\u0001)S\u001d\tI\u0014+C\u0001\u0015\u0013\t\u00112#\u0003\u0002\u0011#%\u0011QkD\u0001\u0007G2LWM\u001c;\n\u0005]C\u0016a\u00022j]\u0012Lgn\u001a\u0006\u0003+>I!AW.\u0002\u000fA\f7m[1hK*\u0011q\u000bW\u0005\u0003;z\u000b\u0011\u0002\u0015:j[&$\u0018N^3\u000b\u0005i[\u0016B\u00011b\u0005\u0015\u0001\u0016M\u001d;z\u0013\t\u00117LA\u0005Qe&l\u0017\u000e^5wK\")\u0001\u0003\u0002a\u0001IB\u0011Q\r[\u0007\u0002M*\u0011q-G\u0001\fa\u0006\u0014H/[2ja\u0006tG/\u0003\u0002jM\n1\u0002+\u0019:uS\u000eL\u0007/\u00198u)\u0016\u001cHoQ8oi\u0016DH\u000fC\u0003l\t\u0001\u0007A.\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0003[~r!A\\\u001f\u0011\u0005e\u0012\u0014aF1tg\u0016\u0014HoU=oG\u001a\u000b\u0017\u000e\\3e%\u0016\fX/Z:u))\t\b0\u001f>\u0002\u001c\u0005}\u00111\u0005\u000b\u0003e^\u00042a\f\u001bt!\t!X/D\u00013\u0013\t1(G\u0001\u0003V]&$\b\"B\"\u0006\u0001\b!\u0005\"\u0002\t\u0006\u0001\u0004!\u0007\"\u0002%\u0006\u0001\u0004I\u0005\"B>\u0006\u0001\u0004a\u0018a\u00053fIV\u0004H.[2bi&|g\u000eU3sS>$\u0007cA?\u0002\u00169\u0019a0a\u0004\u000f\u0007}\fIA\u0004\u0003\u0002\u0002\u0005\u0015ab\u0001(\u0002\u0004%\u0011abD\u0005\u0004\u0003\u000fi\u0011A\u0001<2\u0013\u0011\tY!!\u0004\u0002\u0011\r|W.\\1oINT1!a\u0002\u000e\u0013\u0011\t\t\"a\u0005\u0002\u0011\r{W.\\1oINTA!a\u0003\u0002\u000e%!\u0011qCA\r\u0005M!U\rZ;qY&\u001c\u0017\r^5p]B+'/[8e\u0015\u0011\t\t\"a\u0005\t\r\u0005uQ\u00011\u0001m\u0003)1\u0017-\u001b7SK\u0006\u001cxN\u001c\u0005\u0007\u0003C)\u0001\u0019\u00017\u0002\u001f\u0015D\b/Z2uK\u0012lUm]:bO\u0016Dq!!\n\u0006\u0001\u0004\t9#A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011QF\t\u0002\u000b\u0015\u0014(o\u001c:\n\t\u0005E\u00121\u0006\u0002\n\u000bJ\u0014xN]\"pI\u0016\u0004")
public class CommandDeduplicationPeriodValidationIT
extends LedgerTestSuite {
    private final LoggingContext com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$loggingContext = LoggingContext$.MODULE$.ForTesting();

    public LoggingContext com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$loggingContext() {
        return this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$loggingContext;
    }

    public Future<String> com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$findFirstOffsetAfterGivenOffset(ParticipantTestContext ledger, String offset, Object party, ExecutionContext ec) {
        return ledger.findCompletion(ledger.completionStreamRequest(LedgerOffset$.MODULE$.of((LedgerOffset.Value)new LedgerOffset.Value$.Absolute(offset)), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), (Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationPeriodValidationIT.$anonfun$findFirstOffsetAfterGivenOffset$1(x$27))).map((Function1 & Serializable)completionOpt -> {
            ParticipantTestContext.CompletionResponse completion = (ParticipantTestContext.CompletionResponse)Assertions$.MODULE$.assertDefined(completionOpt, "No completion found");
            return completion.offset().getAbsolute();
        }, ec);
    }

    public Future<BoxedUnit> com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$assertSyncFailedRequest(ParticipantTestContext ledger, Object party, Commands.DeduplicationPeriod deduplicationPeriod, String failReason, String expectedMessage, ErrorCode expectedError, ExecutionContext ec) {
        return Assertions$.MODULE$.futureAssertions(ledger.submit((SubmitRequest)ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$28 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$28).commands()).deduplicationPeriod().$colon$eq((Object)deduplicationPeriod)})))).mustFail(failReason, ec).map((Function1 & Serializable)failure -> {
            Assertions$.MODULE$.assertGrpcErrorRegex(failure, expectedError, (Option)new Some((Object)Pattern.compile(expectedMessage)), Assertions$.MODULE$.assertGrpcErrorRegex$default$4(), Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            return BoxedUnit.UNIT;
        }, ec);
    }

    public static final /* synthetic */ boolean $anonfun$new$4(Features x$4) {
        return x$4.commandDeduplicationFeatures().maxDeduplicationDurationEnforced();
    }

    public static final /* synthetic */ boolean $anonfun$new$6(Features x$12) {
        return x$12.commandDeduplicationFeatures().getDeduplicationPeriodSupport().offsetSupport().isOffsetConvertToDuration();
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Features x$15) {
        return !x$15.commandDeduplicationFeatures().getDeduplicationPeriodSupport().offsetSupport().isOffsetNotSupported();
    }

    public static final /* synthetic */ boolean $anonfun$findFirstOffsetAfterGivenOffset$1(Completion x$27) {
        return true;
    }

    public CommandDeduplicationPeriodValidationIT() {
        this.test("ValidDeduplicationDuration", "Submission returns OK if deduplication time is within the accepted interval", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitRequest request = ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.configuration(ledger.configuration$default$1()).map((Function1 & Serializable)config -> {
                        Duration maxDedupDuration = (Duration)config.maxDeduplicationDuration().get();
                        return new Tuple2(config, (Object)maxDedupDuration);
                    }, this.ec$1).flatMap((Function1 & Serializable)x$3 -> {
                        Tuple2 tuple2 = x$3;
                        if (tuple2 != null) {
                            Duration maxDedupDuration = (Duration)tuple2._2();
                            return ledger.submit((SubmitRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$1 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$1).commands()).deduplicationTime().$colon$eq((Object)maxDedupDuration)}))).map((Function1 & Serializable)x$2 -> {
                                $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$4(x$2);
                                return BoxedUnit.UNIT;
                            }, $this.ec$1);
                        }
                        throw new MatchError((Object)tuple2);
                    }, this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$4(BoxedUnit x$2) {
                BoxedUnit boxedUnit = x$2;
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.v1.ledger_configuration_service.LedgerConfiguration ), $anonfun$applyOrElse$2(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest scala.Tuple2 ), $anonfun$applyOrElse$3(com.google.protobuf.duration.Duration scalapb.lenses.Lens ), $anonfun$applyOrElse$4$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
        this.test("NegativeDeduplicationDuration", "Submission with negative deduplication durations are rejected", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationPeriodValidationIT $outer;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Commands.DeduplicationPeriod$.DeduplicationDuration deduplicationPeriod = new Commands.DeduplicationPeriod$.DeduplicationDuration(DurationConversion$.MODULE$.toProto(java.time.Duration.ofSeconds(-1L)));
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$assertSyncFailedRequest(ledger, party, (Commands.DeduplicationPeriod)deduplicationPeriod, "Requests with a deduplication period represented by a negative duration", "The submitted command has a field with invalid value: Invalid field deduplication_period: Duration must be positive", (ErrorCode)RequestValidation.InvalidField$.MODULE$, this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$2 = ec$2;
            }
        });
        this.test("InvalidOffset", "Submission with deduplication periods represented by invalid offsets are rejected", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationPeriodValidationIT $outer;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Commands.DeduplicationPeriod$.DeduplicationOffset deduplicationPeriod = new Commands.DeduplicationPeriod$.DeduplicationOffset("invalid_offset");
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$assertSyncFailedRequest(ledger, party, (Commands.DeduplicationPeriod)deduplicationPeriod, "Submitting a command with an invalid offset", "Offset in deduplication_period not specified in hexadecimal: invalid_offset: the deduplication offset has to be a hexadecimal string and not invalid_offset", (ErrorCode)RequestValidation.NonHexOffset$.MODULE$, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$3 = ec$3;
            }
        });
        String x$1 = "DeduplicationDurationExceedsMaxDeduplicationDuration";
        String x$2 = "Submission returns expected error codes if deduplication time is too big";
        Allocation.PartyAllocation x$3 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$42 = (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationPeriodValidationIT.$anonfun$new$4(x$4));
        String x$5 = "Maximum deduplication duration is not enforced by the ledger";
        double x$6 = this.test$default$4();
        boolean x$7 = this.test$default$5();
        int x$8 = this.test$default$6();
        List x$9 = this.test$default$9();
        Function1 & Serializable x$10 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitRequest request = ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    RequestValidation$InvalidDeduplicationPeriodField$ expectedError = RequestValidation$InvalidDeduplicationPeriodField$.MODULE$;
                    return (B1)ledger.configuration(ledger.configuration$default$1()).map((Function1 & Serializable)config -> {
                        Duration maxDedupDuration = (Duration)config.maxDeduplicationDuration().get();
                        return new Tuple2(config, (Object)maxDedupDuration);
                    }, this.ec$4).flatMap((Function1 & Serializable)x$11 -> {
                        Tuple2 tuple2 = x$11;
                        if (tuple2 != null) {
                            Duration maxDedupDuration = (Duration)tuple2._2();
                            return Assertions$.MODULE$.futureAssertions(ledger.submit((SubmitRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$5 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$5).commands()).deduplicationTime().$colon$eq(maxDedupDuration.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$6 -> Duration$.MODULE$.DurationLens(x$6).seconds().$colon$eq((Object)BoxesRunTime.boxToLong((long)(maxDedupDuration.seconds() + 1L)))})))})))).mustFail("submitting a command with a deduplication time that is too big", $this.ec$4).map((Function1 & Serializable)failure -> {
                                Assertions$.MODULE$.assertGrpcErrorRegex(failure, (ErrorCode)expectedError, (Option)new Some((Object)Pattern.compile("The given deduplication .+ exceeds the maximum deduplication .+")), Assertions$.MODULE$.assertGrpcErrorRegex$default$4(), Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
                                BoxedUnit x$8 = BoxedUnit.UNIT;
                                String metadataLongestDuration = Assertions$.MODULE$.extractErrorInfoMetadataValue(failure, "longest_duration");
                                return new Tuple3(failure, (Object)x$8, (Object)metadataLongestDuration);
                            }, $this.ec$4).flatMap((Function1 & Serializable)x$10 -> {
                                Tuple3 tuple3 = x$10;
                                if (tuple3 != null) {
                                    String metadataLongestDuration = (String)tuple3._3();
                                    return ledger.submit((SubmitRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$7 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$7).commands()).deduplicationDuration().$colon$eq((Object)DurationConversion$.MODULE$.toProto(java.time.Duration.parse(metadataLongestDuration)))}))).map((Function1 & Serializable)x$9 -> {
                                        $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$12(x$9);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$4);
                                }
                                throw new MatchError((Object)tuple3);
                            }, $this.ec$4);
                        }
                        throw new MatchError((Object)tuple2);
                    }, this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$12(BoxedUnit x$9) {
                BoxedUnit boxedUnit = x$9;
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest scala.Tuple3 ), $anonfun$applyOrElse$11(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$12$adapted(scala.runtime.BoxedUnit ), $anonfun$applyOrElse$5(com.daml.ledger.api.v1.ledger_configuration_service.LedgerConfiguration ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest com.daml.error.definitions.groups.RequestValidation$InvalidDeduplicationPeriodField$ scala.Tuple2 ), $anonfun$applyOrElse$7(com.google.protobuf.duration.Duration scalapb.lenses.Lens ), $anonfun$applyOrElse$8(com.google.protobuf.duration.Duration scalapb.lenses.Lens ), $anonfun$applyOrElse$9(com.daml.error.definitions.groups.RequestValidation$InvalidDeduplicationPeriodField$ java.lang.Throwable )}, serializedLambda);
            }
        };
        this.test("DeduplicationDurationExceedsMaxDeduplicationDuration", "Submission returns expected error codes if deduplication time is too big", x$3, x$6, x$7, x$8, x$42, "Maximum deduplication duration is not enforced by the ledger", x$9, x$10);
        String x$11 = "OffsetOutsideRange";
        String x$122 = "Submission with deduplication periods represented by offsets which are outside the valid range are rejected";
        Allocation.PartyAllocation x$13 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$14 = (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationPeriodValidationIT.$anonfun$new$6(x$12));
        String x$152 = "Only ledgers that convert offsets to durations fail";
        double x$16 = this.test$default$4();
        boolean x$17 = this.test$default$5();
        int x$18 = this.test$default$6();
        List x$19 = this.test$default$9();
        Function1 & Serializable x$20 = (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationPeriodValidationIT $outer;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.offsetBeyondLedgerEnd().map((Function1 & Serializable)end -> {
                        Commands.DeduplicationPeriod$.DeduplicationOffset deduplicationPeriod = new Commands.DeduplicationPeriod$.DeduplicationOffset((String)Ref$.MODULE$.HexString().assertFromString(end.getAbsolute().toLowerCase()));
                        return new Tuple2(end, (Object)deduplicationPeriod);
                    }, this.ec$5).flatMap((Function1 & Serializable)x$14 -> {
                        Tuple2 tuple2 = x$14;
                        if (tuple2 != null) {
                            Commands.DeduplicationPeriod$.DeduplicationOffset deduplicationPeriod = (Commands.DeduplicationPeriod$.DeduplicationOffset)tuple2._2();
                            return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$assertSyncFailedRequest(ledger, party, (Commands.DeduplicationPeriod)deduplicationPeriod, "Submitting a command with an invalid offset", "The submitted command had an invalid deduplication period: Cannot convert deduplication offset to duration because there is no completion at given offset .*", (ErrorCode)RequestValidation$InvalidDeduplicationPeriodField$.MODULE$, $this.ec$5).map((Function1 & Serializable)x$13 -> {
                                $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$15(x$13);
                                return BoxedUnit.UNIT;
                            }, $this.ec$5);
                        }
                        throw new MatchError((Object)tuple2);
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$15(BoxedUnit x$13) {
                BoxedUnit boxedUnit = x$13;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$13(com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$14(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$15$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        this.test("OffsetOutsideRange", "Submission with deduplication periods represented by offsets which are outside the valid range are rejected", x$13, x$16, x$17, x$18, x$14, "Only ledgers that convert offsets to durations fail", x$19, x$20);
        String x$21 = "OffsetPruned";
        String x$22 = "Submission with deduplication periods represented by offsets which are pruned are rejected";
        Allocation.PartyAllocation x$23 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$24 = (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationPeriodValidationIT.$anonfun$new$8(x$15));
        String x$25 = "The ledger does not support deduplication periods represented by offsets";
        boolean x$26 = false;
        double x$27 = this.test$default$4();
        int x$28 = this.test$default$6();
        List x$29 = this.test$default$9();
        Function1 & Serializable x$30 = (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationPeriodValidationIT $outer;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    boolean isOffsetNativelySupported = ledger.features().commandDeduplicationFeatures().getDeduplicationPeriodSupport().offsetSupport().isOffsetNativeSupport();
                    return (B1)ledger.currentEnd().flatMap((Function1 & Serializable)start -> ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)firstCreate -> ledger.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(firstCreate), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$26 -> {
                        TransactionTree transactionTree = x$26;
                        return ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)secondCreate -> ledger.submitAndWait(ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}))).flatMap((Function1 & Serializable)x$25 -> {
                            BoxedUnit boxedUnit = x$25;
                            return ledger.currentEnd().flatMap((Function1 & Serializable)end -> ledger.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(secondCreate), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$24 -> {
                                TransactionTree transactionTree = x$24;
                                return FutureAssertions$.MODULE$.succeedsEventually(new package.DurationInt(package$.MODULE$.DurationInt(10)).millis(), new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds(), ledger.delayMechanism(), "Prune offsets", (Function0 & Serializable)() -> ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)x$19 -> {
                                    Object object = x$19;
                                    return ledger.submitAndWait(ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}))).flatMap((Function1 & Serializable)x$18 -> {
                                        BoxedUnit boxedUnit = x$18;
                                        return ledger.prune(end, 1, ledger.prune$default$3()).map((Function1 & Serializable)x$17 -> {
                                            $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$27(x$17);
                                            return BoxedUnit.UNIT;
                                        }, $this.ec$6);
                                    }, $this.ec$6);
                                }, $this.ec$6), $this.ec$6, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$loggingContext()).flatMap((Function1 & Serializable)x$23 -> {
                                    BoxedUnit boxedUnit = x$23;
                                    return Assertions$.MODULE$.futureAssertions($anonfun$$nestedInanonfun$new$9$1.submitAndWaitWithDeduplication$1(new Commands.DeduplicationPeriod$.DeduplicationOffset(start.getAbsolute()), ledger, party)).mustFail("using an offset which was pruned", $this.ec$6).map((Function1 & Serializable)failure -> {
                                        Assertions$.MODULE$.assertGrpcErrorRegex(failure, (ErrorCode)(isOffsetNativelySupported ? RequestValidation$InvalidDeduplicationPeriodField$.MODULE$ : RequestValidation.ParticipantPrunedDataAccessed$.MODULE$), (Option)None$.MODULE$, Assertions$.MODULE$.assertGrpcErrorRegex$default$4(), Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
                                        BoxedUnit x$20 = BoxedUnit.UNIT;
                                        String earliestOffset = Assertions$.MODULE$.extractErrorInfoMetadataValue(failure, LedgerApiErrors$.MODULE$.EarliestOffsetMetadataKey());
                                        return new Tuple3(failure, (Object)x$20, (Object)earliestOffset);
                                    }, $this.ec$6).flatMap((Function1 & Serializable)x$22 -> {
                                        Tuple3 tuple3 = x$22;
                                        if (tuple3 != null) {
                                            String earliestOffset = (String)tuple3._3();
                                            return (isOffsetNativelySupported ? $anonfun$$nestedInanonfun$new$9$1.submitAndWaitWithDeduplication$1(new Commands.DeduplicationPeriod$.DeduplicationOffset(earliestOffset), ledger, party) : $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationPeriodValidationIT$$findFirstOffsetAfterGivenOffset(ledger, earliestOffset, party, $this.ec$6).flatMap((Function1 & Serializable)offset -> $anonfun$$nestedInanonfun$new$9$1.submitAndWaitWithDeduplication$1(new Commands.DeduplicationPeriod$.DeduplicationOffset(offset), ledger, party), $this.ec$6)).map((Function1 & Serializable)x$21 -> {
                                                $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$32(x$21);
                                                return BoxedUnit.UNIT;
                                            }, $this.ec$6);
                                        }
                                        throw new MatchError((Object)tuple3);
                                    }, $this.ec$6);
                                }, $this.ec$6);
                            }, $this.ec$6), $this.ec$6);
                        }, $this.ec$6), $this.ec$6);
                    }, $this.ec$6), $this.ec$6), this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            private static final Future submitAndWaitWithDeduplication$1(Commands.DeduplicationPeriod$.DeduplicationOffset deduplicationPeriod, ParticipantTestContext ledger$4, Object party$2) {
                return ledger$4.submitAndWait((SubmitAndWaitRequest)ledger$4.submitAndWaitRequest(party$2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party$2).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$16 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$16).commands()).deduplicationPeriod().$colon$eq((Object)deduplicationPeriod)})));
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$27(PruneResponse x$17) {
                PruneResponse pruneResponse = x$17;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$32(BoxedUnit x$21) {
                BoxedUnit boxedUnit = x$21;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$16(com.daml.ledger.api.v1.commands.Commands$DeduplicationPeriod$DeduplicationOffset scalapb.lenses.Lens ), $anonfun$applyOrElse$17(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object boolean com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$18(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset boolean java.lang.Object ), $anonfun$applyOrElse$19(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset boolean com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$20(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset boolean java.lang.Object ), $anonfun$applyOrElse$21(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset boolean scala.runtime.BoxedUnit ), $anonfun$applyOrElse$22(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset boolean com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$23(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset com.daml.ledger.api.v1.ledger_offset.LedgerOffset boolean com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$24(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$25(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object ), $anonfun$applyOrElse$26(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.ledger_offset.LedgerOffset scala.runtime.BoxedUnit ), $anonfun$applyOrElse$27$adapted(com.daml.ledger.api.v1.admin.participant_pruning_service.PruneResponse ), $anonfun$applyOrElse$28(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.v1.ledger_offset.LedgerOffset boolean com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$29(boolean java.lang.Throwable ), $anonfun$applyOrElse$30(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationPeriodValidationIT$$anonfun$$nestedInanonfun$new$9$1 boolean com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$31(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String ), $anonfun$applyOrElse$32$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        this.test("OffsetPruned", "Submission with deduplication periods represented by offsets which are pruned are rejected", x$23, x$27, false, x$28, x$24, "The ledger does not support deduplication periods represented by offsets", x$29, x$30);
    }
}

