/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.CommandExecution;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.FutureAssertions;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.client.binding.package$;
import com.daml.ledger.test.semantic.TimeTests.TimeChecker;
import com.daml.ledger.test.semantic.TimeTests.TimeChecker$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005=3Aa\u0001\u0003\u0003'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?\tiA+[7f'\u0016\u0014h/[2f\u0013RS!!\u0002\u0004\u0002\tY\ft\f\u000f\u0006\u0003\u000f!\taa];ji\u0016\u001c(BA\u0005\u000b\u0003!!Xm\u001d;u_>d'BA\u0006\r\u0003\r\t\u0007/\u001b\u0006\u0003\u001b9\ta\u0001\\3eO\u0016\u0014(BA\b\u0011\u0003\u0011!\u0017-\u001c7\u000b\u0003E\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011AD5oMJ\f7\u000f\u001e:vGR,(/Z\u0005\u00033Y\u0011q\u0002T3eO\u0016\u0014H+Z:u'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\u0011\tqb\u0019:fCR,G+[7fgR\fW\u000e\u001d\u000b\u0003A\u0015\u00032!\t\u0014)\u001b\u0005\u0011#BA\u0012%\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002K\u0005)1oY1mC&\u0011qE\t\u0002\u0007\rV$XO]3\u0011\u0005%\neB\u0001\u0016?\u001d\tY3H\u0004\u0002-q9\u0011QF\u000e\b\u0003]Ur!a\f\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0005I\u0012\u0012A\u0002\u001fs_>$h(C\u0001\u0012\u0013\ty\u0001#\u0003\u0002\u000e\u001d%\u0011q\u0007D\u0001\u0007G2LWM\u001c;\n\u0005eR\u0014a\u00022j]\u0012Lgn\u001a\u0006\u0003o1I!\u0001P\u001f\u0002\u000fA\f7m[1hK*\u0011\u0011HO\u0005\u0003\u007f\u0001\u000b\u0011\u0002\u0015:j[&$\u0018N^3\u000b\u0005qj\u0014B\u0001\"D\u0005%!\u0016.\\3ti\u0006l\u0007/\u0003\u0002E{\tI\u0001K]5nSRLg/\u001a\u0005\u0006\r\n\u0001\raR\u0001\bg\u0016\u001cwN\u001c3t!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003uS6,'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013q!\u00138ti\u0006tG\u000f")
public final class TimeServiceIT
extends LedgerTestSuite {
    public Future<Instant> createTimestamp(Instant seconds) {
        return (Future)package$.MODULE$.Primitive().Timestamp().discardNanos(seconds).fold((Function0 & Serializable)() -> Future$.MODULE$.failed((Throwable)new IllegalStateException("Empty option")), (Function1 & Serializable)result -> Future$.MODULE$.successful(result));
    }

    public TimeServiceIT() {
        String x$12 = "TSTimeIsStatic";
        String x$2 = "Time stands still when static time enabled";
        Allocation.PartyAllocation x$32 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$4 = false;
        Function1 & Serializable x$5 = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.staticTime());
        String x$62 = "requires ledger static time feature";
        double x$7 = this.test$default$4();
        int x$8 = this.test$default$6();
        List x$92 = this.test$default$9();
        Function1 & Serializable x$102 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)ledger.time().flatMap((Function1 & Serializable)initialTime -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Thread.sleep(100L), $this.ec$1).flatMap((Function1 & Serializable)x$2 -> {
                        BoxedUnit boxedUnit = x$2;
                        return ledger.time().map((Function1 & Serializable)laterTime -> {
                            $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$4(initialTime, laterTime);
                            return BoxedUnit.UNIT;
                        }, $this.ec$1);
                    }, $this.ec$1), this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$4(Instant initialTime$1, Instant laterTime) {
                Assertions$.MODULE$.assertEquals("ledger time should stand still", (Object)laterTime, (Object)initialTime$1);
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.time.Instant ), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.time.Instant scala.runtime.BoxedUnit ), $anonfun$applyOrElse$4$adapted(java.time.Instant java.time.Instant )}, serializedLambda);
            }
        };
        this.test("TSTimeIsStatic", "Time stands still when static time enabled", x$32, x$7, false, x$8, x$5, "requires ledger static time feature", x$92, x$102);
        String x$11 = "TSTimeCanBeAdvanced";
        String x$122 = "Time can be advanced when static time enabled";
        Allocation.PartyAllocation x$13 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$14 = false;
        Function1 & Serializable x$15 = (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.staticTime());
        String x$16 = "requires ledger static time feature";
        double x$17 = this.test$default$4();
        int x$18 = this.test$default$6();
        List x$19 = this.test$default$9();
        Function1 & Serializable x$20 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)ledger.time().map((Function1 & Serializable)initialTime -> {
                        Instant thirtySecLater = initialTime.plusSeconds(30L);
                        return new Tuple2(initialTime, (Object)thirtySecLater);
                    }, this.ec$2).flatMap((Function1 & Serializable)x$5 -> {
                        Tuple2 tuple2 = x$5;
                        if (tuple2 != null) {
                            Instant initialTime = (Instant)tuple2._1();
                            Instant thirtySecLater = (Instant)tuple2._2();
                            return ledger.setTime(initialTime, thirtySecLater).flatMap((Function1 & Serializable)x$4 -> {
                                BoxedUnit boxedUnit = x$4;
                                return ledger.time().map((Function1 & Serializable)laterTime -> {
                                    $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$8(thirtySecLater, laterTime);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$2);
                            }, $this.ec$2);
                        }
                        throw new MatchError((Object)tuple2);
                    }, this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$8(Instant thirtySecLater$1, Instant laterTime) {
                Assertions$.MODULE$.assertEquals("ledger time should be advanced", (Object)laterTime, (Object)thirtySecLater$1);
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(java.time.Instant ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple2 ), $anonfun$applyOrElse$7(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.time.Instant scala.runtime.BoxedUnit ), $anonfun$applyOrElse$8$adapted(java.time.Instant java.time.Instant )}, serializedLambda);
            }
        };
        this.test("TSTimeCanBeAdvanced", "Time can be advanced when static time enabled", x$13, x$17, false, x$18, x$15, "requires ledger static time feature", x$19, x$20);
        String x$21 = "TSTimeAdvancementCanFail";
        String x$22 = "Time advancement can fail when current time is not accurate";
        Allocation.PartyAllocation x$23 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$24 = false;
        Function1 & Serializable x$25 = (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.staticTime());
        String x$26 = "requires ledger static time feature";
        double x$27 = this.test$default$4();
        int x$28 = this.test$default$6();
        List x$29 = this.test$default$9();
        Function1 & Serializable x$30 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)ledger.time().map((Function1 & Serializable)initialTime -> {
                        Instant invalidInitialTime = initialTime.plusSeconds(1L);
                        Instant thirtySecLater = initialTime.plusSeconds(30L);
                        return new Tuple3(initialTime, (Object)invalidInitialTime, (Object)thirtySecLater);
                    }, this.ec$3).flatMap((Function1 & Serializable)x$8 -> {
                        Tuple3 tuple3 = x$8;
                        if (tuple3 != null) {
                            Instant invalidInitialTime = (Instant)tuple3._2();
                            Instant thirtySecLater = (Instant)tuple3._3();
                            FutureAssertions qual$1 = Assertions$.MODULE$.futureAssertions(ledger.setTime(invalidInitialTime, thirtySecLater));
                            String x$1 = "current_time mismatch";
                            RequestValidation.InvalidArgument$ x$2 = RequestValidation.InvalidArgument$.MODULE$;
                            Option x$3 = qual$1.mustFailWith$default$3();
                            return qual$1.mustFailWith("current_time mismatch", (ErrorCode)x$2, x$3, $this.ec$3).map((Function1 & Serializable)x$7 -> {
                                $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$11(x$7);
                                return BoxedUnit.UNIT;
                            }, $this.ec$3);
                        }
                        throw new MatchError((Object)tuple3);
                    }, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$11(BoxedUnit x$7) {
                BoxedUnit boxedUnit = x$7;
            }
            {
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple3 ), $anonfun$applyOrElse$11$adapted(scala.runtime.BoxedUnit ), $anonfun$applyOrElse$9(java.time.Instant )}, serializedLambda);
            }
        };
        this.test("TSTimeAdvancementCanFail", "Time advancement can fail when current time is not accurate", x$23, x$27, false, x$28, x$25, "requires ledger static time feature", x$29, x$30);
        String x$31 = "TSFailWhenTimeNotAdvanced";
        String x$322 = "The submission of an exercise before time advancement should fail";
        Allocation.PartyAllocation x$33 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$34 = false;
        Function1 & Serializable x$35 = (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.staticTime());
        String x$36 = "requires ledger static time feature";
        double x$37 = this.test$default$4();
        int x$38 = this.test$default$6();
        List x$39 = this.test$default$9();
        Function1 & Serializable x$40 = (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeServiceIT $outer;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.time().flatMap((Function1 & Serializable)initialTime -> $this.$outer.createTimestamp(initialTime.plusSeconds(30L)).flatMap((Function1 & Serializable)thirtySecLater -> ledger.create(party, (Template)new TimeChecker(party, thirtySecLater)).flatMap((Function1 & Serializable)checker -> Assertions$.MODULE$.futureAssertions(ledger.exercise(party, TimeChecker.TimeChecker$u0020syntax$.MODULE$.exerciseTimeChecker_CheckTime$extension(TimeChecker$.MODULE$.TimeChecker$u0020syntax(checker), ExerciseOn$.MODULE$.OnId()))).mustFail("submitting choice prematurely", $this.ec$4).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$15(failure);
                        return BoxedUnit.UNIT;
                    }, $this.ec$4), $this.ec$4), $this.ec$4), this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$15(Throwable failure) {
                Assertions$.MODULE$.assertGrpcErrorRegex(failure, (ErrorCode)CommandExecution.Interpreter$.UnhandledException$.MODULE$, (Option)new Some((Object)Pattern.compile("Unhandled (Daml )?exception")), true, Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$12(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.time.Instant ), $anonfun$applyOrElse$13(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.time.Instant ), $anonfun$applyOrElse$14(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$15$adapted(java.lang.Throwable )}, serializedLambda);
            }
        };
        this.test("TSFailWhenTimeNotAdvanced", "The submission of an exercise before time advancement should fail", x$33, x$37, false, x$38, x$35, "requires ledger static time feature", x$39, x$40);
        String x$41 = "TSSucceedWhenTimeAdvanced";
        String x$42 = "The submission of an exercise after time advancement should succeed";
        Allocation.PartyAllocation x$43 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$44 = false;
        Function1 & Serializable x$45 = (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.staticTime());
        String x$46 = "requires ledger static time feature";
        double x$47 = this.test$default$4();
        int x$48 = this.test$default$6();
        List x$49 = this.test$default$9();
        Function1 & Serializable x$50 = (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeServiceIT $outer;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.time().flatMap((Function1 & Serializable)initialTime -> $this.$outer.createTimestamp(initialTime.plusSeconds(30L)).flatMap((Function1 & Serializable)thirtySecLater -> ledger.create(party, (Template)new TimeChecker(party, thirtySecLater)).flatMap((Function1 & Serializable)checker -> ledger.setTime(initialTime, initialTime.plusSeconds(30L)).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = x$12;
                        return ledger.exercise(party, TimeChecker.TimeChecker$u0020syntax$.MODULE$.exerciseTimeChecker_CheckTime$extension(TimeChecker$.MODULE$.TimeChecker$u0020syntax(checker), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$11 -> {
                            $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$20(x$11);
                            return BoxedUnit.UNIT;
                        }, $this.ec$5);
                    }, $this.ec$5), $this.ec$5), $this.ec$5), this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$20(TransactionTree x$11) {
                TransactionTree transactionTree = x$11;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$16(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.time.Instant ), $anonfun$applyOrElse$17(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.time.Instant java.time.Instant ), $anonfun$applyOrElse$18(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.time.Instant java.lang.Object java.lang.Object ), $anonfun$applyOrElse$19(com.daml.ledger.api.testtool.suites.v1_8.TimeServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$20$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        };
        this.test("TSSucceedWhenTimeAdvanced", "The submission of an exercise after time advancement should succeed", x$43, x$47, false, x$48, x$45, "requires ledger static time feature", x$49, x$50);
    }
}

