/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Endpoint;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.tls.TlsConfiguration;
import com.daml.ledger.api.tls.TlsVersion;
import com.daml.ledger.api.v1.ledger_identity_service.GetLedgerIdentityRequest;
import com.daml.ledger.api.v1.ledger_identity_service.GetLedgerIdentityResponse;
import com.daml.ledger.api.v1.ledger_identity_service.LedgerIdentityServiceGrpc$;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.ResourceOwner$;
import com.daml.resources.AbstractResourceOwner;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005U4Q\u0001C\u0005\u0002\u0002aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)\u0001\b\u0001C\u0001s!)a\b\u0001C\u0001\u007f!)a\b\u0001C\u00017\"A\u0001\u000e\u0001EC\u0002\u0013%\u0011\u000e\u0003\u0005u\u0001!\u0015\r\u0011\"\u0003j\u0005\u0015!Fn]%U\u0015\tQ1\"\u0001\u0003wc}C$B\u0001\u0007\u000e\u0003\u0019\u0019X/\u001b;fg*\u0011abD\u0001\ti\u0016\u001cH\u000f^8pY*\u0011\u0001#E\u0001\u0004CBL'B\u0001\n\u0014\u0003\u0019aW\rZ4fe*\u0011A#F\u0001\u0005I\u0006lGNC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u001b\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017B\u0001\u0010\u001c\u0005=aU\rZ4feR+7\u000f^*vSR,\u0017!F:i_J$\u0018\nZ3oi&4\u0017.\u001a:Qe\u00164\u0017\u000e\u001f\t\u0003C)r!A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015:\u0012A\u0002\u001fs_>$hHC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIc%\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015'\u0003Y\u0019G.[3oiRc7oQ8oM&<WO]1uS>t\u0007cA\u00181e5\ta%\u0003\u00022M\t1q\n\u001d;j_:\u0004\"a\r\u001c\u000e\u0003QR!!N\b\u0002\u0007Qd7/\u0003\u00028i\t\u0001B\u000b\\:D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007ibT\b\u0005\u0002<\u00015\t\u0011\u0002C\u0003 \u0007\u0001\u0007\u0001\u0005C\u0003.\u0007\u0001\u0007a&A\tuKN$H\u000b\\:D_:tWm\u0019;j_:$2\u0001Q\"W!\ty\u0013)\u0003\u0002CM\t!QK\\5u\u0011\u0015!E\u00011\u0001F\u0003A\u0019G.[3oiRc7OV3sg&|g\u000e\u0005\u0002G':\u0011q)\u0015\b\u0003\u0011Bs!!S(\u000f\u0005)seBA&N\u001d\t\u0019C*C\u0001\u0017\u0013\t!R#\u0003\u0002\u0013'%\u0011\u0001#E\u0005\u0003k=I!A\u0015\u001b\u0002\u0015Qc7OV3sg&|g.\u0003\u0002U+\nQA\u000b\\:WKJ\u001c\u0018n\u001c8\u000b\u0005I#\u0004\"B,\u0005\u0001\u0004A\u0016AE1tg\u0016\u0014HoQ8o]\u0016\u001cG/[8o\u001f.\u0004\"aL-\n\u0005i3#a\u0002\"p_2,\u0017M\u001c\u000b\u0004\u0001r;\u0007\"B/\u0006\u0001\u0004q\u0016!E2mS\u0016tG\u000f\u00167t-\u0016\u00148/[8ogB\u0019q\fZ#\u000f\u0005\u0001\u0014gBA\u0012b\u0013\u00059\u0013BA2'\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001a4\u0003\u0007M+\u0017O\u0003\u0002dM!)q+\u0002a\u00011\u0006Q\u0012m]:feR\u001cVoY2fgN4W\u000f\\\"p]:,7\r^5p]V\t!\u000e\u0005\u00030W6\u001c\u0018B\u00017'\u0005%1UO\\2uS>t\u0017\u0007E\u0002oc\u0002j\u0011a\u001c\u0006\u0003a\u001a\nA!\u001e;jY&\u0011!o\u001c\u0002\u0004)JL\bc\u00018r\u0001\u00061\u0012m]:feR4\u0015-\u001b7fI\u000e{gN\\3di&|g\u000e")
public abstract class TlsIT
extends LedgerTestSuite {
    private Function1<Try<String>, Try<BoxedUnit>> assertSuccessfulConnection;
    private Function1<Try<String>, Try<BoxedUnit>> assertFailedConnection;
    private final String shortIdentifierPrefix;
    public final Option<TlsConfiguration> com$daml$ledger$api$testtool$suites$v1_8$TlsIT$$clientTlsConfiguration;
    private volatile byte bitmap$0;

    public void testTlsConnection(TlsVersion.TlsVersion clientTlsVersion, boolean assertConnectionOk) {
        this.testTlsConnection((Seq<TlsVersion.TlsVersion>)new .colon.colon((Object)clientTlsVersion, (List)Nil$.MODULE$), assertConnectionOk);
    }

    public void testTlsConnection(Seq<TlsVersion.TlsVersion> clientTlsVersions, boolean assertConnectionOk) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = assertConnectionOk ? new Tuple2((Object)"accept", this.assertSuccessfulConnection()) : new Tuple2((Object)"reject", this.assertFailedConnection());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String what = (String)tuple2._1();
        Function1 assertionOnServerResponse = (Function1)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)what, (Object)assertionOnServerResponse);
        String what2 = (String)tuple23._1();
        Function1 assertionOnServerResponse2 = (Function1)tuple23._2();
        String clientTlsVersionsText = ((IterableOnceOps)clientTlsVersions.map((Function1 & Serializable)x$2 -> x$2.version().replace(".", ""))).mkString("and");
        this.testGivenAllParticipants(new StringBuilder(0).append(this.shortIdentifierPrefix).append(clientTlsVersionsText).toString(), new StringBuilder(41).append("A ledger API server should ").append(what2).append(" a ").append(clientTlsVersions).append(" connection").toString(), Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.testGivenAllParticipants$default$4(), this.testGivenAllParticipants$default$5(), this.testGivenAllParticipants$default$6(), this.testGivenAllParticipants$default$7(), this.testGivenAllParticipants$default$8(), this.testGivenAllParticipants$default$9(), (Function1 & Serializable)ec -> (Function1 & Serializable)testContexts -> new Serializable(this, (Seq)testContexts, (Seq)clientTlsVersions, (ExecutionContext)ec, assertionOnServerResponse2){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TlsIT $outer;
            private final Seq testContexts$1;
            private final Seq clientTlsVersions$1;
            private final ExecutionContext ec$1;
            private final Function1 assertionOnServerResponse$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Predef$.MODULE$.assume(this.testContexts$1.nonEmpty(), (Function0 & Serializable)() -> "Missing an expected participant test context!");
                ParticipantTestContext firstTextContext = (ParticipantTestContext)this.testContexts$1.head();
                Predef$.MODULE$.assume(this.$outer.com$daml$ledger$api$testtool$suites$v1_8$TlsIT$$clientTlsConfiguration.isDefined(), (Function0 & Serializable)() -> "Missing required TLS configuration!");
                TlsConfiguration tlsConfiguration = (TlsConfiguration)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$TlsIT$$clientTlsConfiguration.get();
                Predef$.MODULE$.assume(tlsConfiguration.enabled(), (Function0 & Serializable)() -> "TLS configuration is disabled but expected to be enabled!");
                Predef$.MODULE$.assume(firstTextContext.ledgerEndpoint() instanceof Endpoint.Remote, (Function0 & Serializable)() -> "Expected a remote (i.e. with a hostname and port) ledger endpoint!");
                Endpoint.Remote remote = (Endpoint.Remote)firstTextContext.ledgerEndpoint();
                if (remote == null) {
                    throw new MatchError((Object)remote);
                }
                String ledgerHostname = remote.hostname();
                int ledgerPort = remote.port();
                Tuple2 tuple2 = new Tuple2((Object)ledgerHostname, (Object)BoxesRunTime.boxToInteger((int)ledgerPort));
                String ledgerHostname2 = (String)tuple2._1();
                int ledgerPort2 = tuple2._2$mcI$sp();
                SslContext sslContext = (SslContext)tlsConfiguration.client(this.clientTlsVersions$1).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException("Missing SslContext!");
                });
                AbstractResourceOwner serviceStubOwner = ResourceOwner$.MODULE$.forChannel((ManagedChannelBuilder)NettyChannelBuilder.forAddress((String)ledgerHostname2, (int)ledgerPort2).useTransportSecurity().sslContext(sslContext), new package.DurationInt(package$.MODULE$.DurationInt(2)).seconds()).map((Function1 & Serializable)channel -> LedgerIdentityServiceGrpc$.MODULE$.blockingStub(channel));
                Future response = serviceStubOwner.use((Function1 & Serializable)identityService -> {
                    GetLedgerIdentityResponse response = identityService.getLedgerIdentity(new GetLedgerIdentityRequest());
                    return Future$.MODULE$.successful((Object)response.ledgerId());
                }, (Object)new ResourceContext(this.ec$1));
                return (B1)response.transform(this.assertionOnServerResponse$1, this.ec$1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participants participants = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.testContexts$1 = testContexts$1;
                this.clientTlsVersions$1 = clientTlsVersions$1;
                this.ec$1 = ec$1;
                this.assertionOnServerResponse$1 = assertionOnServerResponse$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3(), $anonfun$applyOrElse$4(), $anonfun$applyOrElse$5(), $anonfun$applyOrElse$6(io.grpc.Channel ), $anonfun$applyOrElse$7(com.daml.ledger.api.v1.ledger_identity_service.LedgerIdentityServiceGrpc$LedgerIdentityServiceBlockingStub )}, serializedLambda);
            }
        });
    }

    private Function1<Try<String>, Try<BoxedUnit>> assertSuccessfulConnection$lzycompute() {
        TlsIT tlsIT = this;
        synchronized (tlsIT) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.assertSuccessfulConnection = (Function1 & Serializable)x0$1 -> {
                    Try try_ = x0$1;
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        String ledgerId = (String)success.value();
                        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.assert(ledgerId != null, (Function0 & Serializable)() -> "Expected a not null ledger id!"));
                    }
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new AssertionError("Failed to receive a successful server response!", exception);
                    }
                    throw new MatchError((Object)try_);
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.assertSuccessfulConnection;
    }

    private Function1<Try<String>, Try<BoxedUnit>> assertSuccessfulConnection() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.assertSuccessfulConnection$lzycompute();
        }
        return this.assertSuccessfulConnection;
    }

    private Function1<Try<String>, Try<BoxedUnit>> assertFailedConnection$lzycompute() {
        TlsIT tlsIT = this;
        synchronized (tlsIT) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.assertFailedConnection = (Function1 & Serializable)x0$1 -> {
                    boolean bl = false;
                    Failure failure = null;
                    Try try_ = x0$1;
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        String ledgerId = (String)success.value();
                        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.assert(false, (Function0 & Serializable)() -> new StringBuilder(77).append("Connection succeeded and returned ledgerId: ").append(ledgerId).append(" but expected connection failure!").toString()));
                    }
                    if (try_ instanceof Failure) {
                        bl = true;
                        failure = (Failure)try_;
                        if (failure.exception() instanceof StatusRuntimeException) {
                            return new Success((Object)BoxedUnit.UNIT);
                        }
                    }
                    if (bl) {
                        Throwable other = failure.exception();
                        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.assert(false, (Function0 & Serializable)() -> new StringBuilder(20).append("Unexpected failure: ").append(other).toString()));
                    }
                    throw new MatchError((Object)try_);
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.assertFailedConnection;
    }

    private Function1<Try<String>, Try<BoxedUnit>> assertFailedConnection() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.assertFailedConnection$lzycompute();
        }
        return this.assertFailedConnection;
    }

    public TlsIT(String shortIdentifierPrefix, Option<TlsConfiguration> clientTlsConfiguration) {
        this.shortIdentifierPrefix = shortIdentifierPrefix;
        this.com$daml$ledger$api$testtool$suites$v1_8$TlsIT$$clientTlsConfiguration = clientTlsConfiguration;
    }
}

