/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.IndexErrors;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.error.definitions.groups.UserManagementServiceErrorGroup;
import com.daml.error.utils.ErrorDetails$;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.FutureAssertions;
import com.daml.ledger.api.testtool.infrastructure.participant.Features;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$;
import com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceITBase;
import com.daml.ledger.api.v1.admin.identity_provider_config_service.CreateIdentityProviderConfigResponse;
import com.daml.ledger.api.v1.admin.object_meta.ObjectMeta;
import com.daml.ledger.api.v1.admin.object_meta.ObjectMeta$;
import com.daml.ledger.api.v1.admin.user_management_service.CreateUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.DeleteUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.DeleteUserRequest$;
import com.daml.ledger.api.v1.admin.user_management_service.DeleteUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.GetUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.GetUserRequest$;
import com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.GrantUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.GrantUserRightsRequest$;
import com.daml.ledger.api.v1.admin.user_management_service.GrantUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsRequest$;
import com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.ListUsersRequest;
import com.daml.ledger.api.v1.admin.user_management_service.ListUsersRequest$;
import com.daml.ledger.api.v1.admin.user_management_service.ListUsersResponse;
import com.daml.ledger.api.v1.admin.user_management_service.RevokeUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.RevokeUserRightsRequest$;
import com.daml.ledger.api.v1.admin.user_management_service.RevokeUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.Right;
import com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderRequest;
import com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse;
import com.daml.ledger.api.v1.admin.user_management_service.User;
import com.daml.ledger.api.v1.admin.user_management_service.User$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scalaz.Tag$;

@ScalaSignature(bytes="\u0006\u0005\tEb\u0001\u0002\u0017.\u0005qBQ!\u0011\u0001\u0005\u0002\tCq\u0001\u0012\u0001C\u0002\u0013%Q\t\u0003\u0004Q\u0001\u0001\u0006IA\u0012\u0005\u0006#\u0002!IA\u0015\u0005\u0006E\u0002!Ia\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019q\u0007\u0001)A\u0005O\")q\u000e\u0001C\u0005a\"9\u0011q \u0001\u0005\u0002\t\u0005q!B?.\u0011\u0003qh!\u0002\u0017.\u0011\u0003y\bBB!\f\t\u0003\tIA\u0002\u0004\u0002\f-\u0001\u0015Q\u0002\u0005\u000b\u0003Oi!Q3A\u0005\u0002\u0005%\u0002\"CA\u0016\u001b\tE\t\u0015!\u0003V\u0011)\ti#\u0004BK\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0003_i!\u0011#Q\u0001\nUC!\"!\r\u000e\u0005+\u0007I\u0011AA\u0015\u0011%\t\u0019$\u0004B\tB\u0003%Q\u000b\u0003\u0006\u000265\u0011)\u001a!C\u0001\u0003SA\u0011\"a\u000e\u000e\u0005#\u0005\u000b\u0011B+\t\r\u0005kA\u0011AA\u001d\u0011%\t9%DA\u0001\n\u0003\tI\u0005C\u0005\u0002T5\t\n\u0011\"\u0001\u0002V!I\u00111N\u0007\u0012\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003[j\u0011\u0013!C\u0001\u0003+B\u0011\"a\u001c\u000e#\u0003%\t!!\u0016\t\u0011\u0005ET\"!A\u0005B\u0019D\u0011\"a\u001d\u000e\u0003\u0003%\t!!\u001e\t\u0013\u0005uT\"!A\u0005\u0002\u0005}\u0004\"CAF\u001b\u0005\u0005I\u0011IAG\u0011%\t9*DA\u0001\n\u0003\tI\nC\u0005\u0002$6\t\t\u0011\"\u0011\u0002&\"I\u0011\u0011V\u0007\u0002\u0002\u0013\u0005\u00131\u0016\u0005\n\u0003[k\u0011\u0011!C!\u0003_C\u0011\"!-\u000e\u0003\u0003%\t%a-\b\u0013\u0005]6\"!A\t\u0002\u0005ef!CA\u0006\u0017\u0005\u0005\t\u0012AA^\u0011\u0019\te\u0005\"\u0001\u0002T\"I\u0011Q\u0016\u0014\u0002\u0002\u0013\u0015\u0013q\u0016\u0005\n\u0003+4\u0013\u0011!CA\u0003/D\u0011\"!9'\u0003\u0003%\t)a9\t\u0013\u0005Uh%!A\u0005\n\u0005](aF+tKJl\u0015M\\1hK6,g\u000e^*feZL7-Z%U\u0015\tqs&\u0001\u0003wc}C$B\u0001\u00192\u0003\u0019\u0019X/\u001b;fg*\u0011!gM\u0001\ti\u0016\u001cH\u000f^8pY*\u0011A'N\u0001\u0004CBL'B\u0001\u001c8\u0003\u0019aW\rZ4fe*\u0011\u0001(O\u0001\u0005I\u0006lGNC\u0001;\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\b\u0005\u0002?\u007f5\tQ&\u0003\u0002A[\tYRk]3s\u001b\u0006t\u0017mZ3nK:$8+\u001a:wS\u000e,\u0017\n\u0016\"bg\u0016\fa\u0001P5oSRtD#A\"\u0011\u0005y\u0002\u0011aD1e[&t\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0016\u0003\u0019\u0003\"a\u0012(\u000e\u0003!S!!\u0013&\u0002/U\u001cXM]0nC:\fw-Z7f]R|6/\u001a:wS\u000e,'BA&M\u0003\u0015\tG-\\5o\u0015\ti5'\u0001\u0002wc%\u0011q\n\u0013\u0002\u0006%&<\u0007\u000e^\u0001\u0011C\u0012l\u0017N\u001c)fe6L7o]5p]\u0002\nq\"Y2u\u0003N\u0004VM]7jgNLwN\u001c\u000b\u0003\rNCQ\u0001\u0016\u0003A\u0002U\u000bQ\u0001]1sif\u0004\"AV0\u000f\u0005]k\u0006C\u0001-\\\u001b\u0005I&B\u0001.<\u0003\u0019a$o\\8u})\tA,A\u0003tG\u0006d\u0017-\u0003\u0002_7\u00061\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tq6,\u0001\tsK\u0006$\u0017i\u001d)fe6L7o]5p]R\u0011a\t\u001a\u0005\u0006)\u0016\u0001\r!V\u0001\f\u0003\u0012l\u0017N\\+tKJLE-F\u0001h!\tAW.D\u0001j\u0015\tQ7.\u0001\u0003mC:<'\"\u00017\u0002\t)\fg/Y\u0005\u0003A&\fA\"\u00113nS:,6/\u001a:JI\u0002\nQbZ3u+N,'OU5hQR\u001cHCA9z!\r\u0011xOR\u0007\u0002g*\u0011A/^\u0001\nS6lW\u000f^1cY\u0016T!A^.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002yg\n!A*[:u\u0011\u0015Q\b\u00021\u0001|\u0003\u001d\u0001\u0018M\u001d;jKN\u0004\"\u0001`\u0007\u000f\u0005yR\u0011aF+tKJl\u0015M\\1hK6,g\u000e^*feZL7-Z%U!\tq4bE\u0002\f\u0003\u0003\u0001B!a\u0001\u0002\u00065\t1,C\u0002\u0002\bm\u0013a!\u00118z%\u00164G#\u0001@\u0003\u000fA\u000b'\u000f^5fgN9Q\"!\u0001\u0002\u0010\u0005U\u0001\u0003BA\u0002\u0003#I1!a\u0005\\\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0006\u0002\"9!\u0011\u0011DA\u000f\u001d\rA\u00161D\u0005\u00029&\u0019\u0011qD.\u0002\u000fA\f7m[1hK&!\u00111EA\u0013\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\tybW\u0001\bC\u000e$\u0018N\\42+\u0005)\u0016\u0001C1di&tw-\r\u0011\u0002\u000f\u0005\u001cG/\u001b8he\u0005A\u0011m\u0019;j]\u001e\u0014\u0004%\u0001\u0005sK\u0006$\u0017N\\42\u0003%\u0011X-\u00193j]\u001e\f\u0004%\u0001\u0005sK\u0006$\u0017N\\43\u0003%\u0011X-\u00193j]\u001e\u0014\u0004\u0005\u0006\u0006\u0002<\u0005}\u0012\u0011IA\"\u0003\u000b\u00022!!\u0010\u000e\u001b\u0005Y\u0001BBA\u0014-\u0001\u0007Q\u000b\u0003\u0004\u0002.Y\u0001\r!\u0016\u0005\u0007\u0003c1\u0002\u0019A+\t\r\u0005Ub\u00031\u0001V\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005m\u00121JA'\u0003\u001f\n\t\u0006\u0003\u0005\u0002(]\u0001\n\u00111\u0001V\u0011!\tic\u0006I\u0001\u0002\u0004)\u0006\u0002CA\u0019/A\u0005\t\u0019A+\t\u0011\u0005Ur\u0003%AA\u0002U\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002X)\u001aQ+!\u0017,\u0005\u0005m\u0003\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001a\\\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\nyFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001e\u0011\t\u0005\r\u0011\u0011P\u0005\u0004\u0003wZ&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAA\u0003\u000f\u0003B!a\u0001\u0002\u0004&\u0019\u0011QQ.\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\nz\t\t\u00111\u0001\u0002x\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a$\u0011\r\u0005E\u00151SAA\u001b\u0005)\u0018bAAKk\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY*!)\u0011\t\u0005\r\u0011QT\u0005\u0004\u0003?[&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0013\u0003\u0013\u0011!a\u0001\u0003\u0003\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019q-a*\t\u0013\u0005%\u0015%!AA\u0002\u0005]\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005]\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u001d\fa!Z9vC2\u001cH\u0003BAN\u0003kC\u0011\"!#%\u0003\u0003\u0005\r!!!\u0002\u000fA\u000b'\u000f^5fgB\u0019\u0011Q\b\u0014\u0014\u000b\u0019\ni,!3\u0011\u0015\u0005}\u0016QY+V+V\u000bY$\u0004\u0002\u0002B*\u0019\u00111Y.\u0002\u000fI,h\u000e^5nK&!\u0011qYAa\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*\u0019\u0011qZ6\u0002\u0005%|\u0017\u0002BA\u0012\u0003\u001b$\"!!/\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u0005m\u0012\u0011\\An\u0003;\fy\u000e\u0003\u0004\u0002(%\u0002\r!\u0016\u0005\u0007\u0003[I\u0003\u0019A+\t\r\u0005E\u0012\u00061\u0001V\u0011\u0019\t)$\u000ba\u0001+\u00069QO\\1qa2LH\u0003BAs\u0003c\u0004b!a\u0001\u0002h\u0006-\u0018bAAu7\n1q\n\u001d;j_:\u0004\u0002\"a\u0001\u0002nV+V+V\u0005\u0004\u0003_\\&A\u0002+va2,G\u0007C\u0005\u0002t*\n\t\u00111\u0001\u0002<\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005e\bc\u00015\u0002|&\u0019\u0011Q`5\u0003\r=\u0013'.Z2u\u0003=\tG\u000e\\8dCR,\u0007+\u0019:uS\u0016\u001cHC\u0002B\u0002\u00057\u0011i\u0003\u0006\u0003\u0003\u0006\tE\u0001#\u0002B\u0004\u0005\u001bYXB\u0001B\u0005\u0015\r\u0011YaW\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B\b\u0005\u0013\u0011aAR;ukJ,\u0007b\u0002B\n\u0013\u0001\u000f!QC\u0001\u0003K\u000e\u0004BAa\u0002\u0003\u0018%!!\u0011\u0004B\u0005\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u00047\u0013\u0001\u0007!Q\u0004\t\u0005\u0005?\u0011I#\u0004\u0002\u0003\")!!1\u0005B\u0013\u0003-\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;\u000b\u0007\t\u001d\u0012'\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\t\t-\"\u0011\u0005\u0002\u0017!\u0006\u0014H/[2ja\u0006tG\u000fV3ti\u000e{g\u000e^3yi\"1!qF\u0005A\u0002U\u000baa];gM&D\b")
public final class UserManagementServiceIT
extends UserManagementServiceITBase {
    private final Right adminPermission = new Right((Right.Kind)new Right.Kind$.ParticipantAdmin(new Right.ParticipantAdmin()));
    private final String AdminUserId;

    private Right adminPermission() {
        return this.adminPermission;
    }

    private Right actAsPermission(String party) {
        return new Right((Right.Kind)new Right.Kind$.CanActAs(new Right.CanActAs(party)));
    }

    private Right readAsPermission(String party) {
        return new Right((Right.Kind)new Right.Kind$.CanReadAs(new Right.CanReadAs(party)));
    }

    private String AdminUserId() {
        return this.AdminUserId;
    }

    private List<Right> getUserRights(Parties parties) {
        return new .colon.colon((Object)this.actAsPermission(parties.acting1()), (List)new .colon.colon((Object)this.actAsPermission(parties.acting2()), (List)new .colon.colon((Object)this.readAsPermission(parties.reading1()), (List)new .colon.colon((Object)this.readAsPermission(parties.reading2()), (List)Nil$.MODULE$))));
    }

    public Future<Parties> allocateParties(ParticipantTestContext ledger, String suffix, ExecutionContext ec) {
        return ledger.allocateParty((Option)new Some((Object)new StringBuilder(15).append("acting-party-1-").append(suffix).toString()), ledger.allocateParty$default$2(), ledger.allocateParty$default$3(), ledger.allocateParty$default$4()).flatMap((Function1 & Serializable)acting1 -> ledger.allocateParty((Option)new Some((Object)new StringBuilder(15).append("acting-party-2-").append(suffix).toString()), ledger.allocateParty$default$2(), ledger.allocateParty$default$3(), ledger.allocateParty$default$4()).flatMap((Function1 & Serializable)acting2 -> ledger.allocateParty((Option)new Some((Object)new StringBuilder(16).append("reading-party-1-").append(suffix).toString()), ledger.allocateParty$default$2(), ledger.allocateParty$default$3(), ledger.allocateParty$default$4()).flatMap((Function1 & Serializable)reading1 -> ledger.allocateParty((Option)new Some((Object)new StringBuilder(16).append("reading-party-2-").append(suffix).toString()), ledger.allocateParty$default$2(), ledger.allocateParty$default$3(), ledger.allocateParty$default$4()).map((Function1 & Serializable)reading2 -> new Parties((String)Tag$.MODULE$.unwrap(acting1), (String)Tag$.MODULE$.unwrap(acting2), (String)Tag$.MODULE$.unwrap(reading1), (String)Tag$.MODULE$.unwrap(reading2)), ec), ec), ec), ec);
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Features x$1) {
        return x$1.userManagement().supported();
    }

    public static final /* synthetic */ boolean $anonfun$new$3(Features x$8) {
        return x$8.userManagement().supported();
    }

    public static final /* synthetic */ boolean $anonfun$new$5(Features x$13) {
        return x$13.userManagement().supported();
    }

    public static final /* synthetic */ boolean $anonfun$new$7(Features x$17) {
        return x$17.userManagement().supported();
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Features x$24) {
        return x$24.userManagement().supported();
    }

    public static final /* synthetic */ boolean $anonfun$new$11(Features features) {
        return features.userManagement().maxRightsPerUser() > 0 && features.userManagement().maxRightsPerUser() <= 100;
    }

    public static final /* synthetic */ boolean $anonfun$new$13(Features x$32) {
        return x$32.userManagement().supported();
    }

    public static final /* synthetic */ boolean $anonfun$new$15(Features x$38) {
        return x$38.userManagement().supported();
    }

    public static final /* synthetic */ Future $anonfun$new$19(ParticipantTestContext participant$1, CreateUserRequest request$1, ExecutionContext ec$9, int x$41) {
        return participant$1.createUser(request$1).transform((Function1 & Serializable)x$42 -> new Success(x$42), ec$9);
    }

    public static final /* synthetic */ void $anonfun$new$21(Vector results) {
        Assertions$.MODULE$.assertSingleton("successful user creation", (Seq)results.filter((Function1 & Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)x$43.isSuccess())));
        Vector unexpectedErrors = (Vector)results.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Try<CreateUserResponse>, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Failure failure;
                Throwable t;
                A1 A1 = x9;
                if (A1 instanceof Failure && !ErrorDetails$.MODULE$.matchesOneOf(t = (failure = (Failure)A1).exception(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ErrorCode[]{IndexErrors.DatabaseErrors$.SqlTransientError$.MODULE$, UserManagementServiceErrorGroup.UserAlreadyExists$.MODULE$})) && !ErrorDetails$.MODULE$.isInternalError(t)) {
                    return (B1)t;
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Try<CreateUserResponse> x9) {
                Failure failure;
                Throwable t;
                Try<CreateUserResponse> try_ = x9;
                return try_ instanceof Failure && !ErrorDetails$.MODULE$.matchesOneOf(t = (failure = (Failure)try_).exception(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ErrorCode[]{IndexErrors.DatabaseErrors$.SqlTransientError$.MODULE$, UserManagementServiceErrorGroup.UserAlreadyExists$.MODULE$})) && !ErrorDetails$.MODULE$.isInternalError(t);
            }
        });
        Assertions$.MODULE$.assertIsEmpty((Iterable)unexpectedErrors);
    }

    public static final /* synthetic */ Future $anonfun$new$26(ParticipantTestContext participant$2, DeleteUserRequest deleteUserRequest$1, ExecutionContext ec$10, int x$44) {
        return participant$2.deleteUser(deleteUserRequest$1).transform((Function1 & Serializable)x$45 -> new Success(x$45), ec$10);
    }

    public static final /* synthetic */ void $anonfun$new$28(Vector results) {
        Assertions$.MODULE$.assertSingleton("successful user deletion", (Seq)results.filter((Function1 & Serializable)x$46 -> BoxesRunTime.boxToBoolean((boolean)x$46.isSuccess())));
        Vector unexpectedErrors = (Vector)results.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Try<DeleteUserResponse>, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Failure failure;
                Throwable t;
                A1 A1 = x10;
                if (A1 instanceof Failure && !ErrorDetails$.MODULE$.matchesOneOf(t = (failure = (Failure)A1).exception(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ErrorCode[]{IndexErrors.DatabaseErrors$.SqlTransientError$.MODULE$, UserManagementServiceErrorGroup.UserNotFound$.MODULE$})) && !ErrorDetails$.MODULE$.isInternalError(t)) {
                    return (B1)t;
                }
                return (B1)function1.apply(x10);
            }

            public final boolean isDefinedAt(Try<DeleteUserResponse> x10) {
                Failure failure;
                Throwable t;
                Try<DeleteUserResponse> try_ = x10;
                return try_ instanceof Failure && !ErrorDetails$.MODULE$.matchesOneOf(t = (failure = (Failure)try_).exception(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ErrorCode[]{IndexErrors.DatabaseErrors$.SqlTransientError$.MODULE$, UserManagementServiceErrorGroup.UserNotFound$.MODULE$})) && !ErrorDetails$.MODULE$.isInternalError(t);
            }
        });
        Assertions$.MODULE$.assertIsEmpty((Iterable)unexpectedErrors);
    }

    public static final /* synthetic */ Future $anonfun$new$35(ParticipantTestContext participant$3, GrantUserRightsRequest grantRightsRequest$1, ExecutionContext ec$11, int x$48) {
        return participant$3.userManagement().grantUserRights(grantRightsRequest$1).transform((Function1 & Serializable)x$49 -> new Success(x$49), ec$11);
    }

    public static final /* synthetic */ void $anonfun$new$37(List userRights$1, Vector results) {
        Vector successes = (Vector)results.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Try<GrantUserRightsResponse>, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Seq newlyGrantedRights;
                Success success;
                GrantUserRightsResponse resp;
                A1 A1 = x11;
                if (A1 instanceof Success && (resp = (GrantUserRightsResponse)(success = (Success)A1).value()) != null && (newlyGrantedRights = resp.newlyGrantedRights()).nonEmpty()) {
                    return (B1)resp;
                }
                return (B1)function1.apply(x11);
            }

            public final boolean isDefinedAt(Try<GrantUserRightsResponse> x11) {
                Seq newlyGrantedRights;
                Success success;
                GrantUserRightsResponse resp;
                Try<GrantUserRightsResponse> try_ = x11;
                return try_ instanceof Success && (resp = (GrantUserRightsResponse)(success = (Success)try_).value()) != null && (newlyGrantedRights = resp.newlyGrantedRights()).nonEmpty();
            }
        });
        Assertions$.MODULE$.assertSingleton("Success response", (Seq)successes);
        Assertions$.MODULE$.assertSameElements((Iterable)((GrantUserRightsResponse)successes.head()).newlyGrantedRights(), (Iterable)userRights$1);
        Vector unexpectedErrors = (Vector)results.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Try<GrantUserRightsResponse>, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                Failure failure;
                Throwable t;
                A1 A1 = x12;
                if (A1 instanceof Failure && !ErrorDetails$.MODULE$.matches(t = (failure = (Failure)A1).exception(), (ErrorCode)IndexErrors.DatabaseErrors$.SqlTransientError$.MODULE$) && !ErrorDetails$.MODULE$.isInternalError(t)) {
                    return (B1)t;
                }
                return (B1)function1.apply(x12);
            }

            public final boolean isDefinedAt(Try<GrantUserRightsResponse> x12) {
                Failure failure;
                Throwable t;
                Try<GrantUserRightsResponse> try_ = x12;
                return try_ instanceof Failure && !ErrorDetails$.MODULE$.matches(t = (failure = (Failure)try_).exception(), (ErrorCode)IndexErrors.DatabaseErrors$.SqlTransientError$.MODULE$) && !ErrorDetails$.MODULE$.isInternalError(t);
            }
        });
        Assertions$.MODULE$.assertIsEmpty((Iterable)unexpectedErrors);
    }

    public static final /* synthetic */ Future $anonfun$new$44(ParticipantTestContext participant$4, RevokeUserRightsRequest revokeRightsRequest$1, ExecutionContext ec$12, int x$52) {
        return participant$4.userManagement().revokeUserRights(revokeRightsRequest$1).transform((Function1 & Serializable)x$53 -> new Success(x$53), ec$12);
    }

    public static final /* synthetic */ void $anonfun$new$46(Vector results) {
        Assertions$.MODULE$.assertSingleton("Non empty revoke-rights responses", (Seq)results.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Try<RevokeUserRightsResponse>, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                Seq actuallyRevoked;
                Success success;
                RevokeUserRightsResponse revokeUserRightsResponse;
                A1 A1 = x13;
                if (A1 instanceof Success && (revokeUserRightsResponse = (RevokeUserRightsResponse)(success = (Success)A1).value()) != null && (actuallyRevoked = revokeUserRightsResponse.newlyRevokedRights()).nonEmpty()) {
                    return (B1)actuallyRevoked;
                }
                return (B1)function1.apply(x13);
            }

            public final boolean isDefinedAt(Try<RevokeUserRightsResponse> x13) {
                Seq actuallyRevoked;
                Success success;
                RevokeUserRightsResponse revokeUserRightsResponse;
                Try<RevokeUserRightsResponse> try_ = x13;
                return try_ instanceof Success && (revokeUserRightsResponse = (RevokeUserRightsResponse)(success = (Success)try_).value()) != null && (actuallyRevoked = revokeUserRightsResponse.newlyRevokedRights()).nonEmpty();
            }
        }));
        Assertions$.MODULE$.assertIsEmpty((Iterable)results.filter((Function1 & Serializable)x$54 -> BoxesRunTime.boxToBoolean((boolean)x$54.isFailure())));
    }

    public static final /* synthetic */ void $anonfun$new$51(UserManagementServiceIT $this, GetUserResponse get1$4, boolean useMeta$1, ListUserRightsResponse rights1) {
        String x$81 = $this.AdminUserId();
        Option x$82 = Option$.MODULE$.when(useMeta$1, (Function0 & Serializable)() -> new ObjectMeta(get1$4.getUser().getMetadata().resourceVersion(), ObjectMeta$.MODULE$.apply$default$2()));
        String x$83 = User$.MODULE$.apply$default$2();
        boolean x$84 = User$.MODULE$.apply$default$3();
        String x$85 = User$.MODULE$.apply$default$5();
        Assertions$.MODULE$.assertEquals((Object)get1$4.user(), (Object)new Some((Object)new User(x$81, x$83, x$84, x$82, x$85)));
        Assertions$.MODULE$.assertEquals((Object)rights1, (Object)new ListUserRightsResponse((Seq)new .colon.colon((Object)$this.adminPermission(), (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$new$58(UserManagementServiceIT $this, CreateUserResponse res1$1, User user1$2, Throwable res2$1, CreateUserResponse res3$1, User user2$2, ParticipantTestContext ledger$10, DeleteUserResponse res4) {
        Assertions$.MODULE$.assertEquals((Object)$this.unsetResourceVersion(res1$1), (Object)new CreateUserResponse((Option)new Some((Object)user1$2)));
        $this.assertUserAlreadyExists(res2$1);
        Assertions$.MODULE$.assertEquals((Object)$this.unsetResourceVersion(res3$1), (Object)new CreateUserResponse((Option)new Some((Object)user2$2)));
        Assertions$.MODULE$.assertEquals((Object)res4, (Object)new DeleteUserResponse());
        if (ledger$10.features().userAndPartyLocalMetadataExtensions()) {
            String resourceVersion1 = ((ObjectMeta)((User)res1$1.user().get()).metadata().get()).resourceVersion();
            Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(resourceVersion1)), (Function0 & Serializable)() -> "New user's resource version should be non empty");
            String resourceVersion2 = ((ObjectMeta)((User)res3$1.user().get()).metadata().get()).resourceVersion();
            Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(resourceVersion2)), (Function0 & Serializable)() -> "New user's resource version should be non empty");
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$68(UserManagementServiceIT $this, GetUserResponse res1$2, User user1$3, Throwable res2) {
        $this.assertUserNotFound(res2);
        GetUserResponse getUserResponse = $this.unsetResourceVersion(res1$2);
        GetUserResponse getUserResponse2 = new GetUserResponse((Option)new Some((Object)user1$3));
        Predef$.MODULE$.assert(!(getUserResponse != null ? !getUserResponse.equals(getUserResponse2) : getUserResponse2 != null));
    }

    public static final /* synthetic */ void $anonfun$new$73(UserManagementServiceIT $this, DeleteUserResponse res1$3, Throwable res2) {
        Assertions$.MODULE$.assertEquals((Object)res1$3, (Object)new DeleteUserResponse());
        $this.assertUserNotFound(res2);
    }

    private final void assertUserPresentIn$1(User user, ListUsersResponse list, String msg) {
        Predef$.MODULE$.assert(((SeqOps)list.users().map((Function1 & Serializable)t -> this.unsetResourceVersion(t))).contains((Object)user), (Function0 & Serializable)() -> msg);
    }

    private final void assertUserAbsentIn$1(User user, ListUsersResponse list, String msg) {
        Predef$.MODULE$.assert(!((SeqOps)list.users().map((Function1 & Serializable)t -> this.unsetResourceVersion(t))).contains((Object)user), (Function0 & Serializable)() -> msg);
    }

    public static final /* synthetic */ void $anonfun$new$89(Tuple2 x$64) {
        Tuple2 tuple2 = x$64;
        if (tuple2 != null) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$101(Tuple2 x$70) {
        Tuple2 tuple2 = x$70;
        if (tuple2 != null) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$105(Tuple2 x$78) {
        Tuple2 tuple2 = x$78;
        if (tuple2 != null) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Future fetchNextPage$1(String pageToken, int pagesFetched, ParticipantTestContext ledger$15, int pageSize$1, ExecutionContext ec$20) {
        int x$1 = pageSize$1;
        String x$2 = pageToken;
        String x$3 = ListUsersRequest$.MODULE$.apply$default$3();
        return ledger$15.userManagement().listUsers(new ListUsersRequest(x$2, x$1, x$3)).map((Function1 & Serializable)page -> {
            BoxedUnit boxedUnit;
            String string = page.nextPageToken();
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                if (pagesFetched > 10) {
                    throw Assertions$.MODULE$.fail(new StringBuilder(70).append("Could not reach the last page even after fetching ").append(pagesFetched + 1).append(" pages of size ").append(pageSize$1).append(" each").toString());
                }
                boxedUnit = UserManagementServiceIT.fetchNextPage$1(page.nextPageToken(), pagesFetched + 1, ledger$15, pageSize$1, ec$20);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$77 = boxedUnit;
            return new Tuple2(page, (Object)x$77);
        }, ec$20).map((Function1 & Serializable)x$78 -> {
            UserManagementServiceIT.$anonfun$new$105(x$78);
            return BoxedUnit.UNIT;
        }, ec$20);
    }

    public static final /* synthetic */ void $anonfun$new$109(Throwable onBadTokenError$1, Throwable onNegativePageSizeError) {
        Assertions$.MODULE$.assertGrpcError(onBadTokenError$1, (ErrorCode)RequestValidation.InvalidArgument$.MODULE$, (Option)None$.MODULE$, Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
        Assertions$.MODULE$.assertGrpcError(onNegativePageSizeError, (ErrorCode)RequestValidation.InvalidArgument$.MODULE$, (Option)None$.MODULE$, Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$115(ListUsersResponse pageSizeZero$1, ListUsersResponse pageSizeOne) {
        Predef$.MODULE$.assert(pageSizeOne.users().nonEmpty(), (Function0 & Serializable)() -> "First page with requested pageSize zero should return some users");
        Assertions$.MODULE$.assertEquals(pageSizeZero$1.users().head(), pageSizeOne.users().head());
    }

    public static final /* synthetic */ boolean $anonfun$new$117(Features x$81) {
        return x$81.userManagement().maxUsersPageSize() > 0;
    }

    public static final /* synthetic */ void $anonfun$new$137(UserManagementServiceIT $this, GrantUserRightsResponse res1$4, Throwable res2$2, GrantUserRightsResponse res3$2, GrantUserRightsResponse res4$1, List userRights$3, ParticipantTestContext ledger$21, CreateUserResponse userBefore$1, GetUserResponse userAfter) {
        Assertions$.MODULE$.assertSameElements((Iterable)res1$4.newlyGrantedRights(), (Iterable)new .colon.colon((Object)$this.adminPermission(), (List)Nil$.MODULE$));
        $this.assertUserNotFound(res2$2);
        Assertions$.MODULE$.assertSameElements((Iterable)res3$2.newlyGrantedRights(), (Iterable)package$.MODULE$.List().empty());
        Assertions$.MODULE$.assertSameElements((Iterable)res4$1.newlyGrantedRights().toSet(), (Iterable)userRights$3.toSet());
        if (ledger$21.features().userAndPartyLocalMetadataExtensions()) {
            String userResourceVersion1 = ((ObjectMeta)((User)userBefore$1.user().get()).metadata().get()).resourceVersion();
            String userResourceVersion2 = ((ObjectMeta)((User)userAfter.user().get()).metadata().get()).resourceVersion();
            Assertions$.MODULE$.assertEquals("changing user rights must not change user's resource version", (Object)userResourceVersion1, (Object)userResourceVersion2);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$147(UserManagementServiceIT $this, RevokeUserRightsResponse res1$5, Throwable res2$3, RevokeUserRightsResponse res3$3, RevokeUserRightsResponse res4$2, List userRights$4, ParticipantTestContext ledger$22, CreateUserResponse userBefore$2, GetUserResponse userAfter) {
        Assertions$.MODULE$.assertEquals((Object)res1$5, (Object)new RevokeUserRightsResponse((Seq)new .colon.colon((Object)$this.adminPermission(), (List)Nil$.MODULE$)));
        $this.assertUserNotFound(res2$3);
        Assertions$.MODULE$.assertSameElements((Iterable)res3$3.newlyRevokedRights(), (Iterable)package$.MODULE$.List().empty());
        Assertions$.MODULE$.assertSameElements((Iterable)res4$2.newlyRevokedRights().toSet(), (Iterable)userRights$4.toSet());
        if (ledger$22.features().userAndPartyLocalMetadataExtensions()) {
            String userResourceVersion1 = ((ObjectMeta)((User)userBefore$2.user().get()).metadata().get()).resourceVersion();
            String userResourceVersion2 = ((ObjectMeta)((User)userAfter.user().get()).metadata().get()).resourceVersion();
            Assertions$.MODULE$.assertEquals("changing user rights must not change user's resource version", (Object)userResourceVersion1, (Object)userResourceVersion2);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$156(UserManagementServiceIT $this, CreateUserResponse res1$6, User user1$6, ListUserRightsResponse res2$4, GrantUserRightsResponse res3$4, Parties parties$1, ListUserRightsResponse res4$3, RevokeUserRightsResponse res5$1, ListUserRightsResponse res6) {
        Assertions$.MODULE$.assertEquals((Object)$this.unsetResourceVersion(res1$6), (Object)new CreateUserResponse((Option)new Some((Object)user1$6)));
        Assertions$.MODULE$.assertEquals((Object)res2$4, (Object)new ListUserRightsResponse((Seq)package$.MODULE$.Seq().empty()));
        Assertions$.MODULE$.assertSameElements((Iterable)res3$4.newlyGrantedRights().toSet(), (Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Right[]{$this.adminPermission(), $this.actAsPermission(parties$1.acting1()), $this.readAsPermission(parties$1.reading1())})));
        Assertions$.MODULE$.assertSameElements((Iterable)res4$3.rights().toSet(), (Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Right[]{$this.adminPermission(), $this.actAsPermission(parties$1.acting1()), $this.readAsPermission(parties$1.reading1())})));
        Assertions$.MODULE$.assertSameElements((Iterable)res5$1.newlyRevokedRights(), (Iterable)new .colon.colon((Object)$this.adminPermission(), (List)Nil$.MODULE$));
        Assertions$.MODULE$.assertSameElements((Iterable)res6.rights().toSet(), (Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Right[]{$this.actAsPermission(parties$1.acting1()), $this.readAsPermission(parties$1.reading1())})));
    }

    public UserManagementServiceIT() {
        this.AdminUserId = "participant_admin";
        String x$12 = "UserManagementUpdateUserIdpWithNonDefaultIdps";
        String x$2 = "Test reassigning user to a different idp using non default idps";
        Allocation.PartyAllocation x$3 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$4 = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UserManagementServiceIT.$anonfun$new$1(x$1));
        String x$5 = "requires user management feature";
        double x$6 = this.test$default$4();
        boolean x$7 = this.test$default$5();
        int x$82 = this.test$default$6();
        List x$9 = this.test$default$9();
        Function1 & Serializable x$10 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    String userId1 = (String)ledger.nextUserId().apply();
                    String idpId1 = (String)ledger.nextIdentityProviderId().apply();
                    String idpId2 = (String)ledger.nextIdentityProviderId().apply();
                    return (B1)ledger.createIdentityProviderConfig(idpId1, ledger.createIdentityProviderConfig$default$2(), ledger.createIdentityProviderConfig$default$3(), ledger.createIdentityProviderConfig$default$4()).flatMap((Function1 & Serializable)x$7 -> {
                        CreateIdentityProviderConfigResponse createIdentityProviderConfigResponse = x$7;
                        return ledger.createIdentityProviderConfig(idpId2, ledger.createIdentityProviderConfig$default$2(), ledger.createIdentityProviderConfig$default$3(), ledger.createIdentityProviderConfig$default$4()).flatMap((Function1 & Serializable)x$6 -> {
                            CreateIdentityProviderConfigResponse createIdentityProviderConfigResponse = x$6;
                            String x$1 = userId1;
                            String x$2 = idpId1;
                            String x$3 = User$.MODULE$.apply$default$2();
                            boolean x$4 = User$.MODULE$.apply$default$3();
                            Option x$52 = User$.MODULE$.apply$default$4();
                            return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(x$1, x$3, x$4, x$52, x$2)), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$5 -> {
                                CreateUserResponse createUserResponse = x$5;
                                return ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userId1, idpId1, idpId2)).flatMap((Function1 & Serializable)x$4 -> {
                                    UpdateUserIdentityProviderResponse updateUserIdentityProviderResponse = x$4;
                                    return ledger.userManagement().getUser(new GetUserRequest(userId1, idpId2)).flatMap((Function1 & Serializable)get1 -> ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userId1, idpId2, idpId1)).flatMap((Function1 & Serializable)x$3 -> {
                                        UpdateUserIdentityProviderResponse updateUserIdentityProviderResponse = x$3;
                                        return ledger.userManagement().getUser(new GetUserRequest(userId1, idpId1)).flatMap((Function1 & Serializable)get2 -> Assertions$.MODULE$.futureAssertions(ledger.userManagement().getUser(new GetUserRequest(userId1, idpId2))).mustFail("requesting with wrong idp", $this.ec$1).flatMap((Function1 & Serializable)error -> ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userId1, idpId1, "")).map((Function1 & Serializable)x$2 -> {
                                            $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$9(get1, idpId2, get2, idpId1, error, x$2);
                                            return BoxedUnit.UNIT;
                                        }, $this.ec$1), $this.ec$1), $this.ec$1);
                                    }, $this.ec$1), $this.ec$1);
                                }, $this.ec$1);
                            }, $this.ec$1);
                        }, $this.ec$1);
                    }, this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$9(GetUserResponse get1$1, String idpId2$1, GetUserResponse get2$1, String idpId1$1, Throwable error$1, UpdateUserIdentityProviderResponse x$2) {
                UpdateUserIdentityProviderResponse updateUserIdentityProviderResponse = x$2;
                Assertions$.MODULE$.assertEquals((Object)((User)get1$1.user().get()).identityProviderId(), (Object)idpId2$1);
                Assertions$.MODULE$.assertEquals((Object)((User)get2$1.user().get()).identityProviderId(), (Object)idpId1$1);
                Predef$.MODULE$.assert(error$1.getMessage().startsWith("PERMISSION_DENIED"), (Function0 & Serializable)() -> new StringBuilder(16).append("Actual message: ").append(error$1.getMessage()).toString());
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.identity_provider_config_service.CreateIdentityProviderConfigResponse ), $anonfun$applyOrElse$10(java.lang.Throwable ), $anonfun$applyOrElse$2(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.identity_provider_config_service.CreateIdentityProviderConfigResponse ), $anonfun$applyOrElse$3(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse ), $anonfun$applyOrElse$4(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse ), $anonfun$applyOrElse$5(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse ), $anonfun$applyOrElse$7(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse ), $anonfun$applyOrElse$8(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse java.lang.Throwable ), $anonfun$applyOrElse$9$adapted(com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse java.lang.String java.lang.Throwable com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse )}, serializedLambda);
            }
        };
        this.test("UserManagementUpdateUserIdpWithNonDefaultIdps", "Test reassigning user to a different idp using non default idps", x$3, x$6, x$7, x$82, x$4, "requires user management feature", x$9, x$10);
        String x$11 = "UserManagementUpdateUserIdpWithDefaultIdp";
        String x$122 = "Test reassigning user to a different idp using the default idp";
        Allocation.PartyAllocation x$132 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$14 = (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)UserManagementServiceIT.$anonfun$new$3(x$8));
        String x$15 = "requires user management feature";
        double x$16 = this.test$default$4();
        boolean x$172 = this.test$default$5();
        int x$18 = this.test$default$6();
        List x$19 = this.test$default$9();
        Function1 & Serializable x$20 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    String userId1 = (String)ledger.nextUserId().apply();
                    String idpId = (String)ledger.nextIdentityProviderId().apply();
                    return (B1)ledger.createIdentityProviderConfig(idpId, ledger.createIdentityProviderConfig$default$2(), ledger.createIdentityProviderConfig$default$3(), ledger.createIdentityProviderConfig$default$4()).flatMap((Function1 & Serializable)x$12 -> {
                        CreateIdentityProviderConfigResponse createIdentityProviderConfigResponse = x$12;
                        String x$1 = userId1;
                        String x$2 = "";
                        String x$3 = User$.MODULE$.apply$default$2();
                        boolean x$4 = User$.MODULE$.apply$default$3();
                        Option x$5 = User$.MODULE$.apply$default$4();
                        return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(x$1, x$3, x$4, x$5, "")), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$11 -> {
                            CreateUserResponse createUserResponse = x$11;
                            return ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userId1, "", idpId)).flatMap((Function1 & Serializable)x$10 -> {
                                UpdateUserIdentityProviderResponse updateUserIdentityProviderResponse = x$10;
                                return ledger.userManagement().getUser(new GetUserRequest(userId1, idpId)).flatMap((Function1 & Serializable)get1 -> ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userId1, idpId, "")).flatMap((Function1 & Serializable)x$9 -> {
                                    UpdateUserIdentityProviderResponse updateUserIdentityProviderResponse = x$9;
                                    return ledger.userManagement().getUser(new GetUserRequest(userId1, "")).map((Function1 & Serializable)get2 -> {
                                        $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$16(get1, idpId, get2);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$2);
                                }, $this.ec$2), $this.ec$2);
                            }, $this.ec$2);
                        }, $this.ec$2);
                    }, this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$16(GetUserResponse get1$2, String idpId$1, GetUserResponse get2) {
                Assertions$.MODULE$.assertEquals((Object)((User)get1$2.user().get()).identityProviderId(), (Object)idpId$1);
                Assertions$.MODULE$.assertEquals((Object)((User)get2.user().get()).identityProviderId(), (Object)"");
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$11(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String com.daml.ledger.api.v1.admin.identity_provider_config_service.CreateIdentityProviderConfigResponse ), $anonfun$applyOrElse$12(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse ), $anonfun$applyOrElse$13(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse ), $anonfun$applyOrElse$14(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse ), $anonfun$applyOrElse$15(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse java.lang.String com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse ), $anonfun$applyOrElse$16$adapted(com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse )}, serializedLambda);
            }
        };
        this.test("UserManagementUpdateUserIdpWithDefaultIdp", "Test reassigning user to a different idp using the default idp", x$132, x$16, x$172, x$18, x$14, "requires user management feature", x$19, x$20);
        String x$21 = "UserManagementUpdateUserIdpNonExistentIdps";
        String x$22 = "Test reassigning user to a different idp when source or target idp doesn't exist";
        Allocation.PartyAllocation x$23 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$242 = (Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)UserManagementServiceIT.$anonfun$new$5(x$13));
        String x$25 = "requires user management feature";
        double x$26 = this.test$default$4();
        boolean x$27 = this.test$default$5();
        int x$28 = this.test$default$6();
        List x$29 = this.test$default$9();
        Function1 & Serializable x$30 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    String userId = (String)ledger.nextUserId().apply();
                    String idpNonExistent = (String)ledger.nextIdentityProviderId().apply();
                    String x$1 = userId;
                    String x$2 = "";
                    String x$3 = User$.MODULE$.apply$default$2();
                    boolean x$4 = User$.MODULE$.apply$default$3();
                    Option x$5 = User$.MODULE$.apply$default$4();
                    return (B1)ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(x$1, x$3, x$4, x$5, "")), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$16 -> {
                        CreateUserResponse createUserResponse = x$16;
                        FutureAssertions qual$1 = Assertions$.MODULE$.futureAssertions(ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userId, idpNonExistent, "")));
                        String x$6 = "non existent source idp";
                        RequestValidation.InvalidArgument$ x$7 = RequestValidation.InvalidArgument$.MODULE$;
                        Option x$8 = qual$1.mustFailWith$default$3();
                        return qual$1.mustFailWith("non existent source idp", (ErrorCode)x$7, x$8, $this.ec$3).flatMap((Function1 & Serializable)x$15 -> {
                            BoxedUnit boxedUnit = x$15;
                            FutureAssertions qual$2 = Assertions$.MODULE$.futureAssertions(ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userId, "", idpNonExistent)));
                            String x$9 = "non existent target idp";
                            RequestValidation.InvalidArgument$ x$10 = RequestValidation.InvalidArgument$.MODULE$;
                            Option x$11 = qual$2.mustFailWith$default$3();
                            return qual$2.mustFailWith("non existent target idp", (ErrorCode)x$10, x$11, $this.ec$3).map((Function1 & Serializable)x$14 -> {
                                $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$19(x$14);
                                return BoxedUnit.UNIT;
                            }, $this.ec$3);
                        }, $this.ec$3);
                    }, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$19(BoxedUnit x$14) {
                BoxedUnit boxedUnit = x$14;
            }
            {
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$17(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse ), $anonfun$applyOrElse$18(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String scala.runtime.BoxedUnit ), $anonfun$applyOrElse$19$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        this.test("UserManagementUpdateUserIdpNonExistentIdps", "Test reassigning user to a different idp when source or target idp doesn't exist", x$23, x$26, x$27, x$28, x$242, "requires user management feature", x$29, x$30);
        String x$31 = "UserManagementUpdateUserIdpMismatchedSourceIdp";
        String x$322 = "Test reassigning user to a different idp using mismatched source idp";
        Allocation.PartyAllocation x$33 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$34 = (Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)UserManagementServiceIT.$anonfun$new$7(x$17));
        String x$35 = "requires user management feature";
        double x$36 = this.test$default$4();
        boolean x$37 = this.test$default$5();
        int x$382 = this.test$default$6();
        List x$39 = this.test$default$9();
        Function1 & Serializable x$40 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    String userIdDefault = (String)ledger.nextUserId().apply();
                    String userIdNonDefault = (String)ledger.nextUserId().apply();
                    String idpIdNonDefault = (String)ledger.nextIdentityProviderId().apply();
                    String idpIdTarget = (String)ledger.nextIdentityProviderId().apply();
                    String idpIdMismatched = (String)ledger.nextIdentityProviderId().apply();
                    return (B1)ledger.createIdentityProviderConfig(idpIdMismatched, ledger.createIdentityProviderConfig$default$2(), ledger.createIdentityProviderConfig$default$3(), ledger.createIdentityProviderConfig$default$4()).flatMap((Function1 & Serializable)x$23 -> {
                        CreateIdentityProviderConfigResponse createIdentityProviderConfigResponse = x$23;
                        return ledger.createIdentityProviderConfig(idpIdNonDefault, ledger.createIdentityProviderConfig$default$2(), ledger.createIdentityProviderConfig$default$3(), ledger.createIdentityProviderConfig$default$4()).flatMap((Function1 & Serializable)x$22 -> {
                            CreateIdentityProviderConfigResponse createIdentityProviderConfigResponse = x$22;
                            return ledger.createIdentityProviderConfig(idpIdTarget, ledger.createIdentityProviderConfig$default$2(), ledger.createIdentityProviderConfig$default$3(), ledger.createIdentityProviderConfig$default$4()).flatMap((Function1 & Serializable)x$21 -> {
                                CreateIdentityProviderConfigResponse createIdentityProviderConfigResponse = x$21;
                                String x$1 = userIdDefault;
                                String x$2 = "";
                                String x$3 = User$.MODULE$.apply$default$2();
                                boolean x$4 = User$.MODULE$.apply$default$3();
                                Option x$5 = User$.MODULE$.apply$default$4();
                                return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(x$1, x$3, x$4, x$5, "")), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$20 -> {
                                    CreateUserResponse createUserResponse = x$20;
                                    String x$6 = userIdNonDefault;
                                    String x$7 = idpIdNonDefault;
                                    String x$8 = User$.MODULE$.apply$default$2();
                                    boolean x$9 = User$.MODULE$.apply$default$3();
                                    Option x$10 = User$.MODULE$.apply$default$4();
                                    return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(x$6, x$8, x$9, x$10, x$7)), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$19 -> {
                                        CreateUserResponse createUserResponse = x$19;
                                        return Assertions$.MODULE$.futureAssertions(ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userIdDefault, idpIdMismatched, idpIdTarget))).mustFail("mismatched source idp id", $this.ec$4).flatMap((Function1 & Serializable)error1 -> Assertions$.MODULE$.futureAssertions(ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userIdNonDefault, idpIdMismatched, idpIdTarget))).mustFail("mismatched source idp id", $this.ec$4).flatMap((Function1 & Serializable)error2 -> ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userIdNonDefault, idpIdNonDefault, "")).map((Function1 & Serializable)x$18 -> {
                                            $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$27(error1, error2, x$18);
                                            return BoxedUnit.UNIT;
                                        }, $this.ec$4), $this.ec$4), $this.ec$4);
                                    }, $this.ec$4);
                                }, $this.ec$4);
                            }, $this.ec$4);
                        }, $this.ec$4);
                    }, this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$27(Throwable error1$1, Throwable error2$1, UpdateUserIdentityProviderResponse x$18) {
                UpdateUserIdentityProviderResponse updateUserIdentityProviderResponse = x$18;
                Predef$.MODULE$.assert(error1$1.getMessage().startsWith("PERMISSION_DENIED"), (Function0 & Serializable)() -> new StringBuilder(16).append("Actual message: ").append(error1$1.getMessage()).toString());
                Predef$.MODULE$.assert(error2$1.getMessage().startsWith("PERMISSION_DENIED"), (Function0 & Serializable)() -> new StringBuilder(16).append("Actual message: ").append(error2$1.getMessage()).toString());
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$20(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.identity_provider_config_service.CreateIdentityProviderConfigResponse ), $anonfun$applyOrElse$21(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.identity_provider_config_service.CreateIdentityProviderConfigResponse ), $anonfun$applyOrElse$22(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.identity_provider_config_service.CreateIdentityProviderConfigResponse ), $anonfun$applyOrElse$23(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse ), $anonfun$applyOrElse$24(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse ), $anonfun$applyOrElse$25(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String java.lang.String java.lang.Throwable ), $anonfun$applyOrElse$26(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$27$adapted(java.lang.Throwable java.lang.Throwable com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse ), $anonfun$applyOrElse$28(java.lang.Throwable ), $anonfun$applyOrElse$29(java.lang.Throwable )}, serializedLambda);
            }
        };
        this.test("UserManagementUpdateUserIdpMismatchedSourceIdp", "Test reassigning user to a different idp using mismatched source idp", x$33, x$36, x$37, x$382, x$34, "requires user management feature", x$39, x$40);
        String x$41 = "UserManagementUpdateUserIdpSourceAndTargetIdpTheSame";
        String x$42 = "Test reassigning user to a different idp but source and target idps are the same";
        Allocation.PartyAllocation x$43 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$44 = (Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)UserManagementServiceIT.$anonfun$new$9(x$24));
        String x$45 = "requires user management feature";
        double x$46 = this.test$default$4();
        boolean x$47 = this.test$default$5();
        int x$48 = this.test$default$6();
        List x$49 = this.test$default$9();
        Function1 & Serializable x$50 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    String userIdDefault = (String)ledger.nextUserId().apply();
                    String userIdNonDefault = (String)ledger.nextUserId().apply();
                    String idpId1 = (String)ledger.nextIdentityProviderId().apply();
                    return (B1)ledger.createIdentityProviderConfig(idpId1, ledger.createIdentityProviderConfig$default$2(), ledger.createIdentityProviderConfig$default$3(), ledger.createIdentityProviderConfig$default$4()).flatMap((Function1 & Serializable)x$30 -> {
                        CreateIdentityProviderConfigResponse createIdentityProviderConfigResponse = x$30;
                        String x$1 = userIdDefault;
                        String x$2 = "";
                        String x$3 = User$.MODULE$.apply$default$2();
                        boolean x$4 = User$.MODULE$.apply$default$3();
                        Option x$5 = User$.MODULE$.apply$default$4();
                        return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(x$1, x$3, x$4, x$5, "")), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$29 -> {
                            CreateUserResponse createUserResponse = x$29;
                            String x$6 = userIdNonDefault;
                            String x$7 = idpId1;
                            String x$8 = User$.MODULE$.apply$default$2();
                            boolean x$9 = User$.MODULE$.apply$default$3();
                            Option x$10 = User$.MODULE$.apply$default$4();
                            return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(x$6, x$8, x$9, x$10, x$7)), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$28 -> {
                                CreateUserResponse createUserResponse = x$28;
                                return ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userIdDefault, "", "")).flatMap((Function1 & Serializable)x$27 -> {
                                    UpdateUserIdentityProviderResponse updateUserIdentityProviderResponse = x$27;
                                    return ledger.userManagement().getUser(new GetUserRequest(userIdDefault, "")).flatMap((Function1 & Serializable)get1 -> ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userIdNonDefault, idpId1, idpId1)).flatMap((Function1 & Serializable)x$26 -> {
                                        UpdateUserIdentityProviderResponse updateUserIdentityProviderResponse = x$26;
                                        return ledger.userManagement().getUser(new GetUserRequest(userIdNonDefault, idpId1)).flatMap((Function1 & Serializable)get2 -> ledger.userManagement().updateUserIdentityProviderId(new UpdateUserIdentityProviderRequest(userIdNonDefault, idpId1, "")).map((Function1 & Serializable)x$25 -> {
                                            $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$37(get1, get2, idpId1, x$25);
                                            return BoxedUnit.UNIT;
                                        }, $this.ec$5), $this.ec$5);
                                    }, $this.ec$5), $this.ec$5);
                                }, $this.ec$5);
                            }, $this.ec$5);
                        }, $this.ec$5);
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$37(GetUserResponse get1$3, GetUserResponse get2$2, String idpId1$2, UpdateUserIdentityProviderResponse x$25) {
                UpdateUserIdentityProviderResponse updateUserIdentityProviderResponse = x$25;
                Assertions$.MODULE$.assertEquals("default idp", (Object)((User)get1$3.user().get()).identityProviderId(), (Object)"");
                Assertions$.MODULE$.assertEquals("non default idp", (Object)((User)get2$2.user().get()).identityProviderId(), (Object)idpId1$2);
            }
            {
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$30(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.identity_provider_config_service.CreateIdentityProviderConfigResponse ), $anonfun$applyOrElse$31(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse ), $anonfun$applyOrElse$32(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse ), $anonfun$applyOrElse$33(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse ), $anonfun$applyOrElse$34(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse ), $anonfun$applyOrElse$35(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse ), $anonfun$applyOrElse$36(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse ), $anonfun$applyOrElse$37$adapted(com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse java.lang.String com.daml.ledger.api.v1.admin.user_management_service.UpdateUserIdentityProviderResponse )}, serializedLambda);
            }
        };
        this.test("UserManagementUpdateUserIdpSourceAndTargetIdpTheSame", "Test reassigning user to a different idp but source and target idps are the same", x$43, x$46, x$47, x$48, x$44, "requires user management feature", x$49, x$50);
        String x$51 = "UserManagementUserRightsLimit";
        String x$52 = "Test user rights per user limit";
        Allocation.PartyAllocation x$53 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$54 = (Function1 & Serializable)features -> BoxesRunTime.boxToBoolean((boolean)UserManagementServiceIT.$anonfun$new$11(features));
        String x$55 = "requires user management feature with user rights limit";
        double x$56 = this.test$default$4();
        boolean x$57 = this.test$default$5();
        int x$58 = this.test$default$6();
        List x$59 = this.test$default$9();
        Function1 & Serializable x$60 = (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ UserManagementServiceIT $outer;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    User user1 = this.$outer.newUser(UUID.randomUUID().toString(), this.$outer.newUser$default$2(), this.$outer.newUser$default$3(), this.$outer.newUser$default$4());
                    User user2 = this.$outer.newUser(UUID.randomUUID().toString(), this.$outer.newUser$default$2(), this.$outer.newUser$default$3(), this.$outer.newUser$default$4());
                    int maxRightsPerUser = ledger.features().userManagement().maxRightsPerUser();
                    IndexedSeq allocatePartiesMaxAndOne = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), maxRightsPerUser + 1).map((Function1 & Serializable)id -> $anonfun$$nestedInanonfun$new$12$1.$anonfun$applyOrElse$38(ledger, BoxesRunTime.unboxToInt((Object)id)));
                    return (B1)Future$.MODULE$.sequence((IterableOnce)allocatePartiesMaxAndOne, BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$6).map((Function1 & Serializable)allocatedParties -> {
                        IndexedSeq permissionsMaxPlusOne = (IndexedSeq)allocatedParties.map((Function1 & Serializable)party -> $anonfun$$nestedInanonfun$new$12$1.createCanActAs$1(party));
                        Right permissionOne = (Right)permissionsMaxPlusOne.head();
                        IndexedSeq permissionsMax = (IndexedSeq)permissionsMaxPlusOne.tail();
                        return new Tuple4(allocatedParties, (Object)permissionsMaxPlusOne, (Object)permissionOne, (Object)permissionsMax);
                    }, this.ec$6).flatMap((Function1 & Serializable)x$31 -> {
                        Tuple4 tuple4 = x$31;
                        if (tuple4 != null) {
                            IndexedSeq permissionsMaxPlusOne = (IndexedSeq)tuple4._2();
                            Right permissionOne = (Right)tuple4._3();
                            IndexedSeq permissionsMax = (IndexedSeq)tuple4._4();
                            return Assertions$.MODULE$.futureAssertions(ledger.createUser(new CreateUserRequest((Option)new Some((Object)user1), (Seq)permissionsMaxPlusOne))).mustFail("creating user with too many rights", $this.ec$6).flatMap((Function1 & Serializable)create1 -> ledger.createUser(new CreateUserRequest((Option)new Some((Object)user1), (Seq)permissionsMax)).flatMap((Function1 & Serializable)create2 -> Assertions$.MODULE$.futureAssertions(ledger.userManagement().grantUserRights(new GrantUserRightsRequest(user1.id(), (Seq)new .colon.colon((Object)permissionOne, (List)Nil$.MODULE$), GrantUserRightsRequest$.MODULE$.apply$default$3()))).mustFail("granting more rights exceeds max number of user rights per user", $this.ec$6).flatMap((Function1 & Serializable)grant1 -> ledger.userManagement().listUserRights(new ListUserRightsRequest(user1.id(), ListUserRightsRequest$.MODULE$.apply$default$2())).flatMap((Function1 & Serializable)rights1 -> ledger.createUser(new CreateUserRequest((Option)new Some((Object)user2), (Seq)permissionsMax)).map((Function1 & Serializable)create3 -> {
                                $anonfun$$nestedInanonfun$new$12$1.$anonfun$applyOrElse$46(this, create1, create2, user1, grant1, rights1, permissionsMaxPlusOne, user2, create3);
                                return BoxedUnit.UNIT;
                            }, $this.ec$6), $this.ec$6), $this.ec$6), $this.ec$6), $this.ec$6);
                        }
                        throw new MatchError((Object)tuple4);
                    }, this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            private static final void assertTooManyUserRightsError$1(Throwable t) {
                Assertions$.MODULE$.assertGrpcError(t, (ErrorCode)UserManagementServiceErrorGroup.TooManyUserRights$.MODULE$, (Option)None$.MODULE$, Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }

            private static final Right createCanActAs$1(Object party) {
                return new Right((Right.Kind)new Right.Kind$.CanActAs(new Right.CanActAs((String)Tag$.MODULE$.unwrap(party))));
            }

            private static final Future allocateParty$1(int id, ParticipantTestContext ledger$6) {
                return ledger$6.allocateParty((Option)new Some((Object)new StringBuilder(13).append("acting-party-").append(id).toString()), ledger$6.allocateParty$default$2(), ledger$6.allocateParty$default$3(), ledger$6.allocateParty$default$4());
            }

            public static final /* synthetic */ Future $anonfun$applyOrElse$38(ParticipantTestContext ledger$6, int id) {
                return $anonfun$$nestedInanonfun$new$12$1.allocateParty$1(id, ledger$6);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$46($anonfun$$nestedInanonfun$new$12$1 $this, Throwable create1$1, CreateUserResponse create2$1, User user1$1, Throwable grant1$1, ListUserRightsResponse rights1$1, IndexedSeq permissionsMaxPlusOne$1, User user2$1, CreateUserResponse create3) {
                $anonfun$$nestedInanonfun$new$12$1.assertTooManyUserRightsError$1(create1$1);
                Assertions$.MODULE$.assertEquals((Object)$this.$outer.unsetResourceVersion(create2$1), (Object)new CreateUserResponse((Option)new Some((Object)user1$1)));
                $anonfun$$nestedInanonfun$new$12$1.assertTooManyUserRightsError$1(grant1$1);
                Assertions$.MODULE$.assertEquals((Object)BoxesRunTime.boxToInteger((int)rights1$1.rights().size()), (Object)BoxesRunTime.boxToInteger((int)((SeqOps)permissionsMaxPlusOne$1.tail()).size()));
                Assertions$.MODULE$.assertSameElements((Iterable)rights1$1.rights(), (Iterable)permissionsMaxPlusOne$1.tail());
                Assertions$.MODULE$.assertEquals((Object)$this.$outer.unsetResourceVersion(create3), (Object)new CreateUserResponse((Option)new Some((Object)user2$1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$38$adapted(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$39(scala.collection.immutable.IndexedSeq ), $anonfun$applyOrElse$40(java.lang.Object ), $anonfun$applyOrElse$41(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.admin.user_management_service.User com.daml.ledger.api.v1.admin.user_management_service.User scala.Tuple4 ), $anonfun$applyOrElse$42(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.admin.user_management_service.User scala.collection.immutable.IndexedSeq com.daml.ledger.api.v1.admin.user_management_service.Right com.daml.ledger.api.v1.admin.user_management_service.User scala.collection.immutable.IndexedSeq java.lang.Throwable ), $anonfun$applyOrElse$43(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.admin.user_management_service.User com.daml.ledger.api.v1.admin.user_management_service.Right com.daml.ledger.api.v1.admin.user_management_service.User scala.collection.immutable.IndexedSeq java.lang.Throwable scala.collection.immutable.IndexedSeq com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse ), $anonfun$applyOrElse$44(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.admin.user_management_service.User com.daml.ledger.api.v1.admin.user_management_service.User scala.collection.immutable.IndexedSeq java.lang.Throwable com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse scala.collection.immutable.IndexedSeq java.lang.Throwable ), $anonfun$applyOrElse$45(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.admin.user_management_service.User scala.collection.immutable.IndexedSeq java.lang.Throwable com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse com.daml.ledger.api.v1.admin.user_management_service.User java.lang.Throwable scala.collection.immutable.IndexedSeq com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsResponse ), $anonfun$applyOrElse$46$adapted(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$12$1 java.lang.Throwable com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse com.daml.ledger.api.v1.admin.user_management_service.User java.lang.Throwable com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsResponse scala.collection.immutable.IndexedSeq com.daml.ledger.api.v1.admin.user_management_service.User com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse )}, serializedLambda);
            }
        };
        this.test("UserManagementUserRightsLimit", "Test user rights per user limit", x$53, x$56, x$57, x$58, x$54, "requires user management feature with user rights limit", x$59, x$60);
        String x$61 = "UserManagementCreateUserInvalidArguments";
        String x$62 = "Test argument validation for UserManagement#CreateUser";
        Allocation.PartyAllocation x$63 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$64 = (Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)UserManagementServiceIT.$anonfun$new$13(x$32));
        String x$65 = "requires user management feature";
        double x$66 = this.test$default$4();
        boolean x$67 = this.test$default$5();
        int x$68 = this.test$default$6();
        List x$69 = this.test$default$9();
        Function1 & Serializable x$70 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    String userId = UUID.randomUUID().toString();
                    return (B1)this.createAndCheck$1("empty user-id", new User("", User$.MODULE$.apply$default$2(), User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5()), (Seq)package$.MODULE$.List().empty(), (ErrorCode)RequestValidation.MissingField$.MODULE$, ledger).flatMap((Function1 & Serializable)x$37 -> {
                        BoxedUnit boxedUnit = x$37;
                        return this.createAndCheck$1("invalid user-id", new User("?", User$.MODULE$.apply$default$2(), User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5()), (Seq)package$.MODULE$.List().empty(), (ErrorCode)RequestValidation.InvalidField$.MODULE$, ledger).flatMap((Function1 & Serializable)x$36 -> {
                            BoxedUnit boxedUnit = x$36;
                            return this.createAndCheck$1("invalid primary-party", new User(new StringBuilder(3).append("u1-").append(userId).toString(), "party2-!!", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5()), (Seq)package$.MODULE$.List().empty(), (ErrorCode)RequestValidation.InvalidArgument$.MODULE$, ledger).map((Function1 & Serializable)x$33 -> {
                                Right r = new Right((Right.Kind)new Right.Kind$.CanActAs(new Right.CanActAs("party3-!!")));
                                return new Tuple2(x$33, (Object)r);
                            }, $this.ec$7).flatMap((Function1 & Serializable)x$35 -> {
                                Tuple2 tuple2 = x$35;
                                if (tuple2 != null) {
                                    Right r = (Right)tuple2._2();
                                    return this.createAndCheck$1("invalid party in right", new User(new StringBuilder(3).append("u2-").append(userId).toString(), User$.MODULE$.apply$default$2(), User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5()), (Seq)new .colon.colon((Object)r, (List)Nil$.MODULE$), (ErrorCode)RequestValidation.InvalidArgument$.MODULE$, ledger).map((Function1 & Serializable)x$34 -> {
                                        $anonfun$$nestedInanonfun$new$14$1.$anonfun$applyOrElse$52(x$34);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$7);
                                }
                                throw new MatchError((Object)tuple2);
                            }, $this.ec$7);
                        }, $this.ec$7);
                    }, this.ec$7);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$47(ErrorCode expectedErrorCode$1, Throwable throwable) {
                Assertions$.MODULE$.assertGrpcError(throwable, expectedErrorCode$1, (Option)None$.MODULE$, Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }

            private final Future createAndCheck$1(String problem, User user, Seq rights, ErrorCode expectedErrorCode, ParticipantTestContext ledger$7) {
                return Assertions$.MODULE$.futureAssertions(ledger$7.createUser(new CreateUserRequest((Option)new Some((Object)user), rights))).mustFail(problem, this.ec$7).map((Function1 & Serializable)throwable -> {
                    $anonfun$$nestedInanonfun$new$14$1.$anonfun$applyOrElse$47(expectedErrorCode, throwable);
                    return BoxedUnit.UNIT;
                }, this.ec$7);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$52(BoxedUnit x$34) {
                BoxedUnit boxedUnit = x$34;
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$47$adapted(com.daml.error.ErrorCode java.lang.Throwable ), $anonfun$applyOrElse$48(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$14$1 java.lang.String com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.runtime.BoxedUnit ), $anonfun$applyOrElse$49(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$14$1 java.lang.String com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.runtime.BoxedUnit ), $anonfun$applyOrElse$50(scala.runtime.BoxedUnit ), $anonfun$applyOrElse$51(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$14$1 java.lang.String com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple2 ), $anonfun$applyOrElse$52$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        this.test("UserManagementCreateUserInvalidArguments", "Test argument validation for UserManagement#CreateUser", x$63, x$66, x$67, x$68, x$64, "requires user management feature", x$69, x$70);
        String x$71 = "UserManagementGetUserInvalidArguments";
        String x$72 = "Test argument validation for UserManagement#GetUser";
        Allocation.PartyAllocation x$73 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$74 = (Function1 & Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)UserManagementServiceIT.$anonfun$new$15(x$38));
        String x$75 = "requires user management feature";
        double x$76 = this.test$default$4();
        boolean x$77 = this.test$default$5();
        int x$78 = this.test$default$6();
        List x$79 = this.test$default$9();
        Function1 & Serializable x$80 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)this.getAndCheck$1("empty user-id", "", (ErrorCode)RequestValidation.InvalidArgument$.MODULE$, ledger).flatMap((Function1 & Serializable)x$40 -> {
                        BoxedUnit boxedUnit = x$40;
                        return this.getAndCheck$1("invalid user-id", "?", (ErrorCode)RequestValidation.InvalidField$.MODULE$, ledger).map((Function1 & Serializable)x$39 -> {
                            $anonfun$$nestedInanonfun$new$16$1.$anonfun$applyOrElse$55(x$39);
                            return BoxedUnit.UNIT;
                        }, $this.ec$8);
                    }, this.ec$8);
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participant participant;
                Allocation.Participants participants = x8;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$53(ErrorCode expectedErrorCode$2, Throwable error) {
                Assertions$.MODULE$.assertGrpcError(error, expectedErrorCode$2, (Option)None$.MODULE$, Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }

            private final Future getAndCheck$1(String problem, String userId, ErrorCode expectedErrorCode, ParticipantTestContext ledger$8) {
                return Assertions$.MODULE$.futureAssertions(ledger$8.userManagement().getUser(new GetUserRequest(userId, GetUserRequest$.MODULE$.apply$default$2()))).mustFail(problem, this.ec$8).map((Function1 & Serializable)error -> {
                    $anonfun$$nestedInanonfun$new$16$1.$anonfun$applyOrElse$53(expectedErrorCode, error);
                    return BoxedUnit.UNIT;
                }, this.ec$8);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$55(BoxedUnit x$39) {
                BoxedUnit boxedUnit = x$39;
            }
            {
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$53$adapted(com.daml.error.ErrorCode java.lang.Throwable ), $anonfun$applyOrElse$54(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.runtime.BoxedUnit ), $anonfun$applyOrElse$55$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        this.test("UserManagementGetUserInvalidArguments", "Test argument validation for UserManagement#GetUser", x$73, x$76, x$77, x$78, x$74, "requires user management feature", x$79, x$80);
        this.userManagementTest("RaceConditionCreateUsers", "Tests scenario of multiple concurrent create-user calls for the same user", false, this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)participant -> {
            Vector attempts = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).toVector();
            String userId = (String)participant.nextUserId().apply();
            CreateUserRequest request = new CreateUserRequest((Option)new Some((Object)new User(userId, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)package$.MODULE$.Seq().empty());
            return Future$.MODULE$.traverse((IterableOnce)attempts, (Function1 & Serializable)x$41 -> UserManagementServiceIT.$anonfun$new$19(participant, request, ec, BoxesRunTime.unboxToInt((Object)x$41)), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)results -> {
                UserManagementServiceIT.$anonfun$new$21(results);
                return BoxedUnit.UNIT;
            }, ec);
        });
        this.userManagementTest("RaceConditionDeleteUsers", "Tests scenario of multiple concurrent delete-user calls for the same user", false, this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)participant -> {
            Vector attempts = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).toVector();
            String userId = (String)participant.nextUserId().apply();
            CreateUserRequest createUserRequest = new CreateUserRequest((Option)new Some((Object)new User(userId, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)package$.MODULE$.Seq().empty());
            DeleteUserRequest deleteUserRequest = new DeleteUserRequest(userId, DeleteUserRequest$.MODULE$.apply$default$2());
            return participant.createUser(createUserRequest).flatMap((Function1 & Serializable)x$47 -> {
                CreateUserResponse createUserResponse = x$47;
                return Future$.MODULE$.traverse((IterableOnce)attempts, (Function1 & Serializable)x$44 -> UserManagementServiceIT.$anonfun$new$26(participant, deleteUserRequest, ec, BoxesRunTime.unboxToInt((Object)x$44)), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)results -> {
                    UserManagementServiceIT.$anonfun$new$28(results);
                    return BoxedUnit.UNIT;
                }, ec);
            }, ec);
        });
        this.userManagementTest("RaceConditionGrantRights", "Tests scenario of multiple concurrent grant-right calls for the same user and the same rights", false, this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)participant -> {
            Vector attempts = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).toVector();
            String userId = (String)participant.nextUserId().apply();
            String suffix = UUID.randomUUID().toString();
            CreateUserRequest createUserRequest = new CreateUserRequest((Option)new Some((Object)new User(userId, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)package$.MODULE$.Seq().empty());
            return this.allocateParties((ParticipantTestContext)participant, suffix, (ExecutionContext)ec).map((Function1 & Serializable)parties -> {
                List<Right> userRights = this.getUserRights((Parties)parties);
                GrantUserRightsRequest grantRightsRequest = new GrantUserRightsRequest(userId, userRights, GrantUserRightsRequest$.MODULE$.apply$default$3());
                return new Tuple3(parties, userRights, (Object)grantRightsRequest);
            }, ec).flatMap((Function1 & Serializable)x$51 -> {
                Tuple3 tuple3 = x$51;
                if (tuple3 != null) {
                    List userRights = (List)tuple3._2();
                    GrantUserRightsRequest grantRightsRequest = (GrantUserRightsRequest)tuple3._3();
                    return participant.createUser(createUserRequest).flatMap((Function1 & Serializable)x$50 -> {
                        CreateUserResponse createUserResponse = x$50;
                        return Future$.MODULE$.traverse((IterableOnce)attempts, (Function1 & Serializable)x$48 -> UserManagementServiceIT.$anonfun$new$35(participant, grantRightsRequest, ec, BoxesRunTime.unboxToInt((Object)x$48)), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)results -> {
                            UserManagementServiceIT.$anonfun$new$37(userRights, results);
                            return BoxedUnit.UNIT;
                        }, ec);
                    }, ec);
                }
                throw new MatchError((Object)tuple3);
            }, ec);
        });
        this.userManagementTest("RaceConditionRevokeRights", "Tests scenario of multiple concurrent revoke-right calls for the same user and the same rights", false, this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)participant -> {
            Vector attempts = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).toVector();
            String userId = (String)participant.nextUserId().apply();
            String suffix = UUID.randomUUID().toString();
            return this.allocateParties((ParticipantTestContext)participant, suffix, (ExecutionContext)ec).map((Function1 & Serializable)parties -> {
                List<Right> userRights = this.getUserRights((Parties)parties);
                CreateUserRequest createUserRequest = new CreateUserRequest((Option)new Some((Object)new User(userId, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), userRights);
                return new Tuple3(parties, userRights, (Object)createUserRequest);
            }, ec).flatMap((Function1 & Serializable)x$57 -> {
                Tuple3 tuple3 = x$57;
                if (tuple3 != null) {
                    List userRights = (List)tuple3._2();
                    CreateUserRequest createUserRequest = (CreateUserRequest)tuple3._3();
                    return participant.createUser(createUserRequest).map((Function1 & Serializable)x$55 -> {
                        RevokeUserRightsRequest revokeRightsRequest = new RevokeUserRightsRequest(userId, (Seq)userRights, RevokeUserRightsRequest$.MODULE$.apply$default$3());
                        return new Tuple2(x$55, (Object)revokeRightsRequest);
                    }, ec).flatMap((Function1 & Serializable)x$56 -> {
                        Tuple2 tuple2 = x$56;
                        if (tuple2 != null) {
                            RevokeUserRightsRequest revokeRightsRequest = (RevokeUserRightsRequest)tuple2._2();
                            return Future$.MODULE$.traverse((IterableOnce)attempts, (Function1 & Serializable)x$52 -> UserManagementServiceIT.$anonfun$new$44(participant, revokeRightsRequest, ec, BoxesRunTime.unboxToInt((Object)x$52)), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)results -> {
                                UserManagementServiceIT.$anonfun$new$46(results);
                                return BoxedUnit.UNIT;
                            }, ec);
                        }
                        throw new MatchError((Object)tuple2);
                    }, ec);
                }
                throw new MatchError((Object)tuple3);
            }, ec);
        });
        this.userManagementTest("TestAdminExists", "Ensure admin user exists", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            boolean useMeta = ledger.features().userAndPartyLocalMetadataExtensions();
            return ledger.userManagement().getUser(new GetUserRequest(this.AdminUserId(), GetUserRequest$.MODULE$.apply$default$2())).flatMap((Function1 & Serializable)get1 -> ledger.userManagement().listUserRights(new ListUserRightsRequest(this.AdminUserId(), ListUserRightsRequest$.MODULE$.apply$default$2())).map((Function1 & Serializable)rights1 -> {
                UserManagementServiceIT.$anonfun$new$51(this, get1, useMeta, rights1);
                return BoxedUnit.UNIT;
            }, ec), ec);
        });
        this.userManagementTest("TestCreateUser", "Exercise CreateUser rpc", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId1 = (String)ledger.nextUserId().apply();
            String userId2 = (String)ledger.nextUserId().apply();
            String x$86 = userId1;
            String x$87 = "party1";
            Some x$88 = new Some((Object)new ObjectMeta(ObjectMeta$.MODULE$.apply$default$1(), ObjectMeta$.MODULE$.apply$default$2()));
            boolean x$89 = User$.MODULE$.apply$default$3();
            String x$90 = User$.MODULE$.apply$default$5();
            User user1 = new User(x$86, "party1", x$89, (Option)x$88, x$90);
            String x$91 = userId2;
            String x$92 = "";
            Some x$93 = new Some((Object)new ObjectMeta(ObjectMeta$.MODULE$.apply$default$1(), ObjectMeta$.MODULE$.apply$default$2()));
            boolean x$94 = User$.MODULE$.apply$default$3();
            String x$95 = User$.MODULE$.apply$default$5();
            User user2 = new User(x$91, "", x$94, (Option)x$93, x$95);
            return ledger.createUser(new CreateUserRequest((Option)new Some((Object)user1), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)res1 -> Assertions$.MODULE$.futureAssertions(ledger.createUser(new CreateUserRequest((Option)new Some((Object)user1), (Seq)Nil$.MODULE$))).mustFail("allocating a duplicate user", ec).flatMap((Function1 & Serializable)res2 -> ledger.createUser(new CreateUserRequest((Option)new Some((Object)user2), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)res3 -> ledger.deleteUser(new DeleteUserRequest(userId2, DeleteUserRequest$.MODULE$.apply$default$2())).map((Function1 & Serializable)res4 -> {
                UserManagementServiceIT.$anonfun$new$58(this, res1, user1, res2, res3, user2, ledger, res4);
                return BoxedUnit.UNIT;
            }, ec), ec), ec), ec);
        });
        String x$96 = "TestInvalidResourceVersionInCreateUser";
        String x$97 = "Exercise CreateUser rpc using resource version";
        boolean x$98 = true;
        boolean x$99 = this.userManagementTest$default$3();
        Function1 & Serializable x$105 = (Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId;
            String x$100 = userId = (String)ledger.nextUserId().apply();
            String x$101 = "";
            Some x$102 = new Some((Object)new ObjectMeta("someResourceVersion1", ObjectMeta$.MODULE$.apply$default$2()));
            boolean x$103 = User$.MODULE$.apply$default$3();
            String x$104 = User$.MODULE$.apply$default$5();
            User user = new User(x$100, "", x$103, (Option)x$102, x$104);
            return Assertions$.MODULE$.futureAssertions(ledger.createUser(new CreateUserRequest((Option)new Some((Object)user), (Seq)Nil$.MODULE$))).mustFail("creating user with non empty resource version", ec).map((Function1 & Serializable)res -> {
                Assertions$.MODULE$.assertGrpcError(res, (ErrorCode)RequestValidation.InvalidArgument$.MODULE$, (Option)new Some((Object)"user.metadata.resource_version"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
                return BoxedUnit.UNIT;
            }, ec);
        };
        this.userManagementTest("TestInvalidResourceVersionInCreateUser", "Exercise CreateUser rpc using resource version", x$99, true, (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)x$105);
        this.userManagementTest("TestGetUser", "Exercise GetUser rpc", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId1 = (String)ledger.nextUserId().apply();
            String userId2 = (String)ledger.nextUserId().apply();
            String x$106 = userId1;
            String x$107 = "party1";
            boolean x$108 = this.newUser$default$2();
            Map<String, String> x$109 = this.newUser$default$4();
            User user1 = this.newUser(x$106, x$108, "party1", x$109);
            return ledger.createUser(new CreateUserRequest((Option)new Some((Object)user1), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$58 -> {
                CreateUserResponse createUserResponse = x$58;
                return ledger.userManagement().getUser(new GetUserRequest(userId1, GetUserRequest$.MODULE$.apply$default$2())).flatMap((Function1 & Serializable)res1 -> Assertions$.MODULE$.futureAssertions(ledger.userManagement().getUser(new GetUserRequest(userId2, GetUserRequest$.MODULE$.apply$default$2()))).mustFail("retrieving non-existent user", ec).map((Function1 & Serializable)res2 -> {
                    UserManagementServiceIT.$anonfun$new$68(this, res1, user1, res2);
                    return BoxedUnit.UNIT;
                }, ec), ec);
            }, ec);
        });
        this.userManagementTest("TestDeleteUser", "Exercise DeleteUser rpc", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId1 = (String)ledger.nextUserId().apply();
            String userId2 = (String)ledger.nextUserId().apply();
            User user1 = new User(userId1, "party1", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5());
            return ledger.createUser(new CreateUserRequest((Option)new Some((Object)user1), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$59 -> {
                CreateUserResponse createUserResponse = x$59;
                return ledger.deleteUser(new DeleteUserRequest(userId1, DeleteUserRequest$.MODULE$.apply$default$2())).flatMap((Function1 & Serializable)res1 -> Assertions$.MODULE$.futureAssertions(ledger.userManagement().deleteUser(new DeleteUserRequest(userId2, DeleteUserRequest$.MODULE$.apply$default$2()))).mustFail("deleting non-existent user", ec).map((Function1 & Serializable)res2 -> {
                    UserManagementServiceIT.$anonfun$new$73(this, res1, res2);
                    return BoxedUnit.UNIT;
                }, ec), ec);
            }, ec);
        });
        this.userManagementTest("TestListUsersVisibilityOfNewUserWhenCreatedAndThenDeleted", "Exercise ListUsers rpc: Creating and deleting a user makes it visible and then absent from a page", false, this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> ledger.userManagement().listUsers(new ListUsersRequest("", 10, ListUsersRequest$.MODULE$.apply$default$3())).map((Function1 & Serializable)pageBeforeCreate -> {
            String newUserId;
            String x$110 = newUserId = new StringBuilder(1).append("!").append(pageBeforeCreate.users().headOption().map((Function1 & Serializable)x$60 -> x$60.id()).getOrElse((Function0 & Serializable)() -> (String)ledger.nextUserId().apply())).toString();
            String x$111 = "";
            boolean x$112 = this.newUser$default$2();
            Map<String, String> x$113 = this.newUser$default$4();
            User newUser1 = this.newUser(x$110, x$112, "", x$113);
            this.assertUserAbsentIn$1(newUser1, (ListUsersResponse)pageBeforeCreate, "new user should be absent before it's creation");
            BoxedUnit x$61 = BoxedUnit.UNIT;
            return new Tuple4(pageBeforeCreate, (Object)newUserId, (Object)newUser1, (Object)x$61);
        }, ec).flatMap((Function1 & Serializable)x$68 -> {
            Tuple4 tuple4 = x$68;
            if (tuple4 != null) {
                String newUserId = (String)tuple4._2();
                User newUser1 = (User)tuple4._3();
                return ledger.createUser(new CreateUserRequest((Option)new Some((Object)newUser1), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$67 -> {
                    CreateUserResponse createUserResponse = x$67;
                    return ledger.userManagement().listUsers(new ListUsersRequest("", 10, ListUsersRequest$.MODULE$.apply$default$3())).map((Function1 & Serializable)pageAfterCreate -> {
                        this.assertUserPresentIn$1(newUser1, (ListUsersResponse)pageAfterCreate, "new users should be present after it's creation");
                        BoxedUnit x$62 = BoxedUnit.UNIT;
                        return new Tuple2(pageAfterCreate, (Object)x$62);
                    }, ec).flatMap((Function1 & Serializable)x$66 -> {
                        Tuple2 tuple2 = x$66;
                        if (tuple2 != null) {
                            return ledger.deleteUser(new DeleteUserRequest(newUserId, DeleteUserRequest$.MODULE$.apply$default$2())).flatMap((Function1 & Serializable)x$65 -> {
                                DeleteUserResponse deleteUserResponse = x$65;
                                return ledger.userManagement().listUsers(new ListUsersRequest("", 10, ListUsersRequest$.MODULE$.apply$default$3())).map((Function1 & Serializable)pageAfterDelete -> {
                                    this.assertUserAbsentIn$1(newUser1, (ListUsersResponse)pageAfterDelete, "new user should be absent after it's deletion");
                                    BoxedUnit x$63 = BoxedUnit.UNIT;
                                    return new Tuple2(pageAfterDelete, (Object)x$63);
                                }, ec).map((Function1 & Serializable)x$64 -> {
                                    UserManagementServiceIT.$anonfun$new$89(x$64);
                                    return BoxedUnit.UNIT;
                                }, ec);
                            }, ec);
                        }
                        throw new MatchError((Object)tuple2);
                    }, ec);
                }, ec);
            }
            throw new MatchError((Object)tuple4);
        }, ec));
        this.userManagementTest("TestListUsersCreateOrDeleteUserOnPreviousPage", "Exercise ListUsers rpc: Adding a user to a previous page doesn't affect the subsequent page", false, this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId1 = (String)ledger.nextUserId().apply();
            String userId2 = (String)ledger.nextUserId().apply();
            String userId3 = (String)ledger.nextUserId().apply();
            String userId4 = (String)ledger.nextUserId().apply();
            return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(userId1, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$76 -> {
                CreateUserResponse createUserResponse = x$76;
                return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(userId2, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$75 -> {
                    CreateUserResponse createUserResponse = x$75;
                    return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(userId3, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$74 -> {
                        CreateUserResponse createUserResponse = x$74;
                        return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(userId4, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$73 -> {
                            CreateUserResponse createUserResponse = x$73;
                            return ledger.userManagement().listUsers(new ListUsersRequest("", 2, ListUsersRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)page1 -> ledger.userManagement().listUsers(new ListUsersRequest(page1.nextPageToken(), 2, ListUsersRequest$.MODULE$.apply$default$3())).map((Function1 & Serializable)page2 -> {
                                String newUserId = new StringBuilder(1).append("!").append(((User)page1.users().last()).id()).toString();
                                return new Tuple2(page2, (Object)newUserId);
                            }, ec).flatMap((Function1 & Serializable)x$72 -> {
                                Tuple2 tuple2 = x$72;
                                if (tuple2 != null) {
                                    ListUsersResponse page2 = (ListUsersResponse)tuple2._1();
                                    String newUserId = (String)tuple2._2();
                                    return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(newUserId, User$.MODULE$.apply$default$2(), User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)package$.MODULE$.Seq().empty())).flatMap((Function1 & Serializable)x$71 -> {
                                        CreateUserResponse createUserResponse = x$71;
                                        return ledger.userManagement().listUsers(new ListUsersRequest(page1.nextPageToken(), 2, ListUsersRequest$.MODULE$.apply$default$3())).map((Function1 & Serializable)page2B -> {
                                            Assertions$.MODULE$.assertEquals("after creating new user before the second page", (Object)page2, page2B);
                                            BoxedUnit x$69 = BoxedUnit.UNIT;
                                            return new Tuple2(page2B, (Object)x$69);
                                        }, ec).map((Function1 & Serializable)x$70 -> {
                                            UserManagementServiceIT.$anonfun$new$101(x$70);
                                            return BoxedUnit.UNIT;
                                        }, ec);
                                    }, ec);
                                }
                                throw new MatchError((Object)tuple2);
                            }, ec), ec);
                        }, ec);
                    }, ec);
                }, ec);
            }, ec);
        });
        this.userManagementTest("TestListUsersReachingTheLastPage", "Exercise ListUsers rpc: Listing all users page by page eventually terminates reaching the last page", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            int pageSize = 10000;
            return UserManagementServiceIT.fetchNextPage$1("", 0, ledger, pageSize, ec);
        });
        this.userManagementTest("TestListUsersOnInvalidRequests", "Exercise ListUsers rpc: Requesting invalid pageSize or pageToken results in an error", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> Assertions$.MODULE$.futureAssertions(ledger.userManagement().listUsers(new ListUsersRequest(UUID.randomUUID().toString(), ListUsersRequest$.MODULE$.apply$default$2(), ListUsersRequest$.MODULE$.apply$default$3()))).mustFail("using invalid page token string", ec).flatMap((Function1 & Serializable)onBadTokenError -> {
            int x$114 = -100;
            String x$115 = ListUsersRequest$.MODULE$.apply$default$1();
            String x$116 = ListUsersRequest$.MODULE$.apply$default$3();
            return Assertions$.MODULE$.futureAssertions(ledger.userManagement().listUsers(new ListUsersRequest(x$115, -100, x$116))).mustFail("using negative page size", ec).map((Function1 & Serializable)onNegativePageSizeError -> {
                UserManagementServiceIT.$anonfun$new$109(onBadTokenError, onNegativePageSizeError);
                return BoxedUnit.UNIT;
            }, ec);
        }, ec));
        this.userManagementTest("TestListUsersRequestPageSizeZero", "Exercise ListUsers rpc: Requesting page of size zero means requesting server's default page size, which is larger than zero", false, this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId1 = (String)ledger.nextUserId().apply();
            String userId2 = (String)ledger.nextUserId().apply();
            return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(userId1, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$80 -> {
                CreateUserResponse createUserResponse = x$80;
                return ledger.createUser(new CreateUserRequest((Option)new Some((Object)new User(userId2, "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5())), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$79 -> {
                    CreateUserResponse createUserResponse = x$79;
                    boolean x$117 = false;
                    String x$118 = ListUsersRequest$.MODULE$.apply$default$1();
                    String x$119 = ListUsersRequest$.MODULE$.apply$default$3();
                    return ledger.userManagement().listUsers(new ListUsersRequest(x$118, 0, x$119)).flatMap((Function1 & Serializable)pageSizeZero -> {
                        boolean x$120 = true;
                        String x$121 = ListUsersRequest$.MODULE$.apply$default$1();
                        String x$122 = ListUsersRequest$.MODULE$.apply$default$3();
                        return ledger.userManagement().listUsers(new ListUsersRequest(x$121, 1, x$122)).map((Function1 & Serializable)pageSizeOne -> {
                            UserManagementServiceIT.$anonfun$new$115(pageSizeZero, pageSizeOne);
                            return BoxedUnit.UNIT;
                        }, ec);
                    }, ec);
                }, ec);
            }, ec);
        });
        String x$123 = "TestMaxUsersPageSize";
        String x$124 = "Exercise ListUsers rpc: Requesting more than maxUsersPageSize results in at most maxUsersPageSize returned users";
        Allocation.PartyAllocation x$125 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$126 = (Function1 & Serializable)x$81 -> BoxesRunTime.boxToBoolean((boolean)UserManagementServiceIT.$anonfun$new$117(x$81));
        String x$127 = "requires user management feature with users page size limit";
        boolean x$128 = false;
        double x$129 = this.test$default$4();
        int x$130 = this.test$default$6();
        List x$131 = this.test$default$9();
        Function1 & Serializable x$1322 = (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$23;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x14;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    int maxUsersPageSize = ledger.features().userManagement().maxUsersPageSize();
                    IndexedSeq users = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), maxUsersPageSize + 1).map((Function1 & Serializable)x$82 -> $anonfun$$nestedInanonfun$new$118$1.$anonfun$applyOrElse$56(ledger, BoxesRunTime.unboxToInt((Object)x$82)));
                    return (B1)Future$.MODULE$.sequence((IterableOnce)users.map((Function1 & Serializable)u -> ledger.createUser(new CreateUserRequest((Option)new Some(u), (Seq)Nil$.MODULE$))), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$23).flatMap((Function1 & Serializable)x$83 -> {
                        IndexedSeq indexedSeq = x$83;
                        int x$1 = maxUsersPageSize + 1;
                        String x$2 = "";
                        String x$3 = ListUsersRequest$.MODULE$.apply$default$3();
                        return ledger.userManagement().listUsers(new ListUsersRequest("", x$1, x$3)).map((Function1 & Serializable)page -> {
                            $anonfun$$nestedInanonfun$new$118$1.$anonfun$applyOrElse$59(maxUsersPageSize, page);
                            return BoxedUnit.UNIT;
                        }, $this.ec$23);
                    }, this.ec$23);
                }
                return (B1)function1.apply(x14);
            }

            public final boolean isDefinedAt(Allocation.Participants x14) {
                Allocation.Participant participant;
                Allocation.Participants participants = x14;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ User $anonfun$applyOrElse$56(ParticipantTestContext ledger$18, int x$82) {
                return new User((String)ledger$18.nextUserId().apply(), "", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5());
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$59(int maxUsersPageSize$1, ListUsersResponse page) {
                Predef$.MODULE$.assert(page.users().size() <= maxUsersPageSize$1, (Function0 & Serializable)() -> new StringBuilder(63).append("page size must be within limit. actual size: ").append(page.users().size()).append(", server's limit: ").append(maxUsersPageSize$1).toString());
            }
            {
                this.ec$23 = ec$23;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$56$adapted(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$57(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.admin.user_management_service.User ), $anonfun$applyOrElse$58(com.daml.ledger.api.testtool.suites.v1_8.UserManagementServiceIT$$anonfun$$nestedInanonfun$new$118$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext int scala.collection.immutable.IndexedSeq ), $anonfun$applyOrElse$59$adapted(int com.daml.ledger.api.v1.admin.user_management_service.ListUsersResponse ), $anonfun$applyOrElse$60(com.daml.ledger.api.v1.admin.user_management_service.ListUsersResponse int )}, serializedLambda);
            }
        };
        this.test("TestMaxUsersPageSize", "Exercise ListUsers rpc: Requesting more than maxUsersPageSize results in at most maxUsersPageSize returned users", x$125, x$129, false, x$130, x$126, "requires user management feature with users page size limit", x$131, x$1322);
        this.userManagementTest("TestGrantTheEmptyRight", "Test granting an empty right", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId = (String)ledger.nextUserId().apply();
            User user = new User(userId, User$.MODULE$.apply$default$2(), User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5());
            return ledger.createUser(new CreateUserRequest((Option)new Some((Object)user), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$85 -> {
                CreateUserResponse createUserResponse = x$85;
                return Assertions$.MODULE$.futureAssertions(ledger.userManagement().grantUserRights(new GrantUserRightsRequest(userId, (Seq)new .colon.colon((Object)new Right((Right.Kind)Right.Kind$.Empty$.MODULE$), (List)Nil$.MODULE$), GrantUserRightsRequest$.MODULE$.apply$default$3()))).mustFailWith("granting empty right", (ErrorCode)RequestValidation.InvalidArgument$.MODULE$, (Option)new Some((Object)"unknown kind of right"), ec).map((Function1 & Serializable)x$84 -> {
                    boxedUnit = x$84;
                    return BoxedUnit.UNIT;
                }, ec);
            }, ec);
        });
        this.userManagementTest("TestGrantingAndRevokingEmptyListOfRights", "Test granting and revoking empty list of rights", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId = (String)ledger.nextUserId().apply();
            User user = new User(userId, User$.MODULE$.apply$default$2(), User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5());
            return ledger.createUser(new CreateUserRequest((Option)new Some((Object)user), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)x$88 -> {
                CreateUserResponse createUserResponse = x$88;
                return ledger.userManagement().grantUserRights(new GrantUserRightsRequest(userId, (Seq)package$.MODULE$.List().empty(), GrantUserRightsRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)x$87 -> {
                    GrantUserRightsResponse grantUserRightsResponse = x$87;
                    return ledger.userManagement().revokeUserRights(new RevokeUserRightsRequest(userId, (Seq)package$.MODULE$.List().empty(), RevokeUserRightsRequest$.MODULE$.apply$default$3())).map((Function1 & Serializable)x$86 -> {
                        revokeUserRightsResponse = x$86;
                        return BoxedUnit.UNIT;
                    }, ec);
                }, ec);
            }, ec);
        });
        this.userManagementTest("TestGrantUserRights", "Exercise GrantUserRights rpc", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId1 = (String)ledger.nextUserId().apply();
            String userId2 = (String)ledger.nextUserId().apply();
            User user1 = new User(userId1, "party1", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5());
            String suffix = UUID.randomUUID().toString();
            return this.allocateParties((ParticipantTestContext)ledger, suffix, (ExecutionContext)ec).map((Function1 & Serializable)parties -> {
                List<Right> userRights = this.getUserRights((Parties)parties);
                return new Tuple2(parties, userRights);
            }, ec).flatMap((Function1 & Serializable)x$89 -> {
                Tuple2 tuple2 = x$89;
                if (tuple2 != null) {
                    List userRights = (List)tuple2._2();
                    return ledger.createUser(new CreateUserRequest((Option)new Some((Object)user1), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)userBefore -> ledger.userManagement().grantUserRights(new GrantUserRightsRequest(userId1, (Seq)new .colon.colon((Object)this.adminPermission(), (List)Nil$.MODULE$), GrantUserRightsRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)res1 -> Assertions$.MODULE$.futureAssertions(ledger.userManagement().grantUserRights(new GrantUserRightsRequest(userId2, (Seq)new .colon.colon((Object)this.adminPermission(), (List)Nil$.MODULE$), GrantUserRightsRequest$.MODULE$.apply$default$3()))).mustFail("granting right to a non-existent user", ec).flatMap((Function1 & Serializable)res2 -> ledger.userManagement().grantUserRights(new GrantUserRightsRequest(userId1, (Seq)new .colon.colon((Object)this.adminPermission(), (List)Nil$.MODULE$), GrantUserRightsRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)res3 -> ledger.userManagement().grantUserRights(new GrantUserRightsRequest(userId1, (Seq)userRights, GrantUserRightsRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)res4 -> ledger.userManagement().getUser(new GetUserRequest(user1.id(), GetUserRequest$.MODULE$.apply$default$2())).map((Function1 & Serializable)userAfter -> {
                        UserManagementServiceIT.$anonfun$new$137(this, res1, res2, res3, res4, userRights, ledger, userBefore, userAfter);
                        return BoxedUnit.UNIT;
                    }, ec), ec), ec), ec), ec), ec);
                }
                throw new MatchError((Object)tuple2);
            }, ec);
        });
        this.userManagementTest("TestRevokeUserRights", "Exercise RevokeUserRights rpc", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId1 = (String)ledger.nextUserId().apply();
            String userId2 = (String)ledger.nextUserId().apply();
            User user1 = new User(userId1, "party1", User$.MODULE$.apply$default$3(), User$.MODULE$.apply$default$4(), User$.MODULE$.apply$default$5());
            String suffix = UUID.randomUUID().toString();
            return this.allocateParties((ParticipantTestContext)ledger, suffix, (ExecutionContext)ec).map((Function1 & Serializable)parties -> {
                List<Right> userRights = this.getUserRights((Parties)parties);
                return new Tuple2(parties, userRights);
            }, ec).flatMap((Function1 & Serializable)x$90 -> {
                Tuple2 tuple2 = x$90;
                if (tuple2 != null) {
                    List userRights = (List)tuple2._2();
                    return ledger.createUser(new CreateUserRequest((Option)new Some((Object)user1), (Seq)new .colon.colon((Object)this.adminPermission(), (List)Nil$.MODULE$).$plus$plus((IterableOnce)userRights))).flatMap((Function1 & Serializable)userBefore -> ledger.userManagement().revokeUserRights(new RevokeUserRightsRequest(userId1, (Seq)new .colon.colon((Object)this.adminPermission(), (List)Nil$.MODULE$), RevokeUserRightsRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)res1 -> Assertions$.MODULE$.futureAssertions(ledger.userManagement().revokeUserRights(new RevokeUserRightsRequest(userId2, (Seq)new .colon.colon((Object)this.adminPermission(), (List)Nil$.MODULE$), RevokeUserRightsRequest$.MODULE$.apply$default$3()))).mustFail("revoking right from a non-existent user", ec).flatMap((Function1 & Serializable)res2 -> ledger.userManagement().revokeUserRights(new RevokeUserRightsRequest(userId1, (Seq)new .colon.colon((Object)this.adminPermission(), (List)Nil$.MODULE$), RevokeUserRightsRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)res3 -> ledger.userManagement().revokeUserRights(new RevokeUserRightsRequest(userId1, (Seq)userRights, RevokeUserRightsRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)res4 -> ledger.userManagement().getUser(new GetUserRequest(user1.id(), GetUserRequest$.MODULE$.apply$default$2())).map((Function1 & Serializable)userAfter -> {
                        UserManagementServiceIT.$anonfun$new$147(this, res1, res2, res3, res4, userRights, ledger, userBefore, userAfter);
                        return BoxedUnit.UNIT;
                    }, ec), ec), ec), ec), ec), ec);
                }
                throw new MatchError((Object)tuple2);
            }, ec);
        });
        this.userManagementTest("TestListUserRights", "Exercise ListUserRights rpc", this.userManagementTest$default$3(), this.userManagementTest$default$4(), (Function1<ExecutionContext, Function1<ParticipantTestContext, Future<BoxedUnit>>>)(Function1 & Serializable)ec -> (Function1 & Serializable)ledger -> {
            String userId1;
            String x$133 = userId1 = (String)ledger.nextUserId().apply();
            String x$134 = "party4";
            Some x$135 = new Some((Object)new ObjectMeta(ObjectMeta$.MODULE$.apply$default$1(), ObjectMeta$.MODULE$.apply$default$2()));
            boolean x$136 = User$.MODULE$.apply$default$3();
            String x$137 = User$.MODULE$.apply$default$5();
            User user1 = new User(x$133, "party4", x$136, (Option)x$135, x$137);
            String suffix = UUID.randomUUID().toString();
            return this.allocateParties((ParticipantTestContext)ledger, suffix, (ExecutionContext)ec).flatMap((Function1 & Serializable)parties -> ledger.createUser(new CreateUserRequest((Option)new Some((Object)user1), (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)res1 -> ledger.userManagement().listUserRights(new ListUserRightsRequest(userId1, ListUserRightsRequest$.MODULE$.apply$default$2())).flatMap((Function1 & Serializable)res2 -> ledger.userManagement().grantUserRights(new GrantUserRightsRequest(userId1, (Seq)new .colon.colon((Object)this.adminPermission(), (List)new .colon.colon((Object)this.actAsPermission(parties.acting1()), (List)new .colon.colon((Object)this.readAsPermission(parties.reading1()), (List)Nil$.MODULE$))), GrantUserRightsRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)res3 -> ledger.userManagement().listUserRights(new ListUserRightsRequest(userId1, ListUserRightsRequest$.MODULE$.apply$default$2())).flatMap((Function1 & Serializable)res4 -> ledger.userManagement().revokeUserRights(new RevokeUserRightsRequest(userId1, (Seq)new .colon.colon((Object)this.adminPermission(), (List)Nil$.MODULE$), RevokeUserRightsRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)res5 -> ledger.userManagement().listUserRights(new ListUserRightsRequest(userId1, ListUserRightsRequest$.MODULE$.apply$default$2())).map((Function1 & Serializable)res6 -> {
                UserManagementServiceIT.$anonfun$new$156(this, res1, user1, res2, res3, parties, res4, res5, res6);
                return BoxedUnit.UNIT;
            }, ec), ec), ec), ec), ec), ec), ec);
        });
    }

    public static class Parties
    implements Product,
    Serializable {
        private final String acting1;
        private final String acting2;
        private final String reading1;
        private final String reading2;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String acting1() {
            return this.acting1;
        }

        public String acting2() {
            return this.acting2;
        }

        public String reading1() {
            return this.reading1;
        }

        public String reading2() {
            return this.reading2;
        }

        public Parties copy(String acting1, String acting2, String reading1, String reading2) {
            return new Parties(acting1, acting2, reading1, reading2);
        }

        public String copy$default$1() {
            return this.acting1();
        }

        public String copy$default$2() {
            return this.acting2();
        }

        public String copy$default$3() {
            return this.reading1();
        }

        public String copy$default$4() {
            return this.reading2();
        }

        public String productPrefix() {
            return "Parties";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.acting1();
                }
                case 1: {
                    return this.acting2();
                }
                case 2: {
                    return this.reading1();
                }
                case 3: {
                    return this.reading2();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Parties;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "acting1";
                }
                case 1: {
                    return "acting2";
                }
                case 2: {
                    return "reading1";
                }
                case 3: {
                    return "reading2";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Parties)) return false;
            boolean bl = true;
            if (!bl) return false;
            Parties parties = (Parties)x$1;
            String string = this.acting1();
            String string2 = parties.acting1();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.acting2();
            String string4 = parties.acting2();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.reading1();
            String string6 = parties.reading1();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.reading2();
            String string8 = parties.reading2();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            if (!parties.canEqual(this)) return false;
            return true;
        }

        public Parties(String acting1, String acting2, String reading1, String reading2) {
            this.acting1 = acting1;
            this.acting2 = acting2;
            this.reading1 = reading1;
            this.reading2 = reading2;
            Product.$init$((Product)this);
        }
    }
}

