/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.CommandExecution;
import com.daml.error.definitions.groups.ConsistencyErrors;
import com.daml.grpc.GrpcStatus$;
import com.daml.ledger.api.SubmissionIdGenerator;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.FutureAssertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.ProtobufConverters$;
import com.daml.ledger.api.testtool.infrastructure.assertions.CommandDeduplicationAssertions$;
import com.daml.ledger.api.testtool.infrastructure.participant.Features;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.infrastructure.time.DelayMechanism;
import com.daml.ledger.api.testtool.infrastructure.time.Durations$;
import com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$;
import com.daml.ledger.api.v1.admin.config_management_service.GetTimeModelResponse;
import com.daml.ledger.api.v1.admin.config_management_service.TimeModel;
import com.daml.ledger.api.v1.admin.config_management_service.TimeModel$;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest$;
import com.daml.ledger.api.v1.command_submission_service.SubmitRequest;
import com.daml.ledger.api.v1.command_submission_service.SubmitRequest$;
import com.daml.ledger.api.v1.commands.Command;
import com.daml.ledger.api.v1.commands.Commands;
import com.daml.ledger.api.v1.commands.Commands$;
import com.daml.ledger.api.v1.completion.Completion;
import com.daml.ledger.api.v1.experimental_features.CommandDeduplicationPeriodSupport;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.test.model.DA.Types.Tuple2;
import com.daml.ledger.test.model.Test.Dummy;
import com.daml.ledger.test.model.Test.DummyWithAnnotation;
import com.daml.ledger.test.model.Test.TextKey;
import com.daml.ledger.test.model.Test.TextKeyOperations;
import com.daml.ledger.test.model.Test.TextKeyOperations$;
import com.daml.lf.data.Ref$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.google.protobuf.duration.Duration;
import io.grpc.Status;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rug\u0001B\u0013'\u0005UB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011B%\t\u000fE\u0003!\u0019!C\u0006%\"1\u0011\f\u0001Q\u0001\nMCqA\u0017\u0001C\u0002\u0013%1\f\u0003\u0004e\u0001\u0001\u0006I\u0001\u0018\u0005\u0006K\u0002!IA\u001a\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\tY\u0007\u0001C\t\u0003[Bq!!!\u0001\t#\t\u0019\tC\u0004\u0002J\u0002!\t\"a3\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"I!1\b\u0001\u0012\u0002\u0013%!Q\b\u0005\b\u0005'\u0002A\u0011\u0003B+\u0011\u001d\u0011\t\n\u0001C\t\u0005'CqAa)\u0001\t\u0013\u0011)\u000bC\u0004\u0003F\u0002!IAa2\t\u000f\tM\u0007\u0001\"\u0003\u0003V\"9!Q\u001c\u0001\u0005\n\t}\u0007b\u0002Bw\u0001\u0011%!q\u001e\u0005\b\u0005k\u0004A\u0011\u0002B|\u0011\u001d\u0019Y\u0001\u0001C\u0005\u0007\u001bAqa!\b\u0001\t#\u0019y\u0002C\u0004\u0004\u001e\u0001!\tba\u000b\t\u000f\r]\u0002\u0001\"\u0005\u0004:!91q\t\u0001\u0005\n\r%\u0003bBB(\u0001\u0011%1\u0011\u000b\u0005\b\u0007\u001f\u0002A\u0011BB-\u0011\u001d\u0019\t\u0007\u0001C\u0005\u0007GBqa!\u0019\u0001\t\u0013\u00199\u0007C\u0004\u0004l\u0001!Ia!\u001c\t\u000f\r=\u0004\u0001\"\u0003\u0004r!91\u0011\u0012\u0001\u0005\n\r-\u0005bBBY\u0001\u0011%11\u0017\u0005\b\u0007\u0013\u0004A\u0011BBf\u0005Y\u0019u.\\7b]\u0012$U\rZ;qY&\u001c\u0017\r^5p]&#&BA\u0014)\u0003\u00111\u0018g\u0018\u001d\u000b\u0005%R\u0013AB:vSR,7O\u0003\u0002,Y\u0005AA/Z:ui>|GN\u0003\u0002.]\u0005\u0019\u0011\r]5\u000b\u0005=\u0002\u0014A\u00027fI\u001e,'O\u0003\u00022e\u0005!A-Y7m\u0015\u0005\u0019\u0014aA2p[\u000e\u00011C\u0001\u00017!\t9$(D\u00019\u0015\tI$&\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005mB$a\u0004'fI\u001e,'\u000fV3tiN+\u0018\u000e^3\u0002%QLW.Z8viN\u001b\u0017\r\\3GC\u000e$xN\u001d\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0007\t>,(\r\\3\u0002\rqJg.\u001b;?)\t)u\t\u0005\u0002G\u00015\ta\u0005C\u0003=\u0005\u0001\u0007Q(\u0001\u0004m_\u001e<WM\u001d\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bQa\u001d7gi)T\u0011AT\u0001\u0004_J<\u0017B\u0001)L\u0005\u0019aunZ4fe\u0006qAn\\4hS:<7i\u001c8uKb$X#A*\u0011\u0005Q;V\"A+\u000b\u0005Y\u0003\u0014a\u00027pO\u001eLgnZ\u0005\u00031V\u0013a\u0002T8hO&twmQ8oi\u0016DH/A\bm_\u001e<\u0017N\\4D_:$X\r\u001f;!\u0003U!W\rZ;qY&\u001c\u0017\r^5p]\u0012+(/\u0019;j_:,\u0012\u0001\u0018\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0003C~\n!bY8oGV\u0014(/\u001a8u\u0013\t\u0019gL\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002-\u0011,G-\u001e9mS\u000e\fG/[8o\tV\u0014\u0018\r^5p]\u0002\n\u0001&\\5yK\u0012\u001cE.[3oiN\u001cu.\\7b]\u0012$U\rZ;qY&\u001c\u0017\r^5p]R+7\u000f^\"bg\u0016$\u0012bZA\u0001\u0003\u001f\ti%!\u0018\u0015\u000b!,(\u0010 @\u0015\u0005%\u0004\bc\u00016l[6\t\u0001-\u0003\u0002mA\n1a)\u001e;ve\u0016\u0004\"A\u00108\n\u0005=|$\u0001B+oSRDQ!\u001d\u0005A\u0004I\f!!Z2\u0011\u0005)\u001c\u0018B\u0001;a\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003w\u0011\u0001\u0007q/A\u0005gSJ\u001cHoQ1mYB\u0011a\b_\u0005\u0003s~\u0012qAQ8pY\u0016\fg\u000eC\u0003|\u0011\u0001\u0007q/\u0001\u0006tK\u000e|g\u000eZ\"bY2DQ! \u0005A\u0002]\f\u0011\u0002\u001e5je\u0012\u001c\u0015\r\u001c7\t\u000b}D\u0001\u0019A<\u0002\u0015\u0019|WO\u001d;i\u0007\u0006dG\u000e\u0003\u00040\u0011\u0001\u0007\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u001d\u0002\u0017A\f'\u000f^5dSB\fg\u000e^\u0005\u0005\u0003\u001b\t9A\u0001\fQCJ$\u0018nY5qC:$H+Z:u\u0007>tG/\u001a=u\u0011\u001d\t\t\u0002\u0003a\u0001\u0003'\tQ\u0001]1sif\u0004B!!\u0006\u0002F9!\u0011qCA \u001d\u0011\tI\"!\u000f\u000f\t\u0005m\u00111\u0007\b\u0005\u0003;\tyC\u0004\u0003\u0002 \u00055b\u0002BA\u0011\u0003WqA!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O!\u0014A\u0002\u001fs_>$h(C\u00014\u0013\t\t$'\u0003\u00020a%\u0019\u0011\u0011\u0007\u0018\u0002\r\rd\u0017.\u001a8u\u0013\u0011\t)$a\u000e\u0002\u000f\tLg\u000eZ5oO*\u0019\u0011\u0011\u0007\u0018\n\t\u0005m\u0012QH\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\t)$a\u000e\n\t\u0005\u0005\u00131I\u0001\n!JLW.\u001b;jm\u0016TA!a\u000f\u0002>%!\u0011qIA%\u0005\u0015\u0001\u0016M\u001d;z\u0013\u0011\tY%!\u0010\u0003\u0013A\u0013\u0018.\\5uSZ,\u0007bBA(\u0011\u0001\u0007\u0011\u0011K\u0001\u0006I\u0016d\u0017-\u001f\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011q\u000b\u001d\u0002\tQLW.Z\u0005\u0005\u00037\n)F\u0001\bEK2\f\u00170T3dQ\u0006t\u0017n]7\t\r\u0005}\u0003\u00021\u0001]\u0003\u0015\u00198.Z<t\u0003a!W\r\\1z\r>\u0014xJ\u001a4tKRLeMU3rk&\u0014X\r\u001a\u000b\u0005\u0003K\nI\u0007F\u0002j\u0003OBQ!]\u0005A\u0004IDaaL\u0005A\u0002\u0005\r\u0011!H1tg\u0016\u0014H\u000fU1sifD\u0015m]!di&4XmQ8oiJ\f7\r^:\u0015\u0011\u0005=\u00141OA;\u0003o\"2![A9\u0011\u0015\t(\u0002q\u0001s\u0011\u0019y#\u00021\u0001\u0002\u0004!9\u0011\u0011\u0003\u0006A\u0002\u0005M\u0001bBA=\u0015\u0001\u0007\u00111P\u0001\u0014]>|e-Q2uSZ,7i\u001c8ue\u0006\u001cGo\u001d\t\u0004}\u0005u\u0014bAA@\u007f\t\u0019\u0011J\u001c;\u0002QM,(-\\5u%\u0016\fX/Z:u\u0003:$\u0017i]:feR\u001cu.\u001c9mKRLwN\\!dG\u0016\u0004H/\u001a3\u0015\u0011\u0005\u0015\u0015\u0011VAV\u0003\u007f#B!a\"\u0002(B!!n[AE!\u0011\tY)!)\u000f\t\u00055\u0015Q\u0014\b\u0005\u0003\u001f\u000bYJ\u0004\u0003\u0002\u0012\u0006ee\u0002BAJ\u0003/sA!!\b\u0002\u0016&\u0011QFL\u0005\u0003W1J!!\u000f\u0016\n\u0007\u0005%\u0001(\u0003\u0003\u0002 \u0006\u001d\u0011A\u0006)beRL7-\u001b9b]R$Vm\u001d;D_:$X\r\u001f;\n\t\u0005\r\u0016Q\u0015\u0002\u0013\u0007>l\u0007\u000f\\3uS>t'+Z:q_:\u001cXM\u0003\u0003\u0002 \u0006\u001d\u0001\"B9\f\u0001\b\u0011\bBB\u0018\f\u0001\u0004\t\u0019\u0001C\u0004\u0002..\u0001\r!a,\u0002\u000fI,\u0017/^3tiB!\u0011\u0011WA^\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016AG2p[6\fg\u000eZ0tk\nl\u0017n]:j_:|6/\u001a:wS\u000e,'bAA]Y\u0005\u0011a/M\u0005\u0005\u0003{\u000b\u0019LA\u0007Tk\nl\u0017\u000e\u001e*fcV,7\u000f\u001e\u0005\b\u0003\u0003\\\u0001\u0019AAb\u0003\u001d\u0001\u0018M\u001d;jKN\u0004RAPAc\u0003'I1!a2@\u0005)a$/\u001a9fCR,GMP\u00010gV\u0014W.\u001b;B]\u0012<\u0016-\u001b;SKF,Xm\u001d;B]\u0012\f5o]3si\u000e{W\u000e\u001d7fi&|g.Q2dKB$X\r\u001a\u000b\t\u0003\u001b\f\t.a5\u0002bR!\u0011qQAh\u0011\u0015\tH\u0002q\u0001s\u0011\u0019yC\u00021\u0001\u0002\u0004!9\u0011Q\u0016\u0007A\u0002\u0005U\u0007\u0003BAl\u0003;l!!!7\u000b\t\u0005m\u0017qW\u0001\u0010G>lW.\u00198e?N,'O^5dK&!\u0011q\\Am\u0005Q\u0019VOY7ji\u0006sGmV1jiJ+\u0017/^3ti\"9\u0011\u0011\u0019\u0007A\u0002\u0005\r\u0017!I:vE6LGOU3rk\u0016\u001cH/\u00118e\u0003N\u001cXM\u001d;Ts:\u001cg)Y5mkJ,G\u0003DAt\u0003W\fi/a<\u0003\u0012\t\u0005BcA5\u0002j\")\u0011/\u0004a\u0002e\"1q&\u0004a\u0001\u0003\u0007Aq!!,\u000e\u0001\u0004\ty\u000bC\u0004\u0002r6\u0001\r!a=\u0002\u0011\u001d\u0014\boY\"pI\u0016\u0004B!!>\u0003\f9!\u0011q\u001fB\u0003\u001d\u0011\tI0a@\u000f\t\u0005\r\u00121`\u0005\u0003\u0003{\f!![8\n\t\t\u0005!1A\u0001\u0005OJ\u00048M\u0003\u0002\u0002~&!!q\u0001B\u0005\u0003\u0019\u0019F/\u0019;vg*!!\u0011\u0001B\u0002\u0013\u0011\u0011iAa\u0004\u0003\t\r{G-\u001a\u0006\u0005\u0005\u000f\u0011I\u0001C\u0004\u0003\u00145\u0001\rA!\u0006\u0002\u0013\u0015\u0014(o\u001c:D_\u0012,\u0007\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tm\u0001'A\u0003feJ|'/\u0003\u0003\u0003 \te!!C#se>\u00148i\u001c3f\u0011%\u0011\u0019#\u0004I\u0001\u0002\u0004\u0011)#A\rbI\u0012LG/[8oC2,%O]8s\u0003N\u001cXM\u001d;j_:\u001c\bC\u0002 \u0003(\t-R.C\u0002\u0003*}\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\t5\"Q\u0007\b\u0005\u0005_\u0011\u0019D\u0004\u0003\u0002$\tE\u0012\"\u0001!\n\u0007\u0005mr(\u0003\u0003\u00038\te\"!\u0003+ie><\u0018M\u00197f\u0015\r\tYdP\u0001,gV\u0014W.\u001b;SKF,Xm\u001d;B]\u0012\f5o]3siNKhn\u0019$bS2,(/\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!q\b\u0016\u0005\u0005K\u0011\te\u000b\u0002\u0003DA!!Q\tB(\u001b\t\u00119E\u0003\u0003\u0003J\t-\u0013!C;oG\",7m[3e\u0015\r\u0011ieP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B)\u0005\u000f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003)\u001aXOY7ji\u0006sGmV1jiJ+\u0017/^3ti\u0006sG-Q:tKJ$H)\u001a3va2L7-\u0019;j_:$\"Ba\u0016\u0003\\\tu#q\fBA)\rI'\u0011\f\u0005\u0006c>\u0001\u001dA\u001d\u0005\u0007_=\u0001\r!a\u0001\t\u000f\u00055v\u00021\u0001\u0002V\"9!\u0011M\bA\u0002\t\r\u0014\u0001F1dG\u0016\u0004H/\u001a3Tk\nl\u0017n]:j_:LE\r\u0005\u0003\u0003f\tmd\u0002\u0002B4\u0005krAA!\u001b\u0003p9!\u0011q\u0004B6\u0013\r\u0011i\u0007M\u0001\u0003Y\u001aLAA!\u001d\u0003t\u0005!A-\u0019;b\u0015\r\u0011i\u0007M\u0005\u0005\u0005o\u0012I(A\u0002SK\u001aTAA!\u001d\u0003t%!!Q\u0010B@\u00051\u0019VOY7jgNLwN\\%e\u0015\u0011\u00119H!\u001f\t\u000f\t\ru\u00021\u0001\u0003\u0006\u0006q\u0011mY2faR,Gm\u00144gg\u0016$\b\u0003\u0002BD\u0005\u001bk!A!#\u000b\t\t-\u0015qW\u0001\u000eY\u0016$w-\u001a:`_\u001a47/\u001a;\n\t\t=%\u0011\u0012\u0002\r\u0019\u0016$w-\u001a:PM\u001a\u001cX\r^\u0001$gV\u0014W.\u001b;SKF,Xm\u001d;B]\u0012\f5o]3si\u0012+G-\u001e9mS\u000e\fG/[8o)1\u0011)J!'\u0003\u001c\nu%q\u0014BQ)\u0011\t9Ia&\t\u000bE\u0004\u00029\u0001:\t\r=\u0002\u0002\u0019AA\u0002\u0011\u001d\ti\u000b\u0005a\u0001\u0003_CqA!\u0019\u0011\u0001\u0004\u0011\u0019\u0007C\u0004\u0003\u0004B\u0001\rA!\"\t\u000f\u0005\u0005\u0007\u00031\u0001\u0002D\u00061\u0012m]:feR\u001cu.\u001c9mKRLwN\\*uCR,8\u000fF\u0004n\u0005O\u0013YLa0\t\u000f\t%\u0016\u00031\u0001\u0003,\u0006i!/Z9vKN$8\u000b\u001e:j]\u001e\u0004BA!,\u00036:!!q\u0016BY!\r\t\u0019cP\u0005\u0004\u0005g{\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00038\ne&AB*ue&twMC\u0002\u00034~BqA!0\u0012\u0001\u0004\tI)\u0001\u0005sKN\u0004xN\\:f\u0011\u001d\u0011\t-\u0005a\u0001\u0005\u0007\f1b\u001d;biV\u001c8i\u001c3fgB)a(!2\u0002t\u0006q\u0013m]:feR$U\rZ;qY&\u001c\u0017\r^3e'V\u0014W.[:tS>t\u0017\nZ!oI>3gm]3u\u001f:,%O]8s)\u001di'\u0011\u001aBf\u0005\u001fDqA!\u0019\u0013\u0001\u0004\u0011\u0019\u0007C\u0004\u0003NJ\u0001\rA!\"\u00021\u0005\u001c7-\u001a9uK\u0012\u001cu.\u001c9mKRLwN\\(gMN,G\u000fC\u0004\u0003RJ\u0001\rAa\u000b\u0002\u0003Q\f1'Y:tKJ$H)\u001a3va2L7-\u0019;fIN+(-\\5tg&|g.\u00133B]\u0012|eMZ:fi>s7i\\7qY\u0016$\u0018n\u001c8\u0015\u000f5\u00149N!7\u0003\\\"9!\u0011M\nA\u0002\t\r\u0004b\u0002Bg'\u0001\u0007!Q\u0011\u0005\b\u0005{\u001b\u0002\u0019AAE\u0003\u0011\n7o]3si\u0016C\u0018n\u001d;j]\u001e\u001cVOY7jgNLwN\\%e\u001f:lU\r^1eCR\fG#B7\u0003b\n-\bb\u0002Br)\u0001\u0007!Q]\u0001\t[\u0016$\u0018\rZ1uCBA!Q\u0016Bt\u0005W\u0013Y+\u0003\u0003\u0003j\ne&aA'ba\"9!\u0011\r\u000bA\u0002\t\r\u0014\u0001K1tg\u0016\u0014H/\u0012=jgRLgnZ\"p[BdW\r^5p]>3gm]3u\u001f:lU\r^1eCR\fG#B7\u0003r\nM\bb\u0002Br+\u0001\u0007!Q\u001d\u0005\b\u0005\u001b,\u0002\u0019\u0001BC\u0003\u0001\u001aXOY7jiJ+\u0017/^3ti\u0006sG-Q:tKJ$8i\\7qY\u0016$\u0018n\u001c8\u0015\u0011\te8QAB\u0004\u0007\u0013!BAa?\u0003\u0000R!\u0011q\u0011B\u007f\u0011\u0015\th\u0003q\u0001s\u0011\u001d\u0019\tA\u0006a\u0001\u0007\u0007\tQ$\u00193eSRLwN\\1m\u0007>l\u0007\u000f\\3uS>t\u0017i]:feRLwN\u001c\t\u0007}\t\u001d\u0012\u0011R7\t\r=2\u0002\u0019AA\u0002\u0011\u001d\tiK\u0006a\u0001\u0003_Cq!!1\u0017\u0001\u0004\t\u0019-A\u0014tk\nl\u0017\u000e^!oI^\u000b\u0017\u000e\u001e*fcV,7\u000f^!oI\u0006\u001b8/\u001a:u\u0007>l\u0007\u000f\\3uS>tG\u0003CB\b\u0007/\u0019Iba\u0007\u0015\t\rE1Q\u0003\u000b\u0005\u0003\u000f\u001b\u0019\u0002C\u0003r/\u0001\u000f!\u000fC\u0004\u0004\u0002]\u0001\raa\u0001\t\r=:\u0002\u0019AA\u0002\u0011\u001d\tik\u0006a\u0001\u0003+Dq!!1\u0018\u0001\u0004\t\u0019-\u0001\u0010tk\nl\u0017\u000e\u001e*fcV,7\u000f^!oI\u001aKg\u000eZ\"p[BdW\r^5p]RA1\u0011EB\u0013\u0007O\u0019I\u0003\u0006\u0003\u0002\b\u000e\r\u0002\"B9\u0019\u0001\b\u0011\bBB\u0018\u0019\u0001\u0004\t\u0019\u0001C\u0004\u0002.b\u0001\r!a,\t\u000f\u0005\u0005\u0007\u00041\u0001\u0002DRA1QFB\u0019\u0007g\u0019)\u0004\u0006\u0003\u0002\b\u000e=\u0002\"B9\u001a\u0001\b\u0011\bBB\u0018\u001a\u0001\u0004\t\u0019\u0001C\u0004\u0002.f\u0001\r!!6\t\u000f\u0005\u0005\u0017\u00041\u0001\u0002D\u0006i1/\u001e2nSR\u0014V-];fgR$Baa\u000f\u0004FQ!1QHB\")\u0011\u0019yd!\u0011\u0011\t)\\'Q\u0011\u0005\u0006cj\u0001\u001dA\u001d\u0005\b\u0003[S\u0002\u0019AAX\u0011\u0019y#\u00041\u0001\u0002\u0004\u0005!\u0012MY:pYV$X\rT3eO\u0016\u0014xJ\u001a4tKR$BA!\"\u0004L!91QJ\u000eA\u0002\t-\u0016!\u0002<bYV,\u0017AE;qI\u0006$XmU;c[&\u001c8/[8o\u0013\u0012$b!a,\u0004T\rU\u0003bBAW9\u0001\u0007\u0011q\u0016\u0005\b\u0007/b\u0002\u0019\u0001B2\u00031\u0019XOY7jgNLwN\\%e)\u0019\t)na\u0017\u0004^!9\u0011QV\u000fA\u0002\u0005U\u0007bBB0;\u0001\u0007!1M\u0001\u0016C\u000e\u001cW\r\u001d;fIN+(-\\5tg&|g.\u001332\u0003m)\b\u000fZ1uK^KG\u000f\u001b$sKND7+\u001e2nSN\u001c\u0018n\u001c8JIR!\u0011qVB3\u0011\u001d\tiK\ba\u0001\u0003_#B!!6\u0004j!9\u0011QV\u0010A\u0002\u0005U\u0017a\u00048foN+(-\\5tg&|g.\u00133\u0015\u0005\t\r\u0014\u0001\u0005:v]^KG\u000f\u001b+j[\u0016lu\u000eZ3m)\u0011\u0019\u0019ha \u0015\t\rU4\u0011\u0010\u000b\u0004S\u000e]\u0004\"B9\"\u0001\b\u0011\bbBB>C\u0001\u00071QP\u0001\u0017i\u0016\u001cHoV5uQ\u0012+G.Y=NK\u000eD\u0017M\\5t[B)aHa\n]S\"91\u0011Q\u0011A\u0002\r\r\u0015\u0001\u00049beRL7-\u001b9b]R\u001c\bC\u0002B\u0017\u0007\u000b\u000b\u0019!\u0003\u0003\u0004\b\ne\"aA*fc\u00069\"/\u001e8XSRDW\u000b\u001d3bi\u0016$G+[7f\u001b>$W\r\u001c\u000b\u0007\u0007\u001b\u001bIka+\u0015\t\r=51\u0013\u000b\u0004S\u000eE\u0005\"B9#\u0001\b\u0011\bbBBKE\u0001\u00071qS\u0001\u0005i\u0016\u001cH\u000f\u0005\u0004?\u0005O\u0019I*\u001b\t\u0005\u00077\u001b)+\u0004\u0002\u0004\u001e*!1qTBQ\u0003e\u0019wN\u001c4jO~k\u0017M\\1hK6,g\u000e^0tKJ4\u0018nY3\u000b\t\r\r\u0016qW\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0007O\u001biJA\u0005US6,Wj\u001c3fY\"91\u0011\u0011\u0012A\u0002\r\r\u0005bBBWE\u0001\u00071qV\u0001\u0010i&lW-T8eK2,\u0006\u000fZ1uKB9aHa\n\u0004\u001a\u000ee\u0015a\t;ssRKW.Z'pI\u0016dW\u000b\u001d3bi\u0016|e.\u00117m!\u0006\u0014H/[2ja\u0006tGo\u001d\u000b\u0007\u0007k\u001b\tma1\u0015\t\r]6q\u0018\t\u0005U.\u001cI\fE\u0004?\u0007w\u001bI*a\u0001\n\u0007\ruvH\u0001\u0004UkBdWM\r\u0005\u0006c\u000e\u0002\u001dA\u001d\u0005\b\u0007\u0003\u001b\u0003\u0019ABB\u0011\u001d\u0019ik\ta\u0001\u0007\u000b\u0004rA\u0010B\u0014\u0003\u0007\u00199\r\u0005\u0003kW\u000ee\u0015AJ3yiJ\f7\r\u001e#ve\u0006$\u0018n\u001c8Ge>lG)\u001a3va2L7-\u0019;j_:\u0004VM]5pIR9Al!4\u0004X\u000em\u0007bBBhI\u0001\u00071\u0011[\u0001 I\u0016$W\u000f\u001d7jG\u0006$\u0018n\u001c8D_6\u0004H.\u001a;j_:\u0014Vm\u001d9p]N,\u0007#\u0002 \u0004T\u0006%\u0015bABk\u007f\t1q\n\u001d;j_:Daa!7%\u0001\u0004a\u0016a\u00043fM\u0006,H\u000e\u001e#ve\u0006$\u0018n\u001c8\t\r\u0005}C\u00051\u0001]\u0001")
public final class CommandDeduplicationIT
extends LedgerTestSuite {
    private final double timeoutScaleFactor;
    public final Logger com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$logger;
    private final LoggingContext com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$loggingContext;
    private final FiniteDuration com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration;

    public LoggingContext com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$loggingContext() {
        return this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$loggingContext;
    }

    public FiniteDuration com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration() {
        return this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration;
    }

    public Future<BoxedUnit> com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$mixedClientsCommandDeduplicationTestCase(ParticipantTestContext ledger, Object party, DelayMechanism delay, FiniteDuration skews, boolean firstCall, boolean secondCall, boolean thirdCall, boolean fourthCall, ExecutionContext ec) {
        SubmitAndWaitRequest submitAndWaitRequest = (SubmitAndWaitRequest)ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$15 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$15).commands()).deduplicationTime().$colon$eq((Object)ProtobufConverters$.MODULE$.ScalaDurationConverter(this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration()).asProtobuf())}));
        SubmitRequest submitRequest = (SubmitRequest)ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$16 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$16).commands()).commandId().$colon$eq((Object)submitAndWaitRequest.getCommands().commandId()), (Function1 & Serializable)x$17 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$17).commands()).deduplicationTime().$colon$eq((Object)ProtobufConverters$.MODULE$.ScalaDurationConverter(this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration()).asProtobuf())}));
        return this.submitAndAssertAccepted$1(firstCall, ledger, submitAndWaitRequest, party, ec, submitRequest).flatMap((Function1 & Serializable)firstAcceptedCommand -> this.submitAndAssertDeduplicated$1(secondCall, (String)Ref$.MODULE$.LedgerString().assertFromString(firstAcceptedCommand.completion().submissionId()), firstAcceptedCommand.offset(), ledger, submitAndWaitRequest, ec, submitRequest, party).map((Function1 & Serializable)duplicateResponse -> {
            FiniteDuration deduplicationDurationFromPeriod = this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$extractDurationFromDeduplicationPeriod((Option<ParticipantTestContext.CompletionResponse>)duplicateResponse, this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration(), skews);
            return new scala.Tuple2(duplicateResponse, (Object)deduplicationDurationFromPeriod);
        }, ec).flatMap((Function1 & Serializable)x$24 -> {
            scala.Tuple2 tuple2 = x$24;
            if (tuple2 != null) {
                FiniteDuration deduplicationDurationFromPeriod = (FiniteDuration)tuple2._2();
                FiniteDuration x$1 = deduplicationDurationFromPeriod.$plus(skews).$plus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
                String x$2 = new StringBuilder(66).append("Deduplication period expires and request is accepted for command ").append(submitRequest.getCommands()).append(".").toString();
                DelayMechanism x$3 = delay;
                FiniteDuration x$4 = FutureAssertions$.MODULE$.succeedsEventually$default$1();
                Function0 & Serializable x$5 = (Function0 & Serializable)() -> this.submitAndAssertAccepted$1(thirdCall, ledger, submitAndWaitRequest, party, ec, submitRequest);
                return FutureAssertions$.MODULE$.succeedsEventually(x$4, x$1, x$3, x$2, (Function0)x$5, ec, this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$loggingContext()).map((Function1 & Serializable)eventuallyAccepted -> {
                    Predef$.MODULE$.assert(java.time.Duration.between(firstAcceptedCommand.recordTime(), eventuallyAccepted.recordTime()).toNanos() > this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration().toNanos(), (Function0 & Serializable)() -> new StringBuilder(154).append("Interval between accepted commands is smaller than the deduplication duration. First accepted command record time: ").append(firstAcceptedCommand.recordTime()).append(". Second accepted command record time: ").append(eventuallyAccepted.recordTime()).toString());
                    BoxedUnit x$20 = BoxedUnit.UNIT;
                    return new scala.Tuple2(eventuallyAccepted, (Object)x$20);
                }, ec).flatMap((Function1 & Serializable)x$23 -> {
                    scala.Tuple2 tuple2 = x$23;
                    if (tuple2 != null) {
                        ParticipantTestContext.CompletionResponse eventuallyAccepted = (ParticipantTestContext.CompletionResponse)tuple2._1();
                        return this.submitAndAssertDeduplicated$1(fourthCall, (String)Ref$.MODULE$.LedgerString().assertFromString(eventuallyAccepted.completion().submissionId()), eventuallyAccepted.offset(), ledger, submitAndWaitRequest, ec, submitRequest, party).flatMap((Function1 & Serializable)x$22 -> {
                            Option option = x$22;
                            return this.assertPartyHasActiveContracts(ledger, party, 2, ec).map((Function1 & Serializable)x$21 -> {
                                boxedUnit = x$21;
                                return BoxedUnit.UNIT;
                            }, ec);
                        }, ec);
                    }
                    throw new MatchError((Object)tuple2);
                }, ec);
            }
            throw new MatchError((Object)tuple2);
        }, ec), ec);
    }

    public Future<BoxedUnit> com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$delayForOffsetIfRequired(ParticipantTestContext ledger, ExecutionContext ec) {
        CommandDeduplicationPeriodSupport.OffsetSupport offsetSupport = ledger.features().commandDeduplicationFeatures().getDeduplicationPeriodSupport().offsetSupport();
        if (CommandDeduplicationPeriodSupport.OffsetSupport$.OFFSET_NATIVE_SUPPORT$.MODULE$.equals(offsetSupport)) {
            return Future$.MODULE$.unit();
        }
        if (CommandDeduplicationPeriodSupport.OffsetSupport$.OFFSET_CONVERT_TO_DURATION$.MODULE$.equals(offsetSupport)) {
            return ledger.getTimeModel().flatMap((Function1 & Serializable)response -> ledger.delayMechanism().delayBy((scala.concurrent.duration.Duration)Durations$.MODULE$.asFiniteDuration(package.IntMult$.MODULE$.$times$extension(package$.MODULE$.IntMult(2), ProtobufConverters$.MODULE$.ProtobufDurationConverter(response.getTimeModel().getMaxSkew()).asScala().$plus(ProtobufConverters$.MODULE$.ProtobufDurationConverter(response.getTimeModel().getMinSkew()).asScala())))), ec);
        }
        if (offsetSupport instanceof CommandDeduplicationPeriodSupport.OffsetSupport$.Unrecognized ? true : CommandDeduplicationPeriodSupport.OffsetSupport$.OFFSET_NOT_SUPPORTED$.MODULE$.equals(offsetSupport)) {
            return Future$.MODULE$.unit();
        }
        throw new MatchError((Object)offsetSupport);
    }

    public Future<BoxedUnit> assertPartyHasActiveContracts(ParticipantTestContext ledger, Object party, int noOfActiveContracts, ExecutionContext ec) {
        return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)contracts -> {
            Predef$.MODULE$.assert(contracts.length() == noOfActiveContracts, (Function0 & Serializable)() -> new StringBuilder(59).append("Expected ").append(noOfActiveContracts$1).append(" active contracts for ").append(party$7).append(" but found ").append(contracts.length()).append(" active contracts").toString());
            return BoxedUnit.UNIT;
        }, ec);
    }

    public Future<ParticipantTestContext.CompletionResponse> submitRequestAndAssertCompletionAccepted(ParticipantTestContext ledger, SubmitRequest request, Seq<Object> parties, ExecutionContext ec) {
        return this.submitRequestAndAssertCompletion(ledger, request, parties, (Function1<ParticipantTestContext.CompletionResponse, BoxedUnit>)(Function1 & Serializable)completion -> {
            this.assertCompletionStatus(request.toString(), completion, (Seq<Status.Code>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Status.Code[]{Status.Code.OK}));
            return BoxedUnit.UNIT;
        }, ec);
    }

    public Future<ParticipantTestContext.CompletionResponse> submitAndWaitRequestAndAssertCompletionAccepted(ParticipantTestContext ledger, SubmitAndWaitRequest request, Seq<Object> parties, ExecutionContext ec) {
        return this.submitAndWaitRequestAndAssertCompletion(ledger, request, parties, (Function1<ParticipantTestContext.CompletionResponse, BoxedUnit>)(Function1 & Serializable)completion -> {
            this.assertCompletionStatus(request.toString(), completion, (Seq<Status.Code>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Status.Code[]{Status.Code.OK}));
            return BoxedUnit.UNIT;
        }, ec);
    }

    public Future<BoxedUnit> com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$submitRequestAndAssertSyncFailure(ParticipantTestContext ledger, SubmitRequest request, Status.Code grpcCode, ErrorCode errorCode, Function1<Throwable, BoxedUnit> additionalErrorAssertions, ExecutionContext ec) {
        return Assertions$.MODULE$.futureAssertions(ledger.submit(request)).mustFail(new StringBuilder(35).append("Request expected to fail with code ").append(grpcCode).toString(), ec).map((Function1 & Serializable)x$47 -> {
            Assertions$.MODULE$.assertGrpcError(x$47, errorCode, (Option)None$.MODULE$, true, additionalErrorAssertions);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public Future<BoxedUnit> submitAndWaitRequestAndAssertDeduplication(ParticipantTestContext ledger, SubmitAndWaitRequest request, String acceptedSubmissionId, LedgerOffset acceptedOffset, ExecutionContext ec) {
        return Assertions$.MODULE$.futureAssertions(ledger.submitRequestAndTolerateGrpcError((ErrorCode)ConsistencyErrors.SubmissionAlreadyInFlight$.MODULE$, (Function1 & Serializable)x$48 -> x$48.submitAndWaitForTransaction(request))).mustFail("Request was accepted but we were expecting it to fail with a duplicate error", ec).map((Function1 & Serializable)x$49 -> {
            Assertions$.MODULE$.assertGrpcError(x$49, (ErrorCode)ConsistencyErrors.DuplicateCommand$.MODULE$, (Option)None$.MODULE$, true, (Function1 & Serializable)x$50 -> {
                $this.assertDeduplicatedSubmissionIdAndOffsetOnError(acceptedSubmissionId$2, acceptedOffset$1, x$50);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }, ec);
    }

    public Future<ParticipantTestContext.CompletionResponse> submitRequestAndAssertDeduplication(ParticipantTestContext ledger, SubmitRequest request, String acceptedSubmissionId, LedgerOffset acceptedOffset, Seq<Object> parties, ExecutionContext ec) {
        return this.submitRequestAndAssertCompletion(ledger, request, parties, (Function1<ParticipantTestContext.CompletionResponse, BoxedUnit>)(Function1 & Serializable)completion -> {
            CommandDeduplicationIT.$anonfun$submitRequestAndAssertDeduplication$1(this, request, acceptedSubmissionId, acceptedOffset, completion);
            return BoxedUnit.UNIT;
        }, ec);
    }

    private void assertCompletionStatus(String requestString, ParticipantTestContext.CompletionResponse response, Seq<Status.Code> statusCodes) {
        Predef$.MODULE$.assert(statusCodes.exists((Function1 & Serializable)x$51 -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationIT.$anonfun$assertCompletionStatus$1(response, x$51))), (Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(131).append("Expecting completion with status code(s) ").append(statusCodes.mkString(",")).append(" but completion has status ").append(response.completion().status()).append(".\n         |Request: ").append(requestString).append("\n         |Response: ").append(response).append("\n         |Metadata: ").append(Assertions$.MODULE$.extractErrorInfoMetadata(GrpcStatus$.MODULE$.toJavaProto(response.completion().getStatus()))).toString())));
    }

    private void assertDeduplicatedSubmissionIdAndOffsetOnError(String acceptedSubmissionId, LedgerOffset acceptedCompletionOffset, Throwable t) {
        Throwable throwable = t;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            Map metadata = Assertions$.MODULE$.extractErrorInfoMetadata((Throwable)exception);
            this.assertExistingSubmissionIdOnMetadata((Map<String, String>)metadata, acceptedSubmissionId);
            this.assertExistingCompletionOffsetOnMetadata((Map<String, String>)metadata, acceptedCompletionOffset);
            return;
        }
    }

    private void assertDeduplicatedSubmissionIdAndOffsetOnCompletion(String acceptedSubmissionId, LedgerOffset acceptedCompletionOffset, ParticipantTestContext.CompletionResponse response) {
        Map metadata = Assertions$.MODULE$.extractErrorInfoMetadata(GrpcStatus$.MODULE$.toJavaProto(response.completion().getStatus()));
        this.assertExistingSubmissionIdOnMetadata((Map<String, String>)metadata, acceptedSubmissionId);
        this.assertExistingCompletionOffsetOnMetadata((Map<String, String>)metadata, acceptedCompletionOffset);
    }

    private void assertExistingSubmissionIdOnMetadata(Map<String, String> metadata, String acceptedSubmissionId) {
        metadata.get((Object)"existing_submission_id").foreach((Function1 & Serializable)metadataExistingSubmissionId -> {
            Assertions$.MODULE$.assertEquals("submission ID mismatch", (Object)metadataExistingSubmissionId, (Object)acceptedSubmissionId);
            return BoxedUnit.UNIT;
        });
    }

    private void assertExistingCompletionOffsetOnMetadata(Map<String, String> metadata, LedgerOffset acceptedCompletionOffset) {
        metadata.get((Object)"completion_offset").foreach((Function1 & Serializable)offset -> {
            Assertions$.MODULE$.assertEquals("completion offset mismatch", (Object)this.absoluteLedgerOffset(offset), (Object)acceptedCompletionOffset);
            return BoxedUnit.UNIT;
        });
    }

    private Future<ParticipantTestContext.CompletionResponse> submitRequestAndAssertCompletion(ParticipantTestContext ledger, SubmitRequest request, Seq<Object> parties, Function1<ParticipantTestContext.CompletionResponse, BoxedUnit> additionalCompletionAssertion, ExecutionContext ec) {
        return ledger.submitRequestAndTolerateGrpcError((ErrorCode)ConsistencyErrors.SubmissionAlreadyInFlight$.MODULE$, (Function1 & Serializable)x$52 -> this.submitRequestAndFindCompletion((ParticipantTestContext)x$52, request, parties, ec)).map((Function1 & Serializable)response -> {
            additionalCompletionAssertion.apply(response);
            return response;
        }, ec);
    }

    private Future<ParticipantTestContext.CompletionResponse> submitAndWaitRequestAndAssertCompletion(ParticipantTestContext ledger, SubmitAndWaitRequest request, Seq<Object> parties, Function1<ParticipantTestContext.CompletionResponse, BoxedUnit> additionalCompletionAssertion, ExecutionContext ec) {
        return this.submitRequestAndFindCompletion(ledger, request, parties, ec).map((Function1 & Serializable)response -> {
            additionalCompletionAssertion.apply(response);
            return response;
        }, ec);
    }

    public Future<ParticipantTestContext.CompletionResponse> submitRequestAndFindCompletion(ParticipantTestContext ledger, SubmitRequest request, Seq<Object> parties, ExecutionContext ec) {
        return this.submitRequest(ledger, request, ec).flatMap((Function1 & Serializable)ledgerEnd -> ledger.findCompletion(ledger.completionStreamRequest(ledgerEnd, parties), (Function1 & Serializable)completion -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationIT.$anonfun$submitRequestAndFindCompletion$2(request, completion))).map((Function1 & Serializable)x$54 -> x$54.toList(), ec), ec).map((Function1 & Serializable)completions -> (ParticipantTestContext.CompletionResponse)Assertions$.MODULE$.assertSingleton("Expected only one completion", (Seq)completions), ec);
    }

    public Future<ParticipantTestContext.CompletionResponse> submitRequestAndFindCompletion(ParticipantTestContext ledger, SubmitAndWaitRequest request, Seq<Object> parties, ExecutionContext ec) {
        return ledger.submitAndWait(request).flatMap((Function1 & Serializable)x$55 -> ledger.findCompletion(ledger.completionStreamRequest(ledger.completionStreamRequest$default$1(), parties), (Function1 & Serializable)completion -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationIT.$anonfun$submitRequestAndFindCompletion$7(request, completion))).map((Function1 & Serializable)x$57 -> x$57.toList(), ec), ec).map((Function1 & Serializable)completions -> {
            Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((ParticipantTestContext.CompletionResponse)completions.head()).offset().getAbsolute())), (Function0 & Serializable)() -> "Expected a populated completion offset");
            return (ParticipantTestContext.CompletionResponse)Assertions$.MODULE$.assertSingleton("Expected only one completion", (Seq)completions);
        }, ec);
    }

    public Future<LedgerOffset> submitRequest(ParticipantTestContext ledger, SubmitRequest request, ExecutionContext ec) {
        return ledger.currentEnd().flatMap((Function1 & Serializable)ledgerEnd -> ledger.submit(request).map((Function1 & Serializable)x$58 -> {
            BoxedUnit boxedUnit = x$58;
            return ledgerEnd;
        }, ec), ec);
    }

    public Function1<Throwable, BoxedUnit> com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$submitRequestAndAssertSyncFailure$default$5() {
        return (Function1 & Serializable)x$46 -> {
            CommandDeduplicationIT.$anonfun$submitRequestAndAssertSyncFailure$default$5$1(x$46);
            return BoxedUnit.UNIT;
        };
    }

    private LedgerOffset absoluteLedgerOffset(String value) {
        return new LedgerOffset((LedgerOffset.Value)new LedgerOffset.Value$.Absolute(value));
    }

    public SubmitRequest com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(SubmitRequest request, String submissionId) {
        return (SubmitRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$59 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$59).commands()).submissionId().$colon$eq((Object)submissionId)}));
    }

    public SubmitAndWaitRequest com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(SubmitAndWaitRequest request, String acceptedSubmissionId1) {
        return (SubmitAndWaitRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$60 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$60).commands()).submissionId().$colon$eq((Object)acceptedSubmissionId1)}));
    }

    public SubmitRequest com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(SubmitRequest request) {
        return (SubmitRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$61 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$61).commands()).submissionId().$colon$eq((Object)this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId())}));
    }

    public SubmitAndWaitRequest com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(SubmitAndWaitRequest request) {
        return (SubmitAndWaitRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$62 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$62).commands()).submissionId().$colon$eq((Object)this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId())}));
    }

    public String com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId() {
        return SubmissionIdGenerator.Random$.MODULE$.generate();
    }

    public Future<BoxedUnit> com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$runWithTimeModel(Seq<ParticipantTestContext> participants, Function1<FiniteDuration, Future<BoxedUnit>> testWithDelayMechanism, ExecutionContext ec) {
        Duration skew = ProtobufConverters$.MODULE$.ScalaDurationConverter(Durations$.MODULE$.scaleDuration(new package.DurationInt(package$.MODULE$.DurationInt(3)).second(), this.timeoutScaleFactor)).asProtobuf();
        return this.runWithUpdatedTimeModel(participants, (Function1<TimeModel, TimeModel>)(Function1 & Serializable)x$63 -> (TimeModel)x$63.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$64 -> TimeModel$.MODULE$.TimeModelLens(x$64).minSkew().$colon$eq((Object)skew), (Function1 & Serializable)x$65 -> TimeModel$.MODULE$.TimeModelLens(x$65).maxSkew().$colon$eq((Object)skew)})), (Function1<TimeModel, Future<BoxedUnit>>)(Function1 & Serializable)timeModel -> {
            FiniteDuration minMaxSkewSum = Durations$.MODULE$.asFiniteDuration(ProtobufConverters$.MODULE$.ProtobufDurationConverter(timeModel.getMinSkew()).asScala().$plus(ProtobufConverters$.MODULE$.ProtobufDurationConverter(timeModel.getMaxSkew()).asScala()));
            return (Future)testWithDelayMechanism.apply((Object)minMaxSkewSum);
        }, ec);
    }

    private Future<BoxedUnit> runWithUpdatedTimeModel(Seq<ParticipantTestContext> participants, Function1<TimeModel, TimeModel> timeModelUpdate, Function1<TimeModel, Future<BoxedUnit>> test, ExecutionContext ec) {
        ParticipantTestContext anyParticipant = (ParticipantTestContext)participants.head();
        return anyParticipant.getTimeModel().flatMap((Function1 & Serializable)timeModel -> anyParticipant.time().map((Function1 & Serializable)time -> {
            TimeModel updatedModel = (TimeModel)timeModelUpdate.apply((Object)timeModel.getTimeModel());
            return new scala.Tuple2(time, (Object)updatedModel);
        }, ec).flatMap((Function1 & Serializable)x$73 -> {
            scala.Tuple2 tuple2 = x$73;
            if (tuple2 != null) {
                Instant time = (Instant)tuple2._1();
                TimeModel updatedModel = (TimeModel)tuple2._2();
                return this.tryTimeModelUpdateOnAllParticipants(participants, (Function1<ParticipantTestContext, Future<TimeModel>>)(Function1 & Serializable)x$68 -> x$68.setTimeModel(time.plusSeconds(1L), timeModel.configurationGeneration(), updatedModel).map((Function1 & Serializable)x$69 -> updatedModel, ec), ec).recover((PartialFunction)new Serializable(this, (GetTimeModelResponse)timeModel, anyParticipant){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ CommandDeduplicationIT $outer;
                    private final GetTimeModelResponse timeModel$1;
                    private final ParticipantTestContext anyParticipant$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Option option;
                        A1 A1 = x1;
                        if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                            Throwable exception = (Throwable)option.get();
                            this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$logger.warn("Failed to update time model for test. WIll run test with already configured time model", exception);
                            return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.timeModel$1.getTimeModel()), (Object)this.anyParticipant$1);
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Option option;
                        Throwable throwable = x1;
                        return throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.timeModel$1 = timeModel$1;
                        this.anyParticipant$1 = anyParticipant$1;
                    }
                }, ec).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationIT.$anonfun$runWithUpdatedTimeModel$10(check$ifrefutable$1)), ec).flatMap((Function1 & Serializable)x$72 -> {
                    scala.Tuple2 tuple2 = x$72;
                    if (tuple2 != null) {
                        TimeModel timeModelForTest = (TimeModel)tuple2._1();
                        ParticipantTestContext participantThatDidTheUpdate = (ParticipantTestContext)tuple2._2();
                        return ((Future)test.apply((Object)timeModelForTest)).transformWith((Function1 & Serializable)testResult -> this.restoreTimeModel$1(participantThatDidTheUpdate, ec, (GetTimeModelResponse)timeModel).transform((Function1 & Serializable)x$70 -> testResult, ec), ec).map((Function1 & Serializable)x$71 -> {
                            boxedUnit = x$71;
                            return BoxedUnit.UNIT;
                        }, ec);
                    }
                    throw new MatchError((Object)tuple2);
                }, ec);
            }
            throw new MatchError((Object)tuple2);
        }, ec), ec);
    }

    private Future<scala.Tuple2<TimeModel, ParticipantTestContext>> tryTimeModelUpdateOnAllParticipants(Seq<ParticipantTestContext> participants, Function1<ParticipantTestContext, Future<TimeModel>> timeModelUpdate, ExecutionContext ec) {
        return (Future)participants.foldLeft((Object)Future$.MODULE$.failed((Throwable)new IllegalStateException("No participant")), (Function2 & Serializable)(result, participant) -> result.recoverWith((PartialFunction)new Serializable(null, (Function1)timeModelUpdate, (ParticipantTestContext)participant, ec){
            private static final long serialVersionUID = 0L;
            private final Function1 timeModelUpdate$2;
            private final ParticipantTestContext participant$2;
            private final ExecutionContext ec$16;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    return (B1)((Future)this.timeModelUpdate$2.apply((Object)this.participant$2)).map((Function1 & Serializable)x$74 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$74), (Object)$this.participant$2), this.ec$16);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                return throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
            }
            {
                this.timeModelUpdate$2 = timeModelUpdate$2;
                this.participant$2 = participant$2;
                this.ec$16 = ec$16;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$61(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$tryTimeModelUpdateOnAllParticipants$1$1 com.daml.ledger.api.v1.admin.config_management_service.TimeModel )}, serializedLambda);
            }
        }, ec));
    }

    public FiniteDuration com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$extractDurationFromDeduplicationPeriod(Option<ParticipantTestContext.CompletionResponse> deduplicationCompletionResponse, FiniteDuration defaultDuration, FiniteDuration skews) {
        return (FiniteDuration)deduplicationCompletionResponse.map((Function1 & Serializable)x$75 -> x$75.completion().deduplicationPeriod()).map((Function1 & Serializable)x0$1 -> {
            Completion.DeduplicationPeriod deduplicationPeriod = x0$1;
            if (Completion.DeduplicationPeriod$.Empty$.MODULE$.equals(deduplicationPeriod)) {
                throw new IllegalStateException("received empty completion");
            }
            if (deduplicationPeriod instanceof Completion.DeduplicationPeriod$.DeduplicationOffset) {
                return defaultDuration;
            }
            if (deduplicationPeriod instanceof Completion.DeduplicationPeriod$.DeduplicationDuration) {
                Completion.DeduplicationPeriod$.DeduplicationDuration deduplicationDuration = (Completion.DeduplicationPeriod$.DeduplicationDuration)deduplicationPeriod;
                Duration value = deduplicationDuration.value();
                return ProtobufConverters$.MODULE$.ProtobufDurationConverter(value).asScala();
            }
            throw new MatchError((Object)deduplicationPeriod);
        }).getOrElse((Function0 & Serializable)() -> defaultDuration.$plus(skews));
    }

    public static final /* synthetic */ boolean $anonfun$new$5(Features x$12) {
        return !x$12.staticTime();
    }

    private final Future submitAndAssertAccepted$1(boolean submitAndWait, ParticipantTestContext ledger$6, SubmitAndWaitRequest submitAndWaitRequest$1, Object party$4, ExecutionContext ec$6, SubmitRequest submitRequest$1) {
        String acceptedSubmissionId = this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId();
        if (submitAndWait) {
            return this.submitAndWaitRequestAndAssertCompletionAccepted(ledger$6, this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(submitAndWaitRequest$1, acceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party$4}), ec$6);
        }
        return this.submitRequestAndAssertCompletionAccepted(ledger$6, this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(submitRequest$1, acceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party$4}), ec$6);
    }

    private final Future submitAndAssertDeduplicated$1(boolean submitAndWait, String acceptedSubmissionId, LedgerOffset acceptedLedgerOffset, ParticipantTestContext ledger$6, SubmitAndWaitRequest submitAndWaitRequest$1, ExecutionContext ec$6, SubmitRequest submitRequest$1, Object party$4) {
        if (submitAndWait) {
            return this.submitAndWaitRequestAndAssertDeduplication(ledger$6, this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(submitAndWaitRequest$1), acceptedSubmissionId, acceptedLedgerOffset, ec$6).map((Function1 & Serializable)x$18 -> None$.MODULE$, ec$6);
        }
        return this.submitRequestAndAssertDeduplication(ledger$6, this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(submitRequest$1), acceptedSubmissionId, acceptedLedgerOffset, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party$4}), ec$6).map((Function1 & Serializable)x$19 -> new Some(x$19), ec$6);
    }

    public static final /* synthetic */ boolean $anonfun$new$12(Features x$40) {
        return !x$40.commandDeduplicationFeatures().getDeduplicationPeriodSupport().offsetSupport().isOffsetNotSupported();
    }

    public static final /* synthetic */ void $anonfun$submitRequestAndAssertDeduplication$1(CommandDeduplicationIT $this, SubmitRequest request$9, String acceptedSubmissionId$3, LedgerOffset acceptedOffset$2, ParticipantTestContext.CompletionResponse completion) {
        $this.assertCompletionStatus(request$9.toString(), completion, (Seq<Status.Code>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Status.Code[]{Status.Code.ALREADY_EXISTS}));
        $this.assertDeduplicatedSubmissionIdAndOffsetOnCompletion(acceptedSubmissionId$3, acceptedOffset$2, completion);
    }

    public static final /* synthetic */ boolean $anonfun$assertCompletionStatus$1(ParticipantTestContext.CompletionResponse response$2, Status.Code x$51) {
        return response$2.completion().getStatus().code() == x$51.value();
    }

    public static final /* synthetic */ boolean $anonfun$submitRequestAndFindCompletion$2(SubmitRequest request$11, Completion completion) {
        return request$11.commands().map((Function1 & Serializable)x$53 -> x$53.submissionId()).contains((Object)completion.submissionId());
    }

    public static final /* synthetic */ boolean $anonfun$submitRequestAndFindCompletion$7(SubmitAndWaitRequest request$12, Completion completion) {
        return request$12.commands().map((Function1 & Serializable)x$56 -> x$56.submissionId()).contains((Object)completion.submissionId());
    }

    public static final /* synthetic */ void $anonfun$submitRequestAndAssertSyncFailure$default$5$1(Throwable x$46) {
    }

    public static final /* synthetic */ Future $anonfun$runWithUpdatedTimeModel$4(ParticipantTestContext participant$1, Instant time$1, GetTimeModelResponse timeModel$1, ExecutionContext ec$15, long currentConfigurationGeneration) {
        return participant$1.setTimeModel(time$1.plusSeconds(1L), currentConfigurationGeneration, timeModel$1.getTimeModel()).map((Function1 & Serializable)x$67 -> {
            setTimeModelResponse = x$67;
            return BoxedUnit.UNIT;
        }, ec$15);
    }

    private final Future restoreTimeModel$1(ParticipantTestContext participant, ExecutionContext ec$15, GetTimeModelResponse timeModel$1) {
        Future ledgerTimeModelRestoreResult = participant.time().flatMap((Function1 & Serializable)time -> participant.getTimeModel().map((Function1 & Serializable)x$66 -> BoxesRunTime.boxToLong((long)x$66.configurationGeneration()), ec$15).flatMap((Function1 & Serializable)currentConfigurationGeneration -> CommandDeduplicationIT.$anonfun$runWithUpdatedTimeModel$4(participant, time, timeModel$1, ec$15, BoxesRunTime.unboxToLong((Object)currentConfigurationGeneration)), ec$15), ec$15);
        return ledgerTimeModelRestoreResult.recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    Throwable exception = (Throwable)option.get();
                    this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$logger.warn("Failed to restore time model for ledger", exception);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                return throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ec$15);
    }

    public static final /* synthetic */ boolean $anonfun$runWithUpdatedTimeModel$10(scala.Tuple2 check$ifrefutable$1) {
        scala.Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public CommandDeduplicationIT(double timeoutScaleFactor) {
        this.timeoutScaleFactor = timeoutScaleFactor;
        this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$loggingContext = LoggingContext$.MODULE$.ForTesting();
        this.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration = Durations$.MODULE$.scaleDuration(new package.DurationInt(package$.MODULE$.DurationInt(2)).seconds(), timeoutScaleFactor);
        this.test("SimpleDeduplicationBasic", "Deduplicate commands within the deduplication duration window", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitRequest request = (SubmitRequest)ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new DummyWithAnnotation(party, "Duplicate command").create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$1 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$1).commands()).deduplicationPeriod().$colon$eq((Object)new Commands.DeduplicationPeriod$.DeduplicationDuration(ProtobufConverters$.MODULE$.ScalaDurationConverter($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration()).asProtobuf()))}));
                    String firstAcceptedSubmissionId = this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId();
                    return (B1)this.$outer.submitRequestAndAssertCompletionAccepted(ledger, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(request, firstAcceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), this.ec$1).flatMap((Function1 & Serializable)response -> $this.$outer.submitRequestAndAssertDeduplication(ledger, request, firstAcceptedSubmissionId, response.offset(), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), $this.ec$1).flatMap((Function1 & Serializable)x$3 -> {
                        ParticipantTestContext.CompletionResponse completionResponse = x$3;
                        return $this.$outer.assertPartyHasActiveContracts(ledger, party, 1, $this.ec$1).map((Function1 & Serializable)x$2 -> {
                            $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$4(response, request, x$2);
                            return BoxedUnit.UNIT;
                        }, $this.ec$1);
                    }, $this.ec$1), this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$4(ParticipantTestContext.CompletionResponse response$1, SubmitRequest request$1, BoxedUnit x$2) {
                BoxedUnit boxedUnit = x$2;
                String string = response$1.completion().commandId();
                String string2 = ((Commands)request$1.commands().get()).commandId();
                Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "The command ID of the first completion does not match the command ID of the submission");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$1$1 scalapb.lenses.Lens ), $anonfun$applyOrElse$2(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$3(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.v1.command_submission_service.SubmitRequest com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$4$adapted(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.v1.command_submission_service.SubmitRequest scala.runtime.BoxedUnit ), $anonfun$applyOrElse$5()}, serializedLambda);
            }
        });
        this.test("StopOnSubmissionFailure", "Stop deduplicating commands on submission failure", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    SubmitRequest requestA = ledger.submitRequest(alice, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(bob).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$submitRequestAndAssertSyncFailure(ledger, requestA, Status.Code.INVALID_ARGUMENT, (ErrorCode)CommandExecution.Interpreter$.AuthorizationError$.MODULE$, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$submitRequestAndAssertSyncFailure$default$5(), this.ec$2).flatMap((Function1 & Serializable)x$5 -> {
                        BoxedUnit boxedUnit = x$5;
                        return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$submitRequestAndAssertSyncFailure(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(requestA), Status.Code.INVALID_ARGUMENT, (ErrorCode)CommandExecution.Interpreter$.AuthorizationError$.MODULE$, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$submitRequestAndAssertSyncFailure$default$5(), $this.ec$2).map((Function1 & Serializable)x$4 -> {
                            $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$7(x$4);
                            return BoxedUnit.UNIT;
                        }, $this.ec$2);
                    }, this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$7(BoxedUnit x$4) {
                BoxedUnit boxedUnit = x$4;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest scala.runtime.BoxedUnit ), $anonfun$applyOrElse$7$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
        this.test("StopOnCompletionFailure", "Stop deduplicating commands on completion failure", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String key = (String)ledger.nextKeyId().apply();
                    return (B1)ledger.create(party, (Template)new TextKeyOperations(party)).flatMap((Function1 & Serializable)ko -> ledger.create(party, (Template)new TextKey(party, key, (Seq)Nil$.MODULE$)).map((Function1 & Serializable)x$6 -> {
                        SubmitAndWaitRequest requestA = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOFetchAndRecreate$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(ko), new Tuple2(party, (Object)key), ExerciseOn$.MODULE$.OnId()).command()}));
                        SubmitAndWaitRequest requestB = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOFetchAndRecreate$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(ko), new Tuple2(party, (Object)key), ExerciseOn$.MODULE$.OnId()).command()}));
                        return new Tuple3(x$6, (Object)requestA, (Object)requestB);
                    }, $this.ec$3).flatMap((Function1 & Serializable)x$8 -> {
                        Tuple3 tuple3 = x$8;
                        if (tuple3 != null) {
                            SubmitAndWaitRequest requestA = (SubmitAndWaitRequest)tuple3._2();
                            SubmitAndWaitRequest requestB = (SubmitAndWaitRequest)tuple3._3();
                            return Future$.MODULE$.traverse((IterableOnce)new .colon.colon((Object)requestA, (List)new .colon.colon((Object)requestB, (List)Nil$.MODULE$)), (Function1 & Serializable)request -> ledger.submitAndWait(request).transform((Function1 & Serializable)result -> new Success((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(request), result)), $this.ec$3), BuildFrom$.MODULE$.buildFromIterableOps(), $this.ec$3).flatMap((Function1 & Serializable)submissionResults -> ((Future)submissionResults.collectFirst((PartialFunction)new Serializable(null){
                                private static final long serialVersionUID = 0L;

                                public final <A1 extends scala.Tuple2<SubmitAndWaitRequest, Try<BoxedUnit>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    A1 A1 = x1;
                                    if (A1 != null) {
                                        SubmitAndWaitRequest request = (SubmitAndWaitRequest)A1._1();
                                        Try try_ = (Try)A1._2();
                                        if (try_ instanceof Failure) {
                                            return (B1)request;
                                        }
                                    }
                                    return (B1)function1.apply(x1);
                                }

                                public final boolean isDefinedAt(scala.Tuple2<SubmitAndWaitRequest, Try<BoxedUnit>> x1) {
                                    Try try_;
                                    scala.Tuple2<SubmitAndWaitRequest, Try<BoxedUnit>> tuple2 = x1;
                                    return tuple2 != null && (try_ = (Try)tuple2._2()) instanceof Failure;
                                }
                            }).fold((Function0 & Serializable)() -> Future$.MODULE$.unit(), (Function1 & Serializable)request -> ledger.submitAndWait($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId((SubmitAndWaitRequest)request)))).map((Function1 & Serializable)x$7 -> {
                                $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$16(x$7);
                                return BoxedUnit.UNIT;
                            }, $this.ec$3), $this.ec$3);
                        }
                        throw new MatchError((Object)tuple3);
                    }, $this.ec$3), this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$16(BoxedUnit x$7) {
                BoxedUnit boxedUnit = x$7;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple3 ), $anonfun$applyOrElse$11(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest ), $anonfun$applyOrElse$12(com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest scala.util.Try ), $anonfun$applyOrElse$13(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.collection.immutable.List ), $anonfun$applyOrElse$14(), $anonfun$applyOrElse$15(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest ), $anonfun$applyOrElse$16$adapted(scala.runtime.BoxedUnit ), $anonfun$applyOrElse$8(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.Object ), $anonfun$applyOrElse$9(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Object )}, serializedLambda);
            }
        });
        this.test("SimpleDeduplicationCommandClient", "Deduplicate commands within the deduplication time window using the command client", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = (SubmitAndWaitRequest)ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$9 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$9).commands()).deduplicationTime().$colon$eq((Object)ProtobufConverters$.MODULE$.ScalaDurationConverter($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration()).asProtobuf())}));
                    String acceptedSubmissionId1 = this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId();
                    return (B1)this.$outer.submitAndWaitRequestAndAssertCompletionAccepted(ledger, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(request, acceptedSubmissionId1), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), this.ec$4).flatMap((Function1 & Serializable)response -> $this.$outer.submitAndWaitRequestAndAssertDeduplication(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(request), acceptedSubmissionId1, response.offset(), $this.ec$4).flatMap((Function1 & Serializable)x$11 -> {
                        BoxedUnit boxedUnit = x$11;
                        return $this.$outer.assertPartyHasActiveContracts(ledger, party, 1, $this.ec$4).map((Function1 & Serializable)x$10 -> {
                            $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$20(x$10);
                            return BoxedUnit.UNIT;
                        }, $this.ec$4);
                    }, $this.ec$4), this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$20(BoxedUnit x$10) {
                BoxedUnit boxedUnit = x$10;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$17(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$4$1 scalapb.lenses.Lens ), $anonfun$applyOrElse$18(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest java.lang.String java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$19(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$20$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
        String x$1 = "DeduplicationMixedClients";
        String x$2 = "Deduplicate commands within the deduplication time window using the command client and the command submission client";
        Allocation.PartyAllocation x$3 = Allocation$.MODULE$.allocate((Allocation.PartyCount)new Allocation.Parties(16), (Seq)Nil$.MODULE$);
        Function1 & Serializable x$4 = (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationIT.$anonfun$new$5(x$12));
        String x$5 = "Cannot work in static time as we run multiple test cases in parallel";
        boolean x$6 = false;
        double x$7 = 3.0;
        int x$8 = this.testGivenAllParticipants$default$6();
        List x$9 = this.testGivenAllParticipants$default$9();
        Function1 & Serializable x$10 = (Function1 & Serializable)ec -> (Function1 & Serializable)configuredParticipants -> new Serializable(this, (Seq)configuredParticipants, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;
            private final Seq configuredParticipants$1;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null) {
                    ParticipantTestContext ledger = participant.context();
                    Seq parties = participant.parties();
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$runWithTimeModel((Seq<ParticipantTestContext>)this.configuredParticipants$1, (Function1<FiniteDuration, Future<BoxedUnit>>)(Function1 & Serializable)minMaxSkewSum -> {
                        int numberOfCalls = 4;
                        List allGeneratedVariations = (List)$anonfun$$nestedInanonfun$new$7$1.generateVariations$1((List)scala.package$.MODULE$.List().fill(numberOfCalls, (Function0 & Serializable)() -> (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})))).zip((IterableOnce)parties);
                        return FutureAssertions$.MODULE$.forAllParallel((Seq)allGeneratedVariations, (Function1 & Serializable)x0$1 -> {
                            scala.Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                List list = (List)tuple2._1();
                                Object party = tuple2._2();
                                if (list instanceof .colon.colon) {
                                    .colon.colon colon2 = (.colon.colon)list;
                                    boolean firstCall = BoxesRunTime.unboxToBoolean((Object)colon2.head());
                                    List list2 = colon2.next$access$1();
                                    if (list2 instanceof .colon.colon) {
                                        .colon.colon colon3 = (.colon.colon)list2;
                                        boolean secondCall = BoxesRunTime.unboxToBoolean((Object)colon3.head());
                                        List list3 = colon3.next$access$1();
                                        if (list3 instanceof .colon.colon) {
                                            .colon.colon colon4 = (.colon.colon)list3;
                                            boolean thirdCall = BoxesRunTime.unboxToBoolean((Object)colon4.head());
                                            List list4 = colon4.next$access$1();
                                            if (list4 instanceof .colon.colon) {
                                                .colon.colon colon5 = (.colon.colon)list4;
                                                boolean fourthCall = BoxesRunTime.unboxToBoolean((Object)colon5.head());
                                                List list5 = colon5.next$access$1();
                                                if (Nil$.MODULE$.equals(list5)) {
                                                    return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$mixedClientsCommandDeduplicationTestCase(ledger, party, ledger.delayMechanism(), (FiniteDuration)minMaxSkewSum, firstCall, secondCall, thirdCall, fourthCall, $this.ec$5);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            throw new IllegalArgumentException("Wrong call list constructed");
                        }, $this.ec$5, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$loggingContext()).map((Function1 & Serializable)x$14 -> {
                            $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$26(x$14);
                            return BoxedUnit.UNIT;
                        }, $this.ec$5);
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null;
            }

            public static final /* synthetic */ List $anonfun$applyOrElse$21(List tail$1, boolean value) {
                return $anonfun$$nestedInanonfun$new$7$1.generateVariations$1(tail$1).map((Function1 & Serializable)x$13 -> {
                    boolean bl = value;
                    return x$13.$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                });
            }

            private static final List generateVariations$1(List elements) {
                List list = elements;
                if (Nil$.MODULE$.equals(list)) {
                    return new .colon.colon((Object)Nil$.MODULE$, (List)Nil$.MODULE$);
                }
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List currentElement = (List)colon2.head();
                    List tail = colon2.next$access$1();
                    return currentElement.flatMap((Function1 & Serializable)value -> $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$21(tail, BoxesRunTime.unboxToBoolean((Object)value)));
                }
                throw new MatchError((Object)list);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$26(BoxedUnit x$14) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.configuredParticipants$1 = configuredParticipants$1;
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$21$adapted(scala.collection.immutable.List java.lang.Object ), $anonfun$applyOrElse$22(boolean scala.collection.immutable.List ), $anonfun$applyOrElse$23(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$7$1 scala.collection.immutable.Seq com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.concurrent.duration.FiniteDuration ), $anonfun$applyOrElse$24(), $anonfun$applyOrElse$25(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.concurrent.duration.FiniteDuration scala.Tuple2 ), $anonfun$applyOrElse$26$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        this.testGivenAllParticipants("DeduplicationMixedClients", "Deduplicate commands within the deduplication time window using the command client and the command submission client", x$3, 3.0, false, x$8, x$4, "Cannot work in static time as we run multiple test cases in parallel", x$9, x$10);
        this.test("DeduplicateSubmitterBasic", "Commands with identical submitter and command identifier should be deduplicated by the submission client", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    SubmitRequest aliceRequest = ledger.submitRequest(alice, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(alice).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    SubmitRequest bobRequest = (SubmitRequest)ledger.submitRequest(bob, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(bob).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$25 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$25).commands()).commandId().$colon$eq((Object)aliceRequest.getCommands().commandId())}));
                    String aliceAcceptedSubmissionId = this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId();
                    String bobAcceptedSubmissionId = this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId();
                    return (B1)this.$outer.submitRequestAndAssertCompletionAccepted(ledger, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(aliceRequest, aliceAcceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice}), this.ec$7).flatMap((Function1 & Serializable)aliceResponse -> $this.$outer.submitRequestAndAssertDeduplication(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(aliceRequest), aliceAcceptedSubmissionId, aliceResponse.offset(), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice}), $this.ec$7).flatMap((Function1 & Serializable)x$29 -> {
                        ParticipantTestContext.CompletionResponse completionResponse = x$29;
                        return $this.$outer.submitRequestAndAssertCompletionAccepted(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(bobRequest, bobAcceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob}), $this.ec$7).flatMap((Function1 & Serializable)bobResponse -> $this.$outer.submitRequestAndAssertDeduplication(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(bobRequest), bobAcceptedSubmissionId, bobResponse.offset(), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob}), $this.ec$7).flatMap((Function1 & Serializable)x$28 -> {
                            ParticipantTestContext.CompletionResponse completionResponse = x$28;
                            return $this.$outer.assertPartyHasActiveContracts(ledger, alice, 1, $this.ec$7).flatMap((Function1 & Serializable)x$27 -> {
                                BoxedUnit boxedUnit = x$27;
                                return $this.$outer.assertPartyHasActiveContracts(ledger, bob, 1, $this.ec$7).map((Function1 & Serializable)x$26 -> {
                                    $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$33(x$26);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$7);
                            }, $this.ec$7);
                        }, $this.ec$7), $this.ec$7);
                    }, $this.ec$7), this.ec$7);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$33(BoxedUnit x$26) {
                BoxedUnit boxedUnit = x$26;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$27(com.daml.ledger.api.v1.command_submission_service.SubmitRequest scalapb.lenses.Lens ), $anonfun$applyOrElse$28(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String java.lang.Object com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$29(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$30(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$31(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$32(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$33$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
        this.test("DeduplicateSubmitterCommandClient", "Commands with identical submitter and command identifier should be deduplicated by the command client", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    SubmitAndWaitRequest aliceRequest = ledger.submitAndWaitRequest(alice, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(alice).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    SubmitAndWaitRequest bobRequest = (SubmitAndWaitRequest)ledger.submitAndWaitRequest(bob, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(bob).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$30 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$30).commands()).commandId().$colon$eq((Object)aliceRequest.getCommands().commandId())}));
                    String aliceAcceptedSubmissionId = this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId();
                    String bobAcceptedSubmissionId = this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId();
                    return (B1)this.$outer.submitAndWaitRequestAndAssertCompletionAccepted(ledger, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(aliceRequest, aliceAcceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice}), this.ec$8).flatMap((Function1 & Serializable)aliceResponse -> $this.$outer.submitAndWaitRequestAndAssertDeduplication(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(aliceRequest), aliceAcceptedSubmissionId, aliceResponse.offset(), $this.ec$8).flatMap((Function1 & Serializable)x$34 -> {
                        BoxedUnit boxedUnit = x$34;
                        return $this.$outer.submitAndWaitRequestAndAssertCompletionAccepted(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(bobRequest, bobAcceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob}), $this.ec$8).flatMap((Function1 & Serializable)bobReponse -> $this.$outer.submitAndWaitRequestAndAssertDeduplication(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(bobRequest), bobAcceptedSubmissionId, bobReponse.offset(), $this.ec$8).flatMap((Function1 & Serializable)x$33 -> {
                            BoxedUnit boxedUnit = x$33;
                            return $this.$outer.assertPartyHasActiveContracts(ledger, alice, 1, $this.ec$8).flatMap((Function1 & Serializable)x$32 -> {
                                BoxedUnit boxedUnit = x$32;
                                return $this.$outer.assertPartyHasActiveContracts(ledger, bob, 1, $this.ec$8).map((Function1 & Serializable)x$31 -> {
                                    $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$40(x$31);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$8);
                            }, $this.ec$8);
                        }, $this.ec$8), $this.ec$8);
                    }, $this.ec$8), this.ec$8);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$40(BoxedUnit x$31) {
                BoxedUnit boxedUnit = x$31;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$34(com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest scalapb.lenses.Lens ), $anonfun$applyOrElse$35(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest java.lang.String com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest java.lang.String java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$36(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest java.lang.String java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$37(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest java.lang.String java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$38(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$39(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$40$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
        String x$11 = "DeduplicateUsingDurations";
        String x$122 = "Deduplicate commands within the deduplication period defined by a duration";
        Allocation.PartyAllocation x$13 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        boolean x$14 = false;
        String x$15 = "Most of the assertions run on async responses. Also, ledgers with the sync-only deduplication support use the wall clock for deduplication.";
        double x$16 = this.testGivenAllParticipants$default$4();
        int x$17 = this.testGivenAllParticipants$default$6();
        Function1 x$18 = this.testGivenAllParticipants$default$7();
        List x$19 = this.testGivenAllParticipants$default$9();
        Function1 & Serializable x$20 = (Function1 & Serializable)ec -> (Function1 & Serializable)configuredParticipants -> new Serializable(this, (Seq)configuredParticipants, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;
            private final Seq configuredParticipants$2;
            private final ExecutionContext ec$9;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitRequest request = (SubmitRequest)ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new DummyWithAnnotation(party, "Duplicate command").create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$35 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$35).commands()).deduplicationPeriod().$colon$eq((Object)new Commands.DeduplicationPeriod$.DeduplicationDuration(ProtobufConverters$.MODULE$.ScalaDurationConverter($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration()).asProtobuf()))}));
                    String firstAcceptedSubmissionId = this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId();
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$runWithTimeModel((Seq<ParticipantTestContext>)this.configuredParticipants$2, (Function1<FiniteDuration, Future<BoxedUnit>>)(Function1 & Serializable)minMaxSkewSum -> $this.$outer.submitRequestAndAssertCompletionAccepted(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(request, firstAcceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), $this.ec$9).flatMap((Function1 & Serializable)completionResponse -> $this.$outer.submitRequestAndAssertDeduplication(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId(request), firstAcceptedSubmissionId, completionResponse.offset(), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), $this.ec$9).map((Function1 & Serializable)deduplicationCompletionResponse -> {
                        FiniteDuration deduplicationDurationFromPeriod = $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$extractDurationFromDeduplicationPeriod((Option<ParticipantTestContext.CompletionResponse>)new Some(deduplicationCompletionResponse), $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration(), (FiniteDuration)minMaxSkewSum);
                        return new scala.Tuple2(deduplicationCompletionResponse, (Object)deduplicationDurationFromPeriod);
                    }, $this.ec$9).flatMap((Function1 & Serializable)x$39 -> {
                        scala.Tuple2 tuple2 = x$39;
                        if (tuple2 != null) {
                            ParticipantTestContext.CompletionResponse deduplicationCompletionResponse = (ParticipantTestContext.CompletionResponse)tuple2._1();
                            FiniteDuration deduplicationDurationFromPeriod = (FiniteDuration)tuple2._2();
                            FiniteDuration x$1 = deduplicationDurationFromPeriod.$plus(minMaxSkewSum).$plus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
                            String x$2 = new StringBuilder(79).append("The deduplication period expires and the request is accepted for the commands ").append(request.getCommands()).append(".").toString();
                            DelayMechanism x$3 = ledger.delayMechanism();
                            FiniteDuration x$4 = FutureAssertions$.MODULE$.succeedsEventually$default$1();
                            Function0 & Serializable x$5 = (Function0 & Serializable)() -> $this.$outer.submitRequestAndAssertCompletionAccepted(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(request, firstAcceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), $this.ec$9);
                            return FutureAssertions$.MODULE$.succeedsEventually(x$4, x$1, x$3, x$2, (Function0)x$5, $this.ec$9, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$loggingContext()).flatMap((Function1 & Serializable)eventuallyAcceptedCompletionResponse -> $this.$outer.assertPartyHasActiveContracts(ledger, party, 2, $this.ec$9).flatMap((Function1 & Serializable)x$38 -> {
                                BoxedUnit boxedUnit = x$38;
                                return CommandDeduplicationAssertions$.MODULE$.assertDeduplicationDuration(ProtobufConverters$.MODULE$.ScalaDurationConverter($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration()).asProtobuf(), deduplicationCompletionResponse, party, ledger, $this.ec$9).flatMap((Function1 & Serializable)x$37 -> {
                                    BoxedUnit boxedUnit = x$37;
                                    return CommandDeduplicationAssertions$.MODULE$.assertDeduplicationDuration(ProtobufConverters$.MODULE$.ScalaDurationConverter($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$deduplicationDuration()).asProtobuf(), eventuallyAcceptedCompletionResponse, party, ledger, $this.ec$9).map((Function1 & Serializable)x$36 -> {
                                        $anonfun$$nestedInanonfun$new$11$1.$anonfun$applyOrElse$50(completionResponse, request, x$36);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$9);
                                }, $this.ec$9);
                            }, $this.ec$9), $this.ec$9);
                        }
                        throw new MatchError((Object)tuple2);
                    }, $this.ec$9), $this.ec$9), this.ec$9);
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participant participant;
                Allocation.Participants participants = x8;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$50(ParticipantTestContext.CompletionResponse completionResponse$1, SubmitRequest request$4, BoxedUnit x$36) {
                BoxedUnit boxedUnit = x$36;
                String string = completionResponse$1.completion().commandId();
                String string2 = ((Commands)request$4.commands().get()).commandId();
                Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "The command ID of the first completion does not match the command ID of the submission");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.configuredParticipants$2 = configuredParticipants$2;
                this.ec$9 = ec$9;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$41(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$11$1 scalapb.lenses.Lens ), $anonfun$applyOrElse$42(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String java.lang.Object scala.concurrent.duration.FiniteDuration ), $anonfun$applyOrElse$43(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String java.lang.Object scala.concurrent.duration.FiniteDuration com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$44(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$11$1 scala.concurrent.duration.FiniteDuration com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$45(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$11$1 scala.concurrent.duration.FiniteDuration com.daml.ledger.api.v1.command_submission_service.SubmitRequest com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse scala.Tuple2 ), $anonfun$applyOrElse$46(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String java.lang.Object ), $anonfun$applyOrElse$47(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.v1.command_submission_service.SubmitRequest com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$48(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.v1.command_submission_service.SubmitRequest scala.runtime.BoxedUnit ), $anonfun$applyOrElse$49(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.v1.command_submission_service.SubmitRequest scala.runtime.BoxedUnit ), $anonfun$applyOrElse$50$adapted(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.v1.command_submission_service.SubmitRequest scala.runtime.BoxedUnit ), $anonfun$applyOrElse$51()}, serializedLambda);
            }
        };
        this.testGivenAllParticipants("DeduplicateUsingDurations", "Deduplicate commands within the deduplication period defined by a duration", x$13, x$16, false, x$17, x$18, "Most of the assertions run on async responses. Also, ledgers with the sync-only deduplication support use the wall clock for deduplication.", x$19, x$20);
        String x$21 = "DeduplicateUsingOffsets";
        String x$22 = "Deduplicate commands within the deduplication period defined by the offset";
        Allocation.PartyAllocation x$23 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$24 = (Function1 & Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)CommandDeduplicationIT.$anonfun$new$12(x$40));
        String x$25 = "Deduplication periods represented by offsets are not supported";
        boolean x$26 = false;
        double x$27 = this.testGivenAllParticipants$default$4();
        int x$28 = this.testGivenAllParticipants$default$6();
        List x$29 = this.testGivenAllParticipants$default$9();
        Function1 & Serializable x$30 = (Function1 & Serializable)ec -> (Function1 & Serializable)configuredParticipants -> new Serializable(this, (Seq)configuredParticipants, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandDeduplicationIT $outer;
            private final Seq configuredParticipants$3;
            private final ExecutionContext ec$10;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x9;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitRequest request = ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new DummyWithAnnotation(party, "Duplicate command").create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    String acceptedSubmissionId = this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$newSubmissionId();
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$runWithTimeModel((Seq<ParticipantTestContext>)this.configuredParticipants$3, (Function1<FiniteDuration, Future<BoxedUnit>>)(Function1 & Serializable)x$41 -> {
                        SubmitRequest dummyRequest = ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new DummyWithAnnotation(party, "Dummy command to generate a completion offset").create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                        return $this.$outer.submitRequestAndAssertCompletionAccepted(ledger, dummyRequest, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), $this.ec$10).map((Function1 & Serializable)x$42 -> x$42.offset(), $this.ec$10).flatMap((Function1 & Serializable)offsetBeforeFirstCompletion -> $this.$outer.submitRequestAndAssertCompletionAccepted(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateSubmissionId(request, acceptedSubmissionId), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), $this.ec$10).flatMap((Function1 & Serializable)firstAcceptedResponse -> $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$delayForOffsetIfRequired(ledger, $this.ec$10).flatMap((Function1 & Serializable)x$45 -> {
                            BoxedUnit boxedUnit = x$45;
                            return $this.$outer.submitRequestAndAssertDeduplication(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId((SubmitRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$43 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$43).commands()).deduplicationPeriod().$colon$eq((Object)new Commands.DeduplicationPeriod$.DeduplicationOffset((String)Ref$.MODULE$.HexString().assertFromString(offsetBeforeFirstCompletion.getAbsolute())))}))), acceptedSubmissionId, firstAcceptedResponse.offset(), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), $this.ec$10).flatMap((Function1 & Serializable)duplicateResponse -> $this.$outer.submitRequestAndAssertCompletionAccepted(ledger, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandDeduplicationIT$$updateWithFreshSubmissionId((SubmitRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$44 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$44).commands()).deduplicationPeriod().$colon$eq((Object)new Commands.DeduplicationPeriod$.DeduplicationOffset((String)Ref$.MODULE$.HexString().assertFromString(duplicateResponse.offset().getAbsolute())))}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}), $this.ec$10).map((Function1 & Serializable)secondAcceptedResponse -> {
                                $anonfun$$nestedInanonfun$new$14$1.$anonfun$applyOrElse$60(firstAcceptedResponse, duplicateResponse, ledger, secondAcceptedResponse);
                                return BoxedUnit.UNIT;
                            }, $this.ec$10), $this.ec$10);
                        }, $this.ec$10), $this.ec$10), $this.ec$10);
                    }, this.ec$10);
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Allocation.Participants x9) {
                Allocation.Participant participant;
                Allocation.Participants participants = x9;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$60(ParticipantTestContext.CompletionResponse firstAcceptedResponse$1, ParticipantTestContext.CompletionResponse duplicateResponse$1, ParticipantTestContext ledger$10, ParticipantTestContext.CompletionResponse secondAcceptedResponse) {
                CommandDeduplicationAssertions$.MODULE$.assertDeduplicationOffset(firstAcceptedResponse$1, duplicateResponse$1, ledger$10.features().commandDeduplicationFeatures().getDeduplicationPeriodSupport().offsetSupport());
                CommandDeduplicationAssertions$.MODULE$.assertDeduplicationOffset(duplicateResponse$1, secondAcceptedResponse, ledger$10.features().commandDeduplicationFeatures().getDeduplicationPeriodSupport().offsetSupport());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.configuredParticipants$3 = configuredParticipants$3;
                this.ec$10 = ec$10;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$52(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$14$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String scala.concurrent.duration.FiniteDuration ), $anonfun$applyOrElse$53(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$54(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$14$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.String java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$55(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$14$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.String java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$56(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$14$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.String com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$57(com.daml.ledger.api.v1.ledger_offset.LedgerOffset scalapb.lenses.Lens ), $anonfun$applyOrElse$58(com.daml.ledger.api.testtool.suites.v1_8.CommandDeduplicationIT$$anonfun$$nestedInanonfun$new$14$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse ), $anonfun$applyOrElse$59(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse scalapb.lenses.Lens ), $anonfun$applyOrElse$60$adapted(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext$CompletionResponse )}, serializedLambda);
            }
        };
        this.testGivenAllParticipants("DeduplicateUsingOffsets", "Deduplicate commands within the deduplication period defined by the offset", x$23, x$27, false, x$28, x$24, "Deduplication periods represented by offsets are not supported", x$29, x$30);
    }
}

