/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.CommandExecution;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$;
import com.daml.ledger.api.v1.command_completion_service.CompletionStreamRequest;
import com.daml.ledger.api.v1.command_completion_service.CompletionStreamRequest$;
import com.daml.ledger.api.v1.command_submission_service.SubmitRequest;
import com.daml.ledger.api.v1.command_submission_service.SubmitRequest$;
import com.daml.ledger.api.v1.commands.Command;
import com.daml.ledger.api.v1.commands.Command$;
import com.daml.ledger.api.v1.commands.Commands;
import com.daml.ledger.api.v1.commands.Commands$;
import com.daml.ledger.api.v1.commands.ExerciseCommand$;
import com.daml.ledger.api.v1.completion.Completion;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.test.model.Test.Dummy;
import com.daml.ledger.test.model.Test.Dummy$;
import com.daml.platform.testing.TimeoutException$;
import com.daml.platform.testing.WithTimeout$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.regex.Pattern;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0003%!)\u0011\u0004\u0001C\u00015\ti2i\\7nC:$7+\u001e2nSN\u001c\u0018n\u001c8D_6\u0004H.\u001a;j_:LEK\u0003\u0002\u0005\u000b\u0005!a/M09\u0015\t1q!\u0001\u0004tk&$Xm\u001d\u0006\u0003\u0011%\t\u0001\u0002^3tiR|w\u000e\u001c\u0006\u0003\u0015-\t1!\u00199j\u0015\taQ\"\u0001\u0004mK\u0012<WM\u001d\u0006\u0003\u001d=\tA\u0001Z1nY*\t\u0001#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\u0011acB\u0001\u000fS:4'/Y:ueV\u001cG/\u001e:f\u0013\tARCA\bMK\u0012<WM\u001d+fgR\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t1\u0001")
public final class CommandSubmissionCompletionIT
extends LedgerTestSuite {
    public CommandSubmissionCompletionIT() {
        this.test("CSCCompletions", "Read completions correctly with a correct application identifier and reading party", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitRequest request = ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submit(request).flatMap((Function1 & Serializable)x$2 -> {
                        BoxedUnit boxedUnit = x$2;
                        return ledger.firstCompletions((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)completions -> {
                            $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$2(request, completions);
                            return BoxedUnit.UNIT;
                        }, $this.ec$1);
                    }, this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2(SubmitRequest request$1, Vector completions) {
                String commandId;
                String string = commandId = (String)Assertions$.MODULE$.assertSingleton("Expected only one completion", (Seq)completions.map((Function1 & Serializable)x$1 -> x$1.commandId()));
                String string2 = ((Commands)request$1.commands().get()).commandId();
                Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Wrong command identifier on completion");
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.command_submission_service.SubmitRequest scala.runtime.BoxedUnit ), $anonfun$applyOrElse$2$adapted(com.daml.ledger.api.v1.command_submission_service.SubmitRequest scala.collection.immutable.Vector ), $anonfun$applyOrElse$3(com.daml.ledger.api.v1.completion.Completion ), $anonfun$applyOrElse$4()}, serializedLambda);
            }
        });
        this.test("CSCNoCompletionsWithoutRightAppId", "Read no completions without the correct application identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitRequest request = ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submit(request).map((Function1 & Serializable)x$4 -> {
                        CompletionStreamRequest invalidRequest = (CompletionStreamRequest)ledger.completionStreamRequest(ledger.completionStreamRequest$default$1(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$3 -> CompletionStreamRequest$.MODULE$.CompletionStreamRequestLens(x$3).applicationId().$colon$eq((Object)"invalid-application-id")}));
                        return new Tuple2(x$4, (Object)invalidRequest);
                    }, this.ec$2).flatMap((Function1 & Serializable)x$5 -> {
                        Tuple2 tuple2 = x$5;
                        if (tuple2 != null) {
                            CompletionStreamRequest invalidRequest = (CompletionStreamRequest)tuple2._2();
                            return Assertions$.MODULE$.futureAssertions(WithTimeout$.MODULE$.apply((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds(), (Function0 & Serializable)() -> ledger.firstCompletions(invalidRequest))).mustFail("subscribing to completions with an invalid application ID", $this.ec$2).map((Function1 & Serializable)failure -> {
                                $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$9(failure);
                                return BoxedUnit.UNIT;
                            }, $this.ec$2);
                        }
                        throw new MatchError((Object)tuple2);
                    }, this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$9(Throwable failure) {
                Throwable throwable = failure;
                TimeoutException$ timeoutException$ = TimeoutException$.MODULE$;
                Predef$.MODULE$.assert(!(throwable != null ? !throwable.equals(timeoutException$) : timeoutException$ != null), (Function0 & Serializable)() -> "Timeout expected");
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(), $anonfun$applyOrElse$5(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$6(scalapb.lenses.Lens ), $anonfun$applyOrElse$7(com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple2 ), $anonfun$applyOrElse$8(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_completion_service.CompletionStreamRequest ), $anonfun$applyOrElse$9$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSCAfterEnd", "An OUT_OF_RANGE error should be returned when subscribing to completions past the ledger end", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitRequest request = ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submit(request).flatMap((Function1 & Serializable)x$8 -> {
                        BoxedUnit boxedUnit = x$8;
                        return ledger.offsetBeyondLedgerEnd().map((Function1 & Serializable)futureOffset -> {
                            CompletionStreamRequest invalidRequest = (CompletionStreamRequest)ledger.completionStreamRequest(ledger.completionStreamRequest$default$1(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$6 -> CompletionStreamRequest$.MODULE$.CompletionStreamRequestLens(x$6).offset().$colon$eq(futureOffset)}));
                            return new Tuple2(futureOffset, (Object)invalidRequest);
                        }, $this.ec$3).flatMap((Function1 & Serializable)x$7 -> {
                            Tuple2 tuple2 = x$7;
                            if (tuple2 != null) {
                                CompletionStreamRequest invalidRequest = (CompletionStreamRequest)tuple2._2();
                                return Assertions$.MODULE$.futureAssertions(ledger.firstCompletions(invalidRequest)).mustFail("subscribing to completions past the ledger end", $this.ec$3).map((Function1 & Serializable)failure -> {
                                    $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$15(failure);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$3);
                            }
                            throw new MatchError((Object)tuple2);
                        }, $this.ec$3);
                    }, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$15(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.OffsetAfterLedgerEnd$.MODULE$, (Option)new Some((Object)"is after ledger end"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$11(com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$12(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$13(com.daml.ledger.api.v1.ledger_offset.LedgerOffset scalapb.lenses.Lens ), $anonfun$applyOrElse$14(com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple2 ), $anonfun$applyOrElse$15$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSCNoCompletionsWithoutRightParty", "Read no completions without the correct party", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Object notTheSubmittingParty = participant.parties().apply(1);
                    SubmitRequest request = ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submit(request).flatMap((Function1 & Serializable)x$9 -> {
                        BoxedUnit boxedUnit = x$9;
                        return Assertions$.MODULE$.futureAssertions(WithTimeout$.MODULE$.apply((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds(), (Function0 & Serializable)() -> ledger.firstCompletions((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{notTheSubmittingParty})))).mustFail("subscribing to completions with the wrong party", $this.ec$4).map((Function1 & Serializable)failure -> {
                            $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$18(failure);
                            return BoxedUnit.UNIT;
                        }, $this.ec$4);
                    }, this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$18(Throwable failure) {
                Throwable throwable = failure;
                TimeoutException$ timeoutException$ = TimeoutException$.MODULE$;
                Predef$.MODULE$.assert(!(throwable != null ? !throwable.equals(timeoutException$) : timeoutException$ != null), (Function0 & Serializable)() -> "Timeout expected");
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$16(com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$17(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$18$adapted(java.lang.Throwable ), $anonfun$applyOrElse$19()}, serializedLambda);
            }
        });
        this.test("CSCRefuseBadChoice", "The submission of an exercise of a choice that does not exist should yield INVALID_ARGUMENT", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String badChoice = "THIS_IS_NOT_A_VALID_CHOICE";
                    return (B1)ledger.create(party, (Template)new Dummy(party)).map((Function1 & Serializable)dummy -> {
                        Command exercise = Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId()).command();
                        Command wrongExercise = (Command)exercise.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$10 -> ExerciseCommand$.MODULE$.ExerciseCommandLens(Command$.MODULE$.CommandLens(x$10).exercise()).choice().$colon$eq((Object)badChoice)}));
                        SubmitRequest wrongRequest = ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{wrongExercise}));
                        return new Tuple4(dummy, (Object)exercise, (Object)wrongExercise, (Object)wrongRequest);
                    }, this.ec$5).flatMap((Function1 & Serializable)x$11 -> {
                        Tuple4 tuple4 = x$11;
                        if (tuple4 != null) {
                            SubmitRequest wrongRequest = (SubmitRequest)tuple4._4();
                            return Assertions$.MODULE$.futureAssertions(ledger.submit(wrongRequest)).mustFail("submitting an invalid choice", $this.ec$5).map((Function1 & Serializable)failure -> {
                                $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$23(badChoice, failure);
                                return BoxedUnit.UNIT;
                            }, $this.ec$5);
                        }
                        throw new MatchError((Object)tuple4);
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$23(String badChoice$1, Throwable failure) {
                Assertions$.MODULE$.assertGrpcErrorRegex(failure, (ErrorCode)CommandExecution.Preprocessing$.PreprocessingFailed$.MODULE$, (Option)new Some((Object)Pattern.compile(new StringBuilder(41).append("(unknown|Couldn't find requested) choice ").append(badChoice$1).toString())), true, Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            }
            {
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$20(java.lang.String com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$21(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$22(com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String scala.Tuple4 ), $anonfun$applyOrElse$23$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSCSubmitWithInvalidLedgerId", "Submit should fail for an invalid ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "CSsubmitAndWaitInvalidLedgerId";
                    SubmitRequest request = (SubmitRequest)ledger.submitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$12 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$12).commands()).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submit(request)).mustFail("submitting with an invalid ledger ID", this.ec$6).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$25(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$25(String invalidLedgerId$1, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$1).append("' not found.").toString()), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$24(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$25$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSCDisallowEmptyTransactionsSubmission", "The submission of an empty command should be rejected with INVALID_ARGUMENT", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitRequest emptyRequest = ledger.submitRequest(party, (Seq)Nil$.MODULE$);
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submit(emptyRequest)).mustFail("submitting an empty command", this.ec$7).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$26(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$7);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$26(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.MissingField$.MODULE$, (Option)new Some((Object)"commands"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$26$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSCHandleMultiPartySubscriptions", "Listening for completions should support multi-party subscriptions", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    SubmitRequest aliceRequest = ledger.submitRequest(alice, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(alice).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    SubmitRequest bobRequest = ledger.submitRequest(bob, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(bob).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    String aliceCommandId = aliceRequest.getCommands().commandId();
                    String bobCommandId = bobRequest.getCommands().commandId();
                    return (B1)ledger.submit(aliceRequest).flatMap((Function1 & Serializable)x$18 -> {
                        BoxedUnit boxedUnit = x$18;
                        return ledger.submit(bobRequest).flatMap((Function1 & Serializable)x$17 -> {
                            BoxedUnit boxedUnit = x$17;
                            return WithTimeout$.MODULE$.apply((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds(), (Function0 & Serializable)() -> ledger.findCompletion((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice, bob}), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$30(aliceCommandId, x$13)))).flatMap((Function1 & Serializable)x$16 -> {
                                Option option = x$16;
                                return WithTimeout$.MODULE$.apply((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds(), (Function0 & Serializable)() -> ledger.findCompletion((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{alice, bob}), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$33(bobCommandId, x$14)))).map((Function1 & Serializable)x$15 -> {
                                    $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$34(x$15);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$8);
                            }, $this.ec$8);
                        }, $this.ec$8);
                    }, this.ec$8);
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participant participant;
                Allocation.Participants participants = x8;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$30(String aliceCommandId$1, Completion x$13) {
                String string = x$13.commandId();
                String string2 = aliceCommandId$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$33(String bobCommandId$1, Completion x$14) {
                String string = x$14.commandId();
                String string2 = bobCommandId$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$34(Option x$15) {
                Option option = x$15;
            }
            {
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$27(com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_submission_service.SubmitRequest java.lang.Object java.lang.Object java.lang.String java.lang.String scala.runtime.BoxedUnit ), $anonfun$applyOrElse$28(com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.String scala.runtime.BoxedUnit ), $anonfun$applyOrElse$29(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String ), $anonfun$applyOrElse$30$adapted(java.lang.String com.daml.ledger.api.v1.completion.Completion ), $anonfun$applyOrElse$31(com.daml.ledger.api.testtool.suites.v1_8.CommandSubmissionCompletionIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String scala.Option ), $anonfun$applyOrElse$32(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String ), $anonfun$applyOrElse$33$adapted(java.lang.String com.daml.ledger.api.v1.completion.Completion ), $anonfun$applyOrElse$34$adapted(scala.Option )}, serializedLambda);
            }
        });
    }
}

