/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.LedgerConfigurationServiceIT$$anonfun$;
import com.daml.ledger.api.v1.ledger_configuration_service.LedgerConfiguration;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0001%!)\u0011\u0004\u0001C\u00015\taB*\u001a3hKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK&#&B\u0001\u0003\u0006\u0003\u00111\u0018g\u0018\u001d\u000b\u0005\u00199\u0011AB:vSR,7O\u0003\u0002\t\u0013\u0005AA/Z:ui>|GN\u0003\u0002\u000b\u0017\u0005\u0019\u0011\r]5\u000b\u00051i\u0011A\u00027fI\u001e,'O\u0003\u0002\u000f\u001f\u0005!A-Y7m\u0015\u0005\u0001\u0012aA2p[\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\t1r!\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005a)\"a\u0004'fI\u001e,'\u000fV3tiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0019\u0001")
public class LedgerConfigurationServiceIT
extends LedgerTestSuite {
    public LedgerConfigurationServiceIT() {
        this.test("ConfigSucceeds", "Return a valid configuration for a valid request", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)ledger.configuration(ledger.configuration$default$1()).map((Function1 & Serializable)config -> {
                        $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$1(config);
                        return BoxedUnit.UNIT;
                    }, this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1(LedgerConfiguration config) {
                Predef$.MODULE$.assert(config.maxDeduplicationDuration().isDefined(), (Function0 & Serializable)() -> "The maxDeduplicationDuration field of the configuration is empty");
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.daml.ledger.api.v1.ledger_configuration_service.LedgerConfiguration ), $anonfun$applyOrElse$2()}, serializedLambda);
            }
        });
        this.test("ConfigLedgerId", "Return NOT_FOUND to invalid ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    String invalidLedgerId = "THIS_IS_AN_INVALID_LEDGER_ID";
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.configuration((Option)new Some((Object)invalidLedgerId))).mustFail("retrieving ledger configuration with an invalid ledger ID", this.ec$2).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$3(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(String invalidLedgerId$1, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$1).append("' not found.").toString()), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
    }
}

