/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.PackageServiceIT$$anonfun$;
import com.daml.ledger.api.v1.package_service.GetPackageResponse;
import com.daml.ledger.api.v1.package_service.PackageStatus;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u001d2Aa\u0001\u0003\u0003'!)!\u0004\u0001C\u00017!1a\u0004\u0001Q\u0001\n}\u0011\u0001\u0003U1dW\u0006<WmU3sm&\u001cW-\u0013+\u000b\u0005\u00151\u0011\u0001\u0002<2?bR!a\u0002\u0005\u0002\rM,\u0018\u000e^3t\u0015\tI!\"\u0001\u0005uKN$Ho\\8m\u0015\tYA\"A\u0002ba&T!!\u0004\b\u0002\r1,GmZ3s\u0015\ty\u0001#\u0001\u0003eC6d'\"A\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016L!!\u0007\f\u0003\u001f1+GmZ3s)\u0016\u001cHoU;ji\u0016\fa\u0001P5oSRtD#\u0001\u000f\u0011\u0005u\u0001Q\"\u0001\u0003\u0002!Ut7N\\8x]B\u000b7m[1hK&#\u0007C\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\nAA[1wC&\u0011a%\t\u0002\u0007'R\u0014\u0018N\\4")
public final class PackageServiceIT
extends LedgerTestSuite {
    public final String com$daml$ledger$api$testtool$suites$v1_8$PackageServiceIT$$unknownPackageId;

    public PackageServiceIT() {
        this.com$daml$ledger$api$testtool$suites$v1_8$PackageServiceIT$$unknownPackageId = " ";
        this.test("PackagesList", "Listing packages should return a result", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)ledger.listPackages().map((Function1 & Serializable)knownPackages -> {
                        $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$1(knownPackages);
                        return BoxedUnit.UNIT;
                    }, this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1(Seq knownPackages) {
                Predef$.MODULE$.assert(knownPackages.size() >= 3, (Function0 & Serializable)() -> new StringBuilder(75).append("List of packages was expected to contain at least 3 packages, got ").append(knownPackages.size()).append(" instead.").toString());
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(scala.collection.immutable.Seq ), $anonfun$applyOrElse$2(scala.collection.immutable.Seq )}, serializedLambda);
            }
        });
        this.test("PackagesGetKnown", "Getting package content should return a valid result", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)ledger.listPackages().map((Function1 & Serializable)x$1 -> (String)x$1.headOption().getOrElse((Function0 & Serializable)() -> Assertions$.MODULE$.fail("No package found")), this.ec$2).flatMap((Function1 & Serializable)somePackageId -> ledger.getPackage(somePackageId).map((Function1 & Serializable)somePackage -> {
                        $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$6(somePackageId, somePackage);
                        return BoxedUnit.UNIT;
                    }, $this.ec$2), this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$6(String somePackageId$1, GetPackageResponse somePackage) {
                Predef$.MODULE$.assert(somePackage.hash().length() > 0, (Function0 & Serializable)() -> new StringBuilder(27).append("Package ").append(somePackageId$1).append(" has an empty hash.").toString());
                String string = somePackage.hash();
                String string2 = somePackageId$1;
                Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> new StringBuilder(64).append("Package ").append(somePackageId$1).append(" has hash ").append(somePackage.hash()).append(", expected hash to be equal to the package ID.").toString());
                Predef$.MODULE$.assert(somePackage.archivePayload().size() >= 0, (Function0 & Serializable)() -> new StringBuilder(23).append("Package ").append(somePackageId$1).append(" has zero size.").toString());
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(scala.collection.immutable.Seq ), $anonfun$applyOrElse$4(), $anonfun$applyOrElse$5(com.daml.ledger.api.testtool.suites.v1_8.PackageServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String ), $anonfun$applyOrElse$6$adapted(java.lang.String com.daml.ledger.api.v1.package_service.GetPackageResponse ), $anonfun$applyOrElse$7(java.lang.String ), $anonfun$applyOrElse$8(java.lang.String com.daml.ledger.api.v1.package_service.GetPackageResponse ), $anonfun$applyOrElse$9(java.lang.String )}, serializedLambda);
            }
        });
        this.test("PackagesGetUnknown", "Getting package content for an unknown package should fail", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ PackageServiceIT $outer;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.getPackage(this.$outer.com$daml$ledger$api$testtool$suites$v1_8$PackageServiceIT$$unknownPackageId)).mustFail("getting the contents of an unknown package", this.ec$3).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$10(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$10(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.NotFound$.Package$.MODULE$, (Option)None$.MODULE$, Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("PackagesStatusKnown", "Getting package status should return a valid result", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)ledger.listPackages().map((Function1 & Serializable)x$2 -> (String)x$2.headOption().getOrElse((Function0 & Serializable)() -> Assertions$.MODULE$.fail("No package found")), this.ec$4).flatMap((Function1 & Serializable)somePackageId -> ledger.getPackageStatus(somePackageId).map((Function1 & Serializable)status -> {
                        $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$14(somePackageId, status);
                        return BoxedUnit.UNIT;
                    }, $this.ec$4), this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$14(String somePackageId$2, PackageStatus status) {
                Predef$.MODULE$.assert(status.isRegistered(), (Function0 & Serializable)() -> new StringBuilder(27).append("Package ").append(somePackageId$2).append(" is not registered.").toString());
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$11(scala.collection.immutable.Seq ), $anonfun$applyOrElse$12(), $anonfun$applyOrElse$13(com.daml.ledger.api.testtool.suites.v1_8.PackageServiceIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String ), $anonfun$applyOrElse$14$adapted(java.lang.String com.daml.ledger.api.v1.package_service.PackageStatus ), $anonfun$applyOrElse$15(java.lang.String )}, serializedLambda);
            }
        });
        this.test("PackagesStatusUnknown", "Getting package status for an unknown package should fail", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ PackageServiceIT $outer;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)ledger.getPackageStatus(this.$outer.com$daml$ledger$api$testtool$suites$v1_8$PackageServiceIT$$unknownPackageId).map((Function1 & Serializable)status -> {
                        $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$16(this, status);
                        return BoxedUnit.UNIT;
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$16($anonfun$$nestedInanonfun$new$5$1 $this, PackageStatus status) {
                Predef$.MODULE$.assert(status.isUnknown(), (Function0 & Serializable)() -> new StringBuilder(24).append("Package ").append($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$PackageServiceIT$$unknownPackageId).append(" is not unknown.").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$16$adapted(com.daml.ledger.api.testtool.suites.v1_8.PackageServiceIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.v1.package_service.PackageStatus ), $anonfun$applyOrElse$17(com.daml.ledger.api.testtool.suites.v1_8.PackageServiceIT$$anonfun$$nestedInanonfun$new$5$1 )}, serializedLambda);
            }
        });
    }
}

