/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.CommandExecution;
import com.daml.error.definitions.groups.ConsistencyErrors;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.Eventually$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.Synchronize$;
import com.daml.ledger.api.testtool.infrastructure.TransactionHelpers$;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest;
import com.daml.ledger.api.v1.commands.Command;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.api.v1.value.Identifier;
import com.daml.ledger.api.v1.value.Record;
import com.daml.ledger.api.v1.value.RecordField;
import com.daml.ledger.api.v1.value.Value;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.client.binding.package$;
import com.daml.ledger.test.semantic.SemanticTests.Amount;
import com.daml.ledger.test.semantic.SemanticTests.Delegation;
import com.daml.ledger.test.semantic.SemanticTests.Delegation$;
import com.daml.ledger.test.semantic.SemanticTests.FetchIou;
import com.daml.ledger.test.semantic.SemanticTests.FetchIou$;
import com.daml.ledger.test.semantic.SemanticTests.FetchPaintAgree;
import com.daml.ledger.test.semantic.SemanticTests.FetchPaintAgree$;
import com.daml.ledger.test.semantic.SemanticTests.FetchPaintOffer;
import com.daml.ledger.test.semantic.SemanticTests.FetchPaintOffer$;
import com.daml.ledger.test.semantic.SemanticTests.Iou;
import com.daml.ledger.test.semantic.SemanticTests.Iou$;
import com.daml.ledger.test.semantic.SemanticTests.PaintAgree;
import com.daml.ledger.test.semantic.SemanticTests.PaintAgree$;
import com.daml.ledger.test.semantic.SemanticTests.PaintCounterOffer;
import com.daml.ledger.test.semantic.SemanticTests.PaintCounterOffer$;
import com.daml.ledger.test.semantic.SemanticTests.PaintOffer;
import com.daml.ledger.test.semantic.SemanticTests.PaintOffer$;
import com.daml.ledger.test.semantic.SemanticTests.SharedContract;
import com.daml.ledger.test.semantic.SemanticTests.SharedContract$;
import com.daml.ledger.test.semantic.SemanticTests.Token;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scalaz.Tag$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001B\u0004\t\u0005]AQA\b\u0001\u0005\u0002}AaA\t\u0001!\u0002\u0013\u0019\u0003BB\u0017\u0001A\u0003%1\u0005C\u0003/\u0001\u0011%q\u0006C\u0003q\u0001\u0011%\u0011\u000fC\u0003}\u0001\u0011%QPA\u0007TK6\fg\u000e^5d)\u0016\u001cHo\u001d\u0006\u0003\u0013)\tAA^\u0019`q)\u00111\u0002D\u0001\u0007gVLG/Z:\u000b\u00055q\u0011\u0001\u0003;fgR$xn\u001c7\u000b\u0005=\u0001\u0012aA1qS*\u0011\u0011CE\u0001\u0007Y\u0016$w-\u001a:\u000b\u0005M!\u0012\u0001\u00023b[2T\u0011!F\u0001\u0004G>l7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0007\u0002\u001d%tgM]1tiJ,8\r^;sK&\u0011QD\u0007\u0002\u0010\u0019\u0016$w-\u001a:UKN$8+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011\u0001C\u0001\t_:,\u0007k\\;oIB\u0011AeK\u0007\u0002K)\u0011aeJ\u0001\u000e'\u0016l\u0017M\u001c;jGR+7\u000f^:\u000b\u0005!J\u0013\u0001C:f[\u0006tG/[2\u000b\u0005)\u0002\u0012\u0001\u0002;fgRL!\u0001L\u0013\u0003\r\u0005kw.\u001e8u\u0003%!xo\u001c)pk:$7/\u0001\u0005gKR\u001c\u0007.S8v)\u0011\u0001$)\u00135\u0015\u0005Ej\u0004c\u0001\u001a8s5\t1G\u0003\u00025k\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001a\u0003\r\u0019+H/\u001e:f!\tQ4(D\u00016\u0013\taTG\u0001\u0003V]&$\b\"\u0002 \u0005\u0001\by\u0014AA3d!\t\u0011\u0004)\u0003\u0002Bg\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006#\u0011\u0001\ra\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rj\t1\u0002]1si&\u001c\u0017\u000e]1oi&\u0011\u0001*\u0012\u0002\u0017!\u0006\u0014H/[2ja\u0006tG\u000fV3ti\u000e{g\u000e^3yi\")!\n\u0002a\u0001\u0017\u0006)\u0001/\u0019:usB\u0011A\n\u001a\b\u0003\u001b\u0006t!A\u00140\u000f\u0005=[fB\u0001)Z\u001d\t\t\u0006L\u0004\u0002S/:\u00111KV\u0007\u0002)*\u0011QKF\u0001\u0007yI|w\u000e\u001e \n\u0003UI!a\u0005\u000b\n\u0005E\u0011\u0012B\u0001.\u0011\u0003\u0019\u0019G.[3oi&\u0011A,X\u0001\bE&tG-\u001b8h\u0015\tQ\u0006#\u0003\u0002`A\u00069\u0001/Y2lC\u001e,'B\u0001/^\u0013\t\u00117-A\u0005Qe&l\u0017\u000e^5wK*\u0011q\fY\u0005\u0003K\u001a\u0014Q\u0001U1sifL!a\u001a1\u0003\u0013A\u0013\u0018.\\5uSZ,\u0007\"B5\u0005\u0001\u0004Q\u0017aA5pkB\u0019Aj[7\n\u000514'AC\"p]R\u0014\u0018m\u0019;JIB\u0011AE\\\u0005\u0003_\u0016\u00121!S8v\u0003=1W\r^2i!\u0006Lg\u000e^(gM\u0016\u0014H\u0003\u0002:ukZ$\"!M:\t\u000by*\u00019A \t\u000bE)\u0001\u0019A\"\t\u000b)+\u0001\u0019A&\t\u000b],\u0001\u0019\u0001=\u0002\u0015A\f\u0017N\u001c;PM\u001a,'\u000fE\u0002MWf\u0004\"\u0001\n>\n\u0005m,#A\u0003)bS:$xJ\u001a4fe\u0006ya-\u001a;dQB\u000b\u0017N\u001c;BOJ,W\rF\u0004\u007f\u0003\u0003\t\u0019!!\u0002\u0015\u0005Ez\b\"\u0002 \u0007\u0001\by\u0004\"B\t\u0007\u0001\u0004\u0019\u0005\"\u0002&\u0007\u0001\u0004Y\u0005bBA\u0004\r\u0001\u0007\u0011\u0011B\u0001\nC\u001e\u0014X-Z7f]R\u0004B\u0001T6\u0002\fA\u0019A%!\u0004\n\u0007\u0005=QE\u0001\u0006QC&tG/Q4sK\u0016\u0004")
public final class SemanticTests
extends LedgerTestSuite {
    public final Amount com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound = new Amount(scala.package$.MODULE$.BigDecimal().apply(1), "GBP");
    public final Amount com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$twoPounds = new Amount(scala.package$.MODULE$.BigDecimal().apply(2), "GBP");

    public Future<BoxedUnit> com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchIou(ParticipantTestContext ledger, Object party, Object iou, ExecutionContext ec) {
        return ledger.create(party, (Template)new FetchIou(party, iou)).flatMap((Function1 & Serializable)fetch -> ledger.exercise(party, FetchIou.FetchIou$u0020syntax$.MODULE$.exerciseFetchIou_Fetch$extension(FetchIou$.MODULE$.FetchIou$u0020syntax(fetch), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$29 -> {
            transactionTree = x$29;
            return BoxedUnit.UNIT;
        }, ec), ec);
    }

    public Future<BoxedUnit> com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchPaintOffer(ParticipantTestContext ledger, Object party, Object paintOffer, ExecutionContext ec) {
        return ledger.create(party, (Template)new FetchPaintOffer(party, paintOffer)).flatMap((Function1 & Serializable)fetch -> ledger.exercise(party, FetchPaintOffer.FetchPaintOffer$u0020syntax$.MODULE$.exerciseFetchPaintOffer_Fetch$extension(FetchPaintOffer$.MODULE$.FetchPaintOffer$u0020syntax(fetch), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$30 -> {
            transactionTree = x$30;
            return BoxedUnit.UNIT;
        }, ec), ec);
    }

    public Future<BoxedUnit> com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchPaintAgree(ParticipantTestContext ledger, Object party, Object agreement, ExecutionContext ec) {
        return ledger.create(party, (Template)new FetchPaintAgree(party, agreement)).flatMap((Function1 & Serializable)fetch -> ledger.exercise(party, FetchPaintAgree.FetchPaintAgree$u0020syntax$.MODULE$.exerciseFetchPaintAgree_Fetch$extension(FetchPaintAgree$.MODULE$.FetchPaintAgree$u0020syntax(fetch), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$31 -> {
            transactionTree = x$31;
            return BoxedUnit.UNIT;
        }, ec), ec);
    }

    public SemanticTests() {
        this.test("SemanticDoubleSpendBasic", "Cannot double spend across transactions", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.TwoParties$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTests $outer;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object payer = participant.parties().apply(0);
                        Object owner = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(2) == 0) {
                            Object newOwner = participant2.parties().apply(0);
                            Object leftWithNothing = participant2.parties().apply(1);
                            return (B1)alpha.create(payer, (Template)new Iou(payer, owner, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound)).flatMap((Function1 & Serializable)iou -> alpha.exercise(owner, Iou.Iou$u0020syntax$.MODULE$.exerciseTransfer$extension(Iou$.MODULE$.Iou$u0020syntax(iou), newOwner, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$1 -> {
                                TransactionTree transactionTree = x$1;
                                return Assertions$.MODULE$.futureAssertions(alpha.exercise(owner, Iou.Iou$u0020syntax$.MODULE$.exerciseTransfer$extension(Iou$.MODULE$.Iou$u0020syntax(iou), leftWithNothing, ExerciseOn$.MODULE$.OnId()))).mustFail("consuming a contract twice", $this.ec$1).map((Function1 & Serializable)failure -> {
                                    $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$3(failure);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$1);
                            }, $this.ec$1), this.ec$1);
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participants participants = x1;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(2) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$2(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$3$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("SemanticConcurrentDoubleSpend", "Cannot concurrently double spend across transactions", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object payer = participant.parties().apply(0);
                        Object owner1 = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object owner2 = participant2.parties().apply(0);
                            int creates = 2;
                            int archives = 10;
                            return (B1)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), creates).foldLeft((Object)Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {}, this.ec$2), (Function2 & Serializable)(f, c) -> $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$5(this, alpha, payer, owner1, owner2, beta, archives, f, BoxesRunTime.unboxToInt((Object)c)));
                        }
                    }
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participants participants = x2;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ Future $anonfun$applyOrElse$9($anonfun$$nestedInanonfun$new$2$1 $this, ParticipantTestContext alpha$2, Object owner1$1, Object shared$1, ParticipantTestContext beta$1, Object owner2$1, int x0$1) {
                int n = x0$1;
                switch (n) {
                    default: 
                }
                if (n % 2 == 0) {
                    return alpha$2.exercise(owner1$1, SharedContract.SharedContract$u0020syntax$.MODULE$.exerciseSharedContract_Consume1$extension(SharedContract$.MODULE$.SharedContract$u0020syntax(shared$1), ExerciseOn$.MODULE$.OnId())).transform((Function1 & Serializable)x$3 -> new Success(x$3), $this.ec$2);
                }
                return beta$1.exercise(owner2$1, SharedContract.SharedContract$u0020syntax$.MODULE$.exerciseSharedContract_Consume2$extension(SharedContract$.MODULE$.SharedContract$u0020syntax(shared$1), ExerciseOn$.MODULE$.OnId())).transform((Function1 & Serializable)x$4 -> new Success(x$4), $this.ec$2);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$13(Try x$5) {
                return x$5.isSuccess();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$14(Try x$6) {
                return x$6.isFailure();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$12(int c$1, int archives$1, IndexedSeq results) {
                Assertions$.MODULE$.assertLength(new StringBuilder(29).append("Contract ").append(c$1).append(" successful archives").toString(), 1, (Seq)results.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$13(x$5))));
                Assertions$.MODULE$.assertLength(new StringBuilder(25).append("Contract ").append(c$1).append(" failed archives").toString(), archives$1 - 1, (Seq)results.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$14(x$6))));
            }

            public static final /* synthetic */ Future $anonfun$applyOrElse$5($anonfun$$nestedInanonfun$new$2$1 $this, ParticipantTestContext alpha$2, Object payer$1, Object owner1$1, Object owner2$1, ParticipantTestContext beta$1, int archives$1, Future f, int c) {
                return f.flatMap((Function1 & Serializable)x$2 -> alpha$2.create(payer$1, (Template)new SharedContract(payer$1, owner1$1, owner2$1)).flatMap((Function1 & Serializable)shared -> Synchronize$.MODULE$.synchronize(alpha$2, beta$1, $this.ec$2).flatMap((Function1 & Serializable)x$7 -> {
                    BoxedUnit boxedUnit = x$7;
                    return Future$.MODULE$.traverse((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), archives$1), (Function1 & Serializable)x0$1 -> $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$9($this, alpha$2, owner1$1, shared, beta$1, owner2$1, BoxesRunTime.unboxToInt((Object)x0$1)), BuildFrom$.MODULE$.buildFromIterableOps(), $this.ec$2).map((Function1 & Serializable)results -> {
                        $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$12(c, archives$1, results);
                        return BoxedUnit.UNIT;
                    }, $this.ec$2);
                }, $this.ec$2), $this.ec$2), $this.ec$2);
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(scala.util.Try ), $anonfun$applyOrElse$11(scala.util.Try ), $anonfun$applyOrElse$12$adapted(int int scala.collection.immutable.IndexedSeq ), $anonfun$applyOrElse$13$adapted(scala.util.Try ), $anonfun$applyOrElse$14$adapted(scala.util.Try ), $anonfun$applyOrElse$4(), $anonfun$applyOrElse$5$adapted(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext int scala.concurrent.Future java.lang.Object ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext int int scala.runtime.BoxedUnit ), $anonfun$applyOrElse$7(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext int java.lang.Object java.lang.Object int java.lang.Object ), $anonfun$applyOrElse$8(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$2$1 int com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object int scala.runtime.BoxedUnit ), $anonfun$applyOrElse$9$adapted(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object )}, serializedLambda);
            }
        });
        this.test("SemanticDoubleSpendSameTx", "Cannot double spend within a transaction", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.TwoParties$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTests $outer;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object payer = participant.parties().apply(0);
                        Object owner = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(2) == 0) {
                            Object newOwner1 = participant2.parties().apply(0);
                            Object newOwner2 = participant2.parties().apply(1);
                            return (B1)alpha.create(payer, (Template)new Iou(payer, owner, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound)).map((Function1 & Serializable)iou -> {
                                SubmitAndWaitRequest doubleSpend = alpha.submitAndWaitRequest(owner, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{Iou.Iou$u0020syntax$.MODULE$.exerciseTransfer$extension(Iou$.MODULE$.Iou$u0020syntax(iou), newOwner1, ExerciseOn$.MODULE$.OnId()).command(), Iou.Iou$u0020syntax$.MODULE$.exerciseTransfer$extension(Iou$.MODULE$.Iou$u0020syntax(iou), newOwner2, ExerciseOn$.MODULE$.OnId()).command()}));
                                return new Tuple2(iou, (Object)doubleSpend);
                            }, this.ec$3).flatMap((Function1 & Serializable)x$8 -> {
                                Tuple2 tuple2 = x$8;
                                if (tuple2 != null) {
                                    SubmitAndWaitRequest doubleSpend = (SubmitAndWaitRequest)tuple2._2();
                                    return Assertions$.MODULE$.futureAssertions(alpha.submitAndWait(doubleSpend)).mustFail("consuming a contract twice", $this.ec$3).map((Function1 & Serializable)failure -> {
                                        $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$17(failure);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$3);
                                }
                                throw new MatchError((Object)tuple2);
                            }, this.ec$3);
                        }
                    }
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participants participants = x3;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(2) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$17(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)CommandExecution.Interpreter$.ContractNotActive$.MODULE$, (Option)new Some((Object)"Update failed due to fetch of an inactive contract"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$15(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$16(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple2 ), $anonfun$applyOrElse$17$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("SemanticDoubleSpendShared", "Different parties cannot spend the same contract", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object payer = participant.parties().apply(0);
                        Object owner1 = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object owner2 = participant2.parties().apply(0);
                            return (B1)alpha.create(payer, (Template)new SharedContract(payer, owner1, owner2)).flatMap((Function1 & Serializable)shared -> alpha.exercise(owner1, SharedContract.SharedContract$u0020syntax$.MODULE$.exerciseSharedContract_Consume1$extension(SharedContract$.MODULE$.SharedContract$u0020syntax(shared), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$10 -> {
                                TransactionTree transactionTree = x$10;
                                return Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$4).flatMap((Function1 & Serializable)x$9 -> {
                                    BoxedUnit boxedUnit = x$9;
                                    return Assertions$.MODULE$.futureAssertions(beta.exercise(owner2, SharedContract.SharedContract$u0020syntax$.MODULE$.exerciseSharedContract_Consume2$extension(SharedContract$.MODULE$.SharedContract$u0020syntax(shared), ExerciseOn$.MODULE$.OnId()))).mustFail("consuming a contract twice", $this.ec$4).map((Function1 & Serializable)failure -> {
                                        $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$21(failure);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$4);
                                }, $this.ec$4);
                            }, $this.ec$4), this.ec$4);
                        }
                    }
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participants participants = x4;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$21(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$18(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$19(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$20(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$21$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("SemanticPaintOffer", "Conduct the paint offer workflow successfully", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTests $outer;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object bank = participant.parties().apply(0);
                        Object houseOwner = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object painter = participant2.parties().apply(0);
                            return (B1)alpha.create(bank, (Template)new Iou(bank, houseOwner, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound)).flatMap((Function1 & Serializable)iou -> beta.create(painter, (Template)new PaintOffer(painter, houseOwner, bank, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound)).flatMap((Function1 & Serializable)offer -> Eventually$.MODULE$.eventually("Exercise paint offer", Eventually$.MODULE$.eventually$default$2(), Eventually$.MODULE$.eventually$default$3(), (Function0 & Serializable)() -> alpha.exercise(houseOwner, PaintOffer.PaintOffer$u0020syntax$.MODULE$.exercisePaintOffer_Accept$extension(PaintOffer$.MODULE$.PaintOffer$u0020syntax(offer), iou, ExerciseOn$.MODULE$.OnId())), $this.ec$5).map((Function1 & Serializable)tree -> {
                                $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$25(painter, houseOwner, tree);
                                return BoxedUnit.UNIT;
                            }, $this.ec$5), $this.ec$5), this.ec$5);
                        }
                    }
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participants participants = x5;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$26(CreatedEvent x$11) {
                Identifier identifier = x$11.getTemplateId();
                Object object = Tag$.MODULE$.unwrap(PaintAgree$.MODULE$.id());
                return !(identifier != null ? !identifier.equals(object) : object != null);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$25(Object painter$1, Object houseOwner$1, TransactionTree tree) {
                CreatedEvent agreement = (CreatedEvent)Assertions$.MODULE$.assertSingleton("SemanticPaintOffer", (Seq)TransactionHelpers$.MODULE$.createdEvents(tree).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$26(x$11))));
                Assertions$.MODULE$.assertEquals("Paint agreement parameters", (Object)agreement.getCreateArguments(), (Object)new Record((Option)new Some(Tag$.MODULE$.unwrap(PaintAgree$.MODULE$.id())), (Seq)new .colon.colon((Object)new RecordField("painter", (Option)new Some((Object)new Value((Value.Sum)new Value.Sum$.Party((String)Tag$.MODULE$.unwrap(painter$1))))), (List)new .colon.colon((Object)new RecordField("houseOwner", (Option)new Some((Object)new Value((Value.Sum)new Value.Sum$.Party((String)Tag$.MODULE$.unwrap(houseOwner$1))))), (List)Nil$.MODULE$))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$22(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$23(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$24(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$25$adapted(java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$26$adapted(com.daml.ledger.api.v1.event.CreatedEvent )}, serializedLambda);
            }
        });
        this.test("SemanticPaintCounterOffer", "Conduct the paint counter-offer workflow successfully", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTests $outer;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object bank = participant.parties().apply(0);
                        Object houseOwner = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object painter = participant2.parties().apply(0);
                            return (B1)alpha.create(bank, (Template)new Iou(bank, houseOwner, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound)).flatMap((Function1 & Serializable)iou -> beta.create(painter, (Template)new PaintOffer(painter, houseOwner, bank, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$twoPounds)).flatMap((Function1 & Serializable)offer -> Eventually$.MODULE$.eventually("exerciseAndGetContract", Eventually$.MODULE$.eventually$default$2(), Eventually$.MODULE$.eventually$default$3(), (Function0 & Serializable)() -> alpha.exerciseAndGetContract(houseOwner, PaintOffer.PaintOffer$u0020syntax$.MODULE$.exercisePaintOffer_Counter$extension(PaintOffer$.MODULE$.PaintOffer$u0020syntax(offer), iou, ExerciseOn$.MODULE$.OnId())), $this.ec$6).flatMap((Function1 & Serializable)counter -> Eventually$.MODULE$.eventually("exercisePaintCounterOffer", Eventually$.MODULE$.eventually$default$2(), Eventually$.MODULE$.eventually$default$3(), (Function0 & Serializable)() -> beta.exercise(painter, PaintCounterOffer.PaintCounterOffer$u0020syntax$.MODULE$.exercisePaintCounterOffer_Accept$extension(PaintCounterOffer$.MODULE$.PaintCounterOffer$u0020syntax(counter), ExerciseOn$.MODULE$.OnId())), $this.ec$6).map((Function1 & Serializable)tree -> {
                                $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$32(painter, houseOwner, tree);
                                return BoxedUnit.UNIT;
                            }, $this.ec$6), $this.ec$6), $this.ec$6), this.ec$6);
                        }
                    }
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participants participants = x6;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$33(CreatedEvent x$12) {
                Identifier identifier = x$12.getTemplateId();
                Object object = Tag$.MODULE$.unwrap(PaintAgree$.MODULE$.id());
                return !(identifier != null ? !identifier.equals(object) : object != null);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$32(Object painter$2, Object houseOwner$2, TransactionTree tree) {
                CreatedEvent agreement = (CreatedEvent)Assertions$.MODULE$.assertSingleton("SemanticPaintCounterOffer", (Seq)TransactionHelpers$.MODULE$.createdEvents(tree).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$33(x$12))));
                Assertions$.MODULE$.assertEquals("Paint agreement parameters", (Object)agreement.getCreateArguments(), (Object)new Record((Option)new Some(Tag$.MODULE$.unwrap(PaintAgree$.MODULE$.id())), (Seq)new .colon.colon((Object)new RecordField("painter", (Option)new Some((Object)new Value((Value.Sum)new Value.Sum$.Party((String)Tag$.MODULE$.unwrap(painter$2))))), (List)new .colon.colon((Object)new RecordField("houseOwner", (Option)new Some((Object)new Value((Value.Sum)new Value.Sum$.Party((String)Tag$.MODULE$.unwrap(houseOwner$2))))), (List)Nil$.MODULE$))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$27(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$28(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$29(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$30(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$31(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$32$adapted(java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$33$adapted(com.daml.ledger.api.v1.event.CreatedEvent )}, serializedLambda);
            }
        });
        this.test("SemanticPartialSignatories", "A signatory should not be able to create a contract on behalf of two parties", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object houseOwner = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            Object painter = participant2.parties().apply(0);
                            return (B1)Assertions$.MODULE$.futureAssertions(alpha.create(houseOwner, (Template)new PaintAgree(painter, houseOwner))).mustFail("creating a contract on behalf of two parties", this.ec$7).map((Function1 & Serializable)failure -> {
                                $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$34(failure);
                                return BoxedUnit.UNIT;
                            }, this.ec$7);
                        }
                    }
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participants participants = x7;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$34(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)CommandExecution.Interpreter$.AuthorizationError$.MODULE$, (Option)new Some((Object)"requires authorizers"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$34$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("SemanticAcceptOnBehalf", "It should not be possible to exercise a choice without the consent of the controller", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTests $outer;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        Object bank = participant.parties().apply(0);
                        Object houseOwner = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object painter = participant2.parties().apply(0);
                            return (B1)beta.create(painter, (Template)new Iou(painter, houseOwner, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound)).flatMap((Function1 & Serializable)iou -> beta.create(painter, (Template)new PaintOffer(painter, houseOwner, bank, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound)).flatMap((Function1 & Serializable)offer -> Assertions$.MODULE$.futureAssertions(beta.exercise(painter, PaintOffer.PaintOffer$u0020syntax$.MODULE$.exercisePaintOffer_Accept$extension(PaintOffer$.MODULE$.PaintOffer$u0020syntax(offer), iou, ExerciseOn$.MODULE$.OnId()))).mustFail("exercising a choice without consent", $this.ec$8).map((Function1 & Serializable)failure -> {
                                $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$37(failure);
                                return BoxedUnit.UNIT;
                            }, $this.ec$8), $this.ec$8), this.ec$8);
                        }
                    }
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participants participants = x8;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$37(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)CommandExecution.Interpreter$.AuthorizationError$.MODULE$, (Option)new Some((Object)"requires authorizers"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$35(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$36(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$37$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("SemanticPrivacyProjections", "Test visibility via contract fetches for the paint-offer flow", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), 2.0, this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTests $outer;
            private final ExecutionContext ec$9;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                A1 A1 = x9;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object bank = participant.parties().apply(0);
                        Object houseOwner = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object painter = participant2.parties().apply(0);
                            return (B1)alpha.create(bank, (Template)new Iou(bank, houseOwner, this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound)).flatMap((Function1 & Serializable)iou -> Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$9).flatMap((Function1 & Serializable)x$28 -> {
                                BoxedUnit boxedUnit = x$28;
                                return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchIou(alpha, bank, iou, $this.ec$9).flatMap((Function1 & Serializable)x$27 -> {
                                    BoxedUnit boxedUnit = x$27;
                                    return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchIou(alpha, houseOwner, iou, $this.ec$9).flatMap((Function1 & Serializable)x$26 -> {
                                        BoxedUnit boxedUnit = x$26;
                                        return Assertions$.MODULE$.futureAssertions($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchIou(beta, painter, iou, $this.ec$9)).mustFail("fetching the IOU with the wrong party", $this.ec$9).flatMap((Function1 & Serializable)iouFetchFailure -> beta.create(painter, (Template)new PaintOffer(painter, houseOwner, bank, $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$onePound)).flatMap((Function1 & Serializable)offer -> Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$9).flatMap((Function1 & Serializable)x$25 -> {
                                            BoxedUnit boxedUnit = x$25;
                                            return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchPaintOffer(alpha, houseOwner, offer, $this.ec$9).flatMap((Function1 & Serializable)x$24 -> {
                                                BoxedUnit boxedUnit = x$24;
                                                return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchPaintOffer(beta, painter, offer, $this.ec$9).flatMap((Function1 & Serializable)x$23 -> {
                                                    BoxedUnit boxedUnit = x$23;
                                                    return Assertions$.MODULE$.futureAssertions($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchPaintOffer(alpha, bank, offer, $this.ec$9)).mustFail("fetching the offer with the wrong party", $this.ec$9).flatMap((Function1 & Serializable)paintOfferFetchFailure -> alpha.exercise(houseOwner, PaintOffer.PaintOffer$u0020syntax$.MODULE$.exercisePaintOffer_Accept$extension(PaintOffer$.MODULE$.PaintOffer$u0020syntax(offer), iou, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)tree -> {
                                                        Tuple2 tuple2 = TransactionHelpers$.MODULE$.createdEvents(tree).partition((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$49(x$13)));
                                                        if (tuple2 == null) {
                                                            throw new MatchError((Object)tuple2);
                                                        }
                                                        Vector newIouEvents = (Vector)tuple2._1();
                                                        Vector agreementEvents = (Vector)tuple2._2();
                                                        Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)newIouEvents, (Object)agreementEvents);
                                                        Tuple2 x$14 = (Tuple2)tuple3._1();
                                                        Vector newIouEvents2 = (Vector)tuple3._2();
                                                        Vector agreementEvents2 = (Vector)tuple3._3();
                                                        return new Tuple2(tree, (Object)x$14);
                                                    }, $this.ec$9).flatMap((Function1 & Serializable)x$22 -> {
                                                        Tuple2 tuple2;
                                                        Tuple2 tuple22 = x$22;
                                                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                                                            Vector newIouEvents = (Vector)tuple2._1();
                                                            Vector agreementEvents = (Vector)tuple2._2();
                                                            return Future$.MODULE$.apply((Function0 & Serializable)() -> (CreatedEvent)newIouEvents.head(), $this.ec$9).flatMap((Function1 & Serializable)newIouEvent -> Future$.MODULE$.apply((Function0 & Serializable)() -> (CreatedEvent)agreementEvents.head(), $this.ec$9).map((Function1 & Serializable)agreementEvent -> {
                                                                Object newIou = package$.MODULE$.Primitive().ContractId().apply(newIouEvent.contractId());
                                                                Object agreement = package$.MODULE$.Primitive().ContractId().apply(agreementEvent.contractId());
                                                                return new Tuple3(agreementEvent, newIou, agreement);
                                                            }, $this.ec$9).flatMap((Function1 & Serializable)x$21 -> {
                                                                Tuple3 tuple3 = x$21;
                                                                if (tuple3 != null) {
                                                                    Object newIou = tuple3._2();
                                                                    Object agreement = tuple3._3();
                                                                    return Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$9).flatMap((Function1 & Serializable)x$20 -> {
                                                                        BoxedUnit boxedUnit = x$20;
                                                                        return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchIou(alpha, bank, newIou, $this.ec$9).flatMap((Function1 & Serializable)x$19 -> {
                                                                            BoxedUnit boxedUnit = x$19;
                                                                            return Assertions$.MODULE$.futureAssertions($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchPaintAgree(alpha, bank, agreement, $this.ec$9)).mustFail("fetching the agreement with the wrong party", $this.ec$9).flatMap((Function1 & Serializable)paintAgreeFetchFailure -> $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchPaintAgree(beta, painter, agreement, $this.ec$9).flatMap((Function1 & Serializable)x$18 -> {
                                                                                BoxedUnit boxedUnit = x$18;
                                                                                return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchPaintAgree(alpha, houseOwner, agreement, $this.ec$9).flatMap((Function1 & Serializable)x$17 -> {
                                                                                    BoxedUnit boxedUnit = x$17;
                                                                                    return $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchIou(beta, painter, newIou, $this.ec$9).flatMap((Function1 & Serializable)x$16 -> {
                                                                                        BoxedUnit boxedUnit = x$16;
                                                                                        return Assertions$.MODULE$.futureAssertions($this.$outer.com$daml$ledger$api$testtool$suites$v1_8$SemanticTests$$fetchIou(alpha, houseOwner, newIou, $this.ec$9)).mustFail("fetching the new IOU with the wrong party", $this.ec$9).map((Function1 & Serializable)secondIouFetchFailure -> {
                                                                                            $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$62(iouFetchFailure, paintOfferFetchFailure, paintAgreeFetchFailure, secondIouFetchFailure);
                                                                                            return BoxedUnit.UNIT;
                                                                                        }, $this.ec$9);
                                                                                    }, $this.ec$9);
                                                                                }, $this.ec$9);
                                                                            }, $this.ec$9), $this.ec$9);
                                                                        }, $this.ec$9);
                                                                    }, $this.ec$9);
                                                                }
                                                                throw new MatchError((Object)tuple3);
                                                            }, $this.ec$9), $this.ec$9);
                                                        }
                                                        throw new MatchError((Object)tuple22);
                                                    }, $this.ec$9), $this.ec$9);
                                                }, $this.ec$9);
                                            }, $this.ec$9);
                                        }, $this.ec$9), $this.ec$9), $this.ec$9);
                                    }, $this.ec$9);
                                }, $this.ec$9);
                            }, $this.ec$9), this.ec$9);
                        }
                    }
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Allocation.Participants x9) {
                Allocation.Participants participants = x9;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$49(CreatedEvent x$13) {
                Identifier identifier = x$13.getTemplateId();
                Object object = Tag$.MODULE$.unwrap(Iou$.MODULE$.id());
                return !(identifier != null ? !identifier.equals(object) : object != null);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$62(Throwable iouFetchFailure$1, Throwable paintOfferFetchFailure$1, Throwable paintAgreeFetchFailure$1, Throwable secondIouFetchFailure) {
                Assertions$.MODULE$.assertGrpcError(iouFetchFailure$1, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(paintOfferFetchFailure$1, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(paintAgreeFetchFailure$1, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(secondIouFetchFailure, (ErrorCode)CommandExecution.Interpreter$.AuthorizationError$.MODULE$, (Option)new Some((Object)"requires one of the stakeholders"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$9 = ec$9;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$38(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$39(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$40(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$41(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.runtime.BoxedUnit ), $anonfun$applyOrElse$42(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Throwable ), $anonfun$applyOrElse$43(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Throwable java.lang.Object ), $anonfun$applyOrElse$44(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$45(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$46(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$47(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$48(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$49$adapted(com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$50(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable scala.Tuple2 ), $anonfun$applyOrElse$51(scala.collection.immutable.Vector ), $anonfun$applyOrElse$52(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 scala.collection.immutable.Vector com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$53(scala.collection.immutable.Vector ), $anonfun$applyOrElse$54(com.daml.ledger.api.v1.event.CreatedEvent com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$55(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable scala.Tuple3 ), $anonfun$applyOrElse$56(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$57(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$58(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$59(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$60(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$61(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$62$adapted(java.lang.Throwable java.lang.Throwable java.lang.Throwable java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("SemanticDivulgence", "Respect divulgence rules", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$13;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                A1 A1 = x10;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object issuer = participant.parties().apply(0);
                        Object owner = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object delegate = participant2.parties().apply(0);
                            return (B1)alpha.create(issuer, (Template)new Token(issuer, owner, 1L)).flatMap((Function1 & Serializable)token -> alpha.create(owner, (Template)new Delegation(owner, delegate)).flatMap((Function1 & Serializable)delegation -> alpha.create(owner, (Template)new Delegation(owner, delegate)).flatMap((Function1 & Serializable)noDivulgeToken -> alpha.exercise(owner, Delegation.Delegation$u0020syntax$.MODULE$.exerciseDelegation_Wrong_Divulge_Token$extension(Delegation$.MODULE$.Delegation$u0020syntax(noDivulgeToken), token, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$35 -> {
                                TransactionTree transactionTree = x$35;
                                return Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$13).flatMap((Function1 & Serializable)x$34 -> {
                                    BoxedUnit boxedUnit = x$34;
                                    return Assertions$.MODULE$.futureAssertions(beta.exercise(delegate, Delegation.Delegation$u0020syntax$.MODULE$.exerciseDelegation_Token_Consume$extension(Delegation$.MODULE$.Delegation$u0020syntax(delegation), token, ExerciseOn$.MODULE$.OnId()))).mustFail("divulging with a non-consuming choice", $this.ec$13).flatMap((Function1 & Serializable)failure -> alpha.create(owner, (Template)new Delegation(owner, delegate)).flatMap((Function1 & Serializable)divulgeToken -> alpha.exercise(owner, Delegation.Delegation$u0020syntax$.MODULE$.exerciseDelegation_Divulge_Token$extension(Delegation$.MODULE$.Delegation$u0020syntax(divulgeToken), token, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$33 -> {
                                        TransactionTree transactionTree = x$33;
                                        return Eventually$.MODULE$.eventually("exerciseDelegation_Token_Consume", Eventually$.MODULE$.eventually$default$2(), Eventually$.MODULE$.eventually$default$3(), (Function0 & Serializable)() -> beta.exercise(delegate, Delegation.Delegation$u0020syntax$.MODULE$.exerciseDelegation_Token_Consume$extension(Delegation$.MODULE$.Delegation$u0020syntax(delegation), token, ExerciseOn$.MODULE$.OnId())), $this.ec$13).map((Function1 & Serializable)x$32 -> {
                                            $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$72(failure, x$32);
                                            return BoxedUnit.UNIT;
                                        }, $this.ec$13);
                                    }, $this.ec$13), $this.ec$13), $this.ec$13);
                                }, $this.ec$13);
                            }, $this.ec$13), $this.ec$13), $this.ec$13), this.ec$13);
                        }
                    }
                }
                return (B1)function1.apply(x10);
            }

            public final boolean isDefinedAt(Allocation.Participants x10) {
                Allocation.Participants participants = x10;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$72(Throwable failure$1, TransactionTree x$32) {
                TransactionTree transactionTree = x$32;
                Assertions$.MODULE$.assertGrpcError(failure$1, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$13 = ec$13;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$63(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$64(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$65(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$66(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$67(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$68(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Throwable ), $anonfun$applyOrElse$69(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Throwable java.lang.Object ), $anonfun$applyOrElse$70(com.daml.ledger.api.testtool.suites.v1_8.SemanticTests$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$71(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$72$adapted(java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
    }
}

