/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.Synchronize$;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$;
import com.daml.ledger.api.v1.event.Event;
import com.daml.ledger.api.v1.transaction.Transaction;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.test.model.Test.Dummy;
import com.daml.ledger.test.model.Test.Dummy$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0001%!)\u0011\u0004\u0001C\u00015\tIBK]1og\u0006\u001cG/[8o'\u0016\u0014h/[2f#V,'/_%U\u0015\t!Q!\u0001\u0003wc}C$B\u0001\u0004\b\u0003\u0019\u0019X/\u001b;fg*\u0011\u0001\"C\u0001\ti\u0016\u001cH\u000f^8pY*\u0011!bC\u0001\u0004CBL'B\u0001\u0007\u000e\u0003\u0019aW\rZ4fe*\u0011abD\u0001\u0005I\u0006lGNC\u0001\u0011\u0003\r\u0019w.\\\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\u000f\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017B\u0001\r\u0016\u0005=aU\rZ4feR+7\u000f^*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0004\u0001")
public class TransactionServiceQueryIT
extends LedgerTestSuite {
    public TransactionServiceQueryIT() {
        this.test("TXTransactionTreeByIdBasic", "Expose a visible transaction tree by identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> ledger.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)tree -> ledger.transactionTreeById(tree.transactionId(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)byId -> {
                        $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$3(tree, byId);
                        return BoxedUnit.UNIT;
                    }, $this.ec$1), $this.ec$1), this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(TransactionTree tree$1, TransactionTree byId) {
                Assertions$.MODULE$.assertEquals("The transaction fetched by identifier does not match", (Object)tree$1, (Object)byId);
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$2(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$3$adapted(com.daml.ledger.api.v1.transaction.TransactionTree com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("TXInvisibleTransactionTreeById", "Do not expose an invisible transaction tree by identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object party = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object intruder = participant2.parties().apply(0);
                            return (B1)alpha.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> alpha.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)tree -> Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$2).flatMap((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = x$1;
                                return Assertions$.MODULE$.futureAssertions(beta.transactionTreeById(tree.transactionId(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{intruder}))).mustFail("subscribing to an invisible transaction tree", $this.ec$2).map((Function1 & Serializable)failure -> {
                                    $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$7(failure);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$2);
                            }, $this.ec$2), $this.ec$2), this.ec$2);
                        }
                    }
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participants participants = x2;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$7(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.NotFound$.Transaction$.MODULE$, (Option)new Some((Object)"Transaction not found, or not visible."), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$5(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.transaction.TransactionTree java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$7$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTransactionTreeByIdNotFound", "Return NOT_FOUND when looking up a non-existent transaction tree by identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.transactionTreeById(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("a"), 60), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).mustFail("looking up an non-existent transaction tree", this.ec$3).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$8(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$8(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.NotFound$.Transaction$.MODULE$, (Option)new Some((Object)"Transaction not found, or not visible."), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionByIdBasic", "Expose a visible transaction by identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> ledger.exerciseForFlatTransaction(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)transaction -> ledger.flatTransactionById(transaction.transactionId(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)byId -> {
                        $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$11(transaction, byId);
                        return BoxedUnit.UNIT;
                    }, $this.ec$4), $this.ec$4), this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$11(Transaction transaction$1, Transaction byId) {
                Assertions$.MODULE$.assertEquals("The transaction fetched by identifier does not match", (Object)transaction$1, (Object)byId);
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$11$adapted(com.daml.ledger.api.v1.transaction.Transaction com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$9(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object )}, serializedLambda);
            }
        });
        this.test("TXInvisibleFlatTransactionById", "Do not expose an invisible flat transaction by identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Object intruder = participant.parties().apply(1);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> ledger.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)tree -> Assertions$.MODULE$.futureAssertions(ledger.flatTransactionById(tree.transactionId(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{intruder}))).mustFail("looking up an invisible flat transaction", $this.ec$5).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$14(failure);
                        return BoxedUnit.UNIT;
                    }, $this.ec$5), $this.ec$5), this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$14(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.NotFound$.Transaction$.MODULE$, (Option)new Some((Object)"Transaction not found, or not visible."), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$12(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$13(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$14$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionByIdNotFound", "Return NOT_FOUND when looking up a non-existent flat transaction by identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.flatTransactionById(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("a"), 60), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).mustFail("looking up a non-existent flat transaction", this.ec$6).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$15(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$15(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.NotFound$.Transaction$.MODULE$, (Option)new Some((Object)"Transaction not found, or not visible."), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$15$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTransactionTreeByEventIdBasic", "Expose a visible transaction tree by event identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> ledger.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)tree -> ledger.transactionTreeByEventId((String)tree.rootEventIds().head(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)byId -> {
                        $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$18(tree, byId);
                        return BoxedUnit.UNIT;
                    }, $this.ec$7), $this.ec$7), this.ec$7);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$18(TransactionTree tree$3, TransactionTree byId) {
                Assertions$.MODULE$.assertEquals("The transaction fetched by identifier does not match", (Object)tree$3, (Object)byId);
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$16(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$17(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$18$adapted(com.daml.ledger.api.v1.transaction.TransactionTree com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("TXInvisibleTransactionTreeByEventId", "Do not expose an invisible transaction tree by event identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), 2.0, this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object party = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object intruder = participant2.parties().apply(0);
                            return (B1)alpha.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> alpha.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)tree -> Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$8).flatMap((Function1 & Serializable)x$2 -> {
                                BoxedUnit boxedUnit = x$2;
                                return Assertions$.MODULE$.futureAssertions(beta.transactionTreeByEventId((String)tree.rootEventIds().head(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{intruder}))).mustFail("looking up an invisible transaction tree", $this.ec$8).map((Function1 & Serializable)failure -> {
                                    $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$22(failure);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$8);
                            }, $this.ec$8), $this.ec$8), this.ec$8);
                        }
                    }
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participants participants = x8;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$22(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.NotFound$.Transaction$.MODULE$, (Option)new Some((Object)"Transaction not found, or not visible."), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$19(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$20(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$21(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.transaction.TransactionTree java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$22$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTransactionTreeByEventIdNotFound", "Return NOT_FOUND when looking up a non-existent transaction tree by event identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$9;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x9;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.transactionTreeByEventId(new StringBuilder(5).append("#").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("a"), 60)).append(":000").toString(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).mustFail("looking up a non-existent transaction tree", this.ec$9).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$23(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$9);
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Allocation.Participants x9) {
                Allocation.Participant participant;
                Allocation.Participants participants = x9;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$23(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.NotFound$.Transaction$.MODULE$, (Option)new Some((Object)"Transaction not found, or not visible."), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$9 = ec$9;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$23$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionByEventIdBasic", "Expose a visible flat transaction by event identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$10;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x10;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> ledger.exerciseForFlatTransaction(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)transaction -> {
                        Event.Event event = ((Event)transaction.events().head()).event();
                        String eventId = (String)event.archived().map((Function1 & Serializable)x$3 -> x$3.eventId()).get();
                        return new Tuple3(transaction, (Object)event, (Object)eventId);
                    }, $this.ec$10).flatMap((Function1 & Serializable)x$4 -> {
                        Tuple3 tuple3 = x$4;
                        if (tuple3 != null) {
                            Transaction transaction = (Transaction)tuple3._1();
                            String eventId = (String)tuple3._3();
                            return ledger.flatTransactionByEventId(eventId, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)byId -> {
                                $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$28(transaction, byId);
                                return BoxedUnit.UNIT;
                            }, $this.ec$10);
                        }
                        throw new MatchError((Object)tuple3);
                    }, $this.ec$10), this.ec$10);
                }
                return (B1)function1.apply(x10);
            }

            public final boolean isDefinedAt(Allocation.Participants x10) {
                Allocation.Participant participant;
                Allocation.Participants participants = x10;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$28(Transaction transaction$2, Transaction byId) {
                Assertions$.MODULE$.assertEquals("The transaction fetched by identifier does not match", (Object)transaction$2, (Object)byId);
            }
            {
                this.ec$10 = ec$10;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$24(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$25(com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$26(com.daml.ledger.api.v1.event.ArchivedEvent ), $anonfun$applyOrElse$27(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple3 ), $anonfun$applyOrElse$28$adapted(com.daml.ledger.api.v1.transaction.Transaction com.daml.ledger.api.v1.transaction.Transaction )}, serializedLambda);
            }
        });
        this.test("TXInvisibleFlatTransactionByEventId", "Do not expose an invisible flat transaction by event identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$11;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x11;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Object intruder = participant.parties().apply(1);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> ledger.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)tree -> Assertions$.MODULE$.futureAssertions(ledger.flatTransactionByEventId((String)tree.rootEventIds().head(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{intruder}))).mustFail("looking up an invisible flat transaction", $this.ec$11).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$11$1.$anonfun$applyOrElse$31(failure);
                        return BoxedUnit.UNIT;
                    }, $this.ec$11), $this.ec$11), this.ec$11);
                }
                return (B1)function1.apply(x11);
            }

            public final boolean isDefinedAt(Allocation.Participants x11) {
                Allocation.Participant participant;
                Allocation.Participants participants = x11;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$31(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.NotFound$.Transaction$.MODULE$, (Option)new Some((Object)"Transaction not found, or not visible."), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$11 = ec$11;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$29(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$30(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceQueryIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$31$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionByEventIdNotFound", "Return NOT_FOUND when looking up a non-existent flat transaction by event identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$12;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x12;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.flatTransactionByEventId(new StringBuilder(5).append("#").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("a"), 60)).append(":000").toString(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).mustFail("looking up a non-existent flat transaction", this.ec$12).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$12$1.$anonfun$applyOrElse$32(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$12);
                }
                return (B1)function1.apply(x12);
            }

            public final boolean isDefinedAt(Allocation.Participants x12) {
                Allocation.Participant participant;
                Allocation.Participants participants = x12;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$32(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.NotFound$.Transaction$.MODULE$, (Option)new Some((Object)"Transaction not found, or not visible."), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$12 = ec$12;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$32$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
    }
}

