/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.TransactionHelpers$;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest;
import com.daml.ledger.api.v1.commands.Command;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.transaction.Transaction;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest$;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.test.model.Test.Dummy;
import com.daml.ledger.test.model.Test.Dummy$;
import com.daml.ledger.test.model.Test.DummyFactory;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scalaz.Tag$;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0001%!)\u0011\u0004\u0001C\u00015\tYBK]1og\u0006\u001cG/[8o'\u0016\u0014h/[2f'R\u0014X-Y7t\u0013RS!\u0001B\u0003\u0002\tY\ft\f\u000f\u0006\u0003\r\u001d\taa];ji\u0016\u001c(B\u0001\u0005\n\u0003!!Xm\u001d;u_>d'B\u0001\u0006\f\u0003\r\t\u0007/\u001b\u0006\u0003\u00195\ta\u0001\\3eO\u0016\u0014(B\u0001\b\u0010\u0003\u0011!\u0017-\u001c7\u000b\u0003A\t1aY8n\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0005Y9\u0011AD5oMJ\f7\u000f\u001e:vGR,(/Z\u0005\u00031U\u0011q\u0002T3eO\u0016\u0014H+Z:u'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\r\u0001")
public class TransactionServiceStreamsIT
extends LedgerTestSuite {
    public TransactionServiceStreamsIT() {
        this.test("TXBeginToBegin", "An empty stream should be served when getting transactions from and to the beginning of the ledger", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    GetTransactionsRequest request = ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2());
                    GetTransactionsRequest fromAndToBegin = (GetTransactionsRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$1 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$1).begin().$colon$eq((Object)ledger.begin()), (Function1 & Serializable)x$2 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$2).end().$colon$eq((Object)ledger.begin())}));
                    return (B1)ledger.flatTransactions(fromAndToBegin).map((Function1 & Serializable)transactions -> {
                        $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$3(transactions);
                        return BoxedUnit.UNIT;
                    }, this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(Vector transactions) {
                Predef$.MODULE$.assert(transactions.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(53).append("Received a non-empty stream with ").append(transactions.size()).append(" transactions in it.").toString());
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scalapb.lenses.Lens ), $anonfun$applyOrElse$2(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scalapb.lenses.Lens ), $anonfun$applyOrElse$3$adapted(scala.collection.immutable.Vector ), $anonfun$applyOrElse$4(scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("TXTreesBeginToBegin", "An empty stream of trees should be served when getting transactions from and to the beginning of the ledger", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    GetTransactionsRequest request = ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2());
                    GetTransactionsRequest fromAndToBegin = (GetTransactionsRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$3 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$3).begin().$colon$eq((Object)ledger.begin()), (Function1 & Serializable)x$4 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$4).end().$colon$eq((Object)ledger.begin())}));
                    return (B1)ledger.transactionTrees(fromAndToBegin).map((Function1 & Serializable)transactions -> {
                        $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$7(transactions);
                        return BoxedUnit.UNIT;
                    }, this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$7(Vector transactions) {
                Predef$.MODULE$.assert(transactions.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(53).append("Received a non-empty stream with ").append(transactions.size()).append(" transactions in it.").toString());
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scalapb.lenses.Lens ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scalapb.lenses.Lens ), $anonfun$applyOrElse$7$adapted(scala.collection.immutable.Vector ), $anonfun$applyOrElse$8(scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("TXEndToEnd", "An empty stream should be served when getting transactions from and to the end of the ledger", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).map((Function1 & Serializable)x$7 -> {
                        GetTransactionsRequest request = ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2());
                        GetTransactionsRequest endToEnd = (GetTransactionsRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$5 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$5).begin().$colon$eq((Object)ledger.end()), (Function1 & Serializable)x$6 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$6).end().$colon$eq((Object)ledger.end())}));
                        return new Tuple3(x$7, (Object)request, (Object)endToEnd);
                    }, this.ec$3).flatMap((Function1 & Serializable)x$8 -> {
                        Tuple3 tuple3 = x$8;
                        if (tuple3 != null) {
                            GetTransactionsRequest endToEnd = (GetTransactionsRequest)tuple3._3();
                            return ledger.flatTransactions(endToEnd).map((Function1 & Serializable)transactions -> {
                                $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$13(transactions);
                                return BoxedUnit.UNIT;
                            }, $this.ec$3);
                        }
                        throw new MatchError((Object)tuple3);
                    }, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$13(Vector transactions) {
                Predef$.MODULE$.assert(transactions.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(44).append("No transactions were expected but ").append(transactions.size()).append(" were read").toString());
            }
            {
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scalapb.lenses.Lens ), $anonfun$applyOrElse$11(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scalapb.lenses.Lens ), $anonfun$applyOrElse$12(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple3 ), $anonfun$applyOrElse$13$adapted(scala.collection.immutable.Vector ), $anonfun$applyOrElse$14(scala.collection.immutable.Vector ), $anonfun$applyOrElse$9(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object )}, serializedLambda);
            }
        });
        this.test("TXAfterEnd", "An OUT_OF_RANGE error should be returned when subscribing past the ledger end", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)x$12 -> {
                        Object object = x$12;
                        return ledger.offsetBeyondLedgerEnd().map((Function1 & Serializable)futureOffset -> {
                            GetTransactionsRequest request = ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2());
                            GetTransactionsRequest beyondEnd = (GetTransactionsRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$9 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$9).begin().$colon$eq(futureOffset), (Function1 & Serializable)x$10 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$10).optionalEnd().$colon$eq((Object)None$.MODULE$)}));
                            return new Tuple3(futureOffset, (Object)request, (Object)beyondEnd);
                        }, $this.ec$4).flatMap((Function1 & Serializable)x$11 -> {
                            Tuple3 tuple3 = x$11;
                            if (tuple3 != null) {
                                GetTransactionsRequest beyondEnd = (GetTransactionsRequest)tuple3._3();
                                return Assertions$.MODULE$.futureAssertions(ledger.flatTransactions(beyondEnd)).mustFail("subscribing past the ledger end", $this.ec$4).map((Function1 & Serializable)failure -> {
                                    $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$20(failure);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$4);
                            }
                            throw new MatchError((Object)tuple3);
                        }, $this.ec$4);
                    }, this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$20(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.OffsetAfterLedgerEnd$.MODULE$, (Option)new Some((Object)"is after ledger end"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$15(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$16(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$17(com.daml.ledger.api.v1.ledger_offset.LedgerOffset scalapb.lenses.Lens ), $anonfun$applyOrElse$18(scalapb.lenses.Lens ), $anonfun$applyOrElse$19(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple3 ), $anonfun$applyOrElse$20$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTreesAfterEnd", "An OUT_OF_RANGE error should be returned when subscribing to trees past the ledger end", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)x$16 -> {
                        Object object = x$16;
                        return ledger.offsetBeyondLedgerEnd().map((Function1 & Serializable)futureOffset -> {
                            GetTransactionsRequest request = ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2());
                            GetTransactionsRequest beyondEnd = (GetTransactionsRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$13 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$13).begin().$colon$eq(futureOffset), (Function1 & Serializable)x$14 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$14).optionalEnd().$colon$eq((Object)None$.MODULE$)}));
                            return new Tuple3(futureOffset, (Object)request, (Object)beyondEnd);
                        }, $this.ec$5).flatMap((Function1 & Serializable)x$15 -> {
                            Tuple3 tuple3 = x$15;
                            if (tuple3 != null) {
                                GetTransactionsRequest beyondEnd = (GetTransactionsRequest)tuple3._3();
                                return Assertions$.MODULE$.futureAssertions(ledger.transactionTrees(beyondEnd)).mustFail("subscribing past the ledger end", $this.ec$5).map((Function1 & Serializable)failure -> {
                                    $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$26(failure);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$5);
                            }
                            throw new MatchError((Object)tuple3);
                        }, $this.ec$5);
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$26(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.OffsetAfterLedgerEnd$.MODULE$, (Option)new Some((Object)"is after ledger end"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$21(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$22(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$23(com.daml.ledger.api.v1.ledger_offset.LedgerOffset scalapb.lenses.Lens ), $anonfun$applyOrElse$24(scalapb.lenses.Lens ), $anonfun$applyOrElse$25(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple3 ), $anonfun$applyOrElse$26$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXServeUntilCancellation", "Items should be served until the client cancels", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    int transactionsToSubmit = 14;
                    int transactionsToRead = 10;
                    return (B1)Future$.MODULE$.sequence((IterableOnce)package$.MODULE$.Vector().fill(transactionsToSubmit, (Function0 & Serializable)() -> ledger.create(party, (Template)new Dummy(party))), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$6).flatMap((Function1 & Serializable)dummies -> ledger.flatTransactions(transactionsToRead, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)transactions -> {
                        $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$29(dummies, transactionsToSubmit, transactionsToRead, transactions);
                        return BoxedUnit.UNIT;
                    }, $this.ec$6), this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$29(Vector dummies$1, int transactionsToSubmit$1, int transactionsToRead$1, Vector transactions) {
                Predef$.MODULE$.assert(dummies$1.size() == transactionsToSubmit$1, (Function0 & Serializable)() -> new StringBuilder(45).append(transactionsToSubmit$1).append(" should have been submitted but ").append(dummies$1.size()).append(" were instead").toString());
                Predef$.MODULE$.assert(transactions.size() == transactionsToRead$1, (Function0 & Serializable)() -> new StringBuilder(44).append(transactionsToRead$1).append(" should have been received but ").append(transactions.size()).append(" were instead").toString());
            }
            {
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$27(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$28(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext int java.lang.Object int scala.collection.immutable.Vector ), $anonfun$applyOrElse$29$adapted(scala.collection.immutable.Vector int int scala.collection.immutable.Vector ), $anonfun$applyOrElse$30(int scala.collection.immutable.Vector ), $anonfun$applyOrElse$31(int scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("TXServeTreesUntilCancellation", "Trees should be served until the client cancels", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    int transactionsToSubmit = 14;
                    int treesToRead = 10;
                    return (B1)Future$.MODULE$.sequence((IterableOnce)package$.MODULE$.Vector().fill(transactionsToSubmit, (Function0 & Serializable)() -> ledger.create(party, (Template)new Dummy(party))), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$7).flatMap((Function1 & Serializable)dummies -> ledger.transactionTrees(treesToRead, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)trees -> {
                        $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$34(dummies, transactionsToSubmit, treesToRead, trees);
                        return BoxedUnit.UNIT;
                    }, $this.ec$7), this.ec$7);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$34(Vector dummies$2, int transactionsToSubmit$2, int treesToRead$1, Vector trees) {
                Predef$.MODULE$.assert(dummies$2.size() == transactionsToSubmit$2, (Function0 & Serializable)() -> new StringBuilder(45).append(transactionsToSubmit$2).append(" should have been submitted but ").append(dummies$2.size()).append(" were instead").toString());
                Predef$.MODULE$.assert(trees.size() == treesToRead$1, (Function0 & Serializable)() -> new StringBuilder(44).append(treesToRead$1).append(" should have been received but ").append(trees.size()).append(" were instead").toString());
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$32(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$33(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext int java.lang.Object int scala.collection.immutable.Vector ), $anonfun$applyOrElse$34$adapted(scala.collection.immutable.Vector int int scala.collection.immutable.Vector ), $anonfun$applyOrElse$35(int scala.collection.immutable.Vector ), $anonfun$applyOrElse$36(int scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("TXCompleteOnLedgerEnd", "A stream should complete as soon as the ledger end is hit", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    int transactionsToSubmit = 14;
                    Future transactionsFuture = ledger.flatTransactions((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}));
                    return (B1)Future$.MODULE$.sequence((IterableOnce)package$.MODULE$.Vector().fill(transactionsToSubmit, (Function0 & Serializable)() -> ledger.create(party, (Template)new Dummy(party))), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$8).flatMap((Function1 & Serializable)x$18 -> {
                        Vector vector = x$18;
                        return transactionsFuture.map((Function1 & Serializable)x$17 -> {
                            $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$39(x$17);
                            return BoxedUnit.UNIT;
                        }, $this.ec$8);
                    }, this.ec$8);
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participant participant;
                Allocation.Participants participants = x8;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$39(Vector x$17) {
                Vector vector = x$17;
            }
            {
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$37(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$38(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$8$1 scala.concurrent.Future scala.collection.immutable.Vector ), $anonfun$applyOrElse$39$adapted(scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("TXCompleteTreesOnLedgerEnd", "A stream of trees should complete as soon as the ledger end is hit", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$9;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x9;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    int transactionsToSubmit = 14;
                    Future transactionsFuture = ledger.transactionTrees((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}));
                    return (B1)Future$.MODULE$.sequence((IterableOnce)package$.MODULE$.Vector().fill(transactionsToSubmit, (Function0 & Serializable)() -> ledger.create(party, (Template)new Dummy(party))), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$9).flatMap((Function1 & Serializable)x$20 -> {
                        Vector vector = x$20;
                        return transactionsFuture.map((Function1 & Serializable)x$19 -> {
                            $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$42(x$19);
                            return BoxedUnit.UNIT;
                        }, $this.ec$9);
                    }, this.ec$9);
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Allocation.Participants x9) {
                Allocation.Participant participant;
                Allocation.Participants participants = x9;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$42(Vector x$19) {
                Vector vector = x$19;
            }
            {
                this.ec$9 = ec$9;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$40(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$41(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$9$1 scala.concurrent.Future scala.collection.immutable.Vector ), $anonfun$applyOrElse$42$adapted(scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("TXFilterByTemplate", "The transaction service should correctly filter by template identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$10;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x10;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Object filterBy = Dummy$.MODULE$.id();
                    SubmitAndWaitRequest create = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command(), new DummyFactory(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submitAndWait(create).flatMap((Function1 & Serializable)x$21 -> {
                        BoxedUnit boxedUnit = x$21;
                        return ledger.flatTransactionsByTemplateId(filterBy, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)transactions -> {
                            $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$44(filterBy, transactions);
                            return BoxedUnit.UNIT;
                        }, $this.ec$10);
                    }, this.ec$10);
                }
                return (B1)function1.apply(x10);
            }

            public final boolean isDefinedAt(Allocation.Participants x10) {
                Allocation.Participant participant;
                Allocation.Participants participants = x10;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$44(Object filterBy$1, Vector transactions) {
                CreatedEvent contract = (CreatedEvent)Assertions$.MODULE$.assertSingleton("FilterByTemplate", (Seq)transactions.flatMap((Function1 & Serializable)transaction -> TransactionHelpers$.MODULE$.createdEvents(transaction)));
                Assertions$.MODULE$.assertEquals("FilterByTemplate", (Object)contract.getTemplateId(), Tag$.MODULE$.unwrap(filterBy$1));
            }
            {
                this.ec$10 = ec$10;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$43(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceStreamsIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$44$adapted(java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$45(com.daml.ledger.api.v1.transaction.Transaction )}, serializedLambda);
            }
        });
    }
}

