/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceValidationIT$$anonfun$;
import com.daml.ledger.api.v1.transaction_filter.TransactionFilter$;
import com.daml.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest;
import com.daml.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest$;
import com.daml.ledger.api.v1.transaction_service.GetTransactionByIdRequest;
import com.daml.ledger.api.v1.transaction_service.GetTransactionByIdRequest$;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest$;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.test.model.Test.Dummy;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0001%!)\u0011\u0004\u0001C\u00015\tqBK]1og\u0006\u001cG/[8o'\u0016\u0014h/[2f-\u0006d\u0017\u000eZ1uS>t\u0017\n\u0016\u0006\u0003\t\u0015\tAA^\u0019`q)\u0011aaB\u0001\u0007gVLG/Z:\u000b\u0005!I\u0011\u0001\u0003;fgR$xn\u001c7\u000b\u0005)Y\u0011aA1qS*\u0011A\"D\u0001\u0007Y\u0016$w-\u001a:\u000b\u00059y\u0011\u0001\u00023b[2T\u0011\u0001E\u0001\u0004G>l7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ!AF\u0004\u0002\u001d%tgM]1tiJ,8\r^;sK&\u0011\u0001$\u0006\u0002\u0010\u0019\u0016$w-\u001a:UKN$8+^5uK\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011a\u0001")
public class TransactionServiceValidationIT
extends LedgerTestSuite {
    public TransactionServiceValidationIT() {
        this.test("TXRejectEmptyFilter", "A query with an empty transaction filter should be rejected with an INVALID_ARGUMENT status", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    GetTransactionsRequest request = ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2());
                    GetTransactionsRequest requestWithEmptyFilter = (GetTransactionsRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$1 -> TransactionFilter$.MODULE$.TransactionFilterLens(GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$1).filter()).filtersByParty().$colon$eq((Object)Predef$.MODULE$.Map().empty())}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.flatTransactions(requestWithEmptyFilter)).mustFail("subscribing with an empty filter", this.ec$1).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$2(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.InvalidArgument$.MODULE$, (Option)new Some((Object)"filtersByParty cannot be empty"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scalapb.lenses.Lens ), $anonfun$applyOrElse$2$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXRejectBeginAfterEnd", "A request with the end before the begin should be rejected with INVALID_ARGUMENT", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.currentEnd().flatMap((Function1 & Serializable)earlier -> ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)x$5 -> {
                        Object object = x$5;
                        return ledger.currentEnd().map((Function1 & Serializable)later -> {
                            GetTransactionsRequest request = ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2());
                            GetTransactionsRequest invalidRequest = (GetTransactionsRequest)request.update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$2 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$2).begin().$colon$eq(later), (Function1 & Serializable)x$3 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$3).end().$colon$eq(earlier)}));
                            return new Tuple3(later, (Object)request, (Object)invalidRequest);
                        }, $this.ec$2).flatMap((Function1 & Serializable)x$4 -> {
                            Tuple3 tuple3 = x$4;
                            if (tuple3 != null) {
                                GetTransactionsRequest invalidRequest = (GetTransactionsRequest)tuple3._3();
                                return Assertions$.MODULE$.futureAssertions(ledger.flatTransactions(invalidRequest)).mustFail("subscribing with the end before the begin", $this.ec$2).map((Function1 & Serializable)failure -> {
                                    $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$9(failure);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$2);
                            }
                            throw new MatchError((Object)tuple3);
                        }, $this.ec$2);
                    }, $this.ec$2), this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$9(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.OffsetOutOfRange$.MODULE$, (Option)new Some((Object)"is before Begin offset"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceValidationIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$4(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceValidationIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset java.lang.Object ), $anonfun$applyOrElse$5(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.ledger_offset.LedgerOffset com.daml.ledger.api.v1.ledger_offset.LedgerOffset ), $anonfun$applyOrElse$6(com.daml.ledger.api.v1.ledger_offset.LedgerOffset scalapb.lenses.Lens ), $anonfun$applyOrElse$7(com.daml.ledger.api.v1.ledger_offset.LedgerOffset scalapb.lenses.Lens ), $anonfun$applyOrElse$8(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceValidationIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple3 ), $anonfun$applyOrElse$9$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionsWrongLedgerId", "The getTransactions endpoint should reject calls with the wrong ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "DEFINITELY_NOT_A_VALID_LEDGER_IDENTIFIER";
                    GetTransactionsRequest invalidRequest = (GetTransactionsRequest)ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2()).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$6 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$6).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.flatTransactions(invalidRequest)).mustFail("subscribing with the wrong ledger ID", this.ec$3).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$11(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$11(String invalidLedgerId$1, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$1).append("' not found.").toString()), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$11$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTransactionTreesWrongLedgerId", "The getTransactionTrees endpoint should reject calls with the wrong ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "DEFINITELY_NOT_A_VALID_LEDGER_IDENTIFIER";
                    GetTransactionsRequest invalidRequest = (GetTransactionsRequest)ledger.getTransactionsRequest(ledger.transactionFilter((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})), ledger.transactionFilter$default$2(), ledger.transactionFilter$default$3()), ledger.getTransactionsRequest$default$2()).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$7 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$7).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.transactionTrees(invalidRequest)).mustFail("subscribing with the wrong ledger ID", this.ec$4).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$13(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$13(String invalidLedgerId$2, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$2).append("' not found.").toString()), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$12(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$13$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTransactionTreeByIdWrongLedgerId", "The getTransactionTreeById endpoint should reject calls with the wrong ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "DEFINITELY_NOT_A_VALID_LEDGER_IDENTIFIER";
                    GetTransactionByIdRequest invalidRequest = (GetTransactionByIdRequest)ledger.getTransactionByIdRequest("not-relevant", (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$8 -> GetTransactionByIdRequest$.MODULE$.GetTransactionByIdRequestLens(x$8).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.transactionTreeById(invalidRequest)).mustFail("subscribing with the wrong ledger ID", this.ec$5).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$15(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$15(String invalidLedgerId$3, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$3).append("' not found.").toString()), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$14(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$15$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionByIdWrongLedgerId", "The getFlatTransactionById endpoint should reject calls with the wrong ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "DEFINITELY_NOT_A_VALID_LEDGER_IDENTIFIER";
                    GetTransactionByIdRequest invalidRequest = (GetTransactionByIdRequest)ledger.getTransactionByIdRequest("not-relevant", (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$9 -> GetTransactionByIdRequest$.MODULE$.GetTransactionByIdRequestLens(x$9).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.flatTransactionById(invalidRequest)).mustFail("subscribing with the wrong ledger ID", this.ec$6).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$17(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$17(String invalidLedgerId$4, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$4).append("' not found.").toString()), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$16(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$17$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTransactionTreeByEventIdWrongLedgerId", "The getTransactionTreeByEventId endpoint should reject calls with the wrong ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "DEFINITELY_NOT_A_VALID_LEDGER_IDENTIFIER";
                    GetTransactionByEventIdRequest invalidRequest = (GetTransactionByEventIdRequest)ledger.getTransactionByEventIdRequest("not-relevant", (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$10 -> GetTransactionByEventIdRequest$.MODULE$.GetTransactionByEventIdRequestLens(x$10).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.transactionTreeByEventId(invalidRequest)).mustFail("subscribing with the wrong ledger ID", this.ec$7).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$19(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$7);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$19(String invalidLedgerId$5, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$5).append("' not found.").toString()), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$18(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$19$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionByEventIdWrongLedgerId", "The getFlatTransactionByEventId endpoint should reject calls with the wrong ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "DEFINITELY_NOT_A_VALID_LEDGER_IDENTIFIER";
                    GetTransactionByEventIdRequest invalidRequest = (GetTransactionByEventIdRequest)ledger.getTransactionByEventIdRequest("not-relevant", (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$11 -> GetTransactionByEventIdRequest$.MODULE$.GetTransactionByEventIdRequestLens(x$11).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.flatTransactionByEventId(invalidRequest)).mustFail("subscribing with the wrong ledger ID", this.ec$8).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$21(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$8);
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participant participant;
                Allocation.Participants participants = x8;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$21(String invalidLedgerId$6, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$6).append("' not found.").toString()), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$20(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$21$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXLedgerEndWrongLedgerId", "The ledgerEnd endpoint should reject calls with the wrong ledger identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$9;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x9;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    String invalidLedgerId = "DEFINITELY_NOT_A_VALID_LEDGER_IDENTIFIER";
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.currentEnd(invalidLedgerId)).mustFail("requesting with the wrong ledger ID", this.ec$9).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$22(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$9);
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Allocation.Participants x9) {
                Allocation.Participant participant;
                Allocation.Participants participants = x9;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$22(String invalidLedgerId$7, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$7).append("' not found.").toString()), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$9 = ec$9;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$22$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTransactionTreeByIdWithoutParty", "Return INVALID_ARGUMENT when looking up a transaction tree by identifier without specifying a party", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$10;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x10;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.transactionTreeById("not-relevant", (Seq)Nil$.MODULE$)).mustFail("looking up a transaction tree without specifying a party", this.ec$10).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$23(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$10);
                }
                return (B1)function1.apply(x10);
            }

            public final boolean isDefinedAt(Allocation.Participants x10) {
                Allocation.Participant participant;
                Allocation.Participants participants = x10;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$23(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.MissingField$.MODULE$, (Option)new Some((Object)"requesting_parties"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$10 = ec$10;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$23$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionByIdWithoutParty", "Return INVALID_ARGUMENT when looking up a flat transaction by identifier without specifying a party", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$11;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x11;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.flatTransactionById("not-relevant", (Seq)Nil$.MODULE$)).mustFail("looking up a flat transaction without specifying a party", this.ec$11).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$11$1.$anonfun$applyOrElse$24(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$11);
                }
                return (B1)function1.apply(x11);
            }

            public final boolean isDefinedAt(Allocation.Participants x11) {
                Allocation.Participant participant;
                Allocation.Participants participants = x11;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$24(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.MissingField$.MODULE$, (Option)new Some((Object)"requesting_parties"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$11 = ec$11;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$24$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTransactionTreeByEventIdInvalid", "Return INVALID_ARGUMENT when looking up a transaction tree using an invalid event identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$12;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x12;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.transactionTreeByEventId("dont' worry, be happy", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).mustFail("looking up an transaction tree using an invalid event ID", this.ec$12).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$12$1.$anonfun$applyOrElse$25(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$12);
                }
                return (B1)function1.apply(x12);
            }

            public final boolean isDefinedAt(Allocation.Participants x12) {
                Allocation.Participant participant;
                Allocation.Participants participants = x12;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$25(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.InvalidField$.MODULE$, (Option)new Some((Object)"Invalid field event_id"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$12 = ec$12;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$25$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXTransactionTreeByEventIdWithoutParty", "Return INVALID_ARGUMENT when looking up a transaction tree by event identifier without specifying a party", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$13;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x13;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.transactionTreeByEventId("not-relevant", (Seq)Nil$.MODULE$)).mustFail("looking up a transaction tree without specifying a party", this.ec$13).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$13$1.$anonfun$applyOrElse$26(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$13);
                }
                return (B1)function1.apply(x13);
            }

            public final boolean isDefinedAt(Allocation.Participants x13) {
                Allocation.Participant participant;
                Allocation.Participants participants = x13;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$26(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.MissingField$.MODULE$, (Option)new Some((Object)"requesting_parties"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$13 = ec$13;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$26$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionByEventIdInvalid", "Return INVALID_ARGUMENT when looking up a flat transaction using an invalid event identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$14;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x14;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.flatTransactionByEventId("dont' worry, be happy", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party}))).mustFail("looking up a flat transaction using an invalid event ID", this.ec$14).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$14$1.$anonfun$applyOrElse$27(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$14);
                }
                return (B1)function1.apply(x14);
            }

            public final boolean isDefinedAt(Allocation.Participants x14) {
                Allocation.Participant participant;
                Allocation.Participants participants = x14;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$27(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.InvalidField$.MODULE$, (Option)new Some((Object)"Invalid field event_id"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$14 = ec$14;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$27$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("TXFlatTransactionByEventIdWithoutParty", "Return INVALID_ARGUMENT when looking up a flat transaction by event identifier without specifying a party", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$15;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x15;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.flatTransactionByEventId("not-relevant", (Seq)Nil$.MODULE$)).mustFail("looking up a flat transaction without specifying a party", this.ec$15).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$28(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$15);
                }
                return (B1)function1.apply(x15);
            }

            public final boolean isDefinedAt(Allocation.Participants x15) {
                Allocation.Participant participant;
                Allocation.Participants participants = x15;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$28(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.MissingField$.MODULE$, (Option)new Some((Object)"requesting_parties"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$15 = ec$15;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$28$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
    }
}

