/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.CommandExecution;
import com.daml.error.definitions.groups.ConsistencyErrors;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.Synchronize$;
import com.daml.ledger.api.testtool.infrastructure.TransactionHelpers$;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionIdResponse;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionResponse;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionTreeResponse;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest$;
import com.daml.ledger.api.v1.commands.Command;
import com.daml.ledger.api.v1.commands.Command$;
import com.daml.ledger.api.v1.commands.Commands$;
import com.daml.ledger.api.v1.commands.CreateAndExerciseCommand$;
import com.daml.ledger.api.v1.commands.CreateCommand$;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.event.Event;
import com.daml.ledger.api.v1.event.ExercisedEvent;
import com.daml.ledger.api.v1.transaction.Transaction;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.api.v1.transaction.TreeEvent;
import com.daml.ledger.api.v1.value.Identifier;
import com.daml.ledger.api.v1.value.Record;
import com.daml.ledger.api.v1.value.Record$;
import com.daml.ledger.api.v1.value.RecordField;
import com.daml.ledger.api.v1.value.RecordField$;
import com.daml.ledger.api.v1.value.Value;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.Value$;
import com.daml.ledger.client.binding.ValueEncoder;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.client.binding.package$;
import com.daml.ledger.test.model.Test.CallablePayout;
import com.daml.ledger.test.model.Test.CallablePayout$;
import com.daml.ledger.test.model.Test.DecimalRounding;
import com.daml.ledger.test.model.Test.Dummy;
import com.daml.ledger.test.model.Test.Dummy$;
import com.daml.ledger.test.model.Test.DummyFactory;
import com.daml.ledger.test.model.Test.DummyFactory$;
import com.daml.ledger.test.model.Test.WithObservers;
import com.daml.ledger.test.model.Test.WithObservers$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.regex.Pattern;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scalapb.lenses.CompatLensImplicits;
import scalapb.lenses.Lens;
import scalapb.lenses.Lens$;
import scalaz.syntax.TagOps$;

@ScalaSignature(bytes="\u0006\u0005A2Aa\u0001\u0003\u0003'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0005?\t\u00012i\\7nC:$7+\u001a:wS\u000e,\u0017\n\u0016\u0006\u0003\u000b\u0019\tAA^\u0019`q)\u0011q\u0001C\u0001\u0007gVLG/Z:\u000b\u0005%Q\u0011\u0001\u0003;fgR$xn\u001c7\u000b\u0005-a\u0011aA1qS*\u0011QBD\u0001\u0007Y\u0016$w-\u001a:\u000b\u0005=\u0001\u0012\u0001\u00023b[2T\u0011!E\u0001\u0004G>l7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u001d%tgM]1tiJ,8\r^;sK&\u0011\u0011D\u0006\u0002\u0010\u0019\u0016$w-\u001a:UKN$8+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011\u0001B\u0001\u001cCN\u001cXM\u001d;P]R\u0013\u0018M\\:bGRLwN\u001c*fgB|gn]3\u0015\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSRDQa\n\u0002A\u0002!\n1\u0003\u001e:b]N\f7\r^5p]J+7\u000f]8og\u0016\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u001f\r|W.\\1oI~\u001bXM\u001d<jG\u0016T!!\f\u0006\u0002\u0005Y\f\u0014BA\u0018+\u0005\r\u001aVOY7ji\u0006sGmV1ji\u001a{'\u000f\u0016:b]N\f7\r^5p]J+7\u000f]8og\u0016\u0004")
public final class CommandServiceIT
extends LedgerTestSuite {
    public void com$daml$ledger$api$testtool$suites$v1_8$CommandServiceIT$$assertOnTransactionResponse(SubmitAndWaitForTransactionResponse transactionResponse) {
        Transaction transaction = transactionResponse.getTransaction();
        Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(transaction.transactionId())), (Function0 & Serializable)() -> "The transaction identifier was empty but shouldn't.");
        Event event = (Event)transaction.events().head();
        Predef$.MODULE$.assert(event.event().isCreated(), (Function0 & Serializable)() -> new StringBuilder(65).append("The returned transaction should contain a created-event, but was ").append(event.event()).toString());
        Identifier identifier = event.getCreated().getTemplateId();
        Object object = TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()));
        Predef$.MODULE$.assert(!(identifier != null ? !identifier.equals(object) : object != null), (Function0 & Serializable)() -> new StringBuilder(57).append("The template ID of the created-event should by ").append(TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()))).append(", but was ").append(event.getCreated().getTemplateId()).toString());
    }

    public CommandServiceIT() {
        this.test("CSsubmitAndWaitBasic", "SubmitAndWait creates a contract of the expected template", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submitAndWait(request).flatMap((Function1 & Serializable)x$2 -> {
                        BoxedUnit boxedUnit = x$2;
                        return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)active -> {
                            $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$2(active);
                            return BoxedUnit.UNIT;
                        }, $this.ec$1);
                    }, this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2(Vector active) {
                Identifier dummyTemplateId;
                Predef$.MODULE$.assert(active.size() == 1);
                Identifier identifier = dummyTemplateId = (Identifier)((Vector)active.flatMap((Function1 & Serializable)x$1 -> x$1.templateId().toList())).head();
                Object object = TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()));
                Predef$.MODULE$.assert(!(identifier != null ? !identifier.equals(object) : object != null));
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$2$adapted(scala.collection.immutable.Vector ), $anonfun$applyOrElse$3(com.daml.ledger.api.v1.event.CreatedEvent )}, serializedLambda);
            }
        });
        this.test("CSsubmitAndWaitForTransactionIdBasic", "SubmitAndWaitForTransactionId returns a valid transaction identifier", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submitAndWaitForTransactionId(request).map((Function1 & Serializable)transactionIdResponse -> {
                        String transactionId = transactionIdResponse.transactionId();
                        return new Tuple2(transactionIdResponse, (Object)transactionId);
                    }, this.ec$2).flatMap((Function1 & Serializable)x$3 -> {
                        Tuple2 tuple2 = x$3;
                        if (tuple2 != null) {
                            String transactionId = (String)tuple2._2();
                            return ledger.transactionTreeById(transactionId, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).flatMap((Function1 & Serializable)retrievedTransaction -> ledger.flatTransactions((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)transactions -> {
                                $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$7(transactionId, party, retrievedTransaction, transactions);
                                return BoxedUnit.UNIT;
                            }, $this.ec$2), $this.ec$2);
                        }
                        throw new MatchError((Object)tuple2);
                    }, this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$7(String transactionId$1, Object party$2, TransactionTree retrievedTransaction$1, Vector transactions) {
                Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(transactionId$1)), (Function0 & Serializable)() -> "The transaction identifier was empty but shouldn't.");
                Predef$.MODULE$.assert(transactions.size() == 1, (Function0 & Serializable)() -> new StringBuilder(42).append(party$2).append(" should see only one transaction but sees ").append(transactions.size()).toString());
                Seq events = ((Transaction)transactions.head()).events();
                Predef$.MODULE$.assert(events.size() == 1, (Function0 & Serializable)() -> new StringBuilder(36).append(party$2).append(" should see only one event but sees ").append(events.size()).toString());
                Predef$.MODULE$.assert(((Event)events.head()).event().isCreated(), (Function0 & Serializable)() -> new StringBuilder(37).append(party$2).append(" should see only one create but sees ").append(((Event)events.head()).event()).toString());
                CreatedEvent created = ((Event)((Transaction)transactions.head()).events().head()).getCreated();
                String string = retrievedTransaction$1.transactionId();
                String string2 = transactionId$1;
                Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> new StringBuilder(63).append(party$2).append(" should see the transaction for the created contract ").append(transactionId$1).append(" but sees ").append(retrievedTransaction$1.transactionId()).toString());
                Predef$.MODULE$.assert(retrievedTransaction$1.rootEventIds().size() == 1, (Function0 & Serializable)() -> new StringBuilder(69).append("The retrieved transaction should contain a single event but contains ").append(retrievedTransaction$1.rootEventIds().size()).toString());
                TreeEvent retrievedEvent = (TreeEvent)retrievedTransaction$1.eventsById().apply(retrievedTransaction$1.rootEventIds().head());
                Predef$.MODULE$.assert(retrievedEvent.kind().isCreated(), (Function0 & Serializable)() -> new StringBuilder(57).append("The only event seen should be a created but instead it's ").append(retrievedEvent).toString());
                CreatedEvent createdEvent = retrievedEvent.getCreated();
                CreatedEvent createdEvent2 = created;
                Predef$.MODULE$.assert(!(createdEvent != null ? !createdEvent.equals(createdEvent2) : createdEvent2 != null), (Function0 & Serializable)() -> new StringBuilder(94).append("The retrieved created event does not match the one in the flat transactions: event=").append(created).append(" retrieved=").append(retrievedEvent).toString());
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(java.lang.Object scala.collection.immutable.Seq ), $anonfun$applyOrElse$11(java.lang.Object scala.collection.immutable.Seq ), $anonfun$applyOrElse$12(java.lang.Object java.lang.String com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$13(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$14(com.daml.ledger.api.v1.transaction.TreeEvent ), $anonfun$applyOrElse$15(com.daml.ledger.api.v1.event.CreatedEvent com.daml.ledger.api.v1.transaction.TreeEvent ), $anonfun$applyOrElse$4(com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionIdResponse ), $anonfun$applyOrElse$5(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$7$adapted(java.lang.String java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree scala.collection.immutable.Vector ), $anonfun$applyOrElse$8(), $anonfun$applyOrElse$9(java.lang.Object scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("CSsubmitAndWaitForTransactionBasic", "SubmitAndWaitForTransaction returns a transaction", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandServiceIT $outer;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submitAndWaitForTransaction(request).map((Function1 & Serializable)transactionResponse -> {
                        $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$16(this, transactionResponse);
                        return BoxedUnit.UNIT;
                    }, this.ec$3);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$16($anonfun$$nestedInanonfun$new$3$1 $this, SubmitAndWaitForTransactionResponse transactionResponse) {
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandServiceIT$$assertOnTransactionResponse(transactionResponse);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$16$adapted(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionResponse )}, serializedLambda);
            }
        });
        String x$1 = "CSsubmitAndWaitForTransactionEmptyLedgerId";
        String x$2 = "SubmitAndWaitForTransaction should accept requests with empty ledgerId";
        Allocation.PartyAllocation x$3 = Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$);
        Function1 & Serializable x$42 = (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.optionalLedgerId());
        String x$5 = "Optional ledger id must be enabled";
        double x$6 = this.test$default$4();
        boolean x$7 = this.test$default$5();
        int x$8 = this.test$default$6();
        List x$9 = this.test$default$9();
        Function1 & Serializable x$10 = (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandServiceIT $outer;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = (SubmitAndWaitRequest)ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$5 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$5).commands()).ledgerId().$colon$eq((Object)"")}));
                    return (B1)ledger.submitAndWaitForTransaction(request).map((Function1 & Serializable)transactionResponse -> {
                        $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$18(this, transactionResponse);
                        return BoxedUnit.UNIT;
                    }, this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$18($anonfun$$nestedInanonfun$new$5$1 $this, SubmitAndWaitForTransactionResponse transactionResponse) {
                $this.$outer.com$daml$ledger$api$testtool$suites$v1_8$CommandServiceIT$$assertOnTransactionResponse(transactionResponse);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$17(scalapb.lenses.Lens ), $anonfun$applyOrElse$18$adapted(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionResponse )}, serializedLambda);
            }
        };
        this.test("CSsubmitAndWaitForTransactionEmptyLedgerId", "SubmitAndWaitForTransaction should accept requests with empty ledgerId", x$3, x$6, x$7, x$8, x$42, "Optional ledger id must be enabled", x$9, x$10);
        this.test("CSsubmitAndWaitForTransactionTreeBasic", "SubmitAndWaitForTransactionTree returns a transaction tree", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submitAndWaitForTransactionTree(request).map((Function1 & Serializable)transactionTreeResponse -> {
                        $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$19(transactionTreeResponse);
                        return BoxedUnit.UNIT;
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$19(SubmitAndWaitForTransactionTreeResponse transactionTreeResponse) {
                TransactionTree transactionTree = transactionTreeResponse.getTransaction();
                Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(transactionTree.transactionId())), (Function0 & Serializable)() -> "The transaction identifier was empty but shouldn't.");
                Predef$.MODULE$.assert(transactionTree.eventsById().size() == 1, (Function0 & Serializable)() -> new StringBuilder(68).append("The returned transaction tree should contain 1 event, but contained ").append(transactionTree.eventsById().size()).toString());
                TreeEvent event = (TreeEvent)((Tuple2)transactionTree.eventsById().head())._2();
                Predef$.MODULE$.assert(event.kind().isCreated(), (Function0 & Serializable)() -> new StringBuilder(70).append("The returned transaction tree should contain a created-event, but was ").append(event.kind()).toString());
                Identifier identifier = event.getCreated().getTemplateId();
                Object object = TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()));
                Predef$.MODULE$.assert(!(identifier != null ? !identifier.equals(object) : object != null), (Function0 & Serializable)() -> new StringBuilder(57).append("The template ID of the created-event should by ").append(TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()))).append(", but was ").append(event.getCreated().getTemplateId()).toString());
            }
            {
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$19$adapted(com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionTreeResponse ), $anonfun$applyOrElse$20(), $anonfun$applyOrElse$21(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$22(com.daml.ledger.api.v1.transaction.TreeEvent ), $anonfun$applyOrElse$23(com.daml.ledger.api.v1.transaction.TreeEvent )}, serializedLambda);
            }
        });
        this.test("CSduplicateSubmitAndWaitBasic", "SubmitAndWait should fail on duplicate requests", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submitAndWait(request).flatMap((Function1 & Serializable)x$7 -> {
                        BoxedUnit boxedUnit = x$7;
                        return Assertions$.MODULE$.futureAssertions(ledger.submitRequestAndTolerateGrpcError((ErrorCode)ConsistencyErrors.SubmissionAlreadyInFlight$.MODULE$, (Function1 & Serializable)x$6 -> x$6.submitAndWait(request))).mustFail("submitting a duplicate request", $this.ec$6).map((Function1 & Serializable)failure -> {
                            $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$26(failure);
                            return BoxedUnit.UNIT;
                        }, $this.ec$6);
                    }, this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$26(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.DuplicateCommand$.MODULE$, (Option)None$.MODULE$, true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$24(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest scala.runtime.BoxedUnit ), $anonfun$applyOrElse$25(com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext ), $anonfun$applyOrElse$26$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSduplicateSubmitAndWaitForTransactionId", "SubmitAndWaitForTransactionId should fail on duplicate requests", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submitAndWaitForTransactionId(request).flatMap((Function1 & Serializable)x$9 -> {
                        SubmitAndWaitForTransactionIdResponse submitAndWaitForTransactionIdResponse = x$9;
                        return Assertions$.MODULE$.futureAssertions(ledger.submitRequestAndTolerateGrpcError((ErrorCode)ConsistencyErrors.SubmissionAlreadyInFlight$.MODULE$, (Function1 & Serializable)x$8 -> x$8.submitAndWaitForTransactionId(request))).mustFail("submitting a duplicate request", $this.ec$7).map((Function1 & Serializable)failure -> {
                            $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$29(failure);
                            return BoxedUnit.UNIT;
                        }, $this.ec$7);
                    }, this.ec$7);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$29(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.DuplicateCommand$.MODULE$, (Option)None$.MODULE$, true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$27(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionIdResponse ), $anonfun$applyOrElse$28(com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext ), $anonfun$applyOrElse$29$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSduplicateSubmitAndWaitForTransactionData", "SubmitAndWaitForTransaction should fail on duplicate requests", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submitAndWaitForTransaction(request).flatMap((Function1 & Serializable)x$11 -> {
                        SubmitAndWaitForTransactionResponse submitAndWaitForTransactionResponse = x$11;
                        return Assertions$.MODULE$.futureAssertions(ledger.submitRequestAndTolerateGrpcError((ErrorCode)ConsistencyErrors.SubmissionAlreadyInFlight$.MODULE$, (Function1 & Serializable)x$10 -> x$10.submitAndWaitForTransaction(request))).mustFail("submitting a duplicate request", $this.ec$8).map((Function1 & Serializable)failure -> {
                            $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$32(failure);
                            return BoxedUnit.UNIT;
                        }, $this.ec$8);
                    }, this.ec$8);
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participant participant;
                Allocation.Participants participants = x8;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$32(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.DuplicateCommand$.MODULE$, (Option)None$.MODULE$, true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$30(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionResponse ), $anonfun$applyOrElse$31(com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext ), $anonfun$applyOrElse$32$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSduplicateSubmitAndWaitForTransactionTree", "SubmitAndWaitForTransactionTree should fail on duplicate requests", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$9;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x9;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
                    return (B1)ledger.submitAndWaitForTransactionTree(request).flatMap((Function1 & Serializable)x$13 -> {
                        SubmitAndWaitForTransactionTreeResponse submitAndWaitForTransactionTreeResponse = x$13;
                        return Assertions$.MODULE$.futureAssertions(ledger.submitRequestAndTolerateGrpcError((ErrorCode)ConsistencyErrors.SubmissionAlreadyInFlight$.MODULE$, (Function1 & Serializable)x$12 -> x$12.submitAndWaitForTransactionTree(request))).mustFail("submitting a duplicate request", $this.ec$9).map((Function1 & Serializable)failure -> {
                            $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$35(failure);
                            return BoxedUnit.UNIT;
                        }, $this.ec$9);
                    }, this.ec$9);
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Allocation.Participants x9) {
                Allocation.Participant participant;
                Allocation.Participants participants = x9;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$35(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)ConsistencyErrors.DuplicateCommand$.MODULE$, (Option)None$.MODULE$, true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$9 = ec$9;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$33(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionTreeResponse ), $anonfun$applyOrElse$34(com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext ), $anonfun$applyOrElse$35$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSsubmitAndWaitForTransactionIdInvalidLedgerId", "SubmitAndWaitForTransactionId should fail for invalid ledger IDs", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$10;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x10;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "CSsubmitAndWaitForTransactionIdInvalidLedgerId";
                    SubmitAndWaitRequest request = (SubmitAndWaitRequest)ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$14 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$14).commands()).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submitAndWaitForTransactionId(request)).mustFail("submitting a request with an invalid ledger ID", this.ec$10).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$11$1.$anonfun$applyOrElse$37(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$10);
                }
                return (B1)function1.apply(x10);
            }

            public final boolean isDefinedAt(Allocation.Participants x10) {
                Allocation.Participant participant;
                Allocation.Participants participants = x10;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$37(String invalidLedgerId$1, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$1).append("' not found.").toString()), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$10 = ec$10;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$36(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$37$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSsubmitAndWaitForTransactionInvalidLedgerId", "SubmitAndWaitForTransaction should fail for invalid ledger IDs", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$11;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x11;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "CSsubmitAndWaitForTransactionInvalidLedgerId";
                    SubmitAndWaitRequest request = (SubmitAndWaitRequest)ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$15 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$15).commands()).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submitAndWaitForTransaction(request)).mustFail("submitting a request with an invalid ledger ID", this.ec$11).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$12$1.$anonfun$applyOrElse$39(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$11);
                }
                return (B1)function1.apply(x11);
            }

            public final boolean isDefinedAt(Allocation.Participants x11) {
                Allocation.Participant participant;
                Allocation.Participants participants = x11;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$39(String invalidLedgerId$2, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$2).append("' not found.").toString()), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$11 = ec$11;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$38(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$39$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSsubmitAndWaitForTransactionTreeInvalidLedgerId", "SubmitAndWaitForTransactionTree should fail for invalid ledger ids", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$12;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x12;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String invalidLedgerId = "CSsubmitAndWaitForTransactionTreeInvalidLedgerId";
                    SubmitAndWaitRequest request = (SubmitAndWaitRequest)ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command()})).update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$16 -> Commands$.MODULE$.CommandsLens(SubmitAndWaitRequest$.MODULE$.SubmitAndWaitRequestLens(x$16).commands()).ledgerId().$colon$eq((Object)invalidLedgerId)}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submitAndWaitForTransactionTree(request)).mustFail("submitting a request with an invalid ledger ID", this.ec$12).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$13$1.$anonfun$applyOrElse$41(invalidLedgerId, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$12);
                }
                return (B1)function1.apply(x12);
            }

            public final boolean isDefinedAt(Allocation.Participants x12) {
                Allocation.Participant participant;
                Allocation.Participants participants = x12;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$41(String invalidLedgerId$3, Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)RequestValidation.LedgerIdMismatch$.MODULE$, (Option)new Some((Object)new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId$3).append("' not found.").toString()), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$12 = ec$12;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$40(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$41$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSRefuseBadParameter", "The submission of a creation that contains a bad parameter label should result in an INVALID_ARGUMENT", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$13;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x13;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Command createWithBadArgument = (Command)new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command().update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$17 -> CompatLensImplicits.SeqLikeLens$.MODULE$.foreach$extension(Lens$.MODULE$.seqLikeLens(Record$.MODULE$.RecordLens(CreateCommand$.MODULE$.CreateCommandLens(Command$.MODULE$.CommandLens(x$17).create()).createArguments()).fields()), (Function1 & Serializable)x$18 -> RecordField$.MODULE$.RecordFieldLens(x$18).label().$colon$eq((Object)"INVALID_PARAM"))}));
                    SubmitAndWaitRequest badRequest = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{createWithBadArgument}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submitAndWait(badRequest)).mustFail("submitting a request with a bad parameter label", this.ec$13).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$14$1.$anonfun$applyOrElse$44(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$13);
                }
                return (B1)function1.apply(x13);
            }

            public final boolean isDefinedAt(Allocation.Participants x13) {
                Allocation.Participant participant;
                Allocation.Participants participants = x13;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$44(Throwable failure) {
                Assertions$.MODULE$.assertGrpcErrorRegex(failure, (ErrorCode)CommandExecution.Preprocessing$.PreprocessingFailed$.MODULE$, (Option)new Some((Object)Pattern.compile("Missing record (label|field)")), true, Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            }
            {
                this.ec$13 = ec$13;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$42(scalapb.lenses.Lens ), $anonfun$applyOrElse$43(scalapb.lenses.Lens ), $anonfun$applyOrElse$44$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSReturnStackTrace", "A submission resulting in an interpretation error should return the stack trace", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$14;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x14;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> Assertions$.MODULE$.futureAssertions(ledger.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseFailingClone$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), ExerciseOn$.MODULE$.OnId()))).mustFail("submitting a request with an interpretation error", $this.ec$14).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$15$1.$anonfun$applyOrElse$46(failure);
                        return BoxedUnit.UNIT;
                    }, $this.ec$14), this.ec$14);
                }
                return (B1)function1.apply(x14);
            }

            public final boolean isDefinedAt(Allocation.Participants x14) {
                Allocation.Participant participant;
                Allocation.Participants participants = x14;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$46(Throwable failure) {
                Assertions$.MODULE$.assertGrpcErrorRegex(failure, (ErrorCode)CommandExecution.Interpreter$.UnhandledException$.MODULE$, (Option)new Some((Object)Pattern.compile("Interpretation error: Error: (User abort: Assertion failed.?|Unhandled (Daml )?exception: [0-9a-zA-Z\\.:]*@[0-9a-f]*\\{ message = \"Assertion failed\" \\}\\. [Dd]etails(: |=)Last location: \\[[^\\]]*\\], partial transaction: root node)")), true, Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            }
            {
                this.ec$14 = ec$14;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$45(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$15$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$46$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSDiscloseCreateToObservers", "Disclose create to observers", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$15;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                A1 A1 = x15;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object giver = participant.parties().apply(0);
                        Object observer1 = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object observer2 = participant2.parties().apply(0);
                            WithObservers template = new WithObservers(giver, (Seq)package$.MODULE$.Primitive().List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{observer1, observer2})));
                            return (B1)alpha.create(giver, (Template)template).flatMap((Function1 & Serializable)x$20 -> {
                                Object object = x$20;
                                return Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$15).flatMap((Function1 & Serializable)x$19 -> {
                                    BoxedUnit boxedUnit = x$19;
                                    return alpha.transactionTrees((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{observer1})).flatMap((Function1 & Serializable)observer1View -> beta.transactionTrees((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{observer2})).map((Function1 & Serializable)observer2View -> {
                                        $anonfun$$nestedInanonfun$new$16$1.$anonfun$applyOrElse$50(observer1View, template, observer2View);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$15), $this.ec$15);
                                }, $this.ec$15);
                            }, this.ec$15);
                        }
                    }
                }
                return (B1)function1.apply(x15);
            }

            public final boolean isDefinedAt(Allocation.Participants x15) {
                Allocation.Participants participants = x15;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$50(Vector observer1View$1, WithObservers template$1, Vector observer2View) {
                CreatedEvent observer1Created = (CreatedEvent)Assertions$.MODULE$.assertSingleton("The first observer should see exactly one creation", (Seq)observer1View$1.flatMap((Function1 & Serializable)tree -> TransactionHelpers$.MODULE$.createdEvents(tree)));
                CreatedEvent observer2Created = (CreatedEvent)Assertions$.MODULE$.assertSingleton("The second observer should see exactly one creation", (Seq)observer2View.flatMap((Function1 & Serializable)tree -> TransactionHelpers$.MODULE$.createdEvents(tree)));
                Assertions$.MODULE$.assertEquals("The two observers should see the same creation", (Object)observer1Created.getCreateArguments().fields(), (Object)observer2Created.getCreateArguments().fields());
                Assertions$.MODULE$.assertEquals("The observers should see the created contract", (Object)observer1Created.getCreateArguments().fields(), (Object)Value$.MODULE$.encode((Object)template$1, (ValueEncoder)WithObservers$.MODULE$.the$u0020template$u0020Value()).getRecord().fields());
            }
            {
                this.ec$15 = ec$15;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$47(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.test.model.Test.WithObservers java.lang.Object ), $anonfun$applyOrElse$48(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.test.model.Test.WithObservers scala.runtime.BoxedUnit ), $anonfun$applyOrElse$49(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$16$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.test.model.Test.WithObservers scala.collection.immutable.Vector ), $anonfun$applyOrElse$50$adapted(scala.collection.immutable.Vector com.daml.ledger.test.model.Test.WithObservers scala.collection.immutable.Vector ), $anonfun$applyOrElse$51(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$52(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("CSDiscloseExerciseToObservers", "Disclose exercise to observers", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$16;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x16, Function1<A1, B1> function1) {
                A1 A1 = x16;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object giver = participant.parties().apply(0);
                        Object observer1 = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object observer2 = participant2.parties().apply(0);
                            WithObservers template = new WithObservers(giver, (Seq)package$.MODULE$.Primitive().List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{observer1, observer2})));
                            return (B1)alpha.create(giver, (Template)template).flatMap((Function1 & Serializable)withObservers -> alpha.exercise(giver, WithObservers.WithObservers$u0020syntax$.MODULE$.exercisePing$extension(WithObservers$.MODULE$.WithObservers$u0020syntax(withObservers), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$22 -> {
                                TransactionTree transactionTree = x$22;
                                return Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$16).flatMap((Function1 & Serializable)x$21 -> {
                                    BoxedUnit boxedUnit = x$21;
                                    return alpha.transactionTrees((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{observer1})).flatMap((Function1 & Serializable)observer1View -> beta.transactionTrees((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{observer2})).map((Function1 & Serializable)observer2View -> {
                                        $anonfun$$nestedInanonfun$new$17$1.$anonfun$applyOrElse$57(observer1View, withObservers, observer2View);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$16), $this.ec$16);
                                }, $this.ec$16);
                            }, $this.ec$16), this.ec$16);
                        }
                    }
                }
                return (B1)function1.apply(x16);
            }

            public final boolean isDefinedAt(Allocation.Participants x16) {
                Allocation.Participants participants = x16;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$57(Vector observer1View$2, Object withObservers$1, Vector observer2View) {
                ExercisedEvent observer1Exercise = (ExercisedEvent)Assertions$.MODULE$.assertSingleton("The first observer should see exactly one exercise", (Seq)observer1View$2.flatMap((Function1 & Serializable)tree -> TransactionHelpers$.MODULE$.exercisedEvents(tree)));
                ExercisedEvent observer2Exercise = (ExercisedEvent)Assertions$.MODULE$.assertSingleton("The second observer should see exactly one exercise", (Seq)observer2View.flatMap((Function1 & Serializable)tree -> TransactionHelpers$.MODULE$.exercisedEvents(tree)));
                String string = observer1Exercise.contractId();
                String string2 = observer2Exercise.contractId();
                Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "The two observers should see the same exercise");
                String string3 = observer1Exercise.contractId();
                Object object = TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(withObservers$1));
                Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(object) : object != null), (Function0 & Serializable)() -> "The observers shouls see the exercised contract");
            }
            {
                this.ec$16 = ec$16;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$53(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$54(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$55(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$56(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$17$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$57$adapted(scala.collection.immutable.Vector java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$58(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$59(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$60(), $anonfun$applyOrElse$61()}, serializedLambda);
            }
        });
        this.test("CSHugeCommandSubmission", "The server should accept a submission with 15 commands", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$17;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x17, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x17;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    int target = 15;
                    Vector commands = (Vector)scala.package$.MODULE$.Vector().fill(target, (Function0 & Serializable)() -> new Dummy(party).create(DummyImplicit$.MODULE$.dummyImplicit()).command());
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)commands);
                    return (B1)ledger.submitAndWait(request).flatMap((Function1 & Serializable)x$23 -> {
                        BoxedUnit boxedUnit = x$23;
                        return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)acs -> {
                            $anonfun$$nestedInanonfun$new$18$1.$anonfun$applyOrElse$64(target, acs);
                            return BoxedUnit.UNIT;
                        }, $this.ec$17);
                    }, this.ec$17);
                }
                return (B1)function1.apply(x17);
            }

            public final boolean isDefinedAt(Allocation.Participants x17) {
                Allocation.Participant participant;
                Allocation.Participants participants = x17;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$64(int target$1, Vector acs) {
                Predef$.MODULE$.assert(acs.size() == target$1, (Function0 & Serializable)() -> new StringBuilder(47).append("Expected ").append(target$1).append(" contracts to be created, got ").append(acs.size()).append(" instead").toString());
            }
            {
                this.ec$17 = ec$17;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$62(java.lang.Object ), $anonfun$applyOrElse$63(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$18$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object int scala.runtime.BoxedUnit ), $anonfun$applyOrElse$64$adapted(int scala.collection.immutable.Vector ), $anonfun$applyOrElse$65(int scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("CSCallablePayout", "Run CallablePayout and return the right events", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$18;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x18, Function1<A1, B1> function1) {
                A1 A1 = x18;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object giver = participant.parties().apply(0);
                        Object newReceiver = participant.parties().apply(1);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object receiver = participant2.parties().apply(0);
                            return (B1)alpha.create(giver, (Template)new CallablePayout(giver, receiver)).flatMap((Function1 & Serializable)callablePayout -> Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$18).flatMap((Function1 & Serializable)x$24 -> {
                                BoxedUnit boxedUnit = x$24;
                                return beta.exercise(receiver, CallablePayout.CallablePayout$u0020syntax$.MODULE$.exerciseTransfer$extension(CallablePayout$.MODULE$.CallablePayout$u0020syntax(callablePayout), newReceiver, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)tree -> {
                                    $anonfun$$nestedInanonfun$new$19$1.$anonfun$applyOrElse$68(giver, newReceiver, tree);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$18);
                            }, $this.ec$18), this.ec$18);
                        }
                    }
                }
                return (B1)function1.apply(x18);
            }

            public final boolean isDefinedAt(Allocation.Participants x18) {
                Allocation.Participants participants = x18;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$68(Object giver$2, Object newReceiver$1, TransactionTree tree) {
                CreatedEvent created = (CreatedEvent)Assertions$.MODULE$.assertSingleton("There should only be one creation", (Seq)TransactionHelpers$.MODULE$.createdEvents(tree));
                Assertions$.MODULE$.assertEquals("The created event should be the expected one", (Object)created.getCreateArguments().fields(), (Object)Value$.MODULE$.encode((Object)new CallablePayout(giver$2, newReceiver$1), (ValueEncoder)CallablePayout$.MODULE$.the$u0020template$u0020Value()).getRecord().fields());
            }
            {
                this.ec$18 = ec$18;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$66(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$19$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$67(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$19$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$68$adapted(java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("CSReadyForExercise", "It should be possible to exercise a choice on a created contract", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$19;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x19, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x19;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new DummyFactory(party)).flatMap((Function1 & Serializable)factory -> ledger.exercise(party, DummyFactory.DummyFactory$u0020syntax$.MODULE$.exerciseDummyFactoryCall$extension(DummyFactory$.MODULE$.DummyFactory$u0020syntax(factory), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)tree -> {
                        $anonfun$$nestedInanonfun$new$20$1.$anonfun$applyOrElse$70(factory, tree);
                        return BoxedUnit.UNIT;
                    }, $this.ec$19), this.ec$19);
                }
                return (B1)function1.apply(x19);
            }

            public final boolean isDefinedAt(Allocation.Participants x19) {
                Allocation.Participant participant;
                Allocation.Participants participants = x19;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$70(Object factory$1, TransactionTree tree) {
                ExercisedEvent exercise = (ExercisedEvent)Assertions$.MODULE$.assertSingleton("There should only be one exercise", (Seq)TransactionHelpers$.MODULE$.exercisedEvents(tree));
                String string = exercise.contractId();
                Object object = TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(factory$1));
                Predef$.MODULE$.assert(!(string != null ? !string.equals(object) : object != null), (Function0 & Serializable)() -> "Contract identifier mismatch");
                Predef$.MODULE$.assert(exercise.consuming(), (Function0 & Serializable)() -> "The choice should have been consuming");
                Vector vector = (Vector)Assertions$.MODULE$.assertLength("Two creations should have occurred", 2, (Seq)TransactionHelpers$.MODULE$.createdEvents(tree));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.ec$19 = ec$19;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$69(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$20$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$70$adapted(java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$71(), $anonfun$applyOrElse$72()}, serializedLambda);
            }
        });
        this.test("CSBadNumericValues", "Reject unrepresentable numeric values", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$20;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x20, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x20;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String wouldLosePrecision = "0.00000000005";
                    String positiveOutOfBounds = "10000000000000000000000000000.0000000000";
                    String negativeOutOfBounds = "-10000000000000000000000000000.0000000000";
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submitAndWait(ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{$anonfun$$nestedInanonfun$new$21$1.rounding$1(wouldLosePrecision, party)})))).mustFail("submitting a request which would lose precision", this.ec$20).flatMap((Function1 & Serializable)e1 -> Assertions$.MODULE$.futureAssertions(ledger.submitAndWait(ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{$anonfun$$nestedInanonfun$new$21$1.rounding$1(positiveOutOfBounds, party)})))).mustFail("submitting a request with a positive number out of bounds", $this.ec$20).flatMap((Function1 & Serializable)e2 -> Assertions$.MODULE$.futureAssertions(ledger.submitAndWait(ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{$anonfun$$nestedInanonfun$new$21$1.rounding$1(negativeOutOfBounds, party)})))).mustFail("submitting a request with a negative number out of bounds", $this.ec$20).map((Function1 & Serializable)e3 -> {
                        $anonfun$$nestedInanonfun$new$21$1.$anonfun$applyOrElse$76(e1, e2, e3);
                        return BoxedUnit.UNIT;
                    }, $this.ec$20), $this.ec$20), this.ec$20);
                }
                return (B1)function1.apply(x20);
            }

            public final boolean isDefinedAt(Allocation.Participants x20) {
                Allocation.Participant participant;
                Allocation.Participants participants = x20;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            private static final Command rounding$1(String numeric, Object party$6) {
                return (Command)new DecimalRounding(party$6, scala.package$.MODULE$.BigDecimal().apply("0")).create(DummyImplicit$.MODULE$.dummyImplicit()).command().update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$26 -> {
                    Some x$1 = new Some((Object)new Value((Value.Sum)new Value.Sum$.Numeric(numeric)));
                    String x$2 = RecordField$.MODULE$.apply$default$1();
                    return CompatLensImplicits.SeqLikeLens$.MODULE$.apply$extension(Lens$.MODULE$.seqLikeLens(Record$.MODULE$.RecordLens(CreateCommand$.MODULE$.CreateCommandLens(Command$.MODULE$.CommandLens(x$26).create()).createArguments()).fields()), 1).$colon$eq((Object)new RecordField(x$2, (Option)x$1));
                }}));
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$76(Throwable e1$1, Throwable e2$1, Throwable e3) {
                Assertions$.MODULE$.assertGrpcError(e1$1, (ErrorCode)CommandExecution.Preprocessing$.PreprocessingFailed$.MODULE$, (Option)new Some((Object)"Cannot represent"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(e2$1, (ErrorCode)CommandExecution.Preprocessing$.PreprocessingFailed$.MODULE$, (Option)new Some((Object)"Out-of-bounds (Numeric 10)"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(e3, (ErrorCode)CommandExecution.Preprocessing$.PreprocessingFailed$.MODULE$, (Option)new Some((Object)"Out-of-bounds (Numeric 10)"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$20 = ec$20;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$73(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$74(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$21$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.String java.lang.Throwable ), $anonfun$applyOrElse$75(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$21$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$76$adapted(java.lang.Throwable java.lang.Throwable java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSCreateAndExercise", "Implement create-and-exercise correctly", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$21;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x21, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x21;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Command createAndExercise = Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax((Object)new Dummy(party).createAnd(DummyImplicit$.MODULE$.dummyImplicit())), ExerciseOn$.MODULE$.CreateAndOnTemplate()).command();
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{createAndExercise}));
                    return (B1)ledger.submitAndWait(request).flatMap((Function1 & Serializable)x$29 -> {
                        BoxedUnit boxedUnit = x$29;
                        return ledger.flatTransactions((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).flatMap((Function1 & Serializable)transactions -> ledger.transactionTrees((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)trees -> {
                            $anonfun$$nestedInanonfun$new$22$1.$anonfun$applyOrElse$79(transactions, trees);
                            return BoxedUnit.UNIT;
                        }, $this.ec$21), $this.ec$21);
                    }, this.ec$21);
                }
                return (B1)function1.apply(x21);
            }

            public final boolean isDefinedAt(Allocation.Participants x21) {
                Allocation.Participant participant;
                Allocation.Participants participants = x21;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$79(Vector transactions$2, Vector trees) {
                Predef$.MODULE$.assert(((SeqOps)transactions$2.flatMap((Function1 & Serializable)x$27 -> x$27.events())).isEmpty(), (Function0 & Serializable)() -> "A create-and-exercise flat transaction should show no event");
                Assertions$.MODULE$.assertEquals("Unexpected template identifier in create event", ((StrictOptimizedIterableOps)trees.flatMap((Function1 & Serializable)tree -> TransactionHelpers$.MODULE$.createdEvents(tree))).map((Function1 & Serializable)x$28 -> x$28.getTemplateId()), scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{(Identifier)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()))})));
                String contractId = ((CreatedEvent)((Vector)trees.flatMap((Function1 & Serializable)tree -> TransactionHelpers$.MODULE$.createdEvents(tree))).head()).contractId();
                Assertions$.MODULE$.assertEquals("Unexpected exercise event triple (choice, contractId, consuming)", ((StrictOptimizedIterableOps)trees.flatMap((Function1 & Serializable)tree -> TransactionHelpers$.MODULE$.exercisedEvents(tree))).map((Function1 & Serializable)e -> new Tuple3((Object)e.choice(), (Object)e.contractId(), (Object)BoxesRunTime.boxToBoolean((boolean)e.consuming()))), scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"DummyChoice1", (Object)contractId, (Object)BoxesRunTime.boxToBoolean((boolean)true))})));
            }
            {
                this.ec$21 = ec$21;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$77(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$22$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$78(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$22$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$79$adapted(scala.collection.immutable.Vector scala.collection.immutable.Vector ), $anonfun$applyOrElse$80(com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$81(), $anonfun$applyOrElse$82(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$83(com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$84(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$85(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$86(com.daml.ledger.api.v1.event.ExercisedEvent )}, serializedLambda);
            }
        });
        this.test("CSBadCreateAndExercise", "Fail create-and-exercise on bad create arguments", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$22;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x22, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x22;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Command createAndExercise = (Command)Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax((Object)new Dummy(party).createAnd(DummyImplicit$.MODULE$.dummyImplicit())), ExerciseOn$.MODULE$.CreateAndOnTemplate()).command().update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$30 -> CreateAndExerciseCommand$.MODULE$.CreateAndExerciseCommandLens(Command$.MODULE$.CommandLens(x$30).createAndExercise()).createArguments().$colon$eq((Object)new Record(Record$.MODULE$.apply$default$1(), Record$.MODULE$.apply$default$2()))}));
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{createAndExercise}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submitAndWait(request)).mustFail("submitting a request with bad create arguments", this.ec$22).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$23$1.$anonfun$applyOrElse$88(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$22);
                }
                return (B1)function1.apply(x22);
            }

            public final boolean isDefinedAt(Allocation.Participants x22) {
                Allocation.Participant participant;
                Allocation.Participants participants = x22;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$88(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)CommandExecution.Preprocessing$.PreprocessingFailed$.MODULE$, (Option)new Some((Object)"Expecting 1 field for record"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$22 = ec$22;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$87(scalapb.lenses.Lens ), $anonfun$applyOrElse$88$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSCreateAndBadExerciseArguments", "Fail create-and-exercise on bad choice arguments", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$23;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x23, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x23;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    Command createAndExercise = (Command)Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax((Object)new Dummy(party).createAnd(DummyImplicit$.MODULE$.dummyImplicit())), ExerciseOn$.MODULE$.CreateAndOnTemplate()).command().update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$31 -> CreateAndExerciseCommand$.MODULE$.CreateAndExerciseCommandLens(Command$.MODULE$.CommandLens(x$31).createAndExercise()).choiceArgument().$colon$eq((Object)new Value((Value.Sum)new Value.Sum$.Bool(false)))}));
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{createAndExercise}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submitAndWait(request)).mustFail("submitting a request with bad choice arguments", this.ec$23).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$24$1.$anonfun$applyOrElse$90(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$23);
                }
                return (B1)function1.apply(x23);
            }

            public final boolean isDefinedAt(Allocation.Participants x23) {
                Allocation.Participant participant;
                Allocation.Participants participants = x23;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$90(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)CommandExecution.Preprocessing$.PreprocessingFailed$.MODULE$, (Option)new Some((Object)"mismatching type"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$23 = ec$23;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$89(scalapb.lenses.Lens ), $anonfun$applyOrElse$90$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSCreateAndBadExerciseChoice", "Fail create-and-exercise on invalid choice", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$24;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x24, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x24;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String missingChoice = "DoesNotExist";
                    Command createAndExercise = (Command)Dummy.Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension(Dummy$.MODULE$.Dummy$u0020syntax((Object)new Dummy(party).createAnd(DummyImplicit$.MODULE$.dummyImplicit())), ExerciseOn$.MODULE$.CreateAndOnTemplate()).command().update((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$32 -> CreateAndExerciseCommand$.MODULE$.CreateAndExerciseCommandLens(Command$.MODULE$.CommandLens(x$32).createAndExercise()).choice().$colon$eq((Object)missingChoice)}));
                    SubmitAndWaitRequest request = ledger.submitAndWaitRequest(party, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{createAndExercise}));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.submitAndWait(request)).mustFail("submitting a request with an invalid choice", this.ec$24).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$25$1.$anonfun$applyOrElse$92(missingChoice, failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$24);
                }
                return (B1)function1.apply(x24);
            }

            public final boolean isDefinedAt(Allocation.Participants x24) {
                Allocation.Participant participant;
                Allocation.Participants participants = x24;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$92(String missingChoice$1, Throwable failure) {
                Assertions$.MODULE$.assertGrpcErrorRegex(failure, (ErrorCode)CommandExecution.Preprocessing$.PreprocessingFailed$.MODULE$, (Option)new Some((Object)Pattern.compile(new StringBuilder(41).append("(unknown|Couldn't find requested) choice ").append(missingChoice$1).toString())), true, Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            }
            {
                this.ec$24 = ec$24;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$91(java.lang.String scalapb.lenses.Lens ), $anonfun$applyOrElse$92$adapted(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CSsubmitAndWaitCompletionOffset", "SubmitAndWait methods return the completion offset in the response", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$25;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x25, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x25;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.submitAndWaitForTransactionId($anonfun$$nestedInanonfun$new$26$1.request$5(ledger, party)).flatMap((Function1 & Serializable)transactionIdResponse -> ledger.transactionTreeById(transactionIdResponse.transactionId(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).flatMap((Function1 & Serializable)retrievedTransaction -> ledger.submitAndWaitForTransaction($anonfun$$nestedInanonfun$new$26$1.request$5(ledger, party)).flatMap((Function1 & Serializable)transactionResponse -> ledger.submitAndWaitForTransactionTree($anonfun$$nestedInanonfun$new$26$1.request$5(ledger, party)).map((Function1 & Serializable)transactionTreeResponse -> {
                        $anonfun$$nestedInanonfun$new$26$1.$anonfun$applyOrElse$96(transactionIdResponse, retrievedTransaction, transactionResponse, transactionTreeResponse);
                        return BoxedUnit.UNIT;
                    }, $this.ec$25), $this.ec$25), $this.ec$25), this.ec$25);
                }
                return (B1)function1.apply(x25);
            }

            public final boolean isDefinedAt(Allocation.Participants x25) {
                Allocation.Participant participant;
                Allocation.Participants participants = x25;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            private static final SubmitAndWaitRequest request$5(ParticipantTestContext ledger$12, Object party$8) {
                return ledger$12.submitAndWaitRequest(party$8, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party$8).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}));
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$97() {
                return "SubmitAndWaitForTransactionId does not contain the expected completion offset";
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$98() {
                return "SubmitAndWaitForTransaction does not contain the expected completion offset";
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$99() {
                return "SubmitAndWaitForTransactionTree does not contain the expected completion offset";
            }

            /*
             * Unable to fully structure code
             */
            public static final /* synthetic */ void $anonfun$applyOrElse$96(SubmitAndWaitForTransactionIdResponse transactionIdResponse$1, TransactionTree retrievedTransaction$2, SubmitAndWaitForTransactionResponse transactionResponse$1, SubmitAndWaitForTransactionTreeResponse transactionTreeResponse) {
                if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(transactionIdResponse$1.completionOffset()))) ** GOTO lbl-1000
                v0 = transactionIdResponse$1.completionOffset();
                var4_4 = retrievedTransaction$2.offset();
                if (!(v0 != null ? v0.equals(var4_4) == false : var4_4 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                Predef$.MODULE$.assert(v1, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$applyOrElse$97(), ()Ljava/lang/String;)());
                if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(transactionResponse$1.completionOffset()))) ** GOTO lbl-1000
                v2 = transactionResponse$1.completionOffset();
                var5_5 = transactionResponse$1.getTransaction().offset();
                if (!(v2 != null ? v2.equals(var5_5) == false : var5_5 != null)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                Predef$.MODULE$.assert(v3, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$applyOrElse$98(), ()Ljava/lang/String;)());
                if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(transactionTreeResponse.completionOffset()))) ** GOTO lbl-1000
                v4 = transactionTreeResponse.completionOffset();
                var6_6 = transactionTreeResponse.getTransaction().offset();
                if (!(v4 != null ? v4.equals(var6_6) == false : var6_6 != null)) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                Predef$.MODULE$.assert(v5, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$applyOrElse$99(), ()Ljava/lang/String;)());
            }
            {
                this.ec$25 = ec$25;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$93(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$26$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionIdResponse ), $anonfun$applyOrElse$94(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$26$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionIdResponse java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$95(com.daml.ledger.api.testtool.suites.v1_8.CommandServiceIT$$anonfun$$nestedInanonfun$new$26$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionIdResponse com.daml.ledger.api.v1.transaction.TransactionTree java.lang.Object com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionResponse ), $anonfun$applyOrElse$96$adapted(com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionIdResponse com.daml.ledger.api.v1.transaction.TransactionTree com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionResponse com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionTreeResponse ), $anonfun$applyOrElse$97(), $anonfun$applyOrElse$98(), $anonfun$applyOrElse$99()}, serializedLambda);
            }
        });
    }
}

