/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.CommandExecution;
import com.daml.error.definitions.groups.ConsistencyErrors;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.Eventually$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.Synchronize$;
import com.daml.ledger.api.testtool.infrastructure.TransactionHelpers$;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$;
import com.daml.ledger.api.v1.command_submission_service.SubmitRequest;
import com.daml.ledger.api.v1.commands.Command;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.transaction.Transaction;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.api.v1.transaction.TreeEvent;
import com.daml.ledger.api.v1.value.Record;
import com.daml.ledger.api.v1.value.Record$;
import com.daml.ledger.api.v1.value.RecordField;
import com.daml.ledger.api.v1.value.Value;
import com.daml.ledger.client.binding.DamlCodecs$;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.ValueEncoder;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.client.binding.package$;
import com.daml.ledger.test.model.DA.Types.Tuple2;
import com.daml.ledger.test.model.Test.CallablePayout;
import com.daml.ledger.test.model.Test.Delegated;
import com.daml.ledger.test.model.Test.Delegated$;
import com.daml.ledger.test.model.Test.Delegation;
import com.daml.ledger.test.model.Test.Delegation$;
import com.daml.ledger.test.model.Test.LocalKeyVisibilityOperations;
import com.daml.ledger.test.model.Test.LocalKeyVisibilityOperations$;
import com.daml.ledger.test.model.Test.MaintainerNotSignatory;
import com.daml.ledger.test.model.Test.ShowDelegated;
import com.daml.ledger.test.model.Test.ShowDelegated$;
import com.daml.ledger.test.model.Test.TextKey;
import com.daml.ledger.test.model.Test.TextKey$;
import com.daml.ledger.test.model.Test.TextKeyOperations;
import com.daml.ledger.test.model.Test.TextKeyOperations$;
import com.daml.ledger.test.model.Test.WithKey;
import com.daml.ledger.test.model.Test.WithKey$;
import com.daml.ledger.test.model.Test.WithKeyCreator;
import com.daml.ledger.test.model.Test.WithKeyCreator$;
import com.daml.ledger.test.model.Test.WithKeyCreatorAlternative;
import com.daml.ledger.test.model.Test.WithKeyCreatorAlternative$;
import com.daml.ledger.test.model.Test.WithKeyDivulgenceHelper;
import com.daml.ledger.test.model.Test.WithKeyDivulgenceHelper$;
import com.daml.ledger.test.model.Test.WithKeyFetcher;
import com.daml.ledger.test.model.Test.WithKeyFetcher$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.regex.Pattern;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scalaz.Tag$;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0003%!)\u0011\u0004\u0001C\u00015\tq1i\u001c8ue\u0006\u001cGoS3zg&#&B\u0001\u0003\u0006\u0003\u00111\u0018g\u0018\u001d\u000b\u0005\u00199\u0011AB:vSR,7O\u0003\u0002\t\u0013\u0005AA/Z:ui>|GN\u0003\u0002\u000b\u0017\u0005\u0019\u0011\r]5\u000b\u00051i\u0011A\u00027fI\u001e,'O\u0003\u0002\u000f\u001f\u0005!A-Y7m\u0015\u0005\u0001\u0012aA2p[\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\t1r!\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005a)\"a\u0004'fI\u001e,'\u000fV3tiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0019\u0001")
public final class ContractKeysIT
extends LedgerTestSuite {
    public ContractKeysIT() {
        this.test("CKNoContractKey", "There should be no contract key if the template does not specify one", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        Object receiver = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object giver = participant2.parties().apply(0);
                            return (B1)beta.create(giver, (Template)new CallablePayout(giver, receiver)).flatMap((Function1 & Serializable)x$1 -> {
                                Object object = x$1;
                                return beta.flatTransactions((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{giver, receiver})).map((Function1 & Serializable)transactions -> {
                                    $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$2(transactions);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$1);
                            }, this.ec$1);
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participants participants = x1;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2(Vector transactions) {
                CreatedEvent contract = (CreatedEvent)Assertions$.MODULE$.assertSingleton("NoContractKey", (Seq)transactions.flatMap((Function1 & Serializable)transaction -> TransactionHelpers$.MODULE$.createdEvents(transaction)));
                Predef$.MODULE$.assert(contract.getContractKey().sum().isEmpty(), (Function0 & Serializable)() -> new StringBuilder(22).append("The key is not empty: ").append(contract.getContractKey()).toString());
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$2$adapted(scala.collection.immutable.Vector ), $anonfun$applyOrElse$3(com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$4(com.daml.ledger.api.v1.event.CreatedEvent )}, serializedLambda);
            }
        });
        this.test("CKFetchOrLookup", "Divulged contracts cannot be fetched or looked up by key by non-stakeholders", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object owner = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object delegate = participant2.parties().apply(0);
                            String key = (String)alpha.nextKeyId().apply();
                            return (B1)alpha.create(owner, (Template)new Delegated(owner, key)).flatMap((Function1 & Serializable)delegated -> alpha.create(owner, (Template)new Delegation(owner, delegate)).flatMap((Function1 & Serializable)delegation -> alpha.create(owner, (Template)new ShowDelegated(owner, delegate)).flatMap((Function1 & Serializable)showDelegated -> alpha.exercise(owner, ShowDelegated.ShowDelegated$u0020syntax$.MODULE$.exerciseShowIt$extension(ShowDelegated$.MODULE$.ShowDelegated$u0020syntax(showDelegated), delegated, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$3 -> {
                                TransactionTree transactionTree = x$3;
                                return Eventually$.MODULE$.eventually("exerciseFetchDelegated", Eventually$.MODULE$.eventually$default$2(), Eventually$.MODULE$.eventually$default$3(), (Function0 & Serializable)() -> beta.exercise(delegate, Delegation.Delegation$u0020syntax$.MODULE$.exerciseFetchDelegated$extension(Delegation$.MODULE$.Delegation$u0020syntax(delegation), delegated, ExerciseOn$.MODULE$.OnId())), $this.ec$2).flatMap((Function1 & Serializable)x$2 -> {
                                    TransactionTree transactionTree = x$2;
                                    return Assertions$.MODULE$.futureAssertions(beta.exercise(delegate, Delegation.Delegation$u0020syntax$.MODULE$.exerciseFetchByKeyDelegated$extension(Delegation$.MODULE$.Delegation$u0020syntax(delegation), owner, key, ExerciseOn$.MODULE$.OnId()))).mustFail("fetching by key with a party that cannot see the contract", $this.ec$2).flatMap((Function1 & Serializable)fetchFailure -> Assertions$.MODULE$.futureAssertions(beta.exercise(delegate, Delegation.Delegation$u0020syntax$.MODULE$.exerciseLookupByKeyDelegated$extension(Delegation$.MODULE$.Delegation$u0020syntax(delegation), owner, key, ExerciseOn$.MODULE$.OnId()))).mustFail("looking up by key with a party that cannot see the contract", $this.ec$2).map((Function1 & Serializable)lookupByKeyFailure -> {
                                        $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$12(fetchFailure, lookupByKeyFailure);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$2), $this.ec$2);
                                }, $this.ec$2);
                            }, $this.ec$2), $this.ec$2), $this.ec$2), this.ec$2);
                        }
                    }
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participants participants = x2;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$12(Throwable fetchFailure$1, Throwable lookupByKeyFailure) {
                Assertions$.MODULE$.assertGrpcError(fetchFailure$1, (ErrorCode)CommandExecution.Interpreter$.LookupErrors$.ContractKeyNotFound$.MODULE$, (Option)new Some((Object)"couldn't find key"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcErrorRegex(lookupByKeyFailure, (ErrorCode)ConsistencyErrors.InconsistentContractKey$.MODULE$, (Option)new Some((Object)Pattern.compile("Inconsistent|Contract key lookup with different results")), true, Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.String com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$11(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.String java.lang.Throwable ), $anonfun$applyOrElse$12$adapted(java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$5(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.Object ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.Object ), $anonfun$applyOrElse$7(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Object ), $anonfun$applyOrElse$8(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.String com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$9(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object )}, serializedLambda);
            }
        });
        this.test("CKNoFetchUndisclosed", "Contract Keys should reject fetching an undisclosed contract", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object owner = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object delegate = participant2.parties().apply(0);
                            String key = (String)alpha.nextKeyId().apply();
                            return (B1)alpha.create(owner, (Template)new Delegated(owner, key)).flatMap((Function1 & Serializable)delegated -> alpha.create(owner, (Template)new Delegation(owner, delegate)).flatMap((Function1 & Serializable)delegation -> Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$3).flatMap((Function1 & Serializable)x$4 -> {
                                BoxedUnit boxedUnit = x$4;
                                return Assertions$.MODULE$.futureAssertions(beta.exercise(delegate, Delegation.Delegation$u0020syntax$.MODULE$.exerciseFetchDelegated$extension(Delegation$.MODULE$.Delegation$u0020syntax(delegation), delegated, ExerciseOn$.MODULE$.OnId()))).mustFail("fetching a contract with a party that cannot see it", $this.ec$3).flatMap((Function1 & Serializable)fetchFailure -> Assertions$.MODULE$.futureAssertions(beta.exercise(delegate, Delegation.Delegation$u0020syntax$.MODULE$.exerciseFetchByKeyDelegated$extension(Delegation$.MODULE$.Delegation$u0020syntax(delegation), owner, key, ExerciseOn$.MODULE$.OnId()))).mustFail("fetching a contract by key with a party that cannot see it", $this.ec$3).flatMap((Function1 & Serializable)fetchByKeyFailure -> Assertions$.MODULE$.futureAssertions(beta.exercise(delegate, Delegation.Delegation$u0020syntax$.MODULE$.exerciseLookupByKeyDelegated$extension(Delegation$.MODULE$.Delegation$u0020syntax(delegation), owner, key, ExerciseOn$.MODULE$.OnId()))).mustFail("looking up a contract by key with a party that cannot see it", $this.ec$3).map((Function1 & Serializable)lookupByKeyFailure -> {
                                    $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$18(fetchFailure, fetchByKeyFailure, lookupByKeyFailure);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$3), $this.ec$3), $this.ec$3);
                            }, $this.ec$3), $this.ec$3), this.ec$3);
                        }
                    }
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participants participants = x3;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$18(Throwable fetchFailure$2, Throwable fetchByKeyFailure$1, Throwable lookupByKeyFailure) {
                Assertions$.MODULE$.assertGrpcError(fetchFailure$2, (ErrorCode)ConsistencyErrors.ContractNotFound$.MODULE$, (Option)new Some((Object)"Contract could not be found"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(fetchByKeyFailure$1, (ErrorCode)CommandExecution.Interpreter$.LookupErrors$.ContractKeyNotFound$.MODULE$, (Option)new Some((Object)"couldn't find key"), Assertions$.MODULE$.assertGrpcError$default$4(), Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcErrorRegex(lookupByKeyFailure, (ErrorCode)ConsistencyErrors.InconsistentContractKey$.MODULE$, (Option)new Some((Object)Pattern.compile("Inconsistent|Contract key lookup with different results")), true, Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            }
            {
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$13(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.Object ), $anonfun$applyOrElse$14(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.String java.lang.Object ), $anonfun$applyOrElse$15(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.String scala.runtime.BoxedUnit ), $anonfun$applyOrElse$16(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.String java.lang.Throwable ), $anonfun$applyOrElse$17(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.String java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$18$adapted(java.lang.Throwable java.lang.Throwable java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CKMaintainerScoped", "Contract keys should be scoped by maintainer", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object alice = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object bob = participant2.parties().apply(0);
                            String key1 = (String)alpha.nextKeyId().apply();
                            String key2 = (String)alpha.nextKeyId().apply();
                            String unknownKey = (String)alpha.nextKeyId().apply();
                            return (B1)alpha.create(alice, (Template)new TextKey(alice, key1, (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob})))).flatMap((Function1 & Serializable)tk1 -> alpha.create(alice, (Template)new TextKey(alice, key2, (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob})))).flatMap((Function1 & Serializable)tk2 -> alpha.create(alice, (Template)new TextKeyOperations(alice)).flatMap((Function1 & Serializable)aliceTKO -> beta.create(bob, (Template)new TextKeyOperations(bob)).flatMap((Function1 & Serializable)bobTKO -> Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$4).flatMap((Function1 & Serializable)x$11 -> {
                                BoxedUnit boxedUnit = x$11;
                                return Assertions$.MODULE$.futureAssertions(alpha.create(alice, (Template)new TextKey(alice, key1, (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bob}))))).mustFail("creating a contract with a duplicate key", $this.ec$4).flatMap((Function1 & Serializable)duplicateKeyFailure -> Assertions$.MODULE$.futureAssertions(beta.exercise(bob, TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOLookup$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(bobTKO), new Tuple2(alice, (Object)key1), (Option)new Some(tk1), ExerciseOn$.MODULE$.OnId()))).mustFail("looking up a contract with an unauthorized key", $this.ec$4).flatMap((Function1 & Serializable)bobLooksUpTextKeyFailure -> Assertions$.MODULE$.futureAssertions(beta.exercise(bob, TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOLookup$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(bobTKO), new Tuple2(alice, (Object)unknownKey), (Option)None$.MODULE$, ExerciseOn$.MODULE$.OnId()))).mustFail("looking up a contract with an unauthorized, non-existing key", $this.ec$4).flatMap((Function1 & Serializable)bobLooksUpBogusTextKeyFailure -> alpha.exercise(alice, TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOLookup$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(aliceTKO), new Tuple2(alice, (Object)key1), (Option)new Some(tk1), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$10 -> {
                                    TransactionTree transactionTree = x$10;
                                    return alpha.exercise(alice, TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOFetch$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(aliceTKO), new Tuple2(alice, (Object)key1), tk1, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$9 -> {
                                        TransactionTree transactionTree = x$9;
                                        return alpha.exercise(alice, TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOLookup$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(aliceTKO), new Tuple2(alice, (Object)unknownKey), (Option)None$.MODULE$, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$8 -> {
                                            TransactionTree transactionTree = x$8;
                                            return Assertions$.MODULE$.futureAssertions(alpha.exercise(alice, TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOFetch$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(aliceTKO), new Tuple2(alice, (Object)unknownKey), tk1, ExerciseOn$.MODULE$.OnId()))).mustFail("fetching a contract by an unknown key", $this.ec$4).flatMap((Function1 & Serializable)aliceFailedFetch -> alpha.exercise(alice, TextKey.TextKey$u0020syntax$.MODULE$.exerciseTextKeyChoice$extension(TextKey$.MODULE$.TextKey$u0020syntax(tk1), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$7 -> {
                                                TransactionTree transactionTree = x$7;
                                                return alpha.exercise(alice, TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOLookup$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(aliceTKO), new Tuple2(alice, (Object)key1), (Option)None$.MODULE$, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$6 -> {
                                                    TransactionTree transactionTree = x$6;
                                                    return alpha.exercise(alice, TextKeyOperations.TextKeyOperations$u0020syntax$.MODULE$.exerciseTKOConsumeAndLookup$extension(TextKeyOperations$.MODULE$.TextKeyOperations$u0020syntax(aliceTKO), tk2, new Tuple2(alice, (Object)key2), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$5 -> {
                                                        TransactionTree transactionTree = x$5;
                                                        return Assertions$.MODULE$.futureAssertions(alpha.create(alice, (Template)new MaintainerNotSignatory(alice, bob))).mustFail("creating a contract where a maintainer is not a signatory", $this.ec$4).map((Function1 & Serializable)maintainerNotSignatoryFailed -> {
                                                            $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$34(duplicateKeyFailure, bobLooksUpTextKeyFailure, bobLooksUpBogusTextKeyFailure, aliceFailedFetch, maintainerNotSignatoryFailed);
                                                            return BoxedUnit.UNIT;
                                                        }, $this.ec$4);
                                                    }, $this.ec$4);
                                                }, $this.ec$4);
                                            }, $this.ec$4), $this.ec$4);
                                        }, $this.ec$4);
                                    }, $this.ec$4);
                                }, $this.ec$4), $this.ec$4), $this.ec$4), $this.ec$4);
                            }, $this.ec$4), $this.ec$4), $this.ec$4), $this.ec$4), this.ec$4);
                        }
                    }
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participants participants = x4;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$34(Throwable duplicateKeyFailure$1, Throwable bobLooksUpTextKeyFailure$1, Throwable bobLooksUpBogusTextKeyFailure$1, Throwable aliceFailedFetch$1, Throwable maintainerNotSignatoryFailed) {
                Assertions$.MODULE$.assertGrpcErrorRegex(duplicateKeyFailure$1, (ErrorCode)ConsistencyErrors.DuplicateContractKey$.MODULE$, (Option)new Some((Object)Pattern.compile("Inconsistent|contract key is not unique")), true, Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
                Assertions$.MODULE$.assertGrpcError(bobLooksUpTextKeyFailure$1, (ErrorCode)CommandExecution.Interpreter$.AuthorizationError$.MODULE$, (Option)new Some((Object)"requires authorizers"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(bobLooksUpBogusTextKeyFailure$1, (ErrorCode)CommandExecution.Interpreter$.AuthorizationError$.MODULE$, (Option)new Some((Object)"requires authorizers"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(aliceFailedFetch$1, (ErrorCode)CommandExecution.Interpreter$.LookupErrors$.ContractKeyNotFound$.MODULE$, (Option)new Some((Object)"couldn't find key"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(maintainerNotSignatoryFailed, (ErrorCode)CommandExecution.Interpreter$.AuthorizationError$.MODULE$, (Option)new Some((Object)"are not a subset of the signatories"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$19(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.String java.lang.String java.lang.Object ), $anonfun$applyOrElse$20(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.String java.lang.Object ), $anonfun$applyOrElse$21(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object ), $anonfun$applyOrElse$22(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.Object java.lang.String java.lang.Object ), $anonfun$applyOrElse$23(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.Object java.lang.String scala.runtime.BoxedUnit ), $anonfun$applyOrElse$24(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.String com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Throwable ), $anonfun$applyOrElse$25(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.String com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.Object java.lang.Object java.lang.String java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$26(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$27(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$28(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$29(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$30(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$31(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.String java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$32(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.String java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$33(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Throwable java.lang.Throwable java.lang.Throwable java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$34$adapted(java.lang.Throwable java.lang.Throwable java.lang.Throwable java.lang.Throwable java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CKRecreate", "Contract keys can be recreated in single transaction", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object owner = participant.parties().apply(0);
                    String key = (String)ledger.nextKeyId().apply();
                    return (B1)ledger.submitAndWaitForTransactionTree(ledger.submitAndWaitRequest(owner, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{new Delegated(owner, key).create(DummyImplicit$.MODULE$.dummyImplicit()).command()}))).map((Function1 & Serializable)x$12 -> x$12.getTransaction(), this.ec$5).map((Function1 & Serializable)delegated1TxTree -> {
                        Object delegated1Id = package$.MODULE$.Primitive().ContractId().apply(((TreeEvent)((scala.Tuple2)delegated1TxTree.eventsById().head())._2()).getCreated().contractId());
                        return new scala.Tuple2(delegated1TxTree, delegated1Id);
                    }, this.ec$5).flatMap((Function1 & Serializable)x$14 -> {
                        scala.Tuple2 tuple2 = x$14;
                        if (tuple2 != null) {
                            TransactionTree delegated1TxTree = (TransactionTree)tuple2._1();
                            Object delegated1Id = tuple2._2();
                            return ledger.exercise(owner, Delegated.Delegated$u0020syntax$.MODULE$.exerciseRecreate$extension(Delegated$.MODULE$.Delegated$u0020syntax(delegated1Id), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)delegated2TxTree -> {
                                $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$38(delegated1Id, delegated1TxTree, delegated2TxTree);
                                return BoxedUnit.UNIT;
                            }, $this.ec$5);
                        }
                        throw new MatchError((Object)tuple2);
                    }, this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$39(scala.Tuple2 x$13) {
                return ((TreeEvent)x$13._2()).kind().isCreated();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$38(Object delegated1Id$1, TransactionTree delegated1TxTree$1, TransactionTree delegated2TxTree) {
                Predef$.MODULE$.assert(delegated2TxTree.eventsById().size() == 2);
                TreeEvent event = (TreeEvent)((scala.Tuple2)((IterableOps)delegated2TxTree.eventsById().filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$39(x$13)))).head())._2();
                Object object = Tag$.MODULE$.unwrap(delegated1Id$1);
                String string = event.getCreated().contractId();
                Predef$.MODULE$.assert(object == null ? string != null : !object.equals(string), (Function0 & Serializable)() -> "New contract was not created");
                Option option = event.getCreated().contractKey();
                Option option2 = ((TreeEvent)((scala.Tuple2)delegated1TxTree$1.eventsById().head())._2()).getCreated().contractKey();
                Predef$.MODULE$.assert(!(option != null ? !option.equals(option2) : option2 != null), (Function0 & Serializable)() -> "Contract keys did not match");
            }
            {
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$35(com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionTreeResponse ), $anonfun$applyOrElse$36(com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$37(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$38$adapted(java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$39$adapted(scala.Tuple2 ), $anonfun$applyOrElse$40(), $anonfun$applyOrElse$41()}, serializedLambda);
            }
        });
        this.test("CKTransients", "Contract keys created by transient contracts are properly archived", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$6;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x6;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object owner = participant.parties().apply(0);
                    String key = (String)ledger.nextKeyId().apply();
                    String key2 = (String)ledger.nextKeyId().apply();
                    return (B1)ledger.create(owner, (Template)new Delegation(owner, owner)).flatMap((Function1 & Serializable)delegation -> ledger.create(owner, (Template)new Delegated(owner, key)).flatMap((Function1 & Serializable)delegated -> Assertions$.MODULE$.futureAssertions(ledger.exercise(owner, Delegation.Delegation$u0020syntax$.MODULE$.exerciseFetchByKeyDelegated$extension(Delegation$.MODULE$.Delegation$u0020syntax(delegation), owner, key2, ExerciseOn$.MODULE$.OnId()))).mustFail("fetching a contract with an unknown key", $this.ec$6).flatMap((Function1 & Serializable)failedFetch -> ledger.exercise(owner, Delegated.Delegated$u0020syntax$.MODULE$.exerciseCreateAnotherAndArchive$extension(Delegated$.MODULE$.Delegated$u0020syntax(delegated), key2, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$16 -> {
                        TransactionTree transactionTree = x$16;
                        return ledger.exercise(owner, Delegated.Delegated$u0020syntax$.MODULE$.exerciseCreateAnotherAndArchive$extension(Delegated$.MODULE$.Delegated$u0020syntax(delegated), key2, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$15 -> {
                            $anonfun$$nestedInanonfun$new$6$1.$anonfun$applyOrElse$46(failedFetch, x$15);
                            return BoxedUnit.UNIT;
                        }, $this.ec$6);
                    }, $this.ec$6), $this.ec$6), $this.ec$6), this.ec$6);
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(Allocation.Participants x6) {
                Allocation.Participant participant;
                Allocation.Participants participants = x6;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$46(Throwable failedFetch$1, TransactionTree x$15) {
                TransactionTree transactionTree = x$15;
                Assertions$.MODULE$.assertGrpcError(failedFetch$1, (ErrorCode)CommandExecution.Interpreter$.LookupErrors$.ContractKeyNotFound$.MODULE$, (Option)new Some((Object)"couldn't find key"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$6 = ec$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$42(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.String java.lang.Object ), $anonfun$applyOrElse$43(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Object ), $anonfun$applyOrElse$44(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Throwable ), $anonfun$applyOrElse$45(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$6$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.String java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$46$adapted(java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("CKExposedByTemplate", "The contract key should be exposed if the template specifies one", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$7;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x7;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String expectedKey = (String)ledger.nextKeyId().apply();
                    return (B1)ledger.create(party, (Template)new TextKey(party, expectedKey, (Seq)scala.package$.MODULE$.List().empty())).flatMap((Function1 & Serializable)x$17 -> {
                        Object object = x$17;
                        return ledger.flatTransactions((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)transactions -> {
                            $anonfun$$nestedInanonfun$new$7$1.$anonfun$applyOrElse$48(party, expectedKey, transactions);
                            return BoxedUnit.UNIT;
                        }, $this.ec$7);
                    }, this.ec$7);
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(Allocation.Participants x7) {
                Allocation.Participant participant;
                Allocation.Participants participants = x7;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$48(Object party$1, String expectedKey$1, Vector transactions) {
                CreatedEvent contract = (CreatedEvent)Assertions$.MODULE$.assertSingleton("CKExposedByTemplate", (Seq)transactions.flatMap((Function1 & Serializable)transaction -> TransactionHelpers$.MODULE$.createdEvents(transaction)));
                Assertions$.MODULE$.assertEquals("CKExposedByTemplate", (Object)contract.getContractKey().getRecord().fields(), (Object)new .colon.colon((Object)new RecordField("_1", (Option)new Some((Object)new Value((Value.Sum)new Value.Sum$.Party((String)Tag$.MODULE$.unwrap(party$1))))), (List)new .colon.colon((Object)new RecordField("_2", (Option)new Some((Object)new Value((Value.Sum)new Value.Sum$.Text(expectedKey$1)))), (List)Nil$.MODULE$)));
            }
            {
                this.ec$7 = ec$7;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$47(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$7$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String java.lang.Object ), $anonfun$applyOrElse$48$adapted(java.lang.Object java.lang.String scala.collection.immutable.Vector ), $anonfun$applyOrElse$49(com.daml.ledger.api.v1.transaction.Transaction )}, serializedLambda);
            }
        });
        this.test("CKExerciseByKey", "Exercising by key should be possible only when the corresponding contract is available", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$8;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x8;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    String keyString = (String)ledger.nextKeyId().apply();
                    .colon.colon x$1 = new .colon.colon((Object)new RecordField("_1", (Option)new Some((Object)new Value((Value.Sum)new Value.Sum$.Party((String)Tag$.MODULE$.unwrap(party))))), (List)new .colon.colon((Object)new RecordField("_2", (Option)new Some((Object)new Value((Value.Sum)new Value.Sum$.Text(keyString)))), (List)Nil$.MODULE$));
                    Option x$2 = Record$.MODULE$.apply$default$1();
                    Value expectedKey = new Value((Value.Sum)new Value.Sum$.Record(new Record(x$2, (Seq)x$1)));
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.exerciseByKey(party, TextKey$.MODULE$.id(), expectedKey, "TextKeyChoice", new Value((Value.Sum)new Value.Sum$.Record(new Record(Record$.MODULE$.apply$default$1(), Record$.MODULE$.apply$default$2()))))).mustFail("exercising before creation", this.ec$8).flatMap((Function1 & Serializable)failureBeforeCreation -> ledger.create(party, (Template)new TextKey(party, keyString, (Seq)scala.package$.MODULE$.List().empty())).flatMap((Function1 & Serializable)x$19 -> {
                        Object object = x$19;
                        return ledger.exerciseByKey(party, TextKey$.MODULE$.id(), expectedKey, "TextKeyChoice", new Value((Value.Sum)new Value.Sum$.Record(new Record(Record$.MODULE$.apply$default$1(), Record$.MODULE$.apply$default$2())))).flatMap((Function1 & Serializable)x$18 -> {
                            TransactionTree transactionTree = x$18;
                            return Assertions$.MODULE$.futureAssertions(ledger.exerciseByKey(party, TextKey$.MODULE$.id(), expectedKey, "TextKeyChoice", new Value((Value.Sum)new Value.Sum$.Record(new Record(Record$.MODULE$.apply$default$1(), Record$.MODULE$.apply$default$2()))))).mustFail("exercising after consuming", $this.ec$8).map((Function1 & Serializable)failureAfterConsuming -> {
                                $anonfun$$nestedInanonfun$new$8$1.$anonfun$applyOrElse$53(failureBeforeCreation, failureAfterConsuming);
                                return BoxedUnit.UNIT;
                            }, $this.ec$8);
                        }, $this.ec$8);
                    }, $this.ec$8), this.ec$8);
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(Allocation.Participants x8) {
                Allocation.Participant participant;
                Allocation.Participants participants = x8;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$53(Throwable failureBeforeCreation$1, Throwable failureAfterConsuming) {
                Assertions$.MODULE$.assertGrpcError(failureBeforeCreation$1, (ErrorCode)CommandExecution.Interpreter$.LookupErrors$.ContractKeyNotFound$.MODULE$, (Option)new Some((Object)"dependency error: couldn't find key"), true, Assertions$.MODULE$.assertGrpcError$default$5());
                Assertions$.MODULE$.assertGrpcError(failureAfterConsuming, (ErrorCode)CommandExecution.Interpreter$.LookupErrors$.ContractKeyNotFound$.MODULE$, (Option)new Some((Object)"dependency error: couldn't find key"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$50(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.String com.daml.ledger.api.v1.value.Value java.lang.Throwable ), $anonfun$applyOrElse$51(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.value.Value java.lang.Throwable java.lang.Object ), $anonfun$applyOrElse$52(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$8$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.v1.value.Value java.lang.Throwable com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$53$adapted(java.lang.Throwable java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("CKLocalLookupByKeyVisibility", "Visibility should not be checked for lookup-by-key of contracts created in the current transaction", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$9;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                A1 A1 = x9;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext ledger1 = participant.context();
                        Object party1 = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext ledger2 = participant2.context();
                            Object party2 = participant2.parties().apply(0);
                            return (B1)ledger1.create(party1, (Template)new LocalKeyVisibilityOperations(party1, party2)).flatMap((Function1 & Serializable)ops -> Synchronize$.MODULE$.synchronize(ledger1, ledger2, $this.ec$9).flatMap((Function1 & Serializable)x$21 -> {
                                BoxedUnit boxedUnit = x$21;
                                return ledger2.exercise(party2, LocalKeyVisibilityOperations.LocalKeyVisibilityOperations$u0020syntax$.MODULE$.exerciseLocalLookup$extension(LocalKeyVisibilityOperations$.MODULE$.LocalKeyVisibilityOperations$u0020syntax(ops), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$20 -> {
                                    $anonfun$$nestedInanonfun$new$9$1.$anonfun$applyOrElse$56(x$20);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$9);
                            }, $this.ec$9), this.ec$9);
                        }
                    }
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(Allocation.Participants x9) {
                Allocation.Participants participants = x9;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$56(TransactionTree x$20) {
                TransactionTree transactionTree = x$20;
            }
            {
                this.ec$9 = ec$9;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$54(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$55(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$9$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$56$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("CKLocalFetchByKeyVisibility", "Visibility should not be checked for fetch-by-key of contracts created in the current transaction", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$10;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                A1 A1 = x10;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext ledger1 = participant.context();
                        Object party1 = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext ledger2 = participant2.context();
                            Object party2 = participant2.parties().apply(0);
                            return (B1)ledger1.create(party1, (Template)new LocalKeyVisibilityOperations(party1, party2)).flatMap((Function1 & Serializable)ops -> Synchronize$.MODULE$.synchronize(ledger1, ledger2, $this.ec$10).flatMap((Function1 & Serializable)x$23 -> {
                                BoxedUnit boxedUnit = x$23;
                                return ledger2.exercise(party2, LocalKeyVisibilityOperations.LocalKeyVisibilityOperations$u0020syntax$.MODULE$.exerciseLocalFetch$extension(LocalKeyVisibilityOperations$.MODULE$.LocalKeyVisibilityOperations$u0020syntax(ops), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$22 -> {
                                    $anonfun$$nestedInanonfun$new$10$1.$anonfun$applyOrElse$59(x$22);
                                    return BoxedUnit.UNIT;
                                }, $this.ec$10);
                            }, $this.ec$10), this.ec$10);
                        }
                    }
                }
                return (B1)function1.apply(x10);
            }

            public final boolean isDefinedAt(Allocation.Participants x10) {
                Allocation.Participants participants = x10;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$59(TransactionTree x$22) {
                TransactionTree transactionTree = x$22;
            }
            {
                this.ec$10 = ec$10;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$57(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$58(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$10$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$59$adapted(com.daml.ledger.api.v1.transaction.TransactionTree )}, serializedLambda);
            }
        });
        this.test("CKDisclosedContractKeyReusabilityBasic", "Subsequent disclosed contracts can use the same contract key", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$11;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                A1 A1 = x11;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext ledger1 = participant.context();
                        Object party1 = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext ledger2 = participant2.context();
                            Object party2 = participant2.parties().apply(0);
                            return (B1)ledger1.create(party1, (Template)new WithKeyCreator(party1, party2)).flatMap((Function1 & Serializable)creator1 -> ledger1.exerciseAndGetContract(party1, WithKeyCreator.WithKeyCreator$u0020syntax$.MODULE$.exerciseWithKeyCreator_DiscloseCreate$extension(WithKeyCreator$.MODULE$.WithKeyCreator$u0020syntax(creator1), party1, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)withKey1 -> ledger1.create(party1, (Template)new WithKeyFetcher(party1, party2)).flatMap((Function1 & Serializable)fetcher -> Synchronize$.MODULE$.synchronize(ledger1, ledger2, $this.ec$11).flatMap((Function1 & Serializable)x$30 -> {
                                BoxedUnit boxedUnit = x$30;
                                return ledger2.exercise(party2, WithKeyFetcher.WithKeyFetcher$u0020syntax$.MODULE$.exerciseWithKeyFetcher_Fetch$extension(WithKeyFetcher$.MODULE$.WithKeyFetcher$u0020syntax(fetcher), withKey1, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$29 -> {
                                    TransactionTree transactionTree = x$29;
                                    return ledger1.exercise(party1, WithKey.WithKey$u0020syntax$.MODULE$.exerciseArchive$extension(WithKey$.MODULE$.WithKey$u0020syntax(withKey1), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$28 -> {
                                        TransactionTree transactionTree = x$28;
                                        return Synchronize$.MODULE$.synchronize(ledger1, ledger2, $this.ec$11).flatMap((Function1 & Serializable)x$27 -> {
                                            BoxedUnit boxedUnit = x$27;
                                            return Assertions$.MODULE$.futureAssertions(ledger2.exercise(party2, WithKeyFetcher.WithKeyFetcher$u0020syntax$.MODULE$.exerciseWithKeyFetcher_Fetch$extension(WithKeyFetcher$.MODULE$.WithKeyFetcher$u0020syntax(fetcher), withKey1, ExerciseOn$.MODULE$.OnId()))).mustFail("fetching an archived contract", $this.ec$11).flatMap((Function1 & Serializable)x$26 -> {
                                                Throwable throwable = x$26;
                                                return ledger1.create(party1, (Template)new WithKeyCreator(party1, party2)).flatMap((Function1 & Serializable)creator2 -> ledger1.exerciseAndGetContract(party1, WithKeyCreator.WithKeyCreator$u0020syntax$.MODULE$.exerciseWithKeyCreator_DiscloseCreate$extension(WithKeyCreator$.MODULE$.WithKeyCreator$u0020syntax(creator2), party1, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$25 -> {
                                                    Object object = x$25;
                                                    return Synchronize$.MODULE$.synchronize(ledger1, ledger2, $this.ec$11).map((Function1 & Serializable)x$24 -> {
                                                        $anonfun$$nestedInanonfun$new$11$1.$anonfun$applyOrElse$70(x$24);
                                                        return BoxedUnit.UNIT;
                                                    }, $this.ec$11);
                                                }, $this.ec$11), $this.ec$11);
                                            }, $this.ec$11);
                                        }, $this.ec$11);
                                    }, $this.ec$11);
                                }, $this.ec$11);
                            }, $this.ec$11), $this.ec$11), $this.ec$11), this.ec$11);
                        }
                    }
                }
                return (B1)function1.apply(x11);
            }

            public final boolean isDefinedAt(Allocation.Participants x11) {
                Allocation.Participants participants = x11;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$70(BoxedUnit x$24) {
                BoxedUnit boxedUnit = x$24;
            }
            {
                this.ec$11 = ec$11;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$60(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$61(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$62(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$63(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$64(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$65(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$66(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$67(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Throwable ), $anonfun$applyOrElse$68(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$69(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$11$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object ), $anonfun$applyOrElse$70$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
        this.test("CKDisclosedContractKeyReusabilityAsSubmitter", "Subsequent disclosed contracts can use the same contract key (disclosure because of submitting)", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$12;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                A1 A1 = x12;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext ledger1 = participant.context();
                        Object party1 = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext ledger2 = participant2.context();
                            Object party2 = participant2.parties().apply(0);
                            return (B1)ledger1.create(party1, (Template)new WithKeyCreatorAlternative(party1, party2)).flatMap((Function1 & Serializable)creator1 -> Synchronize$.MODULE$.synchronize(ledger1, ledger2, $this.ec$12).flatMap((Function1 & Serializable)x$40 -> {
                                BoxedUnit boxedUnit = x$40;
                                return ledger2.exercise(party2, WithKeyCreatorAlternative.WithKeyCreatorAlternative$u0020syntax$.MODULE$.exerciseWithKeyCreatorAlternative_DiscloseCreate$extension(WithKeyCreatorAlternative$.MODULE$.WithKeyCreatorAlternative$u0020syntax(creator1), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$39 -> {
                                    TransactionTree transactionTree = x$39;
                                    return Synchronize$.MODULE$.synchronize(ledger1, ledger2, $this.ec$12).flatMap((Function1 & Serializable)x$38 -> {
                                        BoxedUnit boxedUnit = x$38;
                                        return ledger1.activeContractsByTemplateId((Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{WithKey$.MODULE$.id()})), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party1})).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$12$1.$anonfun$applyOrElse$75(check$ifrefutable$1)), $this.ec$12).map((Function1 & Serializable)x$32 -> {
                                            SeqOps seqOps;
                                            Vector vector = x$32;
                                            if (vector != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                                                CreatedEvent withKey1Event = (CreatedEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                                                Object withKey1 = package$.MODULE$.Primitive().ContractId().apply(withKey1Event.contractId());
                                                return new scala.Tuple2((Object)vector, withKey1);
                                            }
                                            throw new MatchError((Object)vector);
                                        }, $this.ec$12).flatMap((Function1 & Serializable)x$37 -> {
                                            scala.Tuple2 tuple2 = x$37;
                                            if (tuple2 != null) {
                                                SeqOps seqOps;
                                                Vector vector = (Vector)tuple2._1();
                                                Object withKey1 = tuple2._2();
                                                if (vector != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                                                    return ledger1.exercise(party1, WithKey.WithKey$u0020syntax$.MODULE$.exerciseArchive$extension(WithKey$.MODULE$.WithKey$u0020syntax(withKey1), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$36 -> {
                                                        TransactionTree transactionTree = x$36;
                                                        return Synchronize$.MODULE$.synchronize(ledger1, ledger2, $this.ec$12).flatMap((Function1 & Serializable)x$35 -> {
                                                            BoxedUnit boxedUnit = x$35;
                                                            return ledger2.exercise(party2, WithKeyCreatorAlternative.WithKeyCreatorAlternative$u0020syntax$.MODULE$.exerciseWithKeyCreatorAlternative_DiscloseCreate$extension(WithKeyCreatorAlternative$.MODULE$.WithKeyCreatorAlternative$u0020syntax(creator1), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$34 -> {
                                                                TransactionTree transactionTree = x$34;
                                                                return Synchronize$.MODULE$.synchronize(ledger1, ledger2, $this.ec$12).map((Function1 & Serializable)x$33 -> {
                                                                    $anonfun$$nestedInanonfun$new$12$1.$anonfun$applyOrElse$81(x$33);
                                                                    return BoxedUnit.UNIT;
                                                                }, $this.ec$12);
                                                            }, $this.ec$12);
                                                        }, $this.ec$12);
                                                    }, $this.ec$12);
                                                }
                                            }
                                            throw new MatchError((Object)tuple2);
                                        }, $this.ec$12);
                                    }, $this.ec$12);
                                }, $this.ec$12);
                            }, $this.ec$12), this.ec$12);
                        }
                    }
                }
                return (B1)function1.apply(x12);
            }

            public final boolean isDefinedAt(Allocation.Participants x12) {
                Allocation.Participants participants = x12;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$75(Vector check$ifrefutable$1) {
                SeqOps seqOps;
                Vector vector = check$ifrefutable$1;
                return vector != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$81(BoxedUnit x$33) {
                BoxedUnit boxedUnit = x$33;
            }
            {
                this.ec$12 = ec$12;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$71(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$72(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$73(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$74(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$75$adapted(scala.collection.immutable.Vector ), $anonfun$applyOrElse$76(scala.collection.immutable.Vector ), $anonfun$applyOrElse$77(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$78(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$79(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.runtime.BoxedUnit ), $anonfun$applyOrElse$80(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$12$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$81$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
        this.test("CKGlocalKeyVisibility", "Contract keys should be visible", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.TwoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$13;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x13;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object alice = participant.parties().apply(0);
                    Object bob = participant.parties().apply(1);
                    return (B1)ledger.create(alice, (Template)new WithKey(alice)).flatMap((Function1 & Serializable)cid -> ledger.submit(ledger.submitRequest(alice, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{WithKey.WithKey$u0020syntax$.MODULE$.exerciseWithKey_NoOp$extension(WithKey$.MODULE$.WithKey$u0020syntax((Object)WithKey$.MODULE$.key(alice, (ValueEncoder)DamlCodecs$.MODULE$.valueParty())), alice, ExerciseOn$.MODULE$.OnKey()).command()}))).flatMap((Function1 & Serializable)x$45 -> {
                        BoxedUnit boxedUnit = x$45;
                        return ledger.create(bob, (Template)new WithKeyDivulgenceHelper(bob, alice)).flatMap((Function1 & Serializable)helper -> ledger.exercise(alice, WithKeyDivulgenceHelper.WithKeyDivulgenceHelper$u0020syntax$.MODULE$.exerciseWithKeyDivulgenceHelper_Fetch$extension(WithKeyDivulgenceHelper$.MODULE$.WithKeyDivulgenceHelper$u0020syntax(helper), cid, ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$44 -> {
                            TransactionTree transactionTree = x$44;
                            return ledger.exercise(bob, WithKey.WithKey$u0020syntax$.MODULE$.exerciseWithKey_NoOp$extension(WithKey$.MODULE$.WithKey$u0020syntax(cid), bob, ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)x$41 -> {
                                SubmitRequest request = ledger.submitRequest(bob, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{WithKey.WithKey$u0020syntax$.MODULE$.exerciseWithKey_NoOp$extension(WithKey$.MODULE$.WithKey$u0020syntax((Object)WithKey$.MODULE$.key(alice, (ValueEncoder)DamlCodecs$.MODULE$.valueParty())), bob, ExerciseOn$.MODULE$.OnKey()).command()}));
                                return new scala.Tuple2(x$41, (Object)request);
                            }, $this.ec$13).flatMap((Function1 & Serializable)x$43 -> {
                                scala.Tuple2 tuple2 = x$43;
                                if (tuple2 != null) {
                                    SubmitRequest request = (SubmitRequest)tuple2._2();
                                    return Assertions$.MODULE$.futureAssertions(ledger.submit(request)).mustFail("exercise of a non visible key", $this.ec$13).map((Function1 & Serializable)failure1 -> {
                                        SubmitRequest request = ledger.submitRequest(bob, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command[]{WithKey.WithKey$u0020syntax$.MODULE$.exerciseWithKey_NoOp$extension(WithKey$.MODULE$.WithKey$u0020syntax(cid), bob, ExerciseOn$.MODULE$.OnId()).command(), WithKey.WithKey$u0020syntax$.MODULE$.exerciseWithKey_NoOp$extension(WithKey$.MODULE$.WithKey$u0020syntax((Object)WithKey$.MODULE$.key(alice, (ValueEncoder)DamlCodecs$.MODULE$.valueParty())), bob, ExerciseOn$.MODULE$.OnKey()).command()}));
                                        return new scala.Tuple2(failure1, (Object)request);
                                    }, $this.ec$13).flatMap((Function1 & Serializable)x$42 -> {
                                        scala.Tuple2 tuple2 = x$42;
                                        if (tuple2 != null) {
                                            Throwable failure1 = (Throwable)tuple2._1();
                                            SubmitRequest request = (SubmitRequest)tuple2._2();
                                            return Assertions$.MODULE$.futureAssertions(ledger.submit(request)).mustFail("exercise of a non visible key", $this.ec$13).map((Function1 & Serializable)failure2 -> {
                                                $anonfun$$nestedInanonfun$new$13$1.$anonfun$applyOrElse$90(failure1, failure2);
                                                return BoxedUnit.UNIT;
                                            }, $this.ec$13);
                                        }
                                        throw new MatchError((Object)tuple2);
                                    }, $this.ec$13);
                                }
                                throw new MatchError((Object)tuple2);
                            }, $this.ec$13);
                        }, $this.ec$13), $this.ec$13);
                    }, $this.ec$13), this.ec$13);
                }
                return (B1)function1.apply(x13);
            }

            public final boolean isDefinedAt(Allocation.Participants x13) {
                Allocation.Participant participant;
                Allocation.Participants participants = x13;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(2) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$91(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)CommandExecution.Interpreter$.LookupErrors$.ContractKeyNotFound$.MODULE$, (Option)new Some((Object)"couldn't find key"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$90(Throwable failure1$1, Throwable failure2) {
                new .colon.colon((Object)failure1$1, (List)new .colon.colon((Object)failure2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)failure -> {
                    $anonfun$$nestedInanonfun$new$13$1.$anonfun$applyOrElse$91(failure);
                    return BoxedUnit.UNIT;
                });
            }
            {
                this.ec$13 = ec$13;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$82(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$83(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$84(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), $anonfun$applyOrElse$85(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$86(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$87(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object scala.Tuple2 ), $anonfun$applyOrElse$88(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object java.lang.Object java.lang.Throwable ), $anonfun$applyOrElse$89(com.daml.ledger.api.testtool.suites.v1_8.ContractKeysIT$$anonfun$$nestedInanonfun$new$13$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple2 ), $anonfun$applyOrElse$90$adapted(java.lang.Throwable java.lang.Throwable ), $anonfun$applyOrElse$91$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
    }
}

