/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.PackageServiceError;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.PackageManagementServiceIT$$anonfun$;
import com.daml.ledger.api.v1.admin.package_management_service.PackageDetails;
import com.daml.ledger.api.v1.admin.package_management_service.UploadDarFileRequest;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.test.PackageManagementTestDar$;
import com.daml.ledger.test.package_management.PackageManagementTest.PackageManagementTestTemplate;
import com.daml.ledger.test.package_management.PackageManagementTest.PackageManagementTestTemplate$;
import com.google.protobuf.ByteString;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.regex.Pattern;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00013A\u0001B\u0003\u0003)!)1\u0004\u0001C\u00019!1q\u0004\u0001Q\u0001\n\u0001BQ\u0001\u000b\u0001\u0005\n%\u0012!\u0004U1dW\u0006<W-T1oC\u001e,W.\u001a8u'\u0016\u0014h/[2f\u0013RS!AB\u0004\u0002\tY\ft\f\u000f\u0006\u0003\u0011%\taa];ji\u0016\u001c(B\u0001\u0006\f\u0003!!Xm\u001d;u_>d'B\u0001\u0007\u000e\u0003\r\t\u0007/\u001b\u0006\u0003\u001d=\ta\u0001\\3eO\u0016\u0014(B\u0001\t\u0012\u0003\u0011!\u0017-\u001c7\u000b\u0003I\t1aY8n\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0005aI\u0011AD5oMJ\f7\u000f\u001e:vGR,(/Z\u0005\u00035]\u0011q\u0002T3eO\u0016\u0014H+Z:u'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\u0015\tq\u0003^3tiB\u000b7m[1hKJ+7o\\;sG\u0016\u0004\u0016\r\u001e5\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t11\u000b\u001e:j]\u001e\fq\u0002\\8bIR+7\u000f\u001e)bG.\fw-\u001a\u000b\u0002UQ\u00111f\u000f\t\u0004YE\u001aT\"A\u0017\u000b\u00059z\u0013AC2p]\u000e,(O]3oi*\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023[\t1a)\u001e;ve\u0016\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u0011A\u0014x\u000e^8ck\u001aT!\u0001O\t\u0002\r\u001d|wn\u001a7f\u0013\tQTG\u0001\u0006CsR,7\u000b\u001e:j]\u001eDQ\u0001P\u0002A\u0004u\n!!Z2\u0011\u00051r\u0014BA .\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f")
public final class PackageManagementServiceIT
extends LedgerTestSuite {
    private final String testPackageResourcePath = PackageManagementTestDar$.MODULE$.path();

    public Future<ByteString> com$daml$ledger$api$testtool$suites$v1_8$PackageManagementServiceIT$$loadTestPackage(ExecutionContext ec) {
        Future testPackage = Future$.MODULE$.apply((Function0 & Serializable)() -> {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream($this.testPackageResourcePath);
            Predef$.MODULE$.assert(in != null, (Function0 & Serializable)() -> new StringBuilder(42).append("Unable to load test package resource at '").append($this.testPackageResourcePath).append("'").toString());
            return in;
        }, ec);
        Future bytes = testPackage.map((Function1 & Serializable)x$1 -> ByteString.readFrom((InputStream)x$1), ec);
        bytes.onComplete((Function1 & Serializable)x$1 -> testPackage.map((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        }, ec), ec);
        return bytes;
    }

    public PackageManagementServiceIT() {
        this.test("PMEmptyUpload", "An attempt at uploading an empty payload should fail", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    return (B1)Assertions$.MODULE$.futureAssertions(ledger.uploadDarFile(ByteString.EMPTY)).mustFail("uploading an empty package", this.ec$2).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$1(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec$2);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1(Throwable failure) {
                Assertions$.MODULE$.assertGrpcErrorRegex(failure, (ErrorCode)PackageServiceError.Reading$.InvalidDar$.MODULE$, (Option)new Some((Object)Pattern.compile("Invalid DAR: package-upload|Dar file is corrupt")), Assertions$.MODULE$.assertGrpcErrorRegex$default$4(), Assertions$.MODULE$.assertGrpcErrorRegex$default$5());
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
        this.test("PMDuplicateSubmissionId", "Duplicate submission ids are accepted when package uploaded twice", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.NoParties$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.NoParties$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ PackageManagementServiceIT $outer;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(0) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$PackageManagementServiceIT$$loadTestPackage(this.ec$3).map((Function1 & Serializable)testPackage -> {
                                UploadDarFileRequest request = alpha.uploadDarRequest(testPackage);
                                return new Tuple2(testPackage, (Object)request);
                            }, this.ec$3).flatMap((Function1 & Serializable)x$5 -> {
                                Tuple2 tuple2 = x$5;
                                if (tuple2 != null) {
                                    UploadDarFileRequest request = (UploadDarFileRequest)tuple2._2();
                                    return alpha.uploadDarFile(request).flatMap((Function1 & Serializable)x$4 -> {
                                        BoxedUnit boxedUnit = x$4;
                                        return beta.uploadDarFile(request).map((Function1 & Serializable)x$3 -> {
                                            $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$5(x$3);
                                            return BoxedUnit.UNIT;
                                        }, $this.ec$3);
                                    }, $this.ec$3);
                                }
                                throw new MatchError((Object)tuple2);
                            }, this.ec$3);
                        }
                    }
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participants participants = x2;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(0) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(0) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$5(BoxedUnit x$3) {
                BoxedUnit boxedUnit = x$3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.google.protobuf.ByteString ), $anonfun$applyOrElse$3(com.daml.ledger.api.testtool.suites.v1_8.PackageManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext scala.Tuple2 ), $anonfun$applyOrElse$4(com.daml.ledger.api.testtool.suites.v1_8.PackageManagementServiceIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.v1.admin.package_management_service.UploadDarFileRequest scala.runtime.BoxedUnit ), $anonfun$applyOrElse$5$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
        this.test("PMLoad", "Concurrent uploads of the same package should be idempotent and result in the package being available for use", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(this, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ PackageManagementServiceIT $outer;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)this.$outer.com$daml$ledger$api$testtool$suites$v1_8$PackageManagementServiceIT$$loadTestPackage(this.ec$4).flatMap((Function1 & Serializable)testPackage -> Future$.MODULE$.sequence((IterableOnce)package$.MODULE$.Vector().fill(8, (Function0 & Serializable)() -> ledger.uploadDarFile(testPackage)), BuildFrom$.MODULE$.buildFromIterableOps(), $this.ec$4).flatMap((Function1 & Serializable)x$11 -> {
                        Vector vector = x$11;
                        return ledger.listKnownPackages().flatMap((Function1 & Serializable)knownPackages -> ledger.create(party, (Template)new PackageManagementTestTemplate(party)).flatMap((Function1 & Serializable)contract -> ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).flatMap((Function1 & Serializable)acsBefore -> ledger.exercise(party, PackageManagementTestTemplate.PackageManagementTestTemplate$u0020syntax$.MODULE$.exerciseTestChoice$extension(PackageManagementTestTemplate$.MODULE$.PackageManagementTestTemplate$u0020syntax(contract), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$10 -> {
                            TransactionTree transactionTree = x$10;
                            return ledger.activeContracts((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)acsAfter -> {
                                $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$13(knownPackages, acsBefore, acsAfter);
                                return BoxedUnit.UNIT;
                            }, $this.ec$4);
                        }, $this.ec$4), $this.ec$4), $this.ec$4), $this.ec$4);
                    }, $this.ec$4), this.ec$4);
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participant participant;
                Allocation.Participants participants = x3;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$15(Seq x$7) {
                return x$7.size();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$16(Tuple2 x$8) {
                return x$8._2$mcI$sp() > 1;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$13(Seq knownPackages$1, Vector acsBefore$1, Vector acsAfter) {
                Map duplicatePackageIds = knownPackages$1.groupBy((Function1 & Serializable)x$6 -> x$6.packageId()).view().mapValues((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$15(x$7))).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$16(x$8))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Predef$.MODULE$.assert(duplicatePackageIds.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(41).append("There are duplicate package identifiers: ").append(((IterableOnceOps)duplicatePackageIds.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        int count = tuple2._2$mcI$sp();
                        return new StringBuilder(3).append(name).append(" (").append(count).append(")").toString();
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString(", ")).toString());
                Predef$.MODULE$.assert(acsBefore$1.size() == 1, (Function0 & Serializable)() -> "After the contract has been created there should be one active contract but there's none");
                Predef$.MODULE$.assert(acsAfter.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(72).append("There should be no active package after the contract has been consumed: ").append(((IterableOnceOps)acsAfter.map((Function1 & Serializable)x$9 -> x$9.contractId())).mkString(", ")).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(com.daml.ledger.api.testtool.suites.v1_8.PackageManagementServiceIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.collection.immutable.Seq java.lang.Object ), $anonfun$applyOrElse$11(com.daml.ledger.api.testtool.suites.v1_8.PackageManagementServiceIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Seq scala.collection.immutable.Vector ), $anonfun$applyOrElse$12(com.daml.ledger.api.testtool.suites.v1_8.PackageManagementServiceIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.collection.immutable.Seq scala.collection.immutable.Vector com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$13$adapted(scala.collection.immutable.Seq scala.collection.immutable.Vector scala.collection.immutable.Vector ), $anonfun$applyOrElse$14(com.daml.ledger.api.v1.admin.package_management_service.PackageDetails ), $anonfun$applyOrElse$15$adapted(scala.collection.immutable.Seq ), $anonfun$applyOrElse$16$adapted(scala.Tuple2 ), $anonfun$applyOrElse$17(scala.collection.immutable.Map ), $anonfun$applyOrElse$18(scala.Tuple2 ), $anonfun$applyOrElse$19(), $anonfun$applyOrElse$20(scala.collection.immutable.Vector ), $anonfun$applyOrElse$21(com.daml.ledger.api.v1.event.CreatedEvent ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.PackageManagementServiceIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.google.protobuf.ByteString ), $anonfun$applyOrElse$7(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.google.protobuf.ByteString ), $anonfun$applyOrElse$8(com.daml.ledger.api.testtool.suites.v1_8.PackageManagementServiceIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$9(com.daml.ledger.api.testtool.suites.v1_8.PackageManagementServiceIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object scala.collection.immutable.Seq )}, serializedLambda);
            }
        });
    }
}

