/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.suites.v1_8;

import com.daml.error.ErrorCode;
import com.daml.error.definitions.groups.CommandExecution;
import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.Eventually$;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.Synchronize$;
import com.daml.ledger.api.testtool.infrastructure.TransactionHelpers$;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$;
import com.daml.ledger.api.v1.event.ArchivedEvent;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.event.Event;
import com.daml.ledger.api.v1.transaction.Transaction;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.api.v1.transaction.TreeEvent;
import com.daml.ledger.client.binding.Template;
import com.daml.ledger.client.binding.encoding.ExerciseOn$;
import com.daml.ledger.client.binding.package$;
import com.daml.ledger.test.model.Test.AgreementFactory;
import com.daml.ledger.test.model.Test.AgreementFactory$;
import com.daml.ledger.test.model.Test.CreateAndFetch;
import com.daml.ledger.test.model.Test.CreateAndFetch$;
import com.daml.ledger.test.model.Test.Dummy;
import com.daml.ledger.test.model.Test.Dummy$;
import com.daml.ledger.test.model.Test.DummyFactory;
import com.daml.ledger.test.model.Test.DummyFactory$;
import com.daml.ledger.test.model.Test.DummyWithParam$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scalaz.Tag$;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0001%!)\u0011\u0004\u0001C\u00015\taBK]1og\u0006\u001cG/[8o'\u0016\u0014h/[2f\u000bb,'oY5tK&#&B\u0001\u0003\u0006\u0003\u00111\u0018g\u0018\u001d\u000b\u0005\u00199\u0011AB:vSR,7O\u0003\u0002\t\u0013\u0005AA/Z:ui>|GN\u0003\u0002\u000b\u0017\u0005\u0019\u0011\r]5\u000b\u00051i\u0011A\u00027fI\u001e,'O\u0003\u0002\u000f\u001f\u0005!A-Y7m\u0015\u0005\u0001\u0012aA2p[\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\t1r!\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005a)\"a\u0004'fI\u001e,'\u000fV3tiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0019\u0001")
public class TransactionServiceExerciseIT
extends LedgerTestSuite {
    public TransactionServiceExerciseIT() {
        this.test("TXUseCreateToExercise", "Should be able to directly use a contract identifier to exercise a choice", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x1;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new DummyFactory(party)).flatMap((Function1 & Serializable)dummyFactory -> ledger.exercise(party, DummyFactory.DummyFactory$u0020syntax$.MODULE$.exerciseDummyFactoryCall$extension(DummyFactory$.MODULE$.DummyFactory$u0020syntax(dummyFactory), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)transactions -> {
                        $anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$2(dummyFactory, transactions);
                        return BoxedUnit.UNIT;
                    }, $this.ec$1), this.ec$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Allocation.Participants x1) {
                Allocation.Participant participant;
                Allocation.Participants participants = x1;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$3(TreeEvent x$1) {
                return x$1.kind().isExercised();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2(Object dummyFactory$1, TransactionTree transactions) {
                Seq events = (Seq)transactions.rootEventIds().collect((PartialFunction)transactions.eventsById());
                Seq exercised = (Seq)events.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$1$1.$anonfun$applyOrElse$3(x$1)));
                Predef$.MODULE$.assert(exercised.size() == 1, (Function0 & Serializable)() -> new StringBuilder(32).append("Only one exercise expected, got ").append(exercised.size()).toString());
                String string = ((TreeEvent)exercised.head()).getExercised().contractId();
                Object object = Tag$.MODULE$.unwrap(dummyFactory$1);
                Predef$.MODULE$.assert(!(string != null ? !string.equals(object) : object != null), (Function0 & Serializable)() -> new StringBuilder(78).append("The identifier of the exercised contract should have been ").append(Tag$.MODULE$.unwrap(dummyFactory$1)).append(" but instead it was ").append(((TreeEvent)exercised.head()).getExercised().contractId()).toString());
            }
            {
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$$nestedInanonfun$new$1$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$2$adapted(java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$3$adapted(com.daml.ledger.api.v1.transaction.TreeEvent ), $anonfun$applyOrElse$4(scala.collection.immutable.Seq ), $anonfun$applyOrElse$5(java.lang.Object scala.collection.immutable.Seq )}, serializedLambda);
            }
        });
        this.test("TXContractIdFromExerciseWhenFilter", "Expose contract identifiers that are results of exercising choices when filtering by template", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$2;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x2;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new DummyFactory(party)).flatMap((Function1 & Serializable)factory -> ledger.exercise(party, DummyFactory.DummyFactory$u0020syntax$.MODULE$.exerciseDummyFactoryCall$extension(DummyFactory$.MODULE$.DummyFactory$u0020syntax(factory), ExerciseOn$.MODULE$.OnId())).flatMap((Function1 & Serializable)x$2 -> {
                        TransactionTree transactionTree = x$2;
                        return ledger.flatTransactionsByTemplateId(DummyWithParam$.MODULE$.id(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).flatMap((Function1 & Serializable)dummyWithParam -> ledger.flatTransactionsByTemplateId(DummyFactory$.MODULE$.id(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{party})).map((Function1 & Serializable)dummyFactory -> {
                            $anonfun$$nestedInanonfun$new$2$1.$anonfun$applyOrElse$9(dummyWithParam, factory, dummyFactory);
                            return BoxedUnit.UNIT;
                        }, $this.ec$2), $this.ec$2);
                    }, $this.ec$2), this.ec$2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Allocation.Participants x2) {
                Allocation.Participant participant;
                Allocation.Participants participants = x2;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$9(Vector dummyWithParam$1, Object factory$1, Vector dummyFactory) {
                CreatedEvent create = (CreatedEvent)Assertions$.MODULE$.assertSingleton("GetCreate", (Seq)dummyWithParam$1.flatMap((Function1 & Serializable)transaction -> TransactionHelpers$.MODULE$.createdEvents(transaction)));
                Assertions$.MODULE$.assertEquals("Create should be of DummyWithParam", (Object)create.getTemplateId(), Tag$.MODULE$.unwrap(DummyWithParam$.MODULE$.id()));
                ArchivedEvent archive = (ArchivedEvent)Assertions$.MODULE$.assertSingleton("GetArchive", (Seq)dummyFactory.flatMap((Function1 & Serializable)transaction -> TransactionHelpers$.MODULE$.archivedEvents(transaction)));
                Assertions$.MODULE$.assertEquals("Archive should be of DummyFactory", (Object)archive.getTemplateId(), Tag$.MODULE$.unwrap(DummyFactory$.MODULE$.id()));
                Assertions$.MODULE$.assertEquals("Mismatching archived contract identifier", (Object)archive.contractId(), Tag$.MODULE$.unwrap(factory$1));
            }
            {
                this.ec$2 = ec$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$11(com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$6(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$7(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$8(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$$nestedInanonfun$new$2$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.collection.immutable.Vector ), $anonfun$applyOrElse$9$adapted(scala.collection.immutable.Vector java.lang.Object scala.collection.immutable.Vector )}, serializedLambda);
            }
        });
        this.test("TXNotArchiveNonConsuming", "Expressing a non-consuming choice on a contract should not result in its archival", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[]{Allocation.SingleParty$.MODULE$})), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$3;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)A1.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)A1.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                        ParticipantTestContext alpha = participant.context();
                        Object receiver = participant.parties().apply(0);
                        if (participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                            ParticipantTestContext beta = participant2.context();
                            Object giver = participant2.parties().apply(0);
                            return (B1)beta.create(giver, (Template)new AgreementFactory(receiver, giver)).flatMap((Function1 & Serializable)agreementFactory -> Eventually$.MODULE$.eventually("exerciseCreateAgreement", Eventually$.MODULE$.eventually$default$2(), Eventually$.MODULE$.eventually$default$3(), (Function0 & Serializable)() -> alpha.exercise(receiver, AgreementFactory.AgreementFactory$u0020syntax$.MODULE$.exerciseCreateAgreement$extension(AgreementFactory$.MODULE$.AgreementFactory$u0020syntax(agreementFactory), ExerciseOn$.MODULE$.OnId())), $this.ec$3).flatMap((Function1 & Serializable)x$8 -> {
                                TransactionTree transactionTree = x$8;
                                return Synchronize$.MODULE$.synchronize(alpha, beta, $this.ec$3).flatMap((Function1 & Serializable)x$7 -> {
                                    BoxedUnit boxedUnit = x$7;
                                    return alpha.flatTransactions((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{receiver, giver})).map((Function1 & Serializable)transactions -> {
                                        $anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$16(transactions);
                                        return BoxedUnit.UNIT;
                                    }, $this.ec$3);
                                }, $this.ec$3);
                            }, $this.ec$3), this.ec$3);
                        }
                    }
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Allocation.Participants x3) {
                Allocation.Participants participants = x3;
                if (participants != null && participants.participants() != null && participants.participants().lengthCompare(2) == 0) {
                    Allocation.Participant participant = (Allocation.Participant)participants.participants().apply(0);
                    Allocation.Participant participant2 = (Allocation.Participant)participants.participants().apply(1);
                    if (participant != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0 && participant2 != null && participant2.parties() != null && participant2.parties().lengthCompare(1) == 0) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$18(Event x$4) {
                return x$4.event().isArchived();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$17(Transaction x$3) {
                return x$3.events().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$18(x$4)));
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$21(Event x$6) {
                return x$6.event().isArchived();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$16(Vector transactions) {
                Predef$.MODULE$.assert(!transactions.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$17(x$3))), (Function0 & Serializable)() -> new StringBuilder(37).append("The transaction include an archival: ").append(((StrictOptimizedIterableOps)transactions.flatMap((Function1 & Serializable)x$5 -> x$5.events())).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$new$3$1.$anonfun$applyOrElse$21(x$6)))).toString());
            }
            {
                this.ec$3 = ec$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$12(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$13(com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$14(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object com.daml.ledger.api.v1.transaction.TransactionTree ), $anonfun$applyOrElse$15(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$$nestedInanonfun$new$3$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object scala.runtime.BoxedUnit ), $anonfun$applyOrElse$16$adapted(scala.collection.immutable.Vector ), $anonfun$applyOrElse$17$adapted(com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$18$adapted(com.daml.ledger.api.v1.event.Event ), $anonfun$applyOrElse$19(scala.collection.immutable.Vector ), $anonfun$applyOrElse$20(com.daml.ledger.api.v1.transaction.Transaction ), $anonfun$applyOrElse$21$adapted(com.daml.ledger.api.v1.event.Event )}, serializedLambda);
            }
        });
        this.test("TXFetchContractCreatedInTransaction", "It should be possible to fetch a contract created within a transaction", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$4;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x4;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new CreateAndFetch(party)).flatMap((Function1 & Serializable)createAndFetch -> ledger.exerciseForFlatTransaction(party, CreateAndFetch.CreateAndFetch$u0020syntax$.MODULE$.exerciseCreateAndFetch_Run$extension(CreateAndFetch$.MODULE$.CreateAndFetch$u0020syntax(createAndFetch), ExerciseOn$.MODULE$.OnId())).map((Function1 & Serializable)transaction -> {
                        $anonfun$$nestedInanonfun$new$4$1.$anonfun$applyOrElse$23(createAndFetch, transaction);
                        return BoxedUnit.UNIT;
                    }, $this.ec$4), this.ec$4);
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Allocation.Participants x4) {
                Allocation.Participant participant;
                Allocation.Participants participants = x4;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$23(Object createAndFetch$1, Transaction transaction) {
                CreatedEvent createdEvent = (CreatedEvent)Assertions$.MODULE$.assertSingleton("There should be only one create", (Seq)TransactionHelpers$.MODULE$.createdEvents(transaction));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                ArchivedEvent exercise = (ArchivedEvent)Assertions$.MODULE$.assertSingleton("There should be only one archive", (Seq)TransactionHelpers$.MODULE$.archivedEvents(transaction));
                Assertions$.MODULE$.assertEquals("The contract identifier of the exercise does not match", Tag$.MODULE$.unwrap(createAndFetch$1), (Object)exercise.contractId());
            }
            {
                this.ec$4 = ec$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$22(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$$nestedInanonfun$new$4$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$23$adapted(java.lang.Object com.daml.ledger.api.v1.transaction.Transaction )}, serializedLambda);
            }
        });
        this.test("TXRejectOnFailingAssertion", "Reject a transaction on a failing assertion", Allocation$.MODULE$.allocate((Allocation.PartyCount)Allocation.SingleParty$.MODULE$, (Seq)Nil$.MODULE$), this.test$default$4(), this.test$default$5(), this.test$default$6(), this.test$default$7(), this.test$default$8(), this.test$default$9(), (Function1 & Serializable)ec -> new Serializable(null, (ExecutionContext)ec){
            private static final long serialVersionUID = 0L;
            private final ExecutionContext ec$5;

            public final <A1 extends Allocation.Participants, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Allocation.Participant participant;
                A1 A1 = x5;
                if (A1 != null && A1.participants() != null && A1.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)A1.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0) {
                    ParticipantTestContext ledger = participant.context();
                    Object party = participant.parties().apply(0);
                    return (B1)ledger.create(party, (Template)new Dummy(party)).flatMap((Function1 & Serializable)dummy -> Assertions$.MODULE$.futureAssertions(ledger.exercise(party, Dummy.Dummy$u0020syntax$.MODULE$.exerciseConsumeIfTimeIsBetween$extension(Dummy$.MODULE$.Dummy$u0020syntax(dummy), package$.MODULE$.Primitive().Timestamp().MAX(), package$.MODULE$.Primitive().Timestamp().MAX(), ExerciseOn$.MODULE$.OnId()))).mustFail("exercising with a failing assertion", $this.ec$5).map((Function1 & Serializable)failure -> {
                        $anonfun$$nestedInanonfun$new$5$1.$anonfun$applyOrElse$25(failure);
                        return BoxedUnit.UNIT;
                    }, $this.ec$5), this.ec$5);
                }
                return (B1)function1.apply(x5);
            }

            public final boolean isDefinedAt(Allocation.Participants x5) {
                Allocation.Participant participant;
                Allocation.Participants participants = x5;
                return participants != null && participants.participants() != null && participants.participants().lengthCompare(1) == 0 && (participant = (Allocation.Participant)participants.participants().apply(0)) != null && participant.parties() != null && participant.parties().lengthCompare(1) == 0;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$25(Throwable failure) {
                Assertions$.MODULE$.assertGrpcError(failure, (ErrorCode)CommandExecution.Interpreter$.UnhandledException$.MODULE$, (Option)new Some((Object)"Assertion failed"), true, Assertions$.MODULE$.assertGrpcError$default$5());
            }
            {
                this.ec$5 = ec$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$24(com.daml.ledger.api.testtool.suites.v1_8.TransactionServiceExerciseIT$$anonfun$$nestedInanonfun$new$5$1 com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext java.lang.Object java.lang.Object ), $anonfun$applyOrElse$25$adapted(java.lang.Throwable )}, serializedLambda);
            }
        });
    }
}

