/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.configuration;

import com.daml.ledger.configuration.Configuration;
import com.daml.ledger.configuration.LedgerTimeModel$;
import com.daml.ledger.configuration.protobuf.LedgerConfiguration;
import com.daml.ledger.configuration.protobuf.LedgerTimeModel;
import com.google.protobuf.Duration;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Try$;

public final class Configuration$
implements Serializable {
    public static final Configuration$ MODULE$ = new Configuration$();
    private static final long StartingGeneration = 1L;
    private static final long protobufVersion = 2L;
    private static final java.time.Duration reasonableMaxDeduplicationDuration = java.time.Duration.ofDays(1L);
    private static final Configuration reasonableInitialConfiguration = new Configuration(MODULE$.StartingGeneration(), LedgerTimeModel$.MODULE$.reasonableDefault(), MODULE$.reasonableMaxDeduplicationDuration());

    public long StartingGeneration() {
        return StartingGeneration;
    }

    public long protobufVersion() {
        return protobufVersion;
    }

    public java.time.Duration reasonableMaxDeduplicationDuration() {
        return reasonableMaxDeduplicationDuration;
    }

    public Configuration reasonableInitialConfiguration() {
        return reasonableInitialConfiguration;
    }

    public LedgerConfiguration encode(Configuration config) {
        com.daml.ledger.configuration.LedgerTimeModel tm = config.timeModel();
        return LedgerConfiguration.newBuilder().setVersion(this.protobufVersion()).setGeneration(config.generation()).setTimeModel(LedgerTimeModel.newBuilder().setAvgTransactionLatency(this.buildDuration(tm.avgTransactionLatency())).setMinSkew(this.buildDuration(tm.minSkew())).setMaxSkew(this.buildDuration(tm.maxSkew()))).setMaxDeduplicationDuration(this.buildDuration(config.maxDeduplicationDuration())).build();
    }

    public Either<String, Configuration> decode(byte[] bytes) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> LedgerConfiguration.parseFrom((byte[])bytes)).toEither().left().map((Function1 & Serializable)x$1 -> x$1.getMessage()).flatMap((Function1 & Serializable)config -> MODULE$.decode((LedgerConfiguration)config));
    }

    public Either<String, Configuration> decode(LedgerConfiguration config) {
        long l = config.getVersion();
        Object object = 1L == l ? this.decodeV1(config) : (2L == l ? this.decodeV2(config) : package$.MODULE$.Left().apply((Object)new StringBuilder(17).append("Unknown version: ").append(l).toString()));
        return object;
    }

    private Either<String, Configuration> decodeV1(LedgerConfiguration config) {
        return (config.hasTimeModel() ? this.decodeTimeModel(config.getTimeModel()) : package$.MODULE$.Left().apply((Object)"Missing time model")).map((Function1 & Serializable)tm -> new Configuration(config.getGeneration(), (com.daml.ledger.configuration.LedgerTimeModel)tm, java.time.Duration.ofDays(1L)));
    }

    private Either<String, Configuration> decodeV2(LedgerConfiguration config) {
        return (config.hasTimeModel() ? this.decodeTimeModel(config.getTimeModel()) : package$.MODULE$.Left().apply((Object)"Missing time model")).flatMap((Function1 & Serializable)tm -> {
            java.time.Duration duration;
            return (config.hasMaxDeduplicationDuration() ? ((duration = MODULE$.parseDuration(config.getMaxDeduplicationDuration())).isNegative() ? package$.MODULE$.Left().apply((Object)"requirement failed: Negative maximum command time to live") : package$.MODULE$.Right().apply((Object)duration)) : package$.MODULE$.Left().apply((Object)"Missing maximum command time to live")).map((Function1 & Serializable)maxDeduplicationTime -> new Configuration(config.getGeneration(), (com.daml.ledger.configuration.LedgerTimeModel)tm, (java.time.Duration)maxDeduplicationTime));
        });
    }

    private Either<String, com.daml.ledger.configuration.LedgerTimeModel> decodeTimeModel(LedgerTimeModel tm) {
        return LedgerTimeModel$.MODULE$.apply(this.parseDuration(tm.getAvgTransactionLatency()), this.parseDuration(tm.getMinSkew()), this.parseDuration(tm.getMaxSkew())).toEither().left().map((Function1 & Serializable)e -> new StringBuilder(17).append("decodeTimeModel: ").append(e.getMessage()).toString());
    }

    private java.time.Duration parseDuration(Duration dur) {
        return java.time.Duration.ofSeconds(dur.getSeconds(), dur.getNanos());
    }

    private Duration buildDuration(java.time.Duration dur) {
        return Duration.newBuilder().setSeconds(dur.getSeconds()).setNanos(dur.getNano()).build();
    }

    public Configuration apply(long generation, com.daml.ledger.configuration.LedgerTimeModel timeModel, java.time.Duration maxDeduplicationDuration) {
        return new Configuration(generation, timeModel, maxDeduplicationDuration);
    }

    public Option<Tuple3<Object, com.daml.ledger.configuration.LedgerTimeModel, java.time.Duration>> unapply(Configuration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)x$0.generation()), (Object)x$0.timeModel(), (Object)x$0.maxDeduplicationDuration()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Configuration$.class);
    }

    private Configuration$() {
    }
}

