/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava;

import com.daml.ledger.rxjava.ActiveContractsClient;
import com.daml.ledger.rxjava.CommandClient;
import com.daml.ledger.rxjava.CommandCompletionClient;
import com.daml.ledger.rxjava.CommandSubmissionClient;
import com.daml.ledger.rxjava.LedgerClient;
import com.daml.ledger.rxjava.LedgerConfigurationClient;
import com.daml.ledger.rxjava.LedgerIdentityClient;
import com.daml.ledger.rxjava.PackageClient;
import com.daml.ledger.rxjava.TimeClient;
import com.daml.ledger.rxjava.TransactionsClient;
import com.daml.ledger.rxjava.grpc.ActiveContractClientImpl;
import com.daml.ledger.rxjava.grpc.CommandClientImpl;
import com.daml.ledger.rxjava.grpc.CommandCompletionClientImpl;
import com.daml.ledger.rxjava.grpc.CommandSubmissionClientImpl;
import com.daml.ledger.rxjava.grpc.LedgerConfigurationClientImpl;
import com.daml.ledger.rxjava.grpc.LedgerIdentityClientImpl;
import com.daml.ledger.rxjava.grpc.PackageClientImpl;
import com.daml.ledger.rxjava.grpc.TimeClientImpl;
import com.daml.ledger.rxjava.grpc.TransactionClientImpl;
import com.digitalasset.grpc.adapter.ExecutionSequencerFactory;
import com.digitalasset.grpc.adapter.SingleThreadExecutionSequencerPool;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DamlLedgerClient
implements LedgerClient {
    private final SingleThreadExecutionSequencerPool pool;
    private ActiveContractsClient activeContractsClient;
    private TransactionsClient transactionsClient;
    private CommandCompletionClient commandCompletionClient;
    private CommandClient commandClient;
    private CommandSubmissionClient commandSubmissionClient;
    private LedgerIdentityClient ledgerIdentityClient;
    private PackageClient packageClient;
    private LedgerConfigurationClient ledgerConfigurationClient;
    private TimeClient timeClient;
    private String expectedLedgerId;
    private final ManagedChannel channel;

    public static DamlLedgerClient forLedgerIdAndHost(@NonNull String ledgerId, @NonNull String hostIp, int hostPort, @NonNull Optional<SslContext> sslContext) {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)hostIp, (int)hostPort);
        if (sslContext.isPresent()) {
            builder.useTransportSecurity();
            builder.sslContext(sslContext.get());
        } else {
            builder.usePlaintext();
        }
        return new DamlLedgerClient(Optional.of(ledgerId), builder.build());
    }

    public static DamlLedgerClient forHostWithLedgerIdDiscovery(@NonNull String hostIp, int hostPort, Optional<SslContext> sslContext) {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)hostIp, (int)hostPort);
        if (sslContext.isPresent()) {
            builder.useTransportSecurity();
            builder.sslContext(sslContext.get());
        } else {
            builder.usePlaintext();
        }
        return new DamlLedgerClient(Optional.empty(), builder.build());
    }

    public DamlLedgerClient(Optional<String> expectedLedgerId, @NonNull ManagedChannel channel) {
        this.channel = channel;
        this.expectedLedgerId = expectedLedgerId.orElse(null);
        this.pool = new SingleThreadExecutionSequencerPool("client");
    }

    public void connect() {
        this.ledgerIdentityClient = new LedgerIdentityClientImpl((Channel)this.channel);
        String reportedLedgerId = (String)this.ledgerIdentityClient.getLedgerIdentity().blockingGet();
        if (this.expectedLedgerId != null && !this.expectedLedgerId.equals(reportedLedgerId)) {
            throw new IllegalArgumentException(String.format("Configured ledger id [%s] is not the same as reported by the ledger [%s]", this.expectedLedgerId, reportedLedgerId));
        }
        this.expectedLedgerId = reportedLedgerId;
        this.activeContractsClient = new ActiveContractClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool);
        this.transactionsClient = new TransactionClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool);
        this.commandCompletionClient = new CommandCompletionClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool);
        this.commandSubmissionClient = new CommandSubmissionClientImpl(reportedLedgerId, (Channel)this.channel);
        this.commandClient = new CommandClientImpl(reportedLedgerId, (Channel)this.channel);
        this.packageClient = new PackageClientImpl(reportedLedgerId, (Channel)this.channel);
        this.ledgerConfigurationClient = new LedgerConfigurationClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool);
        this.timeClient = new TimeClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool);
    }

    @Override
    public String getLedgerId() {
        return this.expectedLedgerId;
    }

    @Override
    public ActiveContractsClient getActiveContractSetClient() {
        return this.activeContractsClient;
    }

    @Override
    public TransactionsClient getTransactionsClient() {
        return this.transactionsClient;
    }

    @Override
    public CommandClient getCommandClient() {
        return this.commandClient;
    }

    @Override
    public CommandCompletionClient getCommandCompletionClient() {
        return this.commandCompletionClient;
    }

    @Override
    public CommandSubmissionClient getCommandSubmissionClient() {
        return this.commandSubmissionClient;
    }

    @Override
    public LedgerIdentityClient getLedgerIdentityClient() {
        return this.ledgerIdentityClient;
    }

    @Override
    public PackageClient getPackageClient() {
        return this.packageClient;
    }

    @Override
    public LedgerConfigurationClient getLedgerConfigurationClient() {
        return this.ledgerConfigurationClient;
    }

    @Override
    public TimeClient getTimeClient() {
        return this.timeClient;
    }

    public void close() throws Exception {
        this.channel.shutdownNow();
        while (!this.channel.awaitTermination(1L, TimeUnit.SECONDS)) {
        }
        this.pool.close();
    }

    public static void main(String[] args) {
        DamlLedgerClient ledgerClient = DamlLedgerClient.forHostWithLedgerIdDiscovery("localhost", 6865, Optional.empty());
        ledgerClient.connect();
        String ledgerId = (String)ledgerClient.ledgerIdentityClient.getLedgerIdentity().blockingGet();
        System.out.println("expectedLedgerId = " + ledgerId);
        LinkedList packageIds = (LinkedList)ledgerClient.packageClient.listPackages().collect(LinkedList::new, LinkedList::addFirst).blockingGet();
        System.out.println("packageIds = " + packageIds);
        ledgerClient.ledgerConfigurationClient.getLedgerConfiguration().take(1L).blockingForEach(c -> System.out.println("ledger-configuration " + c));
    }
}

