/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.grpc;

import com.daml.ledger.javaapi.data.CompletionEndResponse;
import com.daml.ledger.javaapi.data.CompletionStreamRequest;
import com.daml.ledger.javaapi.data.CompletionStreamResponse;
import com.daml.ledger.javaapi.data.LedgerOffset;
import com.daml.ledger.rxjava.CommandCompletionClient;
import com.daml.ledger.rxjava.util.ClientPublisherFlowable;
import com.digitalasset.grpc.adapter.ExecutionSequencerFactory;
import com.digitalasset.ledger.api.v1.CommandCompletionServiceGrpc;
import com.digitalasset.ledger.api.v1.CommandCompletionServiceOuterClass;
import io.grpc.Channel;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.Set;
import java.util.concurrent.Future;

public class CommandCompletionClientImpl
implements CommandCompletionClient {
    private final String ledgerId;
    private final CommandCompletionServiceGrpc.CommandCompletionServiceStub serviceStub;
    private final CommandCompletionServiceGrpc.CommandCompletionServiceFutureStub serviceFutureStub;
    private final ExecutionSequencerFactory sequencerFactory;

    public CommandCompletionClientImpl(String ledgerId, Channel channel, ExecutionSequencerFactory sequencerFactory) {
        this.ledgerId = ledgerId;
        this.sequencerFactory = sequencerFactory;
        this.serviceStub = CommandCompletionServiceGrpc.newStub((Channel)channel);
        this.serviceFutureStub = CommandCompletionServiceGrpc.newFutureStub((Channel)channel);
    }

    private Flowable<CompletionStreamResponse> completionStream(CompletionStreamRequest request) {
        return ClientPublisherFlowable.create(request.toProto(), (arg_0, arg_1) -> ((CommandCompletionServiceGrpc.CommandCompletionServiceStub)this.serviceStub).completionStream(arg_0, arg_1), this.sequencerFactory).map(CompletionStreamResponse::fromProto);
    }

    @Override
    public Flowable<CompletionStreamResponse> completionStream(String applicationId, LedgerOffset offset, Set<String> parties) {
        return this.completionStream(new CompletionStreamRequest(this.ledgerId, applicationId, parties, offset));
    }

    @Override
    public Flowable<CompletionStreamResponse> completionStream(String applicationId, Set<String> parties) {
        return this.completionStream(new CompletionStreamRequest(this.ledgerId, applicationId, parties));
    }

    @Override
    public Single<CompletionEndResponse> completionEnd() {
        CommandCompletionServiceOuterClass.CompletionEndRequest request = CommandCompletionServiceOuterClass.CompletionEndRequest.newBuilder().setLedgerId(this.ledgerId).build();
        return Single.fromFuture((Future)this.serviceFutureStub.completionEnd(request)).map(CompletionEndResponse::fromProto);
    }
}

