/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.grpc;

import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.SubmitRequest;
import com.daml.ledger.rxjava.CommandSubmissionClient;
import com.digitalasset.ledger.api.v1.CommandSubmissionServiceGrpc;
import com.digitalasset.ledger.api.v1.CommandSubmissionServiceOuterClass;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.reactivex.Single;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CommandSubmissionClientImpl
implements CommandSubmissionClient {
    private final String ledgerId;
    private final CommandSubmissionServiceGrpc.CommandSubmissionServiceFutureStub serviceStub;

    public CommandSubmissionClientImpl(@NonNull String ledgerId, @NonNull Channel channel) {
        this.ledgerId = ledgerId;
        this.serviceStub = CommandSubmissionServiceGrpc.newFutureStub((Channel)channel);
    }

    @Override
    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Instant ledgerEffectiveTime, @NonNull Instant maximumRecordTime, @NonNull List<@NonNull Command> commands) {
        CommandSubmissionServiceOuterClass.SubmitRequest request = SubmitRequest.toProto((String)this.ledgerId, (String)workflowId, (String)applicationId, (String)commandId, (String)party, (Instant)ledgerEffectiveTime, (Instant)maximumRecordTime, commands);
        return Single.fromFuture((Future)this.serviceStub.submit(request));
    }
}

