/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.grpc;

import com.daml.ledger.javaapi.data.GetPackageResponse;
import com.daml.ledger.javaapi.data.GetPackageStatusResponse;
import com.daml.ledger.rxjava.PackageClient;
import com.digitalasset.ledger.api.v1.PackageServiceGrpc;
import com.digitalasset.ledger.api.v1.PackageServiceOuterClass;
import io.grpc.Channel;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.concurrent.Future;

public class PackageClientImpl
implements PackageClient {
    private final String ledgerId;
    private final PackageServiceGrpc.PackageServiceFutureStub serviceStub;

    public PackageClientImpl(String ledgerId, Channel channel) {
        this.ledgerId = ledgerId;
        this.serviceStub = PackageServiceGrpc.newFutureStub((Channel)channel);
    }

    @Override
    public Flowable<String> listPackages() {
        PackageServiceOuterClass.ListPackagesRequest request = PackageServiceOuterClass.ListPackagesRequest.newBuilder().setLedgerId(this.ledgerId).build();
        return Flowable.fromFuture((Future)this.serviceStub.listPackages(request)).concatMapIterable(PackageServiceOuterClass.ListPackagesResponse::getPackageIdsList);
    }

    @Override
    public Single<GetPackageResponse> getPackage(String packageId) {
        PackageServiceOuterClass.GetPackageRequest request = PackageServiceOuterClass.GetPackageRequest.newBuilder().setLedgerId(this.ledgerId).setPackageId(packageId).build();
        return Single.fromFuture((Future)this.serviceStub.getPackage(request)).map(GetPackageResponse::fromProto);
    }

    @Override
    public Single<GetPackageStatusResponse> getPackageStatus(String packageId) {
        PackageServiceOuterClass.GetPackageStatusRequest request = PackageServiceOuterClass.GetPackageStatusRequest.newBuilder().setLedgerId(this.ledgerId).setPackageId(packageId).build();
        return Single.fromFuture((Future)this.serviceStub.getPackageStatus(request)).map(GetPackageStatusResponse::fromProto);
    }
}

