/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.grpc;

import com.daml.ledger.javaapi.data.GetFlatTransactionResponse;
import com.daml.ledger.javaapi.data.GetLedgerEndResponse;
import com.daml.ledger.javaapi.data.GetTransactionResponse;
import com.daml.ledger.javaapi.data.GetTransactionTreesResponse;
import com.daml.ledger.javaapi.data.GetTransactionsRequest;
import com.daml.ledger.javaapi.data.GetTransactionsResponse;
import com.daml.ledger.javaapi.data.LedgerOffset;
import com.daml.ledger.javaapi.data.Transaction;
import com.daml.ledger.javaapi.data.TransactionFilter;
import com.daml.ledger.javaapi.data.TransactionTree;
import com.daml.ledger.rxjava.TransactionsClient;
import com.daml.ledger.rxjava.util.ClientPublisherFlowable;
import com.digitalasset.grpc.adapter.ExecutionSequencerFactory;
import com.digitalasset.ledger.api.v1.TransactionServiceGrpc;
import com.digitalasset.ledger.api.v1.TransactionServiceOuterClass;
import io.grpc.Channel;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.Set;
import java.util.concurrent.Future;

public class TransactionClientImpl
implements TransactionsClient {
    private final String ledgerId;
    private final TransactionServiceGrpc.TransactionServiceStub serviceStub;
    private final TransactionServiceGrpc.TransactionServiceFutureStub serviceFutureStub;
    private final ExecutionSequencerFactory sequencerFactory;

    public TransactionClientImpl(String ledgerId, Channel channel, ExecutionSequencerFactory sequencerFactory) {
        this.ledgerId = ledgerId;
        this.sequencerFactory = sequencerFactory;
        this.serviceStub = TransactionServiceGrpc.newStub((Channel)channel);
        this.serviceFutureStub = TransactionServiceGrpc.newFutureStub((Channel)channel);
    }

    @Override
    public Flowable<Transaction> getTransactions(LedgerOffset begin, LedgerOffset end, TransactionFilter filter, boolean verbose) {
        TransactionServiceOuterClass.GetTransactionsRequest request = new GetTransactionsRequest(this.ledgerId, begin, end, filter, verbose).toProto();
        return this.extractTransactions(request);
    }

    @Override
    public Flowable<Transaction> getTransactions(LedgerOffset begin, TransactionFilter filter, boolean verbose) {
        TransactionServiceOuterClass.GetTransactionsRequest request = new GetTransactionsRequest(this.ledgerId, begin, filter, verbose).toProto();
        return this.extractTransactions(request);
    }

    private Flowable<Transaction> extractTransactions(TransactionServiceOuterClass.GetTransactionsRequest request) {
        return ClientPublisherFlowable.create(request, (arg_0, arg_1) -> ((TransactionServiceGrpc.TransactionServiceStub)this.serviceStub).getTransactions(arg_0, arg_1), this.sequencerFactory).map(GetTransactionsResponse::fromProto).concatMapIterable(GetTransactionsResponse::getTransactions);
    }

    @Override
    public Flowable<TransactionTree> getTransactionsTrees(LedgerOffset begin, LedgerOffset end, TransactionFilter filter, boolean verbose) {
        TransactionServiceOuterClass.GetTransactionsRequest request = new GetTransactionsRequest(this.ledgerId, begin, end, filter, verbose).toProto();
        return this.extractTransactionTrees(request);
    }

    @Override
    public Flowable<TransactionTree> getTransactionsTrees(LedgerOffset begin, TransactionFilter filter, boolean verbose) {
        TransactionServiceOuterClass.GetTransactionsRequest request = new GetTransactionsRequest(this.ledgerId, begin, filter, verbose).toProto();
        return this.extractTransactionTrees(request);
    }

    private Flowable<TransactionTree> extractTransactionTrees(TransactionServiceOuterClass.GetTransactionsRequest request) {
        return ClientPublisherFlowable.create(request, (arg_0, arg_1) -> ((TransactionServiceGrpc.TransactionServiceStub)this.serviceStub).getTransactionTrees(arg_0, arg_1), this.sequencerFactory).map(GetTransactionTreesResponse::fromProto).concatMapIterable(GetTransactionTreesResponse::getTransactions);
    }

    @Override
    public Single<TransactionTree> getTransactionByEventId(String eventId, Set<String> requestingParties) {
        TransactionServiceOuterClass.GetTransactionByEventIdRequest request = TransactionServiceOuterClass.GetTransactionByEventIdRequest.newBuilder().setLedgerId(this.ledgerId).setEventId(eventId).addAllRequestingParties(requestingParties).build();
        return this.extractTransactionTree((Future<TransactionServiceOuterClass.GetTransactionResponse>)this.serviceFutureStub.getTransactionByEventId(request));
    }

    @Override
    public Single<TransactionTree> getTransactionById(String transactionId, Set<String> requestingParties) {
        TransactionServiceOuterClass.GetTransactionByIdRequest request = TransactionServiceOuterClass.GetTransactionByIdRequest.newBuilder().setLedgerId(this.ledgerId).setTransactionId(transactionId).addAllRequestingParties(requestingParties).build();
        return this.extractTransactionTree((Future<TransactionServiceOuterClass.GetTransactionResponse>)this.serviceFutureStub.getTransactionById(request));
    }

    private Single<TransactionTree> extractTransactionTree(Future<TransactionServiceOuterClass.GetTransactionResponse> future) {
        return Single.fromFuture(future).map(GetTransactionResponse::fromProto).map(GetTransactionResponse::getTransaction);
    }

    @Override
    public Single<Transaction> getFlatTransactionByEventId(String eventId, Set<String> requestingParties) {
        TransactionServiceOuterClass.GetTransactionByEventIdRequest request = TransactionServiceOuterClass.GetTransactionByEventIdRequest.newBuilder().setLedgerId(this.ledgerId).setEventId(eventId).addAllRequestingParties(requestingParties).build();
        return this.extractTransaction((Future<TransactionServiceOuterClass.GetFlatTransactionResponse>)this.serviceFutureStub.getFlatTransactionByEventId(request));
    }

    @Override
    public Single<Transaction> getFlatTransactionById(String transactionId, Set<String> requestingParties) {
        TransactionServiceOuterClass.GetTransactionByIdRequest request = TransactionServiceOuterClass.GetTransactionByIdRequest.newBuilder().setLedgerId(this.ledgerId).setTransactionId(transactionId).addAllRequestingParties(requestingParties).build();
        return this.extractTransaction((Future<TransactionServiceOuterClass.GetFlatTransactionResponse>)this.serviceFutureStub.getFlatTransactionById(request));
    }

    private Single<Transaction> extractTransaction(Future<TransactionServiceOuterClass.GetFlatTransactionResponse> future) {
        return Single.fromFuture(future).map(GetFlatTransactionResponse::fromProto).map(GetFlatTransactionResponse::getTransaction);
    }

    @Override
    public Single<LedgerOffset> getLedgerEnd() {
        TransactionServiceOuterClass.GetLedgerEndRequest request = TransactionServiceOuterClass.GetLedgerEndRequest.newBuilder().setLedgerId(this.ledgerId).build();
        return Single.fromFuture((Future)this.serviceFutureStub.getLedgerEnd(request)).map(GetLedgerEndResponse::fromProto).map(GetLedgerEndResponse::getOffset);
    }
}

