/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.annotation.InternalApi;
import akka.io.Dns;
import akka.io.PeriodicCacheCleanup;
import akka.io.SimpleDnsCache$;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Forever$;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0$mcJ$sp;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u001c9\u0001uBQ!\u0012\u0001\u0005\u0002\u0019Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\nC\u0004\u0003B\u0002\u0001\u000b\u0011\u0002&\t\u0013\t\r\u0007A1A\u0005\n\u0005}\u0001\u0002\u0003Bc\u0001\u0001\u0006I!!\t\t\u000f\t\u001d\u0007\u0001\"\u0011\u0003J\"9\u00111\b\u0001\u0005\u0012\tM\u0007\u0002\u0003B\u0011\u0001\u0011\u0015\u0001H!6\t\u000f\t-\u0003\u0001\"\u0012\u0003n\u001e)\u0001\f\u000fE\u00013\u001a)q\u0007\u000fE\u00015\")Qi\u0003C\u0001C\u001a)!m\u0003\u00019G\"AQ-\u0004B\u0001B\u0003%a\rC\u0005I\u001b\t\u0005\t\u0015!\u0003\u0002^!Q\u00111H\u0007\u0003\u0002\u0003\u0006IA!\u0002\t\r\u0015kA\u0011\u0001B\u0006\u0011\u001d\u0011)\"\u0004C\u0001\u0005/AqA!\t\u000e\t\u0003\u0011\u0019\u0003C\u0004\u0003L5!\tA!\u0014\u0007\r\u0005\u00154\u0002RA4\u0011)\t9(\u0006BK\u0002\u0013\u0005\u0011\u0011\u0010\u0005\u000b\u0003\u0003+\"\u0011#Q\u0001\n\u0005m\u0004BCA\u000f+\tU\r\u0011\"\u0001\u0002 !Q\u0011qE\u000b\u0003\u0012\u0003\u0006I!!\t\t\r\u0015+B\u0011AAB\u0011\u001d\ty#\u0006C\u0001\u0003\u0017C\u0011\"a$\u0016\u0003\u0003%\t!!%\t\u0013\u0005}U#%A\u0005\u0002\u0005\u0005\u0006\"CA]+E\u0005I\u0011AA^\u0011%\t\u0019-FA\u0001\n\u0003\n)\rC\u0005\u0002TV\t\t\u0011\"\u0001\u0002V\"I\u0011q[\u000b\u0002\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0003?,\u0012\u0011!C!\u0003CD\u0011\"a;\u0016\u0003\u0003%\t!!<\t\u0013\u0005EX#!A\u0005B\u0005M\b\"CA{+\u0005\u0005I\u0011IA|\u0011%\tI0FA\u0001\n\u0003\nYpB\u0005\u0003R-\t\t\u0011#\u0003\u0003T\u0019I\u0011QM\u0006\u0002\u0002#%!Q\u000b\u0005\u0007\u000b\"\"\tAa\u0016\t\u0013\u0005U\b&!A\u0005F\u0005]\b\"\u0003B-Q\u0005\u0005I\u0011\u0011B.\u0011%\u0011I\u0007KA\u0001\n\u0003\u0013Y\u0007C\u0005\u0003\u0002\"\n\t\u0011\"\u0003\u0003\u0004\u001a)\u0001o\u0003\u00019c\"Q\u0011q\u0003\u0018\u0003\u0006\u0004%\t!!\u0007\t\u0015\u0005maF!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\u001e9\u0012)\u0019!C\u0001\u0003?A!\"a\n/\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011\u0019)e\u0006\"\u0001\u0002*!9\u0011q\u0006\u0018\u0005\u0002\u0005E\u0002bBA\u001f]\u0011\u0005\u0013q\b\u0005\t\u0005\u0017[A\u0011\u0001\u001d\u0003\u000e\nq1+[7qY\u0016$en]\"bG\",'BA\u001d;\u0003\tIwNC\u0001<\u0003\u0011\t7n[1\u0004\u0001M\u0019\u0001A\u0010\"\u0011\u0005}\u0002U\"\u0001\u001d\n\u0005\u0005C$a\u0001#ogB\u0011qhQ\u0005\u0003\tb\u0012A\u0003U3sS>$\u0017nY\"bG\",7\t\\3b]V\u0004\u0018A\u0002\u001fj]&$h\bF\u0001H!\ty\u0004!A\u0003dC\u000eDW-F\u0001K!\rYEKV\u0007\u0002\u0019*\u0011QJT\u0001\u0007CR|W.[2\u000b\u0005=\u0003\u0016AC2p]\u000e,(O]3oi*\u0011\u0011KU\u0001\u0005kRLGNC\u0001T\u0003\u0011Q\u0017M^1\n\u0005Uc%aD!u_6L7MU3gKJ,gnY3\u0011\r]k!Q\u0015BZ\u001d\ty$\"\u0001\bTS6\u0004H.\u001a#og\u000e\u000b7\r[3\u0011\u0005}Z1CA\u0006\\!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\u0019\te.\u001f*fMR\t\u0011LA\u0003DC\u000eDW-F\u0003e\u00037\u0012\ta\u0005\u0002\u000e7\u0006)\u0011/^3vKB\u0019q\r\u001c8\u000e\u0003!T!!\u001b6\u0002\u0013%lW.\u001e;bE2,'BA6^\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003[\"\u0014\u0011bU8si\u0016$7+\u001a;\u0011\t=t\u0013\u0011L\u0007\u0002\u0017\tYQ\t\u001f9jef,e\u000e\u001e:z+\r\u0011\u0018QA\n\u0004]m\u001b\bc\u0001;}\u007f:\u0011QO\u001f\b\u0003mfl\u0011a\u001e\u0006\u0003qr\na\u0001\u0010:p_Rt\u0014\"\u00010\n\u0005ml\u0016a\u00029bG.\fw-Z\u0005\u0003{z\u0014qa\u0014:eKJ,GM\u0003\u0002|;B!qNLA\u0001!\u0011\t\u0019!!\u0002\r\u0001\u00119\u0011q\u0001\u0018C\u0002\u0005%!!A&\u0012\t\u0005-\u0011\u0011\u0003\t\u00049\u00065\u0011bAA\b;\n9aj\u001c;iS:<\u0007c\u0001/\u0002\u0014%\u0019\u0011QC/\u0003\u0007\u0005s\u00170\u0001\u0003oC6,WCAA\u0001\u0003\u0015q\u0017-\\3!\u0003\u0015)h\u000e^5m+\t\t\t\u0003E\u0002]\u0003GI1!!\n^\u0005\u0011auN\\4\u0002\rUtG/\u001b7!)\u0015y\u00181FA\u0017\u0011\u001d\t9b\ra\u0001\u0003\u0003Aq!!\b4\u0001\u0004\t\t#A\u0004jgZ\u000bG.\u001b3\u0015\t\u0005M\u0012\u0011\b\t\u00049\u0006U\u0012bAA\u001c;\n9!i\\8mK\u0006t\u0007bBA\u001ei\u0001\u0007\u0011\u0011E\u0001\u0006G2|7m[\u0001\bG>l\u0007/\u0019:f)\u0011\t\t%a\u0012\u0011\u0007q\u000b\u0019%C\u0002\u0002Fu\u00131!\u00138u\u0011\u0019\tI%\u000ea\u0001\u007f\u0006!A\u000f[1uQ\rq\u0013Q\n\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u0005E#aC%oi\u0016\u0014h.\u00197Ba&\u0004B!a\u0001\u0002\\\u00119\u0011qA\u0007C\u0002\u0005%\u0001cB4\u0002`\u0005e\u00131M\u0005\u0004\u0003CB'aA'baB!q.FA\u0000\u0005)\u0019\u0015m\u00195f\u000b:$(/_\u000b\u0005\u0003S\nih\u0005\u0004\u00167\u0006-\u0014\u0011\u000f\t\u00049\u00065\u0014bAA8;\n9\u0001K]8ek\u000e$\bc\u0001/\u0002t%\u0019\u0011QO/\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\r\u0005t7o^3s+\t\tY\b\u0005\u0003\u0002\u0004\u0005uDaBA@+\t\u0007\u0011\u0011\u0002\u0002\u0002)\u00069\u0011M\\:xKJ\u0004CCBAC\u0003\u000f\u000bI\t\u0005\u0003p+\u0005m\u0004bBA<5\u0001\u0007\u00111\u0010\u0005\b\u0003;Q\u0002\u0019AA\u0011)\u0011\t\u0019$!$\t\u000f\u0005m2\u00041\u0001\u0002\"\u0005!1m\u001c9z+\u0011\t\u0019*!'\u0015\r\u0005U\u00151TAO!\u0011yW#a&\u0011\t\u0005\r\u0011\u0011\u0014\u0003\b\u0003\u007fb\"\u0019AA\u0005\u0011%\t9\b\bI\u0001\u0002\u0004\t9\nC\u0005\u0002\u001eq\u0001\n\u00111\u0001\u0002\"\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT\u0003BAR\u0003o+\"!!*+\t\u0005m\u0014qU\u0016\u0003\u0003S\u0003B!a+\u000246\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,A\u0005v]\u000eDWmY6fI*\u0019\u00111K/\n\t\u0005U\u0016Q\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBA@;\t\u0007\u0011\u0011B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\ti,!1\u0016\u0005\u0005}&\u0006BA\u0011\u0003O#q!a \u001f\u0005\u0004\tI!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000f\u0004B!!3\u0002P6\u0011\u00111\u001a\u0006\u0004\u0003\u001b\u0014\u0016\u0001\u00027b]\u001eLA!!5\u0002L\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0011\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011CAn\u0011%\ti.IA\u0001\u0002\u0004\t\t%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003G\u0004b!!:\u0002h\u0006EQ\"\u00016\n\u0007\u0005%(N\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001a\u0003_D\u0011\"!8$\u0003\u0003\u0005\r!!\u0005\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a2\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019$!@\t\u0013\u0005ug%!AA\u0002\u0005E\u0001\u0003BA\u0002\u0005\u0003!qAa\u0001\u000e\u0005\u0004\tIAA\u0001W!\u0015a&qAA\u0011\u0013\r\u0011I!\u0018\u0002\n\rVt7\r^5p]B\"\u0002B!\u0004\u0003\u0010\tE!1\u0003\t\u0007_6\tI&a@\t\u000b\u0015\f\u0002\u0019\u00014\t\r!\u000b\u0002\u0019AA/\u0011\u001d\tY$\u0005a\u0001\u0005\u000b\t1aZ3u)\u0011\u0011IBa\b\u0011\u000bq\u0013Y\"a@\n\u0007\tuQL\u0001\u0004PaRLwN\u001c\u0005\b\u0003/\u0011\u0002\u0019AA-\u0003\r\u0001X\u000f\u001e\u000b\t\u0005\u001b\u0011)Ca\n\u0003*!9\u0011qC\nA\u0002\u0005e\u0003bBA<'\u0001\u0007\u0011q \u0005\b\u0005W\u0019\u0002\u0019\u0001B\u0017\u0003\r!H\u000f\u001c\t\u0005\u0005_\u0011)E\u0004\u0003\u00032\t}b\u0002\u0002B\u001a\u0005wqAA!\u000e\u0003:9\u0019aOa\u000e\n\u0003mJ!!\u000f\u001e\n\u0007\tu\u0002(A\u0002e]NLAA!\u0011\u0003D\u0005Y1)Y2iKB{G.[2z\u0015\r\u0011i\u0004O\u0005\u0005\u0005\u000f\u0012IEA\u0006DC\u000eDW\rU8mS\u000eL(\u0002\u0002B!\u0005\u0007\nqa\u00197fC:,\b\u000f\u0006\u0002\u0003\u000e!\u001aQ\"!\u0014\u0002\u0015\r\u000b7\r[3F]R\u0014\u0018\u0010\u0005\u0002pQM!\u0001fWA9)\t\u0011\u0019&A\u0003baBd\u00170\u0006\u0003\u0003^\t\rDC\u0002B0\u0005K\u00129\u0007\u0005\u0003p+\t\u0005\u0004\u0003BA\u0002\u0005G\"q!a ,\u0005\u0004\tI\u0001C\u0004\u0002x-\u0002\rA!\u0019\t\u000f\u0005u1\u00061\u0001\u0002\"\u00059QO\\1qa2LX\u0003\u0002B7\u0005s\"BAa\u001c\u0003|A)ALa\u0007\u0003rA9ALa\u001d\u0003x\u0005\u0005\u0012b\u0001B;;\n1A+\u001e9mKJ\u0002B!a\u0001\u0003z\u00119\u0011q\u0010\u0017C\u0002\u0005%\u0001\"\u0003B?Y\u0005\u0005\t\u0019\u0001B@\u0003\rAH\u0005\r\t\u0005_V\u00119(A\u0006sK\u0006$'+Z:pYZ,GC\u0001BC!\u0011\tIMa\"\n\t\t%\u00151\u001a\u0002\u0007\u001f\nTWm\u0019;\u0002'\u0015D\b/\u001b:z\u000b:$(/_(sI\u0016\u0014\u0018N\\4\u0016\t\t=%\u0011\u0015\u000b\u0003\u0005#\u0013bAa%\u0003\u0006\n]eA\u0002BKm\u0001\u0011\tJ\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0003u\u00053\u0013i*C\u0002\u0003\u001cz\u0014\u0001b\u0014:eKJLgn\u001a\t\u0005_:\u0012y\n\u0005\u0003\u0002\u0004\t\u0005FaBA\u0004m\t\u0007\u0011\u0011\u0002\u0015\u0004m\u00055\u0003\u0003\u0002BT\u0005_sAA!+\u0003,B\u0011a/X\u0005\u0004\u0005[k\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002R\nE&b\u0001BW;B!!Q\u0017B^\u001d\ry$qW\u0005\u0004\u0005sC\u0014a\u0001#og&!!Q\u0018B`\u0005!\u0011Vm]8mm\u0016$'b\u0001B]q\u000511-Y2iK\u0002\n\u0001B\\1o_\n\u000b7/Z\u0001\n]\u0006twNQ1tK\u0002\naaY1dQ\u0016$G\u0003\u0002Bf\u0005#\u0004R\u0001\u0018B\u000e\u0005\u001b\u0004BAa4\u0003<:!!1\u0007B\\\u0011\u001d\t9B\u0002a\u0001\u0005K#\"!!\t\u0015\r\t]'Q\u001cBq!\ra&\u0011\\\u0005\u0004\u00057l&\u0001B+oSRDqAa8\t\u0001\u0004\u0011i-A\u0001s\u0011\u001d\u0011Y\u0003\u0003a\u0001\u0005[A3\u0001\u0003Bs!\u0011\u00119O!;\u000e\u0005\u0005E\u0016\u0002\u0002Bv\u0003c\u0013q\u0001^1jYJ,7\r\u0006\u0002\u0003X\"\u001a\u0011B!:")
public class SimpleDnsCache
extends Dns
implements PeriodicCacheCleanup {
    private final AtomicReference<Cache<String, Dns.Resolved>> cache = new AtomicReference(new Cache((SortedSet)SortedSet$.MODULE$.apply(Nil$.MODULE$, SimpleDnsCache$.MODULE$.expiryEntryOrdering()), (Map)Predef$.MODULE$.Map().apply(Nil$.MODULE$), (JFunction0$mcJ$sp & scala.Serializable)() -> this.clock()));
    private final long nanoBase = System.nanoTime();

    private AtomicReference<Cache<String, Dns.Resolved>> cache() {
        return this.cache;
    }

    private long nanoBase() {
        return this.nanoBase;
    }

    @Override
    public Option<Dns.Resolved> cached(String name) {
        return this.cache().get().get(name);
    }

    public long clock() {
        long now = System.nanoTime();
        return now - this.nanoBase() < 0L ? 0L : (now - this.nanoBase()) / 1000000L;
    }

    public final void put(Dns.Resolved r, CachePolicy.CachePolicy ttl) {
        Cache<String, Dns.Resolved> c;
        do {
            c = this.cache().get();
        } while (!this.cache().compareAndSet(c, c.put(r.name(), r, ttl)));
    }

    @Override
    public final void cleanup() {
        Cache<String, Dns.Resolved> c;
        do {
            c = this.cache().get();
        } while (!this.cache().compareAndSet(c, c.cleanup()));
    }

    @InternalApi
    public static class Cache<K, V> {
        private final SortedSet<ExpiryEntry<K>> queue;
        private final Map<K, CacheEntry<V>> cache;
        private final Function0<Object> clock;

        public Option<V> get(K name) {
            return this.cache.get(name).withFilter((Function1<CacheEntry, Object> & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean(e.isValid(this.clock.apply$mcJ$sp()))).map((Function1<CacheEntry, Object> & Serializable & scala.Serializable)e -> e.answer());
        }

        public Cache<K, V> put(K name, V answer, CachePolicy.CachePolicy ttl) {
            CachePolicy.Ttl ttl2;
            Option<FiniteDuration> option2;
            long l;
            CachePolicy.CachePolicy cachePolicy = ttl;
            if (CachePolicy$Forever$.MODULE$.equals(cachePolicy)) {
                l = Long.MAX_VALUE;
            } else if (CachePolicy$Never$.MODULE$.equals(cachePolicy)) {
                l = this.clock.apply$mcJ$sp() - 1L;
            } else if (cachePolicy instanceof CachePolicy.Ttl && !(option2 = CachePolicy$Ttl$.MODULE$.unapply(ttl2 = (CachePolicy.Ttl)cachePolicy)).isEmpty()) {
                FiniteDuration ttl3 = option2.get();
                l = this.clock.apply$mcJ$sp() + ttl3.toMillis();
            } else {
                throw new MatchError(cachePolicy);
            }
            long until = l;
            return new Cache<K, V>((SortedSet)this.queue.$plus(new ExpiryEntry<K>(name, until)), this.cache.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), new CacheEntry<V>(answer, until))), this.clock);
        }

        public Cache<K, V> cleanup() {
            long now = this.clock.apply$mcJ$sp();
            SortedSet q = this.queue;
            Map c = this.cache;
            while (q.nonEmpty() && !((ExpiryEntry)q.head()).isValid(now)) {
                ExpiryEntry minEntry = (ExpiryEntry)q.head();
                Object name = minEntry.name();
                q = (SortedSet)q.$minus(minEntry);
                if (!c.get(name).filterNot((Function1<CacheEntry, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isValid(now))).isDefined()) continue;
                c = (Map)c.$minus(name);
            }
            return new Cache<K, V>(q, c, this.clock);
        }

        public Cache(SortedSet<ExpiryEntry<K>> queue, Map<K, CacheEntry<V>> cache, Function0<Object> clock) {
            this.queue = queue;
            this.cache = cache;
            this.clock = clock;
        }
    }

    public static class CacheEntry<T>
    implements Product,
    scala.Serializable {
        private final T answer;
        private final long until;

        public T answer() {
            return this.answer;
        }

        public long until() {
            return this.until;
        }

        public boolean isValid(long clock) {
            return clock < this.until();
        }

        public <T> CacheEntry<T> copy(T answer, long until) {
            return new CacheEntry<T>(answer, until);
        }

        public <T> T copy$default$1() {
            return this.answer();
        }

        public <T> long copy$default$2() {
            return this.until();
        }

        @Override
        public String productPrefix() {
            return "CacheEntry";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.answer();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong(this.until());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
            }
            return object;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheEntry;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, Statics.anyHash(this.answer()));
            n = Statics.mix(n, Statics.longHash(this.until()));
            return Statics.finalizeHash(n, 2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheEntry cacheEntry = (CacheEntry)x$1;
            if (!BoxesRunTime.equals(this.answer(), cacheEntry.answer())) return false;
            if (this.until() != cacheEntry.until()) return false;
            if (!cacheEntry.canEqual(this)) return false;
            return true;
        }

        public CacheEntry(T answer, long until) {
            this.answer = answer;
            this.until = until;
            Product.$init$(this);
        }
    }

    @InternalApi
    public static class ExpiryEntry<K>
    implements Ordered<ExpiryEntry<K>> {
        private final K name;
        private final long until;

        @Override
        public boolean $less(Object that) {
            return Ordered.$less$(this, that);
        }

        @Override
        public boolean $greater(Object that) {
            return Ordered.$greater$(this, that);
        }

        @Override
        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$(this, that);
        }

        @Override
        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$(this, that);
        }

        @Override
        public int compareTo(Object that) {
            return Ordered.compareTo$(this, that);
        }

        public K name() {
            return this.name;
        }

        public long until() {
            return this.until;
        }

        public boolean isValid(long clock) {
            return clock < this.until();
        }

        @Override
        public int compare(ExpiryEntry<K> that) {
            return -Predef$.MODULE$.long2Long(this.until()).compareTo(Predef$.MODULE$.long2Long(that.until()));
        }

        public ExpiryEntry(K name, long until) {
            this.name = name;
            this.until = until;
            Ordered.$init$(this);
        }
    }
}

