/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsCache;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.DnsClient;
import akka.io.dns.internal.package$CachePolicyIsOrdered$;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.Timeout;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\r\ra!B\u001d;\u0005y\u0012\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011a\u0003!\u0011!Q\u0001\neC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\u0006y\u0002!\t! \u0005\n\u0003\u000b\u0001!\u0019!C\u0002\u0003\u000fA\u0001\"!\u0006\u0001A\u0003%\u0011\u0011\u0002\u0005\n\u0003/\u0001!\u0019!C\u0002\u00033A\u0001\"a\n\u0001A\u0003%\u00111\u0004\u0005\n\u0003S\u0001!\u0019!C\u0001\u0003WAq!!\f\u0001A\u0003%A\rC\u0005\u00020\u0001\u0011\r\u0011\"\u0001\u00022!A\u0011Q\n\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002P\u0001\u0011\r\u0011\"\u0001\u00022!A\u0011\u0011\u000b\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002T\u0001\u0001\r\u0011\"\u0003\u0002V!I\u0011Q\f\u0001A\u0002\u0013%\u0011q\f\u0005\t\u0003W\u0002\u0001\u0015)\u0003\u0002X!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004\"CA9\u0001\t\u0007I\u0011BA:\u0011\u001d\t)\b\u0001Q\u0001\naDq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002\u0004\u0002!I!!\"\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u00111\u001d\u0001\u0005\n\u0005\u0015\bbBAw\u0001\u0011%\u0011q\u001e\u0005\b\u0003w\u0004A\u0011BA\u007f\u000f!\u0011\u0019B\u000fE\u0001}\tUaaB\u001d;\u0011\u0003q$q\u0003\u0005\u0007yr!\tA!\u0007\t\u0013\tmAD1A\u0005\n\tu\u0001\u0002\u0003B\u00179\u0001\u0006IAa\b\t\u0013\t=BD1A\u0005\n\tu\u0001\u0002\u0003B\u00199\u0001\u0006IAa\b\t\u000f\tMB\u0004\"\u0003\u00036!I!q\b\u000fC\u0002\u0013%!\u0011\t\u0005\t\u0005\u0007b\u0002\u0015!\u0003\u0002B\u001a1!Q\t\u000fA\u0005\u000fB!Ba\u0017&\u0005+\u0007I\u0011\u0001B/\u0011)\u0011y&\nB\tB\u0003%\u0011q\u0014\u0005\u0007y\u0016\"\tA!\u0019\t\u0013\t%T%!A\u0005\u0002\t-\u0004\"\u0003B8KE\u0005I\u0011\u0001B9\u0011%\u0011))JA\u0001\n\u0003\u00129\tC\u0005\u0003\u0014\u0016\n\t\u0011\"\u0001\u0003\u0016\"I!QT\u0013\u0002\u0002\u0013\u0005!q\u0014\u0005\n\u0005S+\u0013\u0011!C!\u0005WC\u0011B!/&\u0003\u0003%\tAa/\t\u0013\t}V%!A\u0005B\t\u0005\u0007\"\u0003BbK\u0005\u0005I\u0011\tBc\u000f%\u0011I\rHA\u0001\u0012\u0003\u0011YMB\u0005\u0003Fq\t\t\u0011#\u0001\u0003N\"1Ap\rC\u0001\u00057D\u0011B!84\u0003\u0003%)Ea8\t\u0013\t\u00058'!A\u0005\u0002\n\r\b\"\u0003Btg\u0005\u0005I\u0011\u0011Bu\u0011%\u0011)pMA\u0001\n\u0013\u00119P\u0001\tBgft7\r\u00128t%\u0016\u001cx\u000e\u001c<fe*\u00111\bP\u0001\tS:$XM\u001d8bY*\u0011QHP\u0001\u0004I:\u001c(BA A\u0003\tIwNC\u0001B\u0003\u0011\t7n[1\u0014\t\u0001\u0019\u0015j\u0014\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)kU\"A&\u000b\u00051\u0003\u0015!B1di>\u0014\u0018B\u0001(L\u0005\u0015\t5\r^8s!\tQ\u0005+\u0003\u0002R\u0017\na\u0011i\u0019;pe2{wmZ5oO\u0006A1/\u001a;uS:<7o\u0001\u0001\u0011\u0005U3V\"\u0001\u001f\n\u0005]c$a\u0003#ogN+G\u000f^5oON\fQaY1dQ\u0016\u0004\"AW.\u000e\u0003iJ!\u0001\u0018\u001e\u0003\u001b\u0005\u001b\u0018P\\2E]N\u001c\u0015m\u00195f\u00035\u0019G.[3oi\u001a\u000b7\r^8ssB)AiX1eq&\u0011\u0001-\u0012\u0002\n\rVt7\r^5p]J\u0002\"A\u00132\n\u0005\r\\%aD!di>\u0014(+\u001a4GC\u000e$xN]=\u0011\u0007\u0015l\u0007O\u0004\u0002gW:\u0011qM[\u0007\u0002Q*\u0011\u0011nU\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019K!\u0001\\#\u0002\u000fA\f7m[1hK&\u0011an\u001c\u0002\u0005\u0019&\u001cHO\u0003\u0002m\u000bB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0004]\u0016$(\"A;\u0002\t)\fg/Y\u0005\u0003oJ\u0014\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t!\r)W.\u001f\t\u0003\u0015jL!a_&\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\fa\u0001P5oSRtDC\u0002@\u0000\u0003\u0003\t\u0019\u0001\u0005\u0002[\u0001!)!\u000b\u0002a\u0001)\")\u0001\f\u0002a\u00013\")Q\f\u0002a\u0001=\u0006\u0011QmY\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f)\u0015AC2p]\u000e,(O]3oi&!\u00111CA\u0007\u0005a)\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]\u0001\u0004K\u000e\u0004\u0013a\u0002;j[\u0016|W\u000f^\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0001\u0015\u0001B;uS2LA!!\n\u0002 \t9A+[7f_V$\u0018\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\u0002\u00179\fW.Z*feZ,'o]\u000b\u0002I\u0006aa.Y7f'\u0016\u0014h/\u001a:tA\u0005\u0019\u0002o\\:ji&4XmQ1dQ\u0016\u0004v\u000e\\5dsV\u0011\u00111\u0007\t\u0005\u0003k\t9E\u0004\u0003\u00028\u0005\rc\u0002BA\u001d\u0003\u0003rA!a\u000f\u0002@9\u0019q-!\u0010\n\u0003\u0005K!a\u0010!\n\u0005ur\u0014bAA#y\u0005Y1)Y2iKB{G.[2z\u0013\u0011\tI%a\u0013\u0003\u0017\r\u000b7\r[3Q_2L7-\u001f\u0006\u0004\u0003\u000bb\u0014\u0001\u00069pg&$\u0018N^3DC\u000eDW\rU8mS\u000eL\b%A\noK\u001e\fG/\u001b<f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u00170\u0001\u000boK\u001e\fG/\u001b<f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u0017\u0010I\u0001\ne\u0016\fX/Z:u\u0013\u0012,\"!a\u0016\u0011\u0007\u0011\u000bI&C\u0002\u0002\\\u0015\u0013Qa\u00155peR\fQB]3rk\u0016\u001cH/\u00133`I\u0015\fH\u0003BA1\u0003O\u00022\u0001RA2\u0013\r\t)'\u0012\u0002\u0005+:LG\u000fC\u0005\u0002jA\t\t\u00111\u0001\u0002X\u0005\u0019\u0001\u0010J\u0019\u0002\u0015I,\u0017/^3ti&#\u0007%\u0001\u0004oKb$\u0018\n\u001a\u000b\u0003\u0003/\n\u0011B]3t_24XM]:\u0016\u0003a\f!B]3t_24XM]:!\u0003\u001d\u0011XmY3jm\u0016,\"!a\u001f\u0011\t\u0005u\u0014qP\u0007\u0002\u0001%\u0019\u0011\u0011Q'\u0003\u000fI+7-Z5wK\u0006!\"/Z:pYZ,w+\u001b;i%\u0016\u001cx\u000e\u001c<feN$\u0002\"a\"\u0002\u001c\u0006=\u00161\u0018\t\u0007\u0003\u0017\tI)!$\n\t\u0005-\u0015Q\u0002\u0002\u0007\rV$XO]3\u0011\t\u0005=\u0015Q\u0013\b\u0004+\u0006E\u0015bAAJy\u0005YAI\\:Qe>$xnY8m\u0013\u0011\t9*!'\u0003\u0011I+7o\u001c7wK\u0012T1!a%=\u0011\u001d\tiJ\u0006a\u0001\u0003?\u000bAA\\1nKB!\u0011\u0011UAU\u001d\u0011\t\u0019+!*\u0011\u0005\u001d,\u0015bAAT\u000b\u00061\u0001K]3eK\u001aLA!a+\u0002.\n11\u000b\u001e:j]\u001eT1!a*F\u0011\u001d\t\tL\u0006a\u0001\u0003g\u000b1B]3rk\u0016\u001cH\u000fV=qKB!\u0011QWA\\\u001d\u0011\t9$!%\n\t\u0005e\u0016\u0011\u0014\u0002\f%\u0016\fX/Z:u)f\u0004X\r\u0003\u0004\u0002rY\u0001\r\u0001_\u0001\rg\u0016tG-U;fgRLwN\u001c\u000b\u0007\u0003\u0003\f).!7\u0011\r\u0005-\u0011\u0011RAb!\u0011\t)-a4\u000f\t\u0005\u001d\u00171\u001a\b\u0005\u0003o\tI-\u0003\u0002<y%\u0019\u0011Q\u001a\u001e\u0002\u0013\u0011s7o\u00117jK:$\u0018\u0002BAi\u0003'\u0014a!\u00118to\u0016\u0014(bAAgu!1\u0011q[\fA\u0002e\f\u0001B]3t_24XM\u001d\u0005\b\u00037<\u0002\u0019AAo\u0003\u001diWm]:bO\u0016\u0004B!!2\u0002`&!\u0011\u0011]Aj\u0005-!en])vKN$\u0018n\u001c8\u0002#I,7o\u001c7wK^KG\u000f[*fCJ\u001c\u0007\u000e\u0006\u0005\u0002\b\u0006\u001d\u0018\u0011^Av\u0011\u001d\ti\n\u0007a\u0001\u0003?Cq!!-\u0019\u0001\u0004\t\u0019\f\u0003\u0004\u0002Xb\u0001\r!_\u0001\re\u0016\u001cx\u000e\u001c<f\r&\u00148\u000f\u001e\u000b\t\u0003\u000f\u000b\t0a>\u0002z\"9\u00111_\rA\u0002\u0005U\u0018aC:fCJ\u001c\u0007NT1nKN\u0004B!Z7\u0002 \"9\u0011\u0011W\rA\u0002\u0005M\u0006BBAl3\u0001\u0007\u00110A\u0004sKN|GN^3\u0015\u0011\u0005\u001d\u0015q B\u0001\u0005\u0007Aq!!(\u001b\u0001\u0004\ty\nC\u0004\u00022j\u0001\r!a-\t\r\u0005]'\u00041\u0001zQ\r\u0001!q\u0001\t\u0005\u0005\u0013\u0011y!\u0004\u0002\u0003\f)\u0019!Q\u0002!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0012\t-!aC%oi\u0016\u0014h.\u00197Ba&\f\u0001#Q:z]\u000e$en\u001d*fg>dg/\u001a:\u0011\u0005ic2C\u0001\u000fD)\t\u0011)\"A\u0006jaZ$\u0014\t\u001a3sKN\u001cXC\u0001B\u0010!\u0011\u0011\tC!\u000b\u000e\u0005\t\r\"\u0002\u0002B\u0013\u0005O\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0003C)\u0015\u0002\u0002B\u0016\u0005G\u0011QAU3hKb\fA\"\u001b9wi\u0005#GM]3tg\u0002\n1\"\u001b9wm\u0005#GM]3tg\u0006a\u0011\u000e\u001d<7\u0003\u0012$'/Z:tA\u0005i\u0011n]%oKR\fE\r\u001a:fgN$BAa\u000e\u0003>A\u0019AI!\u000f\n\u0007\tmRIA\u0004C_>dW-\u00198\t\u000f\u0005u%\u00051\u0001\u0002 \u0006)Q)\u001c9usV\u0011\u0011\u0011Y\u0001\u0007\u000b6\u0004H/\u001f\u0011\u0003-I+7o\u001c7wK\u001a\u000b\u0017\u000e\\3e\u000bb\u001cW\r\u001d;j_:\u001cr!\nB%\u0005\u001f\u0012)\u0006E\u0002f\u0005\u0017J1A!\u0014p\u0005%)\u0005pY3qi&|g\u000eE\u0002E\u0005#J1Aa\u0015F\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001\u0012B,\u0013\r\u0011I&\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004[N<WCAAP\u0003\u0011i7o\u001a\u0011\u0015\t\t\r$q\r\t\u0004\u0005K*S\"\u0001\u000f\t\u000f\tm\u0003\u00061\u0001\u0002 \u0006!1m\u001c9z)\u0011\u0011\u0019G!\u001c\t\u0013\tm\u0013\u0006%AA\u0002\u0005}\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005gRC!a(\u0003v-\u0012!q\u000f\t\u0005\u0005s\u0012\t)\u0004\u0002\u0003|)!!Q\u0010B@\u0003%)hn\u00195fG.,GMC\u0002\u0003\u000e\u0015KAAa!\u0003|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\t\u0005\u0003\u0003\f\nEUB\u0001BG\u0015\r\u0011y\t^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002,\n5\u0015\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001BL!\r!%\u0011T\u0005\u0004\u00057+%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BQ\u0005O\u00032\u0001\u0012BR\u0013\r\u0011)+\u0012\u0002\u0004\u0003:L\b\"CA5[\u0005\u0005\t\u0019\u0001BL\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BW!\u0019\u0011yK!.\u0003\"6\u0011!\u0011\u0017\u0006\u0004\u0005g+\u0015AC2pY2,7\r^5p]&!!q\u0017BY\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t]\"Q\u0018\u0005\n\u0003Sz\u0013\u0011!a\u0001\u0005C\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005/\u000ba!Z9vC2\u001cH\u0003\u0002B\u001c\u0005\u000fD\u0011\"!\u001b2\u0003\u0003\u0005\rA!)\u0002-I+7o\u001c7wK\u001a\u000b\u0017\u000e\\3e\u000bb\u001cW\r\u001d;j_:\u00042A!\u001a4'\u0015\u0019$q\u001aB+!!\u0011\tNa6\u0002 \n\rTB\u0001Bj\u0015\r\u0011).R\u0001\beVtG/[7f\u0013\u0011\u0011INa5\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0003L\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\n\u0006)\u0011\r\u001d9msR!!1\rBs\u0011\u001d\u0011YF\u000ea\u0001\u0003?\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003l\nE\b#\u0002#\u0003n\u0006}\u0015b\u0001Bx\u000b\n1q\n\u001d;j_:D\u0011Ba=8\u0003\u0003\u0005\rAa\u0019\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B}!\u0011\u0011YIa?\n\t\tu(Q\u0012\u0002\u0007\u001f\nTWm\u0019;)\u0007q\u00119\u0001K\u0002\u001c\u0005\u000f\u0001")
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final DnsSettings settings;
    public final AsyncDnsCache akka$io$dns$internal$AsyncDnsResolver$$cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)A1;
                    String name = resolve.name();
                    Option<DnsProtocol.Resolved> option2 = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.get(new Tuple2<String, DnsProtocol.RequestType>(name, mode = resolve.requestType()));
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        DnsProtocol.Resolved resolved2 = (DnsProtocol.Resolved)some.value();
                        this.$outer.log().debug("{} cached {}", mode, resolved2);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(resolved2, this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option2)) {
                        akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()).map((Function1<DnsProtocol.Resolved, DnsProtocol.Resolved> & Serializable & scala.Serializable)resolved -> {
                            if (resolved.records().nonEmpty()) {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.positiveCachePolicy();
                                CachePolicy.CachePolicy minTtl = (CachePolicy.CachePolicy)((TraversableOnce)((SeqLike)resolved.records().map((Function1<ResourceRecord, CachePolicy.Ttl> & Serializable & scala.Serializable)x$1 -> x$1.ttl(), Seq$.MODULE$.canBuildFrom())).$plus$colon(cachePolicy, Seq$.MODULE$.canBuildFrom())).min(package$CachePolicyIsOrdered$.MODULE$);
                                $this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put(new Tuple2<String, DnsProtocol.RequestType>(name, mode), (DnsProtocol.Resolved)resolved, minTtl);
                            } else {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.negativeCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    $this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put(new Tuple2<String, DnsProtocol.RequestType>(name, mode), (DnsProtocol.Resolved)resolved, $this.$outer.negativeCachePolicy());
                                }
                            }
                            $this.$outer.log().debug("{} resolved {}", mode, resolved);
                            return resolved;
                        }, this.$outer.ec()), this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option2);
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.io.dns.internal.AsyncDnsResolver$$anonfun$receive$1 java.lang.String akka.io.dns.DnsProtocol$RequestType akka.io.dns.DnsProtocol$Resolved ), $anonfun$applyOrElse$2(akka.io.dns.ResourceRecord )}, serializedLambda);
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        Future<DnsProtocol.Resolved> future;
        if (AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) {
            future = Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0<DnsProtocol.Resolved> & Serializable & scala.Serializable)() -> {
                ARecord record2;
                ResourceRecord resourceRecord;
                InetAddress address = InetAddress.getByName(name);
                InetAddress inetAddress = address;
                if (inetAddress instanceof Inet4Address) {
                    resourceRecord = new ARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                } else if (inetAddress instanceof Inet6Address) {
                    Inet6Address inet6Address = (Inet6Address)inetAddress;
                    resourceRecord = new AAAARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                } else {
                    throw new MatchError(inetAddress);
                }
                ARecord aRecord = record2 = resourceRecord;
                return DnsProtocol$Resolved$.MODULE$.apply(name, Nil$.MODULE$.$colon$colon(aRecord));
            }));
        } else {
            Future<Object> future2;
            List<ActorRef> list2 = resolvers;
            if (((Object)Nil$.MODULE$).equals(list2)) {
                future2 = Future$.MODULE$.failed(new ResolveFailedException(new StringBuilder(37).append("Failed to resolve ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
            } else if (list2 instanceof $colon$colon) {
                $colon$colon $colon$colon = ($colon$colon)list2;
                ActorRef head = (ActorRef)$colon$colon.head();
                List tail = $colon$colon.tl$access$1();
                future2 = this.resolveWithSearch(name, requestType, head).recoverWith(new scala.Serializable(this, name, requestType, tail){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AsyncDnsResolver $outer;
                    private final String name$2;
                    private final DnsProtocol.RequestType requestType$1;
                    private final List tail$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        Option<Throwable> option2 = NonFatal$.MODULE$.unapply(A1);
                        if (!option2.isEmpty()) {
                            Throwable t = option2.get();
                            this.$outer.log().error(t, "Resolve failed. Trying next name server");
                            object = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$2, this.requestType$1, this.tail$1);
                        } else {
                            object = function1.apply(x1);
                        }
                        return object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable2 = x1;
                        Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable2);
                        boolean bl = !option2.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.name$2 = name$2;
                        this.requestType$1 = requestType$1;
                        this.tail$1 = tail$1;
                    }
                }, this.ec());
            } else {
                throw new MatchError(list2);
            }
            future = future2;
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result2 = AskableActorRef$.MODULE$.$qmark$extension1(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result2.failed().foreach((Function1<Throwable, Object> & Serializable & scala.Serializable)x$4 -> {
            AsyncDnsResolver.$anonfun$sendQuestion$1(this, resolver, message, x$4);
            return BoxedUnit.UNIT;
        }, this.ec());
        return var3_3;
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future<DnsProtocol.Resolved> future;
        if (this.settings.SearchDomains().nonEmpty()) {
            List<String> list2;
            List<?> nameWithSearch = this.settings.SearchDomains().map((Function1<String, String> & Serializable & scala.Serializable)sd -> new StringBuilder(1).append(name).append(".").append((String)sd).toString(), List$.MODULE$.canBuildFrom());
            if (new StringOps(Predef$.MODULE$.augmentString(name)).count((Function1<Object, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(AsyncDnsResolver.$anonfun$resolveWithSearch$2(BoxesRunTime.unboxToChar(x$5)))) >= this.settings.NDots()) {
                String string2 = name;
                list2 = nameWithSearch.$colon$colon(string2);
            } else {
                list2 = nameWithSearch.$colon$plus(name, List$.MODULE$.canBuildFrom());
            }
            List<String> toResolve = list2;
            future = this.resolveFirst(toResolve, requestType, resolver);
        } else {
            future = this.resolve(name, requestType, resolver);
        }
        return future;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Future<DnsProtocol.Resolved> resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        void var4_12;
        boolean bl = false;
        $colon$colon $colon$colon = null;
        List<String> list2 = searchNames;
        if (list2 instanceof $colon$colon) {
            bl = true;
            $colon$colon = ($colon$colon)list2;
            String searchName = (String)$colon$colon.head();
            List list3 = $colon$colon.tl$access$1();
            if (((Object)Nil$.MODULE$).equals(list3)) {
                Future<DnsProtocol.Resolved> future = this.resolve(searchName, requestType, resolver);
                return var4_12;
            }
        }
        if (bl) {
            String searchName = (String)$colon$colon.head();
            List remaining = $colon$colon.tl$access$1();
            Future future = this.resolve(searchName, requestType, resolver).flatMap((Function1<DnsProtocol.Resolved, Future> & Serializable & scala.Serializable)resolved -> resolved.records().isEmpty() ? this.resolveFirst(remaining, requestType, resolver) : Future$.MODULE$.successful(resolved), this.ec());
            return var4_12;
        }
        if (!((Object)Nil$.MODULE$).equals(list2)) throw new MatchError(list2);
        Future future = Future$.MODULE$.failed(new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
        return var4_12;
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future<DnsProtocol.Resolved> future;
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
            boolean ipv42 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            Future<DnsClient.Answer> ipv4Recs = ipv42 ? this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            future = ipv4Recs.flatMap((Function1<DnsClient.Answer, Future> & Serializable & scala.Serializable)ipv4 -> ipv6Recs.map((Function1<DnsClient.Answer, DnsProtocol.Resolved> & Serializable & scala.Serializable)ipv6 -> new DnsProtocol.Resolved(name, ipv4.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom()), ipv4.additionalRecs().$plus$plus(ipv6.additionalRecs(), Seq$.MODULE$.canBuildFrom())), this.ec()), this.ec());
        } else if (DnsProtocol$Srv$.MODULE$.equals(requestType2)) {
            future = this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map((Function1<DnsClient.Answer, DnsProtocol.Resolved> & Serializable & scala.Serializable)answer -> new DnsProtocol.Resolved(name, answer.rrs(), answer.additionalRecs()), this.ec());
        } else {
            throw new MatchError(requestType2);
        }
        return future;
    }

    public static final /* synthetic */ void $anonfun$sendQuestion$1(AsyncDnsResolver $this, ActorRef resolver$1, DnsClient.DnsQuestion message$1, Throwable x$4) {
        package$.MODULE$.actorRef2Scala(resolver$1).$bang(new DnsClient.DropRequest(message$1.id()), $this.self());
    }

    public static final /* synthetic */ boolean $anonfun$resolveWithSearch$2(char x$5) {
        return x$5 == '.';
    }

    public AsyncDnsResolver(DnsSettings settings, AsyncDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this.settings = settings;
        this.akka$io$dns$internal$AsyncDnsResolver$$cache = cache;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.positiveCachePolicy = settings.PositiveCachePolicy();
        this.negativeCachePolicy = settings.NegativeCachePolicy();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings.SearchDomains(), BoxesRunTime.boxToInteger(settings.NDots()));
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = clientFactory.apply(this.context(), this.nameServers());
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    scala.Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        @Override
        public String productPrefix() {
            return "ResolveFailedException";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
            }
            return this.msg();
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string2 = this.msg();
            String string3 = resolveFailedException.msg();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.$init$(this);
        }
    }
}

