/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.SerializationSetup;
import akka.serialization.Serializer;
import akka.serialization.SerializerDetails;
import akka.serialization.SerializerDetails$;
import akka.serialization.SerializerWithStringManifest;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0011-u!B-[\u0011\u0003yf!B1[\u0011\u0003\u0011\u0007\"B5\u0002\t\u0003QW\u0001B6\u0002\u00011D!\"a\u0005\u0002\u0005\u0004%\t\u0001XA\u000b\u0011!\t\t.\u0001Q\u0001\n\u0005]aABAp\u0003\u0001\t\t\u000f\u0003\u0006\u0002d\u001a\u0011)\u0019!C\u0001\u0003KD!\"!?\u0007\u0005\u0003\u0005\u000b\u0011BAt\u0011\u0019Ig\u0001\"\u0001\u0002|\"I!\u0011\u0001\u0004C\u0002\u0013\u0005!1\u0001\u0005\t\u0005\u001f1\u0001\u0015!\u0003\u0003\u0006!I!\u0011\u0003\u0004C\u0002\u0013\u0005!1\u0001\u0005\t\u0005'1\u0001\u0015!\u0003\u0003\u0006!9!Q\u0003\u0004\u0005\u000e\t]\u0001b\u0002B\u000f\u0003\u0011\u0005!q\u0004\u0004\u0007\u0003O\t!)!\u000b\t\u0015\u0005]\u0002C!f\u0001\n\u0003\tI\u0004\u0003\u0006\u0002HA\u0011\t\u0012)A\u0005\u0003wA!\"!\u0013\u0011\u0005+\u0007I\u0011AA&\u0011)\t\u0019\u0006\u0005B\tB\u0003%\u0011Q\n\u0005\u0007SB!\t!!\u0016\t\u0013\u0005m\u0003#!A\u0005\u0002\u0005u\u0003\"CA2!E\u0005I\u0011AA3\u0011%\tY\bEI\u0001\n\u0003\ti\bC\u0005\u0002\u0002B\t\t\u0011\"\u0011\u0002\u0004\"I\u0011Q\u0013\t\u0002\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003?\u0003\u0012\u0011!C\u0001\u0003CC\u0011\"a*\u0011\u0003\u0003%\t%!+\t\u0013\u0005]\u0006#!A\u0005\u0002\u0005e\u0006\"CAb!\u0005\u0005I\u0011IAc\u0011%\t9\rEA\u0001\n\u0003\nI\rC\u0005\u0002LB\t\t\u0011\"\u0011\u0002N\u001eI!1F\u0001\u0002\u0002#\u0005!Q\u0006\u0004\n\u0003O\t\u0011\u0011!E\u0001\u0005_Aa!\u001b\u0012\u0005\u0002\tu\u0002\"CAdE\u0005\u0005IQIAe\u0011%\u0011yDIA\u0001\n\u0003\u0013\t\u0005C\u0005\u0003H\t\n\t\u0011\"!\u0003J!I!q\u000b\u0012\u0002\u0002\u0013%!\u0011\f\u0005\b\u0005C\nA\u0011\u0001B2\u0011\u001d\u0011\t)\u0001C\u0001\u0005\u00073Q!\u0019.\u0001\u0005\u000bC!\"!\u0013+\u0005\u000b\u0007I\u0011\u0001BG\u0011)\t\u0019F\u000bB\u0001B\u0003%!1\u0010\u0005\u0007S*\"\tAa$\t\u0013\tU%F1A\u0005\u0002\t]\u0005\u0002\u0003BOU\u0001\u0006IA!'\t\u0013\t}%F1A\u0005\u0002\t\u0005\u0006\u0002\u0003BRU\u0001\u0006I!a/\t\u0011\t\u0015&\u0006)A\u0005\u0005OC\u0011Ba-+\u0005\u0004%\tA!.\t\u0011\tu&\u0006)A\u0005\u0005oC\u0011Ba0+\u0005\u0004%IA!1\t\u0011\t5(\u0006)A\u0005\u0005\u0007D\u0001Ba<+\t\u0003a&\u0011\u001f\u0005\b\u0005CRC\u0011\u0002B|\u0011\u001d\u0019\u0019A\u000bC\u0001\u0007\u000bAqa!\b+\t\u0003\u0019y\u0002C\u0004\u0004\u001e)\"\taa\u0015\t\u000f\r}#\u0006\"\u0003\u0004b!911\u000e\u0016\u0005\u0002\r5\u0004bBB\u000fU\u0011\u00051\u0011\u0014\u0005\b\u0007SSC\u0011ABV\u0011\u001d\u0019yK\u000bC\u0001\u0007cCqa!1+\t\u0003\u0019\u0019\rC\u0005\u0004L*\u0012\r\u0011\"\u0003\u0004N\"A11\u001c\u0016!\u0002\u0013\u0019y\rC\u0005\u0004^*\u0012\r\u0011\"\u0003\u0004`\"A11\u001d\u0016!\u0002\u0013\u0019\t\u000f\u0003\u0006\u0004f*\u0012\r\u0011\"\u0001]\u0007OD\u0001b!<+A\u0003%1\u0011\u001e\u0005\b\u0007_TC\u0011BBy\u0011\u001d!iA\u000bC\u0005\t\u001fAq\u0001\"\t+\t\u0013!\u0019\u0003C\u0004\u0005*)\"I\u0001b\u000b\t\u0013\u0011]\"F1A\u0005\n\u0011e\u0002\u0002\u0003C'U\u0001\u0006I\u0001b\u000f\t\u0013\u0011=#F1A\u0005\u0002\u0011E\u0003\u0002\u0003C+U\u0001\u0006I\u0001b\u0015\t\u0013\u0011]#F1A\u0005\n\u0011e\u0003\u0002\u0003C/U\u0001\u0006I\u0001b\u0017\t\u000f\u0011}#\u0006\"\u0003\u0005b!IAq\r\u0016C\u0002\u0013%!\u0011\u0015\u0005\t\tSR\u0003\u0015!\u0003\u0002<\"IA1\u000e\u0016C\u0002\u0013%!\u0011\u0015\u0005\t\t[R\u0003\u0015!\u0003\u0002<\"9Aq\u000e\u0016\u0005\n\u0011E\u0004\u0002\u0003C;U\u0011\u0005A\fb\u001e\u0002\u001bM+'/[1mSj\fG/[8o\u0015\tYF,A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0002;\u0006!\u0011m[6b\u0007\u0001\u0001\"\u0001Y\u0001\u000e\u0003i\u0013QbU3sS\u0006d\u0017N_1uS>t7CA\u0001d!\t!w-D\u0001f\u0015\u00051\u0017!B:dC2\f\u0017B\u00015f\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0018\u0002\u0010\u00072\f7o]*fe&\fG.\u001b>feB)A-\\8\u0002\u000e%\u0011a.\u001a\u0002\u0007)V\u0004H.\u001a\u001a1\u0005Al\bcA9yw:\u0011!O\u001e\t\u0003g\u0016l\u0011\u0001\u001e\u0006\u0003kz\u000ba\u0001\u0010:p_Rt\u0014BA<f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0006\u00072\f7o\u001d\u0006\u0003o\u0016\u0004\"\u0001`?\r\u0001\u0011IapAA\u0001\u0002\u0003\u0015\ta \u0002\u0004?\u0012\n\u0014\u0003BA\u0001\u0003\u000f\u00012\u0001ZA\u0002\u0013\r\t)!\u001a\u0002\b\u001d>$\b.\u001b8h!\r!\u0017\u0011B\u0005\u0004\u0003\u0017)'aA!osB\u0019\u0001-a\u0004\n\u0007\u0005E!L\u0001\u0006TKJL\u0017\r\\5{KJ\f1dY;se\u0016tG\u000f\u0016:b]N\u0004xN\u001d;J]\u001a|'/\\1uS>tWCAA\f!\u0019\tI\"a\b\u0002$5\u0011\u00111\u0004\u0006\u0004\u0003;)\u0017\u0001B;uS2LA!!\t\u0002\u001c\tyA)\u001f8b[&\u001cg+\u0019:jC\ndW\rE\u0002\u0002&Ai\u0011!\u0001\u0002\f\u0013:4wN]7bi&|gn\u0005\u0004\u0011G\u0006-\u0012\u0011\u0007\t\u0004I\u00065\u0012bAA\u0018K\n9\u0001K]8ek\u000e$\bc\u00013\u00024%\u0019\u0011QG3\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000f\u0005$GM]3tgV\u0011\u00111\b\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t/\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005\u0015\u0013q\b\u0002\b\u0003\u0012$'/Z:t\u0003!\tG\r\u001a:fgN\u0004\u0013AB:zgR,W.\u0006\u0002\u0002NA!\u0011QHA(\u0013\u0011\t\t&a\u0010\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!)\u0019\t\u0019#a\u0016\u0002Z!9\u0011qG\u000bA\u0002\u0005m\u0002bBA%+\u0001\u0007\u0011QJ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002$\u0005}\u0013\u0011\r\u0005\n\u0003o1\u0002\u0013!a\u0001\u0003wA\u0011\"!\u0013\u0017!\u0003\u0005\r!!\u0014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\r\u0016\u0005\u0003w\tIg\u000b\u0002\u0002lA!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014!C;oG\",7m[3e\u0015\r\t)(Z\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA=\u0003_\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a +\t\u00055\u0013\u0011N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0005\u0003BAD\u0003#k!!!#\u000b\t\u0005-\u0015QR\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0010\u0006!!.\u0019<b\u0013\u0011\t\u0019*!#\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\nE\u0002e\u00037K1!!(f\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9!a)\t\u0013\u0005\u00156$!AA\u0002\u0005e\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002,B1\u0011QVAZ\u0003\u000fi!!a,\u000b\u0007\u0005EV-\u0001\u0006d_2dWm\u0019;j_:LA!!.\u00020\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY,!1\u0011\u0007\u0011\fi,C\u0002\u0002@\u0016\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002&v\t\t\u00111\u0001\u0002\b\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u001a\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0006\u00061Q-];bYN$B!a/\u0002P\"I\u0011Q\u0015\u0011\u0002\u0002\u0003\u0007\u0011qA\u0001\u001dGV\u0014(/\u001a8u)J\fgn\u001d9peRLeNZ8s[\u0006$\u0018n\u001c8!Q\r)\u0011Q\u001b\t\u0005\u0003/\fY.\u0004\u0002\u0002Z*\u0019\u0011Q\u000f/\n\t\u0005u\u0017\u0011\u001c\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018N\u0001\u0005TKR$\u0018N\\4t'\t11-\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003O\u0004B!!;\u0002v6\u0011\u00111\u001e\u0006\u0005\u0003G\fiO\u0003\u0003\u0002p\u0006E\u0018\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005M\u0018aA2p[&!\u0011q_Av\u0005\u0019\u0019uN\u001c4jO\u000691m\u001c8gS\u001e\u0004C\u0003BA\u007f\u0003\u007f\u00042!!\n\u0007\u0011\u001d\t\u0019/\u0003a\u0001\u0003O\f1bU3sS\u0006d\u0017N_3sgV\u0011!Q\u0001\t\bc\n\u001d!1\u0002B\u0006\u0013\r\u0011IA\u001f\u0002\u0004\u001b\u0006\u0004\bcA9\u0003\u000e%\u0019\u00111\u0013>\u0002\u0019M+'/[1mSj,'o\u001d\u0011\u0002+M+'/[1mSj\fG/[8o\u0005&tG-\u001b8hg\u000612+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c\b%A\u0006d_:4\u0017n\u001a+p\u001b\u0006\u0004H\u0003\u0002B\u0003\u00053AqAa\u0007\u000f\u0001\u0004\t9/A\u0002dM\u001e\f1c]3sS\u0006d\u0017N_3e\u0003\u000e$xN\u001d)bi\"$BAa\u0003\u0003\"!9!1E\bA\u0002\t\u0015\u0012\u0001C1di>\u0014(+\u001a4\u0011\t\u0005u\"qE\u0005\u0005\u0005S\tyD\u0001\u0005BGR|'OU3g\u0003-IeNZ8s[\u0006$\u0018n\u001c8\u0011\u0007\u0005\u0015\"eE\u0003#\u0005c\t\t\u0004\u0005\u0006\u00034\te\u00121HA'\u0003Gi!A!\u000e\u000b\u0007\t]R-A\u0004sk:$\u0018.\\3\n\t\tm\"Q\u0007\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001B\u0017\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t\u0019Ca\u0011\u0003F!9\u0011qG\u0013A\u0002\u0005m\u0002bBA%K\u0001\u0007\u0011QJ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YEa\u0015\u0011\u000b\u0011\u0014iE!\u0015\n\u0007\t=SM\u0001\u0004PaRLwN\u001c\t\u0007I6\fY$!\u0014\t\u0013\tUc%!AA\u0002\u0005\r\u0012a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u0006\u0005\u0003\u0002\b\nu\u0013\u0002\u0002B0\u0003\u0013\u0013aa\u00142kK\u000e$\u0018\u0001G<ji\"$&/\u00198ta>\u0014H/\u00138g_Jl\u0017\r^5p]V!!Q\rB6)\u0011\u00119G!\u001f\u0015\t\t%$q\u000e\t\u0004y\n-DA\u0002B7Q\t\u0007qPA\u0001U\u0011\u001d\u0011\t\b\u000ba\u0001\u0005g\n\u0011A\u001a\t\u0006I\nU$\u0011N\u0005\u0004\u0005o*'!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\tI\u0005\u000ba\u0001\u0005w\u0002B!!\u0010\u0003~%!!qPA \u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003y9W\r^\"veJ,g\u000e\u001e+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g\u000e\u0006\u0002\u0002$M!!f\u0019BD!\u0011\tiD!#\n\t\t-\u0015q\b\u0002\n\u000bb$XM\\:j_:,\"Aa\u001f\u0015\t\tE%1\u0013\t\u0003A*Bq!!\u0013.\u0001\u0004\u0011Y(\u0001\u0005tKR$\u0018N\\4t+\t\u0011I\nE\u0002\u0003\u001c\u001aq!\u0001\u0019\u0001\u0002\u0013M,G\u000f^5oON\u0004\u0013AF!mY><(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0016\u0005\u0005m\u0016aF!mY><(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8!\u0003\u0011yFn\\4\u0011\t\t%&qV\u0007\u0003\u0005WS1A!,]\u0003\u0015)g/\u001a8u\u0013\u0011\u0011\tLa+\u0003)5\u000b'o[3s\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\rawnZ\u000b\u0003\u0005o\u0003BA!+\u0003:&!!1\u0018BV\u00059aunZ4j]\u001e\fE-\u00199uKJ\fA\u0001\\8hA\u0005iQ.\u00198jM\u0016\u001cHoQ1dQ\u0016,\"Aa1\u0011\r\t\u0015'\u0011\u001bBk\u001b\t\u00119M\u0003\u0003\u0003J\n-\u0017AB1u_6L7M\u0003\u0003\u0003N\n=\u0017AC2p]\u000e,(O]3oi*!\u0011QDAG\u0013\u0011\u0011\u0019Na2\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\u0002Ba6\u0003^\n-!q\\\u0007\u0003\u00053TAAa7\u00020\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0005\u0013\u0011I\u000eE\u0003e\u0005\u001b\u0012\t\u000f\r\u0003\u0003d\n%\bCBAD\u0005K\u00149/C\u0002z\u0003\u0013\u00032\u0001 Bu\t)\u0011YONA\u0001\u0002\u0003\u0015\ta \u0002\u0004?\u0012\u0012\u0014AD7b]&4Wm\u001d;DC\u000eDW\rI\u0001\u0019g\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8J]\u001a|'/\\1uS>tWC\u0001Bz!\r\u0011Y\n\u0005\u0015\u0004o\u0005UW\u0003\u0002B}\u0005{$BAa?\u0003\u0000B\u0019AP!@\u0005\r\t5\u0004H1\u0001\u0000\u0011\u001d\u0011\t\b\u000fa\u0001\u0007\u0003\u0001R\u0001\u001aB;\u0005w\f\u0011b]3sS\u0006d\u0017N_3\u0015\t\r\u001d1\u0011\u0004\t\u0007\u00033\u0019Ia!\u0004\n\t\r-\u00111\u0004\u0002\u0004)JL\b#\u00023\u0004\u0010\rM\u0011bAB\tK\n)\u0011I\u001d:bsB\u0019Am!\u0006\n\u0007\r]QM\u0001\u0003CsR,\u0007BBB\u000es\u0001\u00071-A\u0001p\u0003-!Wm]3sS\u0006d\u0017N_3\u0016\t\r\u00052q\u0005\u000b\t\u0007G\u0019Ic!\f\u00042A1\u0011\u0011DB\u0005\u0007K\u00012\u0001`B\u0014\t\u0019\u0011iG\u000fb\u0001\u007f\"911\u0006\u001eA\u0002\r5\u0011!\u00022zi\u0016\u001c\bbBB\u0018u\u0001\u0007\u0011\u0011T\u0001\rg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\n\u001a\u0005\b\u0007gQ\u0004\u0019AB\u001b\u0003\u0015\u0019G.\u0019>{!\u0015!'QJB\u001ca\u0011\u0019Id!\u0010\u0011\tED81\b\t\u0004y\u000euB\u0001DB \u0007\u0003\n\t\u0011!A\u0003\u0002\rE#aA0%i!911\u0007\u001eA\u0002\r\r\u0003#\u00023\u0003N\r\u0015\u0003\u0007BB$\u0007\u0017\u0002B!\u001d=\u0004JA\u0019Apa\u0013\u0005\u0019\r}2\u0011IA\u0001\u0002\u0003\u0015\ta!\u0014\u0012\t\u0005\u00051q\n\t\u0004y\u000e\u001d\u0012\u0003BA\u0001\u0007K!\u0002b!\u0016\u0004X\re31\f\t\u0006\u00033\u0019Ia\u0019\u0005\b\u0007WY\u0004\u0019AB\u0007\u0011\u001d\u0019yc\u000fa\u0001\u00033Cqa!\u0018<\u0001\u0004\u0011Y!\u0001\u0005nC:Lg-Z:u\u0003Q!Wm]3sS\u0006d\u0017N_3CsR,\u0017I\u001d:bsR91ma\u0019\u0004f\r%\u0004bBB\u0016y\u0001\u00071Q\u0002\u0005\b\u0007Ob\u0004\u0019AA\u0007\u0003)\u0019XM]5bY&TXM\u001d\u0005\b\u0007;b\u0004\u0019\u0001B\u0006\u0003U!Wm]3sS\u0006d\u0017N_3CsR,')\u001e4gKJ$raYB8\u0007\u007f\u001a\t\tC\u0004\u0004ru\u0002\raa\u001d\u0002\u0007\t,h\r\u0005\u0003\u0004v\rmTBAB<\u0015\u0011\u0019I(!$\u0002\u00079Lw.\u0003\u0003\u0004~\r]$A\u0003\"zi\u0016\u0014UO\u001a4fe\"91qF\u001fA\u0002\u0005e\u0005bBB/{\u0001\u0007!1\u0002\u0015\u0006{\r\u00155q\u0013\t\u0006I\u000e\u001d51R\u0005\u0004\u0007\u0013+'A\u0002;ie><8\u000f\u0005\u0003\u0004\u000e\u000eMUBABH\u0015\u0011\u0019\t*!$\u0002\u0005%|\u0017\u0002BBK\u0007\u001f\u0013\u0001DT8u'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z#yG\u0016\u0004H/[8oG\t\u0019Y)\u0006\u0003\u0004\u001c\u000e\u0005FCBBO\u0007G\u001b)\u000b\u0005\u0004\u0002\u001a\r%1q\u0014\t\u0004y\u000e\u0005FA\u0002B7}\t\u0007q\u0010C\u0004\u0004,y\u0002\ra!\u0004\t\u000f\rMb\b1\u0001\u0004(B!\u0011\u000f_BP\u0003E1\u0017N\u001c3TKJL\u0017\r\\5{KJ4uN\u001d\u000b\u0005\u0003\u001b\u0019i\u000b\u0003\u0004\u0004\u001c}\u0002\raY\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014hi\u001c:\u0015\t\u0005511\u0017\u0005\b\u0007g\u0001\u0005\u0019AB[a\u0011\u00199la/\u0011\tED8\u0011\u0018\t\u0004y\u000emFaCB_\u0007g\u000b\t\u0011!A\u0003\u0002}\u00141a\u0018\u00139Q\u0015\u00015QQBL\u00031\u0019XM]5bY&TXM](g)\u0011\u0019)ma2\u0011\r\u0005e1\u0011BA\u0007\u0011\u001d\u0019I-\u0011a\u0001\u0005\u0017\tQb]3sS\u0006d\u0017N_3s\rFs\u0015!E:fe&\fG.\u001b>fe\u0012+G/Y5mgV\u00111q\u001a\t\u0007\u0005/\u001c\tn!6\n\t\rM'\u0011\u001c\u0002\u0004'\u0016\f\bc\u00011\u0004X&\u00191\u0011\u001c.\u0003#M+'/[1mSj,'\u000fR3uC&d7/\u0001\ntKJL\u0017\r\\5{KJ$U\r^1jYN\u0004\u0013aC:fe&\fG.\u001b>feN,\"a!9\u0011\u000fE\u00149Aa\u0003\u0002\u000e\u0005a1/\u001a:jC2L'0\u001a:tA\u0005A!-\u001b8eS:<7/\u0006\u0002\u0004jB1!q[Bi\u0007W\u00042Aa'\u0004\u0003%\u0011\u0017N\u001c3j]\u001e\u001c\b%\u0001\u000ff]N,(/Z(oYf\fE\u000e\\8xK\u0012\u001cVM]5bY&TXM]:\u0015\t\rM8\u0011 \t\u0004I\u000eU\u0018bAB|K\n!QK\\5u\u0011\u001d\u0019Y\u0010\u0013a\u0001\u0007{\fA!\u001b;feB11q C\u0005\u0003\u001bqA\u0001\"\u0001\u0005\u00069\u00191\u000fb\u0001\n\u0003\u0019L1\u0001b\u0002f\u0003\u001d\u0001\u0018mY6bO\u0016LA!!.\u0005\f)\u0019AqA3\u0002?]\f'O\\+oKb\u0004Xm\u0019;fI:{g.Q6lCN+'/[1mSj,'\u000f\u0006\u0004\u0002<\u0012EAQ\u0004\u0005\b\u0007gI\u0005\u0019\u0001C\na\u0011!)\u0002\"\u0007\u0011\tEDHq\u0003\t\u0004y\u0012eAa\u0003C\u000e\t#\t\t\u0011!A\u0003\u0002}\u0014Aa\u0018\u00132a!9AqD%A\u0002\u00055\u0011aA:fe\u0006\u00192\r[3dW\u001e{wn\u001a7f!J|Go\u001c2vMR!\u00111\u0018C\u0013\u0011\u001d!9C\u0013a\u0001\u0005\u0017\t\u0011b\u00197bgNt\u0015-\\3\u0002\tM|'\u000f\u001e\u000b\u0005\u0007S$i\u0003C\u0004\u00050-\u0003\r\u0001\"\r\u0002\u0005%t\u0007CBB\u0000\tg\u0019Y/\u0003\u0003\u00056\u0011-!\u0001C%uKJ\f'\r\\3\u0002\u001bM,'/[1mSj,'/T1q+\t!Y\u0004\u0005\u0005\u0005>\u0011}B1IA\u0007\u001b\t\u0011Y-\u0003\u0003\u0005B\t-'!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\"AQ\tC%!\u0011\t\b\u0010b\u0012\u0011\u0007q$I\u0005\u0002\u0006\u0005L5\u000b\t\u0011!A\u0003\u0002}\u0014Aa\u0018\u00132c\u0005q1/\u001a:jC2L'0\u001a:NCB\u0004\u0013\u0001F:fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u00180\u0006\u0002\u0005TA9\u0011Oa\u0002\u0002\u001a\u00065\u0011!F:fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u0018\u0010I\u0001\u001acVL7m[*fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u00180\u0006\u0002\u0005\\A)Ama\u0004\u0002\u000e\u0005Q\u0012/^5dWN+'/[1mSj,'OQ=JI\u0016tG/\u001b;zA\u0005\tr-\u001a;TKJL\u0017\r\\5{KJ\u0014\u00150\u00133\u0015\t\u00055A1\r\u0005\b\tK\u0012\u0006\u0019AAM\u0003\tIG-A\u0011jg*\u000bg/Y*fe&\fG.\u001b>bi&|gnV1s]&tw-\u00128bE2,G-\u0001\u0012jg*\u000bg/Y*fe&\fG.\u001b>bi&|gnV1s]&tw-\u00128bE2,G\rI\u0001!SN<\u0016M\u001d8j]\u001e|eNT8WKJLg-[2bi&|g.\u00128bE2,G-A\u0011jg^\u000b'O\\5oO>sgj\u001c,fe&4\u0017nY1uS>tWI\\1cY\u0016$\u0007%\u0001\u000ejg\u0012K7/\u00197m_^,GMS1wCN+'/[1mSj,'\u000f\u0006\u0003\u0002<\u0012M\u0004bBB4/\u0002\u0007\u0011QB\u0001\u001eg\"|W\u000f\u001c3XCJt\u0017IY8vi*\u000bg/Y*fe&\fG.\u001b>feR1\u00111\u0018C=\t\u000fCq\u0001b\u001fY\u0001\u0004!i(A\btKJL\u0017\r\\5{K\u0012\u001cE.Y:ta\u0011!y\bb!\u0011\tEDH\u0011\u0011\t\u0004y\u0012\rEa\u0003CC\ts\n\t\u0011!A\u0003\u0002}\u0014Aa\u0018\u00132g!91q\r-A\u0002\u00055\u0001f\u0001-\u0002V\u0002")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef2) {
        return Serialization$.MODULE$.serializedActorPath(actorRef2);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        T t;
        Information oldInfo = Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq(this.serializationInformation());
            }
            t = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq(oldInfo);
        }
        return t;
    }

    public Try<byte[]> serialize(Object o) {
        return (Try)this.withTransportInformation((Function0<Try> & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0<byte[]> & Serializable & scala.Serializable)() -> this.findSerializerFor(o).toBinary(o)));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(154).append("Cannot find serializer with id [").append(serializerId).append("]").append(clazz.map((Function1<Class, String> & Serializable & scala.Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).append(". ").append("The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.withTransportInformation((Function0<Object> & Serializable & scala.Serializable)() -> serializer2.fromBinary(bytes, clazz));
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(168).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        return this.withTransportInformation((Function0<Object> & Serializable & scala.Serializable)() -> {
            Object object;
            Serializer serializer = serializer;
            if (serializer instanceof SerializerWithStringManifest) {
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
                object = serializerWithStringManifest.fromBinary(bytes, manifest);
            } else {
                Object object2;
                String string2 = manifest;
                String string3 = "";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    object2 = serializer.fromBinary(bytes, None$.MODULE$);
                } else {
                    Object object3;
                    Map<String, Option<Class<?>>> cache = this.manifestCache().get();
                    Option option2 = cache.get(manifest);
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        Option cachedClassManifest = (Option)some.value();
                        object3 = serializer.fromBinary(bytes, cachedClassManifest);
                    } else if (None$.MODULE$.equals(option2)) {
                        Try<Class<Object>> try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                        if (!(try_ instanceof Success)) {
                            if (try_ instanceof Failure) {
                                throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                            }
                            throw new MatchError(try_);
                        }
                        Success success = (Success)try_;
                        Class classManifest = (Class)success.value();
                        Some classManifestOption = new Some(classManifest);
                        this.updateCache$1(cache, manifest, classManifestOption);
                        Object object4 = serializer.fromBinary(bytes, classManifestOption);
                        object3 = object4;
                    } else {
                        throw new MatchError(option2);
                    }
                    object2 = object3;
                }
                object = object2;
            }
            return object;
        });
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = Serialization$.MODULE$.currentTransportInformation().value();
        try {
            Object object2;
            Serializer serializer3;
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq(this.serializationInformation());
            }
            if ((serializer3 = serializer2) instanceof ByteBufferSerializer) {
                Serializer serializer4 = serializer3;
                object2 = ((ByteBufferSerializer)((Object)serializer4)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object2 = this.deserializeByteArray(bytes, serializer2, manifest);
            }
            object = object2;
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq(oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return (Try)this.withTransportInformation((Function0<Try> & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0<Object> & Serializable & scala.Serializable)() -> this.serializerFor(clazz).fromBinary(bytes, new Some(clazz))));
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            Serializer serializer5;
            Seq seq = (Seq)this.bindings().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializerFor$3(clazz, x0$1)));
            Some<Seq> some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            if (Serialization.unique$1(seq)) {
                serializer5 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                Seq possibilitiesWithoutJavaSerializer = (Seq)seq.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializerFor$4(x0$2)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((TraversableOnce)possibilitiesWithoutJavaSerializer.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Serializer s2 = (Serializer)tuple2._2();
                        String string2 = s2.getClass().getName();
                        return string2;
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", "));
                }
                serializer5 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer4 = serializer5;
            Serializer serializer6 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer6 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the default Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonAkkaSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                serializer3 = ser;
            } else {
                serializer3 = serializer6;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    /*
     * Unable to fully structure code
     */
    public Try<Serializer> serializerOf(String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var3_2 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, new $colon$colon<Nothing$>((Nothing$)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), this.system()), Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith(new scala.Serializable(this, fqn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final String fqn$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Try try_ = A1 instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)) : new Failure<T>(A1);
                return (B1)try_;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable2 = x1;
                boolean bl = throwable2 instanceof NoSuchMethodException ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
            }
        });
    }

    private Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        block0: {
            if (this.system().settings().AllowJavaSerialization()) break block0;
            Predef$.MODULE$.require(iter.forall((Function1<Serializer, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$ensureOnlyAllowedSerializers$1(this, x$6))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Disallowed JavaSerializer binding.");
        }
    }

    private boolean warnUnexpectedNonAkkaSerializer(Class<?> clazz, Serializer ser) {
        boolean bl;
        if (clazz.getName().startsWith("akka.") && !ser.getClass().getName().startsWith("akka.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Akka. It's not recommended to replace serializers for messages provided by Akka.", ser.getClass().getName(), clazz.getName());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean checkGoogleProtobuf(String className) {
        return !className.startsWith("com.google.protobuf") || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return ((TraversableLike)in.foldLeft(new ArrayBuffer(in.size()), (Function2<ArrayBuffer, Tuple2, ArrayBuffer> & Serializable & scala.Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    buf.append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
                default: {
                    buf.insert(n, Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
            }
            return buf;
        })).to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF(Seq$.MODULE$));
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id2) {
        Serializer serializer;
        if (0 <= id2 && id2 < this.quickSerializerByIdentity().length) {
            Serializer serializer2;
            Serializer serializer3 = this.quickSerializerByIdentity()[id2];
            if (serializer3 == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id2).toString());
            }
            serializer = serializer2 = serializer3;
        } else {
            serializer = (Serializer)this.serializerByIdentity().apply(BoxesRunTime.boxToInteger(id2));
        }
        return serializer;
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean akka$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("akka.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, cache.updated(key, value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(false))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals(x$2._2(), ((Tuple2)possibilities$1.apply(false))._2());
    }

    private static final boolean unique$1(Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Class c = (Class)tuple2._1();
        boolean bl = c.isAssignableFrom(clazz$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        boolean bl = tuple2 != null && tuple2._2() instanceof JavaSerializer ? false : tuple2 == null || !(tuple2._2() instanceof DisabledJavaSerializer);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 == null) return false;
        String className = (String)tuple2._1();
        String alias = (String)tuple2._2();
        if (className == null) return false;
        if (alias == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        String string2;
        String string3;
        String alias;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                String className = (String)tuple2._1();
                alias = (String)tuple2._2();
                if (className == null) break block2;
                string3 = className;
                if (alias != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        String string4 = string2 = alias;
        String string5 = "none";
        boolean bl = (string4 == null ? string5 != null : !string4.equals(string5)) && $this.checkGoogleProtobuf(string3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$7(Serialization $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Class clazz = (Class)tuple2._1();
        Serializer ser = (Serializer)tuple2._2();
        boolean bl = $this.warnUnexpectedNonAkkaSerializer(clazz, ser);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$1(Serialization $this, Serializer x$6) {
        return !$this.akka$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$6) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            int id2 = tuple2._1$mcI$sp();
            Serializer ser = (Serializer)tuple2._2();
            if (0 <= id2 && id2 < size$1) {
                table$1[id2] = ser;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError(tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Seq<SerializerDetails> seq;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<GenMap>(Predef$.MODULE$.Map().empty());
        Option option2 = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option2)) {
            seq = package$.MODULE$.Vector().empty();
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            SerializationSetup setting = (SerializationSetup)some.value();
            seq = setting.createSerializers().apply(system);
        } else {
            throw new MatchError(option2);
        }
        this.serializerDetails = seq.collect(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((A1 = A12).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
                    object = SerializerDetails$.MODULE$.apply(A1.alias(), new DisabledJavaSerializer(this.$outer.system()), A1.useFor());
                } else {
                    object = A12;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SerializerDetails x1) {
                SerializerDetails serializerDetails;
                SerializerDetails serializerDetails2 = x1;
                boolean bl = serializerDetails2 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((serializerDetails = serializerDetails2).serializer()) ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map fromConfig = this.settings().Serializers().withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x$3 -> {
            String string2;
            String v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$3;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = (String)tuple2._2();
                    if (k == null) break block2;
                    string2 = k;
                    if (v != null) break block3;
                }
                throw new MatchError(tuple2);
            }
            String string3 = v;
            Tuple2<String, Serializer> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(string2), this.serializerOf(string3).get());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Map result2 = fromConfig.$plus$plus(this.serializerDetails().map((Function1<SerializerDetails, Tuple2> & Serializable & scala.Serializable)d -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(d.alias()), d.serializer()), Seq$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers(result2.iterator().map((Function1<Tuple2, Serializer> & Serializable & scala.Serializable)x0$1 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }));
        this.serializers = result2;
        scala.collection.immutable.Iterable fromConfig2 = this.settings().SerializationBindings().withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$bindings$2(this, x$4))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x$5 -> {
            String string2;
            String alias;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$5;
                    if (tuple2 == null) break block2;
                    String className = (String)tuple2._1();
                    alias = (String)tuple2._2();
                    if (className == null) break block2;
                    string2 = className;
                    if (alias != null) break block3;
                }
                throw new MatchError(tuple2);
            }
            String string3 = alias;
            Tuple2 tuple2 = new Tuple2(this.system().dynamicAccess().getClassFor(string2, ClassTag$.MODULE$.Any()).get(), this.serializers().apply(string3));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom());
        Seq fromSettings = this.serializerDetails().flatMap((Function1<SerializerDetails, Seq> & Serializable & scala.Serializable)detail -> detail.useFor().map((Function1<Class, Tuple2> & Serializable & scala.Serializable)clazz -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(clazz), detail.serializer()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq<Tuple2<Class<?>, Serializer>> result3 = this.sort(fromConfig2.$plus$plus(fromSettings, Iterable$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers(result3.iterator().map((Function1<Tuple2, Serializer> & Serializable & scala.Serializable)x0$2 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }));
        result3.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$bindings$7(this, x0$3)));
        this.bindings = result3;
        this.serializerMap = this.bindings().foldLeft(new ConcurrentHashMap(), (Function2<ConcurrentHashMap, Tuple2, ConcurrentHashMap> & Serializable & scala.Serializable)(x0$4, x1$1) -> {
            Tuple2 tuple2;
            ConcurrentHashMap map2;
            block3: {
                Tuple2<ConcurrentHashMap, Tuple2> tuple22;
                block2: {
                    tuple22 = new Tuple2<ConcurrentHashMap, Tuple2>((ConcurrentHashMap)x0$4, (Tuple2)x1$1);
                    if (tuple22 == null) break block2;
                    map2 = tuple22._1();
                    tuple2 = tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError(tuple22);
            }
            Class c = (Class)tuple2._1();
            Serializer s2 = (Serializer)tuple2._2();
            map2.put(c, s2);
            ConcurrentHashMap concurrentHashMap = map2;
            return concurrentHashMap;
        });
        this.serializerByIdentity = ((MapLike)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(NullSerializer$.MODULE$.identifier())), NullSerializer$.MODULE$)}))).$plus$plus(this.serializers().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Serializer v = (Serializer)tuple2._2();
            Tuple2<Integer, Serializer> tuple22 = new Tuple2<Integer, Serializer>(BoxesRunTime.boxToInteger(v.identifier()), v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()));
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$6 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$6);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("akka.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    scala.Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        @Override
        public String productPrefix() {
            return "Information";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.address();
                    break;
                }
                case 1: {
                    object = this.system();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
            }
            return object;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$(this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return ((TraversableOnce)package$JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2<String, String> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), v.toString());
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            Config config2;
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            Config defaultBindings = config.getConfig("akka.actor.serialization-bindings");
            if (config.getBoolean("akka.actor.enable-additional-serialization-bindings") || !config.getBoolean("akka.actor.allow-java-serialization") || config.hasPath("akka.remote.artery.enabled") && config.getBoolean("akka.remote.artery.enabled")) {
                Config bs = defaultBindings.withFallback(config.getConfig("akka.actor.additional-serialization-bindings"));
                String additionalWhenJavaOffKey = "akka.actor.java-serialization-disabled-additional-serialization-bindings";
                config2 = !config.getBoolean("akka.actor.allow-java-serialization") ? bs.withFallback(config.getConfig(additionalWhenJavaOffKey)) : bs;
            } else {
                config2 = defaultBindings;
            }
            Config bindings = config2;
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

