/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.annotation.InternalApi;
import akka.stream.ActorAttributes$Dispatcher$;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializerHelper$;
import akka.stream.Attributes;
import akka.stream.IOResult;
import akka.stream.MaterializationContext;
import akka.stream.SourceShape;
import akka.stream.actor.ActorPublisher$;
import akka.stream.impl.ErrorPublisher;
import akka.stream.impl.SourceModule;
import akka.stream.impl.io.InputStreamPublisher$;
import akka.util.ByteString;
import java.io.InputStream;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u000194QAC\u0006\u0003#MA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\to\u0001\u0011\t\u0011)A\u0005q!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011%\t\u0005A!A!\u0002\u0013\u0011U\tC\u0003G\u0001\u0011\u0005q\tC\u0003O\u0001\u0011\u0005s\nC\u0003a\u0001\u0011E\u0013\rC\u0003d\u0001\u0011\u0005CMA\tJ]B,Ho\u0015;sK\u0006l7k\\;sG\u0016T!\u0001D\u0007\u0002\u0005%|'B\u0001\b\u0010\u0003\u0011IW\u000e\u001d7\u000b\u0005A\t\u0012AB:ue\u0016\fWNC\u0001\u0013\u0003\u0011\t7n[1\u0014\u0005\u0001!\u0002\u0003B\u000b\u00171yi\u0011!D\u0005\u0003/5\u0011AbU8ve\u000e,Wj\u001c3vY\u0016\u0004\"!\u0007\u000f\u000e\u0003iQ!aG\t\u0002\tU$\u0018\u000e\\\u0005\u0003;i\u0011!BQ=uKN#(/\u001b8h!\ryBEJ\u0007\u0002A)\u0011\u0011EI\u0001\u000bG>t7-\u001e:sK:$(\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0002#A\u0002$viV\u0014X\r\u0005\u0002(Q5\tq\"\u0003\u0002*\u001f\tA\u0011j\u0014*fgVdG/A\tde\u0016\fG/Z%oaV$8\u000b\u001e:fC6\u001c\u0001\u0001E\u0002.]Aj\u0011AI\u0005\u0003_\t\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005E*T\"\u0001\u001a\u000b\u00051\u0019$\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mI\u00121\"\u00138qkR\u001cFO]3b[\u0006I1\r[;oWNK'0\u001a\t\u0003[eJ!A\u000f\u0012\u0003\u0007%sG/\u0001\u0006biR\u0014\u0018NY;uKN,\u0012!\u0010\t\u0003OyJ!aP\b\u0003\u0015\u0005#HO]5ckR,7/A\u0006biR\u0014\u0018NY;uKN\u0004\u0013!B:iCB,\u0007cA\u0014D1%\u0011Ai\u0004\u0002\f'>,(oY3TQ\u0006\u0004X-\u0003\u0002B-\u00051A(\u001b8jiz\"R\u0001\u0013&L\u00196\u0003\"!\u0013\u0001\u000e\u0003-AQA\u000b\u0004A\u00021BQa\u000e\u0004A\u0002aBQa\u000f\u0004A\u0002uBQ!\u0011\u0004A\u0002\t\u000baa\u0019:fCR,GC\u0001)\\!\u0011i\u0013k\u0015\u0010\n\u0005I\u0013#A\u0002+va2,'\u0007E\u0002U3bi\u0011!\u0016\u0006\u0003-^\u000bqB]3bGRLg/Z:ue\u0016\fWn\u001d\u0006\u00021\u0006\u0019qN]4\n\u0005i+&!\u0003)vE2L7\u000f[3s\u0011\u0015av\u00011\u0001^\u0003\u001d\u0019wN\u001c;fqR\u0004\"a\n0\n\u0005}{!AF'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u00179,w/\u00138ti\u0006t7-\u001a\u000b\u0003)\tDQ!\u0011\u0005A\u0002\t\u000bab^5uQ\u0006#HO]5ckR,7\u000f\u0006\u0002\u0015K\")a-\u0003a\u0001{\u0005!\u0011\r\u001e;sQ\t\u0001\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002l#\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00055T'aC%oi\u0016\u0014h.\u00197Ba&\u0004")
@InternalApi
public final class InputStreamSource
extends SourceModule<ByteString, Future<IOResult>> {
    private final Function0<InputStream> createInputStream;
    private final int chunkSize;
    private final Attributes attributes;

    @Override
    public Attributes attributes() {
        return this.attributes;
    }

    @Override
    public Tuple2<Publisher<ByteString>, Future<IOResult>> create(MaterializationContext context) {
        Publisher<Nothing$> publisher;
        ActorMaterializer materializer = ActorMaterializerHelper$.MODULE$.downcast(context.materializer());
        Promise<IOResult> ioResultPromise = Promise$.MODULE$.apply();
        try {
            InputStream is = this.createInputStream.apply();
            Props props = InputStreamPublisher$.MODULE$.props(is, ioResultPromise, this.chunkSize).withDispatcher(ActorAttributes$Dispatcher$.MODULE$.resolve(context));
            ActorRef ref = materializer.actorOf(context, props);
            publisher = ActorPublisher$.MODULE$.apply(ref);
        }
        catch (Exception ex) {
            ioResultPromise.failure(ex);
            publisher = new ErrorPublisher(ex, this.attributes().nameOrDefault("inputStreamSource"));
        }
        ErrorPublisher pub = publisher;
        return new Tuple2<Publisher<ByteString>, Future<IOResult>>(pub, ioResultPromise.future());
    }

    @Override
    public SourceModule<ByteString, Future<IOResult>> newInstance(SourceShape<ByteString> shape) {
        return new InputStreamSource(this.createInputStream, this.chunkSize, this.attributes(), shape);
    }

    @Override
    public SourceModule<ByteString, Future<IOResult>> withAttributes(Attributes attr) {
        return new InputStreamSource(this.createInputStream, this.chunkSize, attr, this.amendShape(attr));
    }

    public InputStreamSource(Function0<InputStream> createInputStream, int chunkSize, Attributes attributes, SourceShape<ByteString> shape) {
        this.createInputStream = createInputStream;
        this.chunkSize = chunkSize;
        this.attributes = attributes;
        super(shape);
    }
}

