/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.util.HashCode$;
import akka.util.ManifestInfo$;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-u!\u0002\u0015*\u0011\u0003qc!\u0002\u0019*\u0011\u0003\t\u0004BB%\u0002\t\u0003\ti\u0005C\u0005\u0002P\u0005\u0011\r\u0011\"\u0003\u0002R!9\u00111K\u0001!\u0002\u0013I\b\"CA+\u0003\t\u0007I\u0011BA)\u0011\u001d\t9&\u0001Q\u0001\neD\u0011\"!\u0017\u0002\u0005\u0004%I!!\u0015\t\u000f\u0005m\u0013\u0001)A\u0005s\"I\u0011QL\u0001C\u0002\u0013%\u0011\u0011\u000b\u0005\b\u0003?\n\u0001\u0015!\u0003z\u0011%\t\t'\u0001b\u0001\n\u0013\t\t\u0006C\u0004\u0002d\u0005\u0001\u000b\u0011B=\t\u0013\u0005\u0015\u0014A1A\u0005\n\u0005E\u0003bBA4\u0003\u0001\u0006I!\u001f\u0005\n\u0003S\n!\u0019!C\u0005\u0003WB\u0001\"a\u001d\u0002A\u0003%\u0011Q\u000e\u0005\b\u0003k\nA\u0011IA<\u0011\u001d\t\t)\u0001C!\u0003\u0007Cq!!\"\u0002\t\u0003\n9I\u0002\u0003_\u0003\ty\u0006\u0002\u00036\u0015\u0005\u000b\u0007I\u0011A6\t\u00111$\"\u0011!Q\u0001\neCQ!\u0013\u000b\u0005\u00025D!b\u001c\u000b\u0011\u0002\u0003\r\t\u0015!\u0003q\u0011\u001dYHC1A\u0005\nqDa! \u000b!\u0002\u0013\u0019\bb\u0002@\u0015\u0005\u0004%Ia\u001b\u0005\u0007\u007fR\u0001\u000b\u0011B-\t\u000f\u0005\u0005A\u0003\"\u0011\u0002\u0004!9\u0011\u0011\u0002\u000b\u0005B\u0005-\u0001bBA\u000f)\u0011\u0005\u0013q\u0004\u0005\b\u0003C!B\u0011IA\u0012\r\u0011\u0001\u0014FA \t\u0011\r\u000b#Q1A\u0005\u0002\u0011C\u0001\u0002S\u0011\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0013\u0006\"\tA\u0013\u0005\b\u0019\u0006\u0012\r\u0011\"\u0001N\u0011\u001d\t)#\tQ\u0001\n9Cq!a\n\"\t\u0003\tI#\u0001\u0007NC:Lg-Z:u\u0013:4wN\u0003\u0002+W\u0005!Q\u000f^5m\u0015\u0005a\u0013\u0001B1lW\u0006\u001c\u0001\u0001\u0005\u00020\u00035\t\u0011F\u0001\u0007NC:Lg-Z:u\u0013:4wnE\u0003\u0002ea\n9\u0005\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VM\u001a\t\u0004sqrT\"\u0001\u001e\u000b\u0005mZ\u0013!B1di>\u0014\u0018BA\u001f;\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\u0005=\n3cA\u00113\u0001B\u0011\u0011(Q\u0005\u0003\u0005j\u0012\u0011\"\u0012=uK:\u001c\u0018n\u001c8\u0002\rML8\u000f^3n+\u0005)\u0005CA\u001dG\u0013\t9%HA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\rqJg.\u001b;?)\tq4\nC\u0003DI\u0001\u0007Q)\u0001\u0005wKJ\u001c\u0018n\u001c8t+\u0005q\u0005\u0003B(W3rs!\u0001\u0015+\u0011\u0005E#T\"\u0001*\u000b\u0005Mk\u0013A\u0002\u001fs_>$h(\u0003\u0002Vi\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\u00075\u000b\u0007O\u0003\u0002ViA\u0011qJW\u0005\u00037b\u0013aa\u0015;sS:<\u0007CA/\u0015\u001d\ty\u0003AA\u0004WKJ\u001c\u0018n\u001c8\u0014\u0007Q\u0011\u0004\rE\u0002bM\"l\u0011A\u0019\u0006\u0003G\u0012\fA\u0001\\1oO*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005)\u0019u.\u001c9be\u0006\u0014G.\u001a\t\u0003SRi\u0011!A\u0001\bm\u0016\u00148/[8o+\u0005I\u0016\u0001\u0003<feNLwN\u001c\u0011\u0015\u0005!t\u0007\"\u00026\u0018\u0001\u0004I\u0016a\u0001=%cA!1']:z\u0013\t\u0011HG\u0001\u0004UkBdWM\r\t\u0004gQ4\u0018BA;5\u0005\u0015\t%O]1z!\t\u0019t/\u0003\u0002yi\t\u0019\u0011J\u001c;\u0011\u0005\u0005T\u0018BA.c\u0003\u001dqW/\u001c2feN,\u0012a]\u0001\t]Vl'-\u001a:tA\u0005!!/Z:u\u0003\u0015\u0011Xm\u001d;!\u0003%\u0019w.\u001c9be\u0016$v\u000eF\u0002w\u0003\u000bAa!a\u0002\u001e\u0001\u0004A\u0017!B8uQ\u0016\u0014\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\u000e\u0005M\u0001cA\u001a\u0002\u0010%\u0019\u0011\u0011\u0003\u001b\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0003\u0010A\u0002\u0005]\u0011!A8\u0011\u0007M\nI\"C\u0002\u0002\u001cQ\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#\u0001<\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!W\u0001\nm\u0016\u00148/[8og\u0002\n\u0001c\u00195fG.\u001c\u0016-\\3WKJ\u001c\u0018n\u001c8\u0015\u0011\u00055\u00111FA\u0018\u0003\u0007Ba!!\f(\u0001\u0004I\u0016a\u00039s_\u0012,8\r\u001e(b[\u0016Dq!!\r(\u0001\u0004\t\u0019$\u0001\u0007eKB,g\u000eZ3oG&,7\u000fE\u0003\u00026\u0005}\u0012,\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003%IW.\\;uC\ndWMC\u0002\u0002>Q\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t%a\u000e\u0003\u0007M+\u0017\u000fC\u0004\u0002F\u001d\u0002\r!!\u0004\u0002\u00151|wmV1s]&tw\rE\u0002:\u0003\u0013J1!a\u0013;\u0005M)\u0005\u0010^3og&|g.\u00133Qe>4\u0018\u000eZ3s)\u0005q\u0013!C%na2$\u0016\u000e\u001e7f+\u0005I\u0018AC%na2$\u0016\u000e\u001e7fA\u0005Y\u0011*\u001c9m-\u0016\u00148/[8o\u00031IU\u000e\u001d7WKJ\u001c\u0018n\u001c8!\u0003)IU\u000e\u001d7WK:$wN]\u0001\f\u00136\u0004HNV3oI>\u0014\b%\u0001\u0006Ck:$G.\u001a(b[\u0016\f1BQ;oI2,g*Y7fA\u0005i!)\u001e8eY\u00164VM]:j_:\faBQ;oI2,g+\u001a:tS>t\u0007%\u0001\u0007Ck:$G.\u001a,f]\u0012|'/A\u0007Ck:$G.\u001a,f]\u0012|'\u000fI\u0001\rW:|wO\u001c,f]\u0012|'o]\u000b\u0003\u0003[\u0002R!!\u000e\u0002peLA!!\u001d\u00028\t\u00191+\u001a;\u0002\u001b-twn\u001e8WK:$wN]:!\u0003\r9W\r\u001e\u000b\u0004}\u0005e\u0004BB\"\u0012\u0001\u0004\tY\bE\u0002:\u0003{J1!a ;\u0005-\t5\r^8s'f\u001cH/Z7\u0002\r1|wn[;q)\u0005i\u0016aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007y\nI\tC\u0003D'\u0001\u0007Q\t")
public final class ManifestInfo
implements Extension {
    private final ExtendedActorSystem system;
    private final Map<String, Version> versions;

    public static ManifestInfo createExtension(ExtendedActorSystem extendedActorSystem) {
        return ManifestInfo$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ManifestInfo$ lookup() {
        return ManifestInfo$.MODULE$.lookup();
    }

    public static ManifestInfo get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.apply(actorSystem);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Map<String, Version> versions() {
        return this.versions;
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning) {
        boolean bl;
        Map filteredVersions = this.versions().filterKeys(dependencies.toSet());
        Set values = filteredVersions.values().toSet();
        if (values.size() > 1) {
            if (logWarning) {
                String conflictingVersions = values.mkString(", ");
                String fullInfo = ((TraversableOnce)filteredVersions.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String k = (String)tuple2._1();
                    Version v = (Version)tuple2._2();
                    String string2 = new StringBuilder(1).append(k).append(":").append(v).toString();
                    return string2;
                }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
                Version highestVersion = (Version)values.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning(new StringBuilder(279).append("Detected possible incompatible versions on the classpath. ").append(new StringBuilder(74).append("Please note that a given ").append(productName).append(" version MUST be the same across all modules of ").append(productName).append(" ").toString()).append("that you are using, e.g. if you use [{}] all other modules that are released together MUST be of the ").append("same version. Make sure you're using a compatible set of libraries. ").append("Possibly conflicting versions [{}] in libraries [{}]").toString(), highestVersion, conflictingVersions, fullInfo);
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final void liftedTree2$1(ObjectRef manifests$1) {
        try {
            Enumeration<URL> resources = this.system().dynamicAccess().classLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try (InputStream ios = resources.nextElement().openStream();){
                    Manifest manifest = new Manifest(ios);
                    Attributes attributes = manifest.getMainAttributes();
                    String string2 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplTitle()));
                    String string3 = string2 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleName())) : string2;
                    String title = string3;
                    String string4 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplVersion()));
                    String string5 = string4 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleVersion())) : string4;
                    String version = string5;
                    String string6 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplVendor()));
                    String string7 = string6 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleVendor())) : string6;
                    String vendor = string7;
                    if (title == null || version == null || vendor == null || !ManifestInfo$.MODULE$.akka$util$ManifestInfo$$knownVendors().apply(vendor)) continue;
                    manifests$1.elem = ((Map)manifests$1.elem).updated(title, new Version(version));
                }
            }
        }
        catch (IOException ioe) {
            Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning("Could not read manifest information. {}", ioe);
        }
    }

    public ManifestInfo(ExtendedActorSystem system) {
        this.system = system;
        ObjectRef<GenMap> manifests = ObjectRef.create(Predef$.MODULE$.Map().empty());
        this.liftedTree2$1(manifests);
        this.versions = (Map)manifests.elem;
    }

    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final /* synthetic */ Tuple2 x$1;
        private final int[] numbers;
        private final String rest;

        public String version() {
            return this.version;
        }

        private int[] numbers() {
            return this.numbers;
        }

        private String rest() {
            return this.rest;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Version other) {
            void var2_2;
            block0: {
                int diff = 0;
                diff = this.numbers()[0] - other.numbers()[0];
                if (diff != 0 || (diff = this.numbers()[1] - other.numbers()[1]) != 0 || (diff = this.numbers()[2] - other.numbers()[2]) != 0) break block0;
                diff = this.rest().compareTo(other.rest());
            }
            return (int)var2_2;
        }

        public boolean equals(Object o) {
            Version version;
            Object object = o;
            boolean bl = object instanceof Version ? this.compareTo(version = (Version)object) == 0 : false;
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result2 = HashCode$.MODULE$.SEED();
            result2 = HashCode$.MODULE$.hash(result2, this.numbers()[0]);
            result2 = HashCode$.MODULE$.hash(result2, this.numbers()[1]);
            result2 = HashCode$.MODULE$.hash(result2, this.numbers()[2]);
            result2 = HashCode$.MODULE$.hash(result2, this.rest());
            return (int)var1_1;
        }

        public String toString() {
            return this.version();
        }

        private static final void liftedTree1$1(int[] numbers$1, IntRef numbersPos$1, String[] segments$1, IntRef segmentPos$1) {
            try {
                numbers$1[numbersPos$1.elem] = new StringOps(Predef$.MODULE$.augmentString(segments$1[segmentPos$1.elem])).toInt();
                ++segmentPos$1.elem;
            }
            catch (NumberFormatException numberFormatException) {
                numbers$1[numbersPos$1.elem] = Integer.MAX_VALUE;
            }
        }

        public Version(String version) {
            int[] nArray;
            String rest;
            block6: {
                Tuple2<int[], String> tuple2;
                block5: {
                    this.version = version;
                    int[] numbers = new int[3];
                    String[] segments = version.split("[.-]");
                    IntRef segmentPos = IntRef.create(0);
                    IntRef numbersPos = IntRef.create(0);
                    while (numbersPos.elem < 3) {
                        if (segmentPos.elem < segments.length) {
                            Version.liftedTree1$1(numbers, numbersPos, segments, segmentPos);
                        }
                        ++numbersPos.elem;
                    }
                    String rest2 = segmentPos.elem >= segments.length ? "" : String.join((CharSequence)"-", Arrays.asList(Arrays.copyOfRange((Object[])segments, segmentPos.elem, segments.length)));
                    tuple2 = new Tuple2<int[], String>(numbers, rest2);
                    if (tuple2 == null) break block5;
                    int[] numbers2 = tuple2._1();
                    rest = tuple2._2();
                    if (numbers2 == null) break block5;
                    nArray = numbers2;
                    if (rest != null) break block6;
                }
                throw new MatchError(tuple2);
            }
            String string2 = rest;
            Tuple2<int[], String> tuple2 = new Tuple2<int[], String>(nArray, string2);
            this.x$1 = tuple2;
            this.numbers = (int[])this.x$1._1();
            this.rest = (String)this.x$1._2();
        }
    }
}

