/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

public final class HexCodec {
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static long lowerHexToUnsignedLong(String lowerHex) {
        int length = lowerHex.length();
        if (length < 1 || length > 32) {
            throw HexCodec.isntLowerHexLong(lowerHex);
        }
        int beginIndex = length > 16 ? length - 16 : 0;
        return HexCodec.lowerHexToUnsignedLong(lowerHex, beginIndex);
    }

    public static long lowerHexToUnsignedLong(String lowerHex, int index) {
        long result2 = 0L;
        int endIndex = Math.min(index + 16, lowerHex.length());
        while (index < endIndex) {
            char c = lowerHex.charAt(index);
            result2 <<= 4;
            if (c >= '0' && c <= '9') {
                result2 |= (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                result2 |= (long)(c - 97 + 10);
            } else {
                throw HexCodec.isntLowerHexLong(lowerHex);
            }
            ++index;
        }
        return result2;
    }

    static NumberFormatException isntLowerHexLong(String lowerHex) {
        throw new NumberFormatException(lowerHex + " should be a 1 to 32 character lower-hex string with no prefix");
    }

    public static String toLowerHex(long high, long low) {
        char[] result2 = new char[high != 0L ? 32 : 16];
        int pos = 0;
        if (high != 0L) {
            HexCodec.writeHexLong(result2, pos, high);
            pos += 16;
        }
        HexCodec.writeHexLong(result2, pos, low);
        return new String(result2);
    }

    public static String toLowerHex(long v) {
        char[] data = new char[16];
        HexCodec.writeHexLong(data, 0, v);
        return new String(data);
    }

    public static void writeHexLong(char[] data, int pos, long v) {
        HexCodec.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    static void writeHexByte(char[] data, int pos, byte b) {
        data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
        data[pos + 1] = HEX_DIGITS[b & 0xF];
    }

    HexCodec() {
    }
}

