/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.Clock;
import brave.Tracer;
import brave.internal.AutoValue_Platform_Jre6;
import brave.internal.AutoValue_Platform_Jre7;
import com.google.auto.value.AutoValue;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.animal_sniffer.IgnoreJRERequirement;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.reporter.Reporter;

public abstract class Platform
implements Clock,
Reporter<Span> {
    static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static final Platform PLATFORM = Platform.findPlatform();
    final long createTimestamp = System.currentTimeMillis() * 1000L;
    final long createTick = System.nanoTime();
    volatile Endpoint localEndpoint;

    Platform() {
    }

    @Override
    public void report(Span span) {
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        if (span == null) {
            throw new NullPointerException("span == null");
        }
        logger.info(span.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint localEndpoint() {
        if (this.localEndpoint == null) {
            Platform platform2 = this;
            synchronized (platform2) {
                if (this.localEndpoint == null) {
                    this.localEndpoint = this.produceLocalEndpoint();
                }
            }
        }
        return this.localEndpoint;
    }

    Endpoint produceLocalEndpoint() {
        Endpoint.Builder builder;
        block6: {
            builder = Endpoint.builder().serviceName("unknown");
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                if (nics == null) {
                    return builder.build();
                }
                block2: while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!address.isSiteLocalAddress()) continue;
                        byte[] addressBytes = address.getAddress();
                        if (addressBytes.length == 4) {
                            builder.ipv4(ByteBuffer.wrap(addressBytes).getInt());
                            continue block2;
                        }
                        if (addressBytes.length != 16) continue block2;
                        builder.ipv6(addressBytes);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!logger.isLoggable(Level.FINE)) break block6;
                logger.log(Level.FINE, "error reading nics", e);
            }
        }
        return builder.build();
    }

    public static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        Jre7 jre7 = Jre7.buildIfSupported();
        if (jre7 != null) {
            return jre7;
        }
        return Jre6.build();
    }

    public abstract long randomLong();

    @Override
    public long currentTimeMicroseconds() {
        return (System.nanoTime() - this.createTick) / 1000L + this.createTimestamp;
    }

    @AutoValue
    static abstract class Jre6
    extends Platform {
        Jre6() {
        }

        abstract Random prng();

        static Jre6 build() {
            return new AutoValue_Platform_Jre6(new Random(System.nanoTime()));
        }

        @Override
        public long randomLong() {
            return this.prng().nextLong();
        }
    }

    @AutoValue
    static abstract class Jre7
    extends Platform {
        Jre7() {
        }

        static Jre7 buildIfSupported() {
            try {
                Class.forName("java.util.concurrent.ThreadLocalRandom");
                return new AutoValue_Platform_Jre7();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        @Override
        @IgnoreJRERequirement
        public long randomLong() {
            return ThreadLocalRandom.current().nextLong();
        }
    }
}

