/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Clock;
import brave.Span;
import brave.internal.recorder.MutableSpan;
import brave.internal.recorder.MutableSpanMap;
import brave.internal.zipkin.V2SpanConverter;
import brave.propagation.TraceContext;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.reporter.Reporter;

public final class Recorder {
    final MutableSpanMap spanMap;
    final Reporter<Span> reporter;
    final AtomicBoolean noop;

    public Recorder(Endpoint localEndpoint, Clock clock, Reporter<Span> reporter, AtomicBoolean noop) {
        this.spanMap = new MutableSpanMap(localEndpoint, clock, reporter, noop);
        this.reporter = reporter;
        this.noop = noop;
    }

    @Nullable
    public Long timestamp(TraceContext context) {
        MutableSpan span = this.spanMap.get(context);
        if (span == null) {
            return null;
        }
        return span.timestamp == 0L ? null : Long.valueOf(span.timestamp);
    }

    public void start(TraceContext context, long timestamp) {
        this.spanMap.getOrCreate(context).start(timestamp);
    }

    public void name(TraceContext context, String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.spanMap.getOrCreate(context).name(name);
    }

    public void kind(TraceContext context, Span.Kind kind) {
        if (kind == null) {
            throw new NullPointerException("kind == null");
        }
        this.spanMap.getOrCreate(context).kind(kind);
    }

    public void annotate(TraceContext context, long timestamp, String value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        this.spanMap.getOrCreate(context).annotate(timestamp, value);
    }

    public void tag(TraceContext context, String key, String value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key is empty");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        this.spanMap.getOrCreate(context).tag(key, value);
    }

    public void remoteEndpoint(TraceContext context, Endpoint remoteEndpoint) {
        if (remoteEndpoint == null) {
            throw new NullPointerException("remoteEndpoint == null");
        }
        this.spanMap.getOrCreate(context).remoteEndpoint(remoteEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(TraceContext context, long finishTimestamp) {
        MutableSpan span = this.spanMap.remove(context);
        if (span == null || this.noop.get()) {
            return;
        }
        MutableSpan mutableSpan = span;
        synchronized (mutableSpan) {
            span.finish(finishTimestamp);
            this.reporter.report(V2SpanConverter.toSpan(span.toSpan()));
        }
    }

    public void abandon(TraceContext context) {
        this.spanMap.remove(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(TraceContext context) {
        MutableSpan span = this.spanMap.remove(context);
        if (span == null || this.noop.get()) {
            return;
        }
        MutableSpan mutableSpan = span;
        synchronized (mutableSpan) {
            span.finish(null);
            this.reporter.report(V2SpanConverter.toSpan(span.toSpan()));
        }
    }
}

