/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.zipkin;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class Util {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    static final char[] URL_MAP = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static int envOr(String key, int fallback) {
        return System.getenv(key) != null ? Integer.parseInt(System.getenv(key)) : fallback;
    }

    public static String envOr(String key, String fallback) {
        return System.getenv(key) != null ? System.getenv(key) : fallback;
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
        return reference;
    }

    public static <T extends Comparable<? super T>> List<T> sortedList(@Nullable Collection<T> in) {
        if (in == null || in.isEmpty()) {
            return Collections.emptyList();
        }
        if (in.size() == 1) {
            return Collections.singletonList((Comparable)in.iterator().next());
        }
        Object[] array = in.toArray();
        Arrays.sort(array);
        List<Object> result2 = Arrays.asList(array);
        return Collections.unmodifiableList(result2);
    }

    public static long midnightUTC(long epochMillis) {
        Calendar day = Calendar.getInstance(UTC);
        day.setTimeInMillis(epochMillis);
        day.set(14, 0);
        day.set(13, 0);
        day.set(12, 0);
        day.set(11, 0);
        return day.getTimeInMillis();
    }

    public static List<Date> getDays(long endTs, @Nullable Long lookback) {
        long to = Util.midnightUTC(endTs);
        long startMillis = endTs - (lookback != null ? lookback : endTs);
        long from = startMillis <= 0L ? 0L : Util.midnightUTC(startMillis);
        ArrayList<Date> days = new ArrayList<Date>();
        for (long time2 = from; time2 <= to; time2 += TimeUnit.DAYS.toMillis(1L)) {
            days.add(new Date(time2));
        }
        return days;
    }

    public static long lowerHexToUnsignedLong(String lowerHex) {
        int length = lowerHex.length();
        if (length < 1 || length > 32) {
            throw Util.isntLowerHexLong(lowerHex);
        }
        int beginIndex = length > 16 ? length - 16 : 0;
        return Util.lowerHexToUnsignedLong(lowerHex, beginIndex);
    }

    public static long lowerHexToUnsignedLong(String lowerHex, int index) {
        long result2 = 0L;
        int endIndex = Math.min(index + 16, lowerHex.length());
        while (index < endIndex) {
            char c = lowerHex.charAt(index);
            result2 <<= 4;
            if (c >= '0' && c <= '9') {
                result2 |= (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                result2 |= (long)(c - 97 + 10);
            } else {
                throw Util.isntLowerHexLong(lowerHex);
            }
            ++index;
        }
        return result2;
    }

    static NumberFormatException isntLowerHexLong(String lowerHex) {
        throw new NumberFormatException(lowerHex + " should be a 1 to 32 character lower-hex string with no prefix");
    }

    public static String toLowerHex(long high, long low) {
        char[] result2 = new char[high != 0L ? 32 : 16];
        int pos = 0;
        if (high != 0L) {
            Util.writeHexLong(result2, pos, high);
            pos += 16;
        }
        Util.writeHexLong(result2, pos, low);
        return new String(result2);
    }

    public static String toLowerHex(long v) {
        char[] data = new char[16];
        Util.writeHexLong(data, 0, v);
        return new String(data);
    }

    static String writeBase64Url(byte[] in) {
        char[] result2 = new char[(in.length + 2) / 3 * 4];
        int end = in.length - in.length % 3;
        int pos = 0;
        for (int i = 0; i < end; i += 3) {
            result2[pos++] = URL_MAP[(in[i] & 0xFF) >> 2];
            result2[pos++] = URL_MAP[(in[i] & 3) << 4 | (in[i + 1] & 0xFF) >> 4];
            result2[pos++] = URL_MAP[(in[i + 1] & 0xF) << 2 | (in[i + 2] & 0xFF) >> 6];
            result2[pos++] = URL_MAP[in[i + 2] & 0x3F];
        }
        switch (in.length % 3) {
            case 1: {
                result2[pos++] = URL_MAP[(in[end] & 0xFF) >> 2];
                result2[pos++] = URL_MAP[(in[end] & 3) << 4];
                result2[pos++] = 61;
                result2[pos] = 61;
                break;
            }
            case 2: {
                result2[pos++] = URL_MAP[(in[end] & 0xFF) >> 2];
                result2[pos++] = URL_MAP[(in[end] & 3) << 4 | (in[end + 1] & 0xFF) >> 4];
                result2[pos++] = URL_MAP[(in[end + 1] & 0xF) << 2];
                result2[pos] = 61;
            }
        }
        return new String(result2);
    }

    public static void writeHexLong(char[] data, int pos, long v) {
        Util.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
        Util.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
        Util.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
        Util.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
        Util.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
        Util.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
        Util.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
        Util.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    public static void propagateIfFatal(Throwable t) {
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }

    static void writeHexByte(char[] data, int pos, byte b) {
        data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
        data[pos + 1] = HEX_DIGITS[b & 0xF];
    }

    static AssertionError assertionError(String message, Throwable cause) {
        AssertionError error = new AssertionError((Object)message);
        ((Throwable)((Object)error)).initCause(cause);
        throw error;
    }

    private Util() {
    }
}

